/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.fatal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.rssowl.core.persist.service.ProfileLockedException;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.CustomWizardDialog;
import org.rssowl.ui.internal.dialogs.fatal.Messages;
import org.rssowl.ui.internal.util.BrowserUtils;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ErrorInfoPage
extends WizardPage {
    private final IStatus fErrorStatus;
    private Menu fCopyMenu;
    private final boolean fHasNextPage;

    ErrorInfoPage(String pageName, IStatus errorStatus, boolean hasNextPage) {
        super(pageName, pageName, null);
        this.fErrorStatus = errorStatus;
        this.fHasNextPage = hasNextPage;
    }

    public void createControl(Composite parent) {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/wizban/welcome_wiz.gif"));
        this.setMessage(Messages.ErrorInfoPage_RSSOWL_CRASH, 2);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 5));
        if (!this.fHasNextPage) {
            ((GridLayout)container.getLayout()).marginBottom = 5;
        }
        Label errorDetailsLabel = new Label(container, 0);
        errorDetailsLabel.setText(Messages.ErrorInfoPage_ERROR_DETAILS);
        errorDetailsLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        errorDetailsLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        String msg = null;
        msg = this.fErrorStatus.getException() instanceof OutOfMemoryError ? (StringUtils.isSet((String)this.fErrorStatus.getMessage()) ? NLS.bind((String)Messages.ErrorInfoPage_OOM_ERROR_N, (Object)this.fErrorStatus.getMessage()) : Messages.ErrorInfoPage_OOM_ERROR) : (this.fErrorStatus.getException() instanceof ProfileLockedException ? (StringUtils.isSet((String)this.fErrorStatus.getMessage()) ? NLS.bind((String)Messages.ErrorInfoPage_LOCKED_ERROR_N, (Object)this.fErrorStatus.getMessage()) : Messages.ErrorInfoPage_LOCKED_ERROR) : (StringUtils.isSet((String)this.fErrorStatus.getMessage()) ? NLS.bind((String)Messages.ErrorInfoPage_STARTUP_ERROR_N, (Object)this.fErrorStatus.getMessage()) : Messages.ErrorInfoPage_STARTUP_ERROR));
        final Label errorDetailsTextLabel = new Label(container, 64);
        errorDetailsTextLabel.setText(msg);
        errorDetailsTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)errorDetailsTextLabel.getLayoutData()).widthHint = 200;
        this.fCopyMenu = new Menu((Decorations)errorDetailsTextLabel.getShell(), 8);
        MenuItem copyItem = new MenuItem(this.fCopyMenu, 8);
        copyItem.setText(Messages.ErrorInfoPage_COPY);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OwlUI.getClipboard(ErrorInfoPage.this.fCopyMenu.getDisplay()).setContents(new Object[]{errorDetailsTextLabel.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        errorDetailsTextLabel.setMenu(this.fCopyMenu);
        if (!(this.fErrorStatus.getException() instanceof ProfileLockedException) && !(this.fErrorStatus.getException() instanceof OutOfMemoryError)) {
            Label crashReportLabel = new Label(container, 0);
            crashReportLabel.setText(Messages.ErrorInfoPage_LET_US_KNOW);
            crashReportLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
            crashReportLabel.setLayoutData((Object)new GridData(4, 1, true, false));
            ((GridData)crashReportLabel.getLayoutData()).verticalIndent = 10;
            Link crashReportTextLabel = new Link(container, 64);
            crashReportTextLabel.setText(Messages.ErrorInfoPage_SEND_LOGS_ADVISE);
            crashReportTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
            crashReportTextLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        if ("save".equals(e.text)) {
                            OwlUI.saveCrashReport(ErrorInfoPage.this.getShell());
                        } else {
                            BrowserUtils.sendErrorLog();
                        }
                    }
                    catch (Throwable t) {
                        ErrorInfoPage.this.setMessage(t.getMessage(), 3);
                    }
                }
            });
        }
        Label furtherStepsLabel = new Label(container, 0);
        furtherStepsLabel.setText(Messages.ErrorInfoPage_FURTHER_STEPS);
        furtherStepsLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        furtherStepsLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)furtherStepsLabel.getLayoutData()).verticalIndent = 10;
        Link moreInfoLabel = new Link(container, 64);
        if (this.fErrorStatus.getException() instanceof ProfileLockedException) {
            moreInfoLabel.setText(Messages.ErrorInfoPage_LOCKED_PROFILE_ADVISE);
        } else {
            moreInfoLabel.setText(this.fHasNextPage ? Messages.ErrorInfoPage_NEXT_PAGE_ADVISE : Messages.ErrorInfoPage_GENERAL_ERROR_ADVISE);
        }
        moreInfoLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)moreInfoLabel.getLayoutData()).widthHint = 200;
        moreInfoLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if ("faq".equals(e.text)) {
                        BrowserUtils.openFAQ(ErrorInfoPage.this.fErrorStatus);
                    } else if ("forum".equals(e.text)) {
                        BrowserUtils.openHelpForum(ErrorInfoPage.this.fErrorStatus);
                    }
                }
                catch (Throwable t) {
                    ErrorInfoPage.this.setMessage(t.getMessage(), 3);
                }
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Button focusButton = ((CustomWizardDialog)this.getContainer()).getButton(15);
            if (focusButton == null) {
                focusButton = ((CustomWizardDialog)this.getContainer()).getButton(16);
            }
            if (focusButton != null) {
                focusButton.setFocus();
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fCopyMenu != null && !this.fCopyMenu.isDisposed()) {
            this.fCopyMenu.dispose();
        }
    }
}

