/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.rssowl.core.INewsAction;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.filter.INewsActionPresentation;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.filter.NewsActionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsActionPresentationManager {
    private static final String NEWS_ACTION_EXTENSION_POINT = "org.rssowl.core.NewsAction";
    private static final String NEWS_ACTION_PRESENTATION_EXTENSION_POINT = "org.rssowl.ui.NewsActionPresentation";
    private static NewsActionPresentationManager fgInstance = new NewsActionPresentationManager();
    private Map<String, NewsActionDescriptor> fNewsActions = new HashMap<String, NewsActionDescriptor>();
    private Set<NewsActionDescriptor> fSortedNewsActions = new TreeSet<NewsActionDescriptor>();
    private Map<String, IConfigurationElement> fNewsActionPresentations = new HashMap<String, IConfigurationElement>();

    public static NewsActionPresentationManager getInstance() {
        return fgInstance;
    }

    private NewsActionPresentationManager() {
        this.loadNewsActions();
        this.loadNewsActionPresentations();
    }

    public INewsActionPresentation getPresentation(String actionId) {
        try {
            IConfigurationElement element = this.fNewsActionPresentations.get(actionId);
            if (element != null) {
                return (INewsActionPresentation)element.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return null;
    }

    public Collection<NewsActionDescriptor> getSortedNewsActions() {
        return this.fSortedNewsActions;
    }

    public NewsActionDescriptor getNewsActionDescriptor(String actionId) {
        return this.fNewsActions.get(actionId);
    }

    public boolean hasNewsAction(String actionId) {
        return this.fNewsActions.containsKey(actionId);
    }

    private void loadNewsActions() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(NEWS_ACTION_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String platform = element.getAttribute("platform");
                if (!StringUtils.isSet((String)platform) || SWT.getPlatform().equals(platform)) {
                    String id = element.getAttribute("id");
                    INewsAction newsAction = (INewsAction)element.createExecutableExtension("class");
                    String name = element.getAttribute("name");
                    String description = element.getAttribute("description");
                    String sortKey = element.getAttribute("sortKey");
                    String forcable = element.getAttribute("forcable");
                    NewsActionDescriptor filterAction = new NewsActionDescriptor(id, newsAction, name, description, sortKey, Boolean.parseBoolean(forcable));
                    this.fNewsActions.put(id, filterAction);
                    this.fSortedNewsActions.add(filterAction);
                }
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            ++n2;
        }
    }

    private void loadNewsActionPresentations() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(NEWS_ACTION_PRESENTATION_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String id = element.getAttribute("actionId");
                this.fNewsActionPresentations.put(id, element);
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            ++n2;
        }
    }
}

