/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.notifier;

import java.util.Date;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.RGB;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.actions.OpenNewsAction;
import org.rssowl.ui.internal.notifier.NotificationItem;

public class NewsNotificationItem
extends NotificationItem {
    private static final int MAX_DESCRIPTION_LENGTH = 500;
    private final String fNewsLink;
    private final FeedLinkReference fFeedReference;
    private final NewsReference fNewsReference;
    private final Date fRecentNewsDate;
    private boolean fIsNewsSticky;
    private boolean fIsNewsRead;
    private String fCachedDescriptionExcerpt;
    private String fCachedOrigin;
    private ImageDescriptor fImage;
    private RGB fColor;

    public NewsNotificationItem(INews news) {
        this(news, null);
    }

    public NewsNotificationItem(INews news, RGB color) {
        super(NewsNotificationItem.makeText(news), OwlUI.BOOKMARK);
        this.fNewsLink = CoreUtils.getLink((INews)news);
        this.fFeedReference = news.getFeedReference();
        this.fNewsReference = new NewsReference(news.getId().longValue());
        this.fRecentNewsDate = DateUtils.getRecentDate((INews)news);
        this.fIsNewsSticky = news.isFlagged();
        boolean bl = this.fIsNewsRead = INews.State.READ == news.getState();
        if (color != null) {
            this.fColor = color;
        } else {
            Set labels = CoreUtils.getSortedLabels((INews)news);
            if (!labels.isEmpty()) {
                this.fColor = OwlUI.getRGB((ILabel)labels.iterator().next());
            }
        }
    }

    private String extractDescriptionExcerpt(INews news) {
        if (news == null) {
            return null;
        }
        String description = news.getDescription();
        if (!StringUtils.isSet((String)description)) {
            return null;
        }
        String content = StringUtils.stripTags((String)description, (boolean)true);
        content = StringUtils.normalizeString((String)content);
        if ((content = StringUtils.smartTrim((String)content, (int)500)).contains("&")) {
            content = StringUtils.replaceAll((String)content, (String)"&", (String)"&&");
        }
        return content.length() > 0 ? content : null;
    }

    private static ImageDescriptor makeImage(FeedLinkReference feedReference) {
        ImageDescriptor favicon;
        IBookMark bookMark = CoreUtils.getBookMark((FeedLinkReference)feedReference);
        if (bookMark != null && (favicon = OwlUI.getFavicon(bookMark)) != null) {
            return favicon;
        }
        return OwlUI.BOOKMARK;
    }

    public ImageDescriptor getImage() {
        if (this.fImage == null) {
            this.fImage = NewsNotificationItem.makeImage(this.fFeedReference);
        }
        return this.fImage;
    }

    private static String makeText(INews news) {
        String headline = CoreUtils.getHeadline((INews)news, (boolean)true);
        if (headline.contains("&")) {
            headline = StringUtils.replaceAll((String)headline, (String)"&", (String)"&&");
        }
        return headline;
    }

    public String getDescription() {
        if (this.fCachedDescriptionExcerpt == null) {
            this.fCachedDescriptionExcerpt = this.extractDescriptionExcerpt(this.fNewsReference.resolve());
        }
        return this.fCachedDescriptionExcerpt;
    }

    public void setColor(RGB color) {
        this.fColor = color;
    }

    public RGB getColor() {
        return this.fColor;
    }

    public String getOrigin() {
        IBookMark bookMark;
        if (this.fCachedOrigin == null && (bookMark = CoreUtils.getBookMark((FeedLinkReference)this.fFeedReference)) != null) {
            this.fCachedOrigin = bookMark.getName();
        }
        return this.fCachedOrigin;
    }

    public void open(MouseEvent e) {
        if ((e.stateMask & SWT.MOD1) != 0) {
            new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)this.fNewsLink)).run();
        } else {
            INews news = this.fNewsReference.resolve();
            if (news != null) {
                OpenNewsAction action = new OpenNewsAction((IStructuredSelection)new StructuredSelection((Object)news));
                action.setRestoreWindow(true);
                action.setPreferActiveFeedView();
                action.run();
            }
        }
    }

    public boolean supportsSticky() {
        return true;
    }

    public boolean isSticky() {
        return this.fIsNewsSticky;
    }

    public void setSticky(boolean sticky) {
        this.fIsNewsSticky = sticky;
        INews news = this.fNewsReference.resolve();
        if (news != null && news.isVisible()) {
            news.setFlagged(sticky);
            DynamicDAO.save((IPersistable)news);
        }
    }

    public boolean supportsMarkRead() {
        return true;
    }

    public void setRead(boolean read) {
        this.fIsNewsRead = read;
        INews news = this.fNewsReference.resolve();
        if (news != null && news.isVisible()) {
            news.setState(read ? INews.State.READ : INews.State.NEW);
            DynamicDAO.save((IPersistable)news);
        }
    }

    public boolean isRead() {
        return this.fIsNewsRead;
    }

    public int compareTo(NotificationItem o) {
        if (o instanceof NewsNotificationItem) {
            if (this.equals(o)) {
                return 0;
            }
            Date date2 = ((NewsNotificationItem)o).fRecentNewsDate;
            Date date1 = this.fRecentNewsDate;
            int res = date2.compareTo(date1);
            return res != 0 ? res : -1;
        }
        return 1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fNewsReference == null ? 0 : this.fNewsReference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewsNotificationItem other = (NewsNotificationItem)obj;
        return !(this.fNewsReference == null ? other.fNewsReference != null : !this.fNewsReference.equals((Object)other.fNewsReference));
    }
}

