/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.search.Messages;
import org.rssowl.ui.internal.search.SearchConditionItem;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConditionList
extends ScrolledComposite {
    private List<SearchConditionItem> fItems = new ArrayList<SearchConditionItem>();
    private final List<Integer> fFieldsToExclude;
    private Composite fContainer;
    private LocalResourceManager fResources;
    private Image fAddIcon;
    private Image fAddDisabledIcon;
    private Image fDeleteIcon;
    private Image fDeleteDisabledIcon;
    private boolean fModified;
    private int fVisibleItemCount = 3;

    public SearchConditionList(Composite parent, int style, List<ISearchCondition> conditions) {
        this(parent, style, conditions, null);
    }

    public SearchConditionList(Composite parent, int style, List<ISearchCondition> conditions, List<Integer> fieldsToExclude) {
        super(parent, style | 0x200);
        this.fFieldsToExclude = fieldsToExclude;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        this.initResources();
        this.initComponents(conditions);
    }

    public void setVisibleItemCount(int count) {
        Assert.isLegal((count >= 0 ? 1 : 0) != 0);
        this.fVisibleItemCount = count;
    }

    public boolean isEmpty() {
        for (SearchConditionItem item : this.fItems) {
            if (!item.hasValue()) continue;
            return false;
        }
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point point = super.computeSize(wHint, hHint, changed);
        if (this.fVisibleItemCount > 0 && this.fItems.size() > 0) {
            int itemHeight = this.fItems.get((int)0).computeSize((int)wHint, (int)hHint).y + 4;
            point.y = this.fVisibleItemCount * itemHeight;
        }
        return point;
    }

    public void reset() {
        this.setRedraw(false);
        try {
            if (this.fItems.size() > 0) {
                ArrayList<SearchConditionItem> itemsToRemove = new ArrayList<SearchConditionItem>(this.fItems);
                for (SearchConditionItem itemToRemove : itemsToRemove) {
                    itemToRemove.getParent().dispose();
                    this.removeItem(itemToRemove);
                }
            }
            this.addItem(this.getDefaultCondition());
        }
        finally {
            this.setRedraw(true);
        }
        this.focusInput();
        this.fModified = true;
    }

    public void focusInput() {
        this.focusInput(0);
    }

    public void focusInput(int index) {
        if (this.fItems.size() > index) {
            this.fItems.get(index).focusInput();
        }
    }

    public List<ISearchCondition> createConditions() {
        return this.createConditions(null);
    }

    public List<ISearchCondition> createConditions(ISearchMark searchmark) {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>();
        for (SearchConditionItem item : this.fItems) {
            ISearchCondition condition = item.createCondition(searchmark, true);
            if (condition == null) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    public void showConditions(List<ISearchCondition> conditions) {
        this.fModified = true;
        this.setRedraw(false);
        try {
            ArrayList<SearchConditionItem> itemsToRemove = new ArrayList<SearchConditionItem>(this.fItems);
            for (SearchConditionItem itemToRemove : itemsToRemove) {
                itemToRemove.getParent().dispose();
                this.removeItem(itemToRemove);
            }
            if (conditions != null && !conditions.isEmpty()) {
                for (ISearchCondition condition : conditions) {
                    this.addItem(condition);
                }
            } else {
                this.addItem(this.getDefaultCondition());
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public boolean isModified() {
        if (this.fModified) {
            return true;
        }
        for (SearchConditionItem item : this.fItems) {
            if (!item.isModified()) continue;
            return true;
        }
        return false;
    }

    private void initResources() {
        this.fAddIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/add.gif");
        this.fAddDisabledIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/dtool16/add.gif");
        this.fDeleteIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/etool16/remove.gif");
        this.fDeleteDisabledIcon = OwlUI.getImage((ResourceManager)this.fResources, "icons/dtool16/remove.gif");
    }

    private void initComponents(List<ISearchCondition> conditions) {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setIncrement(10);
        }
        this.fContainer = new Composite((Composite)this, 0);
        this.fContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        this.fContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setContent((Control)this.fContainer);
        if (conditions != null && !conditions.isEmpty()) {
            for (ISearchCondition condition : conditions) {
                this.addItem(condition);
            }
        } else {
            this.addItem(this.getDefaultCondition());
        }
        this.updateSize();
    }

    private ISearchCondition getDefaultCondition() {
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(-1, INews.class.getName());
        ISearchCondition condition = factory.createSearchCondition(field, SearchSpecifier.CONTAINS_ALL, (Object)"");
        return condition;
    }

    SearchConditionItem addItem(ISearchCondition condition) {
        return this.addItem(condition, this.fItems.size());
    }

    SearchConditionItem addItem(ISearchCondition condition, int index) {
        return this.addItem(condition, index, false);
    }

    SearchConditionItem addItem(ISearchCondition condition, int index, boolean scroll) {
        boolean wasScrollbarShowing = this.getVerticalBar() != null ? this.getVerticalBar().isVisible() : false;
        final Composite itemContainer = new Composite(this.fContainer, 0);
        itemContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        itemContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        final SearchConditionItem item = new SearchConditionItem(itemContainer, 0, condition, this.fFieldsToExclude);
        item.setLayoutData(new GridData(4, 1, true, false));
        final ToolBar buttonBar = new ToolBar(itemContainer, 0x800000);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        ToolItem addButton = new ToolItem(buttonBar, 4);
        addButton.setImage(this.fAddIcon);
        addButton.setDisabledImage(this.fAddDisabledIcon);
        addButton.setToolTipText(Messages.SearchConditionList_ADD_CONDITION);
        final Menu conditionMenu = new Menu((Control)buttonBar);
        this.createConditionMenu(conditionMenu, item);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rect = item.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = buttonBar.toDisplay(pt);
                    conditionMenu.setLocation(pt.x, pt.y);
                    conditionMenu.setVisible(true);
                } else {
                    SearchConditionList.this.onAdd(item);
                }
            }
        });
        buttonBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OwlUI.safeDispose(conditionMenu);
            }
        });
        ToolItem deleteButton = new ToolItem(buttonBar, 8);
        deleteButton.setImage(this.fDeleteIcon);
        deleteButton.setDisabledImage(this.fDeleteDisabledIcon);
        deleteButton.setToolTipText(Messages.SearchConditionList_DELETE_CONDITION);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobRunner.runInUIThread(0, true, (Widget)buttonBar, new Runnable(){

                    public void run() {
                        SearchConditionList.this.onDelete(item, itemContainer);
                    }
                });
            }
        });
        boolean addedToEnd = false;
        if (index == this.fItems.size()) {
            addedToEnd = true;
            this.fItems.add(item);
        } else {
            SearchConditionItem oldItem = this.fItems.get(index);
            this.fItems.add(index, item);
            item.getParent().moveAbove((Control)oldItem.getParent());
        }
        this.layout(true, true);
        this.update();
        this.updateSize();
        OwlUI.adjustSizeForScrollbar(this.getShell(), this.getVerticalBar(), wasScrollbarShowing);
        if (scroll && addedToEnd) {
            this.setOrigin(0, this.getContent().getSize().y);
        }
        return item;
    }

    private void createConditionMenu(Menu menu, SearchConditionItem item) {
        MenuItem mItem;
        IModelFactory factory = Owl.getModelFactory();
        String news = INews.class.getName();
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(-1)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_ENTIRE_NEWS);
            this.hookSelectionListener(mItem, item, factory.createSearchField(-1, news));
            new MenuItem(menu, 2);
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(14)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_STATE);
            this.hookSelectionListener(mItem, item, factory.createSearchField(14, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(19)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_LOCATION);
            this.hookSelectionListener(mItem, item, factory.createSearchField(19, news));
            new MenuItem(menu, 2);
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(0)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_TITLE);
            this.hookSelectionListener(mItem, item, factory.createSearchField(0, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(2)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_DESCRIPTION);
            this.hookSelectionListener(mItem, item, factory.createSearchField(2, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(3)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_AUTHOR);
            this.hookSelectionListener(mItem, item, factory.createSearchField(3, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(12)) {
            mItem = new MenuItem(menu, 8);
            mItem.setText(Messages.SearchConditionList_CATEGORY);
            this.hookSelectionListener(mItem, item, factory.createSearchField(12, news));
        }
        mItem = new MenuItem(menu, 64);
        mItem.setText(Messages.SearchConditionList_DATE);
        Menu dateMenu = new Menu(mItem);
        mItem.setMenu(dateMenu);
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(18)) {
            mItem = new MenuItem(dateMenu, 8);
            mItem.setText(Messages.SearchConditionList_AGE);
            this.hookSelectionListener(mItem, item, factory.createSearchField(18, news));
            new MenuItem(dateMenu, 2);
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(7)) {
            mItem = new MenuItem(dateMenu, 8);
            mItem.setText(Messages.SearchConditionList_DATE_MODIFIED);
            this.hookSelectionListener(mItem, item, factory.createSearchField(7, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(6)) {
            mItem = new MenuItem(dateMenu, 8);
            mItem.setText(Messages.SearchConditionList_DATE_PUBLISHED);
            this.hookSelectionListener(mItem, item, factory.createSearchField(6, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(8)) {
            mItem = new MenuItem(dateMenu, 8);
            mItem.setText(Messages.SearchConditionList_DATE_RECEIVED);
            this.hookSelectionListener(mItem, item, factory.createSearchField(8, news));
        }
        mItem = new MenuItem(menu, 2);
        mItem = new MenuItem(menu, 64);
        mItem.setText(Messages.SearchConditionList_OTHER);
        Menu otherMenu = new Menu(mItem);
        mItem.setMenu(otherMenu);
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(10)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_HAS_ATTACHMENTS);
            this.hookSelectionListener(mItem, item, factory.createSearchField(10, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(11)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_ATTACHMENT);
            this.hookSelectionListener(mItem, item, factory.createSearchField(11, news));
        }
        new MenuItem(otherMenu, 2);
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(9)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_SOURCE);
            this.hookSelectionListener(mItem, item, factory.createSearchField(9, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(1)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_LINK);
            this.hookSelectionListener(mItem, item, factory.createSearchField(1, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(13)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_IS_STICKY);
            this.hookSelectionListener(mItem, item, factory.createSearchField(13, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(17)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_FEED);
            this.hookSelectionListener(mItem, item, factory.createSearchField(17, news));
        }
        if (this.fFieldsToExclude == null || !this.fFieldsToExclude.contains(15)) {
            mItem = new MenuItem(otherMenu, 8);
            mItem.setText(Messages.SearchConditionList_LABEL);
            this.hookSelectionListener(mItem, item, factory.createSearchField(15, news));
        }
    }

    private void hookSelectionListener(MenuItem item, final SearchConditionItem condition, final ISearchField field) {
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchConditionList.this.onAdd(condition, field);
            }
        });
    }

    int indexOf(SearchConditionItem item) {
        return this.fItems.indexOf((Object)item);
    }

    void onAdd(SearchConditionItem selectedItem, ISearchField field) {
        ISearchCondition condition = this.createCondition(selectedItem.createCondition(null, false));
        condition.setField(field);
        SearchConditionItem addedItem = this.addItem(condition, this.indexOf(selectedItem) + 1, true);
        addedItem.focusInput();
        this.fModified = true;
    }

    void onAdd(SearchConditionItem selectedItem) {
        ISearchCondition condition = this.createCondition(selectedItem.createCondition(null, false));
        SearchConditionItem addedItem = this.addItem(condition, this.indexOf(selectedItem) + 1, true);
        addedItem.focusInput();
        this.fModified = true;
    }

    void onDelete(SearchConditionItem item, Composite itemContainer) {
        boolean wasScrollbarShowing = this.getVerticalBar() != null ? this.getVerticalBar().isVisible() : false;
        itemContainer.dispose();
        this.removeItem(item);
        this.fModified = true;
        if (this.fItems.size() == 0) {
            this.addItem(this.getDefaultCondition()).focusInput();
        }
        OwlUI.adjustSizeForScrollbar(this.getShell(), this.getVerticalBar(), wasScrollbarShowing);
    }

    private ISearchCondition createCondition(ISearchCondition current) {
        IModelFactory factory = Owl.getModelFactory();
        ISearchField field = factory.createSearchField(current.getField().getId(), current.getField().getEntityName());
        return factory.createSearchCondition(field, current.getSpecifier(), (Object)"");
    }

    void removeItem(SearchConditionItem item) {
        item.dispose();
        this.fItems.remove((Object)item);
        this.layout(true, true);
        this.update();
        this.updateSize();
    }

    private void updateSize() {
        this.setMinSize(this.fContainer.computeSize(-1, -1));
    }
}

