/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.util.JobRunner;

public class AudioUtils {
    private static final boolean IS_SUPPORTED = AudioUtils.getSupported();

    private AudioUtils() {
    }

    private static boolean getSupported() {
        try {
            Class.forName("javax.sound.sampled.AudioSystem");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSupported() {
        return IS_SUPPORTED;
    }

    public static void play(final String file) {
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                try {
                    if (!Controller.getDefault().isShuttingDown()) {
                        AudioUtils.doPlay(file);
                    }
                }
                catch (UnsupportedAudioFileException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
                catch (IOException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
                catch (LineUnavailableException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
            }
        });
    }

    private static void doPlay(String file) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        AudioInputStream inS = null;
        try {
            inS = AudioSystem.getAudioInputStream(new File(file));
            AudioFormat audioFormat = inS.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(audioFormat);
            line.start();
            int read = 0;
            byte[] buf = new byte[1024];
            while ((read = inS.read(buf, 0, buf.length)) != -1 && !Controller.getDefault().isShuttingDown()) {
                line.write(buf, 0, read);
            }
            line.drain();
            line.close();
        }
        finally {
            if (inS != null) {
                inS.close();
            }
        }
    }
}

