/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.util.CColumnLayoutData;

public class CTree {
    private static final String LAYOUT_DATA = "org.rssowl.ui.internal.CTreeLayoutData";
    private Tree fTree;
    private List<TreeColumn> fCols = new ArrayList<TreeColumn>();
    private boolean fIsFlat = true;

    public CTree(Composite parent, int style) {
        this.fTree = new Tree(parent, style);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CTree.this.onTreeResize();
            }
        });
    }

    public Tree getControl() {
        return this.fTree;
    }

    public void setFlat(boolean isFlat) {
        this.fIsFlat = isFlat;
    }

    public TreeColumn manageColumn(TreeColumn col, CColumnLayoutData layoutData, String text, String tooltip, Image image, boolean moveable, boolean resizable) {
        col.setData(LAYOUT_DATA, (Object)layoutData);
        col.setMoveable(moveable);
        col.setResizable(resizable);
        if (text != null) {
            col.setText(text);
        }
        if (tooltip != null) {
            col.setToolTipText(tooltip);
        }
        if (image != null) {
            col.setImage(image);
        }
        this.fCols.add(col);
        return col;
    }

    public void setVisible(TreeColumn col, boolean visible, boolean update) {
        CColumnLayoutData data = (CColumnLayoutData)col.getData(LAYOUT_DATA);
        data.setHidden(!visible);
        if (update) {
            this.onTreeResize();
        }
    }

    public void update() {
        this.onTreeResize();
    }

    public void clear() {
        for (TreeColumn cols : this.fCols) {
            cols.dispose();
        }
        this.fCols.clear();
    }

    private void onTreeResize() {
        CColumnLayoutData data;
        int totalWidth = this.fTree.getParent().getClientArea().width;
        totalWidth -= this.fTree.getBorderWidth() * 2;
        ScrollBar verticalBar = this.fTree.getVerticalBar();
        if (verticalBar != null) {
            int barWidth = verticalBar.getSize().x;
            if (Application.IS_MAC && barWidth == 0) {
                barWidth = 16;
            }
            totalWidth -= barWidth;
        }
        if (Application.IS_MAC) {
            totalWidth -= 3;
            if (!this.fIsFlat) {
                totalWidth -= 24;
            }
        } else if (Application.IS_LINUX) {
            totalWidth -= 3;
        }
        int freeWidth = totalWidth;
        int occupiedWidth = 0;
        int totalFillSum = 0;
        int i = 0;
        while (i < this.fCols.size()) {
            TreeColumn column = this.fCols.get(i);
            data = (CColumnLayoutData)column.getData(LAYOUT_DATA);
            if (data.isHidden()) {
                column.setWidth(0);
            } else if (data.getSize() == CColumnLayoutData.Size.FIXED && data.getWidthHint() == -1) {
                column.pack();
                int width = column.getWidth();
                freeWidth -= width;
                occupiedWidth += width;
            } else if (data.getSize() == CColumnLayoutData.Size.FIXED) {
                int widthHint = data.getWidthHint();
                if (Application.IS_WINDOWS && i == 0) {
                    widthHint = this.fIsFlat ? (widthHint += 25) : (widthHint += 45);
                } else if (Application.IS_LINUX && i == 0) {
                    widthHint = this.fIsFlat ? (widthHint += 20) : (widthHint += 40);
                } else if (Application.IS_MAC && i == 0) {
                    widthHint += 20;
                }
                freeWidth -= widthHint;
                occupiedWidth += widthHint;
                if (column.getWidth() != widthHint) {
                    column.setWidth(widthHint);
                }
            } else if (data.getSize() == CColumnLayoutData.Size.FILL) {
                totalFillSum += data.getWidthHint();
            }
            ++i;
        }
        for (TreeColumn column : this.fCols) {
            data = (CColumnLayoutData)column.getData(LAYOUT_DATA);
            if (data.getSize() != CColumnLayoutData.Size.FILL) continue;
            int colWidth = freeWidth * data.getWidthHint() / totalFillSum;
            if (occupiedWidth + colWidth >= totalWidth) {
                colWidth = totalWidth - occupiedWidth;
            }
            occupiedWidth += colWidth;
            if (column.getWidth() == colWidth) continue;
            column.setWidth(colWidth);
        }
    }
}

