/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ViewerOpenStrategy
implements Listener {
    private static final int DOUBLE_CLICK = 0;
    private static final int SINGLE_CLICK = 1;
    private static final int SELECT_ON_HOVER = 2;
    private static final int ARROW_KEYS_OPEN = 4;
    private static final int TIME = 500;
    private ListenerList fOpenEventListeners = new ListenerList();
    private boolean fTimerStarted;
    private Event fMouseUpEvent;
    private Event fMouseMoveEvent;
    private SelectionEvent fSelectionPendent;
    private boolean fEnterKeyDown;
    private SelectionEvent fDefaultSelectionPendent;
    private boolean fArrowKeyDown;
    private final int[] fCount = new int[1];
    private long fStartTime = System.currentTimeMillis();
    private boolean fCollapseOccurred;
    private boolean fExpandOccurred;
    private Display fDisplay;

    public ViewerOpenStrategy(Control control) {
        this.fDisplay = control.getDisplay();
        this.addListener(control);
    }

    public void addOpenListener(IOpenEventListener listener) {
        this.fOpenEventListeners.add((Object)listener);
    }

    public void removeOpenListener(IOpenEventListener listener) {
        this.fOpenEventListeners.remove((Object)listener);
    }

    public void clearExpandFlag() {
        this.fExpandOccurred = false;
    }

    private void addListener(Control c) {
        c.addListener(6, (Listener)this);
        c.addListener(7, (Listener)this);
        c.addListener(5, (Listener)this);
        c.addListener(3, (Listener)this);
        c.addListener(4, (Listener)this);
        c.addListener(1, (Listener)this);
        c.addListener(13, (Listener)this);
        c.addListener(14, (Listener)this);
        c.addListener(18, (Listener)this);
        c.addListener(17, (Listener)this);
    }

    private void fireOpenEvent(SelectionEvent e) {
        if (e.item != null && e.item.isDisposed()) {
            return;
        }
        Object[] listeners = this.fOpenEventListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IOpenEventListener)listeners[i]).handleOpen(e);
            ++i;
        }
    }

    public void handleEvent(Event e) {
        if (e.type == 14) {
            SelectionEvent event = new SelectionEvent(e);
            if (OpenStrategy.getOpenMethod() == 0) {
                this.fireOpenEvent(event);
            } else if (this.fEnterKeyDown) {
                this.fireOpenEvent(event);
                this.fEnterKeyDown = false;
                this.fDefaultSelectionPendent = null;
            } else {
                this.fDefaultSelectionPendent = event;
            }
            return;
        }
        switch (e.type) {
            case 6: 
            case 7: {
                this.fMouseUpEvent = null;
                this.fMouseMoveEvent = null;
                this.fSelectionPendent = null;
                break;
            }
            case 5: {
                Runnable[] runnable;
                if ((OpenStrategy.getOpenMethod() & 2) == 0) {
                    return;
                }
                if (e.stateMask != 0) {
                    return;
                }
                if (e.widget.getDisplay().getFocusControl() != e.widget) {
                    return;
                }
                this.fMouseMoveEvent = e;
                runnable = new Runnable[]{new Runnable(){

                    public void run() {
                        long time = System.currentTimeMillis();
                        int diff = (int)(time - ViewerOpenStrategy.this.fStartTime);
                        if (diff <= 500) {
                            ViewerOpenStrategy.this.fDisplay.timerExec(diff * 2 / 3, runnable[0]);
                        } else {
                            ViewerOpenStrategy.this.fTimerStarted = false;
                            ViewerOpenStrategy.this.setSelection(ViewerOpenStrategy.this.fMouseMoveEvent);
                        }
                    }
                }};
                this.fStartTime = System.currentTimeMillis();
                if (this.fTimerStarted) break;
                this.fTimerStarted = true;
                this.fDisplay.timerExec(333, runnable[0]);
                break;
            }
            case 3: {
                this.fMouseUpEvent = null;
                this.fArrowKeyDown = false;
                break;
            }
            case 17: {
                this.fExpandOccurred = true;
                break;
            }
            case 18: {
                this.fCollapseOccurred = true;
                break;
            }
            case 4: {
                this.fMouseMoveEvent = null;
                if (e.button != 1 || (e.stateMask & 0xFFF7FFFF) != 0) {
                    return;
                }
                if (this.fSelectionPendent != null && !this.fCollapseOccurred && !this.fExpandOccurred) {
                    this.mouseSelectItem(this.fSelectionPendent);
                    break;
                }
                this.fMouseUpEvent = e;
                this.fCollapseOccurred = false;
                this.fExpandOccurred = false;
                break;
            }
            case 1: {
                this.fMouseMoveEvent = null;
                this.fMouseUpEvent = null;
                boolean bl = this.fArrowKeyDown = (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) && e.stateMask == 0;
                if (e.character != '\r') break;
                if (this.fDefaultSelectionPendent != null) {
                    this.fireOpenEvent(new SelectionEvent(e));
                    this.fEnterKeyDown = false;
                    this.fDefaultSelectionPendent = null;
                    break;
                }
                this.fEnterKeyDown = true;
                break;
            }
            case 13: {
                SelectionEvent event = new SelectionEvent(e);
                this.fMouseMoveEvent = null;
                if (this.fMouseUpEvent != null) {
                    this.mouseSelectItem(event);
                } else {
                    this.fSelectionPendent = event;
                }
                this.fCount[0] = this.fCount[0] + 1;
                int id = this.fCount[0];
                if (!this.fArrowKeyDown || id != this.fCount[0] || (OpenStrategy.getOpenMethod() & 4) == 0) break;
                this.fireOpenEvent(new SelectionEvent(e));
            }
        }
    }

    void mouseSelectItem(SelectionEvent e) {
        if ((OpenStrategy.getOpenMethod() & 1) != 0) {
            this.fireOpenEvent(e);
        }
        this.fMouseUpEvent = null;
        this.fSelectionPendent = null;
    }

    void setSelection(Event e) {
        if (e == null) {
            return;
        }
        Widget w = e.widget;
        if (w.isDisposed()) {
            return;
        }
        SelectionEvent selEvent = new SelectionEvent(e);
        if (w instanceof Tree) {
            Tree tree = (Tree)w;
            TreeItem item = tree.getItem(new Point(e.x, e.y));
            if (item != null) {
                tree.setSelection(new TreeItem[]{item});
            }
            selEvent.item = item;
        } else if (w instanceof Table) {
            Table table = (Table)w;
            TableItem item = table.getItem(new Point(e.x, e.y));
            if (item != null) {
                table.setSelection(new TableItem[]{item});
            }
            selEvent.item = item;
        } else {
            return;
        }
        if (selEvent.item == null) {
            return;
        }
    }
}

