/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class HashcodeReferenceSystem
implements ReferenceSystem {
    private ObjectReference _hashCodeTree;
    private ObjectReference _idTree;

    public void addNewReference(ObjectReference objectReference) {
        this.addReference(objectReference);
    }

    public void addExistingReference(ObjectReference objectReference) {
        this.addReference(objectReference);
    }

    private void addReference(ObjectReference objectReference) {
        this.idAdd(objectReference);
        this.hashCodeAdd(objectReference);
    }

    public void addExistingReferenceToObjectTree(ObjectReference objectReference) {
        this.hashCodeAdd(objectReference);
    }

    public void addExistingReferenceToIdTree(ObjectReference objectReference) {
        this.idAdd(objectReference);
    }

    public void commit() {
    }

    private void hashCodeAdd(ObjectReference objectReference) {
        if (this._hashCodeTree == null) {
            objectReference.hc_init();
            this._hashCodeTree = objectReference;
            return;
        }
        this._hashCodeTree = this._hashCodeTree.hc_add(objectReference);
    }

    private void idAdd(ObjectReference objectReference) {
        if (this._idTree == null) {
            objectReference.hc_init();
            this._idTree = objectReference;
            return;
        }
        this._idTree = this._idTree.id_add(objectReference);
    }

    public ObjectReference referenceForId(int n) {
        if (this._idTree == null) {
            return null;
        }
        if (!ObjectReference.isValidId(n)) {
            return null;
        }
        return this._idTree.id_find(n);
    }

    public ObjectReference referenceForObject(Object object) {
        if (this._hashCodeTree == null) {
            return null;
        }
        return this._hashCodeTree.hc_find(object);
    }

    public void removeReference(ObjectReference objectReference) {
        if (this._hashCodeTree != null) {
            this._hashCodeTree = this._hashCodeTree.hc_remove(objectReference);
        }
        if (this._idTree != null) {
            this._idTree = this._idTree.id_remove(objectReference.getID());
        }
    }

    public void rollback() {
    }

    public void traverseReferences(Visitor4 visitor4) {
        if (this._hashCodeTree == null) {
            return;
        }
        this._hashCodeTree.hc_traverse(visitor4);
    }
}

