/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.Debug;
import com.db4o.Internal4;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.Rename;
import com.db4o.ReplicationImpl;
import com.db4o.config.Configuration;
import com.db4o.config.Entry;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ExtObjectContainer;
import com.db4o.ext.MemoryFile;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.StoredClass;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.IntIdGenerator;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.PersistentTimeStampIdGenerator;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataRepository;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Message;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectContainerSpec;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReferenceSystem;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TransportObjectContainer;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UUIDFieldMetadata;
import com.db4o.internal.VersionFieldMetadata;
import com.db4o.internal.WeakReferenceCollector;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.callbacks.NullCallbacks;
import com.db4o.internal.cs.ClassInfoHelper;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.query.NativeQueryHandler;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.internal.replication.MigrationConnection;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.replication.ReplicationConflictHandler;
import com.db4o.replication.ReplicationProcess;
import com.db4o.types.Db4oCollections;
import com.db4o.types.Db4oType;
import com.db4o.types.SecondClass;
import com.db4o.types.TransientClass;

public abstract class PartialObjectContainer
implements TransientClass,
Internal4,
ObjectContainerSpec {
    private boolean i_amDuringFatalExit = false;
    protected ClassMetadataRepository _classCollection;
    protected ClassInfoHelper _classMetaHelper = new ClassInfoHelper();
    protected Config4Impl i_config;
    private int _stackDepth;
    private ReferenceSystem _referenceSystem;
    private Tree i_justPeeked;
    public final Object i_lock;
    private List4 i_needsUpdate;
    final ObjectContainerBase i_parent;
    boolean i_refreshInsteadOfActivate;
    int i_showInternalClasses = 0;
    private List4 i_stillToActivate;
    private List4 i_stillToDeactivate;
    private List4 i_stillToSet;
    protected Transaction i_systemTrans;
    protected Transaction i_trans;
    private boolean i_instantiating;
    public HandlerRegistry i_handlers;
    int _replicationCallState;
    WeakReferenceCollector i_references;
    private NativeQueryHandler _nativeQueryHandler;
    private final ObjectContainerBase _this;
    private Callbacks _callbacks = new NullCallbacks();
    protected final PersistentTimeStampIdGenerator _timeStampIdGenerator = new PersistentTimeStampIdGenerator();
    private int _topLevelCallId = 1;
    private IntIdGenerator _topLevelCallIdGenerator = new IntIdGenerator();

    protected PartialObjectContainer(Configuration configuration, ObjectContainerBase objectContainerBase) {
        this._this = PartialObjectContainer.cast(this);
        this.i_parent = objectContainerBase == null ? this._this : objectContainerBase;
        this.i_lock = objectContainerBase == null ? new Object() : objectContainerBase.i_lock;
        this.initializeTransactions();
        this.initialize1(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.activate1(null, object, n);
        }
    }

    public final void activate1(Transaction transaction, Object object) {
        this.activate1(transaction, object, this.configImpl().activationDepth());
    }

    public final void activate1(Transaction transaction, Object object, int n) {
        this.activate2(this.checkTransaction(transaction), object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void activate2(Transaction transaction, Object object, int n) {
        this.beginTopLevelCall();
        try {
            this.stillToActivate(object, n);
            this.activate3CheckStill(transaction);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        finally {
            this.endTopLevelCall();
        }
    }

    final void activate3CheckStill(Transaction transaction) {
        while (this.i_stillToActivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToActivate);
            this.i_stillToActivate = null;
            while (iterator4Impl.moveNext()) {
                ObjectReference objectReference = (ObjectReference)iterator4Impl.current();
                iterator4Impl.moveNext();
                int n = (Integer)iterator4Impl.current();
                Object object = objectReference.getObject();
                if (object == null) {
                    this.removeReference(objectReference);
                    continue;
                }
                objectReference.activate1(transaction, object, n, this.i_refreshInsteadOfActivate);
            }
        }
    }

    public int alignToBlockSize(int n) {
        return this.blocksFor(n) * this.blockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Object object, long l) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.bind1(null, object, l);
        }
    }

    public final void bind1(Transaction transaction, Object object, long l) {
        ObjectReference objectReference;
        Object object2;
        transaction = this.checkTransaction(transaction);
        int n = (int)l;
        if (object != null && (object2 = this.getByID(l)) != null && (objectReference = this.getYapObject(n)) != null) {
            if (transaction.reflector().forObject(object) == objectReference.getYapClass().classReflector()) {
                this.bind2(objectReference, object);
            } else {
                throw new RuntimeException(Messages.get(57));
            }
        }
    }

    public final void bind2(ObjectReference objectReference, Object object) {
        int n = objectReference.getID();
        this.removeReference(objectReference);
        objectReference = new ObjectReference(this.getYapClass(this.reflector().forObject(object)), n);
        objectReference.setObjectWeak(this._this, object);
        objectReference.setStateDirty();
        this._referenceSystem.addExistingReference(objectReference);
    }

    public byte blockSize() {
        return 1;
    }

    public int blocksFor(long l) {
        byte by = this.blockSize();
        int n = (int)(l / (long)by);
        if (l % (long)by != 0L) {
            ++n;
        }
        return n;
    }

    private final boolean breakDeleteForEnum(ObjectReference objectReference, boolean bl) {
        if (bl) {
            return false;
        }
        if (objectReference == null) {
            return false;
        }
        return Platform4.jdk().isEnum(this.reflector(), objectReference.getYapClass().classReflector());
    }

    boolean canUpdate() {
        return true;
    }

    public final void checkClosed() {
        if (this._classCollection == null) {
            Exceptions4.throwRuntimeException(20, this.toString());
        }
    }

    final void checkNeededUpdates() {
        if (this.i_needsUpdate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_needsUpdate);
            while (iterator4Impl.moveNext()) {
                ClassMetadata classMetadata = (ClassMetadata)iterator4Impl.current();
                classMetadata.setStateDirty();
                classMetadata.write(this.i_systemTrans);
            }
            this.i_needsUpdate = null;
        }
    }

    public final Transaction checkTransaction(Transaction transaction) {
        this.checkClosed();
        if (transaction != null) {
            return transaction;
        }
        return this.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        Object object = this.i_lock;
        synchronized (object) {
            boolean bl = this.close1();
            return bl;
        }
    }

    final boolean close1() {
        if (this._classCollection == null) {
            return true;
        }
        Platform4.preClose(this._this);
        this.checkNeededUpdates();
        if (this.stateMessages()) {
            this.logMsg(2, this.toString());
        }
        boolean bl = this.close2();
        return bl;
    }

    protected boolean close2() {
        this.stopSession();
        this.i_systemTrans = null;
        this.i_trans = null;
        if (this.stateMessages()) {
            this.logMsg(3, this.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oCollections collections() {
        Object object = this.i_lock;
        synchronized (object) {
            if (this.i_handlers.i_collections == null) {
                this.i_handlers.i_collections = Platform4.collections(this);
            }
            return this.i_handlers.i_collections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.i_config.isReadOnly()) {
            return;
        }
        Object object = this.i_lock;
        synchronized (object) {
            this.beginTopLevelCall();
            try {
                this.commit1();
                this._referenceSystem.commit();
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    public abstract void commit1();

    public Configuration configure() {
        return this.configImpl();
    }

    public Config4Impl config() {
        return this.configImpl();
    }

    public abstract int converterVersion();

    public abstract AbstractQueryResult newQueryResult(Transaction var1, QueryEvaluationMode var2);

    protected void createStringIO(byte by) {
        this.setStringIo(LatinStringIO.forEncoding(by));
    }

    protected final void initializeTransactions() {
        this.i_systemTrans = this.newTransaction(null);
        this.i_trans = this.newTransaction();
    }

    public abstract Transaction newTransaction(Transaction var1);

    public Transaction newTransaction() {
        return this.newTransaction(this.i_systemTrans);
    }

    public abstract long currentVersion();

    public boolean createYapClass(ClassMetadata classMetadata, ReflectClass reflectClass, ClassMetadata classMetadata2) {
        return classMetadata.init(this._this, classMetadata2, reflectClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oType db4oTypeStored(Transaction transaction, Object object) {
        if (!(object instanceof Db4oDatabase)) {
            return null;
        }
        Db4oDatabase db4oDatabase = (Db4oDatabase)object;
        if (this.getYapObject(object) != null) {
            return db4oDatabase;
        }
        this.showInternalClasses(true);
        try {
            Db4oDatabase db4oDatabase2 = db4oDatabase.query(transaction);
            return db4oDatabase2;
        }
        finally {
            this.showInternalClasses(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.beginTopLevelCall();
            try {
                this.deactivate1(object, n);
            }
            catch (Throwable throwable) {
                this.fatalException(throwable);
            }
            finally {
                this.endTopLevelCall();
            }
        }
    }

    private final void deactivate1(Object object, int n) {
        this.stillToDeactivate(object, n, true);
        while (this.i_stillToDeactivate != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToDeactivate);
            this.i_stillToDeactivate = null;
            while (iterator4Impl.moveNext()) {
                ObjectReference objectReference = (ObjectReference)iterator4Impl.current();
                iterator4Impl.moveNext();
                Integer n2 = (Integer)iterator4Impl.current();
                objectReference.deactivate(this.i_trans, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.generateCallIDOnTopLevel();
            this.delete(null, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Transaction transaction, Object object) {
        if (this.i_config.isReadOnly()) {
            return;
        }
        Object object2 = this.i_lock;
        synchronized (object2) {
            transaction = this.checkTransaction(transaction);
            this.delete1(transaction, object, true);
            transaction.processDeletes();
        }
    }

    public final void delete1(Transaction transaction, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference == null) {
            return;
        }
        try {
            this.delete2(transaction, objectReference, object, 0, bl);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
    }

    public final void delete2(Transaction transaction, ObjectReference objectReference, Object object, int n, boolean bl) {
        if (this.breakDeleteForEnum(objectReference, bl)) {
            return;
        }
        if (object instanceof SecondClass) {
            if (!this.flagForDelete(objectReference)) {
                return;
            }
            this.delete3(transaction, objectReference, n, bl);
            return;
        }
        transaction.delete(objectReference, objectReference.getID(), n);
    }

    final void delete3(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        if (objectReference == null || !objectReference.beginProcessing()) {
            return;
        }
        if (this.breakDeleteForEnum(objectReference, bl)) {
            objectReference.endProcessing();
            return;
        }
        if (!objectReference.isFlaggedForDelete()) {
            objectReference.endProcessing();
            return;
        }
        ClassMetadata classMetadata = objectReference.getYapClass();
        Object object = objectReference.getObject();
        objectReference.endProcessing();
        if (!this.objectCanDelete(classMetadata, object)) {
            return;
        }
        objectReference.beginProcessing();
        if (this.delete4(transaction, objectReference, n, bl)) {
            this.objectOnDelete(classMetadata, object);
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + objectReference.getID() + " delete " + objectReference.getYapClass().getName());
            }
        }
        objectReference.endProcessing();
    }

    private boolean objectCanDelete(ClassMetadata classMetadata, Object object) {
        return this._this.callbacks().objectCanDelete(object) && classMetadata.dispatchEvent(this._this, object, 0);
    }

    private void objectOnDelete(ClassMetadata classMetadata, Object object) {
        this._this.callbacks().objectOnDelete(object);
        classMetadata.dispatchEvent(this._this, object, 1);
    }

    public abstract boolean delete4(Transaction var1, ObjectReference var2, int var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object descend(Object object, String[] stringArray) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.descend1(this.checkTransaction(null), object, stringArray);
        }
    }

    private Object descend1(Transaction transaction, Object object, String[] stringArray) {
        String[] stringArray2;
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference == null) {
            return null;
        }
        Object object2 = null;
        final String string = stringArray[0];
        if (string == null) {
            return null;
        }
        ClassMetadata classMetadata = objectReference.getYapClass();
        final FieldMetadata[] fieldMetadataArray = new FieldMetadata[]{null};
        classMetadata.forEachYapField(new Visitor4(){

            public void visit(Object object) {
                FieldMetadata fieldMetadata = (FieldMetadata)object;
                if (fieldMetadata.canAddToQuery(string)) {
                    fieldMetadataArray[0] = fieldMetadata;
                }
            }
        });
        if (fieldMetadataArray[0] == null) {
            return null;
        }
        if (objectReference.isActive()) {
            object2 = fieldMetadataArray[0].get(object);
        } else {
            stringArray2 = this.readReaderByID(transaction, objectReference.getID());
            if (stringArray2 == null) {
                return null;
            }
            MarshallerFamily marshallerFamily = classMetadata.findOffset((Buffer)stringArray2, fieldMetadataArray[0]);
            if (marshallerFamily == null) {
                return null;
            }
            try {
                object2 = fieldMetadataArray[0].readQuery(transaction, marshallerFamily, (Buffer)stringArray2);
            }
            catch (CorruptionException corruptionException) {
                // empty catch block
            }
        }
        if (stringArray.length == 1) {
            return object2;
        }
        if (object2 == null) {
            return null;
        }
        stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        return this.descend1(transaction, object2, stringArray2);
    }

    public boolean detectSchemaChanges() {
        return this.configImpl().detectSchemaChanges();
    }

    public boolean dispatchsEvents() {
        return true;
    }

    protected boolean doFinalize() {
        return true;
    }

    void emergencyClose() {
        this.stopSession();
    }

    public ExtObjectContainer ext() {
        return this._this;
    }

    void failedToShutDown() {
        if (this._classCollection == null) {
            return;
        }
        if (this.i_amDuringFatalExit) {
            return;
        }
        if (this._stackDepth == 0) {
            Messages.logErr(this.configImpl(), 50, this.toString(), null);
            while (!this.close()) {
            }
        } else {
            this.emergencyClose();
            if (this._stackDepth > 0) {
                Messages.logErr(this.configImpl(), 24, null, null);
            }
        }
    }

    void fatalException(int n) {
        this.fatalException(null, n);
    }

    void fatalException(Throwable throwable) {
        this.fatalException(throwable, 44);
    }

    void fatalException(Throwable throwable, int n) {
        if (!this.i_amDuringFatalExit) {
            this.i_amDuringFatalExit = true;
            this.emergencyClose();
            Messages.logErr(this.configImpl(), n == 44 ? 18 : n, null, throwable);
        }
        throw new RuntimeException(Messages.get(n));
    }

    protected void finalize() {
        if (this.doFinalize() && this.configuredForAutomaticShutDown()) {
            this.failedToShutDown();
        }
    }

    private boolean configuredForAutomaticShutDown() {
        return this.configImpl() == null || this.configImpl().automaticShutDown();
    }

    void gc() {
        this.i_references.pollReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet get(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.get1(null, object);
        }
    }

    ObjectSetFacade get1(Transaction transaction, Object object) {
        transaction = this.checkTransaction(transaction);
        QueryResult queryResult = null;
        try {
            queryResult = this.get2(transaction, object);
        }
        catch (Throwable throwable) {
            Exceptions4.catchAllExceptDb4oException(throwable);
            this.fatalException(throwable);
        }
        return new ObjectSetFacade(queryResult);
    }

    private final QueryResult get2(Transaction transaction, Object object) {
        if (object == null || object.getClass() == Const4.CLASS_OBJECT) {
            return this.getAll(transaction);
        }
        Query query = this.query(transaction);
        query.constrain(object);
        return this.executeQuery((QQuery)query);
    }

    public abstract AbstractQueryResult getAll(Transaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getByID(long l) {
        Object object = this.i_lock;
        synchronized (object) {
            return this.getByID1(null, l);
        }
    }

    public final Object getByID1(Transaction transaction, long l) {
        transaction = this.checkTransaction(transaction);
        try {
            return this.getByID2(transaction, (int)l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    final Object getByID2(Transaction transaction, int n) {
        if (n > 0) {
            Object object = this.objectForIDFromCache(n);
            if (object != null) {
                return object;
            }
            try {
                return new ObjectReference(n).read(transaction, null, null, 0, 1, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public final Object getActivatedObjectFromCache(Transaction transaction, int n) {
        Object object = this.objectForIDFromCache(n);
        if (object == null) {
            return null;
        }
        this.activate1(transaction, object, this.configImpl().activationDepth());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readActivatedObjectNotInCache(Transaction transaction, int n) {
        Object object = null;
        this.beginTopLevelCall();
        try {
            object = new ObjectReference(n).read(transaction, null, null, this.configImpl().activationDepth(), 1, true);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.endTopLevelCall();
        }
        this.activate3CheckStill(transaction);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getByUUID(Db4oUUID db4oUUID) {
        Object object = this.i_lock;
        synchronized (object) {
            if (db4oUUID == null) {
                return null;
            }
            Transaction transaction = this.checkTransaction(null);
            Object[] objectArray = transaction.objectAndYapObjectBySignature(db4oUUID.getLongPart(), db4oUUID.getSignaturePart());
            return objectArray[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.getID1(object);
        }
    }

    public final int getID1(Object object) {
        this.checkClosed();
        if (object == null) {
            return 0;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference != null) {
            return objectReference.getID();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInfo getObjectInfo(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.getYapObject(object);
        }
    }

    public final Object[] getObjectAndYapObjectByID(Transaction transaction, int n) {
        Object[] objectArray = new Object[2];
        if (n > 0) {
            ObjectReference objectReference = this.getYapObject(n);
            if (objectReference != null) {
                Object object = objectReference.getObject();
                if (object != null) {
                    objectArray[0] = object;
                    objectArray[1] = objectReference;
                    return objectArray;
                }
                this.removeReference(objectReference);
            }
            try {
                objectReference = new ObjectReference(n);
                objectArray[0] = objectReference.read(transaction, null, null, 0, 1, true);
                if (objectArray[0] == null) {
                    return objectArray;
                }
                if (objectArray[0] != objectReference.getObject()) {
                    return this.getObjectAndYapObjectByID(transaction, n);
                }
                objectArray[1] = objectReference;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return objectArray;
    }

    public final StatefulBuffer getWriter(Transaction transaction, int n, int n2) {
        if (Debug.exceedsMaximumBlockSize(n2)) {
            return null;
        }
        return new StatefulBuffer(transaction, n, n2);
    }

    public final Transaction getSystemTransaction() {
        return this.i_systemTrans;
    }

    public final Transaction getTransaction() {
        return this.i_trans;
    }

    public final ClassMetadata getYapClass(ReflectClass reflectClass) {
        if (this.cantGetYapClass(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this.i_handlers.getYapClassStatic(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.getYapClass(reflectClass);
    }

    public final ClassMetadata produceYapClass(ReflectClass reflectClass) {
        if (this.cantGetYapClass(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this.i_handlers.getYapClassStatic(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.produceYapClass(reflectClass);
    }

    final ClassMetadata getActiveYapClass(ReflectClass reflectClass) {
        if (this.cantGetYapClass(reflectClass)) {
            return null;
        }
        ClassMetadata classMetadata = this.i_handlers.getYapClassStatic(reflectClass);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.getActiveYapClass(reflectClass);
    }

    private final boolean cantGetYapClass(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return true;
        }
        return !this.showInternalClasses() && this.i_handlers.ICLASS_INTERNAL.isAssignableFrom(reflectClass);
    }

    public ClassMetadata getYapClass(int n) {
        if (n == 0) {
            return null;
        }
        ClassMetadata classMetadata = this.i_handlers.getYapClassStatic(n);
        if (classMetadata != null) {
            return classMetadata;
        }
        return this._classCollection.getYapClass(n);
    }

    public Object objectForIDFromCache(int n) {
        ObjectReference objectReference = this.getYapObject(n);
        if (objectReference == null) {
            return null;
        }
        Object object = objectReference.getObject();
        if (object == null) {
            this.removeReference(objectReference);
        }
        return object;
    }

    public final ObjectReference getYapObject(int n) {
        return this._referenceSystem.referenceForId(n);
    }

    public final ObjectReference getYapObject(Object object) {
        return this._referenceSystem.referenceForObject(object);
    }

    public HandlerRegistry handlers() {
        return this.i_handlers;
    }

    public boolean needsLockFileThread() {
        if (!Platform4.hasLockFileThread()) {
            return false;
        }
        if (Platform4.hasNio()) {
            return false;
        }
        if (this.configImpl().isReadOnly()) {
            return false;
        }
        return this.configImpl().lockFile();
    }

    protected boolean hasShutDownHook() {
        return this.configImpl().automaticShutDown();
    }

    protected void initialize1(Configuration configuration) {
        this.i_config = this.initializeConfig(configuration);
        this.i_handlers = new HandlerRegistry(this._this, this.configImpl().encoding(), this.configImpl().reflector());
        if (this.i_references != null) {
            this.gc();
            this.i_references.stopTimer();
        }
        this.i_references = new WeakReferenceCollector(this._this);
        if (this.hasShutDownHook()) {
            Platform4.addShutDownHook(this, this.i_lock);
        }
        this.i_handlers.initEncryption(this.configImpl());
        this.initialize2();
        this.i_stillToSet = null;
    }

    private Config4Impl initializeConfig(Configuration configuration) {
        Config4Impl config4Impl = (Config4Impl)configuration;
        config4Impl.stream(this._this);
        config4Impl.reflector().setTransaction(this.getSystemTransaction());
        return config4Impl;
    }

    void initialize2() {
        this.initialize2NObjectCarrier();
        this._referenceSystem = new TransactionalReferenceSystem();
    }

    void initialize2NObjectCarrier() {
        this._classCollection = new ClassMetadataRepository(this.i_systemTrans);
        this.i_references.startTimer();
    }

    protected void initialize3() {
        this.i_showInternalClasses = 100000;
        this.initialize4NObjectCarrier();
        this.i_showInternalClasses = 0;
    }

    void initialize4NObjectCarrier() {
        this.initializeEssentialClasses();
        this.rename(this.configImpl());
        this._classCollection.initOnUp(this.i_systemTrans);
        if (this.configImpl().detectSchemaChanges()) {
            this.i_systemTrans.commit();
        }
    }

    void initializeEssentialClasses() {
        for (int i = 0; i < Const4.ESSENTIAL_CLASSES.length; ++i) {
            this.produceYapClass(this.reflector().forClass(Const4.ESSENTIAL_CLASSES[i]));
        }
    }

    final void instantiating(boolean bl) {
        this.i_instantiating = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.isActive1(object);
        }
    }

    final boolean isActive1(Object object) {
        ObjectReference objectReference;
        this.checkClosed();
        if (object != null && (objectReference = this.getYapObject(object)) != null) {
            return objectReference.isActive();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(long l) {
        Object object = this.i_lock;
        synchronized (object) {
            return this.objectForIDFromCache((int)l) != null;
        }
    }

    public boolean isClient() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.i_lock;
        synchronized (object) {
            return this._classCollection == null;
        }
    }

    final boolean isInstantiating() {
        return this.i_instantiating;
    }

    boolean isServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStored(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            return this.isStored1(object);
        }
    }

    final boolean isStored1(Object object) {
        Transaction transaction = this.checkTransaction(null);
        if (object == null) {
            return false;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference == null) {
            return false;
        }
        return !transaction.isDeleted(objectReference.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass[] knownClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            return this.reflector().knownClasses();
        }
    }

    public TypeHandler4 handlerByID(int n) {
        if (n < 1) {
            return null;
        }
        if (this.i_handlers.isSystemHandler(n)) {
            return this.i_handlers.getHandler(n);
        }
        return this.getYapClass(n);
    }

    public Object lock() {
        return this.i_lock;
    }

    public final void logMsg(int n, String string) {
        Messages.logMsg(this.configImpl(), n, string);
    }

    public boolean maintainsIndices() {
        return true;
    }

    protected StatefulBuffer marshall(Transaction transaction, Object object) {
        int[] nArray = new int[]{0};
        byte[] byArray = this.marshall(object, nArray);
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, byArray.length);
        statefulBuffer.append(byArray);
        statefulBuffer.useSlot(nArray[0], 0, byArray.length);
        return statefulBuffer;
    }

    public byte[] marshall(Object object, int[] nArray) {
        MemoryFile memoryFile = new MemoryFile();
        memoryFile.setInitialSize(223);
        memoryFile.setIncrementSizeBy(300);
        this.produceYapClass(this.reflector().forObject(object));
        TransportObjectContainer transportObjectContainer = new TransportObjectContainer(this.config(), this._this, memoryFile);
        transportObjectContainer.i_showInternalClasses = this.i_showInternalClasses;
        transportObjectContainer.set(object);
        nArray[0] = (int)transportObjectContainer.getID(object);
        transportObjectContainer.close();
        return memoryFile.getBytes();
    }

    void message(String string) {
        new Message(this._this, string);
    }

    public void migrateFrom(ObjectContainer objectContainer) {
        if (objectContainer == null) {
            if (this._replicationCallState == 0) {
                return;
            }
            this._replicationCallState = 0;
            if (this.i_handlers.i_migration != null) {
                this.i_handlers.i_migration.terminate();
            }
            this.i_handlers.i_migration = null;
        } else {
            ObjectContainerBase objectContainerBase = (ObjectContainerBase)objectContainer;
            this._replicationCallState = -1;
            objectContainerBase._replicationCallState = -1;
            objectContainerBase.i_handlers.i_migration = this.i_handlers.i_migration = new MigrationConnection(this._this, (ObjectContainerBase)objectContainer);
        }
    }

    public final void needsUpdate(ClassMetadata classMetadata) {
        this.i_needsUpdate = new List4(this.i_needsUpdate, classMetadata);
    }

    public long generateTimeStampId() {
        return this._timeStampIdGenerator.next();
    }

    public abstract int newUserObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peekPersisted(Object object, int n, boolean bl) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            Object object3;
            this.beginTopLevelCall();
            try {
                this.i_justPeeked = null;
                Transaction transaction = bl ? this.i_systemTrans : this.checkTransaction(null);
                Object object4 = null;
                ObjectReference objectReference = this.getYapObject(object);
                if (objectReference != null) {
                    object4 = this.peekPersisted1(transaction, objectReference.getID(), n);
                }
                this.i_justPeeked = null;
                object3 = object4;
                this.endTopLevelCall();
            }
            catch (Throwable throwable) {
                this.endTopLevelCall();
                throw throwable;
            }
            return object3;
        }
    }

    Object peekPersisted1(Transaction transaction, int n, int n2) {
        if (n2 < 0) {
            return null;
        }
        TreeInt treeInt = new TreeInt(n);
        TreeIntObject treeIntObject = (TreeIntObject)Tree.find(this.i_justPeeked, treeInt);
        if (treeIntObject == null) {
            return new ObjectReference(n).read(transaction, null, null, n2, -1, false);
        }
        return treeIntObject._object;
    }

    void peeked(int n, Object object) {
        this.i_justPeeked = Tree.add(this.i_justPeeked, new TreeIntObject(n, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Object object = this.i_lock;
        synchronized (object) {
            this.purge1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.purge1(object);
        }
    }

    final void purge1() {
        this.checkClosed();
        System.gc();
        System.runFinalization();
        System.gc();
        this.gc();
        this._classCollection.purge();
    }

    final void purge1(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof ObjectReference) {
            this.removeReference((ObjectReference)object);
            return;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference != null) {
            this.removeReference(objectReference);
        }
    }

    public final NativeQueryHandler getNativeQueryHandler() {
        if (null == this._nativeQueryHandler) {
            this._nativeQueryHandler = new NativeQueryHandler(this._this);
        }
        return this._nativeQueryHandler;
    }

    public final ObjectSet query(Predicate predicate) {
        return this.query(predicate, (QueryComparator)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectSet query(Predicate predicate, QueryComparator queryComparator) {
        Object object = this.i_lock;
        synchronized (object) {
            return this.getNativeQueryHandler().execute(predicate, queryComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query query() {
        Object object = this.i_lock;
        synchronized (object) {
            return this.query((Transaction)null);
        }
    }

    public final ObjectSet query(Class clazz) {
        return this.get(clazz);
    }

    public final Query query(Transaction transaction) {
        return new QQuery(this.checkTransaction(transaction), null, null);
    }

    public abstract void raiseVersion(long var1);

    public abstract void readBytes(byte[] var1, int var2, int var3);

    public abstract void readBytes(byte[] var1, int var2, int var3, int var4);

    public final Buffer readReaderByAddress(int n, int n2) {
        if (n > 0) {
            Buffer buffer = new Buffer(n2);
            this.readBytes(buffer._buffer, n, n2);
            this.i_handlers.decrypt(buffer);
            return buffer;
        }
        return null;
    }

    public final StatefulBuffer readWriterByAddress(Transaction transaction, int n, int n2) {
        if (n > 0) {
            StatefulBuffer statefulBuffer = this.getWriter(transaction, n, n2);
            statefulBuffer.readEncrypt(this._this, n);
            return statefulBuffer;
        }
        return null;
    }

    public abstract StatefulBuffer readWriterByID(Transaction var1, int var2);

    public abstract Buffer readReaderByID(Transaction var1, int var2);

    public abstract StatefulBuffer[] readWritersByIDs(Transaction var1, int[] var2);

    private void reboot() {
        this.commit();
        int n = this._classCollection.getID();
        this.i_references.stopTimer();
        this.initialize2();
        this._classCollection.setID(n);
        this._classCollection.read(this.i_systemTrans);
    }

    public ReferenceSystem referenceSystem() {
        return this._referenceSystem;
    }

    public GenericReflector reflector() {
        return this.i_handlers._reflector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.i_refreshInsteadOfActivate = true;
            try {
                this.activate1(null, object, n);
            }
            finally {
                this.i_refreshInsteadOfActivate = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refreshClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this._classCollection.refreshClasses();
        }
    }

    public abstract void releaseSemaphore(String var1);

    public void flagAsHandled(ObjectReference objectReference) {
        objectReference.flagAsHandled(this._topLevelCallId);
    }

    boolean flagForDelete(ObjectReference objectReference) {
        if (objectReference == null) {
            return false;
        }
        if (this.handledInCurrentTopLevelCall(objectReference)) {
            return false;
        }
        objectReference.flagForDelete(this._topLevelCallId);
        return true;
    }

    public abstract void releaseSemaphores(Transaction var1);

    void rename(Config4Impl config4Impl) {
        boolean bl = false;
        if (config4Impl.rename() != null) {
            bl = this.rename1(config4Impl);
        }
        this._classCollection.checkChanges();
        if (bl) {
            this.reboot();
        }
    }

    protected boolean rename1(Config4Impl config4Impl) {
        boolean bl = false;
        try {
            Iterator4 iterator4 = config4Impl.rename().iterator();
            while (iterator4.moveNext()) {
                Object object;
                Rename rename = (Rename)iterator4.current();
                if (this.get(rename).size() != 0) continue;
                boolean bl2 = false;
                boolean bl3 = rename.rClass.length() > 0;
                ClassMetadata classMetadata = this._classCollection.getYapClass(bl3 ? rename.rClass : rename.rFrom);
                if (classMetadata != null) {
                    if (bl3) {
                        bl2 = classMetadata.renameField(rename.rFrom, rename.rTo);
                    } else {
                        object = this._classCollection.getYapClass(rename.rTo);
                        if (object == null) {
                            classMetadata.setName(rename.rTo);
                            bl2 = true;
                        } else {
                            this.logMsg(9, "class " + rename.rTo);
                        }
                    }
                }
                if (!bl2) continue;
                bl = true;
                this.setDirtyInSystemTransaction(classMetadata);
                this.logMsg(8, rename.rFrom + " to " + rename.rTo);
                object = this.get(new Rename(rename.rClass, null, rename.rFrom));
                while (object.hasNext()) {
                    this.delete(object.next());
                }
                this.set(rename);
            }
        }
        catch (Throwable throwable) {
            Messages.logErr(this.configImpl(), 10, null, throwable);
        }
        return bl;
    }

    public ReplicationProcess replicationBegin(ObjectContainer objectContainer, ReplicationConflictHandler replicationConflictHandler) {
        return new ReplicationImpl(this._this, objectContainer, replicationConflictHandler);
    }

    public final int oldReplicationHandles(Object object) {
        if (this._replicationCallState != -1) {
            return 0;
        }
        if (this.i_handlers.i_replication == null) {
            return 0;
        }
        if (object instanceof Internal4) {
            return 0;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference != null && this.handledInCurrentTopLevelCall(objectReference)) {
            return objectReference.getID();
        }
        return this.i_handlers.i_replication.tryToHandle(this._this, object);
    }

    public final boolean handledInCurrentTopLevelCall(ObjectReference objectReference) {
        return objectReference.isFlaggedAsHandled(this._topLevelCallId);
    }

    void reserve(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.i_lock;
        synchronized (object) {
            this.rollback1();
            this._referenceSystem.rollback();
        }
    }

    public abstract void rollback1();

    public void send(Object object) {
    }

    public void set(Object object) {
        this.set(object, -2147483548);
    }

    public final void set(Transaction transaction, Object object) {
        this.set(transaction, object, -2147483548);
    }

    public final void set(Object object, int n) {
        this.set(this.i_trans, object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Transaction transaction, Object object, int n) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.setInternal(transaction, object, n, true);
        }
    }

    public final int setInternal(Transaction transaction, Object object, boolean bl) {
        return this.setInternal(transaction, object, -2147483548, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setInternal(Transaction transaction, Object object, int n, boolean bl) {
        if (this.i_config.isReadOnly()) {
            return 0;
        }
        this.beginTopLevelSet();
        try {
            int n2 = this.oldReplicationHandles(object);
            if (n2 != 0) {
                if (n2 < 0) {
                    int n3 = 0;
                    return n3;
                }
                int n4 = n2;
                return n4;
            }
            int n5 = this.setAfterReplication(transaction, object, n, bl);
            return n5;
        }
        finally {
            this.endTopLevelSet(transaction);
        }
    }

    public final int setAfterReplication(Transaction transaction, Object object, int n, boolean bl) {
        Db4oType db4oType;
        if (object instanceof Db4oType && (db4oType = this.db4oTypeStored(transaction, object)) != null) {
            return this.getID1(db4oType);
        }
        try {
            return this.set2(transaction, object, n, bl);
        }
        catch (ObjectNotStorableException objectNotStorableException) {
            throw objectNotStorableException;
        }
        catch (Db4oException db4oException) {
            throw db4oException;
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByNewReplication(Db4oReplicationReferenceProvider db4oReplicationReferenceProvider, Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this._replicationCallState = 1;
            this.i_handlers._replicationReferenceProvider = db4oReplicationReferenceProvider;
            this.set2(this.checkTransaction(null), object, 1, false);
            this._replicationCallState = 0;
            this.i_handlers._replicationReferenceProvider = null;
        }
    }

    private final int set2(Transaction transaction, Object object, int n, boolean bl) {
        int n2 = this.set3(transaction, object, n, bl);
        if (this.stackIsSmall()) {
            this.checkStillToSet();
        }
        return n2;
    }

    public void checkStillToSet() {
        List4 list4 = null;
        while (this.i_stillToSet != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_stillToSet);
            this.i_stillToSet = null;
            while (iterator4Impl.moveNext()) {
                Integer n = (Integer)iterator4Impl.current();
                iterator4Impl.moveNext();
                ObjectReference objectReference = (ObjectReference)iterator4Impl.current();
                iterator4Impl.moveNext();
                Transaction transaction = (Transaction)iterator4Impl.current();
                if (objectReference.continueSet(transaction, n)) continue;
                list4 = new List4(list4, transaction);
                list4 = new List4(list4, objectReference);
                list4 = new List4(list4, n);
            }
        }
        this.i_stillToSet = list4;
    }

    private void notStorable(ReflectClass reflectClass, Object object) {
        if (!this.configImpl().exceptionsOnNotStorable()) {
            return;
        }
    }

    public final int set3(Transaction transaction, Object object, int n, boolean bl) {
        if (object == null || object instanceof TransientClass) {
            return 0;
        }
        if (object instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)object).storedTo(transaction);
        }
        ClassMetadata classMetadata = null;
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference == null) {
            ReflectClass reflectClass = this.reflector().forObject(object);
            if (reflectClass == null) {
                this.notStorable(reflectClass, object);
                return 0;
            }
            classMetadata = this.getActiveYapClass(reflectClass);
            if (classMetadata == null) {
                classMetadata = this.produceYapClass(reflectClass);
                if (classMetadata == null) {
                    this.notStorable(reflectClass, object);
                    return 0;
                }
                objectReference = this.getYapObject(object);
            }
        } else {
            classMetadata = objectReference.getYapClass();
        }
        if (this.isPlainObjectOrPrimitive(classMetadata)) {
            this.notStorable(classMetadata.classReflector(), object);
            return 0;
        }
        if (objectReference == null) {
            if (!this.objectCanNew(classMetadata, object)) {
                return 0;
            }
            objectReference = new ObjectReference();
            objectReference.store(transaction, classMetadata, object);
            this._referenceSystem.addNewReference(objectReference);
            if (object instanceof Db4oTypeImpl) {
                ((Db4oTypeImpl)object).setTrans(transaction);
            }
            if (this.configImpl().messageLevel() > 1) {
                this.message("" + objectReference.getID() + " new " + objectReference.getYapClass().getName());
            }
            this.flagAsHandled(objectReference);
            this.stillToSet(transaction, objectReference, n);
        } else if (this.canUpdate()) {
            if (bl && !objectReference.isNew() && this.handledInCurrentTopLevelCall(objectReference)) {
                return objectReference.getID();
            }
            if (this.updateDepthSufficient(n)) {
                this.flagAsHandled(objectReference);
                objectReference.writeUpdate(transaction, n);
            }
        }
        this.checkNeededUpdates();
        return objectReference.getID();
    }

    private final boolean updateDepthSufficient(int n) {
        return n == -2147483548 || n > 0;
    }

    private final boolean isPlainObjectOrPrimitive(ClassMetadata classMetadata) {
        return classMetadata.getID() == 11 || classMetadata.isPrimitive();
    }

    private boolean objectCanNew(ClassMetadata classMetadata, Object object) {
        return this.callbacks().objectCanNew(object) && classMetadata.dispatchEvent(this._this, object, 8);
    }

    public abstract void setDirtyInSystemTransaction(PersistentBase var1);

    public abstract boolean setSemaphore(String var1, int var2);

    void setStringIo(LatinStringIO latinStringIO) {
        this.i_handlers.i_stringHandler.setStringIo(latinStringIO);
    }

    final boolean showInternalClasses() {
        return this.isServer() || this.i_showInternalClasses > 0;
    }

    public synchronized void showInternalClasses(boolean bl) {
        this.i_showInternalClasses = bl ? ++this.i_showInternalClasses : --this.i_showInternalClasses;
        if (this.i_showInternalClasses < 0) {
            this.i_showInternalClasses = 0;
        }
    }

    private final boolean stackIsSmall() {
        return this._stackDepth < 20;
    }

    boolean stateMessages() {
        return true;
    }

    final List4 stillTo1(List4 list4, Object object, int n, boolean bl) {
        ClassMetadata classMetadata;
        if (object == null || n <= 0) {
            return list4;
        }
        ObjectReference objectReference = this.getYapObject(object);
        if (objectReference != null) {
            if (this.handledInCurrentTopLevelCall(objectReference)) {
                return list4;
            }
            this.flagAsHandled(objectReference);
            return new List4(new List4(list4, new Integer(n)), objectReference);
        }
        ReflectClass reflectClass = this.reflector().forObject(object);
        if (reflectClass.isArray()) {
            if (!reflectClass.getComponentType().isPrimitive()) {
                Object[] objectArray = ArrayHandler.toArray(this._this, object);
                for (int i = 0; i < objectArray.length; ++i) {
                    list4 = this.stillTo1(list4, objectArray[i], n, bl);
                }
            }
        } else if (object instanceof Entry) {
            list4 = this.stillTo1(list4, ((Entry)object).key, n, false);
            list4 = this.stillTo1(list4, ((Entry)object).value, n, false);
        } else if (bl && (classMetadata = this.getYapClass(this.reflector().forObject(object))) != null) {
            classMetadata.deactivate(this.i_trans, object, n);
        }
        return list4;
    }

    public void stillToActivate(Object object, int n) {
        this.i_stillToActivate = this.stillTo1(this.i_stillToActivate, object, n, false);
    }

    public void stillToDeactivate(Object object, int n, boolean bl) {
        this.i_stillToDeactivate = this.stillTo1(this.i_stillToDeactivate, object, n, bl);
    }

    void stillToSet(Transaction transaction, ObjectReference objectReference, int n) {
        if (this.stackIsSmall() && objectReference.continueSet(transaction, n)) {
            return;
        }
        this.i_stillToSet = new List4(this.i_stillToSet, transaction);
        this.i_stillToSet = new List4(this.i_stillToSet, objectReference);
        this.i_stillToSet = new List4(this.i_stillToSet, new Integer(n));
    }

    protected void stopSession() {
        if (this.hasShutDownHook()) {
            Platform4.removeShutDownHook(this, this.i_lock);
        }
        this._classCollection = null;
        this.i_references.stopTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass storedClass(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            this.checkClosed();
            ReflectClass reflectClass = this.configImpl().reflectorFor(object);
            if (reflectClass == null) {
                return null;
            }
            return this.getYapClass(reflectClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredClass[] storedClasses() {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            return this._classCollection.storedClasses();
        }
    }

    public LatinStringIO stringIO() {
        return this.i_handlers.i_stringHandler.i_stringIo;
    }

    public abstract SystemInfo systemInfo();

    public final void beginTopLevelCall() {
        this.checkClosed();
        this.generateCallIDOnTopLevel();
        ++this._stackDepth;
    }

    public final void beginTopLevelSet() {
        this.beginTopLevelCall();
    }

    public final void endTopLevelCall() {
        --this._stackDepth;
        this.generateCallIDOnTopLevel();
    }

    public final void endTopLevelSet(Transaction transaction) {
        this.endTopLevelCall();
        if (this._stackDepth == 0) {
            transaction.processDeletes();
        }
    }

    private final void generateCallIDOnTopLevel() {
        if (this._stackDepth == 0) {
            this._topLevelCallId = this._topLevelCallIdGenerator.next();
        }
    }

    public int stackDepth() {
        return this._stackDepth;
    }

    public void stackDepth(int n) {
        this._stackDepth = n;
    }

    public int topLevelCallId() {
        return this._topLevelCallId;
    }

    public void topLevelCallId(int n) {
        this._topLevelCallId = n;
    }

    public Object unmarshall(StatefulBuffer statefulBuffer) {
        return this.unmarshall(statefulBuffer._buffer, statefulBuffer.getID());
    }

    public Object unmarshall(byte[] byArray, int n) {
        MemoryFile memoryFile = new MemoryFile(byArray);
        TransportObjectContainer transportObjectContainer = new TransportObjectContainer(this.configure(), this._this, memoryFile);
        Object object = transportObjectContainer.getByID(n);
        transportObjectContainer.activate(object, Integer.MAX_VALUE);
        transportObjectContainer.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long version() {
        Object object = this.i_lock;
        synchronized (object) {
            return this.currentVersion();
        }
    }

    public abstract void write(boolean var1);

    public abstract void writeDirty();

    public abstract void writeEmbedded(StatefulBuffer var1, StatefulBuffer var2);

    public abstract void writeNew(ClassMetadata var1, StatefulBuffer var2);

    public abstract void writeTransactionPointer(int var1);

    public abstract void writeUpdate(ClassMetadata var1, StatefulBuffer var2);

    public final void removeReference(ObjectReference objectReference) {
        this._referenceSystem.removeReference(objectReference);
        objectReference.setID(-1);
        Platform4.killYapRef(objectReference.getObjectReference());
    }

    private static ObjectContainerBase cast(PartialObjectContainer partialObjectContainer) {
        return (ObjectContainerBase)partialObjectContainer;
    }

    public Callbacks callbacks() {
        return this._callbacks;
    }

    public void callbacks(Callbacks callbacks) {
        if (callbacks == null) {
            throw new IllegalArgumentException();
        }
        this._callbacks = callbacks;
    }

    public Config4Impl configImpl() {
        return this.i_config;
    }

    public UUIDFieldMetadata getUUIDIndex() {
        return this.i_handlers.i_indexes.i_fieldUUID;
    }

    public VersionFieldMetadata getVersionIndex() {
        return this.i_handlers.i_indexes.i_fieldVersion;
    }

    public ClassMetadataRepository classCollection() {
        return this._classCollection;
    }

    public ClassInfoHelper getClassMetaHelper() {
        return this._classMetaHelper;
    }

    public abstract long[] getIDsForClass(Transaction var1, ClassMetadata var2);

    public abstract QueryResult classOnlyQuery(Transaction var1, ClassMetadata var2);

    public abstract QueryResult executeQuery(QQuery var1);

    public void replicationCallState(int n) {
        this._replicationCallState = n;
    }
}

