/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Queue4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;

class PendingClassInits {
    private final Transaction _systemTransaction;
    private Collection4 _pending = new Collection4();
    private Queue4 _members = new Queue4();
    private Queue4 _statics = new Queue4();
    private Queue4 _writes = new Queue4();
    private Queue4 _inits = new Queue4();
    private boolean _running = false;

    PendingClassInits(Transaction transaction) {
        this._systemTransaction = transaction;
    }

    void process(ClassMetadata classMetadata) {
        if (this._pending.contains(classMetadata)) {
            return;
        }
        ClassMetadata classMetadata2 = classMetadata.getAncestor();
        if (classMetadata2 != null) {
            this.process(classMetadata2);
        }
        this._pending.add(classMetadata);
        this._members.add(classMetadata);
        if (this._running) {
            return;
        }
        this._running = true;
        this.checkInits();
        this._pending = new Collection4();
        this._running = false;
    }

    private void checkMembers() {
        while (this._members.hasNext()) {
            ClassMetadata classMetadata = (ClassMetadata)this._members.next();
            classMetadata.addMembers(this.stream());
            this._statics.add(classMetadata);
        }
    }

    private ObjectContainerBase stream() {
        return this._systemTransaction.stream();
    }

    private void checkStatics() {
        this.checkMembers();
        while (this._statics.hasNext()) {
            ClassMetadata classMetadata = (ClassMetadata)this._statics.next();
            classMetadata.storeStaticFieldValues(this._systemTransaction, true);
            this._writes.add(classMetadata);
            this.checkMembers();
        }
    }

    private void checkWrites() {
        this.checkStatics();
        while (this._writes.hasNext()) {
            ClassMetadata classMetadata = (ClassMetadata)this._writes.next();
            classMetadata.setStateDirty();
            classMetadata.write(this._systemTransaction);
            this._inits.add(classMetadata);
            this.checkStatics();
        }
    }

    private void checkInits() {
        this.checkWrites();
        while (this._inits.hasNext()) {
            ClassMetadata classMetadata = (ClassMetadata)this._inits.next();
            classMetadata.initConfigOnUp(this._systemTransaction);
            this.checkWrites();
        }
    }
}

