/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.BlobTransport;
import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oException;
import com.db4o.ext.ExtClient;
import com.db4o.ext.ObjectNotStorableException;
import com.db4o.ext.SystemInfo;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Lock4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.network.LoopbackSocket;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.UnicodeStringIO;
import com.db4o.internal.cs.BlobProcessor;
import com.db4o.internal.cs.ClassInfo;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ClientQueryResult;
import com.db4o.internal.cs.ClientTransaction;
import com.db4o.internal.cs.LazyClientQueryResult;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgBlob;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.AbstractQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.reflect.ReflectClass;
import java.io.File;
import java.io.IOException;

public class ClientObjectContainer
extends ObjectContainerBase
implements ExtClient,
BlobTransport {
    final Object blobLock = new Object();
    private BlobProcessor blobThread;
    private Socket4 i_socket;
    Queue4 messageQueue = new Queue4();
    final Lock4 messageQueueLock = new Lock4();
    private String password;
    int[] _prefetchedIDs;
    private ClientMessageDispatcher _readerThread;
    int remainingIDs;
    private String switchedToFile;
    private boolean _singleThreaded;
    private String userName;
    private Db4oDatabase i_db;
    protected boolean _doFinalize = true;
    private int _blockSize = 1;
    private Collection4 _batchedMessages = new Collection4();
    private int _batchedQueueLength = 4;

    private ClientObjectContainer(Configuration configuration) {
        super(configuration, null);
    }

    public ClientObjectContainer(String string) {
        this(Db4o.cloneConfiguration());
        Object object = this.lock();
        synchronized (object) {
            this._singleThreaded = this.configImpl().singleThreadedClient();
            throw new RuntimeException("This constructor is for Debug.fakeServer use only.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientObjectContainer(Configuration configuration, Socket4 socket4, String string, String string2, boolean bl) throws IOException {
        this(configuration);
        Object object = this.lock();
        synchronized (object) {
            this._singleThreaded = this.configImpl().singleThreadedClient();
            if (string2 == null) {
                throw new NullPointerException(Messages.get(56));
            }
            if (!bl) {
                string2 = null;
            }
            this.userName = string;
            this.password = string2;
            this.i_socket = socket4;
            try {
                this.loginToServer(socket4);
            }
            catch (IOException iOException) {
                this.stopSession();
                throw iOException;
            }
            if (!this._singleThreaded) {
                this.startReaderThread(socket4, string);
            }
            this.logMsg(36, this.toString());
            this.readThis();
            this.initialize3();
            Platform4.postOpen(this);
        }
    }

    private void startReaderThread(Socket4 socket4, String string) {
        this._readerThread = new ClientMessageDispatcher(this, socket4, this.messageQueue, this.messageQueueLock);
        this._readerThread.setName("db4o message client for user " + string);
        this._readerThread.start();
    }

    public void backup(String string) throws IOException {
        Exceptions4.throwRuntimeException(60);
    }

    public void blockSize(int n) {
        this._blockSize = n;
    }

    public byte blockSize() {
        return (byte)this._blockSize;
    }

    protected boolean close2() {
        if (this._readerThread == null || this._readerThread.isClosed()) {
            return super.close2();
        }
        try {
            this.writeMsg(Msg.COMMIT_OK, true);
            this.expectedResponse(Msg.OK);
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        try {
            this.writeMsg(Msg.CLOSE, true);
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        try {
            if (!this._singleThreaded) {
                this._readerThread.close();
            }
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        try {
            this.i_socket.close();
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
        }
        boolean bl = super.close2();
        return bl;
    }

    public final void commit1() {
        this.i_trans.commit();
    }

    public int converterVersion() {
        return 6;
    }

    Socket4 createParalellSocket() throws IOException {
        this.writeMsg(Msg.GET_THREAD_ID, true);
        int n = this.expectedByteResponse(Msg.ID_LIST).readInt();
        Socket4 socket4 = this.i_socket.openParalellSocket();
        if (!(this.i_socket instanceof LoopbackSocket)) {
            this.loginToServer(socket4);
        }
        if (this.switchedToFile != null) {
            MsgD msgD = Msg.SWITCH_TO_FILE.getWriterForString(this.i_systemTrans, this.switchedToFile);
            msgD.write(this, socket4);
            if (!Msg.OK.equals(Msg.readMessage(this.i_systemTrans, socket4))) {
                throw new IOException(Messages.get(42));
            }
        }
        Msg.USE_TRANSACTION.getWriterForInt(this.i_trans, n).write(this, socket4);
        return socket4;
    }

    public AbstractQueryResult newQueryResult(Transaction transaction, QueryEvaluationMode queryEvaluationMode) {
        throw new IllegalStateException();
    }

    public final Transaction newTransaction(Transaction transaction) {
        return new ClientTransaction(this, transaction);
    }

    public boolean createYapClass(ClassMetadata classMetadata, ReflectClass reflectClass, ClassMetadata classMetadata2) {
        this.writeMsg(Msg.CREATE_CLASS.getWriterForString(this.i_systemTrans, reflectClass.getName()), true);
        Msg msg = this.getResponse();
        if (msg == null) {
            return false;
        }
        if (msg.equals(Msg.FAILED)) {
            this.sendClassMeta(reflectClass);
            msg = this.getResponse();
        }
        if (msg.equals(Msg.FAILED)) {
            if (this.configImpl().exceptionsOnNotStorable()) {
                throw new ObjectNotStorableException(reflectClass);
            }
            return false;
        }
        if (!msg.equals(Msg.OBJECT_TO_CLIENT)) {
            return false;
        }
        MsgObject msgObject = (MsgObject)msg;
        StatefulBuffer statefulBuffer = msgObject.unmarshall();
        if (statefulBuffer == null) {
            return false;
        }
        statefulBuffer.setTransaction(this.getSystemTransaction());
        if (!super.createYapClass(classMetadata, reflectClass, classMetadata2)) {
            return false;
        }
        classMetadata.setID(msgObject.getId());
        classMetadata.readName1(this.getSystemTransaction(), statefulBuffer);
        this.classCollection().addYapClass(classMetadata);
        this.classCollection().readYapClass(classMetadata, reflectClass);
        return true;
    }

    private void sendClassMeta(ReflectClass reflectClass) {
        ClassInfo classInfo = this._classMetaHelper.getClassMeta(reflectClass);
        this.writeMsg(Msg.CLASS_META.getWriter(this.marshall(this.i_systemTrans, classInfo)), true);
    }

    public long currentVersion() {
        this.writeMsg(Msg.CURRENT_VERSION, true);
        return ((MsgD)this.expectedResponse(Msg.ID_LIST)).readLong();
    }

    public final boolean delete4(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        MsgD msgD = Msg.DELETE.getWriterForInts(this.i_trans, new int[]{objectReference.getID(), bl ? 1 : 0});
        this.writeMsg(msgD, false);
        return true;
    }

    public boolean detectSchemaChanges() {
        return false;
    }

    protected boolean doFinalize() {
        return this._doFinalize;
    }

    final Buffer expectedByteResponse(Msg msg) {
        Msg msg2 = this.expectedResponse(msg);
        if (msg2 == null) {
            return null;
        }
        return msg2.getByteLoad();
    }

    final Msg expectedResponse(Msg msg) {
        Msg msg2 = this.getResponse();
        if (msg.equals(msg2)) {
            return msg2;
        }
        return null;
    }

    public AbstractQueryResult getAll(Transaction transaction) {
        int n = this.config().queryEvaluationMode().asInt();
        MsgD msgD = Msg.GET_ALL.getWriterForInt(transaction, n);
        this.writeMsg(msgD, true);
        return this.readQueryResult(transaction);
    }

    Msg getResponse() {
        return this._singleThreaded ? this.getResponseSingleThreaded() : this.getResponseMultiThreaded();
    }

    private Msg getResponseMultiThreaded() {
        try {
            return (Msg)this.messageQueueLock.run(new Closure4(){

                public Object run() {
                    Msg msg = this.retrieveMessage();
                    if (msg != null) {
                        return msg;
                    }
                    this.throwOnClosed();
                    ClientObjectContainer.this.messageQueueLock.snooze(ClientObjectContainer.this.timeout());
                    this.throwOnClosed();
                    return this.retrieveMessage();
                }

                private void throwOnClosed() {
                    if (ClientObjectContainer.this._readerThread.isClosed()) {
                        ClientObjectContainer.this._doFinalize = false;
                        throw new Db4oException(Messages.get(20));
                    }
                }

                private Msg retrieveMessage() {
                    Msg msg = null;
                    msg = (Msg)ClientObjectContainer.this.messageQueue.next();
                    if (msg != null && Msg.ERROR.equals(msg)) {
                        throw new Db4oException("Client connection error");
                    }
                    return msg;
                }
            });
        }
        catch (Exception exception) {
            Exceptions4.catchAllExceptDb4oException(exception);
            return null;
        }
    }

    private Msg getResponseSingleThreaded() {
        while (this.i_socket != null) {
            try {
                Msg msg = Msg.readMessage(this.i_trans, this.i_socket);
                if (Msg.PING.equals(msg)) {
                    this.writeMsg(Msg.OK, true);
                    continue;
                }
                if (Msg.CLOSE.equals(msg)) {
                    this.logMsg(35, this.toString());
                    this.close();
                    return null;
                }
                if (msg == null) continue;
                return msg;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public ClassMetadata getYapClass(int n) {
        ReflectClass reflectClass;
        if (n == 0) {
            return null;
        }
        ClassMetadata classMetadata = super.getYapClass(n);
        if (classMetadata != null) {
            return classMetadata;
        }
        MsgD msgD = Msg.CLASS_NAME_FOR_ID.getWriterForInt(this.i_systemTrans, n);
        this.writeMsg(msgD, true);
        MsgD msgD2 = (MsgD)this.expectedResponse(Msg.CLASS_NAME_FOR_ID);
        String string = msgD2.readString();
        if (string != null && string.length() > 0 && (reflectClass = this.reflector().forName(string)) != null) {
            return this.produceYapClass(reflectClass);
        }
        return null;
    }

    public boolean needsLockFileThread() {
        return false;
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Db4oDatabase identity() {
        if (this.i_db == null) {
            this.writeMsg(Msg.IDENTITY, true);
            Buffer buffer = this.expectedByteResponse(Msg.ID_LIST);
            this.showInternalClasses(true);
            try {
                this.i_db = (Db4oDatabase)this.getByID(buffer.readInt());
                this.activate1(this.i_systemTrans, this.i_db, 3);
            }
            finally {
                this.showInternalClasses(false);
            }
        }
        return this.i_db;
    }

    public boolean isClient() {
        return true;
    }

    void loginToServer(Socket4 socket4) throws IOException {
        if (this.password != null) {
            UnicodeStringIO unicodeStringIO = new UnicodeStringIO();
            int n = unicodeStringIO.length(this.userName) + unicodeStringIO.length(this.password);
            MsgD msgD = Msg.LOGIN.getWriterForLength(this.i_systemTrans, n);
            msgD.writeString(this.userName);
            msgD.writeString(this.password);
            msgD.write(this, socket4);
            Msg msg = Msg.readMessage(this.i_systemTrans, socket4);
            if (!Msg.LOGIN_OK.equals(msg)) {
                throw new IOException(Messages.get(42));
            }
            StatefulBuffer statefulBuffer = msg.payLoad();
            this._blockSize = statefulBuffer.readInt();
            int n2 = statefulBuffer.readInt();
            if (n2 == 0) {
                this.i_handlers.oldEncryptionOff();
            }
        }
    }

    public boolean maintainsIndices() {
        return false;
    }

    public final int newUserObject() {
        int n = this.config().prefetchIDCount();
        this.ensureIDCacheAllocated(n);
        Buffer buffer = null;
        if (this.remainingIDs < 1) {
            MsgD msgD = Msg.PREFETCH_IDS.getWriterForInt(this.i_trans, n);
            this.writeMsg(msgD, true);
            buffer = this.expectedByteResponse(Msg.ID_LIST);
            for (int i = n - 1; i >= 0; --i) {
                this._prefetchedIDs[i] = buffer.readInt();
            }
            this.remainingIDs = n;
        }
        --this.remainingIDs;
        return this._prefetchedIDs[this.remainingIDs];
    }

    public int prefetchObjects(IntIterator4 intIterator4, Object[] objectArray, int n) {
        Object object;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        while (n2 < n && intIterator4.moveNext()) {
            int n4 = intIterator4.currentInt();
            if (n4 <= 0) continue;
            object = this.objectForIDFromCache(n4);
            if (object != null) {
                objectArray[n2] = object;
            } else {
                nArray[n3] = n4;
                nArray2[n3] = n2;
                ++n3;
            }
            ++n2;
        }
        if (n3 > 0) {
            MsgD msgD = Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(this.i_trans, nArray, n3);
            this.writeMsg(msgD, true);
            object = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
            int n5 = ((MsgD)object).readInt();
            for (int i = 0; i < n5; ++i) {
                MsgObject msgObject = (MsgObject)Msg.OBJECT_TO_CLIENT.clone(this.getTransaction());
                msgObject.payLoad(((MsgD)object).payLoad().readYapBytes());
                if (msgObject.payLoad() == null) continue;
                msgObject.payLoad().incrementOffset(9);
                StatefulBuffer statefulBuffer = msgObject.unmarshall(9);
                Object object2 = this.objectForIDFromCache(nArray[i]);
                objectArray[nArray2[i]] = object2 != null ? object2 : new ObjectReference(nArray[i]).readPrefetch(this, statefulBuffer);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processBlobMessage(MsgBlob msgBlob) {
        Object object = this.blobLock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = this.blobThread == null || this.blobThread.isTerminated();
            if (bl) {
                this.blobThread = new BlobProcessor(this);
            }
            this.blobThread.add(msgBlob);
            if (bl) {
                this.blobThread.start();
            }
        }
    }

    public void raiseVersion(long l) {
        this.writeMsg(Msg.RAISE_VERSION.getWriterForLong(this.i_trans, l), true);
    }

    public void readBytes(byte[] byArray, int n, int n2, int n3) {
        throw Exceptions4.virtualException();
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        MsgD msgD = Msg.READ_BYTES.getWriterForInts(this.i_trans, new int[]{n, n2});
        this.writeMsg(msgD, true);
        Buffer buffer = this.expectedByteResponse(Msg.READ_BYTES);
        System.arraycopy(buffer._buffer, 0, byArray, 0, n2);
    }

    protected boolean rename1(Config4Impl config4Impl) {
        this.logMsg(58, null);
        return false;
    }

    public final StatefulBuffer readWriterByID(Transaction transaction, int n) {
        try {
            MsgD msgD = Msg.READ_OBJECT.getWriterForInt(transaction, n);
            this.writeMsg(msgD, true);
            StatefulBuffer statefulBuffer = ((MsgObject)this.expectedResponse(Msg.OBJECT_TO_CLIENT)).unmarshall();
            if (statefulBuffer == null) {
                return null;
            }
            statefulBuffer.setTransaction(transaction);
            return statefulBuffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final StatefulBuffer[] readWritersByIDs(Transaction transaction, int[] nArray) {
        try {
            MsgD msgD = Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(transaction, nArray, nArray.length);
            this.writeMsg(msgD, true);
            MsgD msgD2 = (MsgD)this.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
            int n = msgD2.readInt();
            StatefulBuffer[] statefulBufferArray = new StatefulBuffer[n];
            for (int i = 0; i < n; ++i) {
                MsgObject msgObject = (MsgObject)Msg.OBJECT_TO_CLIENT.clone(this.getTransaction());
                msgObject.payLoad(msgD2.payLoad().readYapBytes());
                if (msgObject.payLoad() == null) continue;
                msgObject.payLoad().incrementOffset(9);
                statefulBufferArray[i] = msgObject.unmarshall(9);
                statefulBufferArray[i].setTransaction(transaction);
            }
            return statefulBufferArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final Buffer readReaderByID(Transaction transaction, int n) {
        return this.readWriterByID(transaction, n);
    }

    private AbstractQueryResult readQueryResult(Transaction transaction) {
        AbstractQueryResult abstractQueryResult = null;
        Buffer buffer = this.expectedByteResponse(Msg.QUERY_RESULT);
        int n = buffer.readInt();
        abstractQueryResult = n > 0 ? new LazyClientQueryResult(transaction, this, n) : new ClientQueryResult(transaction);
        ((AbstractQueryResult)abstractQueryResult).loadFromIdReader(buffer);
        return abstractQueryResult;
    }

    void readThis() {
        this.writeMsg(Msg.GET_CLASSES.getWriter(this.i_systemTrans), true);
        Buffer buffer = this.expectedByteResponse(Msg.GET_CLASSES);
        this.classCollection().setID(buffer.readInt());
        this.createStringIO(buffer.readByte());
        this.classCollection().read(this.i_systemTrans);
        this.classCollection().refreshClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSemaphore(String string) {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            this.writeMsg(Msg.RELEASE_SEMAPHORE.getWriterForString(this.i_trans, string), true);
        }
    }

    public void releaseSemaphores(Transaction transaction) {
    }

    private void reReadAll(Configuration configuration) {
        this.remainingIDs = 0;
        this.initialize1(configuration);
        this.initializeTransactions();
        this.readThis();
    }

    public final void rollback1() {
        if (this.i_config.batchMessages()) {
            this.clearBatchedObjects();
        }
        this.writeMsg(Msg.ROLLBACK, true);
        this.i_trans.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object object) {
        Object object2 = this.i_lock;
        synchronized (object2) {
            if (object != null) {
                this.writeMsg(Msg.USER_MESSAGE.getWriter(this.marshall(this.i_trans, object)), true);
            }
        }
    }

    public final void setDirtyInSystemTransaction(PersistentBase persistentBase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSemaphore(String string, int n) {
        Object object = this.i_lock;
        synchronized (object) {
            this.checkClosed();
            if (string == null) {
                throw new NullPointerException();
            }
            MsgD msgD = Msg.SET_SEMAPHORE.getWriterForIntString(this.i_trans, n, string);
            this.writeMsg(msgD, true);
            Msg msg = this.getResponse();
            return msg.equals(Msg.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToFile(String string) {
        Object object = this.i_lock;
        synchronized (object) {
            this.commit();
            MsgD msgD = Msg.SWITCH_TO_FILE.getWriterForString(this.i_trans, string);
            this.writeMsg(msgD, true);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToMainFile() {
        Object object = this.i_lock;
        synchronized (object) {
            this.commit();
            this.writeMsg(Msg.SWITCH_TO_MAIN_FILE, true);
            this.expectedResponse(Msg.OK);
            this.reReadAll(Db4o.cloneConfiguration());
            this.switchedToFile = null;
        }
    }

    public String name() {
        return this.toString();
    }

    public String toString() {
        return "Client Connection " + this.userName;
    }

    public void write(boolean bl) {
    }

    public final void writeDirty() {
    }

    public final void writeEmbedded(StatefulBuffer statefulBuffer, StatefulBuffer statefulBuffer2) {
        statefulBuffer.addEmbedded(statefulBuffer2);
    }

    final void writeMsg(Msg msg) {
        msg.write(this, this.i_socket);
    }

    final void writeMsg(Msg msg, boolean bl) {
        if (this.i_config.batchMessages()) {
            if (bl && this._batchedMessages.isEmpty()) {
                this.writeMsg(msg);
            } else {
                this.addToBatch(msg);
                if (bl || this._batchedQueueLength > this.i_config.maxBatchQueueSize()) {
                    this.writeBatchedMessages();
                }
            }
        } else {
            this.writeMsg(msg);
        }
    }

    public final void writeNew(ClassMetadata classMetadata, StatefulBuffer statefulBuffer) {
        MsgD msgD = Msg.WRITE_NEW.getWriter(classMetadata, statefulBuffer);
        this.writeMsg(msgD, false);
    }

    public final void writeTransactionPointer(int n) {
    }

    public final void writeUpdate(ClassMetadata classMetadata, StatefulBuffer statefulBuffer) {
        MsgD msgD = Msg.WRITE_UPDATE.getWriter(classMetadata, statefulBuffer);
        this.writeMsg(msgD, false);
    }

    public boolean isAlive() {
        try {
            this.writeMsg(Msg.PING, true);
            return this.expectedResponse(Msg.OK) != null;
        }
        catch (Db4oException db4oException) {
            return false;
        }
    }

    public Socket4 socket() {
        return this.i_socket;
    }

    private void ensureIDCacheAllocated(int n) {
        if (this._prefetchedIDs == null) {
            this._prefetchedIDs = new int[n];
            return;
        }
        if (n > this._prefetchedIDs.length) {
            int[] nArray = new int[n];
            System.arraycopy(this._prefetchedIDs, 0, nArray, 0, this._prefetchedIDs.length);
            this._prefetchedIDs = nArray;
        }
    }

    public SystemInfo systemInfo() {
        throw new NotImplementedException("Functionality not availble on clients.");
    }

    public void writeBlobTo(Transaction transaction, BlobImpl blobImpl, File file) throws IOException {
        MsgBlob msgBlob = (MsgBlob)Msg.READ_BLOB.getWriterForInt(transaction, (int)this.getID(blobImpl));
        msgBlob._blob = blobImpl;
        this.processBlobMessage(msgBlob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlobFrom(Transaction transaction, BlobImpl blobImpl, File file) throws IOException {
        MsgBlob msgBlob = null;
        Object object = this.lock();
        synchronized (object) {
            this.set(blobImpl);
            int n = (int)this.getID(blobImpl);
            msgBlob = (MsgBlob)Msg.WRITE_BLOB.getWriterForInt(transaction, n);
            msgBlob._blob = blobImpl;
            blobImpl.setStatus(-3.0);
        }
        this.processBlobMessage(msgBlob);
    }

    public long[] getIDsForClass(Transaction transaction, ClassMetadata classMetadata) {
        MsgD msgD = Msg.GET_INTERNAL_IDS.getWriterForInt(transaction, classMetadata.getID());
        this.writeMsg(msgD, true);
        Buffer buffer = this.expectedByteResponse(Msg.ID_LIST);
        int n = buffer.readInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = buffer.readInt();
        }
        return lArray;
    }

    public QueryResult classOnlyQuery(Transaction transaction, ClassMetadata classMetadata) {
        long[] lArray = classMetadata.getIDs(transaction);
        ClientQueryResult clientQueryResult = new ClientQueryResult(transaction, lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            clientQueryResult.add((int)lArray[i]);
        }
        return clientQueryResult;
    }

    public QueryResult executeQuery(QQuery qQuery) {
        Transaction transaction = qQuery.getTransaction();
        qQuery.evaluationMode(this.config().queryEvaluationMode());
        qQuery.marshall();
        MsgD msgD = Msg.QUERY_EXECUTE.getWriter(this.marshall(transaction, qQuery));
        this.writeMsg(msgD, true);
        return this.readQueryResult(transaction);
    }

    public final void writeBatchedMessages() {
        if (this._batchedMessages.isEmpty()) {
            return;
        }
        MsgD msgD = Msg.WRITE_BATCHED_MESSAGES.getWriterForLength(this.getTransaction(), this._batchedQueueLength);
        msgD.writeInt(this._batchedMessages.size());
        Iterator4 iterator4 = this._batchedMessages.iterator();
        while (iterator4.moveNext()) {
            Msg msg = (Msg)iterator4.current();
            if (msg == null) {
                msgD.writeInt(0);
                continue;
            }
            msgD.writeInt(msg.payLoad().getLength());
            msgD.payLoad().append(msg.payLoad()._buffer);
        }
        this.writeMsg(msgD);
        this.clearBatchedObjects();
    }

    public final void addToBatch(Msg msg) {
        this._batchedMessages.add(msg);
        this._batchedQueueLength += 4 + msg.payLoad().getLength();
    }

    private final void clearBatchedObjects() {
        this._batchedMessages.clear();
        this._batchedQueueLength = 4;
    }

    private int timeout() {
        return this.isEmbeddedClient() ? 300000 : this.configImpl().timeoutClientSocket();
    }

    private boolean isEmbeddedClient() {
        return this.i_socket instanceof LoopbackSocket;
    }
}

