/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.fieldindex.FieldIndexProcessorResult;
import com.db4o.internal.fieldindex.IndexedNode;
import com.db4o.internal.fieldindex.IndexedNodeCollector;
import com.db4o.internal.query.processor.QCandidates;

public class FieldIndexProcessor {
    private final QCandidates _candidates;

    public FieldIndexProcessor(QCandidates qCandidates) {
        this._candidates = qCandidates;
    }

    public FieldIndexProcessorResult run() {
        IndexedNode indexedNode = this.selectBestIndex();
        if (null == indexedNode) {
            return FieldIndexProcessorResult.NO_INDEX_FOUND;
        }
        if (indexedNode.resultSize() > 0) {
            IndexedNode indexedNode2 = this.resolveFully(indexedNode);
            if (null == indexedNode2) {
                return FieldIndexProcessorResult.NO_INDEX_FOUND;
            }
            return new FieldIndexProcessorResult(indexedNode2);
        }
        return FieldIndexProcessorResult.FOUND_INDEX_BUT_NO_MATCH;
    }

    private IndexedNode resolveFully(IndexedNode indexedNode) {
        if (null == indexedNode) {
            return null;
        }
        if (indexedNode.isResolved()) {
            return indexedNode;
        }
        return this.resolveFully(indexedNode.resolve());
    }

    public IndexedNode selectBestIndex() {
        Iterator4 iterator4 = this.collectIndexedNodes();
        if (!iterator4.moveNext()) {
            return null;
        }
        IndexedNode indexedNode = (IndexedNode)iterator4.current();
        while (iterator4.moveNext()) {
            IndexedNode indexedNode2 = (IndexedNode)iterator4.current();
            if (indexedNode2.resultSize() >= indexedNode.resultSize()) continue;
            indexedNode = indexedNode2;
        }
        return indexedNode;
    }

    public Iterator4 collectIndexedNodes() {
        return new IndexedNodeCollector(this._candidates).getNodes();
    }
}

