/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Comparable4;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.Null;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.handlers.BuiltinTypeHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.StringMarshaller;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.slots.Slot;
import com.db4o.reflect.ReflectClass;

public final class StringHandler
extends BuiltinTypeHandler {
    public LatinStringIO i_stringIo;
    private Buffer i_compareTo;

    public StringHandler(ObjectContainerBase objectContainerBase, LatinStringIO latinStringIO) {
        super(objectContainerBase);
        this.i_stringIo = latinStringIO;
    }

    public boolean canHold(ReflectClass reflectClass) {
        return reflectClass.equals(this.classReflector());
    }

    public void cascadeActivation(Transaction transaction, Object object, int n, boolean bl) {
    }

    public ReflectClass classReflector() {
        return this._stream.i_handlers.ICLASS_STRING;
    }

    public Object comparableObject(Transaction transaction, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return object;
        }
        Slot slot = (Slot)object;
        return transaction.stream().readReaderByAddress(slot._address, slot._length);
    }

    public void deleteEmbedded(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) {
        int n = statefulBuffer.readInt();
        int n2 = statefulBuffer.readInt();
        if (n > 0 && !marshallerFamily._string.inlinedStrings()) {
            statefulBuffer.getTransaction().slotFreeOnCommit(n, n, n2);
        }
    }

    public boolean isEqual(TypeHandler4 typeHandler4) {
        return this == typeHandler4;
    }

    public int getID() {
        return 9;
    }

    byte getIdentifier() {
        return 83;
    }

    public ClassMetadata getYapClass(ObjectContainerBase objectContainerBase) {
        return objectContainerBase.i_handlers.primitiveClassById(this.getID());
    }

    public Object indexEntryToObject(Transaction transaction, Object object) {
        try {
            return StringMarshaller.readShort(this._stream, (Buffer)object);
        }
        catch (CorruptionException corruptionException) {
            return null;
        }
    }

    public boolean indexNullHandling() {
        return true;
    }

    public TernaryBool isSecondClass() {
        return TernaryBool.YES;
    }

    public void calculateLengths(Transaction transaction, ObjectHeaderAttributes objectHeaderAttributes, boolean bl, Object object, boolean bl2) {
        MarshallerFamily.current()._string.calculateLengths(transaction, objectHeaderAttributes, bl, object, bl2);
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._string.readFromParentSlot(statefulBuffer.getStream(), statefulBuffer, bl);
    }

    public TypeHandler4 readArrayHandler(Transaction transaction, MarshallerFamily marshallerFamily, Buffer[] bufferArray) {
        return null;
    }

    public void readCandidates(MarshallerFamily marshallerFamily, Buffer buffer, QCandidates qCandidates) {
    }

    public QCandidate readSubCandidate(MarshallerFamily marshallerFamily, Buffer buffer, QCandidates qCandidates, boolean bl) {
        try {
            Object object = null;
            object = bl ? this.readQuery(qCandidates.i_trans, marshallerFamily, bl, buffer, true) : marshallerFamily._string.read(this._stream, buffer);
            if (object != null) {
                return new QCandidate(qCandidates, object, 0, true);
            }
        }
        catch (CorruptionException corruptionException) {
            // empty catch block
        }
        return null;
    }

    public Object readIndexEntry(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer) throws CorruptionException {
        return marshallerFamily._string.readIndexEntry(statefulBuffer);
    }

    public Object readIndexEntry(Buffer buffer) {
        Slot slot = new Slot(buffer.readInt(), buffer.readInt());
        if (this.isInvalidSlot(slot)) {
            return null;
        }
        return slot;
    }

    private boolean isInvalidSlot(Slot slot) {
        return slot._address == 0 && slot._length == 0;
    }

    public Object readQuery(Transaction transaction, MarshallerFamily marshallerFamily, boolean bl, Buffer buffer, boolean bl2) throws CorruptionException {
        if (!bl) {
            return marshallerFamily._string.read(transaction.stream(), buffer);
        }
        Buffer buffer2 = marshallerFamily._string.readSlotFromParentSlot(transaction.stream(), buffer);
        if (bl2 && buffer2 != null) {
            return marshallerFamily._string.readFromOwnSlot(transaction.stream(), buffer2);
        }
        return buffer2;
    }

    public void setStringIo(LatinStringIO latinStringIO) {
        this.i_stringIo = latinStringIO;
    }

    public boolean supportsIndex() {
        return true;
    }

    public void writeIndexEntry(Buffer buffer, Object object) {
        if (object == null) {
            buffer.writeInt(0);
            buffer.writeInt(0);
            return;
        }
        if (object instanceof StatefulBuffer) {
            StatefulBuffer statefulBuffer = (StatefulBuffer)object;
            buffer.writeInt(statefulBuffer.getAddress());
            buffer.writeInt(statefulBuffer.getLength());
            return;
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            buffer.writeInt(slot._address);
            buffer.writeInt(slot._length);
            return;
        }
        throw new IllegalArgumentException();
    }

    public Object writeNew(MarshallerFamily marshallerFamily, Object object, boolean bl, StatefulBuffer statefulBuffer, boolean bl2, boolean bl3) {
        return marshallerFamily._string.writeNew(object, bl, statefulBuffer, bl2);
    }

    public final void writeShort(String string, Buffer buffer) {
        if (string == null) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(string.length());
            this.i_stringIo.write(buffer, string);
        }
    }

    public int getTypeID() {
        return 1;
    }

    private Buffer val(Object object) {
        if (object instanceof Buffer) {
            return (Buffer)object;
        }
        if (object instanceof String) {
            return StringMarshaller.writeShort(this._stream, (String)object);
        }
        if (object instanceof Slot) {
            Slot slot = (Slot)object;
            return this._stream.readReaderByAddress(slot._address, slot._length);
        }
        return null;
    }

    public void prepareComparison(Transaction transaction, Object object) {
        this.i_compareTo = (Buffer)object;
    }

    public Comparable4 prepareComparison(Object object) {
        if (object == null) {
            this.i_compareTo = null;
            return Null.INSTANCE;
        }
        this.i_compareTo = this.val(object);
        return this;
    }

    public Object current() {
        return this.i_compareTo;
    }

    public int compareTo(Object object) {
        if (this.i_compareTo == null) {
            if (object == null) {
                return 0;
            }
            return 1;
        }
        return this.compare(this.i_compareTo, this.val(object));
    }

    public boolean isEqual(Object object) {
        if (this.i_compareTo == null) {
            return object == null;
        }
        return this.i_compareTo.containsTheSame(this.val(object));
    }

    public boolean isGreater(Object object) {
        if (this.i_compareTo == null) {
            return object != null;
        }
        return this.compare(this.i_compareTo, this.val(object)) > 0;
    }

    public boolean isSmaller(Object object) {
        if (this.i_compareTo == null) {
            return false;
        }
        return this.compare(this.i_compareTo, this.val(object)) < 0;
    }

    final int compare(Buffer buffer, Buffer buffer2) {
        if (buffer == null) {
            if (buffer2 == null) {
                return 0;
            }
            return 1;
        }
        if (buffer2 == null) {
            return -1;
        }
        return StringHandler.compare(buffer._buffer, buffer2._buffer);
    }

    public static final int compare(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i = n = 4; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray2[i] - byArray[i];
        }
        return byArray2.length - byArray.length;
    }

    public void defragIndexEntry(ReaderPair readerPair) {
        readerPair.copyID(false, true);
        readerPair.incrementIntSize();
    }

    public void defrag(MarshallerFamily marshallerFamily, ReaderPair readerPair, boolean bl) {
        if (!bl) {
            readerPair.incrementOffset(this.linkLength());
        } else {
            marshallerFamily._string.defrag(readerPair);
        }
    }
}

