<html><pre><?php
# Copyright (c) 2001  David Muse
# See the file COPYING for more information.

	function checkSuccess($value,$success) {

		if ($value==$success) {
			echo("success ");
		} else {
			echo("$value != $success ");
			echo("failure ");
			sqlrcur_free($cur);
			sqlrcon_free($con);
			exit(1);
		}
	}

	$host="sqlrserver";
	$port=9000;
	$socket="/tmp/test.socket";
	$user="test";
	$password="test";

	# instantiation
	$con=sqlrcon_alloc($host,$port,$socket,$user,$password,0,1);
	$cur=sqlrcur_alloc($con);

	# get database type
	echo("IDENTIFY: \n");
	checkSuccess(sqlrcon_identify($con),"mysql");
	echo("\n");

	# ping
	echo("PING: \n");
	checkSuccess(sqlrcon_ping($con),1);
	echo("\n");

	# drop existing table
	sqlrcur_sendQuery($cur,"drop table testtable");

	# create a new table
	echo("CREATE TEMPTABLE: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"create table testdb.testtable (testtinyint tinyint, testsmallint smallint, testmediumint mediumint, testint int, testbigint bigint, testfloat float, testreal real, testdecimal decimal(2,1), testdate date, testtime time, testdatetime datetime, testyear year, testchar char(40), testtext text, testvarchar varchar(40), testtinytext tinytext, testmediumtext mediumtext, testlongtext longtext, testtimestamp timestamp)"),1);
	echo("\n");

	echo("INSERT: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testdb.testtable values (1,1,1,1,1,1.1,1.1,1.1,'2001-01-01','01:00:00','2001-01-01 01:00:00','2001','char1','text1','varchar1','tinytext1','mediumtext1','longtext1',NULL)"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testdb.testtable values (2,2,2,2,2,2.1,2.1,2.1,'2002-01-01','02:00:00','2002-01-01 02:00:00','2002','char2','text2','varchar2','tinytext2','mediumtext2','longtext2',NULL)"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testdb.testtable values (3,3,3,3,3,3.1,3.1,3.1,'2003-01-01','03:00:00','2003-01-01 03:00:00','2003','char3','text3','varchar3','tinytext3','mediumtext3','longtext3',NULL)"),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testdb.testtable values (4,4,4,4,4,4.1,4.1,4.1,'2004-01-01','04:00:00','2004-01-01 04:00:00','2004','char4','text4','varchar4','tinytext4','mediumtext4','longtext4',NULL)"),1);
	echo("\n");

	echo("AFFECTED ROWS: \n");
	checkSuccess(sqlrcur_affectedRows($cur),1);
	echo("\n");

	echo("BIND BY POSITION: \n");
	sqlrcur_prepareQuery($cur,"insert into testdb.testtable values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NULL)");
	checkSuccess(sqlrcur_countBindVariables($cur),18);
	sqlrcur_inputBind($cur,"1",5);
	sqlrcur_inputBind($cur,"2",5);
	sqlrcur_inputBind($cur,"3",5);
	sqlrcur_inputBind($cur,"4",5);
	sqlrcur_inputBind($cur,"5",5);
	sqlrcur_inputBind($cur,"6",5.1,2,1);
	sqlrcur_inputBind($cur,"7",5.1,2,1);
	sqlrcur_inputBind($cur,"8",5.1,2,1);
	sqlrcur_inputBind($cur,"9","2005-01-01");
	sqlrcur_inputBind($cur,"10","05:00:00");
	sqlrcur_inputBind($cur,"11","2005-01-01 05:00:00");
	sqlrcur_inputBind($cur,"12","2005");
	sqlrcur_inputBind($cur,"13","char5");
	sqlrcur_inputBind($cur,"14","text5");
	sqlrcur_inputBind($cur,"15","varchar5");
	sqlrcur_inputBind($cur,"16","tinytext5");
	sqlrcur_inputBind($cur,"17","mediumtext5");
	sqlrcur_inputBind($cur,"18","longtext5");
	checkSuccess(sqlrcur_executeQuery($cur),1);
	sqlrcur_clearBinds($cur);
	sqlrcur_inputBind($cur,"1",6);
	sqlrcur_inputBind($cur,"2",6);
	sqlrcur_inputBind($cur,"3",6);
	sqlrcur_inputBind($cur,"4",6);
	sqlrcur_inputBind($cur,"5",6);
	sqlrcur_inputBind($cur,"6",6.1,2,1);
	sqlrcur_inputBind($cur,"7",6.1,2,1);
	sqlrcur_inputBind($cur,"8",6.1,2,1);
	sqlrcur_inputBind($cur,"9","2006-01-01");
	sqlrcur_inputBind($cur,"10","06:00:00");
	sqlrcur_inputBind($cur,"11","2006-01-01 06:00:00");
	sqlrcur_inputBind($cur,"12","2006");
	sqlrcur_inputBind($cur,"13","char6");
	sqlrcur_inputBind($cur,"14","text6");
	sqlrcur_inputBind($cur,"15","varchar6");
	sqlrcur_inputBind($cur,"16","tinytext6");
	sqlrcur_inputBind($cur,"17","mediumtext6");
	sqlrcur_inputBind($cur,"18","longtext6");
	checkSuccess(sqlrcur_executeQuery($cur),1);

	echo("ARRAY BIND BY POSITION: \n");
	sqlrcur_clearBinds($cur);
	$bindvars=array("1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18");
	$bindvals=array(7,7,7,7,7,7.1,7.1,7.1,"2007-01-01","07:00:00","2007-01-01 07:00:00","2007","char7","text7","varchar7","tinytext7","mediumtext7","longtext7");
	$precs=array(0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0);
	$scales=array(0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0);
	sqlrcur_inputBinds($cur,$bindvars,$bindvals,$precs,$scales);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("BIND BY POSITION WITH VALIDATION: \n");
	sqlrcur_clearBinds($cur);
	sqlrcur_inputBind($cur,"1",8);
	sqlrcur_inputBind($cur,"2",8);
	sqlrcur_inputBind($cur,"3",8);
	sqlrcur_inputBind($cur,"4",8);
	sqlrcur_inputBind($cur,"5",8);
	sqlrcur_inputBind($cur,"6",8.1,2,1);
	sqlrcur_inputBind($cur,"7",8.1,2,1);
	sqlrcur_inputBind($cur,"8",8.1,2,1);
	sqlrcur_inputBind($cur,"9","2008-01-01");
	sqlrcur_inputBind($cur,"10","08:00:00");
	sqlrcur_inputBind($cur,"11","2008-01-01 08:00:00");
	sqlrcur_inputBind($cur,"12","2008");
	sqlrcur_inputBind($cur,"13","char8");
	sqlrcur_inputBind($cur,"14","text8");
	sqlrcur_inputBind($cur,"15","varchar8");
	sqlrcur_inputBind($cur,"16","tinytext8");
	sqlrcur_inputBind($cur,"17","mediumtext8");
	sqlrcur_inputBind($cur,"18","longtext8");
	sqlrcur_validateBinds($cur);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("SELECT: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	echo("\n");

	echo("COLUMN COUNT: \n");
	checkSuccess(sqlrcur_colCount($cur),19);
	echo("\n");

	echo("COLUMN NAMES: \n");
	checkSuccess(sqlrcur_getColumnName($cur,0),"testtinyint");
	checkSuccess(sqlrcur_getColumnName($cur,1),"testsmallint");
	checkSuccess(sqlrcur_getColumnName($cur,2),"testmediumint");
	checkSuccess(sqlrcur_getColumnName($cur,3),"testint");
	checkSuccess(sqlrcur_getColumnName($cur,4),"testbigint");
	checkSuccess(sqlrcur_getColumnName($cur,5),"testfloat");
	checkSuccess(sqlrcur_getColumnName($cur,6),"testreal");
	checkSuccess(sqlrcur_getColumnName($cur,7),"testdecimal");
	checkSuccess(sqlrcur_getColumnName($cur,8),"testdate");
	checkSuccess(sqlrcur_getColumnName($cur,9),"testtime");
	checkSuccess(sqlrcur_getColumnName($cur,10),"testdatetime");
	checkSuccess(sqlrcur_getColumnName($cur,11),"testyear");
	checkSuccess(sqlrcur_getColumnName($cur,12),"testchar");
	checkSuccess(sqlrcur_getColumnName($cur,13),"testtext");
	checkSuccess(sqlrcur_getColumnName($cur,14),"testvarchar");
	checkSuccess(sqlrcur_getColumnName($cur,15),"testtinytext");
	checkSuccess(sqlrcur_getColumnName($cur,16),"testmediumtext");
	checkSuccess(sqlrcur_getColumnName($cur,17),"testlongtext");
	checkSuccess(sqlrcur_getColumnName($cur,18),"testtimestamp");
	$cols=sqlrcur_getColumnNames($cur);
	checkSuccess($cols[0],"testtinyint");
	checkSuccess($cols[1],"testsmallint");
	checkSuccess($cols[2],"testmediumint");
	checkSuccess($cols[3],"testint");
	checkSuccess($cols[4],"testbigint");
	checkSuccess($cols[5],"testfloat");
	checkSuccess($cols[6],"testreal");
	checkSuccess($cols[7],"testdecimal");
	checkSuccess($cols[8],"testdate");
	checkSuccess($cols[9],"testtime");
	checkSuccess($cols[10],"testdatetime");
	checkSuccess($cols[11],"testyear");
	checkSuccess($cols[12],"testchar");
	checkSuccess($cols[13],"testtext");
	checkSuccess($cols[14],"testvarchar");
	checkSuccess($cols[15],"testtinytext");
	checkSuccess($cols[16],"testmediumtext");
	checkSuccess($cols[17],"testlongtext");
	checkSuccess($cols[18],"testtimestamp");
	echo("\n");

	echo("COLUMN TYPES: \n");
	checkSuccess(sqlrcur_getColumnType($cur,0),"TINYINT");
	checkSuccess(sqlrcur_getColumnType($cur,1),"SMALLINT");
	checkSuccess(sqlrcur_getColumnType($cur,2),"MEDIUMINT");
	checkSuccess(sqlrcur_getColumnType($cur,3),"INT");
	checkSuccess(sqlrcur_getColumnType($cur,4),"BIGINT");
	checkSuccess(sqlrcur_getColumnType($cur,5),"FLOAT");
	checkSuccess(sqlrcur_getColumnType($cur,6),"REAL");
	checkSuccess(sqlrcur_getColumnType($cur,7),"DECIMAL");
	checkSuccess(sqlrcur_getColumnType($cur,8),"DATE");
	checkSuccess(sqlrcur_getColumnType($cur,9),"TIME");
	checkSuccess(sqlrcur_getColumnType($cur,10),"DATETIME");
	checkSuccess(sqlrcur_getColumnType($cur,11),"YEAR");
	checkSuccess(sqlrcur_getColumnType($cur,12),"STRING");
	checkSuccess(sqlrcur_getColumnType($cur,13),"BLOB");
	checkSuccess(sqlrcur_getColumnType($cur,14),"CHAR");
	checkSuccess(sqlrcur_getColumnType($cur,15),"TINYBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,16),"MEDIUMBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,17),"LONGBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,18),"TIMESTAMP");
	checkSuccess(sqlrcur_getColumnType($cur,"testtinyint"),"TINYINT");
	checkSuccess(sqlrcur_getColumnType($cur,"testsmallint"),"SMALLINT");
	checkSuccess(sqlrcur_getColumnType($cur,"testmediumint"),"MEDIUMINT");
	checkSuccess(sqlrcur_getColumnType($cur,"testint"),"INT");
	checkSuccess(sqlrcur_getColumnType($cur,"testbigint"),"BIGINT");
	checkSuccess(sqlrcur_getColumnType($cur,"testfloat"),"FLOAT");
	checkSuccess(sqlrcur_getColumnType($cur,"testreal"),"REAL");
	checkSuccess(sqlrcur_getColumnType($cur,"testdecimal"),"DECIMAL");
	checkSuccess(sqlrcur_getColumnType($cur,"testdate"),"DATE");
	checkSuccess(sqlrcur_getColumnType($cur,"testtime"),"TIME");
	checkSuccess(sqlrcur_getColumnType($cur,"testdatetime"),"DATETIME");
	checkSuccess(sqlrcur_getColumnType($cur,"testyear"),"YEAR");
	checkSuccess(sqlrcur_getColumnType($cur,"testchar"),"STRING");
	checkSuccess(sqlrcur_getColumnType($cur,"testtext"),"BLOB");
	checkSuccess(sqlrcur_getColumnType($cur,"testvarchar"),"CHAR");
	checkSuccess(sqlrcur_getColumnType($cur,"testtinytext"),"TINYBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,"testmediumtext"),"MEDIUMBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,"testlongtext"),"LONGBLOB");
	checkSuccess(sqlrcur_getColumnType($cur,"testtimestamp"),"TIMESTAMP");
	echo("\n");

	echo("COLUMN LENGTH: \n");
	checkSuccess(sqlrcur_getColumnLength($cur,0),1);
	checkSuccess(sqlrcur_getColumnLength($cur,1),2);
	checkSuccess(sqlrcur_getColumnLength($cur,2),3);
	checkSuccess(sqlrcur_getColumnLength($cur,3),4);
	checkSuccess(sqlrcur_getColumnLength($cur,4),8);
	checkSuccess(sqlrcur_getColumnLength($cur,5),4);
	checkSuccess(sqlrcur_getColumnLength($cur,6),8);
	checkSuccess(sqlrcur_getColumnLength($cur,7),6);
	checkSuccess(sqlrcur_getColumnLength($cur,8),3);
	checkSuccess(sqlrcur_getColumnLength($cur,9),3);
	checkSuccess(sqlrcur_getColumnLength($cur,10),8);
	checkSuccess(sqlrcur_getColumnLength($cur,11),1);
	checkSuccess(sqlrcur_getColumnLength($cur,12),40);
	checkSuccess(sqlrcur_getColumnLength($cur,13),65535);
	checkSuccess(sqlrcur_getColumnLength($cur,14),41);
	checkSuccess(sqlrcur_getColumnLength($cur,15),255);
	checkSuccess(sqlrcur_getColumnLength($cur,16),16777215);
	checkSuccess(sqlrcur_getColumnLength($cur,17),2147483647);
	checkSuccess(sqlrcur_getColumnLength($cur,18),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtinyint"),1);
	checkSuccess(sqlrcur_getColumnLength($cur,"testsmallint"),2);
	checkSuccess(sqlrcur_getColumnLength($cur,"testmediumint"),3);
	checkSuccess(sqlrcur_getColumnLength($cur,"testint"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testbigint"),8);
	checkSuccess(sqlrcur_getColumnLength($cur,"testfloat"),4);
	checkSuccess(sqlrcur_getColumnLength($cur,"testreal"),8);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdecimal"),6);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdate"),3);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtime"),3);
	checkSuccess(sqlrcur_getColumnLength($cur,"testdatetime"),8);
	checkSuccess(sqlrcur_getColumnLength($cur,"testyear"),1);
	checkSuccess(sqlrcur_getColumnLength($cur,"testchar"),40);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtext"),65535);
	checkSuccess(sqlrcur_getColumnLength($cur,"testvarchar"),41);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtinytext"),255);
	checkSuccess(sqlrcur_getColumnLength($cur,"testmediumtext"),16777215);
	checkSuccess(sqlrcur_getColumnLength($cur,"testlongtext"),2147483647);
	checkSuccess(sqlrcur_getColumnLength($cur,"testtimestamp"),4);
	echo("\n");

	echo("LONGEST COLUMN: \n");
	checkSuccess(sqlrcur_getLongest($cur,0),1);
	checkSuccess(sqlrcur_getLongest($cur,1),1);
	checkSuccess(sqlrcur_getLongest($cur,2),1);
	checkSuccess(sqlrcur_getLongest($cur,3),1);
	checkSuccess(sqlrcur_getLongest($cur,4),1);
	checkSuccess(sqlrcur_getLongest($cur,5),3);
	checkSuccess(sqlrcur_getLongest($cur,6),3);
	checkSuccess(sqlrcur_getLongest($cur,7),3);
	checkSuccess(sqlrcur_getLongest($cur,8),10);
	checkSuccess(sqlrcur_getLongest($cur,9),8);
	checkSuccess(sqlrcur_getLongest($cur,10),19);
	checkSuccess(sqlrcur_getLongest($cur,11),4);
	checkSuccess(sqlrcur_getLongest($cur,12),5);
	checkSuccess(sqlrcur_getLongest($cur,13),5);
	checkSuccess(sqlrcur_getLongest($cur,14),8);
	checkSuccess(sqlrcur_getLongest($cur,15),9);
	checkSuccess(sqlrcur_getLongest($cur,16),11);
	checkSuccess(sqlrcur_getLongest($cur,17),9);
	checkSuccess(sqlrcur_getLongest($cur,18),19);
	checkSuccess(sqlrcur_getLongest($cur,"testtinyint"),1);
	checkSuccess(sqlrcur_getLongest($cur,"testsmallint"),1);
	checkSuccess(sqlrcur_getLongest($cur,"testmediumint"),1);
	checkSuccess(sqlrcur_getLongest($cur,"testint"),1);
	checkSuccess(sqlrcur_getLongest($cur,"testbigint"),1);
	checkSuccess(sqlrcur_getLongest($cur,"testfloat"),3);
	checkSuccess(sqlrcur_getLongest($cur,"testreal"),3);
	checkSuccess(sqlrcur_getLongest($cur,"testdecimal"),3);
	checkSuccess(sqlrcur_getLongest($cur,"testdate"),10);
	checkSuccess(sqlrcur_getLongest($cur,"testtime"),8);
	checkSuccess(sqlrcur_getLongest($cur,"testdatetime"),19);
	checkSuccess(sqlrcur_getLongest($cur,"testyear"),4);
	checkSuccess(sqlrcur_getLongest($cur,"testchar"),5);
	checkSuccess(sqlrcur_getLongest($cur,"testtext"),5);
	checkSuccess(sqlrcur_getLongest($cur,"testvarchar"),8);
	checkSuccess(sqlrcur_getLongest($cur,"testtinytext"),9);
	checkSuccess(sqlrcur_getLongest($cur,"testmediumtext"),11);
	checkSuccess(sqlrcur_getLongest($cur,"testlongtext"),9);
	checkSuccess(sqlrcur_getLongest($cur,"testtimestamp"),19);
	echo("\n");

	echo("ROW COUNT: \n");
	checkSuccess(sqlrcur_rowCount($cur),8);
	echo("\n");

	echo("TOTAL ROWS: \n");
	checkSuccess(sqlrcur_totalRows($cur),8);
	echo("\n");

	echo("FIRST ROW INDEX: \n");
	checkSuccess(sqlrcur_firstRowIndex($cur),0);
	echo("\n");

	echo("END OF RESULT SET: \n");
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	echo("\n");

	echo("FIELDS BY INDEX: \n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"1");
	checkSuccess(sqlrcur_getField($cur,0,2),"1");
	checkSuccess(sqlrcur_getField($cur,0,3),"1");
	checkSuccess(sqlrcur_getField($cur,0,4),"1");
	checkSuccess(sqlrcur_getField($cur,0,5),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,6),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,7),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,8),"2001-01-01");
	checkSuccess(sqlrcur_getField($cur,0,9),"01:00:00");
	checkSuccess(sqlrcur_getField($cur,0,10),"2001-01-01 01:00:00");
	checkSuccess(sqlrcur_getField($cur,0,11),"2001");
	checkSuccess(sqlrcur_getField($cur,0,12),"char1");
	checkSuccess(sqlrcur_getField($cur,0,13),"text1");
	checkSuccess(sqlrcur_getField($cur,0,14),"varchar1");
	checkSuccess(sqlrcur_getField($cur,0,15),"tinytext1");
	checkSuccess(sqlrcur_getField($cur,0,16),"mediumtext1");
	checkSuccess(sqlrcur_getField($cur,0,17),"longtext1");
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,7,1),"8");
	checkSuccess(sqlrcur_getField($cur,7,2),"8");
	checkSuccess(sqlrcur_getField($cur,7,3),"8");
	checkSuccess(sqlrcur_getField($cur,7,4),"8");
	checkSuccess(sqlrcur_getField($cur,7,5),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,6),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,7),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,8),"2008-01-01");
	checkSuccess(sqlrcur_getField($cur,7,9),"08:00:00");
	checkSuccess(sqlrcur_getField($cur,7,10),"2008-01-01 08:00:00");
	checkSuccess(sqlrcur_getField($cur,7,11),"2008");
	checkSuccess(sqlrcur_getField($cur,7,12),"char8");
	checkSuccess(sqlrcur_getField($cur,7,13),"text8");
	checkSuccess(sqlrcur_getField($cur,7,14),"varchar8");
	checkSuccess(sqlrcur_getField($cur,7,15),"tinytext8");
	checkSuccess(sqlrcur_getField($cur,7,16),"mediumtext8");
	checkSuccess(sqlrcur_getField($cur,7,17),"longtext8");
	echo("\n");

	echo("FIELD LENGTHS BY INDEX: \n");
	checkSuccess(sqlrcur_getFieldLength($cur,0,0),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,1),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,2),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,3),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,4),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,5),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,6),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,7),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,8),10);
	checkSuccess(sqlrcur_getFieldLength($cur,0,9),8);
	checkSuccess(sqlrcur_getFieldLength($cur,0,10),19);
	checkSuccess(sqlrcur_getFieldLength($cur,0,11),4);
	checkSuccess(sqlrcur_getFieldLength($cur,0,12),5);
	checkSuccess(sqlrcur_getFieldLength($cur,0,13),5);
	checkSuccess(sqlrcur_getFieldLength($cur,0,14),8);
	checkSuccess(sqlrcur_getFieldLength($cur,0,15),9);
	checkSuccess(sqlrcur_getFieldLength($cur,0,16),11);
	checkSuccess(sqlrcur_getFieldLength($cur,0,17),9);
	echo("\n");
	checkSuccess(sqlrcur_getFieldLength($cur,7,0),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,1),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,2),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,3),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,4),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,5),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,6),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,7),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,8),10);
	checkSuccess(sqlrcur_getFieldLength($cur,7,9),8);
	checkSuccess(sqlrcur_getFieldLength($cur,7,10),19);
	checkSuccess(sqlrcur_getFieldLength($cur,7,11),4);
	checkSuccess(sqlrcur_getFieldLength($cur,7,12),5);
	checkSuccess(sqlrcur_getFieldLength($cur,7,13),5);
	checkSuccess(sqlrcur_getFieldLength($cur,7,14),8);
	checkSuccess(sqlrcur_getFieldLength($cur,7,15),9);
	checkSuccess(sqlrcur_getFieldLength($cur,7,16),11);
	checkSuccess(sqlrcur_getFieldLength($cur,7,17),9);
	echo("\n");

	echo("FIELDS BY NAME: \n");
	checkSuccess(sqlrcur_getField($cur,0,"testtinyint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testsmallint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testmediumint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testbigint"),"1");
	checkSuccess(sqlrcur_getField($cur,0,"testfloat"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testreal"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testdecimal"),"1.1");
	checkSuccess(sqlrcur_getField($cur,0,"testdate"),"2001-01-01");
	checkSuccess(sqlrcur_getField($cur,0,"testtime"),"01:00:00");
	checkSuccess(sqlrcur_getField($cur,0,"testdatetime"),"2001-01-01 01:00:00");
	checkSuccess(sqlrcur_getField($cur,0,"testyear"),"2001");
	checkSuccess(sqlrcur_getField($cur,0,"testchar"),"char1");
	checkSuccess(sqlrcur_getField($cur,0,"testtext"),"text1");
	checkSuccess(sqlrcur_getField($cur,0,"testvarchar"),"varchar1");
	checkSuccess(sqlrcur_getField($cur,0,"testtinytext"),"tinytext1");
	checkSuccess(sqlrcur_getField($cur,0,"testmediumtext"),"mediumtext1");
	checkSuccess(sqlrcur_getField($cur,0,"testlongtext"),"longtext1");
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,7,"testtinyint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testsmallint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testmediumint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testbigint"),"8");
	checkSuccess(sqlrcur_getField($cur,7,"testfloat"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testreal"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testdecimal"),"8.1");
	checkSuccess(sqlrcur_getField($cur,7,"testdate"),"2008-01-01");
	checkSuccess(sqlrcur_getField($cur,7,"testtime"),"08:00:00");
	checkSuccess(sqlrcur_getField($cur,7,"testdatetime"),"2008-01-01 08:00:00");
	checkSuccess(sqlrcur_getField($cur,7,"testyear"),"2008");
	checkSuccess(sqlrcur_getField($cur,7,"testchar"),"char8");
	checkSuccess(sqlrcur_getField($cur,7,"testtext"),"text8");
	checkSuccess(sqlrcur_getField($cur,7,"testvarchar"),"varchar8");
	checkSuccess(sqlrcur_getField($cur,7,"testtinytext"),"tinytext8");
	checkSuccess(sqlrcur_getField($cur,7,"testmediumtext"),"mediumtext8");
	checkSuccess(sqlrcur_getField($cur,7,"testlongtext"),"longtext8");
	echo("\n");

	echo("FIELD LENGTHS BY NAME: \n");
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testtinyint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testsmallint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testmediumint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testbigint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testfloat"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testreal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdecimal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdate"),10);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testtime"),8);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testdatetime"),19);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testyear"),4);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testchar"),5);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testtext"),5);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testvarchar"),8);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testtinytext"),9);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testmediumtext"),11);
	checkSuccess(sqlrcur_getFieldLength($cur,0,"testlongtext"),9);
	echo("\n");
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testtinyint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testsmallint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testmediumint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testbigint"),1);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testfloat"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testreal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdecimal"),3);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdate"),10);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testtime"),8);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testdatetime"),19);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testyear"),4);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testchar"),5);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testtext"),5);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testvarchar"),8);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testtinytext"),9);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testmediumtext"),11);
	checkSuccess(sqlrcur_getFieldLength($cur,7,"testlongtext"),9);
	echo("\n");

	echo("FIELDS BY ARRAY: \n");
	$fields=sqlrcur_getRow($cur,0);
	checkSuccess($fields[0],"1");
	checkSuccess($fields[1],"1");
	checkSuccess($fields[2],"1");
	checkSuccess($fields[3],"1");
	checkSuccess($fields[4],"1");
	checkSuccess($fields[5],"1.1");
	checkSuccess($fields[6],"1.1");
	checkSuccess($fields[7],"1.1");
	checkSuccess($fields[8],"2001-01-01");
	checkSuccess($fields[9],"01:00:00");
	checkSuccess($fields[10],"2001-01-01 01:00:00");
	checkSuccess($fields[11],"2001");
	checkSuccess($fields[12],"char1");
	checkSuccess($fields[13],"text1");
	checkSuccess($fields[14],"varchar1");
	checkSuccess($fields[15],"tinytext1");
	checkSuccess($fields[16],"mediumtext1");
	checkSuccess($fields[17],"longtext1");
	echo("\n");

	echo("FIELD LENGTHS BY ARRAY: \n");
	$fieldlens=sqlrcur_getRowLengths($cur,0);
	checkSuccess($fieldlens[0],1);
	checkSuccess($fieldlens[1],1);
	checkSuccess($fieldlens[2],1);
	checkSuccess($fieldlens[3],1);
	checkSuccess($fieldlens[4],1);
	checkSuccess($fieldlens[5],3);
	checkSuccess($fieldlens[6],3);
	checkSuccess($fieldlens[7],3);
	checkSuccess($fieldlens[8],10);
	checkSuccess($fieldlens[9],8);
	checkSuccess($fieldlens[10],19);
	checkSuccess($fieldlens[11],4);
	checkSuccess($fieldlens[12],5);
	checkSuccess($fieldlens[13],5);
	checkSuccess($fieldlens[14],8);
	checkSuccess($fieldlens[15],9);
	checkSuccess($fieldlens[16],11);
	checkSuccess($fieldlens[17],9);
	echo("\n");


	echo("FIELDS BY ASSOCIATIVE ARRAY: \n");
	$fields=sqlrcur_getRowAssoc($cur,0);
	checkSuccess($fields["testtinyint"],"1");
	checkSuccess($fields["testsmallint"],"1");
	checkSuccess($fields["testmediumint"],"1");
	checkSuccess($fields["testint"],"1");
	checkSuccess($fields["testbigint"],"1");
	checkSuccess($fields["testfloat"],"1.1");
	checkSuccess($fields["testreal"],"1.1");
	checkSuccess($fields["testdecimal"],"1.1");
	checkSuccess($fields["testdate"],"2001-01-01");
	checkSuccess($fields["testtime"],"01:00:00");
	checkSuccess($fields["testdatetime"],"2001-01-01 01:00:00");
	checkSuccess($fields["testyear"],"2001");
	checkSuccess($fields["testchar"],"char1");
	checkSuccess($fields["testtext"],"text1");
	checkSuccess($fields["testvarchar"],"varchar1");
	checkSuccess($fields["testtinytext"],"tinytext1");
	checkSuccess($fields["testmediumtext"],"mediumtext1");
	checkSuccess($fields["testlongtext"],"longtext1");
	echo("\n");
	$fields=sqlrcur_getRowAssoc($cur,7);
	checkSuccess($fields["testtinyint"],"8");
	checkSuccess($fields["testsmallint"],"8");
	checkSuccess($fields["testmediumint"],"8");
	checkSuccess($fields["testint"],"8");
	checkSuccess($fields["testbigint"],"8");
	checkSuccess($fields["testfloat"],"8.1");
	checkSuccess($fields["testreal"],"8.1");
	checkSuccess($fields["testdecimal"],"8.1");
	checkSuccess($fields["testdate"],"2008-01-01");
	checkSuccess($fields["testtime"],"08:00:00");
	checkSuccess($fields["testdatetime"],"2008-01-01 08:00:00");
	checkSuccess($fields["testyear"],"2008");
	checkSuccess($fields["testchar"],"char8");
	checkSuccess($fields["testtext"],"text8");
	checkSuccess($fields["testvarchar"],"varchar8");
	checkSuccess($fields["testtinytext"],"tinytext8");
	checkSuccess($fields["testmediumtext"],"mediumtext8");
	checkSuccess($fields["testlongtext"],"longtext8");
	echo("\n");

	echo("FIELD LENGTHS BY ASSOCIATIVE ARRAY: \n");
	$fieldlengths=sqlrcur_getRowLengthsAssoc($cur,0);
	checkSuccess($fieldlengths["testtinyint"],1);
	checkSuccess($fieldlengths["testsmallint"],1);
	checkSuccess($fieldlengths["testmediumint"],1);
	checkSuccess($fieldlengths["testint"],1);
	checkSuccess($fieldlengths["testbigint"],1);
	checkSuccess($fieldlengths["testfloat"],3);
	checkSuccess($fieldlengths["testreal"],3);
	checkSuccess($fieldlengths["testdecimal"],3);
	checkSuccess($fieldlengths["testdate"],10);
	checkSuccess($fieldlengths["testtime"],8);
	checkSuccess($fieldlengths["testdatetime"],19);
	checkSuccess($fieldlengths["testyear"],4);
	checkSuccess($fieldlengths["testchar"],5);
	checkSuccess($fieldlengths["testtext"],5);
	checkSuccess($fieldlengths["testvarchar"],8);
	checkSuccess($fieldlengths["testtinytext"],9);
	checkSuccess($fieldlengths["testmediumtext"],11);
	checkSuccess($fieldlengths["testlongtext"],9);
	echo("\n");
	$fieldlengths=sqlrcur_getRowLengthsAssoc($cur,7);
	checkSuccess($fieldlengths["testtinyint"],1);
	checkSuccess($fieldlengths["testsmallint"],1);
	checkSuccess($fieldlengths["testmediumint"],1);
	checkSuccess($fieldlengths["testint"],1);
	checkSuccess($fieldlengths["testbigint"],1);
	checkSuccess($fieldlengths["testfloat"],3);
	checkSuccess($fieldlengths["testreal"],3);
	checkSuccess($fieldlengths["testdecimal"],3);
	checkSuccess($fieldlengths["testdate"],10);
	checkSuccess($fieldlengths["testtime"],8);
	checkSuccess($fieldlengths["testdatetime"],19);
	checkSuccess($fieldlengths["testyear"],4);
	checkSuccess($fieldlengths["testchar"],5);
	checkSuccess($fieldlengths["testtext"],5);
	checkSuccess($fieldlengths["testvarchar"],8);
	checkSuccess($fieldlengths["testtinytext"],9);
	checkSuccess($fieldlengths["testmediumtext"],11);
	checkSuccess($fieldlengths["testlongtext"],9);
	echo("\n");


	echo("INDIVIDUAL SUBSTITUTIONS: \n");
	sqlrcur_prepareQuery($cur,"select $(var1),'$(var2)',$(var3)");
	sqlrcur_substitution($cur,"var1",1);
	sqlrcur_substitution($cur,"var2","hello");
	sqlrcur_substitution($cur,"var3",10.5556,6,4);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("FIELDS: \n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"hello");
	checkSuccess(sqlrcur_getField($cur,0,2),"10.5556");
	echo("\n");

	echo("ARRAY SUBSTITUTIONS: \n");
	sqlrcur_prepareQuery($cur,"select $(var1),'$(var2)',$(var3)");
	$vars=array("var1","var2","var3");
	$vals=array(1,"hello",10.5556);
	$precs=array(0,0,6);
	$scales=array(0,0,4);
	sqlrcur_substitutions($cur,$vars,$vals,$precs,$scales);
	checkSuccess(sqlrcur_executeQuery($cur),1);
	echo("\n");

	echo("FIELDS: \n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,0,1),"hello");
	checkSuccess(sqlrcur_getField($cur,0,2),"10.5556");
	echo("\n");

	echo("NULLS as Nulls: \n");
	sqlrcur_getNullsAsNulls($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select NULL,1,NULL"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),NULL);
	checkSuccess(sqlrcur_getField($cur,0,1),"1");
	checkSuccess(sqlrcur_getField($cur,0,2),NULL);
	sqlrcur_getNullsAsEmptyStrings($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select NULL,1,NULL"),1);
	checkSuccess(sqlrcur_getField($cur,0,0),"");
	checkSuccess(sqlrcur_getField($cur,0,1),"1");
	checkSuccess(sqlrcur_getField($cur,0,2),"");
	sqlrcur_getNullsAsNulls($cur);
	echo("\n");

	echo("RESULT SET BUFFER SIZE: \n");
	checkSuccess(sqlrcur_getResultSetBufferSize($cur),0);
	sqlrcur_setResultSetBufferSize($cur,2);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	checkSuccess(sqlrcur_getResultSetBufferSize($cur),2);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),0);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),2);
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),2);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),4);
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	echo("\n");

	echo("DONT GET COLUMN INFO: \n");
	sqlrcur_dontGetColumnInfo($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	checkSuccess(sqlrcur_getColumnName($cur,0),NULL);
	checkSuccess(sqlrcur_getColumnLength($cur,0),0);
	checkSuccess(sqlrcur_getColumnType($cur,0),NULL);
	echo("\n");
	sqlrcur_getColumnInfo($cur);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	checkSuccess(sqlrcur_getColumnName($cur,0),"testtinyint");
	checkSuccess(sqlrcur_getColumnLength($cur,0),1);
	checkSuccess(sqlrcur_getColumnType($cur,0),"TINYINT");
	echo("\n");

	echo("SUSPENDED SESSION: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	echo("\n");
	checkSuccess(sqlrcur_getField($cur,0,0),"1");
	checkSuccess(sqlrcur_getField($cur,1,0),"2");
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	checkSuccess(sqlrcur_getField($cur,3,0),"4");
	checkSuccess(sqlrcur_getField($cur,4,0),"5");
	checkSuccess(sqlrcur_getField($cur,5,0),"6");
	checkSuccess(sqlrcur_getField($cur,6,0),"7");
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");

	echo("SUSPENDED RESULT SET: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	$id=sqlrcur_getResultSetId($cur);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	checkSuccess(sqlrcur_resumeResultSet($cur,$id),1);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),4);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),6);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("CACHED RESULT SET: \n");
	sqlrcur_cacheToFile($cur,"cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"cachefile1");
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");

	echo("COLUMN COUNT FOR CACHED RESULT SET: \n");
	checkSuccess(sqlrcur_colCount($cur),19);
	echo("\n");

	echo("COLUMN NAMES FOR CACHED RESULT SET: \n");
	checkSuccess(sqlrcur_getColumnName($cur,0),"testtinyint");
	checkSuccess(sqlrcur_getColumnName($cur,1),"testsmallint");
	checkSuccess(sqlrcur_getColumnName($cur,2),"testmediumint");
	checkSuccess(sqlrcur_getColumnName($cur,3),"testint");
	checkSuccess(sqlrcur_getColumnName($cur,4),"testbigint");
	checkSuccess(sqlrcur_getColumnName($cur,5),"testfloat");
	checkSuccess(sqlrcur_getColumnName($cur,6),"testreal");
	checkSuccess(sqlrcur_getColumnName($cur,7),"testdecimal");
	checkSuccess(sqlrcur_getColumnName($cur,8),"testdate");
	checkSuccess(sqlrcur_getColumnName($cur,9),"testtime");
	checkSuccess(sqlrcur_getColumnName($cur,10),"testdatetime");
	checkSuccess(sqlrcur_getColumnName($cur,11),"testyear");
	checkSuccess(sqlrcur_getColumnName($cur,12),"testchar");
	checkSuccess(sqlrcur_getColumnName($cur,13),"testtext");
	checkSuccess(sqlrcur_getColumnName($cur,14),"testvarchar");
	checkSuccess(sqlrcur_getColumnName($cur,15),"testtinytext");
	checkSuccess(sqlrcur_getColumnName($cur,16),"testmediumtext");
	checkSuccess(sqlrcur_getColumnName($cur,17),"testlongtext");
	$cols=sqlrcur_getColumnNames($cur);
	checkSuccess($cols[0],"testtinyint");
	checkSuccess($cols[1],"testsmallint");
	checkSuccess($cols[2],"testmediumint");
	checkSuccess($cols[3],"testint");
	checkSuccess($cols[4],"testbigint");
	checkSuccess($cols[5],"testfloat");
	checkSuccess($cols[6],"testreal");
	checkSuccess($cols[7],"testdecimal");
	checkSuccess($cols[8],"testdate");
	checkSuccess($cols[9],"testtime");
	checkSuccess($cols[10],"testdatetime");
	checkSuccess($cols[11],"testyear");
	checkSuccess($cols[12],"testchar");
	checkSuccess($cols[13],"testtext");
	checkSuccess($cols[14],"testvarchar");
	checkSuccess($cols[15],"testtinytext");
	checkSuccess($cols[16],"testmediumtext");
	checkSuccess($cols[17],"testlongtext");
	echo("\n");

	echo("CACHED RESULT SET WITH RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"cachefile1");
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("FROM ONE CACHE FILE TO ANOTHER: \n");
	sqlrcur_cacheToFile($cur,"cachefile2");
	checkSuccess(sqlrcur_openCachedResultSet($cur,"cachefile1"),1);
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,"cachefile2"),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");

	echo("FROM ONE CACHE FILE TO ANOTHER WITH RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"cachefile2");
	checkSuccess(sqlrcur_openCachedResultSet($cur,"cachefile1"),1);
	sqlrcur_cacheOff($cur);
	checkSuccess(sqlrcur_openCachedResultSet($cur,"cachefile2"),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("CACHED RESULT SET WITH SUSPEND AND RESULT SET BUFFER SIZE: \n");
	sqlrcur_setResultSetBufferSize($cur,2);
	sqlrcur_cacheToFile($cur,"cachefile1");
	sqlrcur_setCacheTtl($cur,200);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),1);
	checkSuccess(sqlrcur_getField($cur,2,0),"3");
	$filename=sqlrcur_getCacheFileName($cur);
	checkSuccess($filename,"cachefile1");
	$id=sqlrcur_getResultSetId($cur);
	sqlrcur_suspendResultSet($cur);
	checkSuccess(sqlrcon_suspendSession($con),1);
	$conport=sqlrcon_getConnectionPort($con);
	$consocket=sqlrcon_getConnectionSocket($con);
	echo("\n");
	checkSuccess(sqlrcon_resumeSession($con,$conport,$consocket),1);
	checkSuccess(sqlrcur_resumeCachedResultSet($cur,$id,$filename),1);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),4);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),6);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),6);
	checkSuccess(sqlrcur_endOfResultSet($cur),0);
	checkSuccess(sqlrcur_rowCount($cur),8);
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	echo("\n");
	checkSuccess(sqlrcur_firstRowIndex($cur),8);
	checkSuccess(sqlrcur_endOfResultSet($cur),1);
	checkSuccess(sqlrcur_rowCount($cur),8);
	sqlrcur_cacheOff($cur);
	echo("\n");
	checkSuccess(sqlrcur_openCachedResultSet($cur,$filename),1);
	checkSuccess(sqlrcur_getField($cur,7,0),"8");
	checkSuccess(sqlrcur_getField($cur,8,0),NULL);
	sqlrcur_setResultSetBufferSize($cur,0);
	echo("\n");

	echo("COMMIT AND ROLLBACK: \n");
	$secondcon=sqlrcon_alloc($host,$port, 
					$socket,$user,$password,0,1);
	$secondcur=sqlrcur_alloc($secondcon);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select count(*) from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,0,0),"0");
	checkSuccess(sqlrcon_commit($con),1);
	checkSuccess(sqlrcon_commit($secondcon),1);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select count(*) from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,0,0),"8");
	checkSuccess(sqlrcon_autoCommitOn($con),1);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testdb.testtable values (10,10,10,10,10,10.1,10.1,10.1,'2010-01-01','10:00:00','2010-01-01 10:00:00','2010','char10','text10','varchar10','tinytext10','mediumtext10','longtext10',NULL)"),1);
	checkSuccess(sqlrcon_commit($secondcon),1);
	checkSuccess(sqlrcur_sendQuery($secondcur,"select count(*) from testtable"),1);
	checkSuccess(sqlrcur_getField($secondcur,0,0),"9");
	checkSuccess(sqlrcon_autoCommitOff($con),1);
	sqlrcon_commit($secondcon);
	echo("\n");

	# drop existing table
	sqlrcur_sendQuery($cur,"drop table testtable");

	# invalid queries...
	echo("INVALID QUERIES: \n");
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"select * from testtable order by testtinyint"),0);
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"insert into testtable values (1,2,3,4)"),0);
	echo("\n");
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	checkSuccess(sqlrcur_sendQuery($cur,"create table testtable"),0);
	echo("\n");

?></pre></html>
