// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoGaussRealWeightUp.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOGAUSSREALWEIGHTUP_H
#define EOGAUSSREALWEIGHTUP_H

//-----------------------------------------------------------------------------
#include <eoWeightUpdater.h>
#include <utils/eoRNG.h>
//-----------------------------------------------------------------------------


/**
 * Update an inertia weight by assigning it a Gaussian randomized value.
 */
class eoGaussRealWeightUp:public eoWeightUpdater<double>
{
public:

    /**
     * Default constructor
     * @param _mean - Mean for Gaussian distribution
     * @param _stdev - Standard deviation for Gaussian distribution
     */
    eoGaussRealWeightUp(
        double  _mean=0,
        double  _stdev=1.0
    ):mean(_mean),stdev(_stdev){}

    /**
     * Assign Gaussian deviation  to _weight
     * @param _weight - The modified weight as a double
     */
    void operator() (double & _weight)
    {
        _weight=rng.normal(mean,stdev);
    }


protected:
    double mean,stdev;

};



#endif/*EOGAUSSREALWEIGHTUP_H*/
