// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoNeighborhood.h
// (c) OPAC 2007
/*
    This library...

    Contact: paradiseo-help@lists.gforge.inria.fr, http://paradiseo.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EONEIGHBORHOOD_H_
#define EONEIGHBORHOOD_H_


/**
 * Abstract class for neighborboods. Used for particle swarm optimization
 * topology strategies. Can be social or physical.
 */
template < class POT > class eoNeighborhood
{
public:

    virtual void put(unsigned _oneIndice)=0;

    virtual bool contains(unsigned _oneIndice)=0;

    virtual unsigned size()=0;

    virtual unsigned get(unsigned _index)=0;

    virtual POT & best()=0;

    virtual void best(POT _particle)=0;
    
    /// Virtual dtor
  	virtual ~eoNeighborhood() {};

};


#endif /* EONEIGHBORHOOD_H_ */











