/*
<sharedFitContinue.h>
Copyright (C) DOLPHIN Project-Team, INRIA Lille - Nord Europe, 2006-2012

Alexandre Quemy - INSA Rouen

This software is governed by the CeCILL license under French law and
abiding by the rules of distribution of free software.  You can  ue,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.
The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

ParadisEO WebSite : http://paradiseo.gforge.inria.fr
Contact: paradiseo-help@lists.gforge.inria.fr
*/

#ifndef SMP_SHARED_FIT_CONTINUE_H_
#define SMP_SHARED_FIT_CONTINUE_H_

#include <atomic>

#include <eoContinue.h>
#include <eoFitContinue.h>

namespace paradiseo
{
namespace smp
{

/** SharedFitContinue

Wrapper on the eoFitContinue in order to allow the island model to stop as soon as an island found a good solution.

@see smp::Island, eoFitContinue
*/

template<class EOT>
class SharedFitContinue : public eoContinue<EOT>
{
public:
    
    typedef typename EOT::Fitness Fitness;
    
    SharedFitContinue(const Fitness _optimum) : 
        fit(_optimum),
        found(false)
    {}; 
 
    virtual bool operator() ( const eoPop<EOT>& _pop );

    virtual std::string className(void) const;

protected:
    eoFitContinue<EOT> fit;
    std::atomic<bool> found;

};

#include <sharedFitContinue.cpp>

}

}

#endif
