;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 2007-2009 Clozure Associates and contributors
;;;   This file is part of Clozure CL.  
;;;
;;;   Clozure CL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with Clozure CL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with Clozure CL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   Clozure CL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")

;;;; helper functions
(defstatic *eucjp-to-ucs-map* nil)
(defstatic *ucs-to-eucjp-map* nil)
(defstatic *cp932-to-ucs-map* nil)
(defstatic *ucs-to-cp932-map* nil)

(let* ((cp932-only '((#xFC4B . #x9ED1)
                     (#xFC4A . #x9E19)
                     (#xFC49 . #xFA2D)
                     (#xFC48 . #x9D6B)
                     (#xFC47 . #x9D70)
                     (#xFC46 . #x9C00)
                     (#xFC45 . #x9BBB)
                     (#xFC44 . #x9BB1)
                     (#xFC43 . #x9B8F)
                     (#xFC42 . #x9B72)
                     (#xFC41 . #x9B75)
                     (#xFC40 . #x9ADC)
                     (#xFBFC . #x9AD9)
                     (#xFBFB . #x9A4E)
                     (#xFBFA . #x999E)
                     (#xFBF9 . #xFA2C)
                     (#xFBF8 . #x9927)
                     (#xFBF7 . #xFA2B)
                     (#xFBF6 . #xFA2A)
                     (#xFBF5 . #x9865)
                     (#xFBF4 . #x9857)
                     (#xFBF3 . #x9755)
                     (#xFBF2 . #x9751)
                     (#xFBF1 . #x974F)
                     (#xFBF0 . #x974D)
                     (#xFBEF . #x9743)
                     (#xFBEE . #x973B)
                     (#xFBED . #x9733)
                     (#xFBEC . #x96AF)
                     (#xFBEB . #x969D)
                     (#xFBEA . #xFA29)
                     (#xFBE9 . #xF9DC)
                     (#xFBE8 . #x9592)
                     (#xFBE7 . #x9448)
                     (#xFBE6 . #x9445)
                     (#xFBE5 . #x9431)
                     (#xFBE4 . #x93F8)
                     (#xFBE3 . #x93DE)
                     (#xFBE2 . #x93C6)
                     (#xFBE1 . #x93A4)
                     (#xFBE0 . #x9357)
                     (#xFBDF . #x9370)
                     (#xFBDE . #x9302)
                     (#xFBDD . #x931D)
                     (#xFBDC . #x92FF)
                     (#xFBDB . #x931E)
                     (#xFBDA . #xFA28)
                     (#xFBD9 . #x92FB)
                     (#xFBD8 . #x9321)
                     (#xFBD7 . #x9325)
                     (#xFBD6 . #x92D3)
                     (#xFBD5 . #x92E0)
                     (#xFBD4 . #x92D5)
                     (#xFBD3 . #xFA27)
                     (#xFBD2 . #x92D0)
                     (#xFBD1 . #x92D9)
                     (#xFBD0 . #x92D7)
                     (#xFBCF . #x92E7)
                     (#xFBCE . #x9278)
                     (#xFBCD . #x9277)
                     (#xFBCC . #x92A7)
                     (#xFBCB . #x9267)
                     (#xFBCA . #x9239)
                     (#xFBC9 . #x9251)
                     (#xFBC8 . #x9259)
                     (#xFBC7 . #x924E)
                     (#xFBC6 . #x923C)
                     (#xFBC5 . #x9240)
                     (#xFBC4 . #x923A)
                     (#xFBC3 . #x920A)
                     (#xFBC2 . #x9210)
                     (#xFBC1 . #x9206)
                     (#xFBC0 . #x91E5)
                     (#xFBBF . #x91E4)
                     (#xFBBE . #x91EE)
                     (#xFBBD . #x91ED)
                     (#xFBBC . #x91DE)
                     (#xFBBB . #x91D7)
                     (#xFBBA . #x91DA)
                     (#xFBB9 . #x9127)
                     (#xFBB8 . #x9115)
                     (#xFBB7 . #xFA26)
                     (#xFBB6 . #x90DE)
                     (#xFBB5 . #x9067)
                     (#xFBB4 . #xFA25)
                     (#xFBB3 . #xFA24)
                     (#xFBB2 . #x8ECF)
                     (#xFBB1 . #xFA23)
                     (#xFBB0 . #x8D76)
                     (#xFBAF . #x8D12)
                     (#xFBAE . #x8CF4)
                     (#xFBAD . #x8CF0)
                     (#xFBAC . #x8B7F)
                     (#xFBAB . #x8B53)
                     (#xFBAA . #x8AF6)
                     (#xFBA9 . #xFA22)
                     (#xFBA8 . #x8ADF)
                     (#xFBA7 . #x8ABE)
                     (#xFBA6 . #x8AA7)
                     (#xFBA5 . #x8A79)
                     (#xFBA4 . #x8A37)
                     (#xFBA3 . #x8A12)
                     (#xFBA2 . #x88F5)
                     (#xFBA1 . #x8807)
                     (#xFBA0 . #xFA21)
                     (#xFB9F . #xFA20)
                     (#xFB9E . #x85B0)
                     (#xFB9D . #xFA1F)
                     (#xFB9C . #x856B)
                     (#xFB9B . #x8559)
                     (#xFB9A . #x8553)
                     (#xFB99 . #x84B4)
                     (#xFB98 . #x8448)
                     (#xFB97 . #x83F6)
                     (#xFB96 . #x83C7)
                     (#xFB95 . #x837F)
                     (#xFB94 . #x8362)
                     (#xFB93 . #x8301)
                     (#xFB92 . #xFA1E)
                     (#xFB91 . #x7FA1)
                     (#xFB90 . #x7F47)
                     (#xFB8F . #x7E52)
                     (#xFB8E . #x7DD6)
                     (#xFB8D . #x7DA0)
                     (#xFB8C . #x7DB7)
                     (#xFB8B . #x7D5C)
                     (#xFB8A . #x7D48)
                     (#xFB89 . #xFA1D)
                     (#xFB88 . #x7B9E)
                     (#xFB87 . #x7AEB)
                     (#xFB86 . #xFA1C)
                     (#xFB85 . #x7AE7)
                     (#xFB84 . #x7AD1)
                     (#xFB83 . #x799B)
                     (#xFB82 . #xFA1B)
                     (#xFB81 . #x7994)
                     (#xFB80 . #xFA1A)
                     (#xFB7E . #xFA19)
                     (#xFB7D . #xFA18)
                     (#xFB7C . #x7930)
                     (#xFB7B . #x787A)
                     (#xFB7A . #x7864)
                     (#xFB79 . #x784E)
                     (#xFB78 . #x7821)
                     (#xFB77 . #x52AF)
                     (#xFB76 . #x7746)
                     (#xFB75 . #xFA17)
                     (#xFB74 . #x76A6)
                     (#xFB73 . #x769B)
                     (#xFB72 . #x769E)
                     (#xFB71 . #x769C)
                     (#xFB70 . #x7682)
                     (#xFB6F . #x756F)
                     (#xFB6E . #x7501)
                     (#xFB6D . #x749F)
                     (#xFB6C . #x7489)
                     (#xFB6B . #x7462)
                     (#xFB6A . #x742E)
                     (#xFB69 . #x7429)
                     (#xFB68 . #x742A)
                     (#xFB67 . #x7426)
                     (#xFB66 . #x73F5)
                     (#xFB65 . #x7407)
                     (#xFB64 . #x73D2)
                     (#xFB63 . #x73E3)
                     (#xFB62 . #x73D6)
                     (#xFB61 . #x73C9)
                     (#xFB60 . #x73BD)
                     (#xFB5F . #x7377)
                     (#xFB5E . #xFA16)
                     (#xFB5D . #x7324)
                     (#xFB5C . #x72BE)
                     (#xFB5B . #x72B1)
                     (#xFB5A . #x71FE)
                     (#xFB59 . #x71C1)
                     (#xFB58 . #xFA15)
                     (#xFB57 . #x7147)
                     (#xFB56 . #x7146)
                     (#xFB55 . #x715C)
                     (#xFB54 . #x7104)
                     (#xFB53 . #x710F)
                     (#xFB52 . #x70AB)
                     (#xFB51 . #x7085)
                     (#xFB50 . #x7028)
                     (#xFB4F . #x7007)
                     (#xFB4E . #x7005)
                     (#xFB4D . #x6FF5)
                     (#xFB4C . #x6FB5)
                     (#xFB4B . #x6F88)
                     (#xFB4A . #x6EBF)
                     (#xFB49 . #x6E3C)
                     (#xFB48 . #x6E27)
                     (#xFB47 . #x6E5C)
                     (#xFB46 . #x6E39)
                     (#xFB45 . #x6DFC)
                     (#xFB44 . #x6DF2)
                     (#xFB43 . #x6DF8)
                     (#xFB42 . #x6DCF)
                     (#xFB41 . #x6DAC)
                     (#xFB40 . #x6D96)
                     (#xFAFC . #x6D6F)
                     (#xFAFB . #x6D87)
                     (#xFAFA . #x6D04)
                     (#xFAF9 . #x6CDA)
                     (#xFAF8 . #x6C6F)
                     (#xFAF7 . #x6C86)
                     (#xFAF6 . #x6C5C)
                     (#xFAF5 . #x6C3F)
                     (#xFAF4 . #x6BD6)
                     (#xFAF3 . #x6AE4)
                     (#xFAF2 . #x6AE2)
                     (#xFAF1 . #x6A7E)
                     (#xFAF0 . #x6A73)
                     (#xFAEF . #x6A46)
                     (#xFAEE . #x6A6B)
                     (#xFAED . #x6A30)
                     (#xFAEC . #x69E2)
                     (#xFAEB . #x6998)
                     (#xFAEA . #xFA14)
                     (#xFAE9 . #x6968)
                     (#xFAE8 . #xFA13)
                     (#xFAE7 . #x68CF)
                     (#xFAE6 . #x6844)
                     (#xFAE5 . #x6801)
                     (#xFAE4 . #x67C0)
                     (#xFAE3 . #x6852)
                     (#xFAE2 . #x67BB)
                     (#xFAE1 . #x6766)
                     (#xFAE0 . #xF929)
                     (#xFADF . #x670E)
                     (#xFADE . #x66FA)
                     (#xFADD . #x66BF)
                     (#xFADC . #x66B2)
                     (#xFADB . #x66A0)
                     (#xFADA . #x6699)
                     (#xFAD9 . #x6673)
                     (#xFAD8 . #xFA12)
                     (#xFAD7 . #x6659)
                     (#xFAD6 . #x6657)
                     (#xFAD5 . #x6665)
                     (#xFAD4 . #x6624)
                     (#xFAD3 . #x661E)
                     (#xFAD2 . #x662E)
                     (#xFAD1 . #x6609)
                     (#xFAD0 . #x663B)
                     (#xFACF . #x6615)
                     (#xFACE . #x6600)
                     (#xFACD . #x654E)
                     (#xFACC . #x64CE)
                     (#xFACB . #x649D)
                     (#xFACA . #x6460)
                     (#xFAC9 . #x63F5)
                     (#xFAC8 . #x62A6)
                     (#xFAC7 . #x6213)
                     (#xFAC6 . #x6198)
                     (#xFAC5 . #x6130)
                     (#xFAC4 . #x6137)
                     (#xFAC3 . #x6111)
                     (#xFAC2 . #x60F2)
                     (#xFAC1 . #x6120)
                     (#xFAC0 . #x60D5)
                     (#xFABF . #x60DE)
                     (#xFABE . #x608A)
                     (#xFABD . #x6085)
                     (#xFABC . #x605D)
                     (#xFABB . #x5FDE)
                     (#xFABA . #x5FB7)
                     (#xFAB9 . #x5F67)
                     (#xFAB8 . #x5F34)
                     (#xFAB7 . #x5F21)
                     (#xFAB6 . #x5DD0)
                     (#xFAB5 . #x5DB9)
                     (#xFAB4 . #x5DB8)
                     (#xFAB3 . #x5D6D)
                     (#xFAB2 . #x5D42)
                     (#xFAB1 . #xFA11)
                     (#xFAB0 . #x5D53)
                     (#xFAAF . #x5D27)
                     (#xFAAE . #x5CF5)
                     (#xFAAD . #x5CBA)
                     (#xFAAC . #x5CA6)
                     (#xFAAB . #x5C1E)
                     (#xFAAA . #x5BEC)
                     (#xFAA9 . #x5BD8)
                     (#xFAA8 . #x752F)
                     (#xFAA7 . #x5BC0)
                     (#xFAA6 . #x5B56)
                     (#xFAA5 . #x59BA)
                     (#xFAA4 . #x59A4)
                     (#xFAA3 . #x5963)
                     (#xFAA2 . #x595D)
                     (#xFAA1 . #x595B)
                     (#xFAA0 . #x5953)
                     (#xFA9F . #x590B)
                     (#xFA9E . #x58B2)
                     (#xFA9D . #x589E)
                     (#xFA9C . #xFA10)
                     (#xFA9B . #xFA0F)
                     (#xFA9A . #x57C7)
                     (#xFA99 . #x57C8)
                     (#xFA98 . #x57AC)
                     (#xFA97 . #x5765)
                     (#xFA96 . #x5759)
                     (#xFA95 . #x5586)
                     (#xFA94 . #x54FF)
                     (#xFA93 . #x54A9)
                     (#xFA92 . #x548A)
                     (#xFA91 . #x549C)
                     (#xFA90 . #xFA0E)
                     (#xFA8F . #x53DD)
                     (#xFA8E . #x53B2)
                     (#xFA8D . #x5393)
                     (#xFA8C . #x5372)
                     (#xFA8B . #x5324)
                     (#xFA8A . #x5307)
                     (#xFA89 . #x5300)
                     (#xFA88 . #x52DB)
                     (#xFA87 . #x52C0)
                     (#xFA86 . #x52A6)
                     (#xFA85 . #x529C)
                     (#xFA84 . #x5215)
                     (#xFA83 . #x51EC)
                     (#xFA82 . #x51BE)
                     (#xFA81 . #x519D)
                     (#xFA80 . #x5164)
                     (#xFA7E . #x514A)
                     (#xFA7D . #x50D8)
                     (#xFA7C . #x50F4)
                     (#xFA7B . #x5094)
                     (#xFA7A . #x5042)
                     (#xFA79 . #x5070)
                     (#xFA78 . #x5046)
                     (#xFA77 . #x501E)
                     (#xFA76 . #x4FFF)
                     (#xFA75 . #x5022)
                     (#xFA74 . #x5040)
                     (#xFA73 . #x4FCD)
                     (#xFA72 . #x4F94)
                     (#xFA71 . #x4F9A)
                     (#xFA70 . #x4F8A)
                     (#xFA6F . #x4F92)
                     (#xFA6E . #x4F56)
                     (#xFA6D . #x4F39)
                     (#xFA6C . #x4F03)
                     (#xFA6B . #x4F00)
                     (#xFA6A . #x4EFC)
                     (#xFA69 . #x4EE1)
                     (#xFA68 . #x4E28)
                     (#xFA67 . #x5F45)
                     (#xFA66 . #x66FB)
                     (#xFA65 . #x92F9)
                     (#xFA64 . #x68C8)
                     (#xFA63 . #x6631)
                     (#xFA62 . #x70BB)
                     (#xFA61 . #x4FC9)
                     (#xFA60 . #x84DC)
                     (#xFA5F . #x9288)
                     (#xFA5E . #x9348)
                     (#xFA5D . #x891C)
                     (#xFA5C . #x7E8A)
                     (#xFA5B . #x2235)
                     (#xFA5A . #x2121)
                     (#xFA59 . #x2116)
                     (#xFA58 . #x3231)
                     (#xFA57 . #xFF02)
                     (#xFA56 . #xFF07)
                     (#xFA55 . #xFFE4)
                     (#xFA54 . #xFFE2)
                     (#xFA53 . #x2169)
                     (#xFA52 . #x2168)
                     (#xFA51 . #x2167)
                     (#xFA50 . #x2166)
                     (#xFA4F . #x2165)
                     (#xFA4E . #x2164)
                     (#xFA4D . #x2163)
                     (#xFA4C . #x2162)
                     (#xFA4B . #x2161)
                     (#xFA4A . #x2160)
                     (#xFA49 . #x2179)
                     (#xFA48 . #x2178)
                     (#xFA47 . #x2177)
                     (#xFA46 . #x2176)
                     (#xFA45 . #x2175)
                     (#xFA44 . #x2174)
                     (#xFA43 . #x2173)
                     (#xFA42 . #x2172)
                     (#xFA41 . #x2171)
                     (#xFA40 . #x2170)
                     (#xF9FC . #xE757)
                     (#xF9FB . #xE756)
                     (#xF9FA . #xE755)
                     (#xF9F9 . #xE754)
                     (#xF9F8 . #xE753)
                     (#xF9F7 . #xE752)
                     (#xF9F6 . #xE751)
                     (#xF9F5 . #xE750)
                     (#xF9F4 . #xE74F)
                     (#xF9F3 . #xE74E)
                     (#xF9F2 . #xE74D)
                     (#xF9F1 . #xE74C)
                     (#xF9F0 . #xE74B)
                     (#xF9EF . #xE74A)
                     (#xF9EE . #xE749)
                     (#xF9ED . #xE748)
                     (#xF9EC . #xE747)
                     (#xF9EB . #xE746)
                     (#xF9EA . #xE745)
                     (#xF9E9 . #xE744)
                     (#xF9E8 . #xE743)
                     (#xF9E7 . #xE742)
                     (#xF9E6 . #xE741)
                     (#xF9E5 . #xE740)
                     (#xF9E4 . #xE73F)
                     (#xF9E3 . #xE73E)
                     (#xF9E2 . #xE73D)
                     (#xF9E1 . #xE73C)
                     (#xF9E0 . #xE73B)
                     (#xF9DF . #xE73A)
                     (#xF9DE . #xE739)
                     (#xF9DD . #xE738)
                     (#xF9DC . #xE737)
                     (#xF9DB . #xE736)
                     (#xF9DA . #xE735)
                     (#xF9D9 . #xE734)
                     (#xF9D8 . #xE733)
                     (#xF9D7 . #xE732)
                     (#xF9D6 . #xE731)
                     (#xF9D5 . #xE730)
                     (#xF9D4 . #xE72F)
                     (#xF9D3 . #xE72E)
                     (#xF9D2 . #xE72D)
                     (#xF9D1 . #xE72C)
                     (#xF9D0 . #xE72B)
                     (#xF9CF . #xE72A)
                     (#xF9CE . #xE729)
                     (#xF9CD . #xE728)
                     (#xF9CC . #xE727)
                     (#xF9CB . #xE726)
                     (#xF9CA . #xE725)
                     (#xF9C9 . #xE724)
                     (#xF9C8 . #xE723)
                     (#xF9C7 . #xE722)
                     (#xF9C6 . #xE721)
                     (#xF9C5 . #xE720)
                     (#xF9C4 . #xE71F)
                     (#xF9C3 . #xE71E)
                     (#xF9C2 . #xE71D)
                     (#xF9C1 . #xE71C)
                     (#xF9C0 . #xE71B)
                     (#xF9BF . #xE71A)
                     (#xF9BE . #xE719)
                     (#xF9BD . #xE718)
                     (#xF9BC . #xE717)
                     (#xF9BB . #xE716)
                     (#xF9BA . #xE715)
                     (#xF9B9 . #xE714)
                     (#xF9B8 . #xE713)
                     (#xF9B7 . #xE712)
                     (#xF9B6 . #xE711)
                     (#xF9B5 . #xE710)
                     (#xF9B4 . #xE70F)
                     (#xF9B3 . #xE70E)
                     (#xF9B2 . #xE70D)
                     (#xF9B1 . #xE70C)
                     (#xF9B0 . #xE70B)
                     (#xF9AF . #xE70A)
                     (#xF9AE . #xE709)
                     (#xF9AD . #xE708)
                     (#xF9AC . #xE707)
                     (#xF9AB . #xE706)
                     (#xF9AA . #xE705)
                     (#xF9A9 . #xE704)
                     (#xF9A8 . #xE703)
                     (#xF9A7 . #xE702)
                     (#xF9A6 . #xE701)
                     (#xF9A5 . #xE700)
                     (#xF9A4 . #xE6FF)
                     (#xF9A3 . #xE6FE)
                     (#xF9A2 . #xE6FD)
                     (#xF9A1 . #xE6FC)
                     (#xF9A0 . #xE6FB)
                     (#xF99F . #xE6FA)
                     (#xF99E . #xE6F9)
                     (#xF99D . #xE6F8)
                     (#xF99C . #xE6F7)
                     (#xF99B . #xE6F6)
                     (#xF99A . #xE6F5)
                     (#xF999 . #xE6F4)
                     (#xF998 . #xE6F3)
                     (#xF997 . #xE6F2)
                     (#xF996 . #xE6F1)
                     (#xF995 . #xE6F0)
                     (#xF994 . #xE6EF)
                     (#xF993 . #xE6EE)
                     (#xF992 . #xE6ED)
                     (#xF991 . #xE6EC)
                     (#xF990 . #xE6EB)
                     (#xF98F . #xE6EA)
                     (#xF98E . #xE6E9)
                     (#xF98D . #xE6E8)
                     (#xF98C . #xE6E7)
                     (#xF98B . #xE6E6)
                     (#xF98A . #xE6E5)
                     (#xF989 . #xE6E4)
                     (#xF988 . #xE6E3)
                     (#xF987 . #xE6E2)
                     (#xF986 . #xE6E1)
                     (#xF985 . #xE6E0)
                     (#xF984 . #xE6DF)
                     (#xF983 . #xE6DE)
                     (#xF982 . #xE6DD)
                     (#xF981 . #xE6DC)
                     (#xF980 . #xE6DB)
                     (#xF97E . #xE6DA)
                     (#xF97D . #xE6D9)
                     (#xF97C . #xE6D8)
                     (#xF97B . #xE6D7)
                     (#xF97A . #xE6D6)
                     (#xF979 . #xE6D5)
                     (#xF978 . #xE6D4)
                     (#xF977 . #xE6D3)
                     (#xF976 . #xE6D2)
                     (#xF975 . #xE6D1)
                     (#xF974 . #xE6D0)
                     (#xF973 . #xE6CF)
                     (#xF972 . #xE6CE)
                     (#xF971 . #xE6CD)
                     (#xF970 . #xE6CC)
                     (#xF96F . #xE6CB)
                     (#xF96E . #xE6CA)
                     (#xF96D . #xE6C9)
                     (#xF96C . #xE6C8)
                     (#xF96B . #xE6C7)
                     (#xF96A . #xE6C6)
                     (#xF969 . #xE6C5)
                     (#xF968 . #xE6C4)
                     (#xF967 . #xE6C3)
                     (#xF966 . #xE6C2)
                     (#xF965 . #xE6C1)
                     (#xF964 . #xE6C0)
                     (#xF963 . #xE6BF)
                     (#xF962 . #xE6BE)
                     (#xF961 . #xE6BD)
                     (#xF960 . #xE6BC)
                     (#xF95F . #xE6BB)
                     (#xF95E . #xE6BA)
                     (#xF95D . #xE6B9)
                     (#xF95C . #xE6B8)
                     (#xF95B . #xE6B7)
                     (#xF95A . #xE6B6)
                     (#xF959 . #xE6B5)
                     (#xF958 . #xE6B4)
                     (#xF957 . #xE6B3)
                     (#xF956 . #xE6B2)
                     (#xF955 . #xE6B1)
                     (#xF954 . #xE6B0)
                     (#xF953 . #xE6AF)
                     (#xF952 . #xE6AE)
                     (#xF951 . #xE6AD)
                     (#xF950 . #xE6AC)
                     (#xF94F . #xE6AB)
                     (#xF94E . #xE6AA)
                     (#xF94D . #xE6A9)
                     (#xF94C . #xE6A8)
                     (#xF94B . #xE6A7)
                     (#xF94A . #xE6A6)
                     (#xF949 . #xE6A5)
                     (#xF948 . #xE6A4)
                     (#xF947 . #xE6A3)
                     (#xF946 . #xE6A2)
                     (#xF945 . #xE6A1)
                     (#xF944 . #xE6A0)
                     (#xF943 . #xE69F)
                     (#xF942 . #xE69E)
                     (#xF941 . #xE69D)
                     (#xF940 . #xE69C)
                     (#xF8FC . #xE69B)
                     (#xF8FB . #xE69A)
                     (#xF8FA . #xE699)
                     (#xF8F9 . #xE698)
                     (#xF8F8 . #xE697)
                     (#xF8F7 . #xE696)
                     (#xF8F6 . #xE695)
                     (#xF8F5 . #xE694)
                     (#xF8F4 . #xE693)
                     (#xF8F3 . #xE692)
                     (#xF8F2 . #xE691)
                     (#xF8F1 . #xE690)
                     (#xF8F0 . #xE68F)
                     (#xF8EF . #xE68E)
                     (#xF8EE . #xE68D)
                     (#xF8ED . #xE68C)
                     (#xF8EC . #xE68B)
                     (#xF8EB . #xE68A)
                     (#xF8EA . #xE689)
                     (#xF8E9 . #xE688)
                     (#xF8E8 . #xE687)
                     (#xF8E7 . #xE686)
                     (#xF8E6 . #xE685)
                     (#xF8E5 . #xE684)
                     (#xF8E4 . #xE683)
                     (#xF8E3 . #xE682)
                     (#xF8E2 . #xE681)
                     (#xF8E1 . #xE680)
                     (#xF8E0 . #xE67F)
                     (#xF8DF . #xE67E)
                     (#xF8DE . #xE67D)
                     (#xF8DD . #xE67C)
                     (#xF8DC . #xE67B)
                     (#xF8DB . #xE67A)
                     (#xF8DA . #xE679)
                     (#xF8D9 . #xE678)
                     (#xF8D8 . #xE677)
                     (#xF8D7 . #xE676)
                     (#xF8D6 . #xE675)
                     (#xF8D5 . #xE674)
                     (#xF8D4 . #xE673)
                     (#xF8D3 . #xE672)
                     (#xF8D2 . #xE671)
                     (#xF8D1 . #xE670)
                     (#xF8D0 . #xE66F)
                     (#xF8CF . #xE66E)
                     (#xF8CE . #xE66D)
                     (#xF8CD . #xE66C)
                     (#xF8CC . #xE66B)
                     (#xF8CB . #xE66A)
                     (#xF8CA . #xE669)
                     (#xF8C9 . #xE668)
                     (#xF8C8 . #xE667)
                     (#xF8C7 . #xE666)
                     (#xF8C6 . #xE665)
                     (#xF8C5 . #xE664)
                     (#xF8C4 . #xE663)
                     (#xF8C3 . #xE662)
                     (#xF8C2 . #xE661)
                     (#xF8C1 . #xE660)
                     (#xF8C0 . #xE65F)
                     (#xF8BF . #xE65E)
                     (#xF8BE . #xE65D)
                     (#xF8BD . #xE65C)
                     (#xF8BC . #xE65B)
                     (#xF8BB . #xE65A)
                     (#xF8BA . #xE659)
                     (#xF8B9 . #xE658)
                     (#xF8B8 . #xE657)
                     (#xF8B7 . #xE656)
                     (#xF8B6 . #xE655)
                     (#xF8B5 . #xE654)
                     (#xF8B4 . #xE653)
                     (#xF8B3 . #xE652)
                     (#xF8B2 . #xE651)
                     (#xF8B1 . #xE650)
                     (#xF8B0 . #xE64F)
                     (#xF8AF . #xE64E)
                     (#xF8AE . #xE64D)
                     (#xF8AD . #xE64C)
                     (#xF8AC . #xE64B)
                     (#xF8AB . #xE64A)
                     (#xF8AA . #xE649)
                     (#xF8A9 . #xE648)
                     (#xF8A8 . #xE647)
                     (#xF8A7 . #xE646)
                     (#xF8A6 . #xE645)
                     (#xF8A5 . #xE644)
                     (#xF8A4 . #xE643)
                     (#xF8A3 . #xE642)
                     (#xF8A2 . #xE641)
                     (#xF8A1 . #xE640)
                     (#xF8A0 . #xE63F)
                     (#xF89F . #xE63E)
                     (#xF89E . #xE63D)
                     (#xF89D . #xE63C)
                     (#xF89C . #xE63B)
                     (#xF89B . #xE63A)
                     (#xF89A . #xE639)
                     (#xF899 . #xE638)
                     (#xF898 . #xE637)
                     (#xF897 . #xE636)
                     (#xF896 . #xE635)
                     (#xF895 . #xE634)
                     (#xF894 . #xE633)
                     (#xF893 . #xE632)
                     (#xF892 . #xE631)
                     (#xF891 . #xE630)
                     (#xF890 . #xE62F)
                     (#xF88F . #xE62E)
                     (#xF88E . #xE62D)
                     (#xF88D . #xE62C)
                     (#xF88C . #xE62B)
                     (#xF88B . #xE62A)
                     (#xF88A . #xE629)
                     (#xF889 . #xE628)
                     (#xF888 . #xE627)
                     (#xF887 . #xE626)
                     (#xF886 . #xE625)
                     (#xF885 . #xE624)
                     (#xF884 . #xE623)
                     (#xF883 . #xE622)
                     (#xF882 . #xE621)
                     (#xF881 . #xE620)
                     (#xF880 . #xE61F)
                     (#xF87E . #xE61E)
                     (#xF87D . #xE61D)
                     (#xF87C . #xE61C)
                     (#xF87B . #xE61B)
                     (#xF87A . #xE61A)
                     (#xF879 . #xE619)
                     (#xF878 . #xE618)
                     (#xF877 . #xE617)
                     (#xF876 . #xE616)
                     (#xF875 . #xE615)
                     (#xF874 . #xE614)
                     (#xF873 . #xE613)
                     (#xF872 . #xE612)
                     (#xF871 . #xE611)
                     (#xF870 . #xE610)
                     (#xF86F . #xE60F)
                     (#xF86E . #xE60E)
                     (#xF86D . #xE60D)
                     (#xF86C . #xE60C)
                     (#xF86B . #xE60B)
                     (#xF86A . #xE60A)
                     (#xF869 . #xE609)
                     (#xF868 . #xE608)
                     (#xF867 . #xE607)
                     (#xF866 . #xE606)
                     (#xF865 . #xE605)
                     (#xF864 . #xE604)
                     (#xF863 . #xE603)
                     (#xF862 . #xE602)
                     (#xF861 . #xE601)
                     (#xF860 . #xE600)
                     (#xF85F . #xE5FF)
                     (#xF85E . #xE5FE)
                     (#xF85D . #xE5FD)
                     (#xF85C . #xE5FC)
                     (#xF85B . #xE5FB)
                     (#xF85A . #xE5FA)
                     (#xF859 . #xE5F9)
                     (#xF858 . #xE5F8)
                     (#xF857 . #xE5F7)
                     (#xF856 . #xE5F6)
                     (#xF855 . #xE5F5)
                     (#xF854 . #xE5F4)
                     (#xF853 . #xE5F3)
                     (#xF852 . #xE5F2)
                     (#xF851 . #xE5F1)
                     (#xF850 . #xE5F0)
                     (#xF84F . #xE5EF)
                     (#xF84E . #xE5EE)
                     (#xF84D . #xE5ED)
                     (#xF84C . #xE5EC)
                     (#xF84B . #xE5EB)
                     (#xF84A . #xE5EA)
                     (#xF849 . #xE5E9)
                     (#xF848 . #xE5E8)
                     (#xF847 . #xE5E7)
                     (#xF846 . #xE5E6)
                     (#xF845 . #xE5E5)
                     (#xF844 . #xE5E4)
                     (#xF843 . #xE5E3)
                     (#xF842 . #xE5E2)
                     (#xF841 . #xE5E1)
                     (#xF840 . #xE5E0)
                     (#xF7FC . #xE5DF)
                     (#xF7FB . #xE5DE)
                     (#xF7FA . #xE5DD)
                     (#xF7F9 . #xE5DC)
                     (#xF7F8 . #xE5DB)
                     (#xF7F7 . #xE5DA)
                     (#xF7F6 . #xE5D9)
                     (#xF7F5 . #xE5D8)
                     (#xF7F4 . #xE5D7)
                     (#xF7F3 . #xE5D6)
                     (#xF7F2 . #xE5D5)
                     (#xF7F1 . #xE5D4)
                     (#xF7F0 . #xE5D3)
                     (#xF7EF . #xE5D2)
                     (#xF7EE . #xE5D1)
                     (#xF7ED . #xE5D0)
                     (#xF7EC . #xE5CF)
                     (#xF7EB . #xE5CE)
                     (#xF7EA . #xE5CD)
                     (#xF7E9 . #xE5CC)
                     (#xF7E8 . #xE5CB)
                     (#xF7E7 . #xE5CA)
                     (#xF7E6 . #xE5C9)
                     (#xF7E5 . #xE5C8)
                     (#xF7E4 . #xE5C7)
                     (#xF7E3 . #xE5C6)
                     (#xF7E2 . #xE5C5)
                     (#xF7E1 . #xE5C4)
                     (#xF7E0 . #xE5C3)
                     (#xF7DF . #xE5C2)
                     (#xF7DE . #xE5C1)
                     (#xF7DD . #xE5C0)
                     (#xF7DC . #xE5BF)
                     (#xF7DB . #xE5BE)
                     (#xF7DA . #xE5BD)
                     (#xF7D9 . #xE5BC)
                     (#xF7D8 . #xE5BB)
                     (#xF7D7 . #xE5BA)
                     (#xF7D6 . #xE5B9)
                     (#xF7D5 . #xE5B8)
                     (#xF7D4 . #xE5B7)
                     (#xF7D3 . #xE5B6)
                     (#xF7D2 . #xE5B5)
                     (#xF7D1 . #xE5B4)
                     (#xF7D0 . #xE5B3)
                     (#xF7CF . #xE5B2)
                     (#xF7CE . #xE5B1)
                     (#xF7CD . #xE5B0)
                     (#xF7CC . #xE5AF)
                     (#xF7CB . #xE5AE)
                     (#xF7CA . #xE5AD)
                     (#xF7C9 . #xE5AC)
                     (#xF7C8 . #xE5AB)
                     (#xF7C7 . #xE5AA)
                     (#xF7C6 . #xE5A9)
                     (#xF7C5 . #xE5A8)
                     (#xF7C4 . #xE5A7)
                     (#xF7C3 . #xE5A6)
                     (#xF7C2 . #xE5A5)
                     (#xF7C1 . #xE5A4)
                     (#xF7C0 . #xE5A3)
                     (#xF7BF . #xE5A2)
                     (#xF7BE . #xE5A1)
                     (#xF7BD . #xE5A0)
                     (#xF7BC . #xE59F)
                     (#xF7BB . #xE59E)
                     (#xF7BA . #xE59D)
                     (#xF7B9 . #xE59C)
                     (#xF7B8 . #xE59B)
                     (#xF7B7 . #xE59A)
                     (#xF7B6 . #xE599)
                     (#xF7B5 . #xE598)
                     (#xF7B4 . #xE597)
                     (#xF7B3 . #xE596)
                     (#xF7B2 . #xE595)
                     (#xF7B1 . #xE594)
                     (#xF7B0 . #xE593)
                     (#xF7AF . #xE592)
                     (#xF7AE . #xE591)
                     (#xF7AD . #xE590)
                     (#xF7AC . #xE58F)
                     (#xF7AB . #xE58E)
                     (#xF7AA . #xE58D)
                     (#xF7A9 . #xE58C)
                     (#xF7A8 . #xE58B)
                     (#xF7A7 . #xE58A)
                     (#xF7A6 . #xE589)
                     (#xF7A5 . #xE588)
                     (#xF7A4 . #xE587)
                     (#xF7A3 . #xE586)
                     (#xF7A2 . #xE585)
                     (#xF7A1 . #xE584)
                     (#xF7A0 . #xE583)
                     (#xF79F . #xE582)
                     (#xF79E . #xE581)
                     (#xF79D . #xE580)
                     (#xF79C . #xE57F)
                     (#xF79B . #xE57E)
                     (#xF79A . #xE57D)
                     (#xF799 . #xE57C)
                     (#xF798 . #xE57B)
                     (#xF797 . #xE57A)
                     (#xF796 . #xE579)
                     (#xF795 . #xE578)
                     (#xF794 . #xE577)
                     (#xF793 . #xE576)
                     (#xF792 . #xE575)
                     (#xF791 . #xE574)
                     (#xF790 . #xE573)
                     (#xF78F . #xE572)
                     (#xF78E . #xE571)
                     (#xF78D . #xE570)
                     (#xF78C . #xE56F)
                     (#xF78B . #xE56E)
                     (#xF78A . #xE56D)
                     (#xF789 . #xE56C)
                     (#xF788 . #xE56B)
                     (#xF787 . #xE56A)
                     (#xF786 . #xE569)
                     (#xF785 . #xE568)
                     (#xF784 . #xE567)
                     (#xF783 . #xE566)
                     (#xF782 . #xE565)
                     (#xF781 . #xE564)
                     (#xF780 . #xE563)
                     (#xF77E . #xE562)
                     (#xF77D . #xE561)
                     (#xF77C . #xE560)
                     (#xF77B . #xE55F)
                     (#xF77A . #xE55E)
                     (#xF779 . #xE55D)
                     (#xF778 . #xE55C)
                     (#xF777 . #xE55B)
                     (#xF776 . #xE55A)
                     (#xF775 . #xE559)
                     (#xF774 . #xE558)
                     (#xF773 . #xE557)
                     (#xF772 . #xE556)
                     (#xF771 . #xE555)
                     (#xF770 . #xE554)
                     (#xF76F . #xE553)
                     (#xF76E . #xE552)
                     (#xF76D . #xE551)
                     (#xF76C . #xE550)
                     (#xF76B . #xE54F)
                     (#xF76A . #xE54E)
                     (#xF769 . #xE54D)
                     (#xF768 . #xE54C)
                     (#xF767 . #xE54B)
                     (#xF766 . #xE54A)
                     (#xF765 . #xE549)
                     (#xF764 . #xE548)
                     (#xF763 . #xE547)
                     (#xF762 . #xE546)
                     (#xF761 . #xE545)
                     (#xF760 . #xE544)
                     (#xF75F . #xE543)
                     (#xF75E . #xE542)
                     (#xF75D . #xE541)
                     (#xF75C . #xE540)
                     (#xF75B . #xE53F)
                     (#xF75A . #xE53E)
                     (#xF759 . #xE53D)
                     (#xF758 . #xE53C)
                     (#xF757 . #xE53B)
                     (#xF756 . #xE53A)
                     (#xF755 . #xE539)
                     (#xF754 . #xE538)
                     (#xF753 . #xE537)
                     (#xF752 . #xE536)
                     (#xF751 . #xE535)
                     (#xF750 . #xE534)
                     (#xF74F . #xE533)
                     (#xF74E . #xE532)
                     (#xF74D . #xE531)
                     (#xF74C . #xE530)
                     (#xF74B . #xE52F)
                     (#xF74A . #xE52E)
                     (#xF749 . #xE52D)
                     (#xF748 . #xE52C)
                     (#xF747 . #xE52B)
                     (#xF746 . #xE52A)
                     (#xF745 . #xE529)
                     (#xF744 . #xE528)
                     (#xF743 . #xE527)
                     (#xF742 . #xE526)
                     (#xF741 . #xE525)
                     (#xF740 . #xE524)
                     (#xF6FC . #xE523)
                     (#xF6FB . #xE522)
                     (#xF6FA . #xE521)
                     (#xF6F9 . #xE520)
                     (#xF6F8 . #xE51F)
                     (#xF6F7 . #xE51E)
                     (#xF6F6 . #xE51D)
                     (#xF6F5 . #xE51C)
                     (#xF6F4 . #xE51B)
                     (#xF6F3 . #xE51A)
                     (#xF6F2 . #xE519)
                     (#xF6F1 . #xE518)
                     (#xF6F0 . #xE517)
                     (#xF6EF . #xE516)
                     (#xF6EE . #xE515)
                     (#xF6ED . #xE514)
                     (#xF6EC . #xE513)
                     (#xF6EB . #xE512)
                     (#xF6EA . #xE511)
                     (#xF6E9 . #xE510)
                     (#xF6E8 . #xE50F)
                     (#xF6E7 . #xE50E)
                     (#xF6E6 . #xE50D)
                     (#xF6E5 . #xE50C)
                     (#xF6E4 . #xE50B)
                     (#xF6E3 . #xE50A)
                     (#xF6E2 . #xE509)
                     (#xF6E1 . #xE508)
                     (#xF6E0 . #xE507)
                     (#xF6DF . #xE506)
                     (#xF6DE . #xE505)
                     (#xF6DD . #xE504)
                     (#xF6DC . #xE503)
                     (#xF6DB . #xE502)
                     (#xF6DA . #xE501)
                     (#xF6D9 . #xE500)
                     (#xF6D8 . #xE4FF)
                     (#xF6D7 . #xE4FE)
                     (#xF6D6 . #xE4FD)
                     (#xF6D5 . #xE4FC)
                     (#xF6D4 . #xE4FB)
                     (#xF6D3 . #xE4FA)
                     (#xF6D2 . #xE4F9)
                     (#xF6D1 . #xE4F8)
                     (#xF6D0 . #xE4F7)
                     (#xF6CF . #xE4F6)
                     (#xF6CE . #xE4F5)
                     (#xF6CD . #xE4F4)
                     (#xF6CC . #xE4F3)
                     (#xF6CB . #xE4F2)
                     (#xF6CA . #xE4F1)
                     (#xF6C9 . #xE4F0)
                     (#xF6C8 . #xE4EF)
                     (#xF6C7 . #xE4EE)
                     (#xF6C6 . #xE4ED)
                     (#xF6C5 . #xE4EC)
                     (#xF6C4 . #xE4EB)
                     (#xF6C3 . #xE4EA)
                     (#xF6C2 . #xE4E9)
                     (#xF6C1 . #xE4E8)
                     (#xF6C0 . #xE4E7)
                     (#xF6BF . #xE4E6)
                     (#xF6BE . #xE4E5)
                     (#xF6BD . #xE4E4)
                     (#xF6BC . #xE4E3)
                     (#xF6BB . #xE4E2)
                     (#xF6BA . #xE4E1)
                     (#xF6B9 . #xE4E0)
                     (#xF6B8 . #xE4DF)
                     (#xF6B7 . #xE4DE)
                     (#xF6B6 . #xE4DD)
                     (#xF6B5 . #xE4DC)
                     (#xF6B4 . #xE4DB)
                     (#xF6B3 . #xE4DA)
                     (#xF6B2 . #xE4D9)
                     (#xF6B1 . #xE4D8)
                     (#xF6B0 . #xE4D7)
                     (#xF6AF . #xE4D6)
                     (#xF6AE . #xE4D5)
                     (#xF6AD . #xE4D4)
                     (#xF6AC . #xE4D3)
                     (#xF6AB . #xE4D2)
                     (#xF6AA . #xE4D1)
                     (#xF6A9 . #xE4D0)
                     (#xF6A8 . #xE4CF)
                     (#xF6A7 . #xE4CE)
                     (#xF6A6 . #xE4CD)
                     (#xF6A5 . #xE4CC)
                     (#xF6A4 . #xE4CB)
                     (#xF6A3 . #xE4CA)
                     (#xF6A2 . #xE4C9)
                     (#xF6A1 . #xE4C8)
                     (#xF6A0 . #xE4C7)
                     (#xF69F . #xE4C6)
                     (#xF69E . #xE4C5)
                     (#xF69D . #xE4C4)
                     (#xF69C . #xE4C3)
                     (#xF69B . #xE4C2)
                     (#xF69A . #xE4C1)
                     (#xF699 . #xE4C0)
                     (#xF698 . #xE4BF)
                     (#xF697 . #xE4BE)
                     (#xF696 . #xE4BD)
                     (#xF695 . #xE4BC)
                     (#xF694 . #xE4BB)
                     (#xF693 . #xE4BA)
                     (#xF692 . #xE4B9)
                     (#xF691 . #xE4B8)
                     (#xF690 . #xE4B7)
                     (#xF68F . #xE4B6)
                     (#xF68E . #xE4B5)
                     (#xF68D . #xE4B4)
                     (#xF68C . #xE4B3)
                     (#xF68B . #xE4B2)
                     (#xF68A . #xE4B1)
                     (#xF689 . #xE4B0)
                     (#xF688 . #xE4AF)
                     (#xF687 . #xE4AE)
                     (#xF686 . #xE4AD)
                     (#xF685 . #xE4AC)
                     (#xF684 . #xE4AB)
                     (#xF683 . #xE4AA)
                     (#xF682 . #xE4A9)
                     (#xF681 . #xE4A8)
                     (#xF680 . #xE4A7)
                     (#xF67E . #xE4A6)
                     (#xF67D . #xE4A5)
                     (#xF67C . #xE4A4)
                     (#xF67B . #xE4A3)
                     (#xF67A . #xE4A2)
                     (#xF679 . #xE4A1)
                     (#xF678 . #xE4A0)
                     (#xF677 . #xE49F)
                     (#xF676 . #xE49E)
                     (#xF675 . #xE49D)
                     (#xF674 . #xE49C)
                     (#xF673 . #xE49B)
                     (#xF672 . #xE49A)
                     (#xF671 . #xE499)
                     (#xF670 . #xE498)
                     (#xF66F . #xE497)
                     (#xF66E . #xE496)
                     (#xF66D . #xE495)
                     (#xF66C . #xE494)
                     (#xF66B . #xE493)
                     (#xF66A . #xE492)
                     (#xF669 . #xE491)
                     (#xF668 . #xE490)
                     (#xF667 . #xE48F)
                     (#xF666 . #xE48E)
                     (#xF665 . #xE48D)
                     (#xF664 . #xE48C)
                     (#xF663 . #xE48B)
                     (#xF662 . #xE48A)
                     (#xF661 . #xE489)
                     (#xF660 . #xE488)
                     (#xF65F . #xE487)
                     (#xF65E . #xE486)
                     (#xF65D . #xE485)
                     (#xF65C . #xE484)
                     (#xF65B . #xE483)
                     (#xF65A . #xE482)
                     (#xF659 . #xE481)
                     (#xF658 . #xE480)
                     (#xF657 . #xE47F)
                     (#xF656 . #xE47E)
                     (#xF655 . #xE47D)
                     (#xF654 . #xE47C)
                     (#xF653 . #xE47B)
                     (#xF652 . #xE47A)
                     (#xF651 . #xE479)
                     (#xF650 . #xE478)
                     (#xF64F . #xE477)
                     (#xF64E . #xE476)
                     (#xF64D . #xE475)
                     (#xF64C . #xE474)
                     (#xF64B . #xE473)
                     (#xF64A . #xE472)
                     (#xF649 . #xE471)
                     (#xF648 . #xE470)
                     (#xF647 . #xE46F)
                     (#xF646 . #xE46E)
                     (#xF645 . #xE46D)
                     (#xF644 . #xE46C)
                     (#xF643 . #xE46B)
                     (#xF642 . #xE46A)
                     (#xF641 . #xE469)
                     (#xF640 . #xE468)
                     (#xF5FC . #xE467)
                     (#xF5FB . #xE466)
                     (#xF5FA . #xE465)
                     (#xF5F9 . #xE464)
                     (#xF5F8 . #xE463)
                     (#xF5F7 . #xE462)
                     (#xF5F6 . #xE461)
                     (#xF5F5 . #xE460)
                     (#xF5F4 . #xE45F)
                     (#xF5F3 . #xE45E)
                     (#xF5F2 . #xE45D)
                     (#xF5F1 . #xE45C)
                     (#xF5F0 . #xE45B)
                     (#xF5EF . #xE45A)
                     (#xF5EE . #xE459)
                     (#xF5ED . #xE458)
                     (#xF5EC . #xE457)
                     (#xF5EB . #xE456)
                     (#xF5EA . #xE455)
                     (#xF5E9 . #xE454)
                     (#xF5E8 . #xE453)
                     (#xF5E7 . #xE452)
                     (#xF5E6 . #xE451)
                     (#xF5E5 . #xE450)
                     (#xF5E4 . #xE44F)
                     (#xF5E3 . #xE44E)
                     (#xF5E2 . #xE44D)
                     (#xF5E1 . #xE44C)
                     (#xF5E0 . #xE44B)
                     (#xF5DF . #xE44A)
                     (#xF5DE . #xE449)
                     (#xF5DD . #xE448)
                     (#xF5DC . #xE447)
                     (#xF5DB . #xE446)
                     (#xF5DA . #xE445)
                     (#xF5D9 . #xE444)
                     (#xF5D8 . #xE443)
                     (#xF5D7 . #xE442)
                     (#xF5D6 . #xE441)
                     (#xF5D5 . #xE440)
                     (#xF5D4 . #xE43F)
                     (#xF5D3 . #xE43E)
                     (#xF5D2 . #xE43D)
                     (#xF5D1 . #xE43C)
                     (#xF5D0 . #xE43B)
                     (#xF5CF . #xE43A)
                     (#xF5CE . #xE439)
                     (#xF5CD . #xE438)
                     (#xF5CC . #xE437)
                     (#xF5CB . #xE436)
                     (#xF5CA . #xE435)
                     (#xF5C9 . #xE434)
                     (#xF5C8 . #xE433)
                     (#xF5C7 . #xE432)
                     (#xF5C6 . #xE431)
                     (#xF5C5 . #xE430)
                     (#xF5C4 . #xE42F)
                     (#xF5C3 . #xE42E)
                     (#xF5C2 . #xE42D)
                     (#xF5C1 . #xE42C)
                     (#xF5C0 . #xE42B)
                     (#xF5BF . #xE42A)
                     (#xF5BE . #xE429)
                     (#xF5BD . #xE428)
                     (#xF5BC . #xE427)
                     (#xF5BB . #xE426)
                     (#xF5BA . #xE425)
                     (#xF5B9 . #xE424)
                     (#xF5B8 . #xE423)
                     (#xF5B7 . #xE422)
                     (#xF5B6 . #xE421)
                     (#xF5B5 . #xE420)
                     (#xF5B4 . #xE41F)
                     (#xF5B3 . #xE41E)
                     (#xF5B2 . #xE41D)
                     (#xF5B1 . #xE41C)
                     (#xF5B0 . #xE41B)
                     (#xF5AF . #xE41A)
                     (#xF5AE . #xE419)
                     (#xF5AD . #xE418)
                     (#xF5AC . #xE417)
                     (#xF5AB . #xE416)
                     (#xF5AA . #xE415)
                     (#xF5A9 . #xE414)
                     (#xF5A8 . #xE413)
                     (#xF5A7 . #xE412)
                     (#xF5A6 . #xE411)
                     (#xF5A5 . #xE410)
                     (#xF5A4 . #xE40F)
                     (#xF5A3 . #xE40E)
                     (#xF5A2 . #xE40D)
                     (#xF5A1 . #xE40C)
                     (#xF5A0 . #xE40B)
                     (#xF59F . #xE40A)
                     (#xF59E . #xE409)
                     (#xF59D . #xE408)
                     (#xF59C . #xE407)
                     (#xF59B . #xE406)
                     (#xF59A . #xE405)
                     (#xF599 . #xE404)
                     (#xF598 . #xE403)
                     (#xF597 . #xE402)
                     (#xF596 . #xE401)
                     (#xF595 . #xE400)
                     (#xF594 . #xE3FF)
                     (#xF593 . #xE3FE)
                     (#xF592 . #xE3FD)
                     (#xF591 . #xE3FC)
                     (#xF590 . #xE3FB)
                     (#xF58F . #xE3FA)
                     (#xF58E . #xE3F9)
                     (#xF58D . #xE3F8)
                     (#xF58C . #xE3F7)
                     (#xF58B . #xE3F6)
                     (#xF58A . #xE3F5)
                     (#xF589 . #xE3F4)
                     (#xF588 . #xE3F3)
                     (#xF587 . #xE3F2)
                     (#xF586 . #xE3F1)
                     (#xF585 . #xE3F0)
                     (#xF584 . #xE3EF)
                     (#xF583 . #xE3EE)
                     (#xF582 . #xE3ED)
                     (#xF581 . #xE3EC)
                     (#xF580 . #xE3EB)
                     (#xF57E . #xE3EA)
                     (#xF57D . #xE3E9)
                     (#xF57C . #xE3E8)
                     (#xF57B . #xE3E7)
                     (#xF57A . #xE3E6)
                     (#xF579 . #xE3E5)
                     (#xF578 . #xE3E4)
                     (#xF577 . #xE3E3)
                     (#xF576 . #xE3E2)
                     (#xF575 . #xE3E1)
                     (#xF574 . #xE3E0)
                     (#xF573 . #xE3DF)
                     (#xF572 . #xE3DE)
                     (#xF571 . #xE3DD)
                     (#xF570 . #xE3DC)
                     (#xF56F . #xE3DB)
                     (#xF56E . #xE3DA)
                     (#xF56D . #xE3D9)
                     (#xF56C . #xE3D8)
                     (#xF56B . #xE3D7)
                     (#xF56A . #xE3D6)
                     (#xF569 . #xE3D5)
                     (#xF568 . #xE3D4)
                     (#xF567 . #xE3D3)
                     (#xF566 . #xE3D2)
                     (#xF565 . #xE3D1)
                     (#xF564 . #xE3D0)
                     (#xF563 . #xE3CF)
                     (#xF562 . #xE3CE)
                     (#xF561 . #xE3CD)
                     (#xF560 . #xE3CC)
                     (#xF55F . #xE3CB)
                     (#xF55E . #xE3CA)
                     (#xF55D . #xE3C9)
                     (#xF55C . #xE3C8)
                     (#xF55B . #xE3C7)
                     (#xF55A . #xE3C6)
                     (#xF559 . #xE3C5)
                     (#xF558 . #xE3C4)
                     (#xF557 . #xE3C3)
                     (#xF556 . #xE3C2)
                     (#xF555 . #xE3C1)
                     (#xF554 . #xE3C0)
                     (#xF553 . #xE3BF)
                     (#xF552 . #xE3BE)
                     (#xF551 . #xE3BD)
                     (#xF550 . #xE3BC)
                     (#xF54F . #xE3BB)
                     (#xF54E . #xE3BA)
                     (#xF54D . #xE3B9)
                     (#xF54C . #xE3B8)
                     (#xF54B . #xE3B7)
                     (#xF54A . #xE3B6)
                     (#xF549 . #xE3B5)
                     (#xF548 . #xE3B4)
                     (#xF547 . #xE3B3)
                     (#xF546 . #xE3B2)
                     (#xF545 . #xE3B1)
                     (#xF544 . #xE3B0)
                     (#xF543 . #xE3AF)
                     (#xF542 . #xE3AE)
                     (#xF541 . #xE3AD)
                     (#xF540 . #xE3AC)
                     (#xF4FC . #xE3AB)
                     (#xF4FB . #xE3AA)
                     (#xF4FA . #xE3A9)
                     (#xF4F9 . #xE3A8)
                     (#xF4F8 . #xE3A7)
                     (#xF4F7 . #xE3A6)
                     (#xF4F6 . #xE3A5)
                     (#xF4F5 . #xE3A4)
                     (#xF4F4 . #xE3A3)
                     (#xF4F3 . #xE3A2)
                     (#xF4F2 . #xE3A1)
                     (#xF4F1 . #xE3A0)
                     (#xF4F0 . #xE39F)
                     (#xF4EF . #xE39E)
                     (#xF4EE . #xE39D)
                     (#xF4ED . #xE39C)
                     (#xF4EC . #xE39B)
                     (#xF4EB . #xE39A)
                     (#xF4EA . #xE399)
                     (#xF4E9 . #xE398)
                     (#xF4E8 . #xE397)
                     (#xF4E7 . #xE396)
                     (#xF4E6 . #xE395)
                     (#xF4E5 . #xE394)
                     (#xF4E4 . #xE393)
                     (#xF4E3 . #xE392)
                     (#xF4E2 . #xE391)
                     (#xF4E1 . #xE390)
                     (#xF4E0 . #xE38F)
                     (#xF4DF . #xE38E)
                     (#xF4DE . #xE38D)
                     (#xF4DD . #xE38C)
                     (#xF4DC . #xE38B)
                     (#xF4DB . #xE38A)
                     (#xF4DA . #xE389)
                     (#xF4D9 . #xE388)
                     (#xF4D8 . #xE387)
                     (#xF4D7 . #xE386)
                     (#xF4D6 . #xE385)
                     (#xF4D5 . #xE384)
                     (#xF4D4 . #xE383)
                     (#xF4D3 . #xE382)
                     (#xF4D2 . #xE381)
                     (#xF4D1 . #xE380)
                     (#xF4D0 . #xE37F)
                     (#xF4CF . #xE37E)
                     (#xF4CE . #xE37D)
                     (#xF4CD . #xE37C)
                     (#xF4CC . #xE37B)
                     (#xF4CB . #xE37A)
                     (#xF4CA . #xE379)
                     (#xF4C9 . #xE378)
                     (#xF4C8 . #xE377)
                     (#xF4C7 . #xE376)
                     (#xF4C6 . #xE375)
                     (#xF4C5 . #xE374)
                     (#xF4C4 . #xE373)
                     (#xF4C3 . #xE372)
                     (#xF4C2 . #xE371)
                     (#xF4C1 . #xE370)
                     (#xF4C0 . #xE36F)
                     (#xF4BF . #xE36E)
                     (#xF4BE . #xE36D)
                     (#xF4BD . #xE36C)
                     (#xF4BC . #xE36B)
                     (#xF4BB . #xE36A)
                     (#xF4BA . #xE369)
                     (#xF4B9 . #xE368)
                     (#xF4B8 . #xE367)
                     (#xF4B7 . #xE366)
                     (#xF4B6 . #xE365)
                     (#xF4B5 . #xE364)
                     (#xF4B4 . #xE363)
                     (#xF4B3 . #xE362)
                     (#xF4B2 . #xE361)
                     (#xF4B1 . #xE360)
                     (#xF4B0 . #xE35F)
                     (#xF4AF . #xE35E)
                     (#xF4AE . #xE35D)
                     (#xF4AD . #xE35C)
                     (#xF4AC . #xE35B)
                     (#xF4AB . #xE35A)
                     (#xF4AA . #xE359)
                     (#xF4A9 . #xE358)
                     (#xF4A8 . #xE357)
                     (#xF4A7 . #xE356)
                     (#xF4A6 . #xE355)
                     (#xF4A5 . #xE354)
                     (#xF4A4 . #xE353)
                     (#xF4A3 . #xE352)
                     (#xF4A2 . #xE351)
                     (#xF4A1 . #xE350)
                     (#xF4A0 . #xE34F)
                     (#xF49F . #xE34E)
                     (#xF49E . #xE34D)
                     (#xF49D . #xE34C)
                     (#xF49C . #xE34B)
                     (#xF49B . #xE34A)
                     (#xF49A . #xE349)
                     (#xF499 . #xE348)
                     (#xF498 . #xE347)
                     (#xF497 . #xE346)
                     (#xF496 . #xE345)
                     (#xF495 . #xE344)
                     (#xF494 . #xE343)
                     (#xF493 . #xE342)
                     (#xF492 . #xE341)
                     (#xF491 . #xE340)
                     (#xF490 . #xE33F)
                     (#xF48F . #xE33E)
                     (#xF48E . #xE33D)
                     (#xF48D . #xE33C)
                     (#xF48C . #xE33B)
                     (#xF48B . #xE33A)
                     (#xF48A . #xE339)
                     (#xF489 . #xE338)
                     (#xF488 . #xE337)
                     (#xF487 . #xE336)
                     (#xF486 . #xE335)
                     (#xF485 . #xE334)
                     (#xF484 . #xE333)
                     (#xF483 . #xE332)
                     (#xF482 . #xE331)
                     (#xF481 . #xE330)
                     (#xF480 . #xE32F)
                     (#xF47E . #xE32E)
                     (#xF47D . #xE32D)
                     (#xF47C . #xE32C)
                     (#xF47B . #xE32B)
                     (#xF47A . #xE32A)
                     (#xF479 . #xE329)
                     (#xF478 . #xE328)
                     (#xF477 . #xE327)
                     (#xF476 . #xE326)
                     (#xF475 . #xE325)
                     (#xF474 . #xE324)
                     (#xF473 . #xE323)
                     (#xF472 . #xE322)
                     (#xF471 . #xE321)
                     (#xF470 . #xE320)
                     (#xF46F . #xE31F)
                     (#xF46E . #xE31E)
                     (#xF46D . #xE31D)
                     (#xF46C . #xE31C)
                     (#xF46B . #xE31B)
                     (#xF46A . #xE31A)
                     (#xF469 . #xE319)
                     (#xF468 . #xE318)
                     (#xF467 . #xE317)
                     (#xF466 . #xE316)
                     (#xF465 . #xE315)
                     (#xF464 . #xE314)
                     (#xF463 . #xE313)
                     (#xF462 . #xE312)
                     (#xF461 . #xE311)
                     (#xF460 . #xE310)
                     (#xF45F . #xE30F)
                     (#xF45E . #xE30E)
                     (#xF45D . #xE30D)
                     (#xF45C . #xE30C)
                     (#xF45B . #xE30B)
                     (#xF45A . #xE30A)
                     (#xF459 . #xE309)
                     (#xF458 . #xE308)
                     (#xF457 . #xE307)
                     (#xF456 . #xE306)
                     (#xF455 . #xE305)
                     (#xF454 . #xE304)
                     (#xF453 . #xE303)
                     (#xF452 . #xE302)
                     (#xF451 . #xE301)
                     (#xF450 . #xE300)
                     (#xF44F . #xE2FF)
                     (#xF44E . #xE2FE)
                     (#xF44D . #xE2FD)
                     (#xF44C . #xE2FC)
                     (#xF44B . #xE2FB)
                     (#xF44A . #xE2FA)
                     (#xF449 . #xE2F9)
                     (#xF448 . #xE2F8)
                     (#xF447 . #xE2F7)
                     (#xF446 . #xE2F6)
                     (#xF445 . #xE2F5)
                     (#xF444 . #xE2F4)
                     (#xF443 . #xE2F3)
                     (#xF442 . #xE2F2)
                     (#xF441 . #xE2F1)
                     (#xF440 . #xE2F0)
                     (#xF3FC . #xE2EF)
                     (#xF3FB . #xE2EE)
                     (#xF3FA . #xE2ED)
                     (#xF3F9 . #xE2EC)
                     (#xF3F8 . #xE2EB)
                     (#xF3F7 . #xE2EA)
                     (#xF3F6 . #xE2E9)
                     (#xF3F5 . #xE2E8)
                     (#xF3F4 . #xE2E7)
                     (#xF3F3 . #xE2E6)
                     (#xF3F2 . #xE2E5)
                     (#xF3F1 . #xE2E4)
                     (#xF3F0 . #xE2E3)
                     (#xF3EF . #xE2E2)
                     (#xF3EE . #xE2E1)
                     (#xF3ED . #xE2E0)
                     (#xF3EC . #xE2DF)
                     (#xF3EB . #xE2DE)
                     (#xF3EA . #xE2DD)
                     (#xF3E9 . #xE2DC)
                     (#xF3E8 . #xE2DB)
                     (#xF3E7 . #xE2DA)
                     (#xF3E6 . #xE2D9)
                     (#xF3E5 . #xE2D8)
                     (#xF3E4 . #xE2D7)
                     (#xF3E3 . #xE2D6)
                     (#xF3E2 . #xE2D5)
                     (#xF3E1 . #xE2D4)
                     (#xF3E0 . #xE2D3)
                     (#xF3DF . #xE2D2)
                     (#xF3DE . #xE2D1)
                     (#xF3DD . #xE2D0)
                     (#xF3DC . #xE2CF)
                     (#xF3DB . #xE2CE)
                     (#xF3DA . #xE2CD)
                     (#xF3D9 . #xE2CC)
                     (#xF3D8 . #xE2CB)
                     (#xF3D7 . #xE2CA)
                     (#xF3D6 . #xE2C9)
                     (#xF3D5 . #xE2C8)
                     (#xF3D4 . #xE2C7)
                     (#xF3D3 . #xE2C6)
                     (#xF3D2 . #xE2C5)
                     (#xF3D1 . #xE2C4)
                     (#xF3D0 . #xE2C3)
                     (#xF3CF . #xE2C2)
                     (#xF3CE . #xE2C1)
                     (#xF3CD . #xE2C0)
                     (#xF3CC . #xE2BF)
                     (#xF3CB . #xE2BE)
                     (#xF3CA . #xE2BD)
                     (#xF3C9 . #xE2BC)
                     (#xF3C8 . #xE2BB)
                     (#xF3C7 . #xE2BA)
                     (#xF3C6 . #xE2B9)
                     (#xF3C5 . #xE2B8)
                     (#xF3C4 . #xE2B7)
                     (#xF3C3 . #xE2B6)
                     (#xF3C2 . #xE2B5)
                     (#xF3C1 . #xE2B4)
                     (#xF3C0 . #xE2B3)
                     (#xF3BF . #xE2B2)
                     (#xF3BE . #xE2B1)
                     (#xF3BD . #xE2B0)
                     (#xF3BC . #xE2AF)
                     (#xF3BB . #xE2AE)
                     (#xF3BA . #xE2AD)
                     (#xF3B9 . #xE2AC)
                     (#xF3B8 . #xE2AB)
                     (#xF3B7 . #xE2AA)
                     (#xF3B6 . #xE2A9)
                     (#xF3B5 . #xE2A8)
                     (#xF3B4 . #xE2A7)
                     (#xF3B3 . #xE2A6)
                     (#xF3B2 . #xE2A5)
                     (#xF3B1 . #xE2A4)
                     (#xF3B0 . #xE2A3)
                     (#xF3AF . #xE2A2)
                     (#xF3AE . #xE2A1)
                     (#xF3AD . #xE2A0)
                     (#xF3AC . #xE29F)
                     (#xF3AB . #xE29E)
                     (#xF3AA . #xE29D)
                     (#xF3A9 . #xE29C)
                     (#xF3A8 . #xE29B)
                     (#xF3A7 . #xE29A)
                     (#xF3A6 . #xE299)
                     (#xF3A5 . #xE298)
                     (#xF3A4 . #xE297)
                     (#xF3A3 . #xE296)
                     (#xF3A2 . #xE295)
                     (#xF3A1 . #xE294)
                     (#xF3A0 . #xE293)
                     (#xF39F . #xE292)
                     (#xF39E . #xE291)
                     (#xF39D . #xE290)
                     (#xF39C . #xE28F)
                     (#xF39B . #xE28E)
                     (#xF39A . #xE28D)
                     (#xF399 . #xE28C)
                     (#xF398 . #xE28B)
                     (#xF397 . #xE28A)
                     (#xF396 . #xE289)
                     (#xF395 . #xE288)
                     (#xF394 . #xE287)
                     (#xF393 . #xE286)
                     (#xF392 . #xE285)
                     (#xF391 . #xE284)
                     (#xF390 . #xE283)
                     (#xF38F . #xE282)
                     (#xF38E . #xE281)
                     (#xF38D . #xE280)
                     (#xF38C . #xE27F)
                     (#xF38B . #xE27E)
                     (#xF38A . #xE27D)
                     (#xF389 . #xE27C)
                     (#xF388 . #xE27B)
                     (#xF387 . #xE27A)
                     (#xF386 . #xE279)
                     (#xF385 . #xE278)
                     (#xF384 . #xE277)
                     (#xF383 . #xE276)
                     (#xF382 . #xE275)
                     (#xF381 . #xE274)
                     (#xF380 . #xE273)
                     (#xF37E . #xE272)
                     (#xF37D . #xE271)
                     (#xF37C . #xE270)
                     (#xF37B . #xE26F)
                     (#xF37A . #xE26E)
                     (#xF379 . #xE26D)
                     (#xF378 . #xE26C)
                     (#xF377 . #xE26B)
                     (#xF376 . #xE26A)
                     (#xF375 . #xE269)
                     (#xF374 . #xE268)
                     (#xF373 . #xE267)
                     (#xF372 . #xE266)
                     (#xF371 . #xE265)
                     (#xF370 . #xE264)
                     (#xF36F . #xE263)
                     (#xF36E . #xE262)
                     (#xF36D . #xE261)
                     (#xF36C . #xE260)
                     (#xF36B . #xE25F)
                     (#xF36A . #xE25E)
                     (#xF369 . #xE25D)
                     (#xF368 . #xE25C)
                     (#xF367 . #xE25B)
                     (#xF366 . #xE25A)
                     (#xF365 . #xE259)
                     (#xF364 . #xE258)
                     (#xF363 . #xE257)
                     (#xF362 . #xE256)
                     (#xF361 . #xE255)
                     (#xF360 . #xE254)
                     (#xF35F . #xE253)
                     (#xF35E . #xE252)
                     (#xF35D . #xE251)
                     (#xF35C . #xE250)
                     (#xF35B . #xE24F)
                     (#xF35A . #xE24E)
                     (#xF359 . #xE24D)
                     (#xF358 . #xE24C)
                     (#xF357 . #xE24B)
                     (#xF356 . #xE24A)
                     (#xF355 . #xE249)
                     (#xF354 . #xE248)
                     (#xF353 . #xE247)
                     (#xF352 . #xE246)
                     (#xF351 . #xE245)
                     (#xF350 . #xE244)
                     (#xF34F . #xE243)
                     (#xF34E . #xE242)
                     (#xF34D . #xE241)
                     (#xF34C . #xE240)
                     (#xF34B . #xE23F)
                     (#xF34A . #xE23E)
                     (#xF349 . #xE23D)
                     (#xF348 . #xE23C)
                     (#xF347 . #xE23B)
                     (#xF346 . #xE23A)
                     (#xF345 . #xE239)
                     (#xF344 . #xE238)
                     (#xF343 . #xE237)
                     (#xF342 . #xE236)
                     (#xF341 . #xE235)
                     (#xF340 . #xE234)
                     (#xF2FC . #xE233)
                     (#xF2FB . #xE232)
                     (#xF2FA . #xE231)
                     (#xF2F9 . #xE230)
                     (#xF2F8 . #xE22F)
                     (#xF2F7 . #xE22E)
                     (#xF2F6 . #xE22D)
                     (#xF2F5 . #xE22C)
                     (#xF2F4 . #xE22B)
                     (#xF2F3 . #xE22A)
                     (#xF2F2 . #xE229)
                     (#xF2F1 . #xE228)
                     (#xF2F0 . #xE227)
                     (#xF2EF . #xE226)
                     (#xF2EE . #xE225)
                     (#xF2ED . #xE224)
                     (#xF2EC . #xE223)
                     (#xF2EB . #xE222)
                     (#xF2EA . #xE221)
                     (#xF2E9 . #xE220)
                     (#xF2E8 . #xE21F)
                     (#xF2E7 . #xE21E)
                     (#xF2E6 . #xE21D)
                     (#xF2E5 . #xE21C)
                     (#xF2E4 . #xE21B)
                     (#xF2E3 . #xE21A)
                     (#xF2E2 . #xE219)
                     (#xF2E1 . #xE218)
                     (#xF2E0 . #xE217)
                     (#xF2DF . #xE216)
                     (#xF2DE . #xE215)
                     (#xF2DD . #xE214)
                     (#xF2DC . #xE213)
                     (#xF2DB . #xE212)
                     (#xF2DA . #xE211)
                     (#xF2D9 . #xE210)
                     (#xF2D8 . #xE20F)
                     (#xF2D7 . #xE20E)
                     (#xF2D6 . #xE20D)
                     (#xF2D5 . #xE20C)
                     (#xF2D4 . #xE20B)
                     (#xF2D3 . #xE20A)
                     (#xF2D2 . #xE209)
                     (#xF2D1 . #xE208)
                     (#xF2D0 . #xE207)
                     (#xF2CF . #xE206)
                     (#xF2CE . #xE205)
                     (#xF2CD . #xE204)
                     (#xF2CC . #xE203)
                     (#xF2CB . #xE202)
                     (#xF2CA . #xE201)
                     (#xF2C9 . #xE200)
                     (#xF2C8 . #xE1FF)
                     (#xF2C7 . #xE1FE)
                     (#xF2C6 . #xE1FD)
                     (#xF2C5 . #xE1FC)
                     (#xF2C4 . #xE1FB)
                     (#xF2C3 . #xE1FA)
                     (#xF2C2 . #xE1F9)
                     (#xF2C1 . #xE1F8)
                     (#xF2C0 . #xE1F7)
                     (#xF2BF . #xE1F6)
                     (#xF2BE . #xE1F5)
                     (#xF2BD . #xE1F4)
                     (#xF2BC . #xE1F3)
                     (#xF2BB . #xE1F2)
                     (#xF2BA . #xE1F1)
                     (#xF2B9 . #xE1F0)
                     (#xF2B8 . #xE1EF)
                     (#xF2B7 . #xE1EE)
                     (#xF2B6 . #xE1ED)
                     (#xF2B5 . #xE1EC)
                     (#xF2B4 . #xE1EB)
                     (#xF2B3 . #xE1EA)
                     (#xF2B2 . #xE1E9)
                     (#xF2B1 . #xE1E8)
                     (#xF2B0 . #xE1E7)
                     (#xF2AF . #xE1E6)
                     (#xF2AE . #xE1E5)
                     (#xF2AD . #xE1E4)
                     (#xF2AC . #xE1E3)
                     (#xF2AB . #xE1E2)
                     (#xF2AA . #xE1E1)
                     (#xF2A9 . #xE1E0)
                     (#xF2A8 . #xE1DF)
                     (#xF2A7 . #xE1DE)
                     (#xF2A6 . #xE1DD)
                     (#xF2A5 . #xE1DC)
                     (#xF2A4 . #xE1DB)
                     (#xF2A3 . #xE1DA)
                     (#xF2A2 . #xE1D9)
                     (#xF2A1 . #xE1D8)
                     (#xF2A0 . #xE1D7)
                     (#xF29F . #xE1D6)
                     (#xF29E . #xE1D5)
                     (#xF29D . #xE1D4)
                     (#xF29C . #xE1D3)
                     (#xF29B . #xE1D2)
                     (#xF29A . #xE1D1)
                     (#xF299 . #xE1D0)
                     (#xF298 . #xE1CF)
                     (#xF297 . #xE1CE)
                     (#xF296 . #xE1CD)
                     (#xF295 . #xE1CC)
                     (#xF294 . #xE1CB)
                     (#xF293 . #xE1CA)
                     (#xF292 . #xE1C9)
                     (#xF291 . #xE1C8)
                     (#xF290 . #xE1C7)
                     (#xF28F . #xE1C6)
                     (#xF28E . #xE1C5)
                     (#xF28D . #xE1C4)
                     (#xF28C . #xE1C3)
                     (#xF28B . #xE1C2)
                     (#xF28A . #xE1C1)
                     (#xF289 . #xE1C0)
                     (#xF288 . #xE1BF)
                     (#xF287 . #xE1BE)
                     (#xF286 . #xE1BD)
                     (#xF285 . #xE1BC)
                     (#xF284 . #xE1BB)
                     (#xF283 . #xE1BA)
                     (#xF282 . #xE1B9)
                     (#xF281 . #xE1B8)
                     (#xF280 . #xE1B7)
                     (#xF27E . #xE1B6)
                     (#xF27D . #xE1B5)
                     (#xF27C . #xE1B4)
                     (#xF27B . #xE1B3)
                     (#xF27A . #xE1B2)
                     (#xF279 . #xE1B1)
                     (#xF278 . #xE1B0)
                     (#xF277 . #xE1AF)
                     (#xF276 . #xE1AE)
                     (#xF275 . #xE1AD)
                     (#xF274 . #xE1AC)
                     (#xF273 . #xE1AB)
                     (#xF272 . #xE1AA)
                     (#xF271 . #xE1A9)
                     (#xF270 . #xE1A8)
                     (#xF26F . #xE1A7)
                     (#xF26E . #xE1A6)
                     (#xF26D . #xE1A5)
                     (#xF26C . #xE1A4)
                     (#xF26B . #xE1A3)
                     (#xF26A . #xE1A2)
                     (#xF269 . #xE1A1)
                     (#xF268 . #xE1A0)
                     (#xF267 . #xE19F)
                     (#xF266 . #xE19E)
                     (#xF265 . #xE19D)
                     (#xF264 . #xE19C)
                     (#xF263 . #xE19B)
                     (#xF262 . #xE19A)
                     (#xF261 . #xE199)
                     (#xF260 . #xE198)
                     (#xF25F . #xE197)
                     (#xF25E . #xE196)
                     (#xF25D . #xE195)
                     (#xF25C . #xE194)
                     (#xF25B . #xE193)
                     (#xF25A . #xE192)
                     (#xF259 . #xE191)
                     (#xF258 . #xE190)
                     (#xF257 . #xE18F)
                     (#xF256 . #xE18E)
                     (#xF255 . #xE18D)
                     (#xF254 . #xE18C)
                     (#xF253 . #xE18B)
                     (#xF252 . #xE18A)
                     (#xF251 . #xE189)
                     (#xF250 . #xE188)
                     (#xF24F . #xE187)
                     (#xF24E . #xE186)
                     (#xF24D . #xE185)
                     (#xF24C . #xE184)
                     (#xF24B . #xE183)
                     (#xF24A . #xE182)
                     (#xF249 . #xE181)
                     (#xF248 . #xE180)
                     (#xF247 . #xE17F)
                     (#xF246 . #xE17E)
                     (#xF245 . #xE17D)
                     (#xF244 . #xE17C)
                     (#xF243 . #xE17B)
                     (#xF242 . #xE17A)
                     (#xF241 . #xE179)
                     (#xF240 . #xE178)
                     (#xF1FC . #xE177)
                     (#xF1FB . #xE176)
                     (#xF1FA . #xE175)
                     (#xF1F9 . #xE174)
                     (#xF1F8 . #xE173)
                     (#xF1F7 . #xE172)
                     (#xF1F6 . #xE171)
                     (#xF1F5 . #xE170)
                     (#xF1F4 . #xE16F)
                     (#xF1F3 . #xE16E)
                     (#xF1F2 . #xE16D)
                     (#xF1F1 . #xE16C)
                     (#xF1F0 . #xE16B)
                     (#xF1EF . #xE16A)
                     (#xF1EE . #xE169)
                     (#xF1ED . #xE168)
                     (#xF1EC . #xE167)
                     (#xF1EB . #xE166)
                     (#xF1EA . #xE165)
                     (#xF1E9 . #xE164)
                     (#xF1E8 . #xE163)
                     (#xF1E7 . #xE162)
                     (#xF1E6 . #xE161)
                     (#xF1E5 . #xE160)
                     (#xF1E4 . #xE15F)
                     (#xF1E3 . #xE15E)
                     (#xF1E2 . #xE15D)
                     (#xF1E1 . #xE15C)
                     (#xF1E0 . #xE15B)
                     (#xF1DF . #xE15A)
                     (#xF1DE . #xE159)
                     (#xF1DD . #xE158)
                     (#xF1DC . #xE157)
                     (#xF1DB . #xE156)
                     (#xF1DA . #xE155)
                     (#xF1D9 . #xE154)
                     (#xF1D8 . #xE153)
                     (#xF1D7 . #xE152)
                     (#xF1D6 . #xE151)
                     (#xF1D5 . #xE150)
                     (#xF1D4 . #xE14F)
                     (#xF1D3 . #xE14E)
                     (#xF1D2 . #xE14D)
                     (#xF1D1 . #xE14C)
                     (#xF1D0 . #xE14B)
                     (#xF1CF . #xE14A)
                     (#xF1CE . #xE149)
                     (#xF1CD . #xE148)
                     (#xF1CC . #xE147)
                     (#xF1CB . #xE146)
                     (#xF1CA . #xE145)
                     (#xF1C9 . #xE144)
                     (#xF1C8 . #xE143)
                     (#xF1C7 . #xE142)
                     (#xF1C6 . #xE141)
                     (#xF1C5 . #xE140)
                     (#xF1C4 . #xE13F)
                     (#xF1C3 . #xE13E)
                     (#xF1C2 . #xE13D)
                     (#xF1C1 . #xE13C)
                     (#xF1C0 . #xE13B)
                     (#xF1BF . #xE13A)
                     (#xF1BE . #xE139)
                     (#xF1BD . #xE138)
                     (#xF1BC . #xE137)
                     (#xF1BB . #xE136)
                     (#xF1BA . #xE135)
                     (#xF1B9 . #xE134)
                     (#xF1B8 . #xE133)
                     (#xF1B7 . #xE132)
                     (#xF1B6 . #xE131)
                     (#xF1B5 . #xE130)
                     (#xF1B4 . #xE12F)
                     (#xF1B3 . #xE12E)
                     (#xF1B2 . #xE12D)
                     (#xF1B1 . #xE12C)
                     (#xF1B0 . #xE12B)
                     (#xF1AF . #xE12A)
                     (#xF1AE . #xE129)
                     (#xF1AD . #xE128)
                     (#xF1AC . #xE127)
                     (#xF1AB . #xE126)
                     (#xF1AA . #xE125)
                     (#xF1A9 . #xE124)
                     (#xF1A8 . #xE123)
                     (#xF1A7 . #xE122)
                     (#xF1A6 . #xE121)
                     (#xF1A5 . #xE120)
                     (#xF1A4 . #xE11F)
                     (#xF1A3 . #xE11E)
                     (#xF1A2 . #xE11D)
                     (#xF1A1 . #xE11C)
                     (#xF1A0 . #xE11B)
                     (#xF19F . #xE11A)
                     (#xF19E . #xE119)
                     (#xF19D . #xE118)
                     (#xF19C . #xE117)
                     (#xF19B . #xE116)
                     (#xF19A . #xE115)
                     (#xF199 . #xE114)
                     (#xF198 . #xE113)
                     (#xF197 . #xE112)
                     (#xF196 . #xE111)
                     (#xF195 . #xE110)
                     (#xF194 . #xE10F)
                     (#xF193 . #xE10E)
                     (#xF192 . #xE10D)
                     (#xF191 . #xE10C)
                     (#xF190 . #xE10B)
                     (#xF18F . #xE10A)
                     (#xF18E . #xE109)
                     (#xF18D . #xE108)
                     (#xF18C . #xE107)
                     (#xF18B . #xE106)
                     (#xF18A . #xE105)
                     (#xF189 . #xE104)
                     (#xF188 . #xE103)
                     (#xF187 . #xE102)
                     (#xF186 . #xE101)
                     (#xF185 . #xE100)
                     (#xF184 . #xE0FF)
                     (#xF183 . #xE0FE)
                     (#xF182 . #xE0FD)
                     (#xF181 . #xE0FC)
                     (#xF180 . #xE0FB)
                     (#xF17E . #xE0FA)
                     (#xF17D . #xE0F9)
                     (#xF17C . #xE0F8)
                     (#xF17B . #xE0F7)
                     (#xF17A . #xE0F6)
                     (#xF179 . #xE0F5)
                     (#xF178 . #xE0F4)
                     (#xF177 . #xE0F3)
                     (#xF176 . #xE0F2)
                     (#xF175 . #xE0F1)
                     (#xF174 . #xE0F0)
                     (#xF173 . #xE0EF)
                     (#xF172 . #xE0EE)
                     (#xF171 . #xE0ED)
                     (#xF170 . #xE0EC)
                     (#xF16F . #xE0EB)
                     (#xF16E . #xE0EA)
                     (#xF16D . #xE0E9)
                     (#xF16C . #xE0E8)
                     (#xF16B . #xE0E7)
                     (#xF16A . #xE0E6)
                     (#xF169 . #xE0E5)
                     (#xF168 . #xE0E4)
                     (#xF167 . #xE0E3)
                     (#xF166 . #xE0E2)
                     (#xF165 . #xE0E1)
                     (#xF164 . #xE0E0)
                     (#xF163 . #xE0DF)
                     (#xF162 . #xE0DE)
                     (#xF161 . #xE0DD)
                     (#xF160 . #xE0DC)
                     (#xF15F . #xE0DB)
                     (#xF15E . #xE0DA)
                     (#xF15D . #xE0D9)
                     (#xF15C . #xE0D8)
                     (#xF15B . #xE0D7)
                     (#xF15A . #xE0D6)
                     (#xF159 . #xE0D5)
                     (#xF158 . #xE0D4)
                     (#xF157 . #xE0D3)
                     (#xF156 . #xE0D2)
                     (#xF155 . #xE0D1)
                     (#xF154 . #xE0D0)
                     (#xF153 . #xE0CF)
                     (#xF152 . #xE0CE)
                     (#xF151 . #xE0CD)
                     (#xF150 . #xE0CC)
                     (#xF14F . #xE0CB)
                     (#xF14E . #xE0CA)
                     (#xF14D . #xE0C9)
                     (#xF14C . #xE0C8)
                     (#xF14B . #xE0C7)
                     (#xF14A . #xE0C6)
                     (#xF149 . #xE0C5)
                     (#xF148 . #xE0C4)
                     (#xF147 . #xE0C3)
                     (#xF146 . #xE0C2)
                     (#xF145 . #xE0C1)
                     (#xF144 . #xE0C0)
                     (#xF143 . #xE0BF)
                     (#xF142 . #xE0BE)
                     (#xF141 . #xE0BD)
                     (#xF140 . #xE0BC)
                     (#xF0FC . #xE0BB)
                     (#xF0FB . #xE0BA)
                     (#xF0FA . #xE0B9)
                     (#xF0F9 . #xE0B8)
                     (#xF0F8 . #xE0B7)
                     (#xF0F7 . #xE0B6)
                     (#xF0F6 . #xE0B5)
                     (#xF0F5 . #xE0B4)
                     (#xF0F4 . #xE0B3)
                     (#xF0F3 . #xE0B2)
                     (#xF0F2 . #xE0B1)
                     (#xF0F1 . #xE0B0)
                     (#xF0F0 . #xE0AF)
                     (#xF0EF . #xE0AE)
                     (#xF0EE . #xE0AD)
                     (#xF0ED . #xE0AC)
                     (#xF0EC . #xE0AB)
                     (#xF0EB . #xE0AA)
                     (#xF0EA . #xE0A9)
                     (#xF0E9 . #xE0A8)
                     (#xF0E8 . #xE0A7)
                     (#xF0E7 . #xE0A6)
                     (#xF0E6 . #xE0A5)
                     (#xF0E5 . #xE0A4)
                     (#xF0E4 . #xE0A3)
                     (#xF0E3 . #xE0A2)
                     (#xF0E2 . #xE0A1)
                     (#xF0E1 . #xE0A0)
                     (#xF0E0 . #xE09F)
                     (#xF0DF . #xE09E)
                     (#xF0DE . #xE09D)
                     (#xF0DD . #xE09C)
                     (#xF0DC . #xE09B)
                     (#xF0DB . #xE09A)
                     (#xF0DA . #xE099)
                     (#xF0D9 . #xE098)
                     (#xF0D8 . #xE097)
                     (#xF0D7 . #xE096)
                     (#xF0D6 . #xE095)
                     (#xF0D5 . #xE094)
                     (#xF0D4 . #xE093)
                     (#xF0D3 . #xE092)
                     (#xF0D2 . #xE091)
                     (#xF0D1 . #xE090)
                     (#xF0D0 . #xE08F)
                     (#xF0CF . #xE08E)
                     (#xF0CE . #xE08D)
                     (#xF0CD . #xE08C)
                     (#xF0CC . #xE08B)
                     (#xF0CB . #xE08A)
                     (#xF0CA . #xE089)
                     (#xF0C9 . #xE088)
                     (#xF0C8 . #xE087)
                     (#xF0C7 . #xE086)
                     (#xF0C6 . #xE085)
                     (#xF0C5 . #xE084)
                     (#xF0C4 . #xE083)
                     (#xF0C3 . #xE082)
                     (#xF0C2 . #xE081)
                     (#xF0C1 . #xE080)
                     (#xF0C0 . #xE07F)
                     (#xF0BF . #xE07E)
                     (#xF0BE . #xE07D)
                     (#xF0BD . #xE07C)
                     (#xF0BC . #xE07B)
                     (#xF0BB . #xE07A)
                     (#xF0BA . #xE079)
                     (#xF0B9 . #xE078)
                     (#xF0B8 . #xE077)
                     (#xF0B7 . #xE076)
                     (#xF0B6 . #xE075)
                     (#xF0B5 . #xE074)
                     (#xF0B4 . #xE073)
                     (#xF0B3 . #xE072)
                     (#xF0B2 . #xE071)
                     (#xF0B1 . #xE070)
                     (#xF0B0 . #xE06F)
                     (#xF0AF . #xE06E)
                     (#xF0AE . #xE06D)
                     (#xF0AD . #xE06C)
                     (#xF0AC . #xE06B)
                     (#xF0AB . #xE06A)
                     (#xF0AA . #xE069)
                     (#xF0A9 . #xE068)
                     (#xF0A8 . #xE067)
                     (#xF0A7 . #xE066)
                     (#xF0A6 . #xE065)
                     (#xF0A5 . #xE064)
                     (#xF0A4 . #xE063)
                     (#xF0A3 . #xE062)
                     (#xF0A2 . #xE061)
                     (#xF0A1 . #xE060)
                     (#xF0A0 . #xE05F)
                     (#xF09F . #xE05E)
                     (#xF09E . #xE05D)
                     (#xF09D . #xE05C)
                     (#xF09C . #xE05B)
                     (#xF09B . #xE05A)
                     (#xF09A . #xE059)
                     (#xF099 . #xE058)
                     (#xF098 . #xE057)
                     (#xF097 . #xE056)
                     (#xF096 . #xE055)
                     (#xF095 . #xE054)
                     (#xF094 . #xE053)
                     (#xF093 . #xE052)
                     (#xF092 . #xE051)
                     (#xF091 . #xE050)
                     (#xF090 . #xE04F)
                     (#xF08F . #xE04E)
                     (#xF08E . #xE04D)
                     (#xF08D . #xE04C)
                     (#xF08C . #xE04B)
                     (#xF08B . #xE04A)
                     (#xF08A . #xE049)
                     (#xF089 . #xE048)
                     (#xF088 . #xE047)
                     (#xF087 . #xE046)
                     (#xF086 . #xE045)
                     (#xF085 . #xE044)
                     (#xF084 . #xE043)
                     (#xF083 . #xE042)
                     (#xF082 . #xE041)
                     (#xF081 . #xE040)
                     (#xF080 . #xE03F)
                     (#xF07E . #xE03E)
                     (#xF07D . #xE03D)
                     (#xF07C . #xE03C)
                     (#xF07B . #xE03B)
                     (#xF07A . #xE03A)
                     (#xF079 . #xE039)
                     (#xF078 . #xE038)
                     (#xF077 . #xE037)
                     (#xF076 . #xE036)
                     (#xF075 . #xE035)
                     (#xF074 . #xE034)
                     (#xF073 . #xE033)
                     (#xF072 . #xE032)
                     (#xF071 . #xE031)
                     (#xF070 . #xE030)
                     (#xF06F . #xE02F)
                     (#xF06E . #xE02E)
                     (#xF06D . #xE02D)
                     (#xF06C . #xE02C)
                     (#xF06B . #xE02B)
                     (#xF06A . #xE02A)
                     (#xF069 . #xE029)
                     (#xF068 . #xE028)
                     (#xF067 . #xE027)
                     (#xF066 . #xE026)
                     (#xF065 . #xE025)
                     (#xF064 . #xE024)
                     (#xF063 . #xE023)
                     (#xF062 . #xE022)
                     (#xF061 . #xE021)
                     (#xF060 . #xE020)
                     (#xF05F . #xE01F)
                     (#xF05E . #xE01E)
                     (#xF05D . #xE01D)
                     (#xF05C . #xE01C)
                     (#xF05B . #xE01B)
                     (#xF05A . #xE01A)
                     (#xF059 . #xE019)
                     (#xF058 . #xE018)
                     (#xF057 . #xE017)
                     (#xF056 . #xE016)
                     (#xF055 . #xE015)
                     (#xF054 . #xE014)
                     (#xF053 . #xE013)
                     (#xF052 . #xE012)
                     (#xF051 . #xE011)
                     (#xF050 . #xE010)
                     (#xF04F . #xE00F)
                     (#xF04E . #xE00E)
                     (#xF04D . #xE00D)
                     (#xF04C . #xE00C)
                     (#xF04B . #xE00B)
                     (#xF04A . #xE00A)
                     (#xF049 . #xE009)
                     (#xF048 . #xE008)
                     (#xF047 . #xE007)
                     (#xF046 . #xE006)
                     (#xF045 . #xE005)
                     (#xF044 . #xE004)
                     (#xF043 . #xE003)
                     (#xF042 . #xE002)
                     (#xF041 . #xE001)
                     (#xF040 . #xE000)
                     (#xEEFC . #xFF02)
                     (#xEEFB . #xFF07)
                     (#xEEFA . #xFFE4)
                     (#xEEF9 . #xFFE2)
                     (#xEEF8 . #x2179)
                     (#xEEF7 . #x2178)
                     (#xEEF6 . #x2177)
                     (#xEEF5 . #x2176)
                     (#xEEF4 . #x2175)
                     (#xEEF3 . #x2174)
                     (#xEEF2 . #x2173)
                     (#xEEF1 . #x2172)
                     (#xEEF0 . #x2171)
                     (#xEEEF . #x2170)
                     (#xEEEC . #x9ED1)
                     (#xEEEB . #x9E19)
                     (#xEEEA . #xFA2D)
                     (#xEEE9 . #x9D6B)
                     (#xEEE8 . #x9D70)
                     (#xEEE7 . #x9C00)
                     (#xEEE6 . #x9BBB)
                     (#xEEE5 . #x9BB1)
                     (#xEEE4 . #x9B8F)
                     (#xEEE3 . #x9B72)
                     (#xEEE2 . #x9B75)
                     (#xEEE1 . #x9ADC)
                     (#xEEE0 . #x9AD9)
                     (#xEEDF . #x9A4E)
                     (#xEEDE . #x999E)
                     (#xEEDD . #xFA2C)
                     (#xEEDC . #x9927)
                     (#xEEDB . #xFA2B)
                     (#xEEDA . #xFA2A)
                     (#xEED9 . #x9865)
                     (#xEED8 . #x9857)
                     (#xEED7 . #x9755)
                     (#xEED6 . #x9751)
                     (#xEED5 . #x974F)
                     (#xEED4 . #x974D)
                     (#xEED3 . #x9743)
                     (#xEED2 . #x973B)
                     (#xEED1 . #x9733)
                     (#xEED0 . #x96AF)
                     (#xEECF . #x969D)
                     (#xEECE . #xFA29)
                     (#xEECD . #xF9DC)
                     (#xEECC . #x9592)
                     (#xEECB . #x9448)
                     (#xEECA . #x9445)
                     (#xEEC9 . #x9431)
                     (#xEEC8 . #x93F8)
                     (#xEEC7 . #x93DE)
                     (#xEEC6 . #x93C6)
                     (#xEEC5 . #x93A4)
                     (#xEEC4 . #x9357)
                     (#xEEC3 . #x9370)
                     (#xEEC2 . #x9302)
                     (#xEEC1 . #x931D)
                     (#xEEC0 . #x92FF)
                     (#xEEBF . #x931E)
                     (#xEEBE . #xFA28)
                     (#xEEBD . #x92FB)
                     (#xEEBC . #x9321)
                     (#xEEBB . #x9325)
                     (#xEEBA . #x92D3)
                     (#xEEB9 . #x92E0)
                     (#xEEB8 . #x92D5)
                     (#xEEB7 . #xFA27)
                     (#xEEB6 . #x92D0)
                     (#xEEB5 . #x92D9)
                     (#xEEB4 . #x92D7)
                     (#xEEB3 . #x92E7)
                     (#xEEB2 . #x9278)
                     (#xEEB1 . #x9277)
                     (#xEEB0 . #x92A7)
                     (#xEEAF . #x9267)
                     (#xEEAE . #x9239)
                     (#xEEAD . #x9251)
                     (#xEEAC . #x9259)
                     (#xEEAB . #x924E)
                     (#xEEAA . #x923C)
                     (#xEEA9 . #x9240)
                     (#xEEA8 . #x923A)
                     (#xEEA7 . #x920A)
                     (#xEEA6 . #x9210)
                     (#xEEA5 . #x9206)
                     (#xEEA4 . #x91E5)
                     (#xEEA3 . #x91E4)
                     (#xEEA2 . #x91EE)
                     (#xEEA1 . #x91ED)
                     (#xEEA0 . #x91DE)
                     (#xEE9F . #x91D7)
                     (#xEE9E . #x91DA)
                     (#xEE9D . #x9127)
                     (#xEE9C . #x9115)
                     (#xEE9B . #xFA26)
                     (#xEE9A . #x90DE)
                     (#xEE99 . #x9067)
                     (#xEE98 . #xFA25)
                     (#xEE97 . #xFA24)
                     (#xEE96 . #x8ECF)
                     (#xEE95 . #xFA23)
                     (#xEE94 . #x8D76)
                     (#xEE93 . #x8D12)
                     (#xEE92 . #x8CF4)
                     (#xEE91 . #x8CF0)
                     (#xEE90 . #x8B7F)
                     (#xEE8F . #x8B53)
                     (#xEE8E . #x8AF6)
                     (#xEE8D . #xFA22)
                     (#xEE8C . #x8ADF)
                     (#xEE8B . #x8ABE)
                     (#xEE8A . #x8AA7)
                     (#xEE89 . #x8A79)
                     (#xEE88 . #x8A37)
                     (#xEE87 . #x8A12)
                     (#xEE86 . #x88F5)
                     (#xEE85 . #x8807)
                     (#xEE84 . #xFA21)
                     (#xEE83 . #xFA20)
                     (#xEE82 . #x85B0)
                     (#xEE81 . #xFA1F)
                     (#xEE80 . #x856B)
                     (#xEE7E . #x8559)
                     (#xEE7D . #x8553)
                     (#xEE7C . #x84B4)
                     (#xEE7B . #x8448)
                     (#xEE7A . #x83F6)
                     (#xEE79 . #x83C7)
                     (#xEE78 . #x837F)
                     (#xEE77 . #x8362)
                     (#xEE76 . #x8301)
                     (#xEE75 . #xFA1E)
                     (#xEE74 . #x7FA1)
                     (#xEE73 . #x7F47)
                     (#xEE72 . #x7E52)
                     (#xEE71 . #x7DD6)
                     (#xEE70 . #x7DA0)
                     (#xEE6F . #x7DB7)
                     (#xEE6E . #x7D5C)
                     (#xEE6D . #x7D48)
                     (#xEE6C . #xFA1D)
                     (#xEE6B . #x7B9E)
                     (#xEE6A . #x7AEB)
                     (#xEE69 . #xFA1C)
                     (#xEE68 . #x7AE7)
                     (#xEE67 . #x7AD1)
                     (#xEE66 . #x799B)
                     (#xEE65 . #xFA1B)
                     (#xEE64 . #x7994)
                     (#xEE63 . #xFA1A)
                     (#xEE62 . #xFA19)
                     (#xEE61 . #xFA18)
                     (#xEE60 . #x7930)
                     (#xEE5F . #x787A)
                     (#xEE5E . #x7864)
                     (#xEE5D . #x784E)
                     (#xEE5C . #x7821)
                     (#xEE5B . #x52AF)
                     (#xEE5A . #x7746)
                     (#xEE59 . #xFA17)
                     (#xEE58 . #x76A6)
                     (#xEE57 . #x769B)
                     (#xEE56 . #x769E)
                     (#xEE55 . #x769C)
                     (#xEE54 . #x7682)
                     (#xEE53 . #x756F)
                     (#xEE52 . #x7501)
                     (#xEE51 . #x749F)
                     (#xEE50 . #x7489)
                     (#xEE4F . #x7462)
                     (#xEE4E . #x742E)
                     (#xEE4D . #x7429)
                     (#xEE4C . #x742A)
                     (#xEE4B . #x7426)
                     (#xEE4A . #x73F5)
                     (#xEE49 . #x7407)
                     (#xEE48 . #x73D2)
                     (#xEE47 . #x73E3)
                     (#xEE46 . #x73D6)
                     (#xEE45 . #x73C9)
                     (#xEE44 . #x73BD)
                     (#xEE43 . #x7377)
                     (#xEE42 . #xFA16)
                     (#xEE41 . #x7324)
                     (#xEE40 . #x72BE)
                     (#xEDFC . #x72B1)
                     (#xEDFB . #x71FE)
                     (#xEDFA . #x71C1)
                     (#xEDF9 . #xFA15)
                     (#xEDF8 . #x7147)
                     (#xEDF7 . #x7146)
                     (#xEDF6 . #x715C)
                     (#xEDF5 . #x7104)
                     (#xEDF4 . #x710F)
                     (#xEDF3 . #x70AB)
                     (#xEDF2 . #x7085)
                     (#xEDF1 . #x7028)
                     (#xEDF0 . #x7007)
                     (#xEDEF . #x7005)
                     (#xEDEE . #x6FF5)
                     (#xEDED . #x6FB5)
                     (#xEDEC . #x6F88)
                     (#xEDEB . #x6EBF)
                     (#xEDEA . #x6E3C)
                     (#xEDE9 . #x6E27)
                     (#xEDE8 . #x6E5C)
                     (#xEDE7 . #x6E39)
                     (#xEDE6 . #x6DFC)
                     (#xEDE5 . #x6DF2)
                     (#xEDE4 . #x6DF8)
                     (#xEDE3 . #x6DCF)
                     (#xEDE2 . #x6DAC)
                     (#xEDE1 . #x6D96)
                     (#xEDE0 . #x6D6F)
                     (#xEDDF . #x6D87)
                     (#xEDDE . #x6D04)
                     (#xEDDD . #x6CDA)
                     (#xEDDC . #x6C6F)
                     (#xEDDB . #x6C86)
                     (#xEDDA . #x6C5C)
                     (#xEDD9 . #x6C3F)
                     (#xEDD8 . #x6BD6)
                     (#xEDD7 . #x6AE4)
                     (#xEDD6 . #x6AE2)
                     (#xEDD5 . #x6A7E)
                     (#xEDD4 . #x6A73)
                     (#xEDD3 . #x6A46)
                     (#xEDD2 . #x6A6B)
                     (#xEDD1 . #x6A30)
                     (#xEDD0 . #x69E2)
                     (#xEDCF . #x6998)
                     (#xEDCE . #xFA14)
                     (#xEDCD . #x6968)
                     (#xEDCC . #xFA13)
                     (#xEDCB . #x68CF)
                     (#xEDCA . #x6844)
                     (#xEDC9 . #x6801)
                     (#xEDC8 . #x67C0)
                     (#xEDC7 . #x6852)
                     (#xEDC6 . #x67BB)
                     (#xEDC5 . #x6766)
                     (#xEDC4 . #xF929)
                     (#xEDC3 . #x670E)
                     (#xEDC2 . #x66FA)
                     (#xEDC1 . #x66BF)
                     (#xEDC0 . #x66B2)
                     (#xEDBF . #x66A0)
                     (#xEDBE . #x6699)
                     (#xEDBD . #x6673)
                     (#xEDBC . #xFA12)
                     (#xEDBB . #x6659)
                     (#xEDBA . #x6657)
                     (#xEDB9 . #x6665)
                     (#xEDB8 . #x6624)
                     (#xEDB7 . #x661E)
                     (#xEDB6 . #x662E)
                     (#xEDB5 . #x6609)
                     (#xEDB4 . #x663B)
                     (#xEDB3 . #x6615)
                     (#xEDB2 . #x6600)
                     (#xEDB1 . #x654E)
                     (#xEDB0 . #x64CE)
                     (#xEDAF . #x649D)
                     (#xEDAE . #x6460)
                     (#xEDAD . #x63F5)
                     (#xEDAC . #x62A6)
                     (#xEDAB . #x6213)
                     (#xEDAA . #x6198)
                     (#xEDA9 . #x6130)
                     (#xEDA8 . #x6137)
                     (#xEDA7 . #x6111)
                     (#xEDA6 . #x60F2)
                     (#xEDA5 . #x6120)
                     (#xEDA4 . #x60D5)
                     (#xEDA3 . #x60DE)
                     (#xEDA2 . #x608A)
                     (#xEDA1 . #x6085)
                     (#xEDA0 . #x605D)
                     (#xED9F . #x5FDE)
                     (#xED9E . #x5FB7)
                     (#xED9D . #x5F67)
                     (#xED9C . #x5F34)
                     (#xED9B . #x5F21)
                     (#xED9A . #x5DD0)
                     (#xED99 . #x5DB9)
                     (#xED98 . #x5DB8)
                     (#xED97 . #x5D6D)
                     (#xED96 . #x5D42)
                     (#xED95 . #xFA11)
                     (#xED94 . #x5D53)
                     (#xED93 . #x5D27)
                     (#xED92 . #x5CF5)
                     (#xED91 . #x5CBA)
                     (#xED90 . #x5CA6)
                     (#xED8F . #x5C1E)
                     (#xED8E . #x5BEC)
                     (#xED8D . #x5BD8)
                     (#xED8C . #x752F)
                     (#xED8B . #x5BC0)
                     (#xED8A . #x5B56)
                     (#xED89 . #x59BA)
                     (#xED88 . #x59A4)
                     (#xED87 . #x5963)
                     (#xED86 . #x595D)
                     (#xED85 . #x595B)
                     (#xED84 . #x5953)
                     (#xED83 . #x590B)
                     (#xED82 . #x58B2)
                     (#xED81 . #x589E)
                     (#xED80 . #xFA10)
                     (#xED7E . #xFA0F)
                     (#xED7D . #x57C7)
                     (#xED7C . #x57C8)
                     (#xED7B . #x57AC)
                     (#xED7A . #x5765)
                     (#xED79 . #x5759)
                     (#xED78 . #x5586)
                     (#xED77 . #x54FF)
                     (#xED76 . #x54A9)
                     (#xED75 . #x548A)
                     (#xED74 . #x549C)
                     (#xED73 . #xFA0E)
                     (#xED72 . #x53DD)
                     (#xED71 . #x53B2)
                     (#xED70 . #x5393)
                     (#xED6F . #x5372)
                     (#xED6E . #x5324)
                     (#xED6D . #x5307)
                     (#xED6C . #x5300)
                     (#xED6B . #x52DB)
                     (#xED6A . #x52C0)
                     (#xED69 . #x52A6)
                     (#xED68 . #x529C)
                     (#xED67 . #x5215)
                     (#xED66 . #x51EC)
                     (#xED65 . #x51BE)
                     (#xED64 . #x519D)
                     (#xED63 . #x5164)
                     (#xED62 . #x514A)
                     (#xED61 . #x50D8)
                     (#xED60 . #x50F4)
                     (#xED5F . #x5094)
                     (#xED5E . #x5042)
                     (#xED5D . #x5070)
                     (#xED5C . #x5046)
                     (#xED5B . #x501E)
                     (#xED5A . #x4FFF)
                     (#xED59 . #x5022)
                     (#xED58 . #x5040)
                     (#xED57 . #x4FCD)
                     (#xED56 . #x4F94)
                     (#xED55 . #x4F9A)
                     (#xED54 . #x4F8A)
                     (#xED53 . #x4F92)
                     (#xED52 . #x4F56)
                     (#xED51 . #x4F39)
                     (#xED50 . #x4F03)
                     (#xED4F . #x4F00)
                     (#xED4E . #x4EFC)
                     (#xED4D . #x4EE1)
                     (#xED4C . #x4E28)
                     (#xED4B . #x5F45)
                     (#xED4A . #x66FB)
                     (#xED49 . #x92F9)
                     (#xED48 . #x68C8)
                     (#xED47 . #x6631)
                     (#xED46 . #x70BB)
                     (#xED45 . #x4FC9)
                     (#xED44 . #x84DC)
                     (#xED43 . #x9288)
                     (#xED42 . #x9348)
                     (#xED41 . #x891C)
                     (#xED40 . #x7E8A)
                     (#xEA9E . #x9FA0)
                     (#xEA40 . #x9D5D)
                     (#xE99E . #x9AF7)
                     (#xE940 . #x9871)
                     (#xE89E . #x965E)
                     (#xE840 . #x9319)
                     (#xE79E . #x8FF8)
                     (#xE740 . #x8E47)
                     (#xE69E . #x8B6B)
                     (#xE640 . #x8966)
                     (#xE59E . #x8759)
                     (#xE540 . #x8541)
                     (#xE49E . #x82D9)
                     (#xE440 . #x968B)
                     (#xE39E . #x7F3A)
                     (#xE340 . #x7D02)
                     (#xE29E . #x7B50)
                     (#xE240 . #x78E7)
                     (#xE19E . #x7670)
                     (#xE140 . #x74E0)
                     (#xE09E . #x71FC)
                     (#xE040 . #x6F3E)
                     (#x9F9E . #x6CBE)
                     (#x9F40 . #x6A97)
                     (#x9E9E . #x68CD)
                     (#x9E40 . #x66C4)
                     (#x9D9E . #x64BC)
                     (#x9D40 . #x621E)
                     (#x9C9E . #x609A)
                     (#x9C40 . #x5ED6)
                     (#x9B9E . #x5C53)
                     (#x9B40 . #x5978)
                     (#x9A9E . #x5709)
                     (#x9A40 . #x54AB)
                     (#x999E . #x8FA8)
                     (#x9940 . #x50C9)
                     (#x9840 . #x84EE)
                     (#x979E . #x7483)
                     (#x9740 . #x8AED)
                     (#x969E . #x6E80)
                     (#x9640 . #x6CD5)
                     (#x959E . #x670D)
                     (#x9540 . #x9F3B)
                     (#x949E . #x9EA6)
                     (#x9440 . #x5982)
                     (#x939E . #x5230)
                     (#x9340 . #x90B8)
                     (#x929E . #x5BF5)
                     (#x9240 . #x53E9)
                     (#x919E . #x618E)
                     (#x9140 . #x7E4A)
                     (#x909E . #x88FE)
                     (#x9040 . #x62ED)
                     (#x8F9E . #x511F)
                     (#x8F40 . #x5B97)
                     (#x8E9E . #x6642)
                     (#x8E40 . #x5BDF)
                     (#x8D9E . #x8FBC)
                     (#x8D40 . #x540E)
                     (#x8C9E . #x6372)
                     (#x8C40 . #x6398)
                     (#x8B9E . #x4EAC)
                     (#x8B40 . #x6A5F)
                     (#x8A9E . #x8431)
                     (#x8A40 . #x9B41)
                     (#x899E . #x5FDC)
                     (#x8940 . #x9662)
                     (#x879C . #x222A)
                     (#x879B . #x2229)
                     (#x879A . #x2235)
                     (#x8799 . #x22BF)
                     (#x8798 . #x221F)
                     (#x8797 . #x2220)
                     (#x8796 . #x22A5)
                     (#x8795 . #x221A)
                     (#x8794 . #x2211)
                     (#x8793 . #x222E)
                     (#x8792 . #x222B)
                     (#x8791 . #x2261)
                     (#x8790 . #x2252)
                     (#x878F . #x337C)
                     (#x878E . #x337D)
                     (#x878D . #x337E)
                     (#x878C . #x3239)
                     (#x878B . #x3232)
                     (#x878A . #x3231)
                     (#x8789 . #x32A8)
                     (#x8788 . #x32A7)
                     (#x8787 . #x32A6)
                     (#x8786 . #x32A5)
                     (#x8785 . #x32A4)
                     (#x8784 . #x2121)
                     (#x8783 . #x33CD)
                     (#x8782 . #x2116)
                     (#x8781 . #x301F)
                     (#x8780 . #x301D)
                     (#x877E . #x337B)
                     (#x8775 . #x33A1)
                     (#x8774 . #x33C4)
                     (#x8773 . #x338F)
                     (#x8772 . #x338E)
                     (#x8771 . #x339E)
                     (#x8770 . #x339D)
                     (#x876F . #x339C)
                     (#x876E . #x333B)
                     (#x876D . #x334A)
                     (#x876C . #x332B)
                     (#x876B . #x3323)
                     (#x876A . #x3326)
                     (#x8769 . #x330D)
                     (#x8768 . #x3357)
                     (#x8767 . #x3351)
                     (#x8766 . #x3336)
                     (#x8765 . #x3303)
                     (#x8764 . #x3327)
                     (#x8763 . #x3318)
                     (#x8762 . #x334D)
                     (#x8761 . #x3322)
                     (#x8760 . #x3314)
                     (#x875F . #x3349)
                     (#x875D . #x2169)
                     (#x875C . #x2168)
                     (#x875B . #x2167)
                     (#x875A . #x2166)
                     (#x8759 . #x2165)
                     (#x8758 . #x2164)
                     (#x8757 . #x2163)
                     (#x8756 . #x2162)
                     (#x8755 . #x2161)
                     (#x8754 . #x2160)
                     (#x8753 . #x2473)
                     (#x8752 . #x2472)
                     (#x8751 . #x2471)
                     (#x8750 . #x2470)
                     (#x874F . #x246F)
                     (#x874E . #x246E)
                     (#x874D . #x246D)
                     (#x874C . #x246C)
                     (#x874B . #x246B)
                     (#x874A . #x246A)
                     (#x8749 . #x2469)
                     (#x8748 . #x2468)
                     (#x8747 . #x2467)
                     (#x8746 . #x2466)
                     (#x8745 . #x2465)
                     (#x8744 . #x2464)
                     (#x8743 . #x2463)
                     (#x8742 . #x2462)
                     (#x8741 . #x2461)
                     (#x8740 . #x2460)
                     (#x8440 . #x410)
                     (#x8340 . #x30A1)
                     (#x819E . #x25C7)
                     (#x8140 . #x3000)
                     ))
       (eucjp-only '((#xFEFE . #xE3AB)
                     (#xFEFD . #xE3AA)
                     (#xFEFC . #xE3A9)
                     (#xFEFB . #xE3A8)
                     (#xFEFA . #xE3A7)
                     (#xFEF9 . #xE3A6)
                     (#xFEF8 . #xE3A5)
                     (#xFEF7 . #xE3A4)
                     (#xFEF6 . #xE3A3)
                     (#xFEF5 . #xE3A2)
                     (#xFEF4 . #xE3A1)
                     (#xFEF3 . #xE3A0)
                     (#xFEF2 . #xE39F)
                     (#xFEF1 . #xE39E)
                     (#xFEF0 . #xE39D)
                     (#xFEEF . #xE39C)
                     (#xFEEE . #xE39B)
                     (#xFEED . #xE39A)
                     (#xFEEC . #xE399)
                     (#xFEEB . #xE398)
                     (#xFEEA . #xE397)
                     (#xFEE9 . #xE396)
                     (#xFEE8 . #xE395)
                     (#xFEE7 . #xE394)
                     (#xFEE6 . #xE393)
                     (#xFEE5 . #xE392)
                     (#xFEE4 . #xE391)
                     (#xFEE3 . #xE390)
                     (#xFEE2 . #xE38F)
                     (#xFEE1 . #xE38E)
                     (#xFEE0 . #xE38D)
                     (#xFEDF . #xE38C)
                     (#xFEDE . #xE38B)
                     (#xFEDD . #xE38A)
                     (#xFEDC . #xE389)
                     (#xFEDB . #xE388)
                     (#xFEDA . #xE387)
                     (#xFED9 . #xE386)
                     (#xFED8 . #xE385)
                     (#xFED7 . #xE384)
                     (#xFED6 . #xE383)
                     (#xFED5 . #xE382)
                     (#xFED4 . #xE381)
                     (#xFED3 . #xE380)
                     (#xFED2 . #xE37F)
                     (#xFED1 . #xE37E)
                     (#xFED0 . #xE37D)
                     (#xFECF . #xE37C)
                     (#xFECE . #xE37B)
                     (#xFECD . #xE37A)
                     (#xFECC . #xE379)
                     (#xFECB . #xE378)
                     (#xFECA . #xE377)
                     (#xFEC9 . #xE376)
                     (#xFEC8 . #xE375)
                     (#xFEC7 . #xE374)
                     (#xFEC6 . #xE373)
                     (#xFEC5 . #xE372)
                     (#xFEC4 . #xE371)
                     (#xFEC3 . #xE370)
                     (#xFEC2 . #xE36F)
                     (#xFEC1 . #xE36E)
                     (#xFEC0 . #xE36D)
                     (#xFEBF . #xE36C)
                     (#xFEBE . #xE36B)
                     (#xFEBD . #xE36A)
                     (#xFEBC . #xE369)
                     (#xFEBB . #xE368)
                     (#xFEBA . #xE367)
                     (#xFEB9 . #xE366)
                     (#xFEB8 . #xE365)
                     (#xFEB7 . #xE364)
                     (#xFEB6 . #xE363)
                     (#xFEB5 . #xE362)
                     (#xFEB4 . #xE361)
                     (#xFEB3 . #xE360)
                     (#xFEB2 . #xE35F)
                     (#xFEB1 . #xE35E)
                     (#xFEB0 . #xE35D)
                     (#xFEAF . #xE35C)
                     (#xFEAE . #xE35B)
                     (#xFEAD . #xE35A)
                     (#xFEAC . #xE359)
                     (#xFEAB . #xE358)
                     (#xFEAA . #xE357)
                     (#xFEA9 . #xE356)
                     (#xFEA8 . #xE355)
                     (#xFEA7 . #xE354)
                     (#xFEA6 . #xE353)
                     (#xFEA5 . #xE352)
                     (#xFEA4 . #xE351)
                     (#xFEA3 . #xE350)
                     (#xFEA2 . #xE34F)
                     (#xFEA1 . #xE34E)
                     (#xFDFE . #xE34D)
                     (#xFDFD . #xE34C)
                     (#xFDFC . #xE34B)
                     (#xFDFB . #xE34A)
                     (#xFDFA . #xE349)
                     (#xFDF9 . #xE348)
                     (#xFDF8 . #xE347)
                     (#xFDF7 . #xE346)
                     (#xFDF6 . #xE345)
                     (#xFDF5 . #xE344)
                     (#xFDF4 . #xE343)
                     (#xFDF3 . #xE342)
                     (#xFDF2 . #xE341)
                     (#xFDF1 . #xE340)
                     (#xFDF0 . #xE33F)
                     (#xFDEF . #xE33E)
                     (#xFDEE . #xE33D)
                     (#xFDED . #xE33C)
                     (#xFDEC . #xE33B)
                     (#xFDEB . #xE33A)
                     (#xFDEA . #xE339)
                     (#xFDE9 . #xE338)
                     (#xFDE8 . #xE337)
                     (#xFDE7 . #xE336)
                     (#xFDE6 . #xE335)
                     (#xFDE5 . #xE334)
                     (#xFDE4 . #xE333)
                     (#xFDE3 . #xE332)
                     (#xFDE2 . #xE331)
                     (#xFDE1 . #xE330)
                     (#xFDE0 . #xE32F)
                     (#xFDDF . #xE32E)
                     (#xFDDE . #xE32D)
                     (#xFDDD . #xE32C)
                     (#xFDDC . #xE32B)
                     (#xFDDB . #xE32A)
                     (#xFDDA . #xE329)
                     (#xFDD9 . #xE328)
                     (#xFDD8 . #xE327)
                     (#xFDD7 . #xE326)
                     (#xFDD6 . #xE325)
                     (#xFDD5 . #xE324)
                     (#xFDD4 . #xE323)
                     (#xFDD3 . #xE322)
                     (#xFDD2 . #xE321)
                     (#xFDD1 . #xE320)
                     (#xFDD0 . #xE31F)
                     (#xFDCF . #xE31E)
                     (#xFDCE . #xE31D)
                     (#xFDCD . #xE31C)
                     (#xFDCC . #xE31B)
                     (#xFDCB . #xE31A)
                     (#xFDCA . #xE319)
                     (#xFDC9 . #xE318)
                     (#xFDC8 . #xE317)
                     (#xFDC7 . #xE316)
                     (#xFDC6 . #xE315)
                     (#xFDC5 . #xE314)
                     (#xFDC4 . #xE313)
                     (#xFDC3 . #xE312)
                     (#xFDC2 . #xE311)
                     (#xFDC1 . #xE310)
                     (#xFDC0 . #xE30F)
                     (#xFDBF . #xE30E)
                     (#xFDBE . #xE30D)
                     (#xFDBD . #xE30C)
                     (#xFDBC . #xE30B)
                     (#xFDBB . #xE30A)
                     (#xFDBA . #xE309)
                     (#xFDB9 . #xE308)
                     (#xFDB8 . #xE307)
                     (#xFDB7 . #xE306)
                     (#xFDB6 . #xE305)
                     (#xFDB5 . #xE304)
                     (#xFDB4 . #xE303)
                     (#xFDB3 . #xE302)
                     (#xFDB2 . #xE301)
                     (#xFDB1 . #xE300)
                     (#xFDB0 . #xE2FF)
                     (#xFDAF . #xE2FE)
                     (#xFDAE . #xE2FD)
                     (#xFDAD . #xE2FC)
                     (#xFDAC . #xE2FB)
                     (#xFDAB . #xE2FA)
                     (#xFDAA . #xE2F9)
                     (#xFDA9 . #xE2F8)
                     (#xFDA8 . #xE2F7)
                     (#xFDA7 . #xE2F6)
                     (#xFDA6 . #xE2F5)
                     (#xFDA5 . #xE2F4)
                     (#xFDA4 . #xE2F3)
                     (#xFDA3 . #xE2F2)
                     (#xFDA2 . #xE2F1)
                     (#xFDA1 . #xE2F0)
                     (#xFCFE . #xE2EF)
                     (#xFCFD . #xE2EE)
                     (#xFCFC . #xE2ED)
                     (#xFCFB . #xE2EC)
                     (#xFCFA . #xE2EB)
                     (#xFCF9 . #xE2EA)
                     (#xFCF8 . #xE2E9)
                     (#xFCF7 . #xE2E8)
                     (#xFCF6 . #xE2E7)
                     (#xFCF5 . #xE2E6)
                     (#xFCF4 . #xE2E5)
                     (#xFCF3 . #xE2E4)
                     (#xFCF2 . #xE2E3)
                     (#xFCF1 . #xE2E2)
                     (#xFCF0 . #xE2E1)
                     (#xFCEF . #xE2E0)
                     (#xFCEE . #xE2DF)
                     (#xFCED . #xE2DE)
                     (#xFCEC . #xE2DD)
                     (#xFCEB . #xE2DC)
                     (#xFCEA . #xE2DB)
                     (#xFCE9 . #xE2DA)
                     (#xFCE8 . #xE2D9)
                     (#xFCE7 . #xE2D8)
                     (#xFCE6 . #xE2D7)
                     (#xFCE5 . #xE2D6)
                     (#xFCE4 . #xE2D5)
                     (#xFCE3 . #xE2D4)
                     (#xFCE2 . #xE2D3)
                     (#xFCE1 . #xE2D2)
                     (#xFCE0 . #xE2D1)
                     (#xFCDF . #xE2D0)
                     (#xFCDE . #xE2CF)
                     (#xFCDD . #xE2CE)
                     (#xFCDC . #xE2CD)
                     (#xFCDB . #xE2CC)
                     (#xFCDA . #xE2CB)
                     (#xFCD9 . #xE2CA)
                     (#xFCD8 . #xE2C9)
                     (#xFCD7 . #xE2C8)
                     (#xFCD6 . #xE2C7)
                     (#xFCD5 . #xE2C6)
                     (#xFCD4 . #xE2C5)
                     (#xFCD3 . #xE2C4)
                     (#xFCD2 . #xE2C3)
                     (#xFCD1 . #xE2C2)
                     (#xFCD0 . #xE2C1)
                     (#xFCCF . #xE2C0)
                     (#xFCCE . #xE2BF)
                     (#xFCCD . #xE2BE)
                     (#xFCCC . #xE2BD)
                     (#xFCCB . #xE2BC)
                     (#xFCCA . #xE2BB)
                     (#xFCC9 . #xE2BA)
                     (#xFCC8 . #xE2B9)
                     (#xFCC7 . #xE2B8)
                     (#xFCC6 . #xE2B7)
                     (#xFCC5 . #xE2B6)
                     (#xFCC4 . #xE2B5)
                     (#xFCC3 . #xE2B4)
                     (#xFCC2 . #xE2B3)
                     (#xFCC1 . #xE2B2)
                     (#xFCC0 . #xE2B1)
                     (#xFCBF . #xE2B0)
                     (#xFCBE . #xE2AF)
                     (#xFCBD . #xE2AE)
                     (#xFCBC . #xE2AD)
                     (#xFCBB . #xE2AC)
                     (#xFCBA . #xE2AB)
                     (#xFCB9 . #xE2AA)
                     (#xFCB8 . #xE2A9)
                     (#xFCB7 . #xE2A8)
                     (#xFCB6 . #xE2A7)
                     (#xFCB5 . #xE2A6)
                     (#xFCB4 . #xE2A5)
                     (#xFCB3 . #xE2A4)
                     (#xFCB2 . #xE2A3)
                     (#xFCB1 . #xE2A2)
                     (#xFCB0 . #xE2A1)
                     (#xFCAF . #xE2A0)
                     (#xFCAE . #xE29F)
                     (#xFCAD . #xE29E)
                     (#xFCAC . #xE29D)
                     (#xFCAB . #xE29C)
                     (#xFCAA . #xE29B)
                     (#xFCA9 . #xE29A)
                     (#xFCA8 . #xE299)
                     (#xFCA7 . #xE298)
                     (#xFCA6 . #xE297)
                     (#xFCA5 . #xE296)
                     (#xFCA4 . #xE295)
                     (#xFCA3 . #xE294)
                     (#xFCA2 . #xE293)
                     (#xFCA1 . #xE292)
                     (#xFBFE . #xE291)
                     (#xFBFD . #xE290)
                     (#xFBFC . #xE28F)
                     (#xFBFB . #xE28E)
                     (#xFBFA . #xE28D)
                     (#xFBF9 . #xE28C)
                     (#xFBF8 . #xE28B)
                     (#xFBF7 . #xE28A)
                     (#xFBF6 . #xE289)
                     (#xFBF5 . #xE288)
                     (#xFBF4 . #xE287)
                     (#xFBF3 . #xE286)
                     (#xFBF2 . #xE285)
                     (#xFBF1 . #xE284)
                     (#xFBF0 . #xE283)
                     (#xFBEF . #xE282)
                     (#xFBEE . #xE281)
                     (#xFBED . #xE280)
                     (#xFBEC . #xE27F)
                     (#xFBEB . #xE27E)
                     (#xFBEA . #xE27D)
                     (#xFBE9 . #xE27C)
                     (#xFBE8 . #xE27B)
                     (#xFBE7 . #xE27A)
                     (#xFBE6 . #xE279)
                     (#xFBE5 . #xE278)
                     (#xFBE4 . #xE277)
                     (#xFBE3 . #xE276)
                     (#xFBE2 . #xE275)
                     (#xFBE1 . #xE274)
                     (#xFBE0 . #xE273)
                     (#xFBDF . #xE272)
                     (#xFBDE . #xE271)
                     (#xFBDD . #xE270)
                     (#xFBDC . #xE26F)
                     (#xFBDB . #xE26E)
                     (#xFBDA . #xE26D)
                     (#xFBD9 . #xE26C)
                     (#xFBD8 . #xE26B)
                     (#xFBD7 . #xE26A)
                     (#xFBD6 . #xE269)
                     (#xFBD5 . #xE268)
                     (#xFBD4 . #xE267)
                     (#xFBD3 . #xE266)
                     (#xFBD2 . #xE265)
                     (#xFBD1 . #xE264)
                     (#xFBD0 . #xE263)
                     (#xFBCF . #xE262)
                     (#xFBCE . #xE261)
                     (#xFBCD . #xE260)
                     (#xFBCC . #xE25F)
                     (#xFBCB . #xE25E)
                     (#xFBCA . #xE25D)
                     (#xFBC9 . #xE25C)
                     (#xFBC8 . #xE25B)
                     (#xFBC7 . #xE25A)
                     (#xFBC6 . #xE259)
                     (#xFBC5 . #xE258)
                     (#xFBC4 . #xE257)
                     (#xFBC3 . #xE256)
                     (#xFBC2 . #xE255)
                     (#xFBC1 . #xE254)
                     (#xFBC0 . #xE253)
                     (#xFBBF . #xE252)
                     (#xFBBE . #xE251)
                     (#xFBBD . #xE250)
                     (#xFBBC . #xE24F)
                     (#xFBBB . #xE24E)
                     (#xFBBA . #xE24D)
                     (#xFBB9 . #xE24C)
                     (#xFBB8 . #xE24B)
                     (#xFBB7 . #xE24A)
                     (#xFBB6 . #xE249)
                     (#xFBB5 . #xE248)
                     (#xFBB4 . #xE247)
                     (#xFBB3 . #xE246)
                     (#xFBB2 . #xE245)
                     (#xFBB1 . #xE244)
                     (#xFBB0 . #xE243)
                     (#xFBAF . #xE242)
                     (#xFBAE . #xE241)
                     (#xFBAD . #xE240)
                     (#xFBAC . #xE23F)
                     (#xFBAB . #xE23E)
                     (#xFBAA . #xE23D)
                     (#xFBA9 . #xE23C)
                     (#xFBA8 . #xE23B)
                     (#xFBA7 . #xE23A)
                     (#xFBA6 . #xE239)
                     (#xFBA5 . #xE238)
                     (#xFBA4 . #xE237)
                     (#xFBA3 . #xE236)
                     (#xFBA2 . #xE235)
                     (#xFBA1 . #xE234)
                     (#xFAFE . #xE233)
                     (#xFAFD . #xE232)
                     (#xFAFC . #xE231)
                     (#xFAFB . #xE230)
                     (#xFAFA . #xE22F)
                     (#xFAF9 . #xE22E)
                     (#xFAF8 . #xE22D)
                     (#xFAF7 . #xE22C)
                     (#xFAF6 . #xE22B)
                     (#xFAF5 . #xE22A)
                     (#xFAF4 . #xE229)
                     (#xFAF3 . #xE228)
                     (#xFAF2 . #xE227)
                     (#xFAF1 . #xE226)
                     (#xFAF0 . #xE225)
                     (#xFAEF . #xE224)
                     (#xFAEE . #xE223)
                     (#xFAED . #xE222)
                     (#xFAEC . #xE221)
                     (#xFAEB . #xE220)
                     (#xFAEA . #xE21F)
                     (#xFAE9 . #xE21E)
                     (#xFAE8 . #xE21D)
                     (#xFAE7 . #xE21C)
                     (#xFAE6 . #xE21B)
                     (#xFAE5 . #xE21A)
                     (#xFAE4 . #xE219)
                     (#xFAE3 . #xE218)
                     (#xFAE2 . #xE217)
                     (#xFAE1 . #xE216)
                     (#xFAE0 . #xE215)
                     (#xFADF . #xE214)
                     (#xFADE . #xE213)
                     (#xFADD . #xE212)
                     (#xFADC . #xE211)
                     (#xFADB . #xE210)
                     (#xFADA . #xE20F)
                     (#xFAD9 . #xE20E)
                     (#xFAD8 . #xE20D)
                     (#xFAD7 . #xE20C)
                     (#xFAD6 . #xE20B)
                     (#xFAD5 . #xE20A)
                     (#xFAD4 . #xE209)
                     (#xFAD3 . #xE208)
                     (#xFAD2 . #xE207)
                     (#xFAD1 . #xE206)
                     (#xFAD0 . #xE205)
                     (#xFACF . #xE204)
                     (#xFACE . #xE203)
                     (#xFACD . #xE202)
                     (#xFACC . #xE201)
                     (#xFACB . #xE200)
                     (#xFACA . #xE1FF)
                     (#xFAC9 . #xE1FE)
                     (#xFAC8 . #xE1FD)
                     (#xFAC7 . #xE1FC)
                     (#xFAC6 . #xE1FB)
                     (#xFAC5 . #xE1FA)
                     (#xFAC4 . #xE1F9)
                     (#xFAC3 . #xE1F8)
                     (#xFAC2 . #xE1F7)
                     (#xFAC1 . #xE1F6)
                     (#xFAC0 . #xE1F5)
                     (#xFABF . #xE1F4)
                     (#xFABE . #xE1F3)
                     (#xFABD . #xE1F2)
                     (#xFABC . #xE1F1)
                     (#xFABB . #xE1F0)
                     (#xFABA . #xE1EF)
                     (#xFAB9 . #xE1EE)
                     (#xFAB8 . #xE1ED)
                     (#xFAB7 . #xE1EC)
                     (#xFAB6 . #xE1EB)
                     (#xFAB5 . #xE1EA)
                     (#xFAB4 . #xE1E9)
                     (#xFAB3 . #xE1E8)
                     (#xFAB2 . #xE1E7)
                     (#xFAB1 . #xE1E6)
                     (#xFAB0 . #xE1E5)
                     (#xFAAF . #xE1E4)
                     (#xFAAE . #xE1E3)
                     (#xFAAD . #xE1E2)
                     (#xFAAC . #xE1E1)
                     (#xFAAB . #xE1E0)
                     (#xFAAA . #xE1DF)
                     (#xFAA9 . #xE1DE)
                     (#xFAA8 . #xE1DD)
                     (#xFAA7 . #xE1DC)
                     (#xFAA6 . #xE1DB)
                     (#xFAA5 . #xE1DA)
                     (#xFAA4 . #xE1D9)
                     (#xFAA3 . #xE1D8)
                     (#xFAA2 . #xE1D7)
                     (#xFAA1 . #xE1D6)
                     (#xF9FE . #xE1D5)
                     (#xF9FD . #xE1D4)
                     (#xF9FC . #xE1D3)
                     (#xF9FB . #xE1D2)
                     (#xF9FA . #xE1D1)
                     (#xF9F9 . #xE1D0)
                     (#xF9F8 . #xE1CF)
                     (#xF9F7 . #xE1CE)
                     (#xF9F6 . #xE1CD)
                     (#xF9F5 . #xE1CC)
                     (#xF9F4 . #xE1CB)
                     (#xF9F3 . #xE1CA)
                     (#xF9F2 . #xE1C9)
                     (#xF9F1 . #xE1C8)
                     (#xF9F0 . #xE1C7)
                     (#xF9EF . #xE1C6)
                     (#xF9EE . #xE1C5)
                     (#xF9ED . #xE1C4)
                     (#xF9EC . #xE1C3)
                     (#xF9EB . #xE1C2)
                     (#xF9EA . #xE1C1)
                     (#xF9E9 . #xE1C0)
                     (#xF9E8 . #xE1BF)
                     (#xF9E7 . #xE1BE)
                     (#xF9E6 . #xE1BD)
                     (#xF9E5 . #xE1BC)
                     (#xF9E4 . #xE1BB)
                     (#xF9E3 . #xE1BA)
                     (#xF9E2 . #xE1B9)
                     (#xF9E1 . #xE1B8)
                     (#xF9E0 . #xE1B7)
                     (#xF9DF . #xE1B6)
                     (#xF9DE . #xE1B5)
                     (#xF9DD . #xE1B4)
                     (#xF9DC . #xE1B3)
                     (#xF9DB . #xE1B2)
                     (#xF9DA . #xE1B1)
                     (#xF9D9 . #xE1B0)
                     (#xF9D8 . #xE1AF)
                     (#xF9D7 . #xE1AE)
                     (#xF9D6 . #xE1AD)
                     (#xF9D5 . #xE1AC)
                     (#xF9D4 . #xE1AB)
                     (#xF9D3 . #xE1AA)
                     (#xF9D2 . #xE1A9)
                     (#xF9D1 . #xE1A8)
                     (#xF9D0 . #xE1A7)
                     (#xF9CF . #xE1A6)
                     (#xF9CE . #xE1A5)
                     (#xF9CD . #xE1A4)
                     (#xF9CC . #xE1A3)
                     (#xF9CB . #xE1A2)
                     (#xF9CA . #xE1A1)
                     (#xF9C9 . #xE1A0)
                     (#xF9C8 . #xE19F)
                     (#xF9C7 . #xE19E)
                     (#xF9C6 . #xE19D)
                     (#xF9C5 . #xE19C)
                     (#xF9C4 . #xE19B)
                     (#xF9C3 . #xE19A)
                     (#xF9C2 . #xE199)
                     (#xF9C1 . #xE198)
                     (#xF9C0 . #xE197)
                     (#xF9BF . #xE196)
                     (#xF9BE . #xE195)
                     (#xF9BD . #xE194)
                     (#xF9BC . #xE193)
                     (#xF9BB . #xE192)
                     (#xF9BA . #xE191)
                     (#xF9B9 . #xE190)
                     (#xF9B8 . #xE18F)
                     (#xF9B7 . #xE18E)
                     (#xF9B6 . #xE18D)
                     (#xF9B5 . #xE18C)
                     (#xF9B4 . #xE18B)
                     (#xF9B3 . #xE18A)
                     (#xF9B2 . #xE189)
                     (#xF9B1 . #xE188)
                     (#xF9B0 . #xE187)
                     (#xF9AF . #xE186)
                     (#xF9AE . #xE185)
                     (#xF9AD . #xE184)
                     (#xF9AC . #xE183)
                     (#xF9AB . #xE182)
                     (#xF9AA . #xE181)
                     (#xF9A9 . #xE180)
                     (#xF9A8 . #xE17F)
                     (#xF9A7 . #xE17E)
                     (#xF9A6 . #xE17D)
                     (#xF9A5 . #xE17C)
                     (#xF9A4 . #xE17B)
                     (#xF9A3 . #xE17A)
                     (#xF9A2 . #xE179)
                     (#xF9A1 . #xE178)
                     (#xF8FE . #xE177)
                     (#xF8FD . #xE176)
                     (#xF8FC . #xE175)
                     (#xF8FB . #xE174)
                     (#xF8FA . #xE173)
                     (#xF8F9 . #xE172)
                     (#xF8F8 . #xE171)
                     (#xF8F7 . #xE170)
                     (#xF8F6 . #xE16F)
                     (#xF8F5 . #xE16E)
                     (#xF8F4 . #xE16D)
                     (#xF8F3 . #xE16C)
                     (#xF8F2 . #xE16B)
                     (#xF8F1 . #xE16A)
                     (#xF8F0 . #xE169)
                     (#xF8EF . #xE168)
                     (#xF8EE . #xE167)
                     (#xF8ED . #xE166)
                     (#xF8EC . #xE165)
                     (#xF8EB . #xE164)
                     (#xF8EA . #xE163)
                     (#xF8E9 . #xE162)
                     (#xF8E8 . #xE161)
                     (#xF8E7 . #xE160)
                     (#xF8E6 . #xE15F)
                     (#xF8E5 . #xE15E)
                     (#xF8E4 . #xE15D)
                     (#xF8E3 . #xE15C)
                     (#xF8E2 . #xE15B)
                     (#xF8E1 . #xE15A)
                     (#xF8E0 . #xE159)
                     (#xF8DF . #xE158)
                     (#xF8DE . #xE157)
                     (#xF8DD . #xE156)
                     (#xF8DC . #xE155)
                     (#xF8DB . #xE154)
                     (#xF8DA . #xE153)
                     (#xF8D9 . #xE152)
                     (#xF8D8 . #xE151)
                     (#xF8D7 . #xE150)
                     (#xF8D6 . #xE14F)
                     (#xF8D5 . #xE14E)
                     (#xF8D4 . #xE14D)
                     (#xF8D3 . #xE14C)
                     (#xF8D2 . #xE14B)
                     (#xF8D1 . #xE14A)
                     (#xF8D0 . #xE149)
                     (#xF8CF . #xE148)
                     (#xF8CE . #xE147)
                     (#xF8CD . #xE146)
                     (#xF8CC . #xE145)
                     (#xF8CB . #xE144)
                     (#xF8CA . #xE143)
                     (#xF8C9 . #xE142)
                     (#xF8C8 . #xE141)
                     (#xF8C7 . #xE140)
                     (#xF8C6 . #xE13F)
                     (#xF8C5 . #xE13E)
                     (#xF8C4 . #xE13D)
                     (#xF8C3 . #xE13C)
                     (#xF8C2 . #xE13B)
                     (#xF8C1 . #xE13A)
                     (#xF8C0 . #xE139)
                     (#xF8BF . #xE138)
                     (#xF8BE . #xE137)
                     (#xF8BD . #xE136)
                     (#xF8BC . #xE135)
                     (#xF8BB . #xE134)
                     (#xF8BA . #xE133)
                     (#xF8B9 . #xE132)
                     (#xF8B8 . #xE131)
                     (#xF8B7 . #xE130)
                     (#xF8B6 . #xE12F)
                     (#xF8B5 . #xE12E)
                     (#xF8B4 . #xE12D)
                     (#xF8B3 . #xE12C)
                     (#xF8B2 . #xE12B)
                     (#xF8B1 . #xE12A)
                     (#xF8B0 . #xE129)
                     (#xF8AF . #xE128)
                     (#xF8AE . #xE127)
                     (#xF8AD . #xE126)
                     (#xF8AC . #xE125)
                     (#xF8AB . #xE124)
                     (#xF8AA . #xE123)
                     (#xF8A9 . #xE122)
                     (#xF8A8 . #xE121)
                     (#xF8A7 . #xE120)
                     (#xF8A6 . #xE11F)
                     (#xF8A5 . #xE11E)
                     (#xF8A4 . #xE11D)
                     (#xF8A3 . #xE11C)
                     (#xF8A2 . #xE11B)
                     (#xF8A1 . #xE11A)
                     (#xF7FE . #xE119)
                     (#xF7FD . #xE118)
                     (#xF7FC . #xE117)
                     (#xF7FB . #xE116)
                     (#xF7FA . #xE115)
                     (#xF7F9 . #xE114)
                     (#xF7F8 . #xE113)
                     (#xF7F7 . #xE112)
                     (#xF7F6 . #xE111)
                     (#xF7F5 . #xE110)
                     (#xF7F4 . #xE10F)
                     (#xF7F3 . #xE10E)
                     (#xF7F2 . #xE10D)
                     (#xF7F1 . #xE10C)
                     (#xF7F0 . #xE10B)
                     (#xF7EF . #xE10A)
                     (#xF7EE . #xE109)
                     (#xF7ED . #xE108)
                     (#xF7EC . #xE107)
                     (#xF7EB . #xE106)
                     (#xF7EA . #xE105)
                     (#xF7E9 . #xE104)
                     (#xF7E8 . #xE103)
                     (#xF7E7 . #xE102)
                     (#xF7E6 . #xE101)
                     (#xF7E5 . #xE100)
                     (#xF7E4 . #xE0FF)
                     (#xF7E3 . #xE0FE)
                     (#xF7E2 . #xE0FD)
                     (#xF7E1 . #xE0FC)
                     (#xF7E0 . #xE0FB)
                     (#xF7DF . #xE0FA)
                     (#xF7DE . #xE0F9)
                     (#xF7DD . #xE0F8)
                     (#xF7DC . #xE0F7)
                     (#xF7DB . #xE0F6)
                     (#xF7DA . #xE0F5)
                     (#xF7D9 . #xE0F4)
                     (#xF7D8 . #xE0F3)
                     (#xF7D7 . #xE0F2)
                     (#xF7D6 . #xE0F1)
                     (#xF7D5 . #xE0F0)
                     (#xF7D4 . #xE0EF)
                     (#xF7D3 . #xE0EE)
                     (#xF7D2 . #xE0ED)
                     (#xF7D1 . #xE0EC)
                     (#xF7D0 . #xE0EB)
                     (#xF7CF . #xE0EA)
                     (#xF7CE . #xE0E9)
                     (#xF7CD . #xE0E8)
                     (#xF7CC . #xE0E7)
                     (#xF7CB . #xE0E6)
                     (#xF7CA . #xE0E5)
                     (#xF7C9 . #xE0E4)
                     (#xF7C8 . #xE0E3)
                     (#xF7C7 . #xE0E2)
                     (#xF7C6 . #xE0E1)
                     (#xF7C5 . #xE0E0)
                     (#xF7C4 . #xE0DF)
                     (#xF7C3 . #xE0DE)
                     (#xF7C2 . #xE0DD)
                     (#xF7C1 . #xE0DC)
                     (#xF7C0 . #xE0DB)
                     (#xF7BF . #xE0DA)
                     (#xF7BE . #xE0D9)
                     (#xF7BD . #xE0D8)
                     (#xF7BC . #xE0D7)
                     (#xF7BB . #xE0D6)
                     (#xF7BA . #xE0D5)
                     (#xF7B9 . #xE0D4)
                     (#xF7B8 . #xE0D3)
                     (#xF7B7 . #xE0D2)
                     (#xF7B6 . #xE0D1)
                     (#xF7B5 . #xE0D0)
                     (#xF7B4 . #xE0CF)
                     (#xF7B3 . #xE0CE)
                     (#xF7B2 . #xE0CD)
                     (#xF7B1 . #xE0CC)
                     (#xF7B0 . #xE0CB)
                     (#xF7AF . #xE0CA)
                     (#xF7AE . #xE0C9)
                     (#xF7AD . #xE0C8)
                     (#xF7AC . #xE0C7)
                     (#xF7AB . #xE0C6)
                     (#xF7AA . #xE0C5)
                     (#xF7A9 . #xE0C4)
                     (#xF7A8 . #xE0C3)
                     (#xF7A7 . #xE0C2)
                     (#xF7A6 . #xE0C1)
                     (#xF7A5 . #xE0C0)
                     (#xF7A4 . #xE0BF)
                     (#xF7A3 . #xE0BE)
                     (#xF7A2 . #xE0BD)
                     (#xF7A1 . #xE0BC)
                     (#xF6FE . #xE0BB)
                     (#xF6FD . #xE0BA)
                     (#xF6FC . #xE0B9)
                     (#xF6FB . #xE0B8)
                     (#xF6FA . #xE0B7)
                     (#xF6F9 . #xE0B6)
                     (#xF6F8 . #xE0B5)
                     (#xF6F7 . #xE0B4)
                     (#xF6F6 . #xE0B3)
                     (#xF6F5 . #xE0B2)
                     (#xF6F4 . #xE0B1)
                     (#xF6F3 . #xE0B0)
                     (#xF6F2 . #xE0AF)
                     (#xF6F1 . #xE0AE)
                     (#xF6F0 . #xE0AD)
                     (#xF6EF . #xE0AC)
                     (#xF6EE . #xE0AB)
                     (#xF6ED . #xE0AA)
                     (#xF6EC . #xE0A9)
                     (#xF6EB . #xE0A8)
                     (#xF6EA . #xE0A7)
                     (#xF6E9 . #xE0A6)
                     (#xF6E8 . #xE0A5)
                     (#xF6E7 . #xE0A4)
                     (#xF6E6 . #xE0A3)
                     (#xF6E5 . #xE0A2)
                     (#xF6E4 . #xE0A1)
                     (#xF6E3 . #xE0A0)
                     (#xF6E2 . #xE09F)
                     (#xF6E1 . #xE09E)
                     (#xF6E0 . #xE09D)
                     (#xF6DF . #xE09C)
                     (#xF6DE . #xE09B)
                     (#xF6DD . #xE09A)
                     (#xF6DC . #xE099)
                     (#xF6DB . #xE098)
                     (#xF6DA . #xE097)
                     (#xF6D9 . #xE096)
                     (#xF6D8 . #xE095)
                     (#xF6D7 . #xE094)
                     (#xF6D6 . #xE093)
                     (#xF6D5 . #xE092)
                     (#xF6D4 . #xE091)
                     (#xF6D3 . #xE090)
                     (#xF6D2 . #xE08F)
                     (#xF6D1 . #xE08E)
                     (#xF6D0 . #xE08D)
                     (#xF6CF . #xE08C)
                     (#xF6CE . #xE08B)
                     (#xF6CD . #xE08A)
                     (#xF6CC . #xE089)
                     (#xF6CB . #xE088)
                     (#xF6CA . #xE087)
                     (#xF6C9 . #xE086)
                     (#xF6C8 . #xE085)
                     (#xF6C7 . #xE084)
                     (#xF6C6 . #xE083)
                     (#xF6C5 . #xE082)
                     (#xF6C4 . #xE081)
                     (#xF6C3 . #xE080)
                     (#xF6C2 . #xE07F)
                     (#xF6C1 . #xE07E)
                     (#xF6C0 . #xE07D)
                     (#xF6BF . #xE07C)
                     (#xF6BE . #xE07B)
                     (#xF6BD . #xE07A)
                     (#xF6BC . #xE079)
                     (#xF6BB . #xE078)
                     (#xF6BA . #xE077)
                     (#xF6B9 . #xE076)
                     (#xF6B8 . #xE075)
                     (#xF6B7 . #xE074)
                     (#xF6B6 . #xE073)
                     (#xF6B5 . #xE072)
                     (#xF6B4 . #xE071)
                     (#xF6B3 . #xE070)
                     (#xF6B2 . #xE06F)
                     (#xF6B1 . #xE06E)
                     (#xF6B0 . #xE06D)
                     (#xF6AF . #xE06C)
                     (#xF6AE . #xE06B)
                     (#xF6AD . #xE06A)
                     (#xF6AC . #xE069)
                     (#xF6AB . #xE068)
                     (#xF6AA . #xE067)
                     (#xF6A9 . #xE066)
                     (#xF6A8 . #xE065)
                     (#xF6A7 . #xE064)
                     (#xF6A6 . #xE063)
                     (#xF6A5 . #xE062)
                     (#xF6A4 . #xE061)
                     (#xF6A3 . #xE060)
                     (#xF6A2 . #xE05F)
                     (#xF6A1 . #xE05E)
                     (#xF5FE . #xE05D)
                     (#xF5FD . #xE05C)
                     (#xF5FC . #xE05B)
                     (#xF5FB . #xE05A)
                     (#xF5FA . #xE059)
                     (#xF5F9 . #xE058)
                     (#xF5F8 . #xE057)
                     (#xF5F7 . #xE056)
                     (#xF5F6 . #xE055)
                     (#xF5F5 . #xE054)
                     (#xF5F4 . #xE053)
                     (#xF5F3 . #xE052)
                     (#xF5F2 . #xE051)
                     (#xF5F1 . #xE050)
                     (#xF5F0 . #xE04F)
                     (#xF5EF . #xE04E)
                     (#xF5EE . #xE04D)
                     (#xF5ED . #xE04C)
                     (#xF5EC . #xE04B)
                     (#xF5EB . #xE04A)
                     (#xF5EA . #xE049)
                     (#xF5E9 . #xE048)
                     (#xF5E8 . #xE047)
                     (#xF5E7 . #xE046)
                     (#xF5E6 . #xE045)
                     (#xF5E5 . #xE044)
                     (#xF5E4 . #xE043)
                     (#xF5E3 . #xE042)
                     (#xF5E2 . #xE041)
                     (#xF5E1 . #xE040)
                     (#xF5E0 . #xE03F)
                     (#xF5DF . #xE03E)
                     (#xF5DE . #xE03D)
                     (#xF5DD . #xE03C)
                     (#xF5DC . #xE03B)
                     (#xF5DB . #xE03A)
                     (#xF5DA . #xE039)
                     (#xF5D9 . #xE038)
                     (#xF5D8 . #xE037)
                     (#xF5D7 . #xE036)
                     (#xF5D6 . #xE035)
                     (#xF5D5 . #xE034)
                     (#xF5D4 . #xE033)
                     (#xF5D3 . #xE032)
                     (#xF5D2 . #xE031)
                     (#xF5D1 . #xE030)
                     (#xF5D0 . #xE02F)
                     (#xF5CF . #xE02E)
                     (#xF5CE . #xE02D)
                     (#xF5CD . #xE02C)
                     (#xF5CC . #xE02B)
                     (#xF5CB . #xE02A)
                     (#xF5CA . #xE029)
                     (#xF5C9 . #xE028)
                     (#xF5C8 . #xE027)
                     (#xF5C7 . #xE026)
                     (#xF5C6 . #xE025)
                     (#xF5C5 . #xE024)
                     (#xF5C4 . #xE023)
                     (#xF5C3 . #xE022)
                     (#xF5C2 . #xE021)
                     (#xF5C1 . #xE020)
                     (#xF5C0 . #xE01F)
                     (#xF5BF . #xE01E)
                     (#xF5BE . #xE01D)
                     (#xF5BD . #xE01C)
                     (#xF5BC . #xE01B)
                     (#xF5BB . #xE01A)
                     (#xF5BA . #xE019)
                     (#xF5B9 . #xE018)
                     (#xF5B8 . #xE017)
                     (#xF5B7 . #xE016)
                     (#xF5B6 . #xE015)
                     (#xF5B5 . #xE014)
                     (#xF5B4 . #xE013)
                     (#xF5B3 . #xE012)
                     (#xF5B2 . #xE011)
                     (#xF5B1 . #xE010)
                     (#xF5B0 . #xE00F)
                     (#xF5AF . #xE00E)
                     (#xF5AE . #xE00D)
                     (#xF5AD . #xE00C)
                     (#xF5AC . #xE00B)
                     (#xF5AB . #xE00A)
                     (#xF5AA . #xE009)
                     (#xF5A9 . #xE008)
                     (#xF5A8 . #xE007)
                     (#xF5A7 . #xE006)
                     (#xF5A6 . #xE005)
                     (#xF5A5 . #xE004)
                     (#xF5A4 . #xE003)
                     (#xF5A3 . #xE002)
                     (#xF5A2 . #xE001)
                     (#xF5A1 . #xE000)
                     ))
       (eucjp '((#x8FA2AF . #x2D8)
                (#x8FA2B0 . #x2C7)
                (#x8FA2B1 . #xB8)
                (#x8FA2B2 . #x2D9)
                (#x8FA2B3 . #x2DD)
                (#x8FA2B4 . #xAF)
                (#x8FA2B5 . #x2DB)
                (#x8FA2B6 . #x2DA)
                (#x8FA2B7 . #xFF5E)
                (#x8FA2B8 . #x384)
                (#x8FA2B9 . #x385)
                (#x8FA2C2 . #xA1)
                (#x8FA2C3 . #xA6)
                (#x8FA2C4 . #xBF)
                (#x8FA2EB . #xBA)
                (#x8FA2EC . #xAA)
                (#x8FA2ED . #xA9)
                (#x8FA2EE . #xAE)
                (#x8FA2EF . #x2122)
                (#x8FA2F0 . #xA4)
                (#x8FA2F1 . #x2116)
                (#x8FA6E1 . #x386)
                (#x8FA6E2 . #x388)
                (#x8FA6E3 . #x389)
                (#x8FA6E4 . #x38A)
                (#x8FA6E5 . #x3AA)
                (#x8FA6E7 . #x38C)
                (#x8FA6E9 . #x38E)
                (#x8FA6EA . #x3AB)
                (#x8FA6EC . #x38F)
                (#x8FA6F1 . #x3AC)
                (#x8FA6F2 . #x3AD)
                (#x8FA6F3 . #x3AE)
                (#x8FA6F4 . #x3AF)
                (#x8FA6F5 . #x3CA)
                (#x8FA6F6 . #x390)
                (#x8FA6F7 . #x3CC)
                (#x8FA6F8 . #x3C2)
                (#x8FA6F9 . #x3CD)
                (#x8FA6FA . #x3CB)
                (#x8FA6FB . #x3B0)
                (#x8FA6FC . #x3CE)
                (#x8FA7C2 . #x402)
                (#x8FA7C3 . #x403)
                (#x8FA7C4 . #x404)
                (#x8FA7C5 . #x405)
                (#x8FA7C6 . #x406)
                (#x8FA7C7 . #x407)
                (#x8FA7C8 . #x408)
                (#x8FA7C9 . #x409)
                (#x8FA7CA . #x40A)
                (#x8FA7CB . #x40B)
                (#x8FA7CC . #x40C)
                (#x8FA7CD . #x40E)
                (#x8FA7CE . #x40F)
                (#x8FA7F2 . #x452)
                (#x8FA7F3 . #x453)
                (#x8FA7F4 . #x454)
                (#x8FA7F5 . #x455)
                (#x8FA7F6 . #x456)
                (#x8FA7F7 . #x457)
                (#x8FA7F8 . #x458)
                (#x8FA7F9 . #x459)
                (#x8FA7FA . #x45A)
                (#x8FA7FB . #x45B)
                (#x8FA7FC . #x45C)
                (#x8FA7FD . #x45E)
                (#x8FA7FE . #x45F)
                (#x8FA9A1 . #xC6)
                (#x8FA9A2 . #x110)
                (#x8FA9A4 . #x126)
                (#x8FA9A6 . #x132)
                (#x8FA9A8 . #x141)
                (#x8FA9A9 . #x13F)
                (#x8FA9AB . #x14A)
                (#x8FA9AC . #xD8)
                (#x8FA9AD . #x152)
                (#x8FA9AF . #x166)
                (#x8FA9B0 . #xDE)
                (#x8FA9C1 . #xE6)
                (#x8FA9C2 . #x111)
                (#x8FA9C3 . #xF0)
                (#x8FA9C4 . #x127)
                (#x8FA9C5 . #x131)
                (#x8FA9C6 . #x133)
                (#x8FA9C7 . #x138)
                (#x8FA9C8 . #x142)
                (#x8FA9C9 . #x140)
                (#x8FA9CA . #x149)
                (#x8FA9CB . #x14B)
                (#x8FA9CC . #xF8)
                (#x8FA9CD . #x153)
                (#x8FA9CE . #xDF)
                (#x8FA9CF . #x167)
                (#x8FA9D0 . #xFE)
                (#x8FAAA1 . #xC1)
                (#x8FAAA2 . #xC0)
                (#x8FAAA3 . #xC4)
                (#x8FAAA4 . #xC2)
                (#x8FAAA5 . #x102)
                (#x8FAAA6 . #x1CD)
                (#x8FAAA7 . #x100)
                (#x8FAAA8 . #x104)
                (#x8FAAA9 . #xC5)
                (#x8FAAAA . #xC3)
                (#x8FAAAB . #x106)
                (#x8FAAAC . #x108)
                (#x8FAAAD . #x10C)
                (#x8FAAAE . #xC7)
                (#x8FAAAF . #x10A)
                (#x8FAAB0 . #x10E)
                (#x8FAAB1 . #xC9)
                (#x8FAAB2 . #xC8)
                (#x8FAAB3 . #xCB)
                (#x8FAAB4 . #xCA)
                (#x8FAAB5 . #x11A)
                (#x8FAAB6 . #x116)
                (#x8FAAB7 . #x112)
                (#x8FAAB8 . #x118)
                (#x8FAABA . #x11C)
                (#x8FAABB . #x11E)
                (#x8FAABC . #x122)
                (#x8FAABD . #x120)
                (#x8FAABE . #x124)
                (#x8FAABF . #xCD)
                (#x8FAAC0 . #xCC)
                (#x8FAAC1 . #xCF)
                (#x8FAAC2 . #xCE)
                (#x8FAAC3 . #x1CF)
                (#x8FAAC4 . #x130)
                (#x8FAAC5 . #x12A)
                (#x8FAAC6 . #x12E)
                (#x8FAAC7 . #x128)
                (#x8FAAC8 . #x134)
                (#x8FAAC9 . #x136)
                (#x8FAACA . #x139)
                (#x8FAACB . #x13D)
                (#x8FAACC . #x13B)
                (#x8FAACD . #x143)
                (#x8FAACE . #x147)
                (#x8FAACF . #x145)
                (#x8FAAD0 . #xD1)
                (#x8FAAD1 . #xD3)
                (#x8FAAD2 . #xD2)
                (#x8FAAD3 . #xD6)
                (#x8FAAD4 . #xD4)
                (#x8FAAD5 . #x1D1)
                (#x8FAAD6 . #x150)
                (#x8FAAD7 . #x14C)
                (#x8FAAD8 . #xD5)
                (#x8FAAD9 . #x154)
                (#x8FAADA . #x158)
                (#x8FAADB . #x156)
                (#x8FAADC . #x15A)
                (#x8FAADD . #x15C)
                (#x8FAADE . #x160)
                (#x8FAADF . #x15E)
                (#x8FAAE0 . #x164)
                (#x8FAAE1 . #x162)
                (#x8FAAE2 . #xDA)
                (#x8FAAE3 . #xD9)
                (#x8FAAE4 . #xDC)
                (#x8FAAE5 . #xDB)
                (#x8FAAE6 . #x16C)
                (#x8FAAE7 . #x1D3)
                (#x8FAAE8 . #x170)
                (#x8FAAE9 . #x16A)
                (#x8FAAEA . #x172)
                (#x8FAAEB . #x16E)
                (#x8FAAEC . #x168)
                (#x8FAAED . #x1D7)
                (#x8FAAEE . #x1DB)
                (#x8FAAEF . #x1D9)
                (#x8FAAF0 . #x1D5)
                (#x8FAAF1 . #x174)
                (#x8FAAF2 . #xDD)
                (#x8FAAF3 . #x178)
                (#x8FAAF4 . #x176)
                (#x8FAAF5 . #x179)
                (#x8FAAF6 . #x17D)
                (#x8FAAF7 . #x17B)
                (#x8FABA1 . #xE1)
                (#x8FABA2 . #xE0)
                (#x8FABA3 . #xE4)
                (#x8FABA4 . #xE2)
                (#x8FABA5 . #x103)
                (#x8FABA6 . #x1CE)
                (#x8FABA7 . #x101)
                (#x8FABA8 . #x105)
                (#x8FABA9 . #xE5)
                (#x8FABAA . #xE3)
                (#x8FABAB . #x107)
                (#x8FABAC . #x109)
                (#x8FABAD . #x10D)
                (#x8FABAE . #xE7)
                (#x8FABAF . #x10B)
                (#x8FABB0 . #x10F)
                (#x8FABB1 . #xE9)
                (#x8FABB2 . #xE8)
                (#x8FABB3 . #xEB)
                (#x8FABB4 . #xEA)
                (#x8FABB5 . #x11B)
                (#x8FABB6 . #x117)
                (#x8FABB7 . #x113)
                (#x8FABB8 . #x119)
                (#x8FABB9 . #x1F5)
                (#x8FABBA . #x11D)
                (#x8FABBB . #x11F)
                (#x8FABBD . #x121)
                (#x8FABBE . #x125)
                (#x8FABBF . #xED)
                (#x8FABC0 . #xEC)
                (#x8FABC1 . #xEF)
                (#x8FABC2 . #xEE)
                (#x8FABC3 . #x1D0)
                (#x8FABC5 . #x12B)
                (#x8FABC6 . #x12F)
                (#x8FABC7 . #x129)
                (#x8FABC8 . #x135)
                (#x8FABC9 . #x137)
                (#x8FABCA . #x13A)
                (#x8FABCB . #x13E)
                (#x8FABCC . #x13C)
                (#x8FABCD . #x144)
                (#x8FABCE . #x148)
                (#x8FABCF . #x146)
                (#x8FABD0 . #xF1)
                (#x8FABD1 . #xF3)
                (#x8FABD2 . #xF2)
                (#x8FABD3 . #xF6)
                (#x8FABD4 . #xF4)
                (#x8FABD5 . #x1D2)
                (#x8FABD6 . #x151)
                (#x8FABD7 . #x14D)
                (#x8FABD8 . #xF5)
                (#x8FABD9 . #x155)
                (#x8FABDA . #x159)
                (#x8FABDB . #x157)
                (#x8FABDC . #x15B)
                (#x8FABDD . #x15D)
                (#x8FABDE . #x161)
                (#x8FABDF . #x15F)
                (#x8FABE0 . #x165)
                (#x8FABE1 . #x163)
                (#x8FABE2 . #xFA)
                (#x8FABE3 . #xF9)
                (#x8FABE4 . #xFC)
                (#x8FABE5 . #xFB)
                (#x8FABE6 . #x16D)
                (#x8FABE7 . #x1D4)
                (#x8FABE8 . #x171)
                (#x8FABE9 . #x16B)
                (#x8FABEA . #x173)
                (#x8FABEB . #x16F)
                (#x8FABEC . #x169)
                (#x8FABED . #x1D8)
                (#x8FABEE . #x1DC)
                (#x8FABEF . #x1DA)
                (#x8FABF0 . #x1D6)
                (#x8FABF1 . #x175)
                (#x8FABF2 . #xFD)
                (#x8FABF3 . #xFF)
                (#x8FABF4 . #x177)
                (#x8FABF5 . #x17A)
                (#x8FABF6 . #x17E)
                (#x8FABF7 . #x17C)
                (#x8FB0A1 . #x4E02)
                (#x8FB0A2 . #x4E04)
                (#x8FB0A3 . #x4E05)
                (#x8FB0A4 . #x4E0C)
                (#x8FB0A5 . #x4E12)
                (#x8FB0A6 . #x4E1F)
                (#x8FB0A7 . #x4E23)
                (#x8FB0A8 . #x4E24)
                (#x8FB0A9 . #x4E28)
                (#x8FB0AA . #x4E2B)
                (#x8FB0AB . #x4E2E)
                (#x8FB0AC . #x4E2F)
                (#x8FB0AD . #x4E30)
                (#x8FB0AE . #x4E35)
                (#x8FB0AF . #x4E40)
                (#x8FB0B0 . #x4E41)
                (#x8FB0B1 . #x4E44)
                (#x8FB0B2 . #x4E47)
                (#x8FB0B3 . #x4E51)
                (#x8FB0B4 . #x4E5A)
                (#x8FB0B5 . #x4E5C)
                (#x8FB0B6 . #x4E63)
                (#x8FB0B7 . #x4E68)
                (#x8FB0B8 . #x4E69)
                (#x8FB0B9 . #x4E74)
                (#x8FB0BA . #x4E75)
                (#x8FB0BB . #x4E79)
                (#x8FB0BC . #x4E7F)
                (#x8FB0BD . #x4E8D)
                (#x8FB0BE . #x4E96)
                (#x8FB0BF . #x4E97)
                (#x8FB0C0 . #x4E9D)
                (#x8FB0C1 . #x4EAF)
                (#x8FB0C2 . #x4EB9)
                (#x8FB0C3 . #x4EC3)
                (#x8FB0C4 . #x4ED0)
                (#x8FB0C5 . #x4EDA)
                (#x8FB0C6 . #x4EDB)
                (#x8FB0C7 . #x4EE0)
                (#x8FB0C8 . #x4EE1)
                (#x8FB0C9 . #x4EE2)
                (#x8FB0CA . #x4EE8)
                (#x8FB0CB . #x4EEF)
                (#x8FB0CC . #x4EF1)
                (#x8FB0CD . #x4EF3)
                (#x8FB0CE . #x4EF5)
                (#x8FB0CF . #x4EFD)
                (#x8FB0D0 . #x4EFE)
                (#x8FB0D1 . #x4EFF)
                (#x8FB0D2 . #x4F00)
                (#x8FB0D3 . #x4F02)
                (#x8FB0D4 . #x4F03)
                (#x8FB0D5 . #x4F08)
                (#x8FB0D6 . #x4F0B)
                (#x8FB0D7 . #x4F0C)
                (#x8FB0D8 . #x4F12)
                (#x8FB0D9 . #x4F15)
                (#x8FB0DA . #x4F16)
                (#x8FB0DB . #x4F17)
                (#x8FB0DC . #x4F19)
                (#x8FB0DD . #x4F2E)
                (#x8FB0DE . #x4F31)
                (#x8FB0DF . #x4F60)
                (#x8FB0E0 . #x4F33)
                (#x8FB0E1 . #x4F35)
                (#x8FB0E2 . #x4F37)
                (#x8FB0E3 . #x4F39)
                (#x8FB0E4 . #x4F3B)
                (#x8FB0E5 . #x4F3E)
                (#x8FB0E6 . #x4F40)
                (#x8FB0E7 . #x4F42)
                (#x8FB0E8 . #x4F48)
                (#x8FB0E9 . #x4F49)
                (#x8FB0EA . #x4F4B)
                (#x8FB0EB . #x4F4C)
                (#x8FB0EC . #x4F52)
                (#x8FB0ED . #x4F54)
                (#x8FB0EE . #x4F56)
                (#x8FB0EF . #x4F58)
                (#x8FB0F0 . #x4F5F)
                (#x8FB0F1 . #x4F63)
                (#x8FB0F2 . #x4F6A)
                (#x8FB0F3 . #x4F6C)
                (#x8FB0F4 . #x4F6E)
                (#x8FB0F5 . #x4F71)
                (#x8FB0F6 . #x4F77)
                (#x8FB0F7 . #x4F78)
                (#x8FB0F8 . #x4F79)
                (#x8FB0F9 . #x4F7A)
                (#x8FB0FA . #x4F7D)
                (#x8FB0FB . #x4F7E)
                (#x8FB0FC . #x4F81)
                (#x8FB0FD . #x4F82)
                (#x8FB0FE . #x4F84)
                (#x8FB1A1 . #x4F85)
                (#x8FB1A2 . #x4F89)
                (#x8FB1A3 . #x4F8A)
                (#x8FB1A4 . #x4F8C)
                (#x8FB1A5 . #x4F8E)
                (#x8FB1A6 . #x4F90)
                (#x8FB1A7 . #x4F92)
                (#x8FB1A8 . #x4F93)
                (#x8FB1A9 . #x4F94)
                (#x8FB1AA . #x4F97)
                (#x8FB1AB . #x4F99)
                (#x8FB1AC . #x4F9A)
                (#x8FB1AD . #x4F9E)
                (#x8FB1AE . #x4F9F)
                (#x8FB1AF . #x4FB2)
                (#x8FB1B0 . #x4FB7)
                (#x8FB1B1 . #x4FB9)
                (#x8FB1B2 . #x4FBB)
                (#x8FB1B3 . #x4FBC)
                (#x8FB1B4 . #x4FBD)
                (#x8FB1B5 . #x4FBE)
                (#x8FB1B6 . #x4FC0)
                (#x8FB1B7 . #x4FC1)
                (#x8FB1B8 . #x4FC5)
                (#x8FB1B9 . #x4FC6)
                (#x8FB1BA . #x4FC8)
                (#x8FB1BB . #x4FC9)
                (#x8FB1BC . #x4FCB)
                (#x8FB1BD . #x4FCC)
                (#x8FB1BE . #x4FCD)
                (#x8FB1BF . #x4FCF)
                (#x8FB1C0 . #x4FD2)
                (#x8FB1C1 . #x4FDC)
                (#x8FB1C2 . #x4FE0)
                (#x8FB1C3 . #x4FE2)
                (#x8FB1C4 . #x4FF0)
                (#x8FB1C5 . #x4FF2)
                (#x8FB1C6 . #x4FFC)
                (#x8FB1C7 . #x4FFD)
                (#x8FB1C8 . #x4FFF)
                (#x8FB1C9 . #x5000)
                (#x8FB1CA . #x5001)
                (#x8FB1CB . #x5004)
                (#x8FB1CC . #x5007)
                (#x8FB1CD . #x500A)
                (#x8FB1CE . #x500C)
                (#x8FB1CF . #x500E)
                (#x8FB1D0 . #x5010)
                (#x8FB1D1 . #x5013)
                (#x8FB1D2 . #x5017)
                (#x8FB1D3 . #x5018)
                (#x8FB1D4 . #x501B)
                (#x8FB1D5 . #x501C)
                (#x8FB1D6 . #x501D)
                (#x8FB1D7 . #x501E)
                (#x8FB1D8 . #x5022)
                (#x8FB1D9 . #x5027)
                (#x8FB1DA . #x502E)
                (#x8FB1DB . #x5030)
                (#x8FB1DC . #x5032)
                (#x8FB1DD . #x5033)
                (#x8FB1DE . #x5035)
                (#x8FB1DF . #x5040)
                (#x8FB1E0 . #x5041)
                (#x8FB1E1 . #x5042)
                (#x8FB1E2 . #x5045)
                (#x8FB1E3 . #x5046)
                (#x8FB1E4 . #x504A)
                (#x8FB1E5 . #x504C)
                (#x8FB1E6 . #x504E)
                (#x8FB1E7 . #x5051)
                (#x8FB1E8 . #x5052)
                (#x8FB1E9 . #x5053)
                (#x8FB1EA . #x5057)
                (#x8FB1EB . #x5059)
                (#x8FB1EC . #x505F)
                (#x8FB1ED . #x5060)
                (#x8FB1EE . #x5062)
                (#x8FB1EF . #x5063)
                (#x8FB1F0 . #x5066)
                (#x8FB1F1 . #x5067)
                (#x8FB1F2 . #x506A)
                (#x8FB1F3 . #x506D)
                (#x8FB1F4 . #x5070)
                (#x8FB1F5 . #x5071)
                (#x8FB1F6 . #x503B)
                (#x8FB1F7 . #x5081)
                (#x8FB1F8 . #x5083)
                (#x8FB1F9 . #x5084)
                (#x8FB1FA . #x5086)
                (#x8FB1FB . #x508A)
                (#x8FB1FC . #x508E)
                (#x8FB1FD . #x508F)
                (#x8FB1FE . #x5090)
                (#x8FB2A1 . #x5092)
                (#x8FB2A2 . #x5093)
                (#x8FB2A3 . #x5094)
                (#x8FB2A4 . #x5096)
                (#x8FB2A5 . #x509B)
                (#x8FB2A6 . #x509C)
                (#x8FB2A7 . #x509E)
                (#x8FB2A8 . #x509F)
                (#x8FB2A9 . #x50A0)
                (#x8FB2AA . #x50A1)
                (#x8FB2AB . #x50A2)
                (#x8FB2AC . #x50AA)
                (#x8FB2AD . #x50AF)
                (#x8FB2AE . #x50B0)
                (#x8FB2AF . #x50B9)
                (#x8FB2B0 . #x50BA)
                (#x8FB2B1 . #x50BD)
                (#x8FB2B2 . #x50C0)
                (#x8FB2B3 . #x50C3)
                (#x8FB2B4 . #x50C4)
                (#x8FB2B5 . #x50C7)
                (#x8FB2B6 . #x50CC)
                (#x8FB2B7 . #x50CE)
                (#x8FB2B8 . #x50D0)
                (#x8FB2B9 . #x50D3)
                (#x8FB2BA . #x50D4)
                (#x8FB2BB . #x50D8)
                (#x8FB2BC . #x50DC)
                (#x8FB2BD . #x50DD)
                (#x8FB2BE . #x50DF)
                (#x8FB2BF . #x50E2)
                (#x8FB2C0 . #x50E4)
                (#x8FB2C1 . #x50E6)
                (#x8FB2C2 . #x50E8)
                (#x8FB2C3 . #x50E9)
                (#x8FB2C4 . #x50EF)
                (#x8FB2C5 . #x50F1)
                (#x8FB2C6 . #x50F6)
                (#x8FB2C7 . #x50FA)
                (#x8FB2C8 . #x50FE)
                (#x8FB2C9 . #x5103)
                (#x8FB2CA . #x5106)
                (#x8FB2CB . #x5107)
                (#x8FB2CC . #x5108)
                (#x8FB2CD . #x510B)
                (#x8FB2CE . #x510C)
                (#x8FB2CF . #x510D)
                (#x8FB2D0 . #x510E)
                (#x8FB2D1 . #x50F2)
                (#x8FB2D2 . #x5110)
                (#x8FB2D3 . #x5117)
                (#x8FB2D4 . #x5119)
                (#x8FB2D5 . #x511B)
                (#x8FB2D6 . #x511C)
                (#x8FB2D7 . #x511D)
                (#x8FB2D8 . #x511E)
                (#x8FB2D9 . #x5123)
                (#x8FB2DA . #x5127)
                (#x8FB2DB . #x5128)
                (#x8FB2DC . #x512C)
                (#x8FB2DD . #x512D)
                (#x8FB2DE . #x512F)
                (#x8FB2DF . #x5131)
                (#x8FB2E0 . #x5133)
                (#x8FB2E1 . #x5134)
                (#x8FB2E2 . #x5135)
                (#x8FB2E3 . #x5138)
                (#x8FB2E4 . #x5139)
                (#x8FB2E5 . #x5142)
                (#x8FB2E6 . #x514A)
                (#x8FB2E7 . #x514F)
                (#x8FB2E8 . #x5153)
                (#x8FB2E9 . #x5155)
                (#x8FB2EA . #x5157)
                (#x8FB2EB . #x5158)
                (#x8FB2EC . #x515F)
                (#x8FB2ED . #x5164)
                (#x8FB2EE . #x5166)
                (#x8FB2EF . #x517E)
                (#x8FB2F0 . #x5183)
                (#x8FB2F1 . #x5184)
                (#x8FB2F2 . #x518B)
                (#x8FB2F3 . #x518E)
                (#x8FB2F4 . #x5198)
                (#x8FB2F5 . #x519D)
                (#x8FB2F6 . #x51A1)
                (#x8FB2F7 . #x51A3)
                (#x8FB2F8 . #x51AD)
                (#x8FB2F9 . #x51B8)
                (#x8FB2FA . #x51BA)
                (#x8FB2FB . #x51BC)
                (#x8FB2FC . #x51BE)
                (#x8FB2FD . #x51BF)
                (#x8FB2FE . #x51C2)
                (#x8FB3A1 . #x51C8)
                (#x8FB3A2 . #x51CF)
                (#x8FB3A3 . #x51D1)
                (#x8FB3A4 . #x51D2)
                (#x8FB3A5 . #x51D3)
                (#x8FB3A6 . #x51D5)
                (#x8FB3A7 . #x51D8)
                (#x8FB3A8 . #x51DE)
                (#x8FB3A9 . #x51E2)
                (#x8FB3AA . #x51E5)
                (#x8FB3AB . #x51EE)
                (#x8FB3AC . #x51F2)
                (#x8FB3AD . #x51F3)
                (#x8FB3AE . #x51F4)
                (#x8FB3AF . #x51F7)
                (#x8FB3B0 . #x5201)
                (#x8FB3B1 . #x5202)
                (#x8FB3B2 . #x5205)
                (#x8FB3B3 . #x5212)
                (#x8FB3B4 . #x5213)
                (#x8FB3B5 . #x5215)
                (#x8FB3B6 . #x5216)
                (#x8FB3B7 . #x5218)
                (#x8FB3B8 . #x5222)
                (#x8FB3B9 . #x5228)
                (#x8FB3BA . #x5231)
                (#x8FB3BB . #x5232)
                (#x8FB3BC . #x5235)
                (#x8FB3BD . #x523C)
                (#x8FB3BE . #x5245)
                (#x8FB3BF . #x5249)
                (#x8FB3C0 . #x5255)
                (#x8FB3C1 . #x5257)
                (#x8FB3C2 . #x5258)
                (#x8FB3C3 . #x525A)
                (#x8FB3C4 . #x525C)
                (#x8FB3C5 . #x525F)
                (#x8FB3C6 . #x5260)
                (#x8FB3C7 . #x5261)
                (#x8FB3C8 . #x5266)
                (#x8FB3C9 . #x526E)
                (#x8FB3CA . #x5277)
                (#x8FB3CB . #x5278)
                (#x8FB3CC . #x5279)
                (#x8FB3CD . #x5280)
                (#x8FB3CE . #x5282)
                (#x8FB3CF . #x5285)
                (#x8FB3D0 . #x528A)
                (#x8FB3D1 . #x528C)
                (#x8FB3D2 . #x5293)
                (#x8FB3D3 . #x5295)
                (#x8FB3D4 . #x5296)
                (#x8FB3D5 . #x5297)
                (#x8FB3D6 . #x5298)
                (#x8FB3D7 . #x529A)
                (#x8FB3D8 . #x529C)
                (#x8FB3D9 . #x52A4)
                (#x8FB3DA . #x52A5)
                (#x8FB3DB . #x52A6)
                (#x8FB3DC . #x52A7)
                (#x8FB3DD . #x52AF)
                (#x8FB3DE . #x52B0)
                (#x8FB3DF . #x52B6)
                (#x8FB3E0 . #x52B7)
                (#x8FB3E1 . #x52B8)
                (#x8FB3E2 . #x52BA)
                (#x8FB3E3 . #x52BB)
                (#x8FB3E4 . #x52BD)
                (#x8FB3E5 . #x52C0)
                (#x8FB3E6 . #x52C4)
                (#x8FB3E7 . #x52C6)
                (#x8FB3E8 . #x52C8)
                (#x8FB3E9 . #x52CC)
                (#x8FB3EA . #x52CF)
                (#x8FB3EB . #x52D1)
                (#x8FB3EC . #x52D4)
                (#x8FB3ED . #x52D6)
                (#x8FB3EE . #x52DB)
                (#x8FB3EF . #x52DC)
                (#x8FB3F0 . #x52E1)
                (#x8FB3F1 . #x52E5)
                (#x8FB3F2 . #x52E8)
                (#x8FB3F3 . #x52E9)
                (#x8FB3F4 . #x52EA)
                (#x8FB3F5 . #x52EC)
                (#x8FB3F6 . #x52F0)
                (#x8FB3F7 . #x52F1)
                (#x8FB3F8 . #x52F4)
                (#x8FB3F9 . #x52F6)
                (#x8FB3FA . #x52F7)
                (#x8FB3FB . #x5300)
                (#x8FB3FC . #x5303)
                (#x8FB3FD . #x530A)
                (#x8FB3FE . #x530B)
                (#x8FB4A1 . #x530C)
                (#x8FB4A2 . #x5311)
                (#x8FB4A3 . #x5313)
                (#x8FB4A4 . #x5318)
                (#x8FB4A5 . #x531B)
                (#x8FB4A6 . #x531C)
                (#x8FB4A7 . #x531E)
                (#x8FB4A8 . #x531F)
                (#x8FB4A9 . #x5325)
                (#x8FB4AA . #x5327)
                (#x8FB4AB . #x5328)
                (#x8FB4AC . #x5329)
                (#x8FB4AD . #x532B)
                (#x8FB4AE . #x532C)
                (#x8FB4AF . #x532D)
                (#x8FB4B0 . #x5330)
                (#x8FB4B1 . #x5332)
                (#x8FB4B2 . #x5335)
                (#x8FB4B3 . #x533C)
                (#x8FB4B4 . #x533D)
                (#x8FB4B5 . #x533E)
                (#x8FB4B6 . #x5342)
                (#x8FB4B7 . #x534C)
                (#x8FB4B8 . #x534B)
                (#x8FB4B9 . #x5359)
                (#x8FB4BA . #x535B)
                (#x8FB4BB . #x5361)
                (#x8FB4BC . #x5363)
                (#x8FB4BD . #x5365)
                (#x8FB4BE . #x536C)
                (#x8FB4BF . #x536D)
                (#x8FB4C0 . #x5372)
                (#x8FB4C1 . #x5379)
                (#x8FB4C2 . #x537E)
                (#x8FB4C3 . #x5383)
                (#x8FB4C4 . #x5387)
                (#x8FB4C5 . #x5388)
                (#x8FB4C6 . #x538E)
                (#x8FB4C7 . #x5393)
                (#x8FB4C8 . #x5394)
                (#x8FB4C9 . #x5399)
                (#x8FB4CA . #x539D)
                (#x8FB4CB . #x53A1)
                (#x8FB4CC . #x53A4)
                (#x8FB4CD . #x53AA)
                (#x8FB4CE . #x53AB)
                (#x8FB4CF . #x53AF)
                (#x8FB4D0 . #x53B2)
                (#x8FB4D1 . #x53B4)
                (#x8FB4D2 . #x53B5)
                (#x8FB4D3 . #x53B7)
                (#x8FB4D4 . #x53B8)
                (#x8FB4D5 . #x53BA)
                (#x8FB4D6 . #x53BD)
                (#x8FB4D7 . #x53C0)
                (#x8FB4D8 . #x53C5)
                (#x8FB4D9 . #x53CF)
                (#x8FB4DA . #x53D2)
                (#x8FB4DB . #x53D3)
                (#x8FB4DC . #x53D5)
                (#x8FB4DD . #x53DA)
                (#x8FB4DE . #x53DD)
                (#x8FB4DF . #x53DE)
                (#x8FB4E0 . #x53E0)
                (#x8FB4E1 . #x53E6)
                (#x8FB4E2 . #x53E7)
                (#x8FB4E3 . #x53F5)
                (#x8FB4E4 . #x5402)
                (#x8FB4E5 . #x5413)
                (#x8FB4E6 . #x541A)
                (#x8FB4E7 . #x5421)
                (#x8FB4E8 . #x5427)
                (#x8FB4E9 . #x5428)
                (#x8FB4EA . #x542A)
                (#x8FB4EB . #x542F)
                (#x8FB4EC . #x5431)
                (#x8FB4ED . #x5434)
                (#x8FB4EE . #x5435)
                (#x8FB4EF . #x5443)
                (#x8FB4F0 . #x5444)
                (#x8FB4F1 . #x5447)
                (#x8FB4F2 . #x544D)
                (#x8FB4F3 . #x544F)
                (#x8FB4F4 . #x545E)
                (#x8FB4F5 . #x5462)
                (#x8FB4F6 . #x5464)
                (#x8FB4F7 . #x5466)
                (#x8FB4F8 . #x5467)
                (#x8FB4F9 . #x5469)
                (#x8FB4FA . #x546B)
                (#x8FB4FB . #x546D)
                (#x8FB4FC . #x546E)
                (#x8FB4FD . #x5474)
                (#x8FB4FE . #x547F)
                (#x8FB5A1 . #x5481)
                (#x8FB5A2 . #x5483)
                (#x8FB5A3 . #x5485)
                (#x8FB5A4 . #x5488)
                (#x8FB5A5 . #x5489)
                (#x8FB5A6 . #x548D)
                (#x8FB5A7 . #x5491)
                (#x8FB5A8 . #x5495)
                (#x8FB5A9 . #x5496)
                (#x8FB5AA . #x549C)
                (#x8FB5AB . #x549F)
                (#x8FB5AC . #x54A1)
                (#x8FB5AD . #x54A6)
                (#x8FB5AE . #x54A7)
                (#x8FB5AF . #x54A9)
                (#x8FB5B0 . #x54AA)
                (#x8FB5B1 . #x54AD)
                (#x8FB5B2 . #x54AE)
                (#x8FB5B3 . #x54B1)
                (#x8FB5B4 . #x54B7)
                (#x8FB5B5 . #x54B9)
                (#x8FB5B6 . #x54BA)
                (#x8FB5B7 . #x54BB)
                (#x8FB5B8 . #x54BF)
                (#x8FB5B9 . #x54C6)
                (#x8FB5BA . #x54CA)
                (#x8FB5BB . #x54CD)
                (#x8FB5BC . #x54CE)
                (#x8FB5BD . #x54E0)
                (#x8FB5BE . #x54EA)
                (#x8FB5BF . #x54EC)
                (#x8FB5C0 . #x54EF)
                (#x8FB5C1 . #x54F6)
                (#x8FB5C2 . #x54FC)
                (#x8FB5C3 . #x54FE)
                (#x8FB5C4 . #x54FF)
                (#x8FB5C5 . #x5500)
                (#x8FB5C6 . #x5501)
                (#x8FB5C7 . #x5505)
                (#x8FB5C8 . #x5508)
                (#x8FB5C9 . #x5509)
                (#x8FB5CA . #x550C)
                (#x8FB5CB . #x550D)
                (#x8FB5CC . #x550E)
                (#x8FB5CD . #x5515)
                (#x8FB5CE . #x552A)
                (#x8FB5CF . #x552B)
                (#x8FB5D0 . #x5532)
                (#x8FB5D1 . #x5535)
                (#x8FB5D2 . #x5536)
                (#x8FB5D3 . #x553B)
                (#x8FB5D4 . #x553C)
                (#x8FB5D5 . #x553D)
                (#x8FB5D6 . #x5541)
                (#x8FB5D7 . #x5547)
                (#x8FB5D8 . #x5549)
                (#x8FB5D9 . #x554A)
                (#x8FB5DA . #x554D)
                (#x8FB5DB . #x5550)
                (#x8FB5DC . #x5551)
                (#x8FB5DD . #x5558)
                (#x8FB5DE . #x555A)
                (#x8FB5DF . #x555B)
                (#x8FB5E0 . #x555E)
                (#x8FB5E1 . #x5560)
                (#x8FB5E2 . #x5561)
                (#x8FB5E3 . #x5564)
                (#x8FB5E4 . #x5566)
                (#x8FB5E5 . #x557F)
                (#x8FB5E6 . #x5581)
                (#x8FB5E7 . #x5582)
                (#x8FB5E8 . #x5586)
                (#x8FB5E9 . #x5588)
                (#x8FB5EA . #x558E)
                (#x8FB5EB . #x558F)
                (#x8FB5EC . #x5591)
                (#x8FB5ED . #x5592)
                (#x8FB5EE . #x5593)
                (#x8FB5EF . #x5594)
                (#x8FB5F0 . #x5597)
                (#x8FB5F1 . #x55A3)
                (#x8FB5F2 . #x55A4)
                (#x8FB5F3 . #x55AD)
                (#x8FB5F4 . #x55B2)
                (#x8FB5F5 . #x55BF)
                (#x8FB5F6 . #x55C1)
                (#x8FB5F7 . #x55C3)
                (#x8FB5F8 . #x55C6)
                (#x8FB5F9 . #x55C9)
                (#x8FB5FA . #x55CB)
                (#x8FB5FB . #x55CC)
                (#x8FB5FC . #x55CE)
                (#x8FB5FD . #x55D1)
                (#x8FB5FE . #x55D2)
                (#x8FB6A1 . #x55D3)
                (#x8FB6A2 . #x55D7)
                (#x8FB6A3 . #x55D8)
                (#x8FB6A4 . #x55DB)
                (#x8FB6A5 . #x55DE)
                (#x8FB6A6 . #x55E2)
                (#x8FB6A7 . #x55E9)
                (#x8FB6A8 . #x55F6)
                (#x8FB6A9 . #x55FF)
                (#x8FB6AA . #x5605)
                (#x8FB6AB . #x5608)
                (#x8FB6AC . #x560A)
                (#x8FB6AD . #x560D)
                (#x8FB6AE . #x560E)
                (#x8FB6AF . #x560F)
                (#x8FB6B0 . #x5610)
                (#x8FB6B1 . #x5611)
                (#x8FB6B2 . #x5612)
                (#x8FB6B3 . #x5619)
                (#x8FB6B4 . #x562C)
                (#x8FB6B5 . #x5630)
                (#x8FB6B6 . #x5633)
                (#x8FB6B7 . #x5635)
                (#x8FB6B8 . #x5637)
                (#x8FB6B9 . #x5639)
                (#x8FB6BA . #x563B)
                (#x8FB6BB . #x563C)
                (#x8FB6BC . #x563D)
                (#x8FB6BD . #x563F)
                (#x8FB6BE . #x5640)
                (#x8FB6BF . #x5641)
                (#x8FB6C0 . #x5643)
                (#x8FB6C1 . #x5644)
                (#x8FB6C2 . #x5646)
                (#x8FB6C3 . #x5649)
                (#x8FB6C4 . #x564B)
                (#x8FB6C5 . #x564D)
                (#x8FB6C6 . #x564F)
                (#x8FB6C7 . #x5654)
                (#x8FB6C8 . #x565E)
                (#x8FB6C9 . #x5660)
                (#x8FB6CA . #x5661)
                (#x8FB6CB . #x5662)
                (#x8FB6CC . #x5663)
                (#x8FB6CD . #x5666)
                (#x8FB6CE . #x5669)
                (#x8FB6CF . #x566D)
                (#x8FB6D0 . #x566F)
                (#x8FB6D1 . #x5671)
                (#x8FB6D2 . #x5672)
                (#x8FB6D3 . #x5675)
                (#x8FB6D4 . #x5684)
                (#x8FB6D5 . #x5685)
                (#x8FB6D6 . #x5688)
                (#x8FB6D7 . #x568B)
                (#x8FB6D8 . #x568C)
                (#x8FB6D9 . #x5695)
                (#x8FB6DA . #x5699)
                (#x8FB6DB . #x569A)
                (#x8FB6DC . #x569D)
                (#x8FB6DD . #x569E)
                (#x8FB6DE . #x569F)
                (#x8FB6DF . #x56A6)
                (#x8FB6E0 . #x56A7)
                (#x8FB6E1 . #x56A8)
                (#x8FB6E2 . #x56A9)
                (#x8FB6E3 . #x56AB)
                (#x8FB6E4 . #x56AC)
                (#x8FB6E5 . #x56AD)
                (#x8FB6E6 . #x56B1)
                (#x8FB6E7 . #x56B3)
                (#x8FB6E8 . #x56B7)
                (#x8FB6E9 . #x56BE)
                (#x8FB6EA . #x56C5)
                (#x8FB6EB . #x56C9)
                (#x8FB6EC . #x56CA)
                (#x8FB6ED . #x56CB)
                (#x8FB6EE . #x56CF)
                (#x8FB6EF . #x56D0)
                (#x8FB6F0 . #x56CC)
                (#x8FB6F1 . #x56CD)
                (#x8FB6F2 . #x56D9)
                (#x8FB6F3 . #x56DC)
                (#x8FB6F4 . #x56DD)
                (#x8FB6F5 . #x56DF)
                (#x8FB6F6 . #x56E1)
                (#x8FB6F7 . #x56E4)
                (#x8FB6F8 . #x56E5)
                (#x8FB6F9 . #x56E6)
                (#x8FB6FA . #x56E7)
                (#x8FB6FB . #x56E8)
                (#x8FB6FC . #x56F1)
                (#x8FB6FD . #x56EB)
                (#x8FB6FE . #x56ED)
                (#x8FB7A1 . #x56F6)
                (#x8FB7A2 . #x56F7)
                (#x8FB7A3 . #x5701)
                (#x8FB7A4 . #x5702)
                (#x8FB7A5 . #x5707)
                (#x8FB7A6 . #x570A)
                (#x8FB7A7 . #x570C)
                (#x8FB7A8 . #x5711)
                (#x8FB7A9 . #x5715)
                (#x8FB7AA . #x571A)
                (#x8FB7AB . #x571B)
                (#x8FB7AC . #x571D)
                (#x8FB7AD . #x5720)
                (#x8FB7AE . #x5722)
                (#x8FB7AF . #x5723)
                (#x8FB7B0 . #x5724)
                (#x8FB7B1 . #x5725)
                (#x8FB7B2 . #x5729)
                (#x8FB7B3 . #x572A)
                (#x8FB7B4 . #x572C)
                (#x8FB7B5 . #x572E)
                (#x8FB7B6 . #x572F)
                (#x8FB7B7 . #x5733)
                (#x8FB7B8 . #x5734)
                (#x8FB7B9 . #x573D)
                (#x8FB7BA . #x573E)
                (#x8FB7BB . #x573F)
                (#x8FB7BC . #x5745)
                (#x8FB7BD . #x5746)
                (#x8FB7BE . #x574C)
                (#x8FB7BF . #x574D)
                (#x8FB7C0 . #x5752)
                (#x8FB7C1 . #x5762)
                (#x8FB7C2 . #x5765)
                (#x8FB7C3 . #x5767)
                (#x8FB7C4 . #x5768)
                (#x8FB7C5 . #x576B)
                (#x8FB7C6 . #x576D)
                (#x8FB7C7 . #x576E)
                (#x8FB7C8 . #x576F)
                (#x8FB7C9 . #x5770)
                (#x8FB7CA . #x5771)
                (#x8FB7CB . #x5773)
                (#x8FB7CC . #x5774)
                (#x8FB7CD . #x5775)
                (#x8FB7CE . #x5777)
                (#x8FB7CF . #x5779)
                (#x8FB7D0 . #x577A)
                (#x8FB7D1 . #x577B)
                (#x8FB7D2 . #x577C)
                (#x8FB7D3 . #x577E)
                (#x8FB7D4 . #x5781)
                (#x8FB7D5 . #x5783)
                (#x8FB7D6 . #x578C)
                (#x8FB7D7 . #x5794)
                (#x8FB7D8 . #x5797)
                (#x8FB7D9 . #x5799)
                (#x8FB7DA . #x579A)
                (#x8FB7DB . #x579C)
                (#x8FB7DC . #x579D)
                (#x8FB7DD . #x579E)
                (#x8FB7DE . #x579F)
                (#x8FB7DF . #x57A1)
                (#x8FB7E0 . #x5795)
                (#x8FB7E1 . #x57A7)
                (#x8FB7E2 . #x57A8)
                (#x8FB7E3 . #x57A9)
                (#x8FB7E4 . #x57AC)
                (#x8FB7E5 . #x57B8)
                (#x8FB7E6 . #x57BD)
                (#x8FB7E7 . #x57C7)
                (#x8FB7E8 . #x57C8)
                (#x8FB7E9 . #x57CC)
                (#x8FB7EA . #x57CF)
                (#x8FB7EB . #x57D5)
                (#x8FB7EC . #x57DD)
                (#x8FB7ED . #x57DE)
                (#x8FB7EE . #x57E4)
                (#x8FB7EF . #x57E6)
                (#x8FB7F0 . #x57E7)
                (#x8FB7F1 . #x57E9)
                (#x8FB7F2 . #x57ED)
                (#x8FB7F3 . #x57F0)
                (#x8FB7F4 . #x57F5)
                (#x8FB7F5 . #x57F6)
                (#x8FB7F6 . #x57F8)
                (#x8FB7F7 . #x57FD)
                (#x8FB7F8 . #x57FE)
                (#x8FB7F9 . #x57FF)
                (#x8FB7FA . #x5803)
                (#x8FB7FB . #x5804)
                (#x8FB7FC . #x5808)
                (#x8FB7FD . #x5809)
                (#x8FB7FE . #x57E1)
                (#x8FB8A1 . #x580C)
                (#x8FB8A2 . #x580D)
                (#x8FB8A3 . #x581B)
                (#x8FB8A4 . #x581E)
                (#x8FB8A5 . #x581F)
                (#x8FB8A6 . #x5820)
                (#x8FB8A7 . #x5826)
                (#x8FB8A8 . #x5827)
                (#x8FB8A9 . #x582D)
                (#x8FB8AA . #x5832)
                (#x8FB8AB . #x5839)
                (#x8FB8AC . #x583F)
                (#x8FB8AD . #x5849)
                (#x8FB8AE . #x584C)
                (#x8FB8AF . #x584D)
                (#x8FB8B0 . #x584F)
                (#x8FB8B1 . #x5850)
                (#x8FB8B2 . #x5855)
                (#x8FB8B3 . #x585F)
                (#x8FB8B4 . #x5861)
                (#x8FB8B5 . #x5864)
                (#x8FB8B6 . #x5867)
                (#x8FB8B7 . #x5868)
                (#x8FB8B8 . #x5878)
                (#x8FB8B9 . #x587C)
                (#x8FB8BA . #x587F)
                (#x8FB8BB . #x5880)
                (#x8FB8BC . #x5881)
                (#x8FB8BD . #x5887)
                (#x8FB8BE . #x5888)
                (#x8FB8BF . #x5889)
                (#x8FB8C0 . #x588A)
                (#x8FB8C1 . #x588C)
                (#x8FB8C2 . #x588D)
                (#x8FB8C3 . #x588F)
                (#x8FB8C4 . #x5890)
                (#x8FB8C5 . #x5894)
                (#x8FB8C6 . #x5896)
                (#x8FB8C7 . #x589D)
                (#x8FB8C8 . #x58A0)
                (#x8FB8C9 . #x58A1)
                (#x8FB8CA . #x58A2)
                (#x8FB8CB . #x58A6)
                (#x8FB8CC . #x58A9)
                (#x8FB8CD . #x58B1)
                (#x8FB8CE . #x58B2)
                (#x8FB8CF . #x58C4)
                (#x8FB8D0 . #x58BC)
                (#x8FB8D1 . #x58C2)
                (#x8FB8D2 . #x58C8)
                (#x8FB8D3 . #x58CD)
                (#x8FB8D4 . #x58CE)
                (#x8FB8D5 . #x58D0)
                (#x8FB8D6 . #x58D2)
                (#x8FB8D7 . #x58D4)
                (#x8FB8D8 . #x58D6)
                (#x8FB8D9 . #x58DA)
                (#x8FB8DA . #x58DD)
                (#x8FB8DB . #x58E1)
                (#x8FB8DC . #x58E2)
                (#x8FB8DD . #x58E9)
                (#x8FB8DE . #x58F3)
                (#x8FB8DF . #x5905)
                (#x8FB8E0 . #x5906)
                (#x8FB8E1 . #x590B)
                (#x8FB8E2 . #x590C)
                (#x8FB8E3 . #x5912)
                (#x8FB8E4 . #x5913)
                (#x8FB8E5 . #x5914)
                (#x8FB8E6 . #x8641)
                (#x8FB8E7 . #x591D)
                (#x8FB8E8 . #x5921)
                (#x8FB8E9 . #x5923)
                (#x8FB8EA . #x5924)
                (#x8FB8EB . #x5928)
                (#x8FB8EC . #x592F)
                (#x8FB8ED . #x5930)
                (#x8FB8EE . #x5933)
                (#x8FB8EF . #x5935)
                (#x8FB8F0 . #x5936)
                (#x8FB8F1 . #x593F)
                (#x8FB8F2 . #x5943)
                (#x8FB8F3 . #x5946)
                (#x8FB8F4 . #x5952)
                (#x8FB8F5 . #x5953)
                (#x8FB8F6 . #x5959)
                (#x8FB8F7 . #x595B)
                (#x8FB8F8 . #x595D)
                (#x8FB8F9 . #x595E)
                (#x8FB8FA . #x595F)
                (#x8FB8FB . #x5961)
                (#x8FB8FC . #x5963)
                (#x8FB8FD . #x596B)
                (#x8FB8FE . #x596D)
                (#x8FB9A1 . #x596F)
                (#x8FB9A2 . #x5972)
                (#x8FB9A3 . #x5975)
                (#x8FB9A4 . #x5976)
                (#x8FB9A5 . #x5979)
                (#x8FB9A6 . #x597B)
                (#x8FB9A7 . #x597C)
                (#x8FB9A8 . #x598B)
                (#x8FB9A9 . #x598C)
                (#x8FB9AA . #x598E)
                (#x8FB9AB . #x5992)
                (#x8FB9AC . #x5995)
                (#x8FB9AD . #x5997)
                (#x8FB9AE . #x599F)
                (#x8FB9AF . #x59A4)
                (#x8FB9B0 . #x59A7)
                (#x8FB9B1 . #x59AD)
                (#x8FB9B2 . #x59AE)
                (#x8FB9B3 . #x59AF)
                (#x8FB9B4 . #x59B0)
                (#x8FB9B5 . #x59B3)
                (#x8FB9B6 . #x59B7)
                (#x8FB9B7 . #x59BA)
                (#x8FB9B8 . #x59BC)
                (#x8FB9B9 . #x59C1)
                (#x8FB9BA . #x59C3)
                (#x8FB9BB . #x59C4)
                (#x8FB9BC . #x59C8)
                (#x8FB9BD . #x59CA)
                (#x8FB9BE . #x59CD)
                (#x8FB9BF . #x59D2)
                (#x8FB9C0 . #x59DD)
                (#x8FB9C1 . #x59DE)
                (#x8FB9C2 . #x59DF)
                (#x8FB9C3 . #x59E3)
                (#x8FB9C4 . #x59E4)
                (#x8FB9C5 . #x59E7)
                (#x8FB9C6 . #x59EE)
                (#x8FB9C7 . #x59EF)
                (#x8FB9C8 . #x59F1)
                (#x8FB9C9 . #x59F2)
                (#x8FB9CA . #x59F4)
                (#x8FB9CB . #x59F7)
                (#x8FB9CC . #x5A00)
                (#x8FB9CD . #x5A04)
                (#x8FB9CE . #x5A0C)
                (#x8FB9CF . #x5A0D)
                (#x8FB9D0 . #x5A0E)
                (#x8FB9D1 . #x5A12)
                (#x8FB9D2 . #x5A13)
                (#x8FB9D3 . #x5A1E)
                (#x8FB9D4 . #x5A23)
                (#x8FB9D5 . #x5A24)
                (#x8FB9D6 . #x5A27)
                (#x8FB9D7 . #x5A28)
                (#x8FB9D8 . #x5A2A)
                (#x8FB9D9 . #x5A2D)
                (#x8FB9DA . #x5A30)
                (#x8FB9DB . #x5A44)
                (#x8FB9DC . #x5A45)
                (#x8FB9DD . #x5A47)
                (#x8FB9DE . #x5A48)
                (#x8FB9DF . #x5A4C)
                (#x8FB9E0 . #x5A50)
                (#x8FB9E1 . #x5A55)
                (#x8FB9E2 . #x5A5E)
                (#x8FB9E3 . #x5A63)
                (#x8FB9E4 . #x5A65)
                (#x8FB9E5 . #x5A67)
                (#x8FB9E6 . #x5A6D)
                (#x8FB9E7 . #x5A77)
                (#x8FB9E8 . #x5A7A)
                (#x8FB9E9 . #x5A7B)
                (#x8FB9EA . #x5A7E)
                (#x8FB9EB . #x5A8B)
                (#x8FB9EC . #x5A90)
                (#x8FB9ED . #x5A93)
                (#x8FB9EE . #x5A96)
                (#x8FB9EF . #x5A99)
                (#x8FB9F0 . #x5A9C)
                (#x8FB9F1 . #x5A9E)
                (#x8FB9F2 . #x5A9F)
                (#x8FB9F3 . #x5AA0)
                (#x8FB9F4 . #x5AA2)
                (#x8FB9F5 . #x5AA7)
                (#x8FB9F6 . #x5AAC)
                (#x8FB9F7 . #x5AB1)
                (#x8FB9F8 . #x5AB2)
                (#x8FB9F9 . #x5AB3)
                (#x8FB9FA . #x5AB5)
                (#x8FB9FB . #x5AB8)
                (#x8FB9FC . #x5ABA)
                (#x8FB9FD . #x5ABB)
                (#x8FB9FE . #x5ABF)
                (#x8FBAA1 . #x5AC4)
                (#x8FBAA2 . #x5AC6)
                (#x8FBAA3 . #x5AC8)
                (#x8FBAA4 . #x5ACF)
                (#x8FBAA5 . #x5ADA)
                (#x8FBAA6 . #x5ADC)
                (#x8FBAA7 . #x5AE0)
                (#x8FBAA8 . #x5AE5)
                (#x8FBAA9 . #x5AEA)
                (#x8FBAAA . #x5AEE)
                (#x8FBAAB . #x5AF5)
                (#x8FBAAC . #x5AF6)
                (#x8FBAAD . #x5AFD)
                (#x8FBAAE . #x5B00)
                (#x8FBAAF . #x5B01)
                (#x8FBAB0 . #x5B08)
                (#x8FBAB1 . #x5B17)
                (#x8FBAB2 . #x5B34)
                (#x8FBAB3 . #x5B19)
                (#x8FBAB4 . #x5B1B)
                (#x8FBAB5 . #x5B1D)
                (#x8FBAB6 . #x5B21)
                (#x8FBAB7 . #x5B25)
                (#x8FBAB8 . #x5B2D)
                (#x8FBAB9 . #x5B38)
                (#x8FBABA . #x5B41)
                (#x8FBABB . #x5B4B)
                (#x8FBABC . #x5B4C)
                (#x8FBABD . #x5B52)
                (#x8FBABE . #x5B56)
                (#x8FBABF . #x5B5E)
                (#x8FBAC0 . #x5B68)
                (#x8FBAC1 . #x5B6E)
                (#x8FBAC2 . #x5B6F)
                (#x8FBAC3 . #x5B7C)
                (#x8FBAC4 . #x5B7D)
                (#x8FBAC5 . #x5B7E)
                (#x8FBAC6 . #x5B7F)
                (#x8FBAC7 . #x5B81)
                (#x8FBAC8 . #x5B84)
                (#x8FBAC9 . #x5B86)
                (#x8FBACA . #x5B8A)
                (#x8FBACB . #x5B8E)
                (#x8FBACC . #x5B90)
                (#x8FBACD . #x5B91)
                (#x8FBACE . #x5B93)
                (#x8FBACF . #x5B94)
                (#x8FBAD0 . #x5B96)
                (#x8FBAD1 . #x5BA8)
                (#x8FBAD2 . #x5BA9)
                (#x8FBAD3 . #x5BAC)
                (#x8FBAD4 . #x5BAD)
                (#x8FBAD5 . #x5BAF)
                (#x8FBAD6 . #x5BB1)
                (#x8FBAD7 . #x5BB2)
                (#x8FBAD8 . #x5BB7)
                (#x8FBAD9 . #x5BBA)
                (#x8FBADA . #x5BBC)
                (#x8FBADB . #x5BC0)
                (#x8FBADC . #x5BC1)
                (#x8FBADD . #x5BCD)
                (#x8FBADE . #x5BCF)
                (#x8FBADF . #x5BD6)
                (#x8FBAE0 . #x5BD7)
                (#x8FBAE1 . #x5BD8)
                (#x8FBAE2 . #x5BD9)
                (#x8FBAE3 . #x5BDA)
                (#x8FBAE4 . #x5BE0)
                (#x8FBAE5 . #x5BEF)
                (#x8FBAE6 . #x5BF1)
                (#x8FBAE7 . #x5BF4)
                (#x8FBAE8 . #x5BFD)
                (#x8FBAE9 . #x5C0C)
                (#x8FBAEA . #x5C17)
                (#x8FBAEB . #x5C1E)
                (#x8FBAEC . #x5C1F)
                (#x8FBAED . #x5C23)
                (#x8FBAEE . #x5C26)
                (#x8FBAEF . #x5C29)
                (#x8FBAF0 . #x5C2B)
                (#x8FBAF1 . #x5C2C)
                (#x8FBAF2 . #x5C2E)
                (#x8FBAF3 . #x5C30)
                (#x8FBAF4 . #x5C32)
                (#x8FBAF5 . #x5C35)
                (#x8FBAF6 . #x5C36)
                (#x8FBAF7 . #x5C59)
                (#x8FBAF8 . #x5C5A)
                (#x8FBAF9 . #x5C5C)
                (#x8FBAFA . #x5C62)
                (#x8FBAFB . #x5C63)
                (#x8FBAFC . #x5C67)
                (#x8FBAFD . #x5C68)
                (#x8FBAFE . #x5C69)
                (#x8FBBA1 . #x5C6D)
                (#x8FBBA2 . #x5C70)
                (#x8FBBA3 . #x5C74)
                (#x8FBBA4 . #x5C75)
                (#x8FBBA5 . #x5C7A)
                (#x8FBBA6 . #x5C7B)
                (#x8FBBA7 . #x5C7C)
                (#x8FBBA8 . #x5C7D)
                (#x8FBBA9 . #x5C87)
                (#x8FBBAA . #x5C88)
                (#x8FBBAB . #x5C8A)
                (#x8FBBAC . #x5C8F)
                (#x8FBBAD . #x5C92)
                (#x8FBBAE . #x5C9D)
                (#x8FBBAF . #x5C9F)
                (#x8FBBB0 . #x5CA0)
                (#x8FBBB1 . #x5CA2)
                (#x8FBBB2 . #x5CA3)
                (#x8FBBB3 . #x5CA6)
                (#x8FBBB4 . #x5CAA)
                (#x8FBBB5 . #x5CB2)
                (#x8FBBB6 . #x5CB4)
                (#x8FBBB7 . #x5CB5)
                (#x8FBBB8 . #x5CBA)
                (#x8FBBB9 . #x5CC9)
                (#x8FBBBA . #x5CCB)
                (#x8FBBBB . #x5CD2)
                (#x8FBBBC . #x5CDD)
                (#x8FBBBD . #x5CD7)
                (#x8FBBBE . #x5CEE)
                (#x8FBBBF . #x5CF1)
                (#x8FBBC0 . #x5CF2)
                (#x8FBBC1 . #x5CF4)
                (#x8FBBC2 . #x5D01)
                (#x8FBBC3 . #x5D06)
                (#x8FBBC4 . #x5D0D)
                (#x8FBBC5 . #x5D12)
                (#x8FBBC6 . #x5D2B)
                (#x8FBBC7 . #x5D23)
                (#x8FBBC8 . #x5D24)
                (#x8FBBC9 . #x5D26)
                (#x8FBBCA . #x5D27)
                (#x8FBBCB . #x5D31)
                (#x8FBBCC . #x5D34)
                (#x8FBBCD . #x5D39)
                (#x8FBBCE . #x5D3D)
                (#x8FBBCF . #x5D3F)
                (#x8FBBD0 . #x5D42)
                (#x8FBBD1 . #x5D43)
                (#x8FBBD2 . #x5D46)
                (#x8FBBD3 . #x5D48)
                (#x8FBBD4 . #x5D55)
                (#x8FBBD5 . #x5D51)
                (#x8FBBD6 . #x5D59)
                (#x8FBBD7 . #x5D4A)
                (#x8FBBD8 . #x5D5F)
                (#x8FBBD9 . #x5D60)
                (#x8FBBDA . #x5D61)
                (#x8FBBDB . #x5D62)
                (#x8FBBDC . #x5D64)
                (#x8FBBDD . #x5D6A)
                (#x8FBBDE . #x5D6D)
                (#x8FBBDF . #x5D70)
                (#x8FBBE0 . #x5D79)
                (#x8FBBE1 . #x5D7A)
                (#x8FBBE2 . #x5D7E)
                (#x8FBBE3 . #x5D7F)
                (#x8FBBE4 . #x5D81)
                (#x8FBBE5 . #x5D83)
                (#x8FBBE6 . #x5D88)
                (#x8FBBE7 . #x5D8A)
                (#x8FBBE8 . #x5D92)
                (#x8FBBE9 . #x5D93)
                (#x8FBBEA . #x5D94)
                (#x8FBBEB . #x5D95)
                (#x8FBBEC . #x5D99)
                (#x8FBBED . #x5D9B)
                (#x8FBBEE . #x5D9F)
                (#x8FBBEF . #x5DA0)
                (#x8FBBF0 . #x5DA7)
                (#x8FBBF1 . #x5DAB)
                (#x8FBBF2 . #x5DB0)
                (#x8FBBF3 . #x5DB4)
                (#x8FBBF4 . #x5DB8)
                (#x8FBBF5 . #x5DB9)
                (#x8FBBF6 . #x5DC3)
                (#x8FBBF7 . #x5DC7)
                (#x8FBBF8 . #x5DCB)
                (#x8FBBF9 . #x5DD0)
                (#x8FBBFA . #x5DCE)
                (#x8FBBFB . #x5DD8)
                (#x8FBBFC . #x5DD9)
                (#x8FBBFD . #x5DE0)
                (#x8FBBFE . #x5DE4)
                (#x8FBCA1 . #x5DE9)
                (#x8FBCA2 . #x5DF8)
                (#x8FBCA3 . #x5DF9)
                (#x8FBCA4 . #x5E00)
                (#x8FBCA5 . #x5E07)
                (#x8FBCA6 . #x5E0D)
                (#x8FBCA7 . #x5E12)
                (#x8FBCA8 . #x5E14)
                (#x8FBCA9 . #x5E15)
                (#x8FBCAA . #x5E18)
                (#x8FBCAB . #x5E1F)
                (#x8FBCAC . #x5E20)
                (#x8FBCAD . #x5E2E)
                (#x8FBCAE . #x5E28)
                (#x8FBCAF . #x5E32)
                (#x8FBCB0 . #x5E35)
                (#x8FBCB1 . #x5E3E)
                (#x8FBCB2 . #x5E4B)
                (#x8FBCB3 . #x5E50)
                (#x8FBCB4 . #x5E49)
                (#x8FBCB5 . #x5E51)
                (#x8FBCB6 . #x5E56)
                (#x8FBCB7 . #x5E58)
                (#x8FBCB8 . #x5E5B)
                (#x8FBCB9 . #x5E5C)
                (#x8FBCBA . #x5E5E)
                (#x8FBCBB . #x5E68)
                (#x8FBCBC . #x5E6A)
                (#x8FBCBD . #x5E6B)
                (#x8FBCBE . #x5E6C)
                (#x8FBCBF . #x5E6D)
                (#x8FBCC0 . #x5E6E)
                (#x8FBCC1 . #x5E70)
                (#x8FBCC2 . #x5E80)
                (#x8FBCC3 . #x5E8B)
                (#x8FBCC4 . #x5E8E)
                (#x8FBCC5 . #x5EA2)
                (#x8FBCC6 . #x5EA4)
                (#x8FBCC7 . #x5EA5)
                (#x8FBCC8 . #x5EA8)
                (#x8FBCC9 . #x5EAA)
                (#x8FBCCA . #x5EAC)
                (#x8FBCCB . #x5EB1)
                (#x8FBCCC . #x5EB3)
                (#x8FBCCD . #x5EBD)
                (#x8FBCCE . #x5EBE)
                (#x8FBCCF . #x5EBF)
                (#x8FBCD0 . #x5EC6)
                (#x8FBCD1 . #x5ECC)
                (#x8FBCD2 . #x5ECB)
                (#x8FBCD3 . #x5ECE)
                (#x8FBCD4 . #x5ED1)
                (#x8FBCD5 . #x5ED2)
                (#x8FBCD6 . #x5ED4)
                (#x8FBCD7 . #x5ED5)
                (#x8FBCD8 . #x5EDC)
                (#x8FBCD9 . #x5EDE)
                (#x8FBCDA . #x5EE5)
                (#x8FBCDB . #x5EEB)
                (#x8FBCDC . #x5F02)
                (#x8FBCDD . #x5F06)
                (#x8FBCDE . #x5F07)
                (#x8FBCDF . #x5F08)
                (#x8FBCE0 . #x5F0E)
                (#x8FBCE1 . #x5F19)
                (#x8FBCE2 . #x5F1C)
                (#x8FBCE3 . #x5F1D)
                (#x8FBCE4 . #x5F21)
                (#x8FBCE5 . #x5F22)
                (#x8FBCE6 . #x5F23)
                (#x8FBCE7 . #x5F24)
                (#x8FBCE8 . #x5F28)
                (#x8FBCE9 . #x5F2B)
                (#x8FBCEA . #x5F2C)
                (#x8FBCEB . #x5F2E)
                (#x8FBCEC . #x5F30)
                (#x8FBCED . #x5F34)
                (#x8FBCEE . #x5F36)
                (#x8FBCEF . #x5F3B)
                (#x8FBCF0 . #x5F3D)
                (#x8FBCF1 . #x5F3F)
                (#x8FBCF2 . #x5F40)
                (#x8FBCF3 . #x5F44)
                (#x8FBCF4 . #x5F45)
                (#x8FBCF5 . #x5F47)
                (#x8FBCF6 . #x5F4D)
                (#x8FBCF7 . #x5F50)
                (#x8FBCF8 . #x5F54)
                (#x8FBCF9 . #x5F58)
                (#x8FBCFA . #x5F5B)
                (#x8FBCFB . #x5F60)
                (#x8FBCFC . #x5F63)
                (#x8FBCFD . #x5F64)
                (#x8FBCFE . #x5F67)
                (#x8FBDA1 . #x5F6F)
                (#x8FBDA2 . #x5F72)
                (#x8FBDA3 . #x5F74)
                (#x8FBDA4 . #x5F75)
                (#x8FBDA5 . #x5F78)
                (#x8FBDA6 . #x5F7A)
                (#x8FBDA7 . #x5F7D)
                (#x8FBDA8 . #x5F7E)
                (#x8FBDA9 . #x5F89)
                (#x8FBDAA . #x5F8D)
                (#x8FBDAB . #x5F8F)
                (#x8FBDAC . #x5F96)
                (#x8FBDAD . #x5F9C)
                (#x8FBDAE . #x5F9D)
                (#x8FBDAF . #x5FA2)
                (#x8FBDB0 . #x5FA7)
                (#x8FBDB1 . #x5FAB)
                (#x8FBDB2 . #x5FA4)
                (#x8FBDB3 . #x5FAC)
                (#x8FBDB4 . #x5FAF)
                (#x8FBDB5 . #x5FB0)
                (#x8FBDB6 . #x5FB1)
                (#x8FBDB7 . #x5FB8)
                (#x8FBDB8 . #x5FC4)
                (#x8FBDB9 . #x5FC7)
                (#x8FBDBA . #x5FC8)
                (#x8FBDBB . #x5FC9)
                (#x8FBDBC . #x5FCB)
                (#x8FBDBD . #x5FD0)
                (#x8FBDBE . #x5FD1)
                (#x8FBDBF . #x5FD2)
                (#x8FBDC0 . #x5FD3)
                (#x8FBDC1 . #x5FD4)
                (#x8FBDC2 . #x5FDE)
                (#x8FBDC3 . #x5FE1)
                (#x8FBDC4 . #x5FE2)
                (#x8FBDC5 . #x5FE8)
                (#x8FBDC6 . #x5FE9)
                (#x8FBDC7 . #x5FEA)
                (#x8FBDC8 . #x5FEC)
                (#x8FBDC9 . #x5FED)
                (#x8FBDCA . #x5FEE)
                (#x8FBDCB . #x5FEF)
                (#x8FBDCC . #x5FF2)
                (#x8FBDCD . #x5FF3)
                (#x8FBDCE . #x5FF6)
                (#x8FBDCF . #x5FFA)
                (#x8FBDD0 . #x5FFC)
                (#x8FBDD1 . #x6007)
                (#x8FBDD2 . #x600A)
                (#x8FBDD3 . #x600D)
                (#x8FBDD4 . #x6013)
                (#x8FBDD5 . #x6014)
                (#x8FBDD6 . #x6017)
                (#x8FBDD7 . #x6018)
                (#x8FBDD8 . #x601A)
                (#x8FBDD9 . #x601F)
                (#x8FBDDA . #x6024)
                (#x8FBDDB . #x602D)
                (#x8FBDDC . #x6033)
                (#x8FBDDD . #x6035)
                (#x8FBDDE . #x6040)
                (#x8FBDDF . #x6047)
                (#x8FBDE0 . #x6048)
                (#x8FBDE1 . #x6049)
                (#x8FBDE2 . #x604C)
                (#x8FBDE3 . #x6051)
                (#x8FBDE4 . #x6054)
                (#x8FBDE5 . #x6056)
                (#x8FBDE6 . #x6057)
                (#x8FBDE7 . #x605D)
                (#x8FBDE8 . #x6061)
                (#x8FBDE9 . #x6067)
                (#x8FBDEA . #x6071)
                (#x8FBDEB . #x607E)
                (#x8FBDEC . #x607F)
                (#x8FBDED . #x6082)
                (#x8FBDEE . #x6086)
                (#x8FBDEF . #x6088)
                (#x8FBDF0 . #x608A)
                (#x8FBDF1 . #x608E)
                (#x8FBDF2 . #x6091)
                (#x8FBDF3 . #x6093)
                (#x8FBDF4 . #x6095)
                (#x8FBDF5 . #x6098)
                (#x8FBDF6 . #x609D)
                (#x8FBDF7 . #x609E)
                (#x8FBDF8 . #x60A2)
                (#x8FBDF9 . #x60A4)
                (#x8FBDFA . #x60A5)
                (#x8FBDFB . #x60A8)
                (#x8FBDFC . #x60B0)
                (#x8FBDFD . #x60B1)
                (#x8FBDFE . #x60B7)
                (#x8FBEA1 . #x60BB)
                (#x8FBEA2 . #x60BE)
                (#x8FBEA3 . #x60C2)
                (#x8FBEA4 . #x60C4)
                (#x8FBEA5 . #x60C8)
                (#x8FBEA6 . #x60C9)
                (#x8FBEA7 . #x60CA)
                (#x8FBEA8 . #x60CB)
                (#x8FBEA9 . #x60CE)
                (#x8FBEAA . #x60CF)
                (#x8FBEAB . #x60D4)
                (#x8FBEAC . #x60D5)
                (#x8FBEAD . #x60D9)
                (#x8FBEAE . #x60DB)
                (#x8FBEAF . #x60DD)
                (#x8FBEB0 . #x60DE)
                (#x8FBEB1 . #x60E2)
                (#x8FBEB2 . #x60E5)
                (#x8FBEB3 . #x60F2)
                (#x8FBEB4 . #x60F5)
                (#x8FBEB5 . #x60F8)
                (#x8FBEB6 . #x60FC)
                (#x8FBEB7 . #x60FD)
                (#x8FBEB8 . #x6102)
                (#x8FBEB9 . #x6107)
                (#x8FBEBA . #x610A)
                (#x8FBEBB . #x610C)
                (#x8FBEBC . #x6110)
                (#x8FBEBD . #x6111)
                (#x8FBEBE . #x6112)
                (#x8FBEBF . #x6113)
                (#x8FBEC0 . #x6114)
                (#x8FBEC1 . #x6116)
                (#x8FBEC2 . #x6117)
                (#x8FBEC3 . #x6119)
                (#x8FBEC4 . #x611C)
                (#x8FBEC5 . #x611E)
                (#x8FBEC6 . #x6122)
                (#x8FBEC7 . #x612A)
                (#x8FBEC8 . #x612B)
                (#x8FBEC9 . #x6130)
                (#x8FBECA . #x6131)
                (#x8FBECB . #x6135)
                (#x8FBECC . #x6136)
                (#x8FBECD . #x6137)
                (#x8FBECE . #x6139)
                (#x8FBECF . #x6141)
                (#x8FBED0 . #x6145)
                (#x8FBED1 . #x6146)
                (#x8FBED2 . #x6149)
                (#x8FBED3 . #x615E)
                (#x8FBED4 . #x6160)
                (#x8FBED5 . #x616C)
                (#x8FBED6 . #x6172)
                (#x8FBED7 . #x6178)
                (#x8FBED8 . #x617B)
                (#x8FBED9 . #x617C)
                (#x8FBEDA . #x617F)
                (#x8FBEDB . #x6180)
                (#x8FBEDC . #x6181)
                (#x8FBEDD . #x6183)
                (#x8FBEDE . #x6184)
                (#x8FBEDF . #x618B)
                (#x8FBEE0 . #x618D)
                (#x8FBEE1 . #x6192)
                (#x8FBEE2 . #x6193)
                (#x8FBEE3 . #x6197)
                (#x8FBEE4 . #x6198)
                (#x8FBEE5 . #x619C)
                (#x8FBEE6 . #x619D)
                (#x8FBEE7 . #x619F)
                (#x8FBEE8 . #x61A0)
                (#x8FBEE9 . #x61A5)
                (#x8FBEEA . #x61A8)
                (#x8FBEEB . #x61AA)
                (#x8FBEEC . #x61AD)
                (#x8FBEED . #x61B8)
                (#x8FBEEE . #x61B9)
                (#x8FBEEF . #x61BC)
                (#x8FBEF0 . #x61C0)
                (#x8FBEF1 . #x61C1)
                (#x8FBEF2 . #x61C2)
                (#x8FBEF3 . #x61CE)
                (#x8FBEF4 . #x61CF)
                (#x8FBEF5 . #x61D5)
                (#x8FBEF6 . #x61DC)
                (#x8FBEF7 . #x61DD)
                (#x8FBEF8 . #x61DE)
                (#x8FBEF9 . #x61DF)
                (#x8FBEFA . #x61E1)
                (#x8FBEFB . #x61E2)
                (#x8FBEFC . #x61E7)
                (#x8FBEFD . #x61E9)
                (#x8FBEFE . #x61E5)
                (#x8FBFA1 . #x61EC)
                (#x8FBFA2 . #x61ED)
                (#x8FBFA3 . #x61EF)
                (#x8FBFA4 . #x6201)
                (#x8FBFA5 . #x6203)
                (#x8FBFA6 . #x6204)
                (#x8FBFA7 . #x6207)
                (#x8FBFA8 . #x6213)
                (#x8FBFA9 . #x6215)
                (#x8FBFAA . #x621C)
                (#x8FBFAB . #x6220)
                (#x8FBFAC . #x6222)
                (#x8FBFAD . #x6223)
                (#x8FBFAE . #x6227)
                (#x8FBFAF . #x6229)
                (#x8FBFB0 . #x622B)
                (#x8FBFB1 . #x6239)
                (#x8FBFB2 . #x623D)
                (#x8FBFB3 . #x6242)
                (#x8FBFB4 . #x6243)
                (#x8FBFB5 . #x6244)
                (#x8FBFB6 . #x6246)
                (#x8FBFB7 . #x624C)
                (#x8FBFB8 . #x6250)
                (#x8FBFB9 . #x6251)
                (#x8FBFBA . #x6252)
                (#x8FBFBB . #x6254)
                (#x8FBFBC . #x6256)
                (#x8FBFBD . #x625A)
                (#x8FBFBE . #x625C)
                (#x8FBFBF . #x6264)
                (#x8FBFC0 . #x626D)
                (#x8FBFC1 . #x626F)
                (#x8FBFC2 . #x6273)
                (#x8FBFC3 . #x627A)
                (#x8FBFC4 . #x627D)
                (#x8FBFC5 . #x628D)
                (#x8FBFC6 . #x628E)
                (#x8FBFC7 . #x628F)
                (#x8FBFC8 . #x6290)
                (#x8FBFC9 . #x62A6)
                (#x8FBFCA . #x62A8)
                (#x8FBFCB . #x62B3)
                (#x8FBFCC . #x62B6)
                (#x8FBFCD . #x62B7)
                (#x8FBFCE . #x62BA)
                (#x8FBFCF . #x62BE)
                (#x8FBFD0 . #x62BF)
                (#x8FBFD1 . #x62C4)
                (#x8FBFD2 . #x62CE)
                (#x8FBFD3 . #x62D5)
                (#x8FBFD4 . #x62D6)
                (#x8FBFD5 . #x62DA)
                (#x8FBFD6 . #x62EA)
                (#x8FBFD7 . #x62F2)
                (#x8FBFD8 . #x62F4)
                (#x8FBFD9 . #x62FC)
                (#x8FBFDA . #x62FD)
                (#x8FBFDB . #x6303)
                (#x8FBFDC . #x6304)
                (#x8FBFDD . #x630A)
                (#x8FBFDE . #x630B)
                (#x8FBFDF . #x630D)
                (#x8FBFE0 . #x6310)
                (#x8FBFE1 . #x6313)
                (#x8FBFE2 . #x6316)
                (#x8FBFE3 . #x6318)
                (#x8FBFE4 . #x6329)
                (#x8FBFE5 . #x632A)
                (#x8FBFE6 . #x632D)
                (#x8FBFE7 . #x6335)
                (#x8FBFE8 . #x6336)
                (#x8FBFE9 . #x6339)
                (#x8FBFEA . #x633C)
                (#x8FBFEB . #x6341)
                (#x8FBFEC . #x6342)
                (#x8FBFED . #x6343)
                (#x8FBFEE . #x6344)
                (#x8FBFEF . #x6346)
                (#x8FBFF0 . #x634A)
                (#x8FBFF1 . #x634B)
                (#x8FBFF2 . #x634E)
                (#x8FBFF3 . #x6352)
                (#x8FBFF4 . #x6353)
                (#x8FBFF5 . #x6354)
                (#x8FBFF6 . #x6358)
                (#x8FBFF7 . #x635B)
                (#x8FBFF8 . #x6365)
                (#x8FBFF9 . #x6366)
                (#x8FBFFA . #x636C)
                (#x8FBFFB . #x636D)
                (#x8FBFFC . #x6371)
                (#x8FBFFD . #x6374)
                (#x8FBFFE . #x6375)
                (#x8FC0A1 . #x6378)
                (#x8FC0A2 . #x637C)
                (#x8FC0A3 . #x637D)
                (#x8FC0A4 . #x637F)
                (#x8FC0A5 . #x6382)
                (#x8FC0A6 . #x6384)
                (#x8FC0A7 . #x6387)
                (#x8FC0A8 . #x638A)
                (#x8FC0A9 . #x6390)
                (#x8FC0AA . #x6394)
                (#x8FC0AB . #x6395)
                (#x8FC0AC . #x6399)
                (#x8FC0AD . #x639A)
                (#x8FC0AE . #x639E)
                (#x8FC0AF . #x63A4)
                (#x8FC0B0 . #x63A6)
                (#x8FC0B1 . #x63AD)
                (#x8FC0B2 . #x63AE)
                (#x8FC0B3 . #x63AF)
                (#x8FC0B4 . #x63BD)
                (#x8FC0B5 . #x63C1)
                (#x8FC0B6 . #x63C5)
                (#x8FC0B7 . #x63C8)
                (#x8FC0B8 . #x63CE)
                (#x8FC0B9 . #x63D1)
                (#x8FC0BA . #x63D3)
                (#x8FC0BB . #x63D4)
                (#x8FC0BC . #x63D5)
                (#x8FC0BD . #x63DC)
                (#x8FC0BE . #x63E0)
                (#x8FC0BF . #x63E5)
                (#x8FC0C0 . #x63EA)
                (#x8FC0C1 . #x63EC)
                (#x8FC0C2 . #x63F2)
                (#x8FC0C3 . #x63F3)
                (#x8FC0C4 . #x63F5)
                (#x8FC0C5 . #x63F8)
                (#x8FC0C6 . #x63F9)
                (#x8FC0C7 . #x6409)
                (#x8FC0C8 . #x640A)
                (#x8FC0C9 . #x6410)
                (#x8FC0CA . #x6412)
                (#x8FC0CB . #x6414)
                (#x8FC0CC . #x6418)
                (#x8FC0CD . #x641E)
                (#x8FC0CE . #x6420)
                (#x8FC0CF . #x6422)
                (#x8FC0D0 . #x6424)
                (#x8FC0D1 . #x6425)
                (#x8FC0D2 . #x6429)
                (#x8FC0D3 . #x642A)
                (#x8FC0D4 . #x642F)
                (#x8FC0D5 . #x6430)
                (#x8FC0D6 . #x6435)
                (#x8FC0D7 . #x643D)
                (#x8FC0D8 . #x643F)
                (#x8FC0D9 . #x644B)
                (#x8FC0DA . #x644F)
                (#x8FC0DB . #x6451)
                (#x8FC0DC . #x6452)
                (#x8FC0DD . #x6453)
                (#x8FC0DE . #x6454)
                (#x8FC0DF . #x645A)
                (#x8FC0E0 . #x645B)
                (#x8FC0E1 . #x645C)
                (#x8FC0E2 . #x645D)
                (#x8FC0E3 . #x645F)
                (#x8FC0E4 . #x6460)
                (#x8FC0E5 . #x6461)
                (#x8FC0E6 . #x6463)
                (#x8FC0E7 . #x646D)
                (#x8FC0E8 . #x6473)
                (#x8FC0E9 . #x6474)
                (#x8FC0EA . #x647B)
                (#x8FC0EB . #x647D)
                (#x8FC0EC . #x6485)
                (#x8FC0ED . #x6487)
                (#x8FC0EE . #x648F)
                (#x8FC0EF . #x6490)
                (#x8FC0F0 . #x6491)
                (#x8FC0F1 . #x6498)
                (#x8FC0F2 . #x6499)
                (#x8FC0F3 . #x649B)
                (#x8FC0F4 . #x649D)
                (#x8FC0F5 . #x649F)
                (#x8FC0F6 . #x64A1)
                (#x8FC0F7 . #x64A3)
                (#x8FC0F8 . #x64A6)
                (#x8FC0F9 . #x64A8)
                (#x8FC0FA . #x64AC)
                (#x8FC0FB . #x64B3)
                (#x8FC0FC . #x64BD)
                (#x8FC0FD . #x64BE)
                (#x8FC0FE . #x64BF)
                (#x8FC1A1 . #x64C4)
                (#x8FC1A2 . #x64C9)
                (#x8FC1A3 . #x64CA)
                (#x8FC1A4 . #x64CB)
                (#x8FC1A5 . #x64CC)
                (#x8FC1A6 . #x64CE)
                (#x8FC1A7 . #x64D0)
                (#x8FC1A8 . #x64D1)
                (#x8FC1A9 . #x64D5)
                (#x8FC1AA . #x64D7)
                (#x8FC1AB . #x64E4)
                (#x8FC1AC . #x64E5)
                (#x8FC1AD . #x64E9)
                (#x8FC1AE . #x64EA)
                (#x8FC1AF . #x64ED)
                (#x8FC1B0 . #x64F0)
                (#x8FC1B1 . #x64F5)
                (#x8FC1B2 . #x64F7)
                (#x8FC1B3 . #x64FB)
                (#x8FC1B4 . #x64FF)
                (#x8FC1B5 . #x6501)
                (#x8FC1B6 . #x6504)
                (#x8FC1B7 . #x6508)
                (#x8FC1B8 . #x6509)
                (#x8FC1B9 . #x650A)
                (#x8FC1BA . #x650F)
                (#x8FC1BB . #x6513)
                (#x8FC1BC . #x6514)
                (#x8FC1BD . #x6516)
                (#x8FC1BE . #x6519)
                (#x8FC1BF . #x651B)
                (#x8FC1C0 . #x651E)
                (#x8FC1C1 . #x651F)
                (#x8FC1C2 . #x6522)
                (#x8FC1C3 . #x6526)
                (#x8FC1C4 . #x6529)
                (#x8FC1C5 . #x652E)
                (#x8FC1C6 . #x6531)
                (#x8FC1C7 . #x653A)
                (#x8FC1C8 . #x653C)
                (#x8FC1C9 . #x653D)
                (#x8FC1CA . #x6543)
                (#x8FC1CB . #x6547)
                (#x8FC1CC . #x6549)
                (#x8FC1CD . #x6550)
                (#x8FC1CE . #x6552)
                (#x8FC1CF . #x6554)
                (#x8FC1D0 . #x655F)
                (#x8FC1D1 . #x6560)
                (#x8FC1D2 . #x6567)
                (#x8FC1D3 . #x656B)
                (#x8FC1D4 . #x657A)
                (#x8FC1D5 . #x657D)
                (#x8FC1D6 . #x6581)
                (#x8FC1D7 . #x6585)
                (#x8FC1D8 . #x658A)
                (#x8FC1D9 . #x6592)
                (#x8FC1DA . #x6595)
                (#x8FC1DB . #x6598)
                (#x8FC1DC . #x659D)
                (#x8FC1DD . #x65A0)
                (#x8FC1DE . #x65A3)
                (#x8FC1DF . #x65A6)
                (#x8FC1E0 . #x65AE)
                (#x8FC1E1 . #x65B2)
                (#x8FC1E2 . #x65B3)
                (#x8FC1E3 . #x65B4)
                (#x8FC1E4 . #x65BF)
                (#x8FC1E5 . #x65C2)
                (#x8FC1E6 . #x65C8)
                (#x8FC1E7 . #x65C9)
                (#x8FC1E8 . #x65CE)
                (#x8FC1E9 . #x65D0)
                (#x8FC1EA . #x65D4)
                (#x8FC1EB . #x65D6)
                (#x8FC1EC . #x65D8)
                (#x8FC1ED . #x65DF)
                (#x8FC1EE . #x65F0)
                (#x8FC1EF . #x65F2)
                (#x8FC1F0 . #x65F4)
                (#x8FC1F1 . #x65F5)
                (#x8FC1F2 . #x65F9)
                (#x8FC1F3 . #x65FE)
                (#x8FC1F4 . #x65FF)
                (#x8FC1F5 . #x6600)
                (#x8FC1F6 . #x6604)
                (#x8FC1F7 . #x6608)
                (#x8FC1F8 . #x6609)
                (#x8FC1F9 . #x660D)
                (#x8FC1FA . #x6611)
                (#x8FC1FB . #x6612)
                (#x8FC1FC . #x6615)
                (#x8FC1FD . #x6616)
                (#x8FC1FE . #x661D)
                (#x8FC2A1 . #x661E)
                (#x8FC2A2 . #x6621)
                (#x8FC2A3 . #x6622)
                (#x8FC2A4 . #x6623)
                (#x8FC2A5 . #x6624)
                (#x8FC2A6 . #x6626)
                (#x8FC2A7 . #x6629)
                (#x8FC2A8 . #x662A)
                (#x8FC2A9 . #x662B)
                (#x8FC2AA . #x662C)
                (#x8FC2AB . #x662E)
                (#x8FC2AC . #x6630)
                (#x8FC2AD . #x6631)
                (#x8FC2AE . #x6633)
                (#x8FC2AF . #x6639)
                (#x8FC2B0 . #x6637)
                (#x8FC2B1 . #x6640)
                (#x8FC2B2 . #x6645)
                (#x8FC2B3 . #x6646)
                (#x8FC2B4 . #x664A)
                (#x8FC2B5 . #x664C)
                (#x8FC2B6 . #x6651)
                (#x8FC2B7 . #x664E)
                (#x8FC2B8 . #x6657)
                (#x8FC2B9 . #x6658)
                (#x8FC2BA . #x6659)
                (#x8FC2BB . #x665B)
                (#x8FC2BC . #x665C)
                (#x8FC2BD . #x6660)
                (#x8FC2BE . #x6661)
                (#x8FC2BF . #x66FB)
                (#x8FC2C0 . #x666A)
                (#x8FC2C1 . #x666B)
                (#x8FC2C2 . #x666C)
                (#x8FC2C3 . #x667E)
                (#x8FC2C4 . #x6673)
                (#x8FC2C5 . #x6675)
                (#x8FC2C6 . #x667F)
                (#x8FC2C7 . #x6677)
                (#x8FC2C8 . #x6678)
                (#x8FC2C9 . #x6679)
                (#x8FC2CA . #x667B)
                (#x8FC2CB . #x6680)
                (#x8FC2CC . #x667C)
                (#x8FC2CD . #x668B)
                (#x8FC2CE . #x668C)
                (#x8FC2CF . #x668D)
                (#x8FC2D0 . #x6690)
                (#x8FC2D1 . #x6692)
                (#x8FC2D2 . #x6699)
                (#x8FC2D3 . #x669A)
                (#x8FC2D4 . #x669B)
                (#x8FC2D5 . #x669C)
                (#x8FC2D6 . #x669F)
                (#x8FC2D7 . #x66A0)
                (#x8FC2D8 . #x66A4)
                (#x8FC2D9 . #x66AD)
                (#x8FC2DA . #x66B1)
                (#x8FC2DB . #x66B2)
                (#x8FC2DC . #x66B5)
                (#x8FC2DD . #x66BB)
                (#x8FC2DE . #x66BF)
                (#x8FC2DF . #x66C0)
                (#x8FC2E0 . #x66C2)
                (#x8FC2E1 . #x66C3)
                (#x8FC2E2 . #x66C8)
                (#x8FC2E3 . #x66CC)
                (#x8FC2E4 . #x66CE)
                (#x8FC2E5 . #x66CF)
                (#x8FC2E6 . #x66D4)
                (#x8FC2E7 . #x66DB)
                (#x8FC2E8 . #x66DF)
                (#x8FC2E9 . #x66E8)
                (#x8FC2EA . #x66EB)
                (#x8FC2EB . #x66EC)
                (#x8FC2EC . #x66EE)
                (#x8FC2ED . #x66FA)
                (#x8FC2EE . #x6705)
                (#x8FC2EF . #x6707)
                (#x8FC2F0 . #x670E)
                (#x8FC2F1 . #x6713)
                (#x8FC2F2 . #x6719)
                (#x8FC2F3 . #x671C)
                (#x8FC2F4 . #x6720)
                (#x8FC2F5 . #x6722)
                (#x8FC2F6 . #x6733)
                (#x8FC2F7 . #x673E)
                (#x8FC2F8 . #x6745)
                (#x8FC2F9 . #x6747)
                (#x8FC2FA . #x6748)
                (#x8FC2FB . #x674C)
                (#x8FC2FC . #x6754)
                (#x8FC2FD . #x6755)
                (#x8FC2FE . #x675D)
                (#x8FC3A1 . #x6766)
                (#x8FC3A2 . #x676C)
                (#x8FC3A3 . #x676E)
                (#x8FC3A4 . #x6774)
                (#x8FC3A5 . #x6776)
                (#x8FC3A6 . #x677B)
                (#x8FC3A7 . #x6781)
                (#x8FC3A8 . #x6784)
                (#x8FC3A9 . #x678E)
                (#x8FC3AA . #x678F)
                (#x8FC3AB . #x6791)
                (#x8FC3AC . #x6793)
                (#x8FC3AD . #x6796)
                (#x8FC3AE . #x6798)
                (#x8FC3AF . #x6799)
                (#x8FC3B0 . #x679B)
                (#x8FC3B1 . #x67B0)
                (#x8FC3B2 . #x67B1)
                (#x8FC3B3 . #x67B2)
                (#x8FC3B4 . #x67B5)
                (#x8FC3B5 . #x67BB)
                (#x8FC3B6 . #x67BC)
                (#x8FC3B7 . #x67BD)
                (#x8FC3B8 . #x67F9)
                (#x8FC3B9 . #x67C0)
                (#x8FC3BA . #x67C2)
                (#x8FC3BB . #x67C3)
                (#x8FC3BC . #x67C5)
                (#x8FC3BD . #x67C8)
                (#x8FC3BE . #x67C9)
                (#x8FC3BF . #x67D2)
                (#x8FC3C0 . #x67D7)
                (#x8FC3C1 . #x67D9)
                (#x8FC3C2 . #x67DC)
                (#x8FC3C3 . #x67E1)
                (#x8FC3C4 . #x67E6)
                (#x8FC3C5 . #x67F0)
                (#x8FC3C6 . #x67F2)
                (#x8FC3C7 . #x67F6)
                (#x8FC3C8 . #x67F7)
                (#x8FC3C9 . #x6852)
                (#x8FC3CA . #x6814)
                (#x8FC3CB . #x6819)
                (#x8FC3CC . #x681D)
                (#x8FC3CD . #x681F)
                (#x8FC3CE . #x6828)
                (#x8FC3CF . #x6827)
                (#x8FC3D0 . #x682C)
                (#x8FC3D1 . #x682D)
                (#x8FC3D2 . #x682F)
                (#x8FC3D3 . #x6830)
                (#x8FC3D4 . #x6831)
                (#x8FC3D5 . #x6833)
                (#x8FC3D6 . #x683B)
                (#x8FC3D7 . #x683F)
                (#x8FC3D8 . #x6844)
                (#x8FC3D9 . #x6845)
                (#x8FC3DA . #x684A)
                (#x8FC3DB . #x684C)
                (#x8FC3DC . #x6855)
                (#x8FC3DD . #x6857)
                (#x8FC3DE . #x6858)
                (#x8FC3DF . #x685B)
                (#x8FC3E0 . #x686B)
                (#x8FC3E1 . #x686E)
                (#x8FC3E2 . #x686F)
                (#x8FC3E3 . #x6870)
                (#x8FC3E4 . #x6871)
                (#x8FC3E5 . #x6872)
                (#x8FC3E6 . #x6875)
                (#x8FC3E7 . #x6879)
                (#x8FC3E8 . #x687A)
                (#x8FC3E9 . #x687B)
                (#x8FC3EA . #x687C)
                (#x8FC3EB . #x6882)
                (#x8FC3EC . #x6884)
                (#x8FC3ED . #x6886)
                (#x8FC3EE . #x6888)
                (#x8FC3EF . #x6896)
                (#x8FC3F0 . #x6898)
                (#x8FC3F1 . #x689A)
                (#x8FC3F2 . #x689C)
                (#x8FC3F3 . #x68A1)
                (#x8FC3F4 . #x68A3)
                (#x8FC3F5 . #x68A5)
                (#x8FC3F6 . #x68A9)
                (#x8FC3F7 . #x68AA)
                (#x8FC3F8 . #x68AE)
                (#x8FC3F9 . #x68B2)
                (#x8FC3FA . #x68BB)
                (#x8FC3FB . #x68C5)
                (#x8FC3FC . #x68C8)
                (#x8FC3FD . #x68CC)
                (#x8FC3FE . #x68CF)
                (#x8FC4A1 . #x68D0)
                (#x8FC4A2 . #x68D1)
                (#x8FC4A3 . #x68D3)
                (#x8FC4A4 . #x68D6)
                (#x8FC4A5 . #x68D9)
                (#x8FC4A6 . #x68DC)
                (#x8FC4A7 . #x68DD)
                (#x8FC4A8 . #x68E5)
                (#x8FC4A9 . #x68E8)
                (#x8FC4AA . #x68EA)
                (#x8FC4AB . #x68EB)
                (#x8FC4AC . #x68EC)
                (#x8FC4AD . #x68ED)
                (#x8FC4AE . #x68F0)
                (#x8FC4AF . #x68F1)
                (#x8FC4B0 . #x68F5)
                (#x8FC4B1 . #x68F6)
                (#x8FC4B2 . #x68FB)
                (#x8FC4B3 . #x68FC)
                (#x8FC4B4 . #x68FD)
                (#x8FC4B5 . #x6906)
                (#x8FC4B6 . #x6909)
                (#x8FC4B7 . #x690A)
                (#x8FC4B8 . #x6910)
                (#x8FC4B9 . #x6911)
                (#x8FC4BA . #x6913)
                (#x8FC4BB . #x6916)
                (#x8FC4BC . #x6917)
                (#x8FC4BD . #x6931)
                (#x8FC4BE . #x6933)
                (#x8FC4BF . #x6935)
                (#x8FC4C0 . #x6938)
                (#x8FC4C1 . #x693B)
                (#x8FC4C2 . #x6942)
                (#x8FC4C3 . #x6945)
                (#x8FC4C4 . #x6949)
                (#x8FC4C5 . #x694E)
                (#x8FC4C6 . #x6957)
                (#x8FC4C7 . #x695B)
                (#x8FC4C8 . #x6963)
                (#x8FC4C9 . #x6964)
                (#x8FC4CA . #x6965)
                (#x8FC4CB . #x6966)
                (#x8FC4CC . #x6968)
                (#x8FC4CD . #x6969)
                (#x8FC4CE . #x696C)
                (#x8FC4CF . #x6970)
                (#x8FC4D0 . #x6971)
                (#x8FC4D1 . #x6972)
                (#x8FC4D2 . #x697A)
                (#x8FC4D3 . #x697B)
                (#x8FC4D4 . #x697F)
                (#x8FC4D5 . #x6980)
                (#x8FC4D6 . #x698D)
                (#x8FC4D7 . #x6992)
                (#x8FC4D8 . #x6996)
                (#x8FC4D9 . #x6998)
                (#x8FC4DA . #x69A1)
                (#x8FC4DB . #x69A5)
                (#x8FC4DC . #x69A6)
                (#x8FC4DD . #x69A8)
                (#x8FC4DE . #x69AB)
                (#x8FC4DF . #x69AD)
                (#x8FC4E0 . #x69AF)
                (#x8FC4E1 . #x69B7)
                (#x8FC4E2 . #x69B8)
                (#x8FC4E3 . #x69BA)
                (#x8FC4E4 . #x69BC)
                (#x8FC4E5 . #x69C5)
                (#x8FC4E6 . #x69C8)
                (#x8FC4E7 . #x69D1)
                (#x8FC4E8 . #x69D6)
                (#x8FC4E9 . #x69D7)
                (#x8FC4EA . #x69E2)
                (#x8FC4EB . #x69E5)
                (#x8FC4EC . #x69EE)
                (#x8FC4ED . #x69EF)
                (#x8FC4EE . #x69F1)
                (#x8FC4EF . #x69F3)
                (#x8FC4F0 . #x69F5)
                (#x8FC4F1 . #x69FE)
                (#x8FC4F2 . #x6A00)
                (#x8FC4F3 . #x6A01)
                (#x8FC4F4 . #x6A03)
                (#x8FC4F5 . #x6A0F)
                (#x8FC4F6 . #x6A11)
                (#x8FC4F7 . #x6A15)
                (#x8FC4F8 . #x6A1A)
                (#x8FC4F9 . #x6A1D)
                (#x8FC4FA . #x6A20)
                (#x8FC4FB . #x6A24)
                (#x8FC4FC . #x6A28)
                (#x8FC4FD . #x6A30)
                (#x8FC4FE . #x6A32)
                (#x8FC5A1 . #x6A34)
                (#x8FC5A2 . #x6A37)
                (#x8FC5A3 . #x6A3B)
                (#x8FC5A4 . #x6A3E)
                (#x8FC5A5 . #x6A3F)
                (#x8FC5A6 . #x6A45)
                (#x8FC5A7 . #x6A46)
                (#x8FC5A8 . #x6A49)
                (#x8FC5A9 . #x6A4A)
                (#x8FC5AA . #x6A4E)
                (#x8FC5AB . #x6A50)
                (#x8FC5AC . #x6A51)
                (#x8FC5AD . #x6A52)
                (#x8FC5AE . #x6A55)
                (#x8FC5AF . #x6A56)
                (#x8FC5B0 . #x6A5B)
                (#x8FC5B1 . #x6A64)
                (#x8FC5B2 . #x6A67)
                (#x8FC5B3 . #x6A6A)
                (#x8FC5B4 . #x6A71)
                (#x8FC5B5 . #x6A73)
                (#x8FC5B6 . #x6A7E)
                (#x8FC5B7 . #x6A81)
                (#x8FC5B8 . #x6A83)
                (#x8FC5B9 . #x6A86)
                (#x8FC5BA . #x6A87)
                (#x8FC5BB . #x6A89)
                (#x8FC5BC . #x6A8B)
                (#x8FC5BD . #x6A91)
                (#x8FC5BE . #x6A9B)
                (#x8FC5BF . #x6A9D)
                (#x8FC5C0 . #x6A9E)
                (#x8FC5C1 . #x6A9F)
                (#x8FC5C2 . #x6AA5)
                (#x8FC5C3 . #x6AAB)
                (#x8FC5C4 . #x6AAF)
                (#x8FC5C5 . #x6AB0)
                (#x8FC5C6 . #x6AB1)
                (#x8FC5C7 . #x6AB4)
                (#x8FC5C8 . #x6ABD)
                (#x8FC5C9 . #x6ABE)
                (#x8FC5CA . #x6ABF)
                (#x8FC5CB . #x6AC6)
                (#x8FC5CC . #x6AC9)
                (#x8FC5CD . #x6AC8)
                (#x8FC5CE . #x6ACC)
                (#x8FC5CF . #x6AD0)
                (#x8FC5D0 . #x6AD4)
                (#x8FC5D1 . #x6AD5)
                (#x8FC5D2 . #x6AD6)
                (#x8FC5D3 . #x6ADC)
                (#x8FC5D4 . #x6ADD)
                (#x8FC5D5 . #x6AE4)
                (#x8FC5D6 . #x6AE7)
                (#x8FC5D7 . #x6AEC)
                (#x8FC5D8 . #x6AF0)
                (#x8FC5D9 . #x6AF1)
                (#x8FC5DA . #x6AF2)
                (#x8FC5DB . #x6AFC)
                (#x8FC5DC . #x6AFD)
                (#x8FC5DD . #x6B02)
                (#x8FC5DE . #x6B03)
                (#x8FC5DF . #x6B06)
                (#x8FC5E0 . #x6B07)
                (#x8FC5E1 . #x6B09)
                (#x8FC5E2 . #x6B0F)
                (#x8FC5E3 . #x6B10)
                (#x8FC5E4 . #x6B11)
                (#x8FC5E5 . #x6B17)
                (#x8FC5E6 . #x6B1B)
                (#x8FC5E7 . #x6B1E)
                (#x8FC5E8 . #x6B24)
                (#x8FC5E9 . #x6B28)
                (#x8FC5EA . #x6B2B)
                (#x8FC5EB . #x6B2C)
                (#x8FC5EC . #x6B2F)
                (#x8FC5ED . #x6B35)
                (#x8FC5EE . #x6B36)
                (#x8FC5EF . #x6B3B)
                (#x8FC5F0 . #x6B3F)
                (#x8FC5F1 . #x6B46)
                (#x8FC5F2 . #x6B4A)
                (#x8FC5F3 . #x6B4D)
                (#x8FC5F4 . #x6B52)
                (#x8FC5F5 . #x6B56)
                (#x8FC5F6 . #x6B58)
                (#x8FC5F7 . #x6B5D)
                (#x8FC5F8 . #x6B60)
                (#x8FC5F9 . #x6B67)
                (#x8FC5FA . #x6B6B)
                (#x8FC5FB . #x6B6E)
                (#x8FC5FC . #x6B70)
                (#x8FC5FD . #x6B75)
                (#x8FC5FE . #x6B7D)
                (#x8FC6A1 . #x6B7E)
                (#x8FC6A2 . #x6B82)
                (#x8FC6A3 . #x6B85)
                (#x8FC6A4 . #x6B97)
                (#x8FC6A5 . #x6B9B)
                (#x8FC6A6 . #x6B9F)
                (#x8FC6A7 . #x6BA0)
                (#x8FC6A8 . #x6BA2)
                (#x8FC6A9 . #x6BA3)
                (#x8FC6AA . #x6BA8)
                (#x8FC6AB . #x6BA9)
                (#x8FC6AC . #x6BAC)
                (#x8FC6AD . #x6BAD)
                (#x8FC6AE . #x6BAE)
                (#x8FC6AF . #x6BB0)
                (#x8FC6B0 . #x6BB8)
                (#x8FC6B1 . #x6BB9)
                (#x8FC6B2 . #x6BBD)
                (#x8FC6B3 . #x6BBE)
                (#x8FC6B4 . #x6BC3)
                (#x8FC6B5 . #x6BC4)
                (#x8FC6B6 . #x6BC9)
                (#x8FC6B7 . #x6BCC)
                (#x8FC6B8 . #x6BD6)
                (#x8FC6B9 . #x6BDA)
                (#x8FC6BA . #x6BE1)
                (#x8FC6BB . #x6BE3)
                (#x8FC6BC . #x6BE6)
                (#x8FC6BD . #x6BE7)
                (#x8FC6BE . #x6BEE)
                (#x8FC6BF . #x6BF1)
                (#x8FC6C0 . #x6BF7)
                (#x8FC6C1 . #x6BF9)
                (#x8FC6C2 . #x6BFF)
                (#x8FC6C3 . #x6C02)
                (#x8FC6C4 . #x6C04)
                (#x8FC6C5 . #x6C05)
                (#x8FC6C6 . #x6C09)
                (#x8FC6C7 . #x6C0D)
                (#x8FC6C8 . #x6C0E)
                (#x8FC6C9 . #x6C10)
                (#x8FC6CA . #x6C12)
                (#x8FC6CB . #x6C19)
                (#x8FC6CC . #x6C1F)
                (#x8FC6CD . #x6C26)
                (#x8FC6CE . #x6C27)
                (#x8FC6CF . #x6C28)
                (#x8FC6D0 . #x6C2C)
                (#x8FC6D1 . #x6C2E)
                (#x8FC6D2 . #x6C33)
                (#x8FC6D3 . #x6C35)
                (#x8FC6D4 . #x6C36)
                (#x8FC6D5 . #x6C3A)
                (#x8FC6D6 . #x6C3B)
                (#x8FC6D7 . #x6C3F)
                (#x8FC6D8 . #x6C4A)
                (#x8FC6D9 . #x6C4B)
                (#x8FC6DA . #x6C4D)
                (#x8FC6DB . #x6C4F)
                (#x8FC6DC . #x6C52)
                (#x8FC6DD . #x6C54)
                (#x8FC6DE . #x6C59)
                (#x8FC6DF . #x6C5B)
                (#x8FC6E0 . #x6C5C)
                (#x8FC6E1 . #x6C6B)
                (#x8FC6E2 . #x6C6D)
                (#x8FC6E3 . #x6C6F)
                (#x8FC6E4 . #x6C74)
                (#x8FC6E5 . #x6C76)
                (#x8FC6E6 . #x6C78)
                (#x8FC6E7 . #x6C79)
                (#x8FC6E8 . #x6C7B)
                (#x8FC6E9 . #x6C85)
                (#x8FC6EA . #x6C86)
                (#x8FC6EB . #x6C87)
                (#x8FC6EC . #x6C89)
                (#x8FC6ED . #x6C94)
                (#x8FC6EE . #x6C95)
                (#x8FC6EF . #x6C97)
                (#x8FC6F0 . #x6C98)
                (#x8FC6F1 . #x6C9C)
                (#x8FC6F2 . #x6C9F)
                (#x8FC6F3 . #x6CB0)
                (#x8FC6F4 . #x6CB2)
                (#x8FC6F5 . #x6CB4)
                (#x8FC6F6 . #x6CC2)
                (#x8FC6F7 . #x6CC6)
                (#x8FC6F8 . #x6CCD)
                (#x8FC6F9 . #x6CCF)
                (#x8FC6FA . #x6CD0)
                (#x8FC6FB . #x6CD1)
                (#x8FC6FC . #x6CD2)
                (#x8FC6FD . #x6CD4)
                (#x8FC6FE . #x6CD6)
                (#x8FC7A1 . #x6CDA)
                (#x8FC7A2 . #x6CDC)
                (#x8FC7A3 . #x6CE0)
                (#x8FC7A4 . #x6CE7)
                (#x8FC7A5 . #x6CE9)
                (#x8FC7A6 . #x6CEB)
                (#x8FC7A7 . #x6CEC)
                (#x8FC7A8 . #x6CEE)
                (#x8FC7A9 . #x6CF2)
                (#x8FC7AA . #x6CF4)
                (#x8FC7AB . #x6D04)
                (#x8FC7AC . #x6D07)
                (#x8FC7AD . #x6D0A)
                (#x8FC7AE . #x6D0E)
                (#x8FC7AF . #x6D0F)
                (#x8FC7B0 . #x6D11)
                (#x8FC7B1 . #x6D13)
                (#x8FC7B2 . #x6D1A)
                (#x8FC7B3 . #x6D26)
                (#x8FC7B4 . #x6D27)
                (#x8FC7B5 . #x6D28)
                (#x8FC7B6 . #x6C67)
                (#x8FC7B7 . #x6D2E)
                (#x8FC7B8 . #x6D2F)
                (#x8FC7B9 . #x6D31)
                (#x8FC7BA . #x6D39)
                (#x8FC7BB . #x6D3C)
                (#x8FC7BC . #x6D3F)
                (#x8FC7BD . #x6D57)
                (#x8FC7BE . #x6D5E)
                (#x8FC7BF . #x6D5F)
                (#x8FC7C0 . #x6D61)
                (#x8FC7C1 . #x6D65)
                (#x8FC7C2 . #x6D67)
                (#x8FC7C3 . #x6D6F)
                (#x8FC7C4 . #x6D70)
                (#x8FC7C5 . #x6D7C)
                (#x8FC7C6 . #x6D82)
                (#x8FC7C7 . #x6D87)
                (#x8FC7C8 . #x6D91)
                (#x8FC7C9 . #x6D92)
                (#x8FC7CA . #x6D94)
                (#x8FC7CB . #x6D96)
                (#x8FC7CC . #x6D97)
                (#x8FC7CD . #x6D98)
                (#x8FC7CE . #x6DAA)
                (#x8FC7CF . #x6DAC)
                (#x8FC7D0 . #x6DB4)
                (#x8FC7D1 . #x6DB7)
                (#x8FC7D2 . #x6DB9)
                (#x8FC7D3 . #x6DBD)
                (#x8FC7D4 . #x6DBF)
                (#x8FC7D5 . #x6DC4)
                (#x8FC7D6 . #x6DC8)
                (#x8FC7D7 . #x6DCA)
                (#x8FC7D8 . #x6DCE)
                (#x8FC7D9 . #x6DCF)
                (#x8FC7DA . #x6DD6)
                (#x8FC7DB . #x6DDB)
                (#x8FC7DC . #x6DDD)
                (#x8FC7DD . #x6DDF)
                (#x8FC7DE . #x6DE0)
                (#x8FC7DF . #x6DE2)
                (#x8FC7E0 . #x6DE5)
                (#x8FC7E1 . #x6DE9)
                (#x8FC7E2 . #x6DEF)
                (#x8FC7E3 . #x6DF0)
                (#x8FC7E4 . #x6DF4)
                (#x8FC7E5 . #x6DF6)
                (#x8FC7E6 . #x6DFC)
                (#x8FC7E7 . #x6E00)
                (#x8FC7E8 . #x6E04)
                (#x8FC7E9 . #x6E1E)
                (#x8FC7EA . #x6E22)
                (#x8FC7EB . #x6E27)
                (#x8FC7EC . #x6E32)
                (#x8FC7ED . #x6E36)
                (#x8FC7EE . #x6E39)
                (#x8FC7EF . #x6E3B)
                (#x8FC7F0 . #x6E3C)
                (#x8FC7F1 . #x6E44)
                (#x8FC7F2 . #x6E45)
                (#x8FC7F3 . #x6E48)
                (#x8FC7F4 . #x6E49)
                (#x8FC7F5 . #x6E4B)
                (#x8FC7F6 . #x6E4F)
                (#x8FC7F7 . #x6E51)
                (#x8FC7F8 . #x6E52)
                (#x8FC7F9 . #x6E53)
                (#x8FC7FA . #x6E54)
                (#x8FC7FB . #x6E57)
                (#x8FC7FC . #x6E5C)
                (#x8FC7FD . #x6E5D)
                (#x8FC7FE . #x6E5E)
                (#x8FC8A1 . #x6E62)
                (#x8FC8A2 . #x6E63)
                (#x8FC8A3 . #x6E68)
                (#x8FC8A4 . #x6E73)
                (#x8FC8A5 . #x6E7B)
                (#x8FC8A6 . #x6E7D)
                (#x8FC8A7 . #x6E8D)
                (#x8FC8A8 . #x6E93)
                (#x8FC8A9 . #x6E99)
                (#x8FC8AA . #x6EA0)
                (#x8FC8AB . #x6EA7)
                (#x8FC8AC . #x6EAD)
                (#x8FC8AD . #x6EAE)
                (#x8FC8AE . #x6EB1)
                (#x8FC8AF . #x6EB3)
                (#x8FC8B0 . #x6EBB)
                (#x8FC8B1 . #x6EBF)
                (#x8FC8B2 . #x6EC0)
                (#x8FC8B3 . #x6EC1)
                (#x8FC8B4 . #x6EC3)
                (#x8FC8B5 . #x6EC7)
                (#x8FC8B6 . #x6EC8)
                (#x8FC8B7 . #x6ECA)
                (#x8FC8B8 . #x6ECD)
                (#x8FC8B9 . #x6ECE)
                (#x8FC8BA . #x6ECF)
                (#x8FC8BB . #x6EEB)
                (#x8FC8BC . #x6EED)
                (#x8FC8BD . #x6EEE)
                (#x8FC8BE . #x6EF9)
                (#x8FC8BF . #x6EFB)
                (#x8FC8C0 . #x6EFD)
                (#x8FC8C1 . #x6F04)
                (#x8FC8C2 . #x6F08)
                (#x8FC8C3 . #x6F0A)
                (#x8FC8C4 . #x6F0C)
                (#x8FC8C5 . #x6F0D)
                (#x8FC8C6 . #x6F16)
                (#x8FC8C7 . #x6F18)
                (#x8FC8C8 . #x6F1A)
                (#x8FC8C9 . #x6F1B)
                (#x8FC8CA . #x6F26)
                (#x8FC8CB . #x6F29)
                (#x8FC8CC . #x6F2A)
                (#x8FC8CD . #x6F2F)
                (#x8FC8CE . #x6F30)
                (#x8FC8CF . #x6F33)
                (#x8FC8D0 . #x6F36)
                (#x8FC8D1 . #x6F3B)
                (#x8FC8D2 . #x6F3C)
                (#x8FC8D3 . #x6F2D)
                (#x8FC8D4 . #x6F4F)
                (#x8FC8D5 . #x6F51)
                (#x8FC8D6 . #x6F52)
                (#x8FC8D7 . #x6F53)
                (#x8FC8D8 . #x6F57)
                (#x8FC8D9 . #x6F59)
                (#x8FC8DA . #x6F5A)
                (#x8FC8DB . #x6F5D)
                (#x8FC8DC . #x6F5E)
                (#x8FC8DD . #x6F61)
                (#x8FC8DE . #x6F62)
                (#x8FC8DF . #x6F68)
                (#x8FC8E0 . #x6F6C)
                (#x8FC8E1 . #x6F7D)
                (#x8FC8E2 . #x6F7E)
                (#x8FC8E3 . #x6F83)
                (#x8FC8E4 . #x6F87)
                (#x8FC8E5 . #x6F88)
                (#x8FC8E6 . #x6F8B)
                (#x8FC8E7 . #x6F8C)
                (#x8FC8E8 . #x6F8D)
                (#x8FC8E9 . #x6F90)
                (#x8FC8EA . #x6F92)
                (#x8FC8EB . #x6F93)
                (#x8FC8EC . #x6F94)
                (#x8FC8ED . #x6F96)
                (#x8FC8EE . #x6F9A)
                (#x8FC8EF . #x6F9F)
                (#x8FC8F0 . #x6FA0)
                (#x8FC8F1 . #x6FA5)
                (#x8FC8F2 . #x6FA6)
                (#x8FC8F3 . #x6FA7)
                (#x8FC8F4 . #x6FA8)
                (#x8FC8F5 . #x6FAE)
                (#x8FC8F6 . #x6FAF)
                (#x8FC8F7 . #x6FB0)
                (#x8FC8F8 . #x6FB5)
                (#x8FC8F9 . #x6FB6)
                (#x8FC8FA . #x6FBC)
                (#x8FC8FB . #x6FC5)
                (#x8FC8FC . #x6FC7)
                (#x8FC8FD . #x6FC8)
                (#x8FC8FE . #x6FCA)
                (#x8FC9A1 . #x6FDA)
                (#x8FC9A2 . #x6FDE)
                (#x8FC9A3 . #x6FE8)
                (#x8FC9A4 . #x6FE9)
                (#x8FC9A5 . #x6FF0)
                (#x8FC9A6 . #x6FF5)
                (#x8FC9A7 . #x6FF9)
                (#x8FC9A8 . #x6FFC)
                (#x8FC9A9 . #x6FFD)
                (#x8FC9AA . #x7000)
                (#x8FC9AB . #x7005)
                (#x8FC9AC . #x7006)
                (#x8FC9AD . #x7007)
                (#x8FC9AE . #x700D)
                (#x8FC9AF . #x7017)
                (#x8FC9B0 . #x7020)
                (#x8FC9B1 . #x7023)
                (#x8FC9B2 . #x702F)
                (#x8FC9B3 . #x7034)
                (#x8FC9B4 . #x7037)
                (#x8FC9B5 . #x7039)
                (#x8FC9B6 . #x703C)
                (#x8FC9B7 . #x7043)
                (#x8FC9B8 . #x7044)
                (#x8FC9B9 . #x7048)
                (#x8FC9BA . #x7049)
                (#x8FC9BB . #x704A)
                (#x8FC9BC . #x704B)
                (#x8FC9BD . #x7054)
                (#x8FC9BE . #x7055)
                (#x8FC9BF . #x705D)
                (#x8FC9C0 . #x705E)
                (#x8FC9C1 . #x704E)
                (#x8FC9C2 . #x7064)
                (#x8FC9C3 . #x7065)
                (#x8FC9C4 . #x706C)
                (#x8FC9C5 . #x706E)
                (#x8FC9C6 . #x7075)
                (#x8FC9C7 . #x7076)
                (#x8FC9C8 . #x707E)
                (#x8FC9C9 . #x7081)
                (#x8FC9CA . #x7085)
                (#x8FC9CB . #x7086)
                (#x8FC9CC . #x7094)
                (#x8FC9CD . #x7095)
                (#x8FC9CE . #x7096)
                (#x8FC9CF . #x7097)
                (#x8FC9D0 . #x7098)
                (#x8FC9D1 . #x709B)
                (#x8FC9D2 . #x70A4)
                (#x8FC9D3 . #x70AB)
                (#x8FC9D4 . #x70B0)
                (#x8FC9D5 . #x70B1)
                (#x8FC9D6 . #x70B4)
                (#x8FC9D7 . #x70B7)
                (#x8FC9D8 . #x70CA)
                (#x8FC9D9 . #x70D1)
                (#x8FC9DA . #x70D3)
                (#x8FC9DB . #x70D4)
                (#x8FC9DC . #x70D5)
                (#x8FC9DD . #x70D6)
                (#x8FC9DE . #x70D8)
                (#x8FC9DF . #x70DC)
                (#x8FC9E0 . #x70E4)
                (#x8FC9E1 . #x70FA)
                (#x8FC9E2 . #x7103)
                (#x8FC9E3 . #x7104)
                (#x8FC9E4 . #x7105)
                (#x8FC9E5 . #x7106)
                (#x8FC9E6 . #x7107)
                (#x8FC9E7 . #x710B)
                (#x8FC9E8 . #x710C)
                (#x8FC9E9 . #x710F)
                (#x8FC9EA . #x711E)
                (#x8FC9EB . #x7120)
                (#x8FC9EC . #x712B)
                (#x8FC9ED . #x712D)
                (#x8FC9EE . #x712F)
                (#x8FC9EF . #x7130)
                (#x8FC9F0 . #x7131)
                (#x8FC9F1 . #x7138)
                (#x8FC9F2 . #x7141)
                (#x8FC9F3 . #x7145)
                (#x8FC9F4 . #x7146)
                (#x8FC9F5 . #x7147)
                (#x8FC9F6 . #x714A)
                (#x8FC9F7 . #x714B)
                (#x8FC9F8 . #x7150)
                (#x8FC9F9 . #x7152)
                (#x8FC9FA . #x7157)
                (#x8FC9FB . #x715A)
                (#x8FC9FC . #x715C)
                (#x8FC9FD . #x715E)
                (#x8FC9FE . #x7160)
                (#x8FCAA1 . #x7168)
                (#x8FCAA2 . #x7179)
                (#x8FCAA3 . #x7180)
                (#x8FCAA4 . #x7185)
                (#x8FCAA5 . #x7187)
                (#x8FCAA6 . #x718C)
                (#x8FCAA7 . #x7192)
                (#x8FCAA8 . #x719A)
                (#x8FCAA9 . #x719B)
                (#x8FCAAA . #x71A0)
                (#x8FCAAB . #x71A2)
                (#x8FCAAC . #x71AF)
                (#x8FCAAD . #x71B0)
                (#x8FCAAE . #x71B2)
                (#x8FCAAF . #x71B3)
                (#x8FCAB0 . #x71BA)
                (#x8FCAB1 . #x71BF)
                (#x8FCAB2 . #x71C0)
                (#x8FCAB3 . #x71C1)
                (#x8FCAB4 . #x71C4)
                (#x8FCAB5 . #x71CB)
                (#x8FCAB6 . #x71CC)
                (#x8FCAB7 . #x71D3)
                (#x8FCAB8 . #x71D6)
                (#x8FCAB9 . #x71D9)
                (#x8FCABA . #x71DA)
                (#x8FCABB . #x71DC)
                (#x8FCABC . #x71F8)
                (#x8FCABD . #x71FE)
                (#x8FCABE . #x7200)
                (#x8FCABF . #x7207)
                (#x8FCAC0 . #x7208)
                (#x8FCAC1 . #x7209)
                (#x8FCAC2 . #x7213)
                (#x8FCAC3 . #x7217)
                (#x8FCAC4 . #x721A)
                (#x8FCAC5 . #x721D)
                (#x8FCAC6 . #x721F)
                (#x8FCAC7 . #x7224)
                (#x8FCAC8 . #x722B)
                (#x8FCAC9 . #x722F)
                (#x8FCACA . #x7234)
                (#x8FCACB . #x7238)
                (#x8FCACC . #x7239)
                (#x8FCACD . #x7241)
                (#x8FCACE . #x7242)
                (#x8FCACF . #x7243)
                (#x8FCAD0 . #x7245)
                (#x8FCAD1 . #x724E)
                (#x8FCAD2 . #x724F)
                (#x8FCAD3 . #x7250)
                (#x8FCAD4 . #x7253)
                (#x8FCAD5 . #x7255)
                (#x8FCAD6 . #x7256)
                (#x8FCAD7 . #x725A)
                (#x8FCAD8 . #x725C)
                (#x8FCAD9 . #x725E)
                (#x8FCADA . #x7260)
                (#x8FCADB . #x7263)
                (#x8FCADC . #x7268)
                (#x8FCADD . #x726B)
                (#x8FCADE . #x726E)
                (#x8FCADF . #x726F)
                (#x8FCAE0 . #x7271)
                (#x8FCAE1 . #x7277)
                (#x8FCAE2 . #x7278)
                (#x8FCAE3 . #x727B)
                (#x8FCAE4 . #x727C)
                (#x8FCAE5 . #x727F)
                (#x8FCAE6 . #x7284)
                (#x8FCAE7 . #x7289)
                (#x8FCAE8 . #x728D)
                (#x8FCAE9 . #x728E)
                (#x8FCAEA . #x7293)
                (#x8FCAEB . #x729B)
                (#x8FCAEC . #x72A8)
                (#x8FCAED . #x72AD)
                (#x8FCAEE . #x72AE)
                (#x8FCAEF . #x72B1)
                (#x8FCAF0 . #x72B4)
                (#x8FCAF1 . #x72BE)
                (#x8FCAF2 . #x72C1)
                (#x8FCAF3 . #x72C7)
                (#x8FCAF4 . #x72C9)
                (#x8FCAF5 . #x72CC)
                (#x8FCAF6 . #x72D5)
                (#x8FCAF7 . #x72D6)
                (#x8FCAF8 . #x72D8)
                (#x8FCAF9 . #x72DF)
                (#x8FCAFA . #x72E5)
                (#x8FCAFB . #x72F3)
                (#x8FCAFC . #x72F4)
                (#x8FCAFD . #x72FA)
                (#x8FCAFE . #x72FB)
                (#x8FCBA1 . #x72FE)
                (#x8FCBA2 . #x7302)
                (#x8FCBA3 . #x7304)
                (#x8FCBA4 . #x7305)
                (#x8FCBA5 . #x7307)
                (#x8FCBA6 . #x730B)
                (#x8FCBA7 . #x730D)
                (#x8FCBA8 . #x7312)
                (#x8FCBA9 . #x7313)
                (#x8FCBAA . #x7318)
                (#x8FCBAB . #x7319)
                (#x8FCBAC . #x731E)
                (#x8FCBAD . #x7322)
                (#x8FCBAE . #x7324)
                (#x8FCBAF . #x7327)
                (#x8FCBB0 . #x7328)
                (#x8FCBB1 . #x732C)
                (#x8FCBB2 . #x7331)
                (#x8FCBB3 . #x7332)
                (#x8FCBB4 . #x7335)
                (#x8FCBB5 . #x733A)
                (#x8FCBB6 . #x733B)
                (#x8FCBB7 . #x733D)
                (#x8FCBB8 . #x7343)
                (#x8FCBB9 . #x734D)
                (#x8FCBBA . #x7350)
                (#x8FCBBB . #x7352)
                (#x8FCBBC . #x7356)
                (#x8FCBBD . #x7358)
                (#x8FCBBE . #x735D)
                (#x8FCBBF . #x735E)
                (#x8FCBC0 . #x735F)
                (#x8FCBC1 . #x7360)
                (#x8FCBC2 . #x7366)
                (#x8FCBC3 . #x7367)
                (#x8FCBC4 . #x7369)
                (#x8FCBC5 . #x736B)
                (#x8FCBC6 . #x736C)
                (#x8FCBC7 . #x736E)
                (#x8FCBC8 . #x736F)
                (#x8FCBC9 . #x7371)
                (#x8FCBCA . #x7377)
                (#x8FCBCB . #x7379)
                (#x8FCBCC . #x737C)
                (#x8FCBCD . #x7380)
                (#x8FCBCE . #x7381)
                (#x8FCBCF . #x7383)
                (#x8FCBD0 . #x7385)
                (#x8FCBD1 . #x7386)
                (#x8FCBD2 . #x738E)
                (#x8FCBD3 . #x7390)
                (#x8FCBD4 . #x7393)
                (#x8FCBD5 . #x7395)
                (#x8FCBD6 . #x7397)
                (#x8FCBD7 . #x7398)
                (#x8FCBD8 . #x739C)
                (#x8FCBD9 . #x739E)
                (#x8FCBDA . #x739F)
                (#x8FCBDB . #x73A0)
                (#x8FCBDC . #x73A2)
                (#x8FCBDD . #x73A5)
                (#x8FCBDE . #x73A6)
                (#x8FCBDF . #x73AA)
                (#x8FCBE0 . #x73AB)
                (#x8FCBE1 . #x73AD)
                (#x8FCBE2 . #x73B5)
                (#x8FCBE3 . #x73B7)
                (#x8FCBE4 . #x73B9)
                (#x8FCBE5 . #x73BC)
                (#x8FCBE6 . #x73BD)
                (#x8FCBE7 . #x73BF)
                (#x8FCBE8 . #x73C5)
                (#x8FCBE9 . #x73C6)
                (#x8FCBEA . #x73C9)
                (#x8FCBEB . #x73CB)
                (#x8FCBEC . #x73CC)
                (#x8FCBED . #x73CF)
                (#x8FCBEE . #x73D2)
                (#x8FCBEF . #x73D3)
                (#x8FCBF0 . #x73D6)
                (#x8FCBF1 . #x73D9)
                (#x8FCBF2 . #x73DD)
                (#x8FCBF3 . #x73E1)
                (#x8FCBF4 . #x73E3)
                (#x8FCBF5 . #x73E6)
                (#x8FCBF6 . #x73E7)
                (#x8FCBF7 . #x73E9)
                (#x8FCBF8 . #x73F4)
                (#x8FCBF9 . #x73F5)
                (#x8FCBFA . #x73F7)
                (#x8FCBFB . #x73F9)
                (#x8FCBFC . #x73FA)
                (#x8FCBFD . #x73FB)
                (#x8FCBFE . #x73FD)
                (#x8FCCA1 . #x73FF)
                (#x8FCCA2 . #x7400)
                (#x8FCCA3 . #x7401)
                (#x8FCCA4 . #x7404)
                (#x8FCCA5 . #x7407)
                (#x8FCCA6 . #x740A)
                (#x8FCCA7 . #x7411)
                (#x8FCCA8 . #x741A)
                (#x8FCCA9 . #x741B)
                (#x8FCCAA . #x7424)
                (#x8FCCAB . #x7426)
                (#x8FCCAC . #x7428)
                (#x8FCCAD . #x7429)
                (#x8FCCAE . #x742A)
                (#x8FCCAF . #x742B)
                (#x8FCCB0 . #x742C)
                (#x8FCCB1 . #x742D)
                (#x8FCCB2 . #x742E)
                (#x8FCCB3 . #x742F)
                (#x8FCCB4 . #x7430)
                (#x8FCCB5 . #x7431)
                (#x8FCCB6 . #x7439)
                (#x8FCCB7 . #x7440)
                (#x8FCCB8 . #x7443)
                (#x8FCCB9 . #x7444)
                (#x8FCCBA . #x7446)
                (#x8FCCBB . #x7447)
                (#x8FCCBC . #x744B)
                (#x8FCCBD . #x744D)
                (#x8FCCBE . #x7451)
                (#x8FCCBF . #x7452)
                (#x8FCCC0 . #x7457)
                (#x8FCCC1 . #x745D)
                (#x8FCCC2 . #x7462)
                (#x8FCCC3 . #x7466)
                (#x8FCCC4 . #x7467)
                (#x8FCCC5 . #x7468)
                (#x8FCCC6 . #x746B)
                (#x8FCCC7 . #x746D)
                (#x8FCCC8 . #x746E)
                (#x8FCCC9 . #x7471)
                (#x8FCCCA . #x7472)
                (#x8FCCCB . #x7480)
                (#x8FCCCC . #x7481)
                (#x8FCCCD . #x7485)
                (#x8FCCCE . #x7486)
                (#x8FCCCF . #x7487)
                (#x8FCCD0 . #x7489)
                (#x8FCCD1 . #x748F)
                (#x8FCCD2 . #x7490)
                (#x8FCCD3 . #x7491)
                (#x8FCCD4 . #x7492)
                (#x8FCCD5 . #x7498)
                (#x8FCCD6 . #x7499)
                (#x8FCCD7 . #x749A)
                (#x8FCCD8 . #x749C)
                (#x8FCCD9 . #x749F)
                (#x8FCCDA . #x74A0)
                (#x8FCCDB . #x74A1)
                (#x8FCCDC . #x74A3)
                (#x8FCCDD . #x74A6)
                (#x8FCCDE . #x74A8)
                (#x8FCCDF . #x74A9)
                (#x8FCCE0 . #x74AA)
                (#x8FCCE1 . #x74AB)
                (#x8FCCE2 . #x74AE)
                (#x8FCCE3 . #x74AF)
                (#x8FCCE4 . #x74B1)
                (#x8FCCE5 . #x74B2)
                (#x8FCCE6 . #x74B5)
                (#x8FCCE7 . #x74B9)
                (#x8FCCE8 . #x74BB)
                (#x8FCCE9 . #x74BF)
                (#x8FCCEA . #x74C8)
                (#x8FCCEB . #x74C9)
                (#x8FCCEC . #x74CC)
                (#x8FCCED . #x74D0)
                (#x8FCCEE . #x74D3)
                (#x8FCCEF . #x74D8)
                (#x8FCCF0 . #x74DA)
                (#x8FCCF1 . #x74DB)
                (#x8FCCF2 . #x74DE)
                (#x8FCCF3 . #x74DF)
                (#x8FCCF4 . #x74E4)
                (#x8FCCF5 . #x74E8)
                (#x8FCCF6 . #x74EA)
                (#x8FCCF7 . #x74EB)
                (#x8FCCF8 . #x74EF)
                (#x8FCCF9 . #x74F4)
                (#x8FCCFA . #x74FA)
                (#x8FCCFB . #x74FB)
                (#x8FCCFC . #x74FC)
                (#x8FCCFD . #x74FF)
                (#x8FCCFE . #x7506)
                (#x8FCDA1 . #x7512)
                (#x8FCDA2 . #x7516)
                (#x8FCDA3 . #x7517)
                (#x8FCDA4 . #x7520)
                (#x8FCDA5 . #x7521)
                (#x8FCDA6 . #x7524)
                (#x8FCDA7 . #x7527)
                (#x8FCDA8 . #x7529)
                (#x8FCDA9 . #x752A)
                (#x8FCDAA . #x752F)
                (#x8FCDAB . #x7536)
                (#x8FCDAC . #x7539)
                (#x8FCDAD . #x753D)
                (#x8FCDAE . #x753E)
                (#x8FCDAF . #x753F)
                (#x8FCDB0 . #x7540)
                (#x8FCDB1 . #x7543)
                (#x8FCDB2 . #x7547)
                (#x8FCDB3 . #x7548)
                (#x8FCDB4 . #x754E)
                (#x8FCDB5 . #x7550)
                (#x8FCDB6 . #x7552)
                (#x8FCDB7 . #x7557)
                (#x8FCDB8 . #x755E)
                (#x8FCDB9 . #x755F)
                (#x8FCDBA . #x7561)
                (#x8FCDBB . #x756F)
                (#x8FCDBC . #x7571)
                (#x8FCDBD . #x7579)
                (#x8FCDBE . #x757A)
                (#x8FCDBF . #x757B)
                (#x8FCDC0 . #x757C)
                (#x8FCDC1 . #x757D)
                (#x8FCDC2 . #x757E)
                (#x8FCDC3 . #x7581)
                (#x8FCDC4 . #x7585)
                (#x8FCDC5 . #x7590)
                (#x8FCDC6 . #x7592)
                (#x8FCDC7 . #x7593)
                (#x8FCDC8 . #x7595)
                (#x8FCDC9 . #x7599)
                (#x8FCDCA . #x759C)
                (#x8FCDCB . #x75A2)
                (#x8FCDCC . #x75A4)
                (#x8FCDCD . #x75B4)
                (#x8FCDCE . #x75BA)
                (#x8FCDCF . #x75BF)
                (#x8FCDD0 . #x75C0)
                (#x8FCDD1 . #x75C1)
                (#x8FCDD2 . #x75C4)
                (#x8FCDD3 . #x75C6)
                (#x8FCDD4 . #x75CC)
                (#x8FCDD5 . #x75CE)
                (#x8FCDD6 . #x75CF)
                (#x8FCDD7 . #x75D7)
                (#x8FCDD8 . #x75DC)
                (#x8FCDD9 . #x75DF)
                (#x8FCDDA . #x75E0)
                (#x8FCDDB . #x75E1)
                (#x8FCDDC . #x75E4)
                (#x8FCDDD . #x75E7)
                (#x8FCDDE . #x75EC)
                (#x8FCDDF . #x75EE)
                (#x8FCDE0 . #x75EF)
                (#x8FCDE1 . #x75F1)
                (#x8FCDE2 . #x75F9)
                (#x8FCDE3 . #x7600)
                (#x8FCDE4 . #x7602)
                (#x8FCDE5 . #x7603)
                (#x8FCDE6 . #x7604)
                (#x8FCDE7 . #x7607)
                (#x8FCDE8 . #x7608)
                (#x8FCDE9 . #x760A)
                (#x8FCDEA . #x760C)
                (#x8FCDEB . #x760F)
                (#x8FCDEC . #x7612)
                (#x8FCDED . #x7613)
                (#x8FCDEE . #x7615)
                (#x8FCDEF . #x7616)
                (#x8FCDF0 . #x7619)
                (#x8FCDF1 . #x761B)
                (#x8FCDF2 . #x761C)
                (#x8FCDF3 . #x761D)
                (#x8FCDF4 . #x761E)
                (#x8FCDF5 . #x7623)
                (#x8FCDF6 . #x7625)
                (#x8FCDF7 . #x7626)
                (#x8FCDF8 . #x7629)
                (#x8FCDF9 . #x762D)
                (#x8FCDFA . #x7632)
                (#x8FCDFB . #x7633)
                (#x8FCDFC . #x7635)
                (#x8FCDFD . #x7638)
                (#x8FCDFE . #x7639)
                (#x8FCEA1 . #x763A)
                (#x8FCEA2 . #x763C)
                (#x8FCEA3 . #x764A)
                (#x8FCEA4 . #x7640)
                (#x8FCEA5 . #x7641)
                (#x8FCEA6 . #x7643)
                (#x8FCEA7 . #x7644)
                (#x8FCEA8 . #x7645)
                (#x8FCEA9 . #x7649)
                (#x8FCEAA . #x764B)
                (#x8FCEAB . #x7655)
                (#x8FCEAC . #x7659)
                (#x8FCEAD . #x765F)
                (#x8FCEAE . #x7664)
                (#x8FCEAF . #x7665)
                (#x8FCEB0 . #x766D)
                (#x8FCEB1 . #x766E)
                (#x8FCEB2 . #x766F)
                (#x8FCEB3 . #x7671)
                (#x8FCEB4 . #x7674)
                (#x8FCEB5 . #x7681)
                (#x8FCEB6 . #x7685)
                (#x8FCEB7 . #x768C)
                (#x8FCEB8 . #x768D)
                (#x8FCEB9 . #x7695)
                (#x8FCEBA . #x769B)
                (#x8FCEBB . #x769C)
                (#x8FCEBC . #x769D)
                (#x8FCEBD . #x769F)
                (#x8FCEBE . #x76A0)
                (#x8FCEBF . #x76A2)
                (#x8FCEC0 . #x76A3)
                (#x8FCEC1 . #x76A4)
                (#x8FCEC2 . #x76A5)
                (#x8FCEC3 . #x76A6)
                (#x8FCEC4 . #x76A7)
                (#x8FCEC5 . #x76A8)
                (#x8FCEC6 . #x76AA)
                (#x8FCEC7 . #x76AD)
                (#x8FCEC8 . #x76BD)
                (#x8FCEC9 . #x76C1)
                (#x8FCECA . #x76C5)
                (#x8FCECB . #x76C9)
                (#x8FCECC . #x76CB)
                (#x8FCECD . #x76CC)
                (#x8FCECE . #x76CE)
                (#x8FCECF . #x76D4)
                (#x8FCED0 . #x76D9)
                (#x8FCED1 . #x76E0)
                (#x8FCED2 . #x76E6)
                (#x8FCED3 . #x76E8)
                (#x8FCED4 . #x76EC)
                (#x8FCED5 . #x76F0)
                (#x8FCED6 . #x76F1)
                (#x8FCED7 . #x76F6)
                (#x8FCED8 . #x76F9)
                (#x8FCED9 . #x76FC)
                (#x8FCEDA . #x7700)
                (#x8FCEDB . #x7706)
                (#x8FCEDC . #x770A)
                (#x8FCEDD . #x770E)
                (#x8FCEDE . #x7712)
                (#x8FCEDF . #x7714)
                (#x8FCEE0 . #x7715)
                (#x8FCEE1 . #x7717)
                (#x8FCEE2 . #x7719)
                (#x8FCEE3 . #x771A)
                (#x8FCEE4 . #x771C)
                (#x8FCEE5 . #x7722)
                (#x8FCEE6 . #x7728)
                (#x8FCEE7 . #x772D)
                (#x8FCEE8 . #x772E)
                (#x8FCEE9 . #x772F)
                (#x8FCEEA . #x7734)
                (#x8FCEEB . #x7735)
                (#x8FCEEC . #x7736)
                (#x8FCEED . #x7739)
                (#x8FCEEE . #x773D)
                (#x8FCEEF . #x773E)
                (#x8FCEF0 . #x7742)
                (#x8FCEF1 . #x7745)
                (#x8FCEF2 . #x7746)
                (#x8FCEF3 . #x774A)
                (#x8FCEF4 . #x774D)
                (#x8FCEF5 . #x774E)
                (#x8FCEF6 . #x774F)
                (#x8FCEF7 . #x7752)
                (#x8FCEF8 . #x7756)
                (#x8FCEF9 . #x7757)
                (#x8FCEFA . #x775C)
                (#x8FCEFB . #x775E)
                (#x8FCEFC . #x775F)
                (#x8FCEFD . #x7760)
                (#x8FCEFE . #x7762)
                (#x8FCFA1 . #x7764)
                (#x8FCFA2 . #x7767)
                (#x8FCFA3 . #x776A)
                (#x8FCFA4 . #x776C)
                (#x8FCFA5 . #x7770)
                (#x8FCFA6 . #x7772)
                (#x8FCFA7 . #x7773)
                (#x8FCFA8 . #x7774)
                (#x8FCFA9 . #x777A)
                (#x8FCFAA . #x777D)
                (#x8FCFAB . #x7780)
                (#x8FCFAC . #x7784)
                (#x8FCFAD . #x778C)
                (#x8FCFAE . #x778D)
                (#x8FCFAF . #x7794)
                (#x8FCFB0 . #x7795)
                (#x8FCFB1 . #x7796)
                (#x8FCFB2 . #x779A)
                (#x8FCFB3 . #x779F)
                (#x8FCFB4 . #x77A2)
                (#x8FCFB5 . #x77A7)
                (#x8FCFB6 . #x77AA)
                (#x8FCFB7 . #x77AE)
                (#x8FCFB8 . #x77AF)
                (#x8FCFB9 . #x77B1)
                (#x8FCFBA . #x77B5)
                (#x8FCFBB . #x77BE)
                (#x8FCFBC . #x77C3)
                (#x8FCFBD . #x77C9)
                (#x8FCFBE . #x77D1)
                (#x8FCFBF . #x77D2)
                (#x8FCFC0 . #x77D5)
                (#x8FCFC1 . #x77D9)
                (#x8FCFC2 . #x77DE)
                (#x8FCFC3 . #x77DF)
                (#x8FCFC4 . #x77E0)
                (#x8FCFC5 . #x77E4)
                (#x8FCFC6 . #x77E6)
                (#x8FCFC7 . #x77EA)
                (#x8FCFC8 . #x77EC)
                (#x8FCFC9 . #x77F0)
                (#x8FCFCA . #x77F1)
                (#x8FCFCB . #x77F4)
                (#x8FCFCC . #x77F8)
                (#x8FCFCD . #x77FB)
                (#x8FCFCE . #x7805)
                (#x8FCFCF . #x7806)
                (#x8FCFD0 . #x7809)
                (#x8FCFD1 . #x780D)
                (#x8FCFD2 . #x780E)
                (#x8FCFD3 . #x7811)
                (#x8FCFD4 . #x781D)
                (#x8FCFD5 . #x7821)
                (#x8FCFD6 . #x7822)
                (#x8FCFD7 . #x7823)
                (#x8FCFD8 . #x782D)
                (#x8FCFD9 . #x782E)
                (#x8FCFDA . #x7830)
                (#x8FCFDB . #x7835)
                (#x8FCFDC . #x7837)
                (#x8FCFDD . #x7843)
                (#x8FCFDE . #x7844)
                (#x8FCFDF . #x7847)
                (#x8FCFE0 . #x7848)
                (#x8FCFE1 . #x784C)
                (#x8FCFE2 . #x784E)
                (#x8FCFE3 . #x7852)
                (#x8FCFE4 . #x785C)
                (#x8FCFE5 . #x785E)
                (#x8FCFE6 . #x7860)
                (#x8FCFE7 . #x7861)
                (#x8FCFE8 . #x7863)
                (#x8FCFE9 . #x7864)
                (#x8FCFEA . #x7868)
                (#x8FCFEB . #x786A)
                (#x8FCFEC . #x786E)
                (#x8FCFED . #x787A)
                (#x8FCFEE . #x787E)
                (#x8FCFEF . #x788A)
                (#x8FCFF0 . #x788F)
                (#x8FCFF1 . #x7894)
                (#x8FCFF2 . #x7898)
                (#x8FCFF3 . #x78A1)
                (#x8FCFF4 . #x789D)
                (#x8FCFF5 . #x789E)
                (#x8FCFF6 . #x789F)
                (#x8FCFF7 . #x78A4)
                (#x8FCFF8 . #x78A8)
                (#x8FCFF9 . #x78AC)
                (#x8FCFFA . #x78AD)
                (#x8FCFFB . #x78B0)
                (#x8FCFFC . #x78B1)
                (#x8FCFFD . #x78B2)
                (#x8FCFFE . #x78B3)
                (#x8FD0A1 . #x78BB)
                (#x8FD0A2 . #x78BD)
                (#x8FD0A3 . #x78BF)
                (#x8FD0A4 . #x78C7)
                (#x8FD0A5 . #x78C8)
                (#x8FD0A6 . #x78C9)
                (#x8FD0A7 . #x78CC)
                (#x8FD0A8 . #x78CE)
                (#x8FD0A9 . #x78D2)
                (#x8FD0AA . #x78D3)
                (#x8FD0AB . #x78D5)
                (#x8FD0AC . #x78D6)
                (#x8FD0AD . #x78E4)
                (#x8FD0AE . #x78DB)
                (#x8FD0AF . #x78DF)
                (#x8FD0B0 . #x78E0)
                (#x8FD0B1 . #x78E1)
                (#x8FD0B2 . #x78E6)
                (#x8FD0B3 . #x78EA)
                (#x8FD0B4 . #x78F2)
                (#x8FD0B5 . #x78F3)
                (#x8FD0B6 . #x7900)
                (#x8FD0B7 . #x78F6)
                (#x8FD0B8 . #x78F7)
                (#x8FD0B9 . #x78FA)
                (#x8FD0BA . #x78FB)
                (#x8FD0BB . #x78FF)
                (#x8FD0BC . #x7906)
                (#x8FD0BD . #x790C)
                (#x8FD0BE . #x7910)
                (#x8FD0BF . #x791A)
                (#x8FD0C0 . #x791C)
                (#x8FD0C1 . #x791E)
                (#x8FD0C2 . #x791F)
                (#x8FD0C3 . #x7920)
                (#x8FD0C4 . #x7925)
                (#x8FD0C5 . #x7927)
                (#x8FD0C6 . #x7929)
                (#x8FD0C7 . #x792D)
                (#x8FD0C8 . #x7931)
                (#x8FD0C9 . #x7934)
                (#x8FD0CA . #x7935)
                (#x8FD0CB . #x793B)
                (#x8FD0CC . #x793D)
                (#x8FD0CD . #x793F)
                (#x8FD0CE . #x7944)
                (#x8FD0CF . #x7945)
                (#x8FD0D0 . #x7946)
                (#x8FD0D1 . #x794A)
                (#x8FD0D2 . #x794B)
                (#x8FD0D3 . #x794F)
                (#x8FD0D4 . #x7951)
                (#x8FD0D5 . #x7954)
                (#x8FD0D6 . #x7958)
                (#x8FD0D7 . #x795B)
                (#x8FD0D8 . #x795C)
                (#x8FD0D9 . #x7967)
                (#x8FD0DA . #x7969)
                (#x8FD0DB . #x796B)
                (#x8FD0DC . #x7972)
                (#x8FD0DD . #x7979)
                (#x8FD0DE . #x797B)
                (#x8FD0DF . #x797C)
                (#x8FD0E0 . #x797E)
                (#x8FD0E1 . #x798B)
                (#x8FD0E2 . #x798C)
                (#x8FD0E3 . #x7991)
                (#x8FD0E4 . #x7993)
                (#x8FD0E5 . #x7994)
                (#x8FD0E6 . #x7995)
                (#x8FD0E7 . #x7996)
                (#x8FD0E8 . #x7998)
                (#x8FD0E9 . #x799B)
                (#x8FD0EA . #x799C)
                (#x8FD0EB . #x79A1)
                (#x8FD0EC . #x79A8)
                (#x8FD0ED . #x79A9)
                (#x8FD0EE . #x79AB)
                (#x8FD0EF . #x79AF)
                (#x8FD0F0 . #x79B1)
                (#x8FD0F1 . #x79B4)
                (#x8FD0F2 . #x79B8)
                (#x8FD0F3 . #x79BB)
                (#x8FD0F4 . #x79C2)
                (#x8FD0F5 . #x79C4)
                (#x8FD0F6 . #x79C7)
                (#x8FD0F7 . #x79C8)
                (#x8FD0F8 . #x79CA)
                (#x8FD0F9 . #x79CF)
                (#x8FD0FA . #x79D4)
                (#x8FD0FB . #x79D6)
                (#x8FD0FC . #x79DA)
                (#x8FD0FD . #x79DD)
                (#x8FD0FE . #x79DE)
                (#x8FD1A1 . #x79E0)
                (#x8FD1A2 . #x79E2)
                (#x8FD1A3 . #x79E5)
                (#x8FD1A4 . #x79EA)
                (#x8FD1A5 . #x79EB)
                (#x8FD1A6 . #x79ED)
                (#x8FD1A7 . #x79F1)
                (#x8FD1A8 . #x79F8)
                (#x8FD1A9 . #x79FC)
                (#x8FD1AA . #x7A02)
                (#x8FD1AB . #x7A03)
                (#x8FD1AC . #x7A07)
                (#x8FD1AD . #x7A09)
                (#x8FD1AE . #x7A0A)
                (#x8FD1AF . #x7A0C)
                (#x8FD1B0 . #x7A11)
                (#x8FD1B1 . #x7A15)
                (#x8FD1B2 . #x7A1B)
                (#x8FD1B3 . #x7A1E)
                (#x8FD1B4 . #x7A21)
                (#x8FD1B5 . #x7A27)
                (#x8FD1B6 . #x7A2B)
                (#x8FD1B7 . #x7A2D)
                (#x8FD1B8 . #x7A2F)
                (#x8FD1B9 . #x7A30)
                (#x8FD1BA . #x7A34)
                (#x8FD1BB . #x7A35)
                (#x8FD1BC . #x7A38)
                (#x8FD1BD . #x7A39)
                (#x8FD1BE . #x7A3A)
                (#x8FD1BF . #x7A44)
                (#x8FD1C0 . #x7A45)
                (#x8FD1C1 . #x7A47)
                (#x8FD1C2 . #x7A48)
                (#x8FD1C3 . #x7A4C)
                (#x8FD1C4 . #x7A55)
                (#x8FD1C5 . #x7A56)
                (#x8FD1C6 . #x7A59)
                (#x8FD1C7 . #x7A5C)
                (#x8FD1C8 . #x7A5D)
                (#x8FD1C9 . #x7A5F)
                (#x8FD1CA . #x7A60)
                (#x8FD1CB . #x7A65)
                (#x8FD1CC . #x7A67)
                (#x8FD1CD . #x7A6A)
                (#x8FD1CE . #x7A6D)
                (#x8FD1CF . #x7A75)
                (#x8FD1D0 . #x7A78)
                (#x8FD1D1 . #x7A7E)
                (#x8FD1D2 . #x7A80)
                (#x8FD1D3 . #x7A82)
                (#x8FD1D4 . #x7A85)
                (#x8FD1D5 . #x7A86)
                (#x8FD1D6 . #x7A8A)
                (#x8FD1D7 . #x7A8B)
                (#x8FD1D8 . #x7A90)
                (#x8FD1D9 . #x7A91)
                (#x8FD1DA . #x7A94)
                (#x8FD1DB . #x7A9E)
                (#x8FD1DC . #x7AA0)
                (#x8FD1DD . #x7AA3)
                (#x8FD1DE . #x7AAC)
                (#x8FD1DF . #x7AB3)
                (#x8FD1E0 . #x7AB5)
                (#x8FD1E1 . #x7AB9)
                (#x8FD1E2 . #x7ABB)
                (#x8FD1E3 . #x7ABC)
                (#x8FD1E4 . #x7AC6)
                (#x8FD1E5 . #x7AC9)
                (#x8FD1E6 . #x7ACC)
                (#x8FD1E7 . #x7ACE)
                (#x8FD1E8 . #x7AD1)
                (#x8FD1E9 . #x7ADB)
                (#x8FD1EA . #x7AE8)
                (#x8FD1EB . #x7AE9)
                (#x8FD1EC . #x7AEB)
                (#x8FD1ED . #x7AEC)
                (#x8FD1EE . #x7AF1)
                (#x8FD1EF . #x7AF4)
                (#x8FD1F0 . #x7AFB)
                (#x8FD1F1 . #x7AFD)
                (#x8FD1F2 . #x7AFE)
                (#x8FD1F3 . #x7B07)
                (#x8FD1F4 . #x7B14)
                (#x8FD1F5 . #x7B1F)
                (#x8FD1F6 . #x7B23)
                (#x8FD1F7 . #x7B27)
                (#x8FD1F8 . #x7B29)
                (#x8FD1F9 . #x7B2A)
                (#x8FD1FA . #x7B2B)
                (#x8FD1FB . #x7B2D)
                (#x8FD1FC . #x7B2E)
                (#x8FD1FD . #x7B2F)
                (#x8FD1FE . #x7B30)
                (#x8FD2A1 . #x7B31)
                (#x8FD2A2 . #x7B34)
                (#x8FD2A3 . #x7B3D)
                (#x8FD2A4 . #x7B3F)
                (#x8FD2A5 . #x7B40)
                (#x8FD2A6 . #x7B41)
                (#x8FD2A7 . #x7B47)
                (#x8FD2A8 . #x7B4E)
                (#x8FD2A9 . #x7B55)
                (#x8FD2AA . #x7B60)
                (#x8FD2AB . #x7B64)
                (#x8FD2AC . #x7B66)
                (#x8FD2AD . #x7B69)
                (#x8FD2AE . #x7B6A)
                (#x8FD2AF . #x7B6D)
                (#x8FD2B0 . #x7B6F)
                (#x8FD2B1 . #x7B72)
                (#x8FD2B2 . #x7B73)
                (#x8FD2B3 . #x7B77)
                (#x8FD2B4 . #x7B84)
                (#x8FD2B5 . #x7B89)
                (#x8FD2B6 . #x7B8E)
                (#x8FD2B7 . #x7B90)
                (#x8FD2B8 . #x7B91)
                (#x8FD2B9 . #x7B96)
                (#x8FD2BA . #x7B9B)
                (#x8FD2BB . #x7B9E)
                (#x8FD2BC . #x7BA0)
                (#x8FD2BD . #x7BA5)
                (#x8FD2BE . #x7BAC)
                (#x8FD2BF . #x7BAF)
                (#x8FD2C0 . #x7BB0)
                (#x8FD2C1 . #x7BB2)
                (#x8FD2C2 . #x7BB5)
                (#x8FD2C3 . #x7BB6)
                (#x8FD2C4 . #x7BBA)
                (#x8FD2C5 . #x7BBB)
                (#x8FD2C6 . #x7BBC)
                (#x8FD2C7 . #x7BBD)
                (#x8FD2C8 . #x7BC2)
                (#x8FD2C9 . #x7BC5)
                (#x8FD2CA . #x7BC8)
                (#x8FD2CB . #x7BCA)
                (#x8FD2CC . #x7BD4)
                (#x8FD2CD . #x7BD6)
                (#x8FD2CE . #x7BD7)
                (#x8FD2CF . #x7BD9)
                (#x8FD2D0 . #x7BDA)
                (#x8FD2D1 . #x7BDB)
                (#x8FD2D2 . #x7BE8)
                (#x8FD2D3 . #x7BEA)
                (#x8FD2D4 . #x7BF2)
                (#x8FD2D5 . #x7BF4)
                (#x8FD2D6 . #x7BF5)
                (#x8FD2D7 . #x7BF8)
                (#x8FD2D8 . #x7BF9)
                (#x8FD2D9 . #x7BFA)
                (#x8FD2DA . #x7BFC)
                (#x8FD2DB . #x7BFE)
                (#x8FD2DC . #x7C01)
                (#x8FD2DD . #x7C02)
                (#x8FD2DE . #x7C03)
                (#x8FD2DF . #x7C04)
                (#x8FD2E0 . #x7C06)
                (#x8FD2E1 . #x7C09)
                (#x8FD2E2 . #x7C0B)
                (#x8FD2E3 . #x7C0C)
                (#x8FD2E4 . #x7C0E)
                (#x8FD2E5 . #x7C0F)
                (#x8FD2E6 . #x7C19)
                (#x8FD2E7 . #x7C1B)
                (#x8FD2E8 . #x7C20)
                (#x8FD2E9 . #x7C25)
                (#x8FD2EA . #x7C26)
                (#x8FD2EB . #x7C28)
                (#x8FD2EC . #x7C2C)
                (#x8FD2ED . #x7C31)
                (#x8FD2EE . #x7C33)
                (#x8FD2EF . #x7C34)
                (#x8FD2F0 . #x7C36)
                (#x8FD2F1 . #x7C39)
                (#x8FD2F2 . #x7C3A)
                (#x8FD2F3 . #x7C46)
                (#x8FD2F4 . #x7C4A)
                (#x8FD2F5 . #x7C55)
                (#x8FD2F6 . #x7C51)
                (#x8FD2F7 . #x7C52)
                (#x8FD2F8 . #x7C53)
                (#x8FD2F9 . #x7C59)
                (#x8FD2FA . #x7C5A)
                (#x8FD2FB . #x7C5B)
                (#x8FD2FC . #x7C5C)
                (#x8FD2FD . #x7C5D)
                (#x8FD2FE . #x7C5E)
                (#x8FD3A1 . #x7C61)
                (#x8FD3A2 . #x7C63)
                (#x8FD3A3 . #x7C67)
                (#x8FD3A4 . #x7C69)
                (#x8FD3A5 . #x7C6D)
                (#x8FD3A6 . #x7C6E)
                (#x8FD3A7 . #x7C70)
                (#x8FD3A8 . #x7C72)
                (#x8FD3A9 . #x7C79)
                (#x8FD3AA . #x7C7C)
                (#x8FD3AB . #x7C7D)
                (#x8FD3AC . #x7C86)
                (#x8FD3AD . #x7C87)
                (#x8FD3AE . #x7C8F)
                (#x8FD3AF . #x7C94)
                (#x8FD3B0 . #x7C9E)
                (#x8FD3B1 . #x7CA0)
                (#x8FD3B2 . #x7CA6)
                (#x8FD3B3 . #x7CB0)
                (#x8FD3B4 . #x7CB6)
                (#x8FD3B5 . #x7CB7)
                (#x8FD3B6 . #x7CBA)
                (#x8FD3B7 . #x7CBB)
                (#x8FD3B8 . #x7CBC)
                (#x8FD3B9 . #x7CBF)
                (#x8FD3BA . #x7CC4)
                (#x8FD3BB . #x7CC7)
                (#x8FD3BC . #x7CC8)
                (#x8FD3BD . #x7CC9)
                (#x8FD3BE . #x7CCD)
                (#x8FD3BF . #x7CCF)
                (#x8FD3C0 . #x7CD3)
                (#x8FD3C1 . #x7CD4)
                (#x8FD3C2 . #x7CD5)
                (#x8FD3C3 . #x7CD7)
                (#x8FD3C4 . #x7CD9)
                (#x8FD3C5 . #x7CDA)
                (#x8FD3C6 . #x7CDD)
                (#x8FD3C7 . #x7CE6)
                (#x8FD3C8 . #x7CE9)
                (#x8FD3C9 . #x7CEB)
                (#x8FD3CA . #x7CF5)
                (#x8FD3CB . #x7D03)
                (#x8FD3CC . #x7D07)
                (#x8FD3CD . #x7D08)
                (#x8FD3CE . #x7D09)
                (#x8FD3CF . #x7D0F)
                (#x8FD3D0 . #x7D11)
                (#x8FD3D1 . #x7D12)
                (#x8FD3D2 . #x7D13)
                (#x8FD3D3 . #x7D16)
                (#x8FD3D4 . #x7D1D)
                (#x8FD3D5 . #x7D1E)
                (#x8FD3D6 . #x7D23)
                (#x8FD3D7 . #x7D26)
                (#x8FD3D8 . #x7D2A)
                (#x8FD3D9 . #x7D2D)
                (#x8FD3DA . #x7D31)
                (#x8FD3DB . #x7D3C)
                (#x8FD3DC . #x7D3D)
                (#x8FD3DD . #x7D3E)
                (#x8FD3DE . #x7D40)
                (#x8FD3DF . #x7D41)
                (#x8FD3E0 . #x7D47)
                (#x8FD3E1 . #x7D48)
                (#x8FD3E2 . #x7D4D)
                (#x8FD3E3 . #x7D51)
                (#x8FD3E4 . #x7D53)
                (#x8FD3E5 . #x7D57)
                (#x8FD3E6 . #x7D59)
                (#x8FD3E7 . #x7D5A)
                (#x8FD3E8 . #x7D5C)
                (#x8FD3E9 . #x7D5D)
                (#x8FD3EA . #x7D65)
                (#x8FD3EB . #x7D67)
                (#x8FD3EC . #x7D6A)
                (#x8FD3ED . #x7D70)
                (#x8FD3EE . #x7D78)
                (#x8FD3EF . #x7D7A)
                (#x8FD3F0 . #x7D7B)
                (#x8FD3F1 . #x7D7F)
                (#x8FD3F2 . #x7D81)
                (#x8FD3F3 . #x7D82)
                (#x8FD3F4 . #x7D83)
                (#x8FD3F5 . #x7D85)
                (#x8FD3F6 . #x7D86)
                (#x8FD3F7 . #x7D88)
                (#x8FD3F8 . #x7D8B)
                (#x8FD3F9 . #x7D8C)
                (#x8FD3FA . #x7D8D)
                (#x8FD3FB . #x7D91)
                (#x8FD3FC . #x7D96)
                (#x8FD3FD . #x7D97)
                (#x8FD3FE . #x7D9D)
                (#x8FD4A1 . #x7D9E)
                (#x8FD4A2 . #x7DA6)
                (#x8FD4A3 . #x7DA7)
                (#x8FD4A4 . #x7DAA)
                (#x8FD4A5 . #x7DB3)
                (#x8FD4A6 . #x7DB6)
                (#x8FD4A7 . #x7DB7)
                (#x8FD4A8 . #x7DB9)
                (#x8FD4A9 . #x7DC2)
                (#x8FD4AA . #x7DC3)
                (#x8FD4AB . #x7DC4)
                (#x8FD4AC . #x7DC5)
                (#x8FD4AD . #x7DC6)
                (#x8FD4AE . #x7DCC)
                (#x8FD4AF . #x7DCD)
                (#x8FD4B0 . #x7DCE)
                (#x8FD4B1 . #x7DD7)
                (#x8FD4B2 . #x7DD9)
                (#x8FD4B3 . #x7E00)
                (#x8FD4B4 . #x7DE2)
                (#x8FD4B5 . #x7DE5)
                (#x8FD4B6 . #x7DE6)
                (#x8FD4B7 . #x7DEA)
                (#x8FD4B8 . #x7DEB)
                (#x8FD4B9 . #x7DED)
                (#x8FD4BA . #x7DF1)
                (#x8FD4BB . #x7DF5)
                (#x8FD4BC . #x7DF6)
                (#x8FD4BD . #x7DF9)
                (#x8FD4BE . #x7DFA)
                (#x8FD4BF . #x7E08)
                (#x8FD4C0 . #x7E10)
                (#x8FD4C1 . #x7E11)
                (#x8FD4C2 . #x7E15)
                (#x8FD4C3 . #x7E17)
                (#x8FD4C4 . #x7E1C)
                (#x8FD4C5 . #x7E1D)
                (#x8FD4C6 . #x7E20)
                (#x8FD4C7 . #x7E27)
                (#x8FD4C8 . #x7E28)
                (#x8FD4C9 . #x7E2C)
                (#x8FD4CA . #x7E2D)
                (#x8FD4CB . #x7E2F)
                (#x8FD4CC . #x7E33)
                (#x8FD4CD . #x7E36)
                (#x8FD4CE . #x7E3F)
                (#x8FD4CF . #x7E44)
                (#x8FD4D0 . #x7E45)
                (#x8FD4D1 . #x7E47)
                (#x8FD4D2 . #x7E4E)
                (#x8FD4D3 . #x7E50)
                (#x8FD4D4 . #x7E52)
                (#x8FD4D5 . #x7E58)
                (#x8FD4D6 . #x7E5F)
                (#x8FD4D7 . #x7E61)
                (#x8FD4D8 . #x7E62)
                (#x8FD4D9 . #x7E65)
                (#x8FD4DA . #x7E6B)
                (#x8FD4DB . #x7E6E)
                (#x8FD4DC . #x7E6F)
                (#x8FD4DD . #x7E73)
                (#x8FD4DE . #x7E78)
                (#x8FD4DF . #x7E7E)
                (#x8FD4E0 . #x7E81)
                (#x8FD4E1 . #x7E86)
                (#x8FD4E2 . #x7E87)
                (#x8FD4E3 . #x7E8A)
                (#x8FD4E4 . #x7E8D)
                (#x8FD4E5 . #x7E91)
                (#x8FD4E6 . #x7E95)
                (#x8FD4E7 . #x7E98)
                (#x8FD4E8 . #x7E9A)
                (#x8FD4E9 . #x7E9D)
                (#x8FD4EA . #x7E9E)
                (#x8FD4EB . #x7F3C)
                (#x8FD4EC . #x7F3B)
                (#x8FD4ED . #x7F3D)
                (#x8FD4EE . #x7F3E)
                (#x8FD4EF . #x7F3F)
                (#x8FD4F0 . #x7F43)
                (#x8FD4F1 . #x7F44)
                (#x8FD4F2 . #x7F47)
                (#x8FD4F3 . #x7F4F)
                (#x8FD4F4 . #x7F52)
                (#x8FD4F5 . #x7F53)
                (#x8FD4F6 . #x7F5B)
                (#x8FD4F7 . #x7F5C)
                (#x8FD4F8 . #x7F5D)
                (#x8FD4F9 . #x7F61)
                (#x8FD4FA . #x7F63)
                (#x8FD4FB . #x7F64)
                (#x8FD4FC . #x7F65)
                (#x8FD4FD . #x7F66)
                (#x8FD4FE . #x7F6D)
                (#x8FD5A1 . #x7F71)
                (#x8FD5A2 . #x7F7D)
                (#x8FD5A3 . #x7F7E)
                (#x8FD5A4 . #x7F7F)
                (#x8FD5A5 . #x7F80)
                (#x8FD5A6 . #x7F8B)
                (#x8FD5A7 . #x7F8D)
                (#x8FD5A8 . #x7F8F)
                (#x8FD5A9 . #x7F90)
                (#x8FD5AA . #x7F91)
                (#x8FD5AB . #x7F96)
                (#x8FD5AC . #x7F97)
                (#x8FD5AD . #x7F9C)
                (#x8FD5AE . #x7FA1)
                (#x8FD5AF . #x7FA2)
                (#x8FD5B0 . #x7FA6)
                (#x8FD5B1 . #x7FAA)
                (#x8FD5B2 . #x7FAD)
                (#x8FD5B3 . #x7FB4)
                (#x8FD5B4 . #x7FBC)
                (#x8FD5B5 . #x7FBF)
                (#x8FD5B6 . #x7FC0)
                (#x8FD5B7 . #x7FC3)
                (#x8FD5B8 . #x7FC8)
                (#x8FD5B9 . #x7FCE)
                (#x8FD5BA . #x7FCF)
                (#x8FD5BB . #x7FDB)
                (#x8FD5BC . #x7FDF)
                (#x8FD5BD . #x7FE3)
                (#x8FD5BE . #x7FE5)
                (#x8FD5BF . #x7FE8)
                (#x8FD5C0 . #x7FEC)
                (#x8FD5C1 . #x7FEE)
                (#x8FD5C2 . #x7FEF)
                (#x8FD5C3 . #x7FF2)
                (#x8FD5C4 . #x7FFA)
                (#x8FD5C5 . #x7FFD)
                (#x8FD5C6 . #x7FFE)
                (#x8FD5C7 . #x7FFF)
                (#x8FD5C8 . #x8007)
                (#x8FD5C9 . #x8008)
                (#x8FD5CA . #x800A)
                (#x8FD5CB . #x800D)
                (#x8FD5CC . #x800E)
                (#x8FD5CD . #x800F)
                (#x8FD5CE . #x8011)
                (#x8FD5CF . #x8013)
                (#x8FD5D0 . #x8014)
                (#x8FD5D1 . #x8016)
                (#x8FD5D2 . #x801D)
                (#x8FD5D3 . #x801E)
                (#x8FD5D4 . #x801F)
                (#x8FD5D5 . #x8020)
                (#x8FD5D6 . #x8024)
                (#x8FD5D7 . #x8026)
                (#x8FD5D8 . #x802C)
                (#x8FD5D9 . #x802E)
                (#x8FD5DA . #x8030)
                (#x8FD5DB . #x8034)
                (#x8FD5DC . #x8035)
                (#x8FD5DD . #x8037)
                (#x8FD5DE . #x8039)
                (#x8FD5DF . #x803A)
                (#x8FD5E0 . #x803C)
                (#x8FD5E1 . #x803E)
                (#x8FD5E2 . #x8040)
                (#x8FD5E3 . #x8044)
                (#x8FD5E4 . #x8060)
                (#x8FD5E5 . #x8064)
                (#x8FD5E6 . #x8066)
                (#x8FD5E7 . #x806D)
                (#x8FD5E8 . #x8071)
                (#x8FD5E9 . #x8075)
                (#x8FD5EA . #x8081)
                (#x8FD5EB . #x8088)
                (#x8FD5EC . #x808E)
                (#x8FD5ED . #x809C)
                (#x8FD5EE . #x809E)
                (#x8FD5EF . #x80A6)
                (#x8FD5F0 . #x80A7)
                (#x8FD5F1 . #x80AB)
                (#x8FD5F2 . #x80B8)
                (#x8FD5F3 . #x80B9)
                (#x8FD5F4 . #x80C8)
                (#x8FD5F5 . #x80CD)
                (#x8FD5F6 . #x80CF)
                (#x8FD5F7 . #x80D2)
                (#x8FD5F8 . #x80D4)
                (#x8FD5F9 . #x80D5)
                (#x8FD5FA . #x80D7)
                (#x8FD5FB . #x80D8)
                (#x8FD5FC . #x80E0)
                (#x8FD5FD . #x80ED)
                (#x8FD5FE . #x80EE)
                (#x8FD6A1 . #x80F0)
                (#x8FD6A2 . #x80F2)
                (#x8FD6A3 . #x80F3)
                (#x8FD6A4 . #x80F6)
                (#x8FD6A5 . #x80F9)
                (#x8FD6A6 . #x80FA)
                (#x8FD6A7 . #x80FE)
                (#x8FD6A8 . #x8103)
                (#x8FD6A9 . #x810B)
                (#x8FD6AA . #x8116)
                (#x8FD6AB . #x8117)
                (#x8FD6AC . #x8118)
                (#x8FD6AD . #x811C)
                (#x8FD6AE . #x811E)
                (#x8FD6AF . #x8120)
                (#x8FD6B0 . #x8124)
                (#x8FD6B1 . #x8127)
                (#x8FD6B2 . #x812C)
                (#x8FD6B3 . #x8130)
                (#x8FD6B4 . #x8135)
                (#x8FD6B5 . #x813A)
                (#x8FD6B6 . #x813C)
                (#x8FD6B7 . #x8145)
                (#x8FD6B8 . #x8147)
                (#x8FD6B9 . #x814A)
                (#x8FD6BA . #x814C)
                (#x8FD6BB . #x8152)
                (#x8FD6BC . #x8157)
                (#x8FD6BD . #x8160)
                (#x8FD6BE . #x8161)
                (#x8FD6BF . #x8167)
                (#x8FD6C0 . #x8168)
                (#x8FD6C1 . #x8169)
                (#x8FD6C2 . #x816D)
                (#x8FD6C3 . #x816F)
                (#x8FD6C4 . #x8177)
                (#x8FD6C5 . #x8181)
                (#x8FD6C6 . #x8190)
                (#x8FD6C7 . #x8184)
                (#x8FD6C8 . #x8185)
                (#x8FD6C9 . #x8186)
                (#x8FD6CA . #x818B)
                (#x8FD6CB . #x818E)
                (#x8FD6CC . #x8196)
                (#x8FD6CD . #x8198)
                (#x8FD6CE . #x819B)
                (#x8FD6CF . #x819E)
                (#x8FD6D0 . #x81A2)
                (#x8FD6D1 . #x81AE)
                (#x8FD6D2 . #x81B2)
                (#x8FD6D3 . #x81B4)
                (#x8FD6D4 . #x81BB)
                (#x8FD6D5 . #x81CB)
                (#x8FD6D6 . #x81C3)
                (#x8FD6D7 . #x81C5)
                (#x8FD6D8 . #x81CA)
                (#x8FD6D9 . #x81CE)
                (#x8FD6DA . #x81CF)
                (#x8FD6DB . #x81D5)
                (#x8FD6DC . #x81D7)
                (#x8FD6DD . #x81DB)
                (#x8FD6DE . #x81DD)
                (#x8FD6DF . #x81DE)
                (#x8FD6E0 . #x81E1)
                (#x8FD6E1 . #x81E4)
                (#x8FD6E2 . #x81EB)
                (#x8FD6E3 . #x81EC)
                (#x8FD6E4 . #x81F0)
                (#x8FD6E5 . #x81F1)
                (#x8FD6E6 . #x81F2)
                (#x8FD6E7 . #x81F5)
                (#x8FD6E8 . #x81F6)
                (#x8FD6E9 . #x81F8)
                (#x8FD6EA . #x81F9)
                (#x8FD6EB . #x81FD)
                (#x8FD6EC . #x81FF)
                (#x8FD6ED . #x8200)
                (#x8FD6EE . #x8203)
                (#x8FD6EF . #x820F)
                (#x8FD6F0 . #x8213)
                (#x8FD6F1 . #x8214)
                (#x8FD6F2 . #x8219)
                (#x8FD6F3 . #x821A)
                (#x8FD6F4 . #x821D)
                (#x8FD6F5 . #x8221)
                (#x8FD6F6 . #x8222)
                (#x8FD6F7 . #x8228)
                (#x8FD6F8 . #x8232)
                (#x8FD6F9 . #x8234)
                (#x8FD6FA . #x823A)
                (#x8FD6FB . #x8243)
                (#x8FD6FC . #x8244)
                (#x8FD6FD . #x8245)
                (#x8FD6FE . #x8246)
                (#x8FD7A1 . #x824B)
                (#x8FD7A2 . #x824E)
                (#x8FD7A3 . #x824F)
                (#x8FD7A4 . #x8251)
                (#x8FD7A5 . #x8256)
                (#x8FD7A6 . #x825C)
                (#x8FD7A7 . #x8260)
                (#x8FD7A8 . #x8263)
                (#x8FD7A9 . #x8267)
                (#x8FD7AA . #x826D)
                (#x8FD7AB . #x8274)
                (#x8FD7AC . #x827B)
                (#x8FD7AD . #x827D)
                (#x8FD7AE . #x827F)
                (#x8FD7AF . #x8280)
                (#x8FD7B0 . #x8281)
                (#x8FD7B1 . #x8283)
                (#x8FD7B2 . #x8284)
                (#x8FD7B3 . #x8287)
                (#x8FD7B4 . #x8289)
                (#x8FD7B5 . #x828A)
                (#x8FD7B6 . #x828E)
                (#x8FD7B7 . #x8291)
                (#x8FD7B8 . #x8294)
                (#x8FD7B9 . #x8296)
                (#x8FD7BA . #x8298)
                (#x8FD7BB . #x829A)
                (#x8FD7BC . #x829B)
                (#x8FD7BD . #x82A0)
                (#x8FD7BE . #x82A1)
                (#x8FD7BF . #x82A3)
                (#x8FD7C0 . #x82A4)
                (#x8FD7C1 . #x82A7)
                (#x8FD7C2 . #x82A8)
                (#x8FD7C3 . #x82A9)
                (#x8FD7C4 . #x82AA)
                (#x8FD7C5 . #x82AE)
                (#x8FD7C6 . #x82B0)
                (#x8FD7C7 . #x82B2)
                (#x8FD7C8 . #x82B4)
                (#x8FD7C9 . #x82B7)
                (#x8FD7CA . #x82BA)
                (#x8FD7CB . #x82BC)
                (#x8FD7CC . #x82BE)
                (#x8FD7CD . #x82BF)
                (#x8FD7CE . #x82C6)
                (#x8FD7CF . #x82D0)
                (#x8FD7D0 . #x82D5)
                (#x8FD7D1 . #x82DA)
                (#x8FD7D2 . #x82E0)
                (#x8FD7D3 . #x82E2)
                (#x8FD7D4 . #x82E4)
                (#x8FD7D5 . #x82E8)
                (#x8FD7D6 . #x82EA)
                (#x8FD7D7 . #x82ED)
                (#x8FD7D8 . #x82EF)
                (#x8FD7D9 . #x82F6)
                (#x8FD7DA . #x82F7)
                (#x8FD7DB . #x82FD)
                (#x8FD7DC . #x82FE)
                (#x8FD7DD . #x8300)
                (#x8FD7DE . #x8301)
                (#x8FD7DF . #x8307)
                (#x8FD7E0 . #x8308)
                (#x8FD7E1 . #x830A)
                (#x8FD7E2 . #x830B)
                (#x8FD7E3 . #x8354)
                (#x8FD7E4 . #x831B)
                (#x8FD7E5 . #x831D)
                (#x8FD7E6 . #x831E)
                (#x8FD7E7 . #x831F)
                (#x8FD7E8 . #x8321)
                (#x8FD7E9 . #x8322)
                (#x8FD7EA . #x832C)
                (#x8FD7EB . #x832D)
                (#x8FD7EC . #x832E)
                (#x8FD7ED . #x8330)
                (#x8FD7EE . #x8333)
                (#x8FD7EF . #x8337)
                (#x8FD7F0 . #x833A)
                (#x8FD7F1 . #x833C)
                (#x8FD7F2 . #x833D)
                (#x8FD7F3 . #x8342)
                (#x8FD7F4 . #x8343)
                (#x8FD7F5 . #x8344)
                (#x8FD7F6 . #x8347)
                (#x8FD7F7 . #x834D)
                (#x8FD7F8 . #x834E)
                (#x8FD7F9 . #x8351)
                (#x8FD7FA . #x8355)
                (#x8FD7FB . #x8356)
                (#x8FD7FC . #x8357)
                (#x8FD7FD . #x8370)
                (#x8FD7FE . #x8378)
                (#x8FD8A1 . #x837D)
                (#x8FD8A2 . #x837F)
                (#x8FD8A3 . #x8380)
                (#x8FD8A4 . #x8382)
                (#x8FD8A5 . #x8384)
                (#x8FD8A6 . #x8386)
                (#x8FD8A7 . #x838D)
                (#x8FD8A8 . #x8392)
                (#x8FD8A9 . #x8394)
                (#x8FD8AA . #x8395)
                (#x8FD8AB . #x8398)
                (#x8FD8AC . #x8399)
                (#x8FD8AD . #x839B)
                (#x8FD8AE . #x839C)
                (#x8FD8AF . #x839D)
                (#x8FD8B0 . #x83A6)
                (#x8FD8B1 . #x83A7)
                (#x8FD8B2 . #x83A9)
                (#x8FD8B3 . #x83AC)
                (#x8FD8B4 . #x83BE)
                (#x8FD8B5 . #x83BF)
                (#x8FD8B6 . #x83C0)
                (#x8FD8B7 . #x83C7)
                (#x8FD8B8 . #x83C9)
                (#x8FD8B9 . #x83CF)
                (#x8FD8BA . #x83D0)
                (#x8FD8BB . #x83D1)
                (#x8FD8BC . #x83D4)
                (#x8FD8BD . #x83DD)
                (#x8FD8BE . #x8353)
                (#x8FD8BF . #x83E8)
                (#x8FD8C0 . #x83EA)
                (#x8FD8C1 . #x83F6)
                (#x8FD8C2 . #x83F8)
                (#x8FD8C3 . #x83F9)
                (#x8FD8C4 . #x83FC)
                (#x8FD8C5 . #x8401)
                (#x8FD8C6 . #x8406)
                (#x8FD8C7 . #x840A)
                (#x8FD8C8 . #x840F)
                (#x8FD8C9 . #x8411)
                (#x8FD8CA . #x8415)
                (#x8FD8CB . #x8419)
                (#x8FD8CC . #x83AD)
                (#x8FD8CD . #x842F)
                (#x8FD8CE . #x8439)
                (#x8FD8CF . #x8445)
                (#x8FD8D0 . #x8447)
                (#x8FD8D1 . #x8448)
                (#x8FD8D2 . #x844A)
                (#x8FD8D3 . #x844D)
                (#x8FD8D4 . #x844F)
                (#x8FD8D5 . #x8451)
                (#x8FD8D6 . #x8452)
                (#x8FD8D7 . #x8456)
                (#x8FD8D8 . #x8458)
                (#x8FD8D9 . #x8459)
                (#x8FD8DA . #x845A)
                (#x8FD8DB . #x845C)
                (#x8FD8DC . #x8460)
                (#x8FD8DD . #x8464)
                (#x8FD8DE . #x8465)
                (#x8FD8DF . #x8467)
                (#x8FD8E0 . #x846A)
                (#x8FD8E1 . #x8470)
                (#x8FD8E2 . #x8473)
                (#x8FD8E3 . #x8474)
                (#x8FD8E4 . #x8476)
                (#x8FD8E5 . #x8478)
                (#x8FD8E6 . #x847C)
                (#x8FD8E7 . #x847D)
                (#x8FD8E8 . #x8481)
                (#x8FD8E9 . #x8485)
                (#x8FD8EA . #x8492)
                (#x8FD8EB . #x8493)
                (#x8FD8EC . #x8495)
                (#x8FD8ED . #x849E)
                (#x8FD8EE . #x84A6)
                (#x8FD8EF . #x84A8)
                (#x8FD8F0 . #x84A9)
                (#x8FD8F1 . #x84AA)
                (#x8FD8F2 . #x84AF)
                (#x8FD8F3 . #x84B1)
                (#x8FD8F4 . #x84B4)
                (#x8FD8F5 . #x84BA)
                (#x8FD8F6 . #x84BD)
                (#x8FD8F7 . #x84BE)
                (#x8FD8F8 . #x84C0)
                (#x8FD8F9 . #x84C2)
                (#x8FD8FA . #x84C7)
                (#x8FD8FB . #x84C8)
                (#x8FD8FC . #x84CC)
                (#x8FD8FD . #x84CF)
                (#x8FD8FE . #x84D3)
                (#x8FD9A1 . #x84DC)
                (#x8FD9A2 . #x84E7)
                (#x8FD9A3 . #x84EA)
                (#x8FD9A4 . #x84EF)
                (#x8FD9A5 . #x84F0)
                (#x8FD9A6 . #x84F1)
                (#x8FD9A7 . #x84F2)
                (#x8FD9A8 . #x84F7)
                (#x8FD9A9 . #x8532)
                (#x8FD9AA . #x84FA)
                (#x8FD9AB . #x84FB)
                (#x8FD9AC . #x84FD)
                (#x8FD9AD . #x8502)
                (#x8FD9AE . #x8503)
                (#x8FD9AF . #x8507)
                (#x8FD9B0 . #x850C)
                (#x8FD9B1 . #x850E)
                (#x8FD9B2 . #x8510)
                (#x8FD9B3 . #x851C)
                (#x8FD9B4 . #x851E)
                (#x8FD9B5 . #x8522)
                (#x8FD9B6 . #x8523)
                (#x8FD9B7 . #x8524)
                (#x8FD9B8 . #x8525)
                (#x8FD9B9 . #x8527)
                (#x8FD9BA . #x852A)
                (#x8FD9BB . #x852B)
                (#x8FD9BC . #x852F)
                (#x8FD9BD . #x8533)
                (#x8FD9BE . #x8534)
                (#x8FD9BF . #x8536)
                (#x8FD9C0 . #x853F)
                (#x8FD9C1 . #x8546)
                (#x8FD9C2 . #x854F)
                (#x8FD9C3 . #x8550)
                (#x8FD9C4 . #x8551)
                (#x8FD9C5 . #x8552)
                (#x8FD9C6 . #x8553)
                (#x8FD9C7 . #x8556)
                (#x8FD9C8 . #x8559)
                (#x8FD9C9 . #x855C)
                (#x8FD9CA . #x855D)
                (#x8FD9CB . #x855E)
                (#x8FD9CC . #x855F)
                (#x8FD9CD . #x8560)
                (#x8FD9CE . #x8561)
                (#x8FD9CF . #x8562)
                (#x8FD9D0 . #x8564)
                (#x8FD9D1 . #x856B)
                (#x8FD9D2 . #x856F)
                (#x8FD9D3 . #x8579)
                (#x8FD9D4 . #x857A)
                (#x8FD9D5 . #x857B)
                (#x8FD9D6 . #x857D)
                (#x8FD9D7 . #x857F)
                (#x8FD9D8 . #x8581)
                (#x8FD9D9 . #x8585)
                (#x8FD9DA . #x8586)
                (#x8FD9DB . #x8589)
                (#x8FD9DC . #x858B)
                (#x8FD9DD . #x858C)
                (#x8FD9DE . #x858F)
                (#x8FD9DF . #x8593)
                (#x8FD9E0 . #x8598)
                (#x8FD9E1 . #x859D)
                (#x8FD9E2 . #x859F)
                (#x8FD9E3 . #x85A0)
                (#x8FD9E4 . #x85A2)
                (#x8FD9E5 . #x85A5)
                (#x8FD9E6 . #x85A7)
                (#x8FD9E7 . #x85B4)
                (#x8FD9E8 . #x85B6)
                (#x8FD9E9 . #x85B7)
                (#x8FD9EA . #x85B8)
                (#x8FD9EB . #x85BC)
                (#x8FD9EC . #x85BD)
                (#x8FD9ED . #x85BE)
                (#x8FD9EE . #x85BF)
                (#x8FD9EF . #x85C2)
                (#x8FD9F0 . #x85C7)
                (#x8FD9F1 . #x85CA)
                (#x8FD9F2 . #x85CB)
                (#x8FD9F3 . #x85CE)
                (#x8FD9F4 . #x85AD)
                (#x8FD9F5 . #x85D8)
                (#x8FD9F6 . #x85DA)
                (#x8FD9F7 . #x85DF)
                (#x8FD9F8 . #x85E0)
                (#x8FD9F9 . #x85E6)
                (#x8FD9FA . #x85E8)
                (#x8FD9FB . #x85ED)
                (#x8FD9FC . #x85F3)
                (#x8FD9FD . #x85F6)
                (#x8FD9FE . #x85FC)
                (#x8FDAA1 . #x85FF)
                (#x8FDAA2 . #x8600)
                (#x8FDAA3 . #x8604)
                (#x8FDAA4 . #x8605)
                (#x8FDAA5 . #x860D)
                (#x8FDAA6 . #x860E)
                (#x8FDAA7 . #x8610)
                (#x8FDAA8 . #x8611)
                (#x8FDAA9 . #x8612)
                (#x8FDAAA . #x8618)
                (#x8FDAAB . #x8619)
                (#x8FDAAC . #x861B)
                (#x8FDAAD . #x861E)
                (#x8FDAAE . #x8621)
                (#x8FDAAF . #x8627)
                (#x8FDAB0 . #x8629)
                (#x8FDAB1 . #x8636)
                (#x8FDAB2 . #x8638)
                (#x8FDAB3 . #x863A)
                (#x8FDAB4 . #x863C)
                (#x8FDAB5 . #x863D)
                (#x8FDAB6 . #x8640)
                (#x8FDAB7 . #x8642)
                (#x8FDAB8 . #x8646)
                (#x8FDAB9 . #x8652)
                (#x8FDABA . #x8653)
                (#x8FDABB . #x8656)
                (#x8FDABC . #x8657)
                (#x8FDABD . #x8658)
                (#x8FDABE . #x8659)
                (#x8FDABF . #x865D)
                (#x8FDAC0 . #x8660)
                (#x8FDAC1 . #x8661)
                (#x8FDAC2 . #x8662)
                (#x8FDAC3 . #x8663)
                (#x8FDAC4 . #x8664)
                (#x8FDAC5 . #x8669)
                (#x8FDAC6 . #x866C)
                (#x8FDAC7 . #x866F)
                (#x8FDAC8 . #x8675)
                (#x8FDAC9 . #x8676)
                (#x8FDACA . #x8677)
                (#x8FDACB . #x867A)
                (#x8FDACC . #x868D)
                (#x8FDACD . #x8691)
                (#x8FDACE . #x8696)
                (#x8FDACF . #x8698)
                (#x8FDAD0 . #x869A)
                (#x8FDAD1 . #x869C)
                (#x8FDAD2 . #x86A1)
                (#x8FDAD3 . #x86A6)
                (#x8FDAD4 . #x86A7)
                (#x8FDAD5 . #x86A8)
                (#x8FDAD6 . #x86AD)
                (#x8FDAD7 . #x86B1)
                (#x8FDAD8 . #x86B3)
                (#x8FDAD9 . #x86B4)
                (#x8FDADA . #x86B5)
                (#x8FDADB . #x86B7)
                (#x8FDADC . #x86B8)
                (#x8FDADD . #x86B9)
                (#x8FDADE . #x86BF)
                (#x8FDADF . #x86C0)
                (#x8FDAE0 . #x86C1)
                (#x8FDAE1 . #x86C3)
                (#x8FDAE2 . #x86C5)
                (#x8FDAE3 . #x86D1)
                (#x8FDAE4 . #x86D2)
                (#x8FDAE5 . #x86D5)
                (#x8FDAE6 . #x86D7)
                (#x8FDAE7 . #x86DA)
                (#x8FDAE8 . #x86DC)
                (#x8FDAE9 . #x86E0)
                (#x8FDAEA . #x86E3)
                (#x8FDAEB . #x86E5)
                (#x8FDAEC . #x86E7)
                (#x8FDAED . #x8688)
                (#x8FDAEE . #x86FA)
                (#x8FDAEF . #x86FC)
                (#x8FDAF0 . #x86FD)
                (#x8FDAF1 . #x8704)
                (#x8FDAF2 . #x8705)
                (#x8FDAF3 . #x8707)
                (#x8FDAF4 . #x870B)
                (#x8FDAF5 . #x870E)
                (#x8FDAF6 . #x870F)
                (#x8FDAF7 . #x8710)
                (#x8FDAF8 . #x8713)
                (#x8FDAF9 . #x8714)
                (#x8FDAFA . #x8719)
                (#x8FDAFB . #x871E)
                (#x8FDAFC . #x871F)
                (#x8FDAFD . #x8721)
                (#x8FDAFE . #x8723)
                (#x8FDBA1 . #x8728)
                (#x8FDBA2 . #x872E)
                (#x8FDBA3 . #x872F)
                (#x8FDBA4 . #x8731)
                (#x8FDBA5 . #x8732)
                (#x8FDBA6 . #x8739)
                (#x8FDBA7 . #x873A)
                (#x8FDBA8 . #x873C)
                (#x8FDBA9 . #x873D)
                (#x8FDBAA . #x873E)
                (#x8FDBAB . #x8740)
                (#x8FDBAC . #x8743)
                (#x8FDBAD . #x8745)
                (#x8FDBAE . #x874D)
                (#x8FDBAF . #x8758)
                (#x8FDBB0 . #x875D)
                (#x8FDBB1 . #x8761)
                (#x8FDBB2 . #x8764)
                (#x8FDBB3 . #x8765)
                (#x8FDBB4 . #x876F)
                (#x8FDBB5 . #x8771)
                (#x8FDBB6 . #x8772)
                (#x8FDBB7 . #x877B)
                (#x8FDBB8 . #x8783)
                (#x8FDBB9 . #x8784)
                (#x8FDBBA . #x8785)
                (#x8FDBBB . #x8786)
                (#x8FDBBC . #x8787)
                (#x8FDBBD . #x8788)
                (#x8FDBBE . #x8789)
                (#x8FDBBF . #x878B)
                (#x8FDBC0 . #x878C)
                (#x8FDBC1 . #x8790)
                (#x8FDBC2 . #x8793)
                (#x8FDBC3 . #x8795)
                (#x8FDBC4 . #x8797)
                (#x8FDBC5 . #x8798)
                (#x8FDBC6 . #x8799)
                (#x8FDBC7 . #x879E)
                (#x8FDBC8 . #x87A0)
                (#x8FDBC9 . #x87A3)
                (#x8FDBCA . #x87A7)
                (#x8FDBCB . #x87AC)
                (#x8FDBCC . #x87AD)
                (#x8FDBCD . #x87AE)
                (#x8FDBCE . #x87B1)
                (#x8FDBCF . #x87B5)
                (#x8FDBD0 . #x87BE)
                (#x8FDBD1 . #x87BF)
                (#x8FDBD2 . #x87C1)
                (#x8FDBD3 . #x87C8)
                (#x8FDBD4 . #x87C9)
                (#x8FDBD5 . #x87CA)
                (#x8FDBD6 . #x87CE)
                (#x8FDBD7 . #x87D5)
                (#x8FDBD8 . #x87D6)
                (#x8FDBD9 . #x87D9)
                (#x8FDBDA . #x87DA)
                (#x8FDBDB . #x87DC)
                (#x8FDBDC . #x87DF)
                (#x8FDBDD . #x87E2)
                (#x8FDBDE . #x87E3)
                (#x8FDBDF . #x87E4)
                (#x8FDBE0 . #x87EA)
                (#x8FDBE1 . #x87EB)
                (#x8FDBE2 . #x87ED)
                (#x8FDBE3 . #x87F1)
                (#x8FDBE4 . #x87F3)
                (#x8FDBE5 . #x87F8)
                (#x8FDBE6 . #x87FA)
                (#x8FDBE7 . #x87FF)
                (#x8FDBE8 . #x8801)
                (#x8FDBE9 . #x8803)
                (#x8FDBEA . #x8806)
                (#x8FDBEB . #x8809)
                (#x8FDBEC . #x880A)
                (#x8FDBED . #x880B)
                (#x8FDBEE . #x8810)
                (#x8FDBEF . #x8819)
                (#x8FDBF0 . #x8812)
                (#x8FDBF1 . #x8813)
                (#x8FDBF2 . #x8814)
                (#x8FDBF3 . #x8818)
                (#x8FDBF4 . #x881A)
                (#x8FDBF5 . #x881B)
                (#x8FDBF6 . #x881C)
                (#x8FDBF7 . #x881E)
                (#x8FDBF8 . #x881F)
                (#x8FDBF9 . #x8828)
                (#x8FDBFA . #x882D)
                (#x8FDBFB . #x882E)
                (#x8FDBFC . #x8830)
                (#x8FDBFD . #x8832)
                (#x8FDBFE . #x8835)
                (#x8FDCA1 . #x883A)
                (#x8FDCA2 . #x883C)
                (#x8FDCA3 . #x8841)
                (#x8FDCA4 . #x8843)
                (#x8FDCA5 . #x8845)
                (#x8FDCA6 . #x8848)
                (#x8FDCA7 . #x8849)
                (#x8FDCA8 . #x884A)
                (#x8FDCA9 . #x884B)
                (#x8FDCAA . #x884E)
                (#x8FDCAB . #x8851)
                (#x8FDCAC . #x8855)
                (#x8FDCAD . #x8856)
                (#x8FDCAE . #x8858)
                (#x8FDCAF . #x885A)
                (#x8FDCB0 . #x885C)
                (#x8FDCB1 . #x885F)
                (#x8FDCB2 . #x8860)
                (#x8FDCB3 . #x8864)
                (#x8FDCB4 . #x8869)
                (#x8FDCB5 . #x8871)
                (#x8FDCB6 . #x8879)
                (#x8FDCB7 . #x887B)
                (#x8FDCB8 . #x8880)
                (#x8FDCB9 . #x8898)
                (#x8FDCBA . #x889A)
                (#x8FDCBB . #x889B)
                (#x8FDCBC . #x889C)
                (#x8FDCBD . #x889F)
                (#x8FDCBE . #x88A0)
                (#x8FDCBF . #x88A8)
                (#x8FDCC0 . #x88AA)
                (#x8FDCC1 . #x88BA)
                (#x8FDCC2 . #x88BD)
                (#x8FDCC3 . #x88BE)
                (#x8FDCC4 . #x88C0)
                (#x8FDCC5 . #x88CA)
                (#x8FDCC6 . #x88CB)
                (#x8FDCC7 . #x88CC)
                (#x8FDCC8 . #x88CD)
                (#x8FDCC9 . #x88CE)
                (#x8FDCCA . #x88D1)
                (#x8FDCCB . #x88D2)
                (#x8FDCCC . #x88D3)
                (#x8FDCCD . #x88DB)
                (#x8FDCCE . #x88DE)
                (#x8FDCCF . #x88E7)
                (#x8FDCD0 . #x88EF)
                (#x8FDCD1 . #x88F0)
                (#x8FDCD2 . #x88F1)
                (#x8FDCD3 . #x88F5)
                (#x8FDCD4 . #x88F7)
                (#x8FDCD5 . #x8901)
                (#x8FDCD6 . #x8906)
                (#x8FDCD7 . #x890D)
                (#x8FDCD8 . #x890E)
                (#x8FDCD9 . #x890F)
                (#x8FDCDA . #x8915)
                (#x8FDCDB . #x8916)
                (#x8FDCDC . #x8918)
                (#x8FDCDD . #x8919)
                (#x8FDCDE . #x891A)
                (#x8FDCDF . #x891C)
                (#x8FDCE0 . #x8920)
                (#x8FDCE1 . #x8926)
                (#x8FDCE2 . #x8927)
                (#x8FDCE3 . #x8928)
                (#x8FDCE4 . #x8930)
                (#x8FDCE5 . #x8931)
                (#x8FDCE6 . #x8932)
                (#x8FDCE7 . #x8935)
                (#x8FDCE8 . #x8939)
                (#x8FDCE9 . #x893A)
                (#x8FDCEA . #x893E)
                (#x8FDCEB . #x8940)
                (#x8FDCEC . #x8942)
                (#x8FDCED . #x8945)
                (#x8FDCEE . #x8946)
                (#x8FDCEF . #x8949)
                (#x8FDCF0 . #x894F)
                (#x8FDCF1 . #x8952)
                (#x8FDCF2 . #x8957)
                (#x8FDCF3 . #x895A)
                (#x8FDCF4 . #x895B)
                (#x8FDCF5 . #x895C)
                (#x8FDCF6 . #x8961)
                (#x8FDCF7 . #x8962)
                (#x8FDCF8 . #x8963)
                (#x8FDCF9 . #x896B)
                (#x8FDCFA . #x896E)
                (#x8FDCFB . #x8970)
                (#x8FDCFC . #x8973)
                (#x8FDCFD . #x8975)
                (#x8FDCFE . #x897A)
                (#x8FDDA1 . #x897B)
                (#x8FDDA2 . #x897C)
                (#x8FDDA3 . #x897D)
                (#x8FDDA4 . #x8989)
                (#x8FDDA5 . #x898D)
                (#x8FDDA6 . #x8990)
                (#x8FDDA7 . #x8994)
                (#x8FDDA8 . #x8995)
                (#x8FDDA9 . #x899B)
                (#x8FDDAA . #x899C)
                (#x8FDDAB . #x899F)
                (#x8FDDAC . #x89A0)
                (#x8FDDAD . #x89A5)
                (#x8FDDAE . #x89B0)
                (#x8FDDAF . #x89B4)
                (#x8FDDB0 . #x89B5)
                (#x8FDDB1 . #x89B6)
                (#x8FDDB2 . #x89B7)
                (#x8FDDB3 . #x89BC)
                (#x8FDDB4 . #x89D4)
                (#x8FDDB5 . #x89D5)
                (#x8FDDB6 . #x89D6)
                (#x8FDDB7 . #x89D7)
                (#x8FDDB8 . #x89D8)
                (#x8FDDB9 . #x89E5)
                (#x8FDDBA . #x89E9)
                (#x8FDDBB . #x89EB)
                (#x8FDDBC . #x89ED)
                (#x8FDDBD . #x89F1)
                (#x8FDDBE . #x89F3)
                (#x8FDDBF . #x89F6)
                (#x8FDDC0 . #x89F9)
                (#x8FDDC1 . #x89FD)
                (#x8FDDC2 . #x89FF)
                (#x8FDDC3 . #x8A04)
                (#x8FDDC4 . #x8A05)
                (#x8FDDC5 . #x8A07)
                (#x8FDDC6 . #x8A0F)
                (#x8FDDC7 . #x8A11)
                (#x8FDDC8 . #x8A12)
                (#x8FDDC9 . #x8A14)
                (#x8FDDCA . #x8A15)
                (#x8FDDCB . #x8A1E)
                (#x8FDDCC . #x8A20)
                (#x8FDDCD . #x8A22)
                (#x8FDDCE . #x8A24)
                (#x8FDDCF . #x8A26)
                (#x8FDDD0 . #x8A2B)
                (#x8FDDD1 . #x8A2C)
                (#x8FDDD2 . #x8A2F)
                (#x8FDDD3 . #x8A35)
                (#x8FDDD4 . #x8A37)
                (#x8FDDD5 . #x8A3D)
                (#x8FDDD6 . #x8A3E)
                (#x8FDDD7 . #x8A40)
                (#x8FDDD8 . #x8A43)
                (#x8FDDD9 . #x8A45)
                (#x8FDDDA . #x8A47)
                (#x8FDDDB . #x8A49)
                (#x8FDDDC . #x8A4D)
                (#x8FDDDD . #x8A4E)
                (#x8FDDDE . #x8A53)
                (#x8FDDDF . #x8A56)
                (#x8FDDE0 . #x8A57)
                (#x8FDDE1 . #x8A58)
                (#x8FDDE2 . #x8A5C)
                (#x8FDDE3 . #x8A5D)
                (#x8FDDE4 . #x8A61)
                (#x8FDDE5 . #x8A65)
                (#x8FDDE6 . #x8A67)
                (#x8FDDE7 . #x8A75)
                (#x8FDDE8 . #x8A76)
                (#x8FDDE9 . #x8A77)
                (#x8FDDEA . #x8A79)
                (#x8FDDEB . #x8A7A)
                (#x8FDDEC . #x8A7B)
                (#x8FDDED . #x8A7E)
                (#x8FDDEE . #x8A7F)
                (#x8FDDEF . #x8A80)
                (#x8FDDF0 . #x8A83)
                (#x8FDDF1 . #x8A86)
                (#x8FDDF2 . #x8A8B)
                (#x8FDDF3 . #x8A8F)
                (#x8FDDF4 . #x8A90)
                (#x8FDDF5 . #x8A92)
                (#x8FDDF6 . #x8A96)
                (#x8FDDF7 . #x8A97)
                (#x8FDDF8 . #x8A99)
                (#x8FDDF9 . #x8A9F)
                (#x8FDDFA . #x8AA7)
                (#x8FDDFB . #x8AA9)
                (#x8FDDFC . #x8AAE)
                (#x8FDDFD . #x8AAF)
                (#x8FDDFE . #x8AB3)
                (#x8FDEA1 . #x8AB6)
                (#x8FDEA2 . #x8AB7)
                (#x8FDEA3 . #x8ABB)
                (#x8FDEA4 . #x8ABE)
                (#x8FDEA5 . #x8AC3)
                (#x8FDEA6 . #x8AC6)
                (#x8FDEA7 . #x8AC8)
                (#x8FDEA8 . #x8AC9)
                (#x8FDEA9 . #x8ACA)
                (#x8FDEAA . #x8AD1)
                (#x8FDEAB . #x8AD3)
                (#x8FDEAC . #x8AD4)
                (#x8FDEAD . #x8AD5)
                (#x8FDEAE . #x8AD7)
                (#x8FDEAF . #x8ADD)
                (#x8FDEB0 . #x8ADF)
                (#x8FDEB1 . #x8AEC)
                (#x8FDEB2 . #x8AF0)
                (#x8FDEB3 . #x8AF4)
                (#x8FDEB4 . #x8AF5)
                (#x8FDEB5 . #x8AF6)
                (#x8FDEB6 . #x8AFC)
                (#x8FDEB7 . #x8AFF)
                (#x8FDEB8 . #x8B05)
                (#x8FDEB9 . #x8B06)
                (#x8FDEBA . #x8B0B)
                (#x8FDEBB . #x8B11)
                (#x8FDEBC . #x8B1C)
                (#x8FDEBD . #x8B1E)
                (#x8FDEBE . #x8B1F)
                (#x8FDEBF . #x8B0A)
                (#x8FDEC0 . #x8B2D)
                (#x8FDEC1 . #x8B30)
                (#x8FDEC2 . #x8B37)
                (#x8FDEC3 . #x8B3C)
                (#x8FDEC4 . #x8B42)
                (#x8FDEC5 . #x8B43)
                (#x8FDEC6 . #x8B44)
                (#x8FDEC7 . #x8B45)
                (#x8FDEC8 . #x8B46)
                (#x8FDEC9 . #x8B48)
                (#x8FDECA . #x8B52)
                (#x8FDECB . #x8B53)
                (#x8FDECC . #x8B54)
                (#x8FDECD . #x8B59)
                (#x8FDECE . #x8B4D)
                (#x8FDECF . #x8B5E)
                (#x8FDED0 . #x8B63)
                (#x8FDED1 . #x8B6D)
                (#x8FDED2 . #x8B76)
                (#x8FDED3 . #x8B78)
                (#x8FDED4 . #x8B79)
                (#x8FDED5 . #x8B7C)
                (#x8FDED6 . #x8B7E)
                (#x8FDED7 . #x8B81)
                (#x8FDED8 . #x8B84)
                (#x8FDED9 . #x8B85)
                (#x8FDEDA . #x8B8B)
                (#x8FDEDB . #x8B8D)
                (#x8FDEDC . #x8B8F)
                (#x8FDEDD . #x8B94)
                (#x8FDEDE . #x8B95)
                (#x8FDEDF . #x8B9C)
                (#x8FDEE0 . #x8B9E)
                (#x8FDEE1 . #x8B9F)
                (#x8FDEE2 . #x8C38)
                (#x8FDEE3 . #x8C39)
                (#x8FDEE4 . #x8C3D)
                (#x8FDEE5 . #x8C3E)
                (#x8FDEE6 . #x8C45)
                (#x8FDEE7 . #x8C47)
                (#x8FDEE8 . #x8C49)
                (#x8FDEE9 . #x8C4B)
                (#x8FDEEA . #x8C4F)
                (#x8FDEEB . #x8C51)
                (#x8FDEEC . #x8C53)
                (#x8FDEED . #x8C54)
                (#x8FDEEE . #x8C57)
                (#x8FDEEF . #x8C58)
                (#x8FDEF0 . #x8C5B)
                (#x8FDEF1 . #x8C5D)
                (#x8FDEF2 . #x8C59)
                (#x8FDEF3 . #x8C63)
                (#x8FDEF4 . #x8C64)
                (#x8FDEF5 . #x8C66)
                (#x8FDEF6 . #x8C68)
                (#x8FDEF7 . #x8C69)
                (#x8FDEF8 . #x8C6D)
                (#x8FDEF9 . #x8C73)
                (#x8FDEFA . #x8C75)
                (#x8FDEFB . #x8C76)
                (#x8FDEFC . #x8C7B)
                (#x8FDEFD . #x8C7E)
                (#x8FDEFE . #x8C86)
                (#x8FDFA1 . #x8C87)
                (#x8FDFA2 . #x8C8B)
                (#x8FDFA3 . #x8C90)
                (#x8FDFA4 . #x8C92)
                (#x8FDFA5 . #x8C93)
                (#x8FDFA6 . #x8C99)
                (#x8FDFA7 . #x8C9B)
                (#x8FDFA8 . #x8C9C)
                (#x8FDFA9 . #x8CA4)
                (#x8FDFAA . #x8CB9)
                (#x8FDFAB . #x8CBA)
                (#x8FDFAC . #x8CC5)
                (#x8FDFAD . #x8CC6)
                (#x8FDFAE . #x8CC9)
                (#x8FDFAF . #x8CCB)
                (#x8FDFB0 . #x8CCF)
                (#x8FDFB1 . #x8CD6)
                (#x8FDFB2 . #x8CD5)
                (#x8FDFB3 . #x8CD9)
                (#x8FDFB4 . #x8CDD)
                (#x8FDFB5 . #x8CE1)
                (#x8FDFB6 . #x8CE8)
                (#x8FDFB7 . #x8CEC)
                (#x8FDFB8 . #x8CEF)
                (#x8FDFB9 . #x8CF0)
                (#x8FDFBA . #x8CF2)
                (#x8FDFBB . #x8CF5)
                (#x8FDFBC . #x8CF7)
                (#x8FDFBD . #x8CF8)
                (#x8FDFBE . #x8CFE)
                (#x8FDFBF . #x8CFF)
                (#x8FDFC0 . #x8D01)
                (#x8FDFC1 . #x8D03)
                (#x8FDFC2 . #x8D09)
                (#x8FDFC3 . #x8D12)
                (#x8FDFC4 . #x8D17)
                (#x8FDFC5 . #x8D1B)
                (#x8FDFC6 . #x8D65)
                (#x8FDFC7 . #x8D69)
                (#x8FDFC8 . #x8D6C)
                (#x8FDFC9 . #x8D6E)
                (#x8FDFCA . #x8D7F)
                (#x8FDFCB . #x8D82)
                (#x8FDFCC . #x8D84)
                (#x8FDFCD . #x8D88)
                (#x8FDFCE . #x8D8D)
                (#x8FDFCF . #x8D90)
                (#x8FDFD0 . #x8D91)
                (#x8FDFD1 . #x8D95)
                (#x8FDFD2 . #x8D9E)
                (#x8FDFD3 . #x8D9F)
                (#x8FDFD4 . #x8DA0)
                (#x8FDFD5 . #x8DA6)
                (#x8FDFD6 . #x8DAB)
                (#x8FDFD7 . #x8DAC)
                (#x8FDFD8 . #x8DAF)
                (#x8FDFD9 . #x8DB2)
                (#x8FDFDA . #x8DB5)
                (#x8FDFDB . #x8DB7)
                (#x8FDFDC . #x8DB9)
                (#x8FDFDD . #x8DBB)
                (#x8FDFDE . #x8DC0)
                (#x8FDFDF . #x8DC5)
                (#x8FDFE0 . #x8DC6)
                (#x8FDFE1 . #x8DC7)
                (#x8FDFE2 . #x8DC8)
                (#x8FDFE3 . #x8DCA)
                (#x8FDFE4 . #x8DCE)
                (#x8FDFE5 . #x8DD1)
                (#x8FDFE6 . #x8DD4)
                (#x8FDFE7 . #x8DD5)
                (#x8FDFE8 . #x8DD7)
                (#x8FDFE9 . #x8DD9)
                (#x8FDFEA . #x8DE4)
                (#x8FDFEB . #x8DE5)
                (#x8FDFEC . #x8DE7)
                (#x8FDFED . #x8DEC)
                (#x8FDFEE . #x8DF0)
                (#x8FDFEF . #x8DBC)
                (#x8FDFF0 . #x8DF1)
                (#x8FDFF1 . #x8DF2)
                (#x8FDFF2 . #x8DF4)
                (#x8FDFF3 . #x8DFD)
                (#x8FDFF4 . #x8E01)
                (#x8FDFF5 . #x8E04)
                (#x8FDFF6 . #x8E05)
                (#x8FDFF7 . #x8E06)
                (#x8FDFF8 . #x8E0B)
                (#x8FDFF9 . #x8E11)
                (#x8FDFFA . #x8E14)
                (#x8FDFFB . #x8E16)
                (#x8FDFFC . #x8E20)
                (#x8FDFFD . #x8E21)
                (#x8FDFFE . #x8E22)
                (#x8FE0A1 . #x8E23)
                (#x8FE0A2 . #x8E26)
                (#x8FE0A3 . #x8E27)
                (#x8FE0A4 . #x8E31)
                (#x8FE0A5 . #x8E33)
                (#x8FE0A6 . #x8E36)
                (#x8FE0A7 . #x8E37)
                (#x8FE0A8 . #x8E38)
                (#x8FE0A9 . #x8E39)
                (#x8FE0AA . #x8E3D)
                (#x8FE0AB . #x8E40)
                (#x8FE0AC . #x8E41)
                (#x8FE0AD . #x8E4B)
                (#x8FE0AE . #x8E4D)
                (#x8FE0AF . #x8E4E)
                (#x8FE0B0 . #x8E4F)
                (#x8FE0B1 . #x8E54)
                (#x8FE0B2 . #x8E5B)
                (#x8FE0B3 . #x8E5C)
                (#x8FE0B4 . #x8E5D)
                (#x8FE0B5 . #x8E5E)
                (#x8FE0B6 . #x8E61)
                (#x8FE0B7 . #x8E62)
                (#x8FE0B8 . #x8E69)
                (#x8FE0B9 . #x8E6C)
                (#x8FE0BA . #x8E6D)
                (#x8FE0BB . #x8E6F)
                (#x8FE0BC . #x8E70)
                (#x8FE0BD . #x8E71)
                (#x8FE0BE . #x8E79)
                (#x8FE0BF . #x8E7A)
                (#x8FE0C0 . #x8E7B)
                (#x8FE0C1 . #x8E82)
                (#x8FE0C2 . #x8E83)
                (#x8FE0C3 . #x8E89)
                (#x8FE0C4 . #x8E90)
                (#x8FE0C5 . #x8E92)
                (#x8FE0C6 . #x8E95)
                (#x8FE0C7 . #x8E9A)
                (#x8FE0C8 . #x8E9B)
                (#x8FE0C9 . #x8E9D)
                (#x8FE0CA . #x8E9E)
                (#x8FE0CB . #x8EA2)
                (#x8FE0CC . #x8EA7)
                (#x8FE0CD . #x8EA9)
                (#x8FE0CE . #x8EAD)
                (#x8FE0CF . #x8EAE)
                (#x8FE0D0 . #x8EB3)
                (#x8FE0D1 . #x8EB5)
                (#x8FE0D2 . #x8EBA)
                (#x8FE0D3 . #x8EBB)
                (#x8FE0D4 . #x8EC0)
                (#x8FE0D5 . #x8EC1)
                (#x8FE0D6 . #x8EC3)
                (#x8FE0D7 . #x8EC4)
                (#x8FE0D8 . #x8EC7)
                (#x8FE0D9 . #x8ECF)
                (#x8FE0DA . #x8ED1)
                (#x8FE0DB . #x8ED4)
                (#x8FE0DC . #x8EDC)
                (#x8FE0DD . #x8EE8)
                (#x8FE0DE . #x8EEE)
                (#x8FE0DF . #x8EF0)
                (#x8FE0E0 . #x8EF1)
                (#x8FE0E1 . #x8EF7)
                (#x8FE0E2 . #x8EF9)
                (#x8FE0E3 . #x8EFA)
                (#x8FE0E4 . #x8EED)
                (#x8FE0E5 . #x8F00)
                (#x8FE0E6 . #x8F02)
                (#x8FE0E7 . #x8F07)
                (#x8FE0E8 . #x8F08)
                (#x8FE0E9 . #x8F0F)
                (#x8FE0EA . #x8F10)
                (#x8FE0EB . #x8F16)
                (#x8FE0EC . #x8F17)
                (#x8FE0ED . #x8F18)
                (#x8FE0EE . #x8F1E)
                (#x8FE0EF . #x8F20)
                (#x8FE0F0 . #x8F21)
                (#x8FE0F1 . #x8F23)
                (#x8FE0F2 . #x8F25)
                (#x8FE0F3 . #x8F27)
                (#x8FE0F4 . #x8F28)
                (#x8FE0F5 . #x8F2C)
                (#x8FE0F6 . #x8F2D)
                (#x8FE0F7 . #x8F2E)
                (#x8FE0F8 . #x8F34)
                (#x8FE0F9 . #x8F35)
                (#x8FE0FA . #x8F36)
                (#x8FE0FB . #x8F37)
                (#x8FE0FC . #x8F3A)
                (#x8FE0FD . #x8F40)
                (#x8FE0FE . #x8F41)
                (#x8FE1A1 . #x8F43)
                (#x8FE1A2 . #x8F47)
                (#x8FE1A3 . #x8F4F)
                (#x8FE1A4 . #x8F51)
                (#x8FE1A5 . #x8F52)
                (#x8FE1A6 . #x8F53)
                (#x8FE1A7 . #x8F54)
                (#x8FE1A8 . #x8F55)
                (#x8FE1A9 . #x8F58)
                (#x8FE1AA . #x8F5D)
                (#x8FE1AB . #x8F5E)
                (#x8FE1AC . #x8F65)
                (#x8FE1AD . #x8F9D)
                (#x8FE1AE . #x8FA0)
                (#x8FE1AF . #x8FA1)
                (#x8FE1B0 . #x8FA4)
                (#x8FE1B1 . #x8FA5)
                (#x8FE1B2 . #x8FA6)
                (#x8FE1B3 . #x8FB5)
                (#x8FE1B4 . #x8FB6)
                (#x8FE1B5 . #x8FB8)
                (#x8FE1B6 . #x8FBE)
                (#x8FE1B7 . #x8FC0)
                (#x8FE1B8 . #x8FC1)
                (#x8FE1B9 . #x8FC6)
                (#x8FE1BA . #x8FCA)
                (#x8FE1BB . #x8FCB)
                (#x8FE1BC . #x8FCD)
                (#x8FE1BD . #x8FD0)
                (#x8FE1BE . #x8FD2)
                (#x8FE1BF . #x8FD3)
                (#x8FE1C0 . #x8FD5)
                (#x8FE1C1 . #x8FE0)
                (#x8FE1C2 . #x8FE3)
                (#x8FE1C3 . #x8FE4)
                (#x8FE1C4 . #x8FE8)
                (#x8FE1C5 . #x8FEE)
                (#x8FE1C6 . #x8FF1)
                (#x8FE1C7 . #x8FF5)
                (#x8FE1C8 . #x8FF6)
                (#x8FE1C9 . #x8FFB)
                (#x8FE1CA . #x8FFE)
                (#x8FE1CB . #x9002)
                (#x8FE1CC . #x9004)
                (#x8FE1CD . #x9008)
                (#x8FE1CE . #x900C)
                (#x8FE1CF . #x9018)
                (#x8FE1D0 . #x901B)
                (#x8FE1D1 . #x9028)
                (#x8FE1D2 . #x9029)
                (#x8FE1D3 . #x902F)
                (#x8FE1D4 . #x902A)
                (#x8FE1D5 . #x902C)
                (#x8FE1D6 . #x902D)
                (#x8FE1D7 . #x9033)
                (#x8FE1D8 . #x9034)
                (#x8FE1D9 . #x9037)
                (#x8FE1DA . #x903F)
                (#x8FE1DB . #x9043)
                (#x8FE1DC . #x9044)
                (#x8FE1DD . #x904C)
                (#x8FE1DE . #x905B)
                (#x8FE1DF . #x905D)
                (#x8FE1E0 . #x9062)
                (#x8FE1E1 . #x9066)
                (#x8FE1E2 . #x9067)
                (#x8FE1E3 . #x906C)
                (#x8FE1E4 . #x9070)
                (#x8FE1E5 . #x9074)
                (#x8FE1E6 . #x9079)
                (#x8FE1E7 . #x9085)
                (#x8FE1E8 . #x9088)
                (#x8FE1E9 . #x908B)
                (#x8FE1EA . #x908C)
                (#x8FE1EB . #x908E)
                (#x8FE1EC . #x9090)
                (#x8FE1ED . #x9095)
                (#x8FE1EE . #x9097)
                (#x8FE1EF . #x9098)
                (#x8FE1F0 . #x9099)
                (#x8FE1F1 . #x909B)
                (#x8FE1F2 . #x90A0)
                (#x8FE1F3 . #x90A1)
                (#x8FE1F4 . #x90A2)
                (#x8FE1F5 . #x90A5)
                (#x8FE1F6 . #x90B0)
                (#x8FE1F7 . #x90B2)
                (#x8FE1F8 . #x90B3)
                (#x8FE1F9 . #x90B4)
                (#x8FE1FA . #x90B6)
                (#x8FE1FB . #x90BD)
                (#x8FE1FC . #x90CC)
                (#x8FE1FD . #x90BE)
                (#x8FE1FE . #x90C3)
                (#x8FE2A1 . #x90C4)
                (#x8FE2A2 . #x90C5)
                (#x8FE2A3 . #x90C7)
                (#x8FE2A4 . #x90C8)
                (#x8FE2A5 . #x90D5)
                (#x8FE2A6 . #x90D7)
                (#x8FE2A7 . #x90D8)
                (#x8FE2A8 . #x90D9)
                (#x8FE2A9 . #x90DC)
                (#x8FE2AA . #x90DD)
                (#x8FE2AB . #x90DF)
                (#x8FE2AC . #x90E5)
                (#x8FE2AD . #x90D2)
                (#x8FE2AE . #x90F6)
                (#x8FE2AF . #x90EB)
                (#x8FE2B0 . #x90EF)
                (#x8FE2B1 . #x90F0)
                (#x8FE2B2 . #x90F4)
                (#x8FE2B3 . #x90FE)
                (#x8FE2B4 . #x90FF)
                (#x8FE2B5 . #x9100)
                (#x8FE2B6 . #x9104)
                (#x8FE2B7 . #x9105)
                (#x8FE2B8 . #x9106)
                (#x8FE2B9 . #x9108)
                (#x8FE2BA . #x910D)
                (#x8FE2BB . #x9110)
                (#x8FE2BC . #x9114)
                (#x8FE2BD . #x9116)
                (#x8FE2BE . #x9117)
                (#x8FE2BF . #x9118)
                (#x8FE2C0 . #x911A)
                (#x8FE2C1 . #x911C)
                (#x8FE2C2 . #x911E)
                (#x8FE2C3 . #x9120)
                (#x8FE2C4 . #x9125)
                (#x8FE2C5 . #x9122)
                (#x8FE2C6 . #x9123)
                (#x8FE2C7 . #x9127)
                (#x8FE2C8 . #x9129)
                (#x8FE2C9 . #x912E)
                (#x8FE2CA . #x912F)
                (#x8FE2CB . #x9131)
                (#x8FE2CC . #x9134)
                (#x8FE2CD . #x9136)
                (#x8FE2CE . #x9137)
                (#x8FE2CF . #x9139)
                (#x8FE2D0 . #x913A)
                (#x8FE2D1 . #x913C)
                (#x8FE2D2 . #x913D)
                (#x8FE2D3 . #x9143)
                (#x8FE2D4 . #x9147)
                (#x8FE2D5 . #x9148)
                (#x8FE2D6 . #x914F)
                (#x8FE2D7 . #x9153)
                (#x8FE2D8 . #x9157)
                (#x8FE2D9 . #x9159)
                (#x8FE2DA . #x915A)
                (#x8FE2DB . #x915B)
                (#x8FE2DC . #x9161)
                (#x8FE2DD . #x9164)
                (#x8FE2DE . #x9167)
                (#x8FE2DF . #x916D)
                (#x8FE2E0 . #x9174)
                (#x8FE2E1 . #x9179)
                (#x8FE2E2 . #x917A)
                (#x8FE2E3 . #x917B)
                (#x8FE2E4 . #x9181)
                (#x8FE2E5 . #x9183)
                (#x8FE2E6 . #x9185)
                (#x8FE2E7 . #x9186)
                (#x8FE2E8 . #x918A)
                (#x8FE2E9 . #x918E)
                (#x8FE2EA . #x9191)
                (#x8FE2EB . #x9193)
                (#x8FE2EC . #x9194)
                (#x8FE2ED . #x9195)
                (#x8FE2EE . #x9198)
                (#x8FE2EF . #x919E)
                (#x8FE2F0 . #x91A1)
                (#x8FE2F1 . #x91A6)
                (#x8FE2F2 . #x91A8)
                (#x8FE2F3 . #x91AC)
                (#x8FE2F4 . #x91AD)
                (#x8FE2F5 . #x91AE)
                (#x8FE2F6 . #x91B0)
                (#x8FE2F7 . #x91B1)
                (#x8FE2F8 . #x91B2)
                (#x8FE2F9 . #x91B3)
                (#x8FE2FA . #x91B6)
                (#x8FE2FB . #x91BB)
                (#x8FE2FC . #x91BC)
                (#x8FE2FD . #x91BD)
                (#x8FE2FE . #x91BF)
                (#x8FE3A1 . #x91C2)
                (#x8FE3A2 . #x91C3)
                (#x8FE3A3 . #x91C5)
                (#x8FE3A4 . #x91D3)
                (#x8FE3A5 . #x91D4)
                (#x8FE3A6 . #x91D7)
                (#x8FE3A7 . #x91D9)
                (#x8FE3A8 . #x91DA)
                (#x8FE3A9 . #x91DE)
                (#x8FE3AA . #x91E4)
                (#x8FE3AB . #x91E5)
                (#x8FE3AC . #x91E9)
                (#x8FE3AD . #x91EA)
                (#x8FE3AE . #x91EC)
                (#x8FE3AF . #x91ED)
                (#x8FE3B0 . #x91EE)
                (#x8FE3B1 . #x91EF)
                (#x8FE3B2 . #x91F0)
                (#x8FE3B3 . #x91F1)
                (#x8FE3B4 . #x91F7)
                (#x8FE3B5 . #x91F9)
                (#x8FE3B6 . #x91FB)
                (#x8FE3B7 . #x91FD)
                (#x8FE3B8 . #x9200)
                (#x8FE3B9 . #x9201)
                (#x8FE3BA . #x9204)
                (#x8FE3BB . #x9205)
                (#x8FE3BC . #x9206)
                (#x8FE3BD . #x9207)
                (#x8FE3BE . #x9209)
                (#x8FE3BF . #x920A)
                (#x8FE3C0 . #x920C)
                (#x8FE3C1 . #x9210)
                (#x8FE3C2 . #x9212)
                (#x8FE3C3 . #x9213)
                (#x8FE3C4 . #x9216)
                (#x8FE3C5 . #x9218)
                (#x8FE3C6 . #x921C)
                (#x8FE3C7 . #x921D)
                (#x8FE3C8 . #x9223)
                (#x8FE3C9 . #x9224)
                (#x8FE3CA . #x9225)
                (#x8FE3CB . #x9226)
                (#x8FE3CC . #x9228)
                (#x8FE3CD . #x922E)
                (#x8FE3CE . #x922F)
                (#x8FE3CF . #x9230)
                (#x8FE3D0 . #x9233)
                (#x8FE3D1 . #x9235)
                (#x8FE3D2 . #x9236)
                (#x8FE3D3 . #x9238)
                (#x8FE3D4 . #x9239)
                (#x8FE3D5 . #x923A)
                (#x8FE3D6 . #x923C)
                (#x8FE3D7 . #x923E)
                (#x8FE3D8 . #x9240)
                (#x8FE3D9 . #x9242)
                (#x8FE3DA . #x9243)
                (#x8FE3DB . #x9246)
                (#x8FE3DC . #x9247)
                (#x8FE3DD . #x924A)
                (#x8FE3DE . #x924D)
                (#x8FE3DF . #x924E)
                (#x8FE3E0 . #x924F)
                (#x8FE3E1 . #x9251)
                (#x8FE3E2 . #x9258)
                (#x8FE3E3 . #x9259)
                (#x8FE3E4 . #x925C)
                (#x8FE3E5 . #x925D)
                (#x8FE3E6 . #x9260)
                (#x8FE3E7 . #x9261)
                (#x8FE3E8 . #x9265)
                (#x8FE3E9 . #x9267)
                (#x8FE3EA . #x9268)
                (#x8FE3EB . #x9269)
                (#x8FE3EC . #x926E)
                (#x8FE3ED . #x926F)
                (#x8FE3EE . #x9270)
                (#x8FE3EF . #x9275)
                (#x8FE3F0 . #x9276)
                (#x8FE3F1 . #x9277)
                (#x8FE3F2 . #x9278)
                (#x8FE3F3 . #x9279)
                (#x8FE3F4 . #x927B)
                (#x8FE3F5 . #x927C)
                (#x8FE3F6 . #x927D)
                (#x8FE3F7 . #x927F)
                (#x8FE3F8 . #x9288)
                (#x8FE3F9 . #x9289)
                (#x8FE3FA . #x928A)
                (#x8FE3FB . #x928D)
                (#x8FE3FC . #x928E)
                (#x8FE3FD . #x9292)
                (#x8FE3FE . #x9297)
                (#x8FE4A1 . #x9299)
                (#x8FE4A2 . #x929F)
                (#x8FE4A3 . #x92A0)
                (#x8FE4A4 . #x92A4)
                (#x8FE4A5 . #x92A5)
                (#x8FE4A6 . #x92A7)
                (#x8FE4A7 . #x92A8)
                (#x8FE4A8 . #x92AB)
                (#x8FE4A9 . #x92AF)
                (#x8FE4AA . #x92B2)
                (#x8FE4AB . #x92B6)
                (#x8FE4AC . #x92B8)
                (#x8FE4AD . #x92BA)
                (#x8FE4AE . #x92BB)
                (#x8FE4AF . #x92BC)
                (#x8FE4B0 . #x92BD)
                (#x8FE4B1 . #x92BF)
                (#x8FE4B2 . #x92C0)
                (#x8FE4B3 . #x92C1)
                (#x8FE4B4 . #x92C2)
                (#x8FE4B5 . #x92C3)
                (#x8FE4B6 . #x92C5)
                (#x8FE4B7 . #x92C6)
                (#x8FE4B8 . #x92C7)
                (#x8FE4B9 . #x92C8)
                (#x8FE4BA . #x92CB)
                (#x8FE4BB . #x92CC)
                (#x8FE4BC . #x92CD)
                (#x8FE4BD . #x92CE)
                (#x8FE4BE . #x92D0)
                (#x8FE4BF . #x92D3)
                (#x8FE4C0 . #x92D5)
                (#x8FE4C1 . #x92D7)
                (#x8FE4C2 . #x92D8)
                (#x8FE4C3 . #x92D9)
                (#x8FE4C4 . #x92DC)
                (#x8FE4C5 . #x92DD)
                (#x8FE4C6 . #x92DF)
                (#x8FE4C7 . #x92E0)
                (#x8FE4C8 . #x92E1)
                (#x8FE4C9 . #x92E3)
                (#x8FE4CA . #x92E5)
                (#x8FE4CB . #x92E7)
                (#x8FE4CC . #x92E8)
                (#x8FE4CD . #x92EC)
                (#x8FE4CE . #x92EE)
                (#x8FE4CF . #x92F0)
                (#x8FE4D0 . #x92F9)
                (#x8FE4D1 . #x92FB)
                (#x8FE4D2 . #x92FF)
                (#x8FE4D3 . #x9300)
                (#x8FE4D4 . #x9302)
                (#x8FE4D5 . #x9308)
                (#x8FE4D6 . #x930D)
                (#x8FE4D7 . #x9311)
                (#x8FE4D8 . #x9314)
                (#x8FE4D9 . #x9315)
                (#x8FE4DA . #x931C)
                (#x8FE4DB . #x931D)
                (#x8FE4DC . #x931E)
                (#x8FE4DD . #x931F)
                (#x8FE4DE . #x9321)
                (#x8FE4DF . #x9324)
                (#x8FE4E0 . #x9325)
                (#x8FE4E1 . #x9327)
                (#x8FE4E2 . #x9329)
                (#x8FE4E3 . #x932A)
                (#x8FE4E4 . #x9333)
                (#x8FE4E5 . #x9334)
                (#x8FE4E6 . #x9336)
                (#x8FE4E7 . #x9337)
                (#x8FE4E8 . #x9347)
                (#x8FE4E9 . #x9348)
                (#x8FE4EA . #x9349)
                (#x8FE4EB . #x9350)
                (#x8FE4EC . #x9351)
                (#x8FE4ED . #x9352)
                (#x8FE4EE . #x9355)
                (#x8FE4EF . #x9357)
                (#x8FE4F0 . #x9358)
                (#x8FE4F1 . #x935A)
                (#x8FE4F2 . #x935E)
                (#x8FE4F3 . #x9364)
                (#x8FE4F4 . #x9365)
                (#x8FE4F5 . #x9367)
                (#x8FE4F6 . #x9369)
                (#x8FE4F7 . #x936A)
                (#x8FE4F8 . #x936D)
                (#x8FE4F9 . #x936F)
                (#x8FE4FA . #x9370)
                (#x8FE4FB . #x9371)
                (#x8FE4FC . #x9373)
                (#x8FE4FD . #x9374)
                (#x8FE4FE . #x9376)
                (#x8FE5A1 . #x937A)
                (#x8FE5A2 . #x937D)
                (#x8FE5A3 . #x937F)
                (#x8FE5A4 . #x9380)
                (#x8FE5A5 . #x9381)
                (#x8FE5A6 . #x9382)
                (#x8FE5A7 . #x9388)
                (#x8FE5A8 . #x938A)
                (#x8FE5A9 . #x938B)
                (#x8FE5AA . #x938D)
                (#x8FE5AB . #x938F)
                (#x8FE5AC . #x9392)
                (#x8FE5AD . #x9395)
                (#x8FE5AE . #x9398)
                (#x8FE5AF . #x939B)
                (#x8FE5B0 . #x939E)
                (#x8FE5B1 . #x93A1)
                (#x8FE5B2 . #x93A3)
                (#x8FE5B3 . #x93A4)
                (#x8FE5B4 . #x93A6)
                (#x8FE5B5 . #x93A8)
                (#x8FE5B6 . #x93AB)
                (#x8FE5B7 . #x93B4)
                (#x8FE5B8 . #x93B5)
                (#x8FE5B9 . #x93B6)
                (#x8FE5BA . #x93BA)
                (#x8FE5BB . #x93A9)
                (#x8FE5BC . #x93C1)
                (#x8FE5BD . #x93C4)
                (#x8FE5BE . #x93C5)
                (#x8FE5BF . #x93C6)
                (#x8FE5C0 . #x93C7)
                (#x8FE5C1 . #x93C9)
                (#x8FE5C2 . #x93CA)
                (#x8FE5C3 . #x93CB)
                (#x8FE5C4 . #x93CC)
                (#x8FE5C5 . #x93CD)
                (#x8FE5C6 . #x93D3)
                (#x8FE5C7 . #x93D9)
                (#x8FE5C8 . #x93DC)
                (#x8FE5C9 . #x93DE)
                (#x8FE5CA . #x93DF)
                (#x8FE5CB . #x93E2)
                (#x8FE5CC . #x93E6)
                (#x8FE5CD . #x93E7)
                (#x8FE5CE . #x93F9)
                (#x8FE5CF . #x93F7)
                (#x8FE5D0 . #x93F8)
                (#x8FE5D1 . #x93FA)
                (#x8FE5D2 . #x93FB)
                (#x8FE5D3 . #x93FD)
                (#x8FE5D4 . #x9401)
                (#x8FE5D5 . #x9402)
                (#x8FE5D6 . #x9404)
                (#x8FE5D7 . #x9408)
                (#x8FE5D8 . #x9409)
                (#x8FE5D9 . #x940D)
                (#x8FE5DA . #x940E)
                (#x8FE5DB . #x940F)
                (#x8FE5DC . #x9415)
                (#x8FE5DD . #x9416)
                (#x8FE5DE . #x9417)
                (#x8FE5DF . #x941F)
                (#x8FE5E0 . #x942E)
                (#x8FE5E1 . #x942F)
                (#x8FE5E2 . #x9431)
                (#x8FE5E3 . #x9432)
                (#x8FE5E4 . #x9433)
                (#x8FE5E5 . #x9434)
                (#x8FE5E6 . #x943B)
                (#x8FE5E7 . #x943F)
                (#x8FE5E8 . #x943D)
                (#x8FE5E9 . #x9443)
                (#x8FE5EA . #x9445)
                (#x8FE5EB . #x9448)
                (#x8FE5EC . #x944A)
                (#x8FE5ED . #x944C)
                (#x8FE5EE . #x9455)
                (#x8FE5EF . #x9459)
                (#x8FE5F0 . #x945C)
                (#x8FE5F1 . #x945F)
                (#x8FE5F2 . #x9461)
                (#x8FE5F3 . #x9463)
                (#x8FE5F4 . #x9468)
                (#x8FE5F5 . #x946B)
                (#x8FE5F6 . #x946D)
                (#x8FE5F7 . #x946E)
                (#x8FE5F8 . #x946F)
                (#x8FE5F9 . #x9471)
                (#x8FE5FA . #x9472)
                (#x8FE5FB . #x9484)
                (#x8FE5FC . #x9483)
                (#x8FE5FD . #x9578)
                (#x8FE5FE . #x9579)
                (#x8FE6A1 . #x957E)
                (#x8FE6A2 . #x9584)
                (#x8FE6A3 . #x9588)
                (#x8FE6A4 . #x958C)
                (#x8FE6A5 . #x958D)
                (#x8FE6A6 . #x958E)
                (#x8FE6A7 . #x959D)
                (#x8FE6A8 . #x959E)
                (#x8FE6A9 . #x959F)
                (#x8FE6AA . #x95A1)
                (#x8FE6AB . #x95A6)
                (#x8FE6AC . #x95A9)
                (#x8FE6AD . #x95AB)
                (#x8FE6AE . #x95AC)
                (#x8FE6AF . #x95B4)
                (#x8FE6B0 . #x95B6)
                (#x8FE6B1 . #x95BA)
                (#x8FE6B2 . #x95BD)
                (#x8FE6B3 . #x95BF)
                (#x8FE6B4 . #x95C6)
                (#x8FE6B5 . #x95C8)
                (#x8FE6B6 . #x95C9)
                (#x8FE6B7 . #x95CB)
                (#x8FE6B8 . #x95D0)
                (#x8FE6B9 . #x95D1)
                (#x8FE6BA . #x95D2)
                (#x8FE6BB . #x95D3)
                (#x8FE6BC . #x95D9)
                (#x8FE6BD . #x95DA)
                (#x8FE6BE . #x95DD)
                (#x8FE6BF . #x95DE)
                (#x8FE6C0 . #x95DF)
                (#x8FE6C1 . #x95E0)
                (#x8FE6C2 . #x95E4)
                (#x8FE6C3 . #x95E6)
                (#x8FE6C4 . #x961D)
                (#x8FE6C5 . #x961E)
                (#x8FE6C6 . #x9622)
                (#x8FE6C7 . #x9624)
                (#x8FE6C8 . #x9625)
                (#x8FE6C9 . #x9626)
                (#x8FE6CA . #x962C)
                (#x8FE6CB . #x9631)
                (#x8FE6CC . #x9633)
                (#x8FE6CD . #x9637)
                (#x8FE6CE . #x9638)
                (#x8FE6CF . #x9639)
                (#x8FE6D0 . #x963A)
                (#x8FE6D1 . #x963C)
                (#x8FE6D2 . #x963D)
                (#x8FE6D3 . #x9641)
                (#x8FE6D4 . #x9652)
                (#x8FE6D5 . #x9654)
                (#x8FE6D6 . #x9656)
                (#x8FE6D7 . #x9657)
                (#x8FE6D8 . #x9658)
                (#x8FE6D9 . #x9661)
                (#x8FE6DA . #x966E)
                (#x8FE6DB . #x9674)
                (#x8FE6DC . #x967B)
                (#x8FE6DD . #x967C)
                (#x8FE6DE . #x967E)
                (#x8FE6DF . #x967F)
                (#x8FE6E0 . #x9681)
                (#x8FE6E1 . #x9682)
                (#x8FE6E2 . #x9683)
                (#x8FE6E3 . #x9684)
                (#x8FE6E4 . #x9689)
                (#x8FE6E5 . #x9691)
                (#x8FE6E6 . #x9696)
                (#x8FE6E7 . #x969A)
                (#x8FE6E8 . #x969D)
                (#x8FE6E9 . #x969F)
                (#x8FE6EA . #x96A4)
                (#x8FE6EB . #x96A5)
                (#x8FE6EC . #x96A6)
                (#x8FE6ED . #x96A9)
                (#x8FE6EE . #x96AE)
                (#x8FE6EF . #x96AF)
                (#x8FE6F0 . #x96B3)
                (#x8FE6F1 . #x96BA)
                (#x8FE6F2 . #x96CA)
                (#x8FE6F3 . #x96D2)
                (#x8FE6F4 . #x5DB2)
                (#x8FE6F5 . #x96D8)
                (#x8FE6F6 . #x96DA)
                (#x8FE6F7 . #x96DD)
                (#x8FE6F8 . #x96DE)
                (#x8FE6F9 . #x96DF)
                (#x8FE6FA . #x96E9)
                (#x8FE6FB . #x96EF)
                (#x8FE6FC . #x96F1)
                (#x8FE6FD . #x96FA)
                (#x8FE6FE . #x9702)
                (#x8FE7A1 . #x9703)
                (#x8FE7A2 . #x9705)
                (#x8FE7A3 . #x9709)
                (#x8FE7A4 . #x971A)
                (#x8FE7A5 . #x971B)
                (#x8FE7A6 . #x971D)
                (#x8FE7A7 . #x9721)
                (#x8FE7A8 . #x9722)
                (#x8FE7A9 . #x9723)
                (#x8FE7AA . #x9728)
                (#x8FE7AB . #x9731)
                (#x8FE7AC . #x9733)
                (#x8FE7AD . #x9741)
                (#x8FE7AE . #x9743)
                (#x8FE7AF . #x974A)
                (#x8FE7B0 . #x974E)
                (#x8FE7B1 . #x974F)
                (#x8FE7B2 . #x9755)
                (#x8FE7B3 . #x9757)
                (#x8FE7B4 . #x9758)
                (#x8FE7B5 . #x975A)
                (#x8FE7B6 . #x975B)
                (#x8FE7B7 . #x9763)
                (#x8FE7B8 . #x9767)
                (#x8FE7B9 . #x976A)
                (#x8FE7BA . #x976E)
                (#x8FE7BB . #x9773)
                (#x8FE7BC . #x9776)
                (#x8FE7BD . #x9777)
                (#x8FE7BE . #x9778)
                (#x8FE7BF . #x977B)
                (#x8FE7C0 . #x977D)
                (#x8FE7C1 . #x977F)
                (#x8FE7C2 . #x9780)
                (#x8FE7C3 . #x9789)
                (#x8FE7C4 . #x9795)
                (#x8FE7C5 . #x9796)
                (#x8FE7C6 . #x9797)
                (#x8FE7C7 . #x9799)
                (#x8FE7C8 . #x979A)
                (#x8FE7C9 . #x979E)
                (#x8FE7CA . #x979F)
                (#x8FE7CB . #x97A2)
                (#x8FE7CC . #x97AC)
                (#x8FE7CD . #x97AE)
                (#x8FE7CE . #x97B1)
                (#x8FE7CF . #x97B2)
                (#x8FE7D0 . #x97B5)
                (#x8FE7D1 . #x97B6)
                (#x8FE7D2 . #x97B8)
                (#x8FE7D3 . #x97B9)
                (#x8FE7D4 . #x97BA)
                (#x8FE7D5 . #x97BC)
                (#x8FE7D6 . #x97BE)
                (#x8FE7D7 . #x97BF)
                (#x8FE7D8 . #x97C1)
                (#x8FE7D9 . #x97C4)
                (#x8FE7DA . #x97C5)
                (#x8FE7DB . #x97C7)
                (#x8FE7DC . #x97C9)
                (#x8FE7DD . #x97CA)
                (#x8FE7DE . #x97CC)
                (#x8FE7DF . #x97CD)
                (#x8FE7E0 . #x97CE)
                (#x8FE7E1 . #x97D0)
                (#x8FE7E2 . #x97D1)
                (#x8FE7E3 . #x97D4)
                (#x8FE7E4 . #x97D7)
                (#x8FE7E5 . #x97D8)
                (#x8FE7E6 . #x97D9)
                (#x8FE7E7 . #x97DD)
                (#x8FE7E8 . #x97DE)
                (#x8FE7E9 . #x97E0)
                (#x8FE7EA . #x97DB)
                (#x8FE7EB . #x97E1)
                (#x8FE7EC . #x97E4)
                (#x8FE7ED . #x97EF)
                (#x8FE7EE . #x97F1)
                (#x8FE7EF . #x97F4)
                (#x8FE7F0 . #x97F7)
                (#x8FE7F1 . #x97F8)
                (#x8FE7F2 . #x97FA)
                (#x8FE7F3 . #x9807)
                (#x8FE7F4 . #x980A)
                (#x8FE7F5 . #x9819)
                (#x8FE7F6 . #x980D)
                (#x8FE7F7 . #x980E)
                (#x8FE7F8 . #x9814)
                (#x8FE7F9 . #x9816)
                (#x8FE7FA . #x981C)
                (#x8FE7FB . #x981E)
                (#x8FE7FC . #x9820)
                (#x8FE7FD . #x9823)
                (#x8FE7FE . #x9826)
                (#x8FE8A1 . #x982B)
                (#x8FE8A2 . #x982E)
                (#x8FE8A3 . #x982F)
                (#x8FE8A4 . #x9830)
                (#x8FE8A5 . #x9832)
                (#x8FE8A6 . #x9833)
                (#x8FE8A7 . #x9835)
                (#x8FE8A8 . #x9825)
                (#x8FE8A9 . #x983E)
                (#x8FE8AA . #x9844)
                (#x8FE8AB . #x9847)
                (#x8FE8AC . #x984A)
                (#x8FE8AD . #x9851)
                (#x8FE8AE . #x9852)
                (#x8FE8AF . #x9853)
                (#x8FE8B0 . #x9856)
                (#x8FE8B1 . #x9857)
                (#x8FE8B2 . #x9859)
                (#x8FE8B3 . #x985A)
                (#x8FE8B4 . #x9862)
                (#x8FE8B5 . #x9863)
                (#x8FE8B6 . #x9865)
                (#x8FE8B7 . #x9866)
                (#x8FE8B8 . #x986A)
                (#x8FE8B9 . #x986C)
                (#x8FE8BA . #x98AB)
                (#x8FE8BB . #x98AD)
                (#x8FE8BC . #x98AE)
                (#x8FE8BD . #x98B0)
                (#x8FE8BE . #x98B4)
                (#x8FE8BF . #x98B7)
                (#x8FE8C0 . #x98B8)
                (#x8FE8C1 . #x98BA)
                (#x8FE8C2 . #x98BB)
                (#x8FE8C3 . #x98BF)
                (#x8FE8C4 . #x98C2)
                (#x8FE8C5 . #x98C5)
                (#x8FE8C6 . #x98C8)
                (#x8FE8C7 . #x98CC)
                (#x8FE8C8 . #x98E1)
                (#x8FE8C9 . #x98E3)
                (#x8FE8CA . #x98E5)
                (#x8FE8CB . #x98E6)
                (#x8FE8CC . #x98E7)
                (#x8FE8CD . #x98EA)
                (#x8FE8CE . #x98F3)
                (#x8FE8CF . #x98F6)
                (#x8FE8D0 . #x9902)
                (#x8FE8D1 . #x9907)
                (#x8FE8D2 . #x9908)
                (#x8FE8D3 . #x9911)
                (#x8FE8D4 . #x9915)
                (#x8FE8D5 . #x9916)
                (#x8FE8D6 . #x9917)
                (#x8FE8D7 . #x991A)
                (#x8FE8D8 . #x991B)
                (#x8FE8D9 . #x991C)
                (#x8FE8DA . #x991F)
                (#x8FE8DB . #x9922)
                (#x8FE8DC . #x9926)
                (#x8FE8DD . #x9927)
                (#x8FE8DE . #x992B)
                (#x8FE8DF . #x9931)
                (#x8FE8E0 . #x9932)
                (#x8FE8E1 . #x9933)
                (#x8FE8E2 . #x9934)
                (#x8FE8E3 . #x9935)
                (#x8FE8E4 . #x9939)
                (#x8FE8E5 . #x993A)
                (#x8FE8E6 . #x993B)
                (#x8FE8E7 . #x993C)
                (#x8FE8E8 . #x9940)
                (#x8FE8E9 . #x9941)
                (#x8FE8EA . #x9946)
                (#x8FE8EB . #x9947)
                (#x8FE8EC . #x9948)
                (#x8FE8ED . #x994D)
                (#x8FE8EE . #x994E)
                (#x8FE8EF . #x9954)
                (#x8FE8F0 . #x9958)
                (#x8FE8F1 . #x9959)
                (#x8FE8F2 . #x995B)
                (#x8FE8F3 . #x995C)
                (#x8FE8F4 . #x995E)
                (#x8FE8F5 . #x995F)
                (#x8FE8F6 . #x9960)
                (#x8FE8F7 . #x999B)
                (#x8FE8F8 . #x999D)
                (#x8FE8F9 . #x999F)
                (#x8FE8FA . #x99A6)
                (#x8FE8FB . #x99B0)
                (#x8FE8FC . #x99B1)
                (#x8FE8FD . #x99B2)
                (#x8FE8FE . #x99B5)
                (#x8FE9A1 . #x99B9)
                (#x8FE9A2 . #x99BA)
                (#x8FE9A3 . #x99BD)
                (#x8FE9A4 . #x99BF)
                (#x8FE9A5 . #x99C3)
                (#x8FE9A6 . #x99C9)
                (#x8FE9A7 . #x99D3)
                (#x8FE9A8 . #x99D4)
                (#x8FE9A9 . #x99D9)
                (#x8FE9AA . #x99DA)
                (#x8FE9AB . #x99DC)
                (#x8FE9AC . #x99DE)
                (#x8FE9AD . #x99E7)
                (#x8FE9AE . #x99EA)
                (#x8FE9AF . #x99EB)
                (#x8FE9B0 . #x99EC)
                (#x8FE9B1 . #x99F0)
                (#x8FE9B2 . #x99F4)
                (#x8FE9B3 . #x99F5)
                (#x8FE9B4 . #x99F9)
                (#x8FE9B5 . #x99FD)
                (#x8FE9B6 . #x99FE)
                (#x8FE9B7 . #x9A02)
                (#x8FE9B8 . #x9A03)
                (#x8FE9B9 . #x9A04)
                (#x8FE9BA . #x9A0B)
                (#x8FE9BB . #x9A0C)
                (#x8FE9BC . #x9A10)
                (#x8FE9BD . #x9A11)
                (#x8FE9BE . #x9A16)
                (#x8FE9BF . #x9A1E)
                (#x8FE9C0 . #x9A20)
                (#x8FE9C1 . #x9A22)
                (#x8FE9C2 . #x9A23)
                (#x8FE9C3 . #x9A24)
                (#x8FE9C4 . #x9A27)
                (#x8FE9C5 . #x9A2D)
                (#x8FE9C6 . #x9A2E)
                (#x8FE9C7 . #x9A33)
                (#x8FE9C8 . #x9A35)
                (#x8FE9C9 . #x9A36)
                (#x8FE9CA . #x9A38)
                (#x8FE9CB . #x9A47)
                (#x8FE9CC . #x9A41)
                (#x8FE9CD . #x9A44)
                (#x8FE9CE . #x9A4A)
                (#x8FE9CF . #x9A4B)
                (#x8FE9D0 . #x9A4C)
                (#x8FE9D1 . #x9A4E)
                (#x8FE9D2 . #x9A51)
                (#x8FE9D3 . #x9A54)
                (#x8FE9D4 . #x9A56)
                (#x8FE9D5 . #x9A5D)
                (#x8FE9D6 . #x9AAA)
                (#x8FE9D7 . #x9AAC)
                (#x8FE9D8 . #x9AAE)
                (#x8FE9D9 . #x9AAF)
                (#x8FE9DA . #x9AB2)
                (#x8FE9DB . #x9AB4)
                (#x8FE9DC . #x9AB5)
                (#x8FE9DD . #x9AB6)
                (#x8FE9DE . #x9AB9)
                (#x8FE9DF . #x9ABB)
                (#x8FE9E0 . #x9ABE)
                (#x8FE9E1 . #x9ABF)
                (#x8FE9E2 . #x9AC1)
                (#x8FE9E3 . #x9AC3)
                (#x8FE9E4 . #x9AC6)
                (#x8FE9E5 . #x9AC8)
                (#x8FE9E6 . #x9ACE)
                (#x8FE9E7 . #x9AD0)
                (#x8FE9E8 . #x9AD2)
                (#x8FE9E9 . #x9AD5)
                (#x8FE9EA . #x9AD6)
                (#x8FE9EB . #x9AD7)
                (#x8FE9EC . #x9ADB)
                (#x8FE9ED . #x9ADC)
                (#x8FE9EE . #x9AE0)
                (#x8FE9EF . #x9AE4)
                (#x8FE9F0 . #x9AE5)
                (#x8FE9F1 . #x9AE7)
                (#x8FE9F2 . #x9AE9)
                (#x8FE9F3 . #x9AEC)
                (#x8FE9F4 . #x9AF2)
                (#x8FE9F5 . #x9AF3)
                (#x8FE9F6 . #x9AF5)
                (#x8FE9F7 . #x9AF9)
                (#x8FE9F8 . #x9AFA)
                (#x8FE9F9 . #x9AFD)
                (#x8FE9FA . #x9AFF)
                (#x8FE9FB . #x9B00)
                (#x8FE9FC . #x9B01)
                (#x8FE9FD . #x9B02)
                (#x8FE9FE . #x9B03)
                (#x8FEAA1 . #x9B04)
                (#x8FEAA2 . #x9B05)
                (#x8FEAA3 . #x9B08)
                (#x8FEAA4 . #x9B09)
                (#x8FEAA5 . #x9B0B)
                (#x8FEAA6 . #x9B0C)
                (#x8FEAA7 . #x9B0D)
                (#x8FEAA8 . #x9B0E)
                (#x8FEAA9 . #x9B10)
                (#x8FEAAA . #x9B12)
                (#x8FEAAB . #x9B16)
                (#x8FEAAC . #x9B19)
                (#x8FEAAD . #x9B1B)
                (#x8FEAAE . #x9B1C)
                (#x8FEAAF . #x9B20)
                (#x8FEAB0 . #x9B26)
                (#x8FEAB1 . #x9B2B)
                (#x8FEAB2 . #x9B2D)
                (#x8FEAB3 . #x9B33)
                (#x8FEAB4 . #x9B34)
                (#x8FEAB5 . #x9B35)
                (#x8FEAB6 . #x9B37)
                (#x8FEAB7 . #x9B39)
                (#x8FEAB8 . #x9B3A)
                (#x8FEAB9 . #x9B3D)
                (#x8FEABA . #x9B48)
                (#x8FEABB . #x9B4B)
                (#x8FEABC . #x9B4C)
                (#x8FEABD . #x9B55)
                (#x8FEABE . #x9B56)
                (#x8FEABF . #x9B57)
                (#x8FEAC0 . #x9B5B)
                (#x8FEAC1 . #x9B5E)
                (#x8FEAC2 . #x9B61)
                (#x8FEAC3 . #x9B63)
                (#x8FEAC4 . #x9B65)
                (#x8FEAC5 . #x9B66)
                (#x8FEAC6 . #x9B68)
                (#x8FEAC7 . #x9B6A)
                (#x8FEAC8 . #x9B6B)
                (#x8FEAC9 . #x9B6C)
                (#x8FEACA . #x9B6D)
                (#x8FEACB . #x9B6E)
                (#x8FEACC . #x9B73)
                (#x8FEACD . #x9B75)
                (#x8FEACE . #x9B77)
                (#x8FEACF . #x9B78)
                (#x8FEAD0 . #x9B79)
                (#x8FEAD1 . #x9B7F)
                (#x8FEAD2 . #x9B80)
                (#x8FEAD3 . #x9B84)
                (#x8FEAD4 . #x9B85)
                (#x8FEAD5 . #x9B86)
                (#x8FEAD6 . #x9B87)
                (#x8FEAD7 . #x9B89)
                (#x8FEAD8 . #x9B8A)
                (#x8FEAD9 . #x9B8B)
                (#x8FEADA . #x9B8D)
                (#x8FEADB . #x9B8F)
                (#x8FEADC . #x9B90)
                (#x8FEADD . #x9B94)
                (#x8FEADE . #x9B9A)
                (#x8FEADF . #x9B9D)
                (#x8FEAE0 . #x9B9E)
                (#x8FEAE1 . #x9BA6)
                (#x8FEAE2 . #x9BA7)
                (#x8FEAE3 . #x9BA9)
                (#x8FEAE4 . #x9BAC)
                (#x8FEAE5 . #x9BB0)
                (#x8FEAE6 . #x9BB1)
                (#x8FEAE7 . #x9BB2)
                (#x8FEAE8 . #x9BB7)
                (#x8FEAE9 . #x9BB8)
                (#x8FEAEA . #x9BBB)
                (#x8FEAEB . #x9BBC)
                (#x8FEAEC . #x9BBE)
                (#x8FEAED . #x9BBF)
                (#x8FEAEE . #x9BC1)
                (#x8FEAEF . #x9BC7)
                (#x8FEAF0 . #x9BC8)
                (#x8FEAF1 . #x9BCE)
                (#x8FEAF2 . #x9BD0)
                (#x8FEAF3 . #x9BD7)
                (#x8FEAF4 . #x9BD8)
                (#x8FEAF5 . #x9BDD)
                (#x8FEAF6 . #x9BDF)
                (#x8FEAF7 . #x9BE5)
                (#x8FEAF8 . #x9BE7)
                (#x8FEAF9 . #x9BEA)
                (#x8FEAFA . #x9BEB)
                (#x8FEAFB . #x9BEF)
                (#x8FEAFC . #x9BF3)
                (#x8FEAFD . #x9BF7)
                (#x8FEAFE . #x9BF8)
                (#x8FEBA1 . #x9BF9)
                (#x8FEBA2 . #x9BFA)
                (#x8FEBA3 . #x9BFD)
                (#x8FEBA4 . #x9BFF)
                (#x8FEBA5 . #x9C00)
                (#x8FEBA6 . #x9C02)
                (#x8FEBA7 . #x9C0B)
                (#x8FEBA8 . #x9C0F)
                (#x8FEBA9 . #x9C11)
                (#x8FEBAA . #x9C16)
                (#x8FEBAB . #x9C18)
                (#x8FEBAC . #x9C19)
                (#x8FEBAD . #x9C1A)
                (#x8FEBAE . #x9C1C)
                (#x8FEBAF . #x9C1E)
                (#x8FEBB0 . #x9C22)
                (#x8FEBB1 . #x9C23)
                (#x8FEBB2 . #x9C26)
                (#x8FEBB3 . #x9C27)
                (#x8FEBB4 . #x9C28)
                (#x8FEBB5 . #x9C29)
                (#x8FEBB6 . #x9C2A)
                (#x8FEBB7 . #x9C31)
                (#x8FEBB8 . #x9C35)
                (#x8FEBB9 . #x9C36)
                (#x8FEBBA . #x9C37)
                (#x8FEBBB . #x9C3D)
                (#x8FEBBC . #x9C41)
                (#x8FEBBD . #x9C43)
                (#x8FEBBE . #x9C44)
                (#x8FEBBF . #x9C45)
                (#x8FEBC0 . #x9C49)
                (#x8FEBC1 . #x9C4A)
                (#x8FEBC2 . #x9C4E)
                (#x8FEBC3 . #x9C4F)
                (#x8FEBC4 . #x9C50)
                (#x8FEBC5 . #x9C53)
                (#x8FEBC6 . #x9C54)
                (#x8FEBC7 . #x9C56)
                (#x8FEBC8 . #x9C58)
                (#x8FEBC9 . #x9C5B)
                (#x8FEBCA . #x9C5D)
                (#x8FEBCB . #x9C5E)
                (#x8FEBCC . #x9C5F)
                (#x8FEBCD . #x9C63)
                (#x8FEBCE . #x9C69)
                (#x8FEBCF . #x9C6A)
                (#x8FEBD0 . #x9C5C)
                (#x8FEBD1 . #x9C6B)
                (#x8FEBD2 . #x9C68)
                (#x8FEBD3 . #x9C6E)
                (#x8FEBD4 . #x9C70)
                (#x8FEBD5 . #x9C72)
                (#x8FEBD6 . #x9C75)
                (#x8FEBD7 . #x9C77)
                (#x8FEBD8 . #x9C7B)
                (#x8FEBD9 . #x9CE6)
                (#x8FEBDA . #x9CF2)
                (#x8FEBDB . #x9CF7)
                (#x8FEBDC . #x9CF9)
                (#x8FEBDD . #x9D0B)
                (#x8FEBDE . #x9D02)
                (#x8FEBDF . #x9D11)
                (#x8FEBE0 . #x9D17)
                (#x8FEBE1 . #x9D18)
                (#x8FEBE2 . #x9D1C)
                (#x8FEBE3 . #x9D1D)
                (#x8FEBE4 . #x9D1E)
                (#x8FEBE5 . #x9D2F)
                (#x8FEBE6 . #x9D30)
                (#x8FEBE7 . #x9D32)
                (#x8FEBE8 . #x9D33)
                (#x8FEBE9 . #x9D34)
                (#x8FEBEA . #x9D3A)
                (#x8FEBEB . #x9D3C)
                (#x8FEBEC . #x9D45)
                (#x8FEBED . #x9D3D)
                (#x8FEBEE . #x9D42)
                (#x8FEBEF . #x9D43)
                (#x8FEBF0 . #x9D47)
                (#x8FEBF1 . #x9D4A)
                (#x8FEBF2 . #x9D53)
                (#x8FEBF3 . #x9D54)
                (#x8FEBF4 . #x9D5F)
                (#x8FEBF5 . #x9D63)
                (#x8FEBF6 . #x9D62)
                (#x8FEBF7 . #x9D65)
                (#x8FEBF8 . #x9D69)
                (#x8FEBF9 . #x9D6A)
                (#x8FEBFA . #x9D6B)
                (#x8FEBFB . #x9D70)
                (#x8FEBFC . #x9D76)
                (#x8FEBFD . #x9D77)
                (#x8FEBFE . #x9D7B)
                (#x8FECA1 . #x9D7C)
                (#x8FECA2 . #x9D7E)
                (#x8FECA3 . #x9D83)
                (#x8FECA4 . #x9D84)
                (#x8FECA5 . #x9D86)
                (#x8FECA6 . #x9D8A)
                (#x8FECA7 . #x9D8D)
                (#x8FECA8 . #x9D8E)
                (#x8FECA9 . #x9D92)
                (#x8FECAA . #x9D93)
                (#x8FECAB . #x9D95)
                (#x8FECAC . #x9D96)
                (#x8FECAD . #x9D97)
                (#x8FECAE . #x9D98)
                (#x8FECAF . #x9DA1)
                (#x8FECB0 . #x9DAA)
                (#x8FECB1 . #x9DAC)
                (#x8FECB2 . #x9DAE)
                (#x8FECB3 . #x9DB1)
                (#x8FECB4 . #x9DB5)
                (#x8FECB5 . #x9DB9)
                (#x8FECB6 . #x9DBC)
                (#x8FECB7 . #x9DBF)
                (#x8FECB8 . #x9DC3)
                (#x8FECB9 . #x9DC7)
                (#x8FECBA . #x9DC9)
                (#x8FECBB . #x9DCA)
                (#x8FECBC . #x9DD4)
                (#x8FECBD . #x9DD5)
                (#x8FECBE . #x9DD6)
                (#x8FECBF . #x9DD7)
                (#x8FECC0 . #x9DDA)
                (#x8FECC1 . #x9DDE)
                (#x8FECC2 . #x9DDF)
                (#x8FECC3 . #x9DE0)
                (#x8FECC4 . #x9DE5)
                (#x8FECC5 . #x9DE7)
                (#x8FECC6 . #x9DE9)
                (#x8FECC7 . #x9DEB)
                (#x8FECC8 . #x9DEE)
                (#x8FECC9 . #x9DF0)
                (#x8FECCA . #x9DF3)
                (#x8FECCB . #x9DF4)
                (#x8FECCC . #x9DFE)
                (#x8FECCD . #x9E0A)
                (#x8FECCE . #x9E02)
                (#x8FECCF . #x9E07)
                (#x8FECD0 . #x9E0E)
                (#x8FECD1 . #x9E10)
                (#x8FECD2 . #x9E11)
                (#x8FECD3 . #x9E12)
                (#x8FECD4 . #x9E15)
                (#x8FECD5 . #x9E16)
                (#x8FECD6 . #x9E19)
                (#x8FECD7 . #x9E1C)
                (#x8FECD8 . #x9E1D)
                (#x8FECD9 . #x9E7A)
                (#x8FECDA . #x9E7B)
                (#x8FECDB . #x9E7C)
                (#x8FECDC . #x9E80)
                (#x8FECDD . #x9E82)
                (#x8FECDE . #x9E83)
                (#x8FECDF . #x9E84)
                (#x8FECE0 . #x9E85)
                (#x8FECE1 . #x9E87)
                (#x8FECE2 . #x9E8E)
                (#x8FECE3 . #x9E8F)
                (#x8FECE4 . #x9E96)
                (#x8FECE5 . #x9E98)
                (#x8FECE6 . #x9E9B)
                (#x8FECE7 . #x9E9E)
                (#x8FECE8 . #x9EA4)
                (#x8FECE9 . #x9EA8)
                (#x8FECEA . #x9EAC)
                (#x8FECEB . #x9EAE)
                (#x8FECEC . #x9EAF)
                (#x8FECED . #x9EB0)
                (#x8FECEE . #x9EB3)
                (#x8FECEF . #x9EB4)
                (#x8FECF0 . #x9EB5)
                (#x8FECF1 . #x9EC6)
                (#x8FECF2 . #x9EC8)
                (#x8FECF3 . #x9ECB)
                (#x8FECF4 . #x9ED5)
                (#x8FECF5 . #x9EDF)
                (#x8FECF6 . #x9EE4)
                (#x8FECF7 . #x9EE7)
                (#x8FECF8 . #x9EEC)
                (#x8FECF9 . #x9EED)
                (#x8FECFA . #x9EEE)
                (#x8FECFB . #x9EF0)
                (#x8FECFC . #x9EF1)
                (#x8FECFD . #x9EF2)
                (#x8FECFE . #x9EF5)
                (#x8FEDA1 . #x9EF8)
                (#x8FEDA2 . #x9EFF)
                (#x8FEDA3 . #x9F02)
                (#x8FEDA4 . #x9F03)
                (#x8FEDA5 . #x9F09)
                (#x8FEDA6 . #x9F0F)
                (#x8FEDA7 . #x9F10)
                (#x8FEDA8 . #x9F11)
                (#x8FEDA9 . #x9F12)
                (#x8FEDAA . #x9F14)
                (#x8FEDAB . #x9F16)
                (#x8FEDAC . #x9F17)
                (#x8FEDAD . #x9F19)
                (#x8FEDAE . #x9F1A)
                (#x8FEDAF . #x9F1B)
                (#x8FEDB0 . #x9F1F)
                (#x8FEDB1 . #x9F22)
                (#x8FEDB2 . #x9F26)
                (#x8FEDB3 . #x9F2A)
                (#x8FEDB4 . #x9F2B)
                (#x8FEDB5 . #x9F2F)
                (#x8FEDB6 . #x9F31)
                (#x8FEDB7 . #x9F32)
                (#x8FEDB8 . #x9F34)
                (#x8FEDB9 . #x9F37)
                (#x8FEDBA . #x9F39)
                (#x8FEDBB . #x9F3A)
                (#x8FEDBC . #x9F3C)
                (#x8FEDBD . #x9F3D)
                (#x8FEDBE . #x9F3F)
                (#x8FEDBF . #x9F41)
                (#x8FEDC0 . #x9F43)
                (#x8FEDC1 . #x9F44)
                (#x8FEDC2 . #x9F45)
                (#x8FEDC3 . #x9F46)
                (#x8FEDC4 . #x9F47)
                (#x8FEDC5 . #x9F53)
                (#x8FEDC6 . #x9F55)
                (#x8FEDC7 . #x9F56)
                (#x8FEDC8 . #x9F57)
                (#x8FEDC9 . #x9F58)
                (#x8FEDCA . #x9F5A)
                (#x8FEDCB . #x9F5D)
                (#x8FEDCC . #x9F5E)
                (#x8FEDCD . #x9F68)
                (#x8FEDCE . #x9F69)
                (#x8FEDCF . #x9F6D)
                (#x8FEDD0 . #x9F6E)
                (#x8FEDD1 . #x9F6F)
                (#x8FEDD2 . #x9F70)
                (#x8FEDD3 . #x9F71)
                (#x8FEDD4 . #x9F73)
                (#x8FEDD5 . #x9F75)
                (#x8FEDD6 . #x9F7A)
                (#x8FEDD7 . #x9F7D)
                (#x8FEDD8 . #x9F8F)
                (#x8FEDD9 . #x9F90)
                (#x8FEDDA . #x9F91)
                (#x8FEDDB . #x9F92)
                (#x8FEDDC . #x9F94)
                (#x8FEDDD . #x9F96)
                (#x8FEDDE . #x9F97)
                (#x8FEDDF . #x9F9E)
                (#x8FEDE0 . #x9FA1)
                (#x8FEDE1 . #x9FA2)
                (#x8FEDE2 . #x9FA3)
                (#x8FEDE3 . #x9FA5)
                (#x8FF5A1 . #xE3AC)
                (#x8FF5A2 . #xE3AD)
                (#x8FF5A3 . #xE3AE)
                (#x8FF5A4 . #xE3AF)
                (#x8FF5A5 . #xE3B0)
                (#x8FF5A6 . #xE3B1)
                (#x8FF5A7 . #xE3B2)
                (#x8FF5A8 . #xE3B3)
                (#x8FF5A9 . #xE3B4)
                (#x8FF5AA . #xE3B5)
                (#x8FF5AB . #xE3B6)
                (#x8FF5AC . #xE3B7)
                (#x8FF5AD . #xE3B8)
                (#x8FF5AE . #xE3B9)
                (#x8FF5AF . #xE3BA)
                (#x8FF5B0 . #xE3BB)
                (#x8FF5B1 . #xE3BC)
                (#x8FF5B2 . #xE3BD)
                (#x8FF5B3 . #xE3BE)
                (#x8FF5B4 . #xE3BF)
                (#x8FF5B5 . #xE3C0)
                (#x8FF5B6 . #xE3C1)
                (#x8FF5B7 . #xE3C2)
                (#x8FF5B8 . #xE3C3)
                (#x8FF5B9 . #xE3C4)
                (#x8FF5BA . #xE3C5)
                (#x8FF5BB . #xE3C6)
                (#x8FF5BC . #xE3C7)
                (#x8FF5BD . #xE3C8)
                (#x8FF5BE . #xE3C9)
                (#x8FF5BF . #xE3CA)
                (#x8FF5C0 . #xE3CB)
                (#x8FF5C1 . #xE3CC)
                (#x8FF5C2 . #xE3CD)
                (#x8FF5C3 . #xE3CE)
                (#x8FF5C4 . #xE3CF)
                (#x8FF5C5 . #xE3D0)
                (#x8FF5C6 . #xE3D1)
                (#x8FF5C7 . #xE3D2)
                (#x8FF5C8 . #xE3D3)
                (#x8FF5C9 . #xE3D4)
                (#x8FF5CA . #xE3D5)
                (#x8FF5CB . #xE3D6)
                (#x8FF5CC . #xE3D7)
                (#x8FF5CD . #xE3D8)
                (#x8FF5CE . #xE3D9)
                (#x8FF5CF . #xE3DA)
                (#x8FF5D0 . #xE3DB)
                (#x8FF5D1 . #xE3DC)
                (#x8FF5D2 . #xE3DD)
                (#x8FF5D3 . #xE3DE)
                (#x8FF5D4 . #xE3DF)
                (#x8FF5D5 . #xE3E0)
                (#x8FF5D6 . #xE3E1)
                (#x8FF5D7 . #xE3E2)
                (#x8FF5D8 . #xE3E3)
                (#x8FF5D9 . #xE3E4)
                (#x8FF5DA . #xE3E5)
                (#x8FF5DB . #xE3E6)
                (#x8FF5DC . #xE3E7)
                (#x8FF5DD . #xE3E8)
                (#x8FF5DE . #xE3E9)
                (#x8FF5DF . #xE3EA)
                (#x8FF5E0 . #xE3EB)
                (#x8FF5E1 . #xE3EC)
                (#x8FF5E2 . #xE3ED)
                (#x8FF5E3 . #xE3EE)
                (#x8FF5E4 . #xE3EF)
                (#x8FF5E5 . #xE3F0)
                (#x8FF5E6 . #xE3F1)
                (#x8FF5E7 . #xE3F2)
                (#x8FF5E8 . #xE3F3)
                (#x8FF5E9 . #xE3F4)
                (#x8FF5EA . #xE3F5)
                (#x8FF5EB . #xE3F6)
                (#x8FF5EC . #xE3F7)
                (#x8FF5ED . #xE3F8)
                (#x8FF5EE . #xE3F9)
                (#x8FF5EF . #xE3FA)
                (#x8FF5F0 . #xE3FB)
                (#x8FF5F1 . #xE3FC)
                (#x8FF5F2 . #xE3FD)
                (#x8FF5F3 . #xE3FE)
                (#x8FF5F4 . #xE3FF)
                (#x8FF5F5 . #xE400)
                (#x8FF5F6 . #xE401)
                (#x8FF5F7 . #xE402)
                (#x8FF5F8 . #xE403)
                (#x8FF5F9 . #xE404)
                (#x8FF5FA . #xE405)
                (#x8FF5FB . #xE406)
                (#x8FF5FC . #xE407)
                (#x8FF5FD . #xE408)
                (#x8FF5FE . #xE409)
                (#x8FF6A1 . #xE40A)
                (#x8FF6A2 . #xE40B)
                (#x8FF6A3 . #xE40C)
                (#x8FF6A4 . #xE40D)
                (#x8FF6A5 . #xE40E)
                (#x8FF6A6 . #xE40F)
                (#x8FF6A7 . #xE410)
                (#x8FF6A8 . #xE411)
                (#x8FF6A9 . #xE412)
                (#x8FF6AA . #xE413)
                (#x8FF6AB . #xE414)
                (#x8FF6AC . #xE415)
                (#x8FF6AD . #xE416)
                (#x8FF6AE . #xE417)
                (#x8FF6AF . #xE418)
                (#x8FF6B0 . #xE419)
                (#x8FF6B1 . #xE41A)
                (#x8FF6B2 . #xE41B)
                (#x8FF6B3 . #xE41C)
                (#x8FF6B4 . #xE41D)
                (#x8FF6B5 . #xE41E)
                (#x8FF6B6 . #xE41F)
                (#x8FF6B7 . #xE420)
                (#x8FF6B8 . #xE421)
                (#x8FF6B9 . #xE422)
                (#x8FF6BA . #xE423)
                (#x8FF6BB . #xE424)
                (#x8FF6BC . #xE425)
                (#x8FF6BD . #xE426)
                (#x8FF6BE . #xE427)
                (#x8FF6BF . #xE428)
                (#x8FF6C0 . #xE429)
                (#x8FF6C1 . #xE42A)
                (#x8FF6C2 . #xE42B)
                (#x8FF6C3 . #xE42C)
                (#x8FF6C4 . #xE42D)
                (#x8FF6C5 . #xE42E)
                (#x8FF6C6 . #xE42F)
                (#x8FF6C7 . #xE430)
                (#x8FF6C8 . #xE431)
                (#x8FF6C9 . #xE432)
                (#x8FF6CA . #xE433)
                (#x8FF6CB . #xE434)
                (#x8FF6CC . #xE435)
                (#x8FF6CD . #xE436)
                (#x8FF6CE . #xE437)
                (#x8FF6CF . #xE438)
                (#x8FF6D0 . #xE439)
                (#x8FF6D1 . #xE43A)
                (#x8FF6D2 . #xE43B)
                (#x8FF6D3 . #xE43C)
                (#x8FF6D4 . #xE43D)
                (#x8FF6D5 . #xE43E)
                (#x8FF6D6 . #xE43F)
                (#x8FF6D7 . #xE440)
                (#x8FF6D8 . #xE441)
                (#x8FF6D9 . #xE442)
                (#x8FF6DA . #xE443)
                (#x8FF6DB . #xE444)
                (#x8FF6DC . #xE445)
                (#x8FF6DD . #xE446)
                (#x8FF6DE . #xE447)
                (#x8FF6DF . #xE448)
                (#x8FF6E0 . #xE449)
                (#x8FF6E1 . #xE44A)
                (#x8FF6E2 . #xE44B)
                (#x8FF6E3 . #xE44C)
                (#x8FF6E4 . #xE44D)
                (#x8FF6E5 . #xE44E)
                (#x8FF6E6 . #xE44F)
                (#x8FF6E7 . #xE450)
                (#x8FF6E8 . #xE451)
                (#x8FF6E9 . #xE452)
                (#x8FF6EA . #xE453)
                (#x8FF6EB . #xE454)
                (#x8FF6EC . #xE455)
                (#x8FF6ED . #xE456)
                (#x8FF6EE . #xE457)
                (#x8FF6EF . #xE458)
                (#x8FF6F0 . #xE459)
                (#x8FF6F1 . #xE45A)
                (#x8FF6F2 . #xE45B)
                (#x8FF6F3 . #xE45C)
                (#x8FF6F4 . #xE45D)
                (#x8FF6F5 . #xE45E)
                (#x8FF6F6 . #xE45F)
                (#x8FF6F7 . #xE460)
                (#x8FF6F8 . #xE461)
                (#x8FF6F9 . #xE462)
                (#x8FF6FA . #xE463)
                (#x8FF6FB . #xE464)
                (#x8FF6FC . #xE465)
                (#x8FF6FD . #xE466)
                (#x8FF6FE . #xE467)
                (#x8FF7A1 . #xE468)
                (#x8FF7A2 . #xE469)
                (#x8FF7A3 . #xE46A)
                (#x8FF7A4 . #xE46B)
                (#x8FF7A5 . #xE46C)
                (#x8FF7A6 . #xE46D)
                (#x8FF7A7 . #xE46E)
                (#x8FF7A8 . #xE46F)
                (#x8FF7A9 . #xE470)
                (#x8FF7AA . #xE471)
                (#x8FF7AB . #xE472)
                (#x8FF7AC . #xE473)
                (#x8FF7AD . #xE474)
                (#x8FF7AE . #xE475)
                (#x8FF7AF . #xE476)
                (#x8FF7B0 . #xE477)
                (#x8FF7B1 . #xE478)
                (#x8FF7B2 . #xE479)
                (#x8FF7B3 . #xE47A)
                (#x8FF7B4 . #xE47B)
                (#x8FF7B5 . #xE47C)
                (#x8FF7B6 . #xE47D)
                (#x8FF7B7 . #xE47E)
                (#x8FF7B8 . #xE47F)
                (#x8FF7B9 . #xE480)
                (#x8FF7BA . #xE481)
                (#x8FF7BB . #xE482)
                (#x8FF7BC . #xE483)
                (#x8FF7BD . #xE484)
                (#x8FF7BE . #xE485)
                (#x8FF7BF . #xE486)
                (#x8FF7C0 . #xE487)
                (#x8FF7C1 . #xE488)
                (#x8FF7C2 . #xE489)
                (#x8FF7C3 . #xE48A)
                (#x8FF7C4 . #xE48B)
                (#x8FF7C5 . #xE48C)
                (#x8FF7C6 . #xE48D)
                (#x8FF7C7 . #xE48E)
                (#x8FF7C8 . #xE48F)
                (#x8FF7C9 . #xE490)
                (#x8FF7CA . #xE491)
                (#x8FF7CB . #xE492)
                (#x8FF7CC . #xE493)
                (#x8FF7CD . #xE494)
                (#x8FF7CE . #xE495)
                (#x8FF7CF . #xE496)
                (#x8FF7D0 . #xE497)
                (#x8FF7D1 . #xE498)
                (#x8FF7D2 . #xE499)
                (#x8FF7D3 . #xE49A)
                (#x8FF7D4 . #xE49B)
                (#x8FF7D5 . #xE49C)
                (#x8FF7D6 . #xE49D)
                (#x8FF7D7 . #xE49E)
                (#x8FF7D8 . #xE49F)
                (#x8FF7D9 . #xE4A0)
                (#x8FF7DA . #xE4A1)
                (#x8FF7DB . #xE4A2)
                (#x8FF7DC . #xE4A3)
                (#x8FF7DD . #xE4A4)
                (#x8FF7DE . #xE4A5)
                (#x8FF7DF . #xE4A6)
                (#x8FF7E0 . #xE4A7)
                (#x8FF7E1 . #xE4A8)
                (#x8FF7E2 . #xE4A9)
                (#x8FF7E3 . #xE4AA)
                (#x8FF7E4 . #xE4AB)
                (#x8FF7E5 . #xE4AC)
                (#x8FF7E6 . #xE4AD)
                (#x8FF7E7 . #xE4AE)
                (#x8FF7E8 . #xE4AF)
                (#x8FF7E9 . #xE4B0)
                (#x8FF7EA . #xE4B1)
                (#x8FF7EB . #xE4B2)
                (#x8FF7EC . #xE4B3)
                (#x8FF7ED . #xE4B4)
                (#x8FF7EE . #xE4B5)
                (#x8FF7EF . #xE4B6)
                (#x8FF7F0 . #xE4B7)
                (#x8FF7F1 . #xE4B8)
                (#x8FF7F2 . #xE4B9)
                (#x8FF7F3 . #xE4BA)
                (#x8FF7F4 . #xE4BB)
                (#x8FF7F5 . #xE4BC)
                (#x8FF7F6 . #xE4BD)
                (#x8FF7F7 . #xE4BE)
                (#x8FF7F8 . #xE4BF)
                (#x8FF7F9 . #xE4C0)
                (#x8FF7FA . #xE4C1)
                (#x8FF7FB . #xE4C2)
                (#x8FF7FC . #xE4C3)
                (#x8FF7FD . #xE4C4)
                (#x8FF7FE . #xE4C5)
                (#x8FF8A1 . #xE4C6)
                (#x8FF8A2 . #xE4C7)
                (#x8FF8A3 . #xE4C8)
                (#x8FF8A4 . #xE4C9)
                (#x8FF8A5 . #xE4CA)
                (#x8FF8A6 . #xE4CB)
                (#x8FF8A7 . #xE4CC)
                (#x8FF8A8 . #xE4CD)
                (#x8FF8A9 . #xE4CE)
                (#x8FF8AA . #xE4CF)
                (#x8FF8AB . #xE4D0)
                (#x8FF8AC . #xE4D1)
                (#x8FF8AD . #xE4D2)
                (#x8FF8AE . #xE4D3)
                (#x8FF8AF . #xE4D4)
                (#x8FF8B0 . #xE4D5)
                (#x8FF8B1 . #xE4D6)
                (#x8FF8B2 . #xE4D7)
                (#x8FF8B3 . #xE4D8)
                (#x8FF8B4 . #xE4D9)
                (#x8FF8B5 . #xE4DA)
                (#x8FF8B6 . #xE4DB)
                (#x8FF8B7 . #xE4DC)
                (#x8FF8B8 . #xE4DD)
                (#x8FF8B9 . #xE4DE)
                (#x8FF8BA . #xE4DF)
                (#x8FF8BB . #xE4E0)
                (#x8FF8BC . #xE4E1)
                (#x8FF8BD . #xE4E2)
                (#x8FF8BE . #xE4E3)
                (#x8FF8BF . #xE4E4)
                (#x8FF8C0 . #xE4E5)
                (#x8FF8C1 . #xE4E6)
                (#x8FF8C2 . #xE4E7)
                (#x8FF8C3 . #xE4E8)
                (#x8FF8C4 . #xE4E9)
                (#x8FF8C5 . #xE4EA)
                (#x8FF8C6 . #xE4EB)
                (#x8FF8C7 . #xE4EC)
                (#x8FF8C8 . #xE4ED)
                (#x8FF8C9 . #xE4EE)
                (#x8FF8CA . #xE4EF)
                (#x8FF8CB . #xE4F0)
                (#x8FF8CC . #xE4F1)
                (#x8FF8CD . #xE4F2)
                (#x8FF8CE . #xE4F3)
                (#x8FF8CF . #xE4F4)
                (#x8FF8D0 . #xE4F5)
                (#x8FF8D1 . #xE4F6)
                (#x8FF8D2 . #xE4F7)
                (#x8FF8D3 . #xE4F8)
                (#x8FF8D4 . #xE4F9)
                (#x8FF8D5 . #xE4FA)
                (#x8FF8D6 . #xE4FB)
                (#x8FF8D7 . #xE4FC)
                (#x8FF8D8 . #xE4FD)
                (#x8FF8D9 . #xE4FE)
                (#x8FF8DA . #xE4FF)
                (#x8FF8DB . #xE500)
                (#x8FF8DC . #xE501)
                (#x8FF8DD . #xE502)
                (#x8FF8DE . #xE503)
                (#x8FF8DF . #xE504)
                (#x8FF8E0 . #xE505)
                (#x8FF8E1 . #xE506)
                (#x8FF8E2 . #xE507)
                (#x8FF8E3 . #xE508)
                (#x8FF8E4 . #xE509)
                (#x8FF8E5 . #xE50A)
                (#x8FF8E6 . #xE50B)
                (#x8FF8E7 . #xE50C)
                (#x8FF8E8 . #xE50D)
                (#x8FF8E9 . #xE50E)
                (#x8FF8EA . #xE50F)
                (#x8FF8EB . #xE510)
                (#x8FF8EC . #xE511)
                (#x8FF8ED . #xE512)
                (#x8FF8EE . #xE513)
                (#x8FF8EF . #xE514)
                (#x8FF8F0 . #xE515)
                (#x8FF8F1 . #xE516)
                (#x8FF8F2 . #xE517)
                (#x8FF8F3 . #xE518)
                (#x8FF8F4 . #xE519)
                (#x8FF8F5 . #xE51A)
                (#x8FF8F6 . #xE51B)
                (#x8FF8F7 . #xE51C)
                (#x8FF8F8 . #xE51D)
                (#x8FF8F9 . #xE51E)
                (#x8FF8FA . #xE51F)
                (#x8FF8FB . #xE520)
                (#x8FF8FC . #xE521)
                (#x8FF8FD . #xE522)
                (#x8FF8FE . #xE523)
                (#x8FF9A1 . #xE524)
                (#x8FF9A2 . #xE525)
                (#x8FF9A3 . #xE526)
                (#x8FF9A4 . #xE527)
                (#x8FF9A5 . #xE528)
                (#x8FF9A6 . #xE529)
                (#x8FF9A7 . #xE52A)
                (#x8FF9A8 . #xE52B)
                (#x8FF9A9 . #xE52C)
                (#x8FF9AA . #xE52D)
                (#x8FF9AB . #xE52E)
                (#x8FF9AC . #xE52F)
                (#x8FF9AD . #xE530)
                (#x8FF9AE . #xE531)
                (#x8FF9AF . #xE532)
                (#x8FF9B0 . #xE533)
                (#x8FF9B1 . #xE534)
                (#x8FF9B2 . #xE535)
                (#x8FF9B3 . #xE536)
                (#x8FF9B4 . #xE537)
                (#x8FF9B5 . #xE538)
                (#x8FF9B6 . #xE539)
                (#x8FF9B7 . #xE53A)
                (#x8FF9B8 . #xE53B)
                (#x8FF9B9 . #xE53C)
                (#x8FF9BA . #xE53D)
                (#x8FF9BB . #xE53E)
                (#x8FF9BC . #xE53F)
                (#x8FF9BD . #xE540)
                (#x8FF9BE . #xE541)
                (#x8FF9BF . #xE542)
                (#x8FF9C0 . #xE543)
                (#x8FF9C1 . #xE544)
                (#x8FF9C2 . #xE545)
                (#x8FF9C3 . #xE546)
                (#x8FF9C4 . #xE547)
                (#x8FF9C5 . #xE548)
                (#x8FF9C6 . #xE549)
                (#x8FF9C7 . #xE54A)
                (#x8FF9C8 . #xE54B)
                (#x8FF9C9 . #xE54C)
                (#x8FF9CA . #xE54D)
                (#x8FF9CB . #xE54E)
                (#x8FF9CC . #xE54F)
                (#x8FF9CD . #xE550)
                (#x8FF9CE . #xE551)
                (#x8FF9CF . #xE552)
                (#x8FF9D0 . #xE553)
                (#x8FF9D1 . #xE554)
                (#x8FF9D2 . #xE555)
                (#x8FF9D3 . #xE556)
                (#x8FF9D4 . #xE557)
                (#x8FF9D5 . #xE558)
                (#x8FF9D6 . #xE559)
                (#x8FF9D7 . #xE55A)
                (#x8FF9D8 . #xE55B)
                (#x8FF9D9 . #xE55C)
                (#x8FF9DA . #xE55D)
                (#x8FF9DB . #xE55E)
                (#x8FF9DC . #xE55F)
                (#x8FF9DD . #xE560)
                (#x8FF9DE . #xE561)
                (#x8FF9DF . #xE562)
                (#x8FF9E0 . #xE563)
                (#x8FF9E1 . #xE564)
                (#x8FF9E2 . #xE565)
                (#x8FF9E3 . #xE566)
                (#x8FF9E4 . #xE567)
                (#x8FF9E5 . #xE568)
                (#x8FF9E6 . #xE569)
                (#x8FF9E7 . #xE56A)
                (#x8FF9E8 . #xE56B)
                (#x8FF9E9 . #xE56C)
                (#x8FF9EA . #xE56D)
                (#x8FF9EB . #xE56E)
                (#x8FF9EC . #xE56F)
                (#x8FF9ED . #xE570)
                (#x8FF9EE . #xE571)
                (#x8FF9EF . #xE572)
                (#x8FF9F0 . #xE573)
                (#x8FF9F1 . #xE574)
                (#x8FF9F2 . #xE575)
                (#x8FF9F3 . #xE576)
                (#x8FF9F4 . #xE577)
                (#x8FF9F5 . #xE578)
                (#x8FF9F6 . #xE579)
                (#x8FF9F7 . #xE57A)
                (#x8FF9F8 . #xE57B)
                (#x8FF9F9 . #xE57C)
                (#x8FF9FA . #xE57D)
                (#x8FF9FB . #xE57E)
                (#x8FF9FC . #xE57F)
                (#x8FF9FD . #xE580)
                (#x8FF9FE . #xE581)
                (#x8FFAA1 . #xE582)
                (#x8FFAA2 . #xE583)
                (#x8FFAA3 . #xE584)
                (#x8FFAA4 . #xE585)
                (#x8FFAA5 . #xE586)
                (#x8FFAA6 . #xE587)
                (#x8FFAA7 . #xE588)
                (#x8FFAA8 . #xE589)
                (#x8FFAA9 . #xE58A)
                (#x8FFAAA . #xE58B)
                (#x8FFAAB . #xE58C)
                (#x8FFAAC . #xE58D)
                (#x8FFAAD . #xE58E)
                (#x8FFAAE . #xE58F)
                (#x8FFAAF . #xE590)
                (#x8FFAB0 . #xE591)
                (#x8FFAB1 . #xE592)
                (#x8FFAB2 . #xE593)
                (#x8FFAB3 . #xE594)
                (#x8FFAB4 . #xE595)
                (#x8FFAB5 . #xE596)
                (#x8FFAB6 . #xE597)
                (#x8FFAB7 . #xE598)
                (#x8FFAB8 . #xE599)
                (#x8FFAB9 . #xE59A)
                (#x8FFABA . #xE59B)
                (#x8FFABB . #xE59C)
                (#x8FFABC . #xE59D)
                (#x8FFABD . #xE59E)
                (#x8FFABE . #xE59F)
                (#x8FFABF . #xE5A0)
                (#x8FFAC0 . #xE5A1)
                (#x8FFAC1 . #xE5A2)
                (#x8FFAC2 . #xE5A3)
                (#x8FFAC3 . #xE5A4)
                (#x8FFAC4 . #xE5A5)
                (#x8FFAC5 . #xE5A6)
                (#x8FFAC6 . #xE5A7)
                (#x8FFAC7 . #xE5A8)
                (#x8FFAC8 . #xE5A9)
                (#x8FFAC9 . #xE5AA)
                (#x8FFACA . #xE5AB)
                (#x8FFACB . #xE5AC)
                (#x8FFACC . #xE5AD)
                (#x8FFACD . #xE5AE)
                (#x8FFACE . #xE5AF)
                (#x8FFACF . #xE5B0)
                (#x8FFAD0 . #xE5B1)
                (#x8FFAD1 . #xE5B2)
                (#x8FFAD2 . #xE5B3)
                (#x8FFAD3 . #xE5B4)
                (#x8FFAD4 . #xE5B5)
                (#x8FFAD5 . #xE5B6)
                (#x8FFAD6 . #xE5B7)
                (#x8FFAD7 . #xE5B8)
                (#x8FFAD8 . #xE5B9)
                (#x8FFAD9 . #xE5BA)
                (#x8FFADA . #xE5BB)
                (#x8FFADB . #xE5BC)
                (#x8FFADC . #xE5BD)
                (#x8FFADD . #xE5BE)
                (#x8FFADE . #xE5BF)
                (#x8FFADF . #xE5C0)
                (#x8FFAE0 . #xE5C1)
                (#x8FFAE1 . #xE5C2)
                (#x8FFAE2 . #xE5C3)
                (#x8FFAE3 . #xE5C4)
                (#x8FFAE4 . #xE5C5)
                (#x8FFAE5 . #xE5C6)
                (#x8FFAE6 . #xE5C7)
                (#x8FFAE7 . #xE5C8)
                (#x8FFAE8 . #xE5C9)
                (#x8FFAE9 . #xE5CA)
                (#x8FFAEA . #xE5CB)
                (#x8FFAEB . #xE5CC)
                (#x8FFAEC . #xE5CD)
                (#x8FFAED . #xE5CE)
                (#x8FFAEE . #xE5CF)
                (#x8FFAEF . #xE5D0)
                (#x8FFAF0 . #xE5D1)
                (#x8FFAF1 . #xE5D2)
                (#x8FFAF2 . #xE5D3)
                (#x8FFAF3 . #xE5D4)
                (#x8FFAF4 . #xE5D5)
                (#x8FFAF5 . #xE5D6)
                (#x8FFAF6 . #xE5D7)
                (#x8FFAF7 . #xE5D8)
                (#x8FFAF8 . #xE5D9)
                (#x8FFAF9 . #xE5DA)
                (#x8FFAFA . #xE5DB)
                (#x8FFAFB . #xE5DC)
                (#x8FFAFC . #xE5DD)
                (#x8FFAFD . #xE5DE)
                (#x8FFAFE . #xE5DF)
                (#x8FFBA1 . #xE5E0)
                (#x8FFBA2 . #xE5E1)
                (#x8FFBA3 . #xE5E2)
                (#x8FFBA4 . #xE5E3)
                (#x8FFBA5 . #xE5E4)
                (#x8FFBA6 . #xE5E5)
                (#x8FFBA7 . #xE5E6)
                (#x8FFBA8 . #xE5E7)
                (#x8FFBA9 . #xE5E8)
                (#x8FFBAA . #xE5E9)
                (#x8FFBAB . #xE5EA)
                (#x8FFBAC . #xE5EB)
                (#x8FFBAD . #xE5EC)
                (#x8FFBAE . #xE5ED)
                (#x8FFBAF . #xE5EE)
                (#x8FFBB0 . #xE5EF)
                (#x8FFBB1 . #xE5F0)
                (#x8FFBB2 . #xE5F1)
                (#x8FFBB3 . #xE5F2)
                (#x8FFBB4 . #xE5F3)
                (#x8FFBB5 . #xE5F4)
                (#x8FFBB6 . #xE5F5)
                (#x8FFBB7 . #xE5F6)
                (#x8FFBB8 . #xE5F7)
                (#x8FFBB9 . #xE5F8)
                (#x8FFBBA . #xE5F9)
                (#x8FFBBB . #xE5FA)
                (#x8FFBBC . #xE5FB)
                (#x8FFBBD . #xE5FC)
                (#x8FFBBE . #xE5FD)
                (#x8FFBBF . #xE5FE)
                (#x8FFBC0 . #xE5FF)
                (#x8FFBC1 . #xE600)
                (#x8FFBC2 . #xE601)
                (#x8FFBC3 . #xE602)
                (#x8FFBC4 . #xE603)
                (#x8FFBC5 . #xE604)
                (#x8FFBC6 . #xE605)
                (#x8FFBC7 . #xE606)
                (#x8FFBC8 . #xE607)
                (#x8FFBC9 . #xE608)
                (#x8FFBCA . #xE609)
                (#x8FFBCB . #xE60A)
                (#x8FFBCC . #xE60B)
                (#x8FFBCD . #xE60C)
                (#x8FFBCE . #xE60D)
                (#x8FFBCF . #xE60E)
                (#x8FFBD0 . #xE60F)
                (#x8FFBD1 . #xE610)
                (#x8FFBD2 . #xE611)
                (#x8FFBD3 . #xE612)
                (#x8FFBD4 . #xE613)
                (#x8FFBD5 . #xE614)
                (#x8FFBD6 . #xE615)
                (#x8FFBD7 . #xE616)
                (#x8FFBD8 . #xE617)
                (#x8FFBD9 . #xE618)
                (#x8FFBDA . #xE619)
                (#x8FFBDB . #xE61A)
                (#x8FFBDC . #xE61B)
                (#x8FFBDD . #xE61C)
                (#x8FFBDE . #xE61D)
                (#x8FFBDF . #xE61E)
                (#x8FFBE0 . #xE61F)
                (#x8FFBE1 . #xE620)
                (#x8FFBE2 . #xE621)
                (#x8FFBE3 . #xE622)
                (#x8FFBE4 . #xE623)
                (#x8FFBE5 . #xE624)
                (#x8FFBE6 . #xE625)
                (#x8FFBE7 . #xE626)
                (#x8FFBE8 . #xE627)
                (#x8FFBE9 . #xE628)
                (#x8FFBEA . #xE629)
                (#x8FFBEB . #xE62A)
                (#x8FFBEC . #xE62B)
                (#x8FFBED . #xE62C)
                (#x8FFBEE . #xE62D)
                (#x8FFBEF . #xE62E)
                (#x8FFBF0 . #xE62F)
                (#x8FFBF1 . #xE630)
                (#x8FFBF2 . #xE631)
                (#x8FFBF3 . #xE632)
                (#x8FFBF4 . #xE633)
                (#x8FFBF5 . #xE634)
                (#x8FFBF6 . #xE635)
                (#x8FFBF7 . #xE636)
                (#x8FFBF8 . #xE637)
                (#x8FFBF9 . #xE638)
                (#x8FFBFA . #xE639)
                (#x8FFBFB . #xE63A)
                (#x8FFBFC . #xE63B)
                (#x8FFBFD . #xE63C)
                (#x8FFBFE . #xE63D)
                (#x8FFCA1 . #xE63E)
                (#x8FFCA2 . #xE63F)
                (#x8FFCA3 . #xE640)
                (#x8FFCA4 . #xE641)
                (#x8FFCA5 . #xE642)
                (#x8FFCA6 . #xE643)
                (#x8FFCA7 . #xE644)
                (#x8FFCA8 . #xE645)
                (#x8FFCA9 . #xE646)
                (#x8FFCAA . #xE647)
                (#x8FFCAB . #xE648)
                (#x8FFCAC . #xE649)
                (#x8FFCAD . #xE64A)
                (#x8FFCAE . #xE64B)
                (#x8FFCAF . #xE64C)
                (#x8FFCB0 . #xE64D)
                (#x8FFCB1 . #xE64E)
                (#x8FFCB2 . #xE64F)
                (#x8FFCB3 . #xE650)
                (#x8FFCB4 . #xE651)
                (#x8FFCB5 . #xE652)
                (#x8FFCB6 . #xE653)
                (#x8FFCB7 . #xE654)
                (#x8FFCB8 . #xE655)
                (#x8FFCB9 . #xE656)
                (#x8FFCBA . #xE657)
                (#x8FFCBB . #xE658)
                (#x8FFCBC . #xE659)
                (#x8FFCBD . #xE65A)
                (#x8FFCBE . #xE65B)
                (#x8FFCBF . #xE65C)
                (#x8FFCC0 . #xE65D)
                (#x8FFCC1 . #xE65E)
                (#x8FFCC2 . #xE65F)
                (#x8FFCC3 . #xE660)
                (#x8FFCC4 . #xE661)
                (#x8FFCC5 . #xE662)
                (#x8FFCC6 . #xE663)
                (#x8FFCC7 . #xE664)
                (#x8FFCC8 . #xE665)
                (#x8FFCC9 . #xE666)
                (#x8FFCCA . #xE667)
                (#x8FFCCB . #xE668)
                (#x8FFCCC . #xE669)
                (#x8FFCCD . #xE66A)
                (#x8FFCCE . #xE66B)
                (#x8FFCCF . #xE66C)
                (#x8FFCD0 . #xE66D)
                (#x8FFCD1 . #xE66E)
                (#x8FFCD2 . #xE66F)
                (#x8FFCD3 . #xE670)
                (#x8FFCD4 . #xE671)
                (#x8FFCD5 . #xE672)
                (#x8FFCD6 . #xE673)
                (#x8FFCD7 . #xE674)
                (#x8FFCD8 . #xE675)
                (#x8FFCD9 . #xE676)
                (#x8FFCDA . #xE677)
                (#x8FFCDB . #xE678)
                (#x8FFCDC . #xE679)
                (#x8FFCDD . #xE67A)
                (#x8FFCDE . #xE67B)
                (#x8FFCDF . #xE67C)
                (#x8FFCE0 . #xE67D)
                (#x8FFCE1 . #xE67E)
                (#x8FFCE2 . #xE67F)
                (#x8FFCE3 . #xE680)
                (#x8FFCE4 . #xE681)
                (#x8FFCE5 . #xE682)
                (#x8FFCE6 . #xE683)
                (#x8FFCE7 . #xE684)
                (#x8FFCE8 . #xE685)
                (#x8FFCE9 . #xE686)
                (#x8FFCEA . #xE687)
                (#x8FFCEB . #xE688)
                (#x8FFCEC . #xE689)
                (#x8FFCED . #xE68A)
                (#x8FFCEE . #xE68B)
                (#x8FFCEF . #xE68C)
                (#x8FFCF0 . #xE68D)
                (#x8FFCF1 . #xE68E)
                (#x8FFCF2 . #xE68F)
                (#x8FFCF3 . #xE690)
                (#x8FFCF4 . #xE691)
                (#x8FFCF5 . #xE692)
                (#x8FFCF6 . #xE693)
                (#x8FFCF7 . #xE694)
                (#x8FFCF8 . #xE695)
                (#x8FFCF9 . #xE696)
                (#x8FFCFA . #xE697)
                (#x8FFCFB . #xE698)
                (#x8FFCFC . #xE699)
                (#x8FFCFD . #xE69A)
                (#x8FFCFE . #xE69B)
                (#x8FFDA1 . #xE69C)
                (#x8FFDA2 . #xE69D)
                (#x8FFDA3 . #xE69E)
                (#x8FFDA4 . #xE69F)
                (#x8FFDA5 . #xE6A0)
                (#x8FFDA6 . #xE6A1)
                (#x8FFDA7 . #xE6A2)
                (#x8FFDA8 . #xE6A3)
                (#x8FFDA9 . #xE6A4)
                (#x8FFDAA . #xE6A5)
                (#x8FFDAB . #xE6A6)
                (#x8FFDAC . #xE6A7)
                (#x8FFDAD . #xE6A8)
                (#x8FFDAE . #xE6A9)
                (#x8FFDAF . #xE6AA)
                (#x8FFDB0 . #xE6AB)
                (#x8FFDB1 . #xE6AC)
                (#x8FFDB2 . #xE6AD)
                (#x8FFDB3 . #xE6AE)
                (#x8FFDB4 . #xE6AF)
                (#x8FFDB5 . #xE6B0)
                (#x8FFDB6 . #xE6B1)
                (#x8FFDB7 . #xE6B2)
                (#x8FFDB8 . #xE6B3)
                (#x8FFDB9 . #xE6B4)
                (#x8FFDBA . #xE6B5)
                (#x8FFDBB . #xE6B6)
                (#x8FFDBC . #xE6B7)
                (#x8FFDBD . #xE6B8)
                (#x8FFDBE . #xE6B9)
                (#x8FFDBF . #xE6BA)
                (#x8FFDC0 . #xE6BB)
                (#x8FFDC1 . #xE6BC)
                (#x8FFDC2 . #xE6BD)
                (#x8FFDC3 . #xE6BE)
                (#x8FFDC4 . #xE6BF)
                (#x8FFDC5 . #xE6C0)
                (#x8FFDC6 . #xE6C1)
                (#x8FFDC7 . #xE6C2)
                (#x8FFDC8 . #xE6C3)
                (#x8FFDC9 . #xE6C4)
                (#x8FFDCA . #xE6C5)
                (#x8FFDCB . #xE6C6)
                (#x8FFDCC . #xE6C7)
                (#x8FFDCD . #xE6C8)
                (#x8FFDCE . #xE6C9)
                (#x8FFDCF . #xE6CA)
                (#x8FFDD0 . #xE6CB)
                (#x8FFDD1 . #xE6CC)
                (#x8FFDD2 . #xE6CD)
                (#x8FFDD3 . #xE6CE)
                (#x8FFDD4 . #xE6CF)
                (#x8FFDD5 . #xE6D0)
                (#x8FFDD6 . #xE6D1)
                (#x8FFDD7 . #xE6D2)
                (#x8FFDD8 . #xE6D3)
                (#x8FFDD9 . #xE6D4)
                (#x8FFDDA . #xE6D5)
                (#x8FFDDB . #xE6D6)
                (#x8FFDDC . #xE6D7)
                (#x8FFDDD . #xE6D8)
                (#x8FFDDE . #xE6D9)
                (#x8FFDDF . #xE6DA)
                (#x8FFDE0 . #xE6DB)
                (#x8FFDE1 . #xE6DC)
                (#x8FFDE2 . #xE6DD)
                (#x8FFDE3 . #xE6DE)
                (#x8FFDE4 . #xE6DF)
                (#x8FFDE5 . #xE6E0)
                (#x8FFDE6 . #xE6E1)
                (#x8FFDE7 . #xE6E2)
                (#x8FFDE8 . #xE6E3)
                (#x8FFDE9 . #xE6E4)
                (#x8FFDEA . #xE6E5)
                (#x8FFDEB . #xE6E6)
                (#x8FFDEC . #xE6E7)
                (#x8FFDED . #xE6E8)
                (#x8FFDEE . #xE6E9)
                (#x8FFDEF . #xE6EA)
                (#x8FFDF0 . #xE6EB)
                (#x8FFDF1 . #xE6EC)
                (#x8FFDF2 . #xE6ED)
                (#x8FFDF3 . #xE6EE)
                (#x8FFDF4 . #xE6EF)
                (#x8FFDF5 . #xE6F0)
                (#x8FFDF6 . #xE6F1)
                (#x8FFDF7 . #xE6F2)
                (#x8FFDF8 . #xE6F3)
                (#x8FFDF9 . #xE6F4)
                (#x8FFDFA . #xE6F5)
                (#x8FFDFB . #xE6F6)
                (#x8FFDFC . #xE6F7)
                (#x8FFDFD . #xE6F8)
                (#x8FFDFE . #xE6F9)
                (#x8FFEA1 . #xE6FA)
                (#x8FFEA2 . #xE6FB)
                (#x8FFEA3 . #xE6FC)
                (#x8FFEA4 . #xE6FD)
                (#x8FFEA5 . #xE6FE)
                (#x8FFEA6 . #xE6FF)
                (#x8FFEA7 . #xE700)
                (#x8FFEA8 . #xE701)
                (#x8FFEA9 . #xE702)
                (#x8FFEAA . #xE703)
                (#x8FFEAB . #xE704)
                (#x8FFEAC . #xE705)
                (#x8FFEAD . #xE706)
                (#x8FFEAE . #xE707)
                (#x8FFEAF . #xE708)
                (#x8FFEB0 . #xE709)
                (#x8FFEB1 . #xE70A)
                (#x8FFEB2 . #xE70B)
                (#x8FFEB3 . #xE70C)
                (#x8FFEB4 . #xE70D)
                (#x8FFEB5 . #xE70E)
                (#x8FFEB6 . #xE70F)
                (#x8FFEB7 . #xE710)
                (#x8FFEB8 . #xE711)
                (#x8FFEB9 . #xE712)
                (#x8FFEBA . #xE713)
                (#x8FFEBB . #xE714)
                (#x8FFEBC . #xE715)
                (#x8FFEBD . #xE716)
                (#x8FFEBE . #xE717)
                (#x8FFEBF . #xE718)
                (#x8FFEC0 . #xE719)
                (#x8FFEC1 . #xE71A)
                (#x8FFEC2 . #xE71B)
                (#x8FFEC3 . #xE71C)
                (#x8FFEC4 . #xE71D)
                (#x8FFEC5 . #xE71E)
                (#x8FFEC6 . #xE71F)
                (#x8FFEC7 . #xE720)
                (#x8FFEC8 . #xE721)
                (#x8FFEC9 . #xE722)
                (#x8FFECA . #xE723)
                (#x8FFECB . #xE724)
                (#x8FFECC . #xE725)
                (#x8FFECD . #xE726)
                (#x8FFECE . #xE727)
                (#x8FFECF . #xE728)
                (#x8FFED0 . #xE729)
                (#x8FFED1 . #xE72A)
                (#x8FFED2 . #xE72B)
                (#x8FFED3 . #xE72C)
                (#x8FFED4 . #xE72D)
                (#x8FFED5 . #xE72E)
                (#x8FFED6 . #xE72F)
                (#x8FFED7 . #xE730)
                (#x8FFED8 . #xE731)
                (#x8FFED9 . #xE732)
                (#x8FFEDA . #xE733)
                (#x8FFEDB . #xE734)
                (#x8FFEDC . #xE735)
                (#x8FFEDD . #xE736)
                (#x8FFEDE . #xE737)
                (#x8FFEDF . #xE738)
                (#x8FFEE0 . #xE739)
                (#x8FFEE1 . #xE73A)
                (#x8FFEE2 . #xE73B)
                (#x8FFEE3 . #xE73C)
                (#x8FFEE4 . #xE73D)
                (#x8FFEE5 . #xE73E)
                (#x8FFEE6 . #xE73F)
                (#x8FFEE7 . #xE740)
                (#x8FFEE8 . #xE741)
                (#x8FFEE9 . #xE742)
                (#x8FFEEA . #xE743)
                (#x8FFEEB . #xE744)
                (#x8FFEEC . #xE745)
                (#x8FFEED . #xE746)
                (#x8FFEEE . #xE747)
                (#x8FFEEF . #xE748)
                (#x8FFEF0 . #xE749)
                (#x8FFEF1 . #xE74A)
                (#x8FFEF2 . #xE74B)
                (#x8FFEF3 . #xE74C)
                (#x8FFEF4 . #xE74D)
                (#x8FFEF5 . #xE74E)
                (#x8FFEF6 . #xE74F)
                (#x8FFEF7 . #xE750)
                (#x8FFEF8 . #xE751)
                (#x8FFEF9 . #xE752)
                (#x8FFEFA . #xE753)
                (#x8FFEFB . #xE754)
                (#x8FFEFC . #xE755)
                (#x8FFEFD . #xE756)
                (#x8FFEFE . #xE757)
                (#xA1A1 . #x3000)
                (#xA1A2 . #x3001)
                (#xA1A3 . #x3002)
                (#xA1A4 . #xFF0C)
                (#xA1A5 . #xFF0E)
                (#xA1A6 . #x30FB)
                (#xA1A7 . #xFF1A)
                (#xA1A8 . #xFF1B)
                (#xA1A9 . #xFF1F)
                (#xA1AA . #xFF01)
                (#xA1AB . #x309B)
                (#xA1AC . #x309C)
                (#xA1AD . #xB4)
                (#xA1AE . #xFF40)
                (#xA1AF . #xA8)
                (#xA1B0 . #xFF3E)
                (#xA1B1 . #xFFE3)
                (#xA1B2 . #xFF3F)
                (#xA1B3 . #x30FD)
                (#xA1B4 . #x30FE)
                (#xA1B5 . #x309D)
                (#xA1B6 . #x309E)
                (#xA1B7 . #x3003)
                (#xA1B8 . #x4EDD)
                (#xA1B9 . #x3005)
                (#xA1BA . #x3006)
                (#xA1BB . #x3007)
                (#xA1BC . #x30FC)
                (#xA1BD . #x2015)
                (#xA1BE . #x2010)
                (#xA1BF . #xFF0F)
                (#xA1C0 . #xFF3C)
                (#xA1C1 . #x301C)
                (#xA1C2 . #x2016)
                (#xA1C3 . #xFF5C)
                (#xA1C4 . #x2026)
                (#xA1C5 . #x2025)
                (#xA1C6 . #x2018)
                (#xA1C7 . #x2019)
                (#xA1C8 . #x201C)
                (#xA1C9 . #x201D)
                (#xA1CA . #xFF08)
                (#xA1CB . #xFF09)
                (#xA1CC . #x3014)
                (#xA1CD . #x3015)
                (#xA1CE . #xFF3B)
                (#xA1CF . #xFF3D)
                (#xA1D0 . #xFF5B)
                (#xA1D1 . #xFF5D)
                (#xA1D2 . #x3008)
                (#xA1D3 . #x3009)
                (#xA1D4 . #x300A)
                (#xA1D5 . #x300B)
                (#xA1D6 . #x300C)
                (#xA1D7 . #x300D)
                (#xA1D8 . #x300E)
                (#xA1D9 . #x300F)
                (#xA1DA . #x3010)
                (#xA1DB . #x3011)
                (#xA1DC . #xFF0B)
                (#xA1DD . #x2212)
                (#xA1DE . #xB1)
                (#xA1DF . #xD7)
                (#xA1E0 . #xF7)
                (#xA1E1 . #xFF1D)
                (#xA1E2 . #x2260)
                (#xA1E3 . #xFF1C)
                (#xA1E4 . #xFF1E)
                (#xA1E5 . #x2266)
                (#xA1E6 . #x2267)
                (#xA1E7 . #x221E)
                (#xA1E8 . #x2234)
                (#xA1E9 . #x2642)
                (#xA1EA . #x2640)
                (#xA1EB . #xB0)
                (#xA1EC . #x2032)
                (#xA1ED . #x2033)
                (#xA1EE . #x2103)
                (#xA1EF . #xFFE5)
                (#xA1F0 . #xFF04)
                (#xA1F1 . #xA2)
                (#xA1F2 . #xA3)
                (#xA1F3 . #xFF05)
                (#xA1F4 . #xFF03)
                (#xA1F5 . #xFF06)
                (#xA1F6 . #xFF0A)
                (#xA1F7 . #xFF20)
                (#xA1F8 . #xA7)
                (#xA1F9 . #x2606)
                (#xA1FA . #x2605)
                (#xA1FB . #x25CB)
                (#xA1FC . #x25CF)
                (#xA1FD . #x25CE)
                (#xA1FE . #x25C7)
                (#xA2A1 . #x25C6)
                (#xA2A2 . #x25A1)
                (#xA2A3 . #x25A0)
                (#xA2A4 . #x25B3)
                (#xA2A5 . #x25B2)
                (#xA2A6 . #x25BD)
                (#xA2A7 . #x25BC)
                (#xA2A8 . #x203B)
                (#xA2A9 . #x3012)
                (#xA2AA . #x2192)
                (#xA2AB . #x2190)
                (#xA2AC . #x2191)
                (#xA2AD . #x2193)
                (#xA2AE . #x3013)
                (#xA2BA . #x2208)
                (#xA2BB . #x220B)
                (#xA2BC . #x2286)
                (#xA2BD . #x2287)
                (#xA2BE . #x2282)
                (#xA2BF . #x2283)
                (#xA2C0 . #x222A)
                (#xA2C1 . #x2229)
                (#xA2CA . #x2227)
                (#xA2CB . #x2228)
                (#xA2CC . #xAC)
                (#xA2CD . #x21D2)
                (#xA2CE . #x21D4)
                (#xA2CF . #x2200)
                (#xA2D0 . #x2203)
                (#xA2DC . #x2220)
                (#xA2DD . #x22A5)
                (#xA2DE . #x2312)
                (#xA2DF . #x2202)
                (#xA2E0 . #x2207)
                (#xA2E1 . #x2261)
                (#xA2E2 . #x2252)
                (#xA2E3 . #x226A)
                (#xA2E4 . #x226B)
                (#xA2E5 . #x221A)
                (#xA2E6 . #x223D)
                (#xA2E7 . #x221D)
                (#xA2E8 . #x2235)
                (#xA2E9 . #x222B)
                (#xA2EA . #x222C)
                (#xA2F2 . #x212B)
                (#xA2F3 . #x2030)
                (#xA2F4 . #x266F)
                (#xA2F5 . #x266D)
                (#xA2F6 . #x266A)
                (#xA2F7 . #x2020)
                (#xA2F8 . #x2021)
                (#xA2F9 . #xB6)
                (#xA2FE . #x25EF)
                (#xA3B0 . #xFF10)
                (#xA3B1 . #xFF11)
                (#xA3B2 . #xFF12)
                (#xA3B3 . #xFF13)
                (#xA3B4 . #xFF14)
                (#xA3B5 . #xFF15)
                (#xA3B6 . #xFF16)
                (#xA3B7 . #xFF17)
                (#xA3B8 . #xFF18)
                (#xA3B9 . #xFF19)
                (#xA3C1 . #xFF21)
                (#xA3C2 . #xFF22)
                (#xA3C3 . #xFF23)
                (#xA3C4 . #xFF24)
                (#xA3C5 . #xFF25)
                (#xA3C6 . #xFF26)
                (#xA3C7 . #xFF27)
                (#xA3C8 . #xFF28)
                (#xA3C9 . #xFF29)
                (#xA3CA . #xFF2A)
                (#xA3CB . #xFF2B)
                (#xA3CC . #xFF2C)
                (#xA3CD . #xFF2D)
                (#xA3CE . #xFF2E)
                (#xA3CF . #xFF2F)
                (#xA3D0 . #xFF30)
                (#xA3D1 . #xFF31)
                (#xA3D2 . #xFF32)
                (#xA3D3 . #xFF33)
                (#xA3D4 . #xFF34)
                (#xA3D5 . #xFF35)
                (#xA3D6 . #xFF36)
                (#xA3D7 . #xFF37)
                (#xA3D8 . #xFF38)
                (#xA3D9 . #xFF39)
                (#xA3DA . #xFF3A)
                (#xA3E1 . #xFF41)
                (#xA3E2 . #xFF42)
                (#xA3E3 . #xFF43)
                (#xA3E4 . #xFF44)
                (#xA3E5 . #xFF45)
                (#xA3E6 . #xFF46)
                (#xA3E7 . #xFF47)
                (#xA3E8 . #xFF48)
                (#xA3E9 . #xFF49)
                (#xA3EA . #xFF4A)
                (#xA3EB . #xFF4B)
                (#xA3EC . #xFF4C)
                (#xA3ED . #xFF4D)
                (#xA3EE . #xFF4E)
                (#xA3EF . #xFF4F)
                (#xA3F0 . #xFF50)
                (#xA3F1 . #xFF51)
                (#xA3F2 . #xFF52)
                (#xA3F3 . #xFF53)
                (#xA3F4 . #xFF54)
                (#xA3F5 . #xFF55)
                (#xA3F6 . #xFF56)
                (#xA3F7 . #xFF57)
                (#xA3F8 . #xFF58)
                (#xA3F9 . #xFF59)
                (#xA3FA . #xFF5A)
                (#xA4A1 . #x3041)
                (#xA4A2 . #x3042)
                (#xA4A3 . #x3043)
                (#xA4A4 . #x3044)
                (#xA4A5 . #x3045)
                (#xA4A6 . #x3046)
                (#xA4A7 . #x3047)
                (#xA4A8 . #x3048)
                (#xA4A9 . #x3049)
                (#xA4AA . #x304A)
                (#xA4AB . #x304B)
                (#xA4AC . #x304C)
                (#xA4AD . #x304D)
                (#xA4AE . #x304E)
                (#xA4AF . #x304F)
                (#xA4B0 . #x3050)
                (#xA4B1 . #x3051)
                (#xA4B2 . #x3052)
                (#xA4B3 . #x3053)
                (#xA4B4 . #x3054)
                (#xA4B5 . #x3055)
                (#xA4B6 . #x3056)
                (#xA4B7 . #x3057)
                (#xA4B8 . #x3058)
                (#xA4B9 . #x3059)
                (#xA4BA . #x305A)
                (#xA4BB . #x305B)
                (#xA4BC . #x305C)
                (#xA4BD . #x305D)
                (#xA4BE . #x305E)
                (#xA4BF . #x305F)
                (#xA4C0 . #x3060)
                (#xA4C1 . #x3061)
                (#xA4C2 . #x3062)
                (#xA4C3 . #x3063)
                (#xA4C4 . #x3064)
                (#xA4C5 . #x3065)
                (#xA4C6 . #x3066)
                (#xA4C7 . #x3067)
                (#xA4C8 . #x3068)
                (#xA4C9 . #x3069)
                (#xA4CA . #x306A)
                (#xA4CB . #x306B)
                (#xA4CC . #x306C)
                (#xA4CD . #x306D)
                (#xA4CE . #x306E)
                (#xA4CF . #x306F)
                (#xA4D0 . #x3070)
                (#xA4D1 . #x3071)
                (#xA4D2 . #x3072)
                (#xA4D3 . #x3073)
                (#xA4D4 . #x3074)
                (#xA4D5 . #x3075)
                (#xA4D6 . #x3076)
                (#xA4D7 . #x3077)
                (#xA4D8 . #x3078)
                (#xA4D9 . #x3079)
                (#xA4DA . #x307A)
                (#xA4DB . #x307B)
                (#xA4DC . #x307C)
                (#xA4DD . #x307D)
                (#xA4DE . #x307E)
                (#xA4DF . #x307F)
                (#xA4E0 . #x3080)
                (#xA4E1 . #x3081)
                (#xA4E2 . #x3082)
                (#xA4E3 . #x3083)
                (#xA4E4 . #x3084)
                (#xA4E5 . #x3085)
                (#xA4E6 . #x3086)
                (#xA4E7 . #x3087)
                (#xA4E8 . #x3088)
                (#xA4E9 . #x3089)
                (#xA4EA . #x308A)
                (#xA4EB . #x308B)
                (#xA4EC . #x308C)
                (#xA4ED . #x308D)
                (#xA4EE . #x308E)
                (#xA4EF . #x308F)
                (#xA4F0 . #x3090)
                (#xA4F1 . #x3091)
                (#xA4F2 . #x3092)
                (#xA4F3 . #x3093)
                (#xA5A1 . #x30A1)
                (#xA5A2 . #x30A2)
                (#xA5A3 . #x30A3)
                (#xA5A4 . #x30A4)
                (#xA5A5 . #x30A5)
                (#xA5A6 . #x30A6)
                (#xA5A7 . #x30A7)
                (#xA5A8 . #x30A8)
                (#xA5A9 . #x30A9)
                (#xA5AA . #x30AA)
                (#xA5AB . #x30AB)
                (#xA5AC . #x30AC)
                (#xA5AD . #x30AD)
                (#xA5AE . #x30AE)
                (#xA5AF . #x30AF)
                (#xA5B0 . #x30B0)
                (#xA5B1 . #x30B1)
                (#xA5B2 . #x30B2)
                (#xA5B3 . #x30B3)
                (#xA5B4 . #x30B4)
                (#xA5B5 . #x30B5)
                (#xA5B6 . #x30B6)
                (#xA5B7 . #x30B7)
                (#xA5B8 . #x30B8)
                (#xA5B9 . #x30B9)
                (#xA5BA . #x30BA)
                (#xA5BB . #x30BB)
                (#xA5BC . #x30BC)
                (#xA5BD . #x30BD)
                (#xA5BE . #x30BE)
                (#xA5BF . #x30BF)
                (#xA5C0 . #x30C0)
                (#xA5C1 . #x30C1)
                (#xA5C2 . #x30C2)
                (#xA5C3 . #x30C3)
                (#xA5C4 . #x30C4)
                (#xA5C5 . #x30C5)
                (#xA5C6 . #x30C6)
                (#xA5C7 . #x30C7)
                (#xA5C8 . #x30C8)
                (#xA5C9 . #x30C9)
                (#xA5CA . #x30CA)
                (#xA5CB . #x30CB)
                (#xA5CC . #x30CC)
                (#xA5CD . #x30CD)
                (#xA5CE . #x30CE)
                (#xA5CF . #x30CF)
                (#xA5D0 . #x30D0)
                (#xA5D1 . #x30D1)
                (#xA5D2 . #x30D2)
                (#xA5D3 . #x30D3)
                (#xA5D4 . #x30D4)
                (#xA5D5 . #x30D5)
                (#xA5D6 . #x30D6)
                (#xA5D7 . #x30D7)
                (#xA5D8 . #x30D8)
                (#xA5D9 . #x30D9)
                (#xA5DA . #x30DA)
                (#xA5DB . #x30DB)
                (#xA5DC . #x30DC)
                (#xA5DD . #x30DD)
                (#xA5DE . #x30DE)
                (#xA5DF . #x30DF)
                (#xA5E0 . #x30E0)
                (#xA5E1 . #x30E1)
                (#xA5E2 . #x30E2)
                (#xA5E3 . #x30E3)
                (#xA5E4 . #x30E4)
                (#xA5E5 . #x30E5)
                (#xA5E6 . #x30E6)
                (#xA5E7 . #x30E7)
                (#xA5E8 . #x30E8)
                (#xA5E9 . #x30E9)
                (#xA5EA . #x30EA)
                (#xA5EB . #x30EB)
                (#xA5EC . #x30EC)
                (#xA5ED . #x30ED)
                (#xA5EE . #x30EE)
                (#xA5EF . #x30EF)
                (#xA5F0 . #x30F0)
                (#xA5F1 . #x30F1)
                (#xA5F2 . #x30F2)
                (#xA5F3 . #x30F3)
                (#xA5F4 . #x30F4)
                (#xA5F5 . #x30F5)
                (#xA5F6 . #x30F6)
                (#xA6A1 . #x391)
                (#xA6A2 . #x392)
                (#xA6A3 . #x393)
                (#xA6A4 . #x394)
                (#xA6A5 . #x395)
                (#xA6A6 . #x396)
                (#xA6A7 . #x397)
                (#xA6A8 . #x398)
                (#xA6A9 . #x399)
                (#xA6AA . #x39A)
                (#xA6AB . #x39B)
                (#xA6AC . #x39C)
                (#xA6AD . #x39D)
                (#xA6AE . #x39E)
                (#xA6AF . #x39F)
                (#xA6B0 . #x3A0)
                (#xA6B1 . #x3A1)
                (#xA6B2 . #x3A3)
                (#xA6B3 . #x3A4)
                (#xA6B4 . #x3A5)
                (#xA6B5 . #x3A6)
                (#xA6B6 . #x3A7)
                (#xA6B7 . #x3A8)
                (#xA6B8 . #x3A9)
                (#xA6C1 . #x3B1)
                (#xA6C2 . #x3B2)
                (#xA6C3 . #x3B3)
                (#xA6C4 . #x3B4)
                (#xA6C5 . #x3B5)
                (#xA6C6 . #x3B6)
                (#xA6C7 . #x3B7)
                (#xA6C8 . #x3B8)
                (#xA6C9 . #x3B9)
                (#xA6CA . #x3BA)
                (#xA6CB . #x3BB)
                (#xA6CC . #x3BC)
                (#xA6CD . #x3BD)
                (#xA6CE . #x3BE)
                (#xA6CF . #x3BF)
                (#xA6D0 . #x3C0)
                (#xA6D1 . #x3C1)
                (#xA6D2 . #x3C3)
                (#xA6D3 . #x3C4)
                (#xA6D4 . #x3C5)
                (#xA6D5 . #x3C6)
                (#xA6D6 . #x3C7)
                (#xA6D7 . #x3C8)
                (#xA6D8 . #x3C9)
                (#xA7A1 . #x410)
                (#xA7A2 . #x411)
                (#xA7A3 . #x412)
                (#xA7A4 . #x413)
                (#xA7A5 . #x414)
                (#xA7A6 . #x415)
                (#xA7A7 . #x401)
                (#xA7A8 . #x416)
                (#xA7A9 . #x417)
                (#xA7AA . #x418)
                (#xA7AB . #x419)
                (#xA7AC . #x41A)
                (#xA7AD . #x41B)
                (#xA7AE . #x41C)
                (#xA7AF . #x41D)
                (#xA7B0 . #x41E)
                (#xA7B1 . #x41F)
                (#xA7B2 . #x420)
                (#xA7B3 . #x421)
                (#xA7B4 . #x422)
                (#xA7B5 . #x423)
                (#xA7B6 . #x424)
                (#xA7B7 . #x425)
                (#xA7B8 . #x426)
                (#xA7B9 . #x427)
                (#xA7BA . #x428)
                (#xA7BB . #x429)
                (#xA7BC . #x42A)
                (#xA7BD . #x42B)
                (#xA7BE . #x42C)
                (#xA7BF . #x42D)
                (#xA7C0 . #x42E)
                (#xA7C1 . #x42F)
                (#xA7D1 . #x430)
                (#xA7D2 . #x431)
                (#xA7D3 . #x432)
                (#xA7D4 . #x433)
                (#xA7D5 . #x434)
                (#xA7D6 . #x435)
                (#xA7D7 . #x451)
                (#xA7D8 . #x436)
                (#xA7D9 . #x437)
                (#xA7DA . #x438)
                (#xA7DB . #x439)
                (#xA7DC . #x43A)
                (#xA7DD . #x43B)
                (#xA7DE . #x43C)
                (#xA7DF . #x43D)
                (#xA7E0 . #x43E)
                (#xA7E1 . #x43F)
                (#xA7E2 . #x440)
                (#xA7E3 . #x441)
                (#xA7E4 . #x442)
                (#xA7E5 . #x443)
                (#xA7E6 . #x444)
                (#xA7E7 . #x445)
                (#xA7E8 . #x446)
                (#xA7E9 . #x447)
                (#xA7EA . #x448)
                (#xA7EB . #x449)
                (#xA7EC . #x44A)
                (#xA7ED . #x44B)
                (#xA7EE . #x44C)
                (#xA7EF . #x44D)
                (#xA7F0 . #x44E)
                (#xA7F1 . #x44F)
                (#xA8A1 . #x2500)
                (#xA8A2 . #x2502)
                (#xA8A3 . #x250C)
                (#xA8A4 . #x2510)
                (#xA8A5 . #x2518)
                (#xA8A6 . #x2514)
                (#xA8A7 . #x251C)
                (#xA8A8 . #x252C)
                (#xA8A9 . #x2524)
                (#xA8AA . #x2534)
                (#xA8AB . #x253C)
                (#xA8AC . #x2501)
                (#xA8AD . #x2503)
                (#xA8AE . #x250F)
                (#xA8AF . #x2513)
                (#xA8B0 . #x251B)
                (#xA8B1 . #x2517)
                (#xA8B2 . #x2523)
                (#xA8B3 . #x2533)
                (#xA8B4 . #x252B)
                (#xA8B5 . #x253B)
                (#xA8B6 . #x254B)
                (#xA8B7 . #x2520)
                (#xA8B8 . #x252F)
                (#xA8B9 . #x2528)
                (#xA8BA . #x2537)
                (#xA8BB . #x253F)
                (#xA8BC . #x251D)
                (#xA8BD . #x2530)
                (#xA8BE . #x2525)
                (#xA8BF . #x2538)
                (#xA8C0 . #x2542)
                (#xB0A1 . #x4E9C)
                (#xB0A2 . #x5516)
                (#xB0A3 . #x5A03)
                (#xB0A4 . #x963F)
                (#xB0A5 . #x54C0)
                (#xB0A6 . #x611B)
                (#xB0A7 . #x6328)
                (#xB0A8 . #x59F6)
                (#xB0A9 . #x9022)
                (#xB0AA . #x8475)
                (#xB0AB . #x831C)
                (#xB0AC . #x7A50)
                (#xB0AD . #x60AA)
                (#xB0AE . #x63E1)
                (#xB0AF . #x6E25)
                (#xB0B0 . #x65ED)
                (#xB0B1 . #x8466)
                (#xB0B2 . #x82A6)
                (#xB0B3 . #x9BF5)
                (#xB0B4 . #x6893)
                (#xB0B5 . #x5727)
                (#xB0B6 . #x65A1)
                (#xB0B7 . #x6271)
                (#xB0B8 . #x5B9B)
                (#xB0B9 . #x59D0)
                (#xB0BA . #x867B)
                (#xB0BB . #x98F4)
                (#xB0BC . #x7D62)
                (#xB0BD . #x7DBE)
                (#xB0BE . #x9B8E)
                (#xB0BF . #x6216)
                (#xB0C0 . #x7C9F)
                (#xB0C1 . #x88B7)
                (#xB0C2 . #x5B89)
                (#xB0C3 . #x5EB5)
                (#xB0C4 . #x6309)
                (#xB0C5 . #x6697)
                (#xB0C6 . #x6848)
                (#xB0C7 . #x95C7)
                (#xB0C8 . #x978D)
                (#xB0C9 . #x674F)
                (#xB0CA . #x4EE5)
                (#xB0CB . #x4F0A)
                (#xB0CC . #x4F4D)
                (#xB0CD . #x4F9D)
                (#xB0CE . #x5049)
                (#xB0CF . #x56F2)
                (#xB0D0 . #x5937)
                (#xB0D1 . #x59D4)
                (#xB0D2 . #x5A01)
                (#xB0D3 . #x5C09)
                (#xB0D4 . #x60DF)
                (#xB0D5 . #x610F)
                (#xB0D6 . #x6170)
                (#xB0D7 . #x6613)
                (#xB0D8 . #x6905)
                (#xB0D9 . #x70BA)
                (#xB0DA . #x754F)
                (#xB0DB . #x7570)
                (#xB0DC . #x79FB)
                (#xB0DD . #x7DAD)
                (#xB0DE . #x7DEF)
                (#xB0DF . #x80C3)
                (#xB0E0 . #x840E)
                (#xB0E1 . #x8863)
                (#xB0E2 . #x8B02)
                (#xB0E3 . #x9055)
                (#xB0E4 . #x907A)
                (#xB0E5 . #x533B)
                (#xB0E6 . #x4E95)
                (#xB0E7 . #x4EA5)
                (#xB0E8 . #x57DF)
                (#xB0E9 . #x80B2)
                (#xB0EA . #x90C1)
                (#xB0EB . #x78EF)
                (#xB0EC . #x4E00)
                (#xB0ED . #x58F1)
                (#xB0EE . #x6EA2)
                (#xB0EF . #x9038)
                (#xB0F0 . #x7A32)
                (#xB0F1 . #x8328)
                (#xB0F2 . #x828B)
                (#xB0F3 . #x9C2F)
                (#xB0F4 . #x5141)
                (#xB0F5 . #x5370)
                (#xB0F6 . #x54BD)
                (#xB0F7 . #x54E1)
                (#xB0F8 . #x56E0)
                (#xB0F9 . #x59FB)
                (#xB0FA . #x5F15)
                (#xB0FB . #x98F2)
                (#xB0FC . #x6DEB)
                (#xB0FD . #x80E4)
                (#xB0FE . #x852D)
                (#xB1A1 . #x9662)
                (#xB1A2 . #x9670)
                (#xB1A3 . #x96A0)
                (#xB1A4 . #x97FB)
                (#xB1A5 . #x540B)
                (#xB1A6 . #x53F3)
                (#xB1A7 . #x5B87)
                (#xB1A8 . #x70CF)
                (#xB1A9 . #x7FBD)
                (#xB1AA . #x8FC2)
                (#xB1AB . #x96E8)
                (#xB1AC . #x536F)
                (#xB1AD . #x9D5C)
                (#xB1AE . #x7ABA)
                (#xB1AF . #x4E11)
                (#xB1B0 . #x7893)
                (#xB1B1 . #x81FC)
                (#xB1B2 . #x6E26)
                (#xB1B3 . #x5618)
                (#xB1B4 . #x5504)
                (#xB1B5 . #x6B1D)
                (#xB1B6 . #x851A)
                (#xB1B7 . #x9C3B)
                (#xB1B8 . #x59E5)
                (#xB1B9 . #x53A9)
                (#xB1BA . #x6D66)
                (#xB1BB . #x74DC)
                (#xB1BC . #x958F)
                (#xB1BD . #x5642)
                (#xB1BE . #x4E91)
                (#xB1BF . #x904B)
                (#xB1C0 . #x96F2)
                (#xB1C1 . #x834F)
                (#xB1C2 . #x990C)
                (#xB1C3 . #x53E1)
                (#xB1C4 . #x55B6)
                (#xB1C5 . #x5B30)
                (#xB1C6 . #x5F71)
                (#xB1C7 . #x6620)
                (#xB1C8 . #x66F3)
                (#xB1C9 . #x6804)
                (#xB1CA . #x6C38)
                (#xB1CB . #x6CF3)
                (#xB1CC . #x6D29)
                (#xB1CD . #x745B)
                (#xB1CE . #x76C8)
                (#xB1CF . #x7A4E)
                (#xB1D0 . #x9834)
                (#xB1D1 . #x82F1)
                (#xB1D2 . #x885B)
                (#xB1D3 . #x8A60)
                (#xB1D4 . #x92ED)
                (#xB1D5 . #x6DB2)
                (#xB1D6 . #x75AB)
                (#xB1D7 . #x76CA)
                (#xB1D8 . #x99C5)
                (#xB1D9 . #x60A6)
                (#xB1DA . #x8B01)
                (#xB1DB . #x8D8A)
                (#xB1DC . #x95B2)
                (#xB1DD . #x698E)
                (#xB1DE . #x53AD)
                (#xB1DF . #x5186)
                (#xB1E0 . #x5712)
                (#xB1E1 . #x5830)
                (#xB1E2 . #x5944)
                (#xB1E3 . #x5BB4)
                (#xB1E4 . #x5EF6)
                (#xB1E5 . #x6028)
                (#xB1E6 . #x63A9)
                (#xB1E7 . #x63F4)
                (#xB1E8 . #x6CBF)
                (#xB1E9 . #x6F14)
                (#xB1EA . #x708E)
                (#xB1EB . #x7114)
                (#xB1EC . #x7159)
                (#xB1ED . #x71D5)
                (#xB1EE . #x733F)
                (#xB1EF . #x7E01)
                (#xB1F0 . #x8276)
                (#xB1F1 . #x82D1)
                (#xB1F2 . #x8597)
                (#xB1F3 . #x9060)
                (#xB1F4 . #x925B)
                (#xB1F5 . #x9D1B)
                (#xB1F6 . #x5869)
                (#xB1F7 . #x65BC)
                (#xB1F8 . #x6C5A)
                (#xB1F9 . #x7525)
                (#xB1FA . #x51F9)
                (#xB1FB . #x592E)
                (#xB1FC . #x5965)
                (#xB1FD . #x5F80)
                (#xB1FE . #x5FDC)
                (#xB2A1 . #x62BC)
                (#xB2A2 . #x65FA)
                (#xB2A3 . #x6A2A)
                (#xB2A4 . #x6B27)
                (#xB2A5 . #x6BB4)
                (#xB2A6 . #x738B)
                (#xB2A7 . #x7FC1)
                (#xB2A8 . #x8956)
                (#xB2A9 . #x9D2C)
                (#xB2AA . #x9D0E)
                (#xB2AB . #x9EC4)
                (#xB2AC . #x5CA1)
                (#xB2AD . #x6C96)
                (#xB2AE . #x837B)
                (#xB2AF . #x5104)
                (#xB2B0 . #x5C4B)
                (#xB2B1 . #x61B6)
                (#xB2B2 . #x81C6)
                (#xB2B3 . #x6876)
                (#xB2B4 . #x7261)
                (#xB2B5 . #x4E59)
                (#xB2B6 . #x4FFA)
                (#xB2B7 . #x5378)
                (#xB2B8 . #x6069)
                (#xB2B9 . #x6E29)
                (#xB2BA . #x7A4F)
                (#xB2BB . #x97F3)
                (#xB2BC . #x4E0B)
                (#xB2BD . #x5316)
                (#xB2BE . #x4EEE)
                (#xB2BF . #x4F55)
                (#xB2C0 . #x4F3D)
                (#xB2C1 . #x4FA1)
                (#xB2C2 . #x4F73)
                (#xB2C3 . #x52A0)
                (#xB2C4 . #x53EF)
                (#xB2C5 . #x5609)
                (#xB2C6 . #x590F)
                (#xB2C7 . #x5AC1)
                (#xB2C8 . #x5BB6)
                (#xB2C9 . #x5BE1)
                (#xB2CA . #x79D1)
                (#xB2CB . #x6687)
                (#xB2CC . #x679C)
                (#xB2CD . #x67B6)
                (#xB2CE . #x6B4C)
                (#xB2CF . #x6CB3)
                (#xB2D0 . #x706B)
                (#xB2D1 . #x73C2)
                (#xB2D2 . #x798D)
                (#xB2D3 . #x79BE)
                (#xB2D4 . #x7A3C)
                (#xB2D5 . #x7B87)
                (#xB2D6 . #x82B1)
                (#xB2D7 . #x82DB)
                (#xB2D8 . #x8304)
                (#xB2D9 . #x8377)
                (#xB2DA . #x83EF)
                (#xB2DB . #x83D3)
                (#xB2DC . #x8766)
                (#xB2DD . #x8AB2)
                (#xB2DE . #x5629)
                (#xB2DF . #x8CA8)
                (#xB2E0 . #x8FE6)
                (#xB2E1 . #x904E)
                (#xB2E2 . #x971E)
                (#xB2E3 . #x868A)
                (#xB2E4 . #x4FC4)
                (#xB2E5 . #x5CE8)
                (#xB2E6 . #x6211)
                (#xB2E7 . #x7259)
                (#xB2E8 . #x753B)
                (#xB2E9 . #x81E5)
                (#xB2EA . #x82BD)
                (#xB2EB . #x86FE)
                (#xB2EC . #x8CC0)
                (#xB2ED . #x96C5)
                (#xB2EE . #x9913)
                (#xB2EF . #x99D5)
                (#xB2F0 . #x4ECB)
                (#xB2F1 . #x4F1A)
                (#xB2F2 . #x89E3)
                (#xB2F3 . #x56DE)
                (#xB2F4 . #x584A)
                (#xB2F5 . #x58CA)
                (#xB2F6 . #x5EFB)
                (#xB2F7 . #x5FEB)
                (#xB2F8 . #x602A)
                (#xB2F9 . #x6094)
                (#xB2FA . #x6062)
                (#xB2FB . #x61D0)
                (#xB2FC . #x6212)
                (#xB2FD . #x62D0)
                (#xB2FE . #x6539)
                (#xB3A1 . #x9B41)
                (#xB3A2 . #x6666)
                (#xB3A3 . #x68B0)
                (#xB3A4 . #x6D77)
                (#xB3A5 . #x7070)
                (#xB3A6 . #x754C)
                (#xB3A7 . #x7686)
                (#xB3A8 . #x7D75)
                (#xB3A9 . #x82A5)
                (#xB3AA . #x87F9)
                (#xB3AB . #x958B)
                (#xB3AC . #x968E)
                (#xB3AD . #x8C9D)
                (#xB3AE . #x51F1)
                (#xB3AF . #x52BE)
                (#xB3B0 . #x5916)
                (#xB3B1 . #x54B3)
                (#xB3B2 . #x5BB3)
                (#xB3B3 . #x5D16)
                (#xB3B4 . #x6168)
                (#xB3B5 . #x6982)
                (#xB3B6 . #x6DAF)
                (#xB3B7 . #x788D)
                (#xB3B8 . #x84CB)
                (#xB3B9 . #x8857)
                (#xB3BA . #x8A72)
                (#xB3BB . #x93A7)
                (#xB3BC . #x9AB8)
                (#xB3BD . #x6D6C)
                (#xB3BE . #x99A8)
                (#xB3BF . #x86D9)
                (#xB3C0 . #x57A3)
                (#xB3C1 . #x67FF)
                (#xB3C2 . #x86CE)
                (#xB3C3 . #x920E)
                (#xB3C4 . #x5283)
                (#xB3C5 . #x5687)
                (#xB3C6 . #x5404)
                (#xB3C7 . #x5ED3)
                (#xB3C8 . #x62E1)
                (#xB3C9 . #x64B9)
                (#xB3CA . #x683C)
                (#xB3CB . #x6838)
                (#xB3CC . #x6BBB)
                (#xB3CD . #x7372)
                (#xB3CE . #x78BA)
                (#xB3CF . #x7A6B)
                (#xB3D0 . #x899A)
                (#xB3D1 . #x89D2)
                (#xB3D2 . #x8D6B)
                (#xB3D3 . #x8F03)
                (#xB3D4 . #x90ED)
                (#xB3D5 . #x95A3)
                (#xB3D6 . #x9694)
                (#xB3D7 . #x9769)
                (#xB3D8 . #x5B66)
                (#xB3D9 . #x5CB3)
                (#xB3DA . #x697D)
                (#xB3DB . #x984D)
                (#xB3DC . #x984E)
                (#xB3DD . #x639B)
                (#xB3DE . #x7B20)
                (#xB3DF . #x6A2B)
                (#xB3E0 . #x6A7F)
                (#xB3E1 . #x68B6)
                (#xB3E2 . #x9C0D)
                (#xB3E3 . #x6F5F)
                (#xB3E4 . #x5272)
                (#xB3E5 . #x559D)
                (#xB3E6 . #x6070)
                (#xB3E7 . #x62EC)
                (#xB3E8 . #x6D3B)
                (#xB3E9 . #x6E07)
                (#xB3EA . #x6ED1)
                (#xB3EB . #x845B)
                (#xB3EC . #x8910)
                (#xB3ED . #x8F44)
                (#xB3EE . #x4E14)
                (#xB3EF . #x9C39)
                (#xB3F0 . #x53F6)
                (#xB3F1 . #x691B)
                (#xB3F2 . #x6A3A)
                (#xB3F3 . #x9784)
                (#xB3F4 . #x682A)
                (#xB3F5 . #x515C)
                (#xB3F6 . #x7AC3)
                (#xB3F7 . #x84B2)
                (#xB3F8 . #x91DC)
                (#xB3F9 . #x938C)
                (#xB3FA . #x565B)
                (#xB3FB . #x9D28)
                (#xB3FC . #x6822)
                (#xB3FD . #x8305)
                (#xB3FE . #x8431)
                (#xB4A1 . #x7CA5)
                (#xB4A2 . #x5208)
                (#xB4A3 . #x82C5)
                (#xB4A4 . #x74E6)
                (#xB4A5 . #x4E7E)
                (#xB4A6 . #x4F83)
                (#xB4A7 . #x51A0)
                (#xB4A8 . #x5BD2)
                (#xB4A9 . #x520A)
                (#xB4AA . #x52D8)
                (#xB4AB . #x52E7)
                (#xB4AC . #x5DFB)
                (#xB4AD . #x559A)
                (#xB4AE . #x582A)
                (#xB4AF . #x59E6)
                (#xB4B0 . #x5B8C)
                (#xB4B1 . #x5B98)
                (#xB4B2 . #x5BDB)
                (#xB4B3 . #x5E72)
                (#xB4B4 . #x5E79)
                (#xB4B5 . #x60A3)
                (#xB4B6 . #x611F)
                (#xB4B7 . #x6163)
                (#xB4B8 . #x61BE)
                (#xB4B9 . #x63DB)
                (#xB4BA . #x6562)
                (#xB4BB . #x67D1)
                (#xB4BC . #x6853)
                (#xB4BD . #x68FA)
                (#xB4BE . #x6B3E)
                (#xB4BF . #x6B53)
                (#xB4C0 . #x6C57)
                (#xB4C1 . #x6F22)
                (#xB4C2 . #x6F97)
                (#xB4C3 . #x6F45)
                (#xB4C4 . #x74B0)
                (#xB4C5 . #x7518)
                (#xB4C6 . #x76E3)
                (#xB4C7 . #x770B)
                (#xB4C8 . #x7AFF)
                (#xB4C9 . #x7BA1)
                (#xB4CA . #x7C21)
                (#xB4CB . #x7DE9)
                (#xB4CC . #x7F36)
                (#xB4CD . #x7FF0)
                (#xB4CE . #x809D)
                (#xB4CF . #x8266)
                (#xB4D0 . #x839E)
                (#xB4D1 . #x89B3)
                (#xB4D2 . #x8ACC)
                (#xB4D3 . #x8CAB)
                (#xB4D4 . #x9084)
                (#xB4D5 . #x9451)
                (#xB4D6 . #x9593)
                (#xB4D7 . #x9591)
                (#xB4D8 . #x95A2)
                (#xB4D9 . #x9665)
                (#xB4DA . #x97D3)
                (#xB4DB . #x9928)
                (#xB4DC . #x8218)
                (#xB4DD . #x4E38)
                (#xB4DE . #x542B)
                (#xB4DF . #x5CB8)
                (#xB4E0 . #x5DCC)
                (#xB4E1 . #x73A9)
                (#xB4E2 . #x764C)
                (#xB4E3 . #x773C)
                (#xB4E4 . #x5CA9)
                (#xB4E5 . #x7FEB)
                (#xB4E6 . #x8D0B)
                (#xB4E7 . #x96C1)
                (#xB4E8 . #x9811)
                (#xB4E9 . #x9854)
                (#xB4EA . #x9858)
                (#xB4EB . #x4F01)
                (#xB4EC . #x4F0E)
                (#xB4ED . #x5371)
                (#xB4EE . #x559C)
                (#xB4EF . #x5668)
                (#xB4F0 . #x57FA)
                (#xB4F1 . #x5947)
                (#xB4F2 . #x5B09)
                (#xB4F3 . #x5BC4)
                (#xB4F4 . #x5C90)
                (#xB4F5 . #x5E0C)
                (#xB4F6 . #x5E7E)
                (#xB4F7 . #x5FCC)
                (#xB4F8 . #x63EE)
                (#xB4F9 . #x673A)
                (#xB4FA . #x65D7)
                (#xB4FB . #x65E2)
                (#xB4FC . #x671F)
                (#xB4FD . #x68CB)
                (#xB4FE . #x68C4)
                (#xB5A1 . #x6A5F)
                (#xB5A2 . #x5E30)
                (#xB5A3 . #x6BC5)
                (#xB5A4 . #x6C17)
                (#xB5A5 . #x6C7D)
                (#xB5A6 . #x757F)
                (#xB5A7 . #x7948)
                (#xB5A8 . #x5B63)
                (#xB5A9 . #x7A00)
                (#xB5AA . #x7D00)
                (#xB5AB . #x5FBD)
                (#xB5AC . #x898F)
                (#xB5AD . #x8A18)
                (#xB5AE . #x8CB4)
                (#xB5AF . #x8D77)
                (#xB5B0 . #x8ECC)
                (#xB5B1 . #x8F1D)
                (#xB5B2 . #x98E2)
                (#xB5B3 . #x9A0E)
                (#xB5B4 . #x9B3C)
                (#xB5B5 . #x4E80)
                (#xB5B6 . #x507D)
                (#xB5B7 . #x5100)
                (#xB5B8 . #x5993)
                (#xB5B9 . #x5B9C)
                (#xB5BA . #x622F)
                (#xB5BB . #x6280)
                (#xB5BC . #x64EC)
                (#xB5BD . #x6B3A)
                (#xB5BE . #x72A0)
                (#xB5BF . #x7591)
                (#xB5C0 . #x7947)
                (#xB5C1 . #x7FA9)
                (#xB5C2 . #x87FB)
                (#xB5C3 . #x8ABC)
                (#xB5C4 . #x8B70)
                (#xB5C5 . #x63AC)
                (#xB5C6 . #x83CA)
                (#xB5C7 . #x97A0)
                (#xB5C8 . #x5409)
                (#xB5C9 . #x5403)
                (#xB5CA . #x55AB)
                (#xB5CB . #x6854)
                (#xB5CC . #x6A58)
                (#xB5CD . #x8A70)
                (#xB5CE . #x7827)
                (#xB5CF . #x6775)
                (#xB5D0 . #x9ECD)
                (#xB5D1 . #x5374)
                (#xB5D2 . #x5BA2)
                (#xB5D3 . #x811A)
                (#xB5D4 . #x8650)
                (#xB5D5 . #x9006)
                (#xB5D6 . #x4E18)
                (#xB5D7 . #x4E45)
                (#xB5D8 . #x4EC7)
                (#xB5D9 . #x4F11)
                (#xB5DA . #x53CA)
                (#xB5DB . #x5438)
                (#xB5DC . #x5BAE)
                (#xB5DD . #x5F13)
                (#xB5DE . #x6025)
                (#xB5DF . #x6551)
                (#xB5E0 . #x673D)
                (#xB5E1 . #x6C42)
                (#xB5E2 . #x6C72)
                (#xB5E3 . #x6CE3)
                (#xB5E4 . #x7078)
                (#xB5E5 . #x7403)
                (#xB5E6 . #x7A76)
                (#xB5E7 . #x7AAE)
                (#xB5E8 . #x7B08)
                (#xB5E9 . #x7D1A)
                (#xB5EA . #x7CFE)
                (#xB5EB . #x7D66)
                (#xB5EC . #x65E7)
                (#xB5ED . #x725B)
                (#xB5EE . #x53BB)
                (#xB5EF . #x5C45)
                (#xB5F0 . #x5DE8)
                (#xB5F1 . #x62D2)
                (#xB5F2 . #x62E0)
                (#xB5F3 . #x6319)
                (#xB5F4 . #x6E20)
                (#xB5F5 . #x865A)
                (#xB5F6 . #x8A31)
                (#xB5F7 . #x8DDD)
                (#xB5F8 . #x92F8)
                (#xB5F9 . #x6F01)
                (#xB5FA . #x79A6)
                (#xB5FB . #x9B5A)
                (#xB5FC . #x4EA8)
                (#xB5FD . #x4EAB)
                (#xB5FE . #x4EAC)
                (#xB6A1 . #x4F9B)
                (#xB6A2 . #x4FA0)
                (#xB6A3 . #x50D1)
                (#xB6A4 . #x5147)
                (#xB6A5 . #x7AF6)
                (#xB6A6 . #x5171)
                (#xB6A7 . #x51F6)
                (#xB6A8 . #x5354)
                (#xB6A9 . #x5321)
                (#xB6AA . #x537F)
                (#xB6AB . #x53EB)
                (#xB6AC . #x55AC)
                (#xB6AD . #x5883)
                (#xB6AE . #x5CE1)
                (#xB6AF . #x5F37)
                (#xB6B0 . #x5F4A)
                (#xB6B1 . #x602F)
                (#xB6B2 . #x6050)
                (#xB6B3 . #x606D)
                (#xB6B4 . #x631F)
                (#xB6B5 . #x6559)
                (#xB6B6 . #x6A4B)
                (#xB6B7 . #x6CC1)
                (#xB6B8 . #x72C2)
                (#xB6B9 . #x72ED)
                (#xB6BA . #x77EF)
                (#xB6BB . #x80F8)
                (#xB6BC . #x8105)
                (#xB6BD . #x8208)
                (#xB6BE . #x854E)
                (#xB6BF . #x90F7)
                (#xB6C0 . #x93E1)
                (#xB6C1 . #x97FF)
                (#xB6C2 . #x9957)
                (#xB6C3 . #x9A5A)
                (#xB6C4 . #x4EF0)
                (#xB6C5 . #x51DD)
                (#xB6C6 . #x5C2D)
                (#xB6C7 . #x6681)
                (#xB6C8 . #x696D)
                (#xB6C9 . #x5C40)
                (#xB6CA . #x66F2)
                (#xB6CB . #x6975)
                (#xB6CC . #x7389)
                (#xB6CD . #x6850)
                (#xB6CE . #x7C81)
                (#xB6CF . #x50C5)
                (#xB6D0 . #x52E4)
                (#xB6D1 . #x5747)
                (#xB6D2 . #x5DFE)
                (#xB6D3 . #x9326)
                (#xB6D4 . #x65A4)
                (#xB6D5 . #x6B23)
                (#xB6D6 . #x6B3D)
                (#xB6D7 . #x7434)
                (#xB6D8 . #x7981)
                (#xB6D9 . #x79BD)
                (#xB6DA . #x7B4B)
                (#xB6DB . #x7DCA)
                (#xB6DC . #x82B9)
                (#xB6DD . #x83CC)
                (#xB6DE . #x887F)
                (#xB6DF . #x895F)
                (#xB6E0 . #x8B39)
                (#xB6E1 . #x8FD1)
                (#xB6E2 . #x91D1)
                (#xB6E3 . #x541F)
                (#xB6E4 . #x9280)
                (#xB6E5 . #x4E5D)
                (#xB6E6 . #x5036)
                (#xB6E7 . #x53E5)
                (#xB6E8 . #x533A)
                (#xB6E9 . #x72D7)
                (#xB6EA . #x7396)
                (#xB6EB . #x77E9)
                (#xB6EC . #x82E6)
                (#xB6ED . #x8EAF)
                (#xB6EE . #x99C6)
                (#xB6EF . #x99C8)
                (#xB6F0 . #x99D2)
                (#xB6F1 . #x5177)
                (#xB6F2 . #x611A)
                (#xB6F3 . #x865E)
                (#xB6F4 . #x55B0)
                (#xB6F5 . #x7A7A)
                (#xB6F6 . #x5076)
                (#xB6F7 . #x5BD3)
                (#xB6F8 . #x9047)
                (#xB6F9 . #x9685)
                (#xB6FA . #x4E32)
                (#xB6FB . #x6ADB)
                (#xB6FC . #x91E7)
                (#xB6FD . #x5C51)
                (#xB6FE . #x5C48)
                (#xB7A1 . #x6398)
                (#xB7A2 . #x7A9F)
                (#xB7A3 . #x6C93)
                (#xB7A4 . #x9774)
                (#xB7A5 . #x8F61)
                (#xB7A6 . #x7AAA)
                (#xB7A7 . #x718A)
                (#xB7A8 . #x9688)
                (#xB7A9 . #x7C82)
                (#xB7AA . #x6817)
                (#xB7AB . #x7E70)
                (#xB7AC . #x6851)
                (#xB7AD . #x936C)
                (#xB7AE . #x52F2)
                (#xB7AF . #x541B)
                (#xB7B0 . #x85AB)
                (#xB7B1 . #x8A13)
                (#xB7B2 . #x7FA4)
                (#xB7B3 . #x8ECD)
                (#xB7B4 . #x90E1)
                (#xB7B5 . #x5366)
                (#xB7B6 . #x8888)
                (#xB7B7 . #x7941)
                (#xB7B8 . #x4FC2)
                (#xB7B9 . #x50BE)
                (#xB7BA . #x5211)
                (#xB7BB . #x5144)
                (#xB7BC . #x5553)
                (#xB7BD . #x572D)
                (#xB7BE . #x73EA)
                (#xB7BF . #x578B)
                (#xB7C0 . #x5951)
                (#xB7C1 . #x5F62)
                (#xB7C2 . #x5F84)
                (#xB7C3 . #x6075)
                (#xB7C4 . #x6176)
                (#xB7C5 . #x6167)
                (#xB7C6 . #x61A9)
                (#xB7C7 . #x63B2)
                (#xB7C8 . #x643A)
                (#xB7C9 . #x656C)
                (#xB7CA . #x666F)
                (#xB7CB . #x6842)
                (#xB7CC . #x6E13)
                (#xB7CD . #x7566)
                (#xB7CE . #x7A3D)
                (#xB7CF . #x7CFB)
                (#xB7D0 . #x7D4C)
                (#xB7D1 . #x7D99)
                (#xB7D2 . #x7E4B)
                (#xB7D3 . #x7F6B)
                (#xB7D4 . #x830E)
                (#xB7D5 . #x834A)
                (#xB7D6 . #x86CD)
                (#xB7D7 . #x8A08)
                (#xB7D8 . #x8A63)
                (#xB7D9 . #x8B66)
                (#xB7DA . #x8EFD)
                (#xB7DB . #x981A)
                (#xB7DC . #x9D8F)
                (#xB7DD . #x82B8)
                (#xB7DE . #x8FCE)
                (#xB7DF . #x9BE8)
                (#xB7E0 . #x5287)
                (#xB7E1 . #x621F)
                (#xB7E2 . #x6483)
                (#xB7E3 . #x6FC0)
                (#xB7E4 . #x9699)
                (#xB7E5 . #x6841)
                (#xB7E6 . #x5091)
                (#xB7E7 . #x6B20)
                (#xB7E8 . #x6C7A)
                (#xB7E9 . #x6F54)
                (#xB7EA . #x7A74)
                (#xB7EB . #x7D50)
                (#xB7EC . #x8840)
                (#xB7ED . #x8A23)
                (#xB7EE . #x6708)
                (#xB7EF . #x4EF6)
                (#xB7F0 . #x5039)
                (#xB7F1 . #x5026)
                (#xB7F2 . #x5065)
                (#xB7F3 . #x517C)
                (#xB7F4 . #x5238)
                (#xB7F5 . #x5263)
                (#xB7F6 . #x55A7)
                (#xB7F7 . #x570F)
                (#xB7F8 . #x5805)
                (#xB7F9 . #x5ACC)
                (#xB7FA . #x5EFA)
                (#xB7FB . #x61B2)
                (#xB7FC . #x61F8)
                (#xB7FD . #x62F3)
                (#xB7FE . #x6372)
                (#xB8A1 . #x691C)
                (#xB8A2 . #x6A29)
                (#xB8A3 . #x727D)
                (#xB8A4 . #x72AC)
                (#xB8A5 . #x732E)
                (#xB8A6 . #x7814)
                (#xB8A7 . #x786F)
                (#xB8A8 . #x7D79)
                (#xB8A9 . #x770C)
                (#xB8AA . #x80A9)
                (#xB8AB . #x898B)
                (#xB8AC . #x8B19)
                (#xB8AD . #x8CE2)
                (#xB8AE . #x8ED2)
                (#xB8AF . #x9063)
                (#xB8B0 . #x9375)
                (#xB8B1 . #x967A)
                (#xB8B2 . #x9855)
                (#xB8B3 . #x9A13)
                (#xB8B4 . #x9E78)
                (#xB8B5 . #x5143)
                (#xB8B6 . #x539F)
                (#xB8B7 . #x53B3)
                (#xB8B8 . #x5E7B)
                (#xB8B9 . #x5F26)
                (#xB8BA . #x6E1B)
                (#xB8BB . #x6E90)
                (#xB8BC . #x7384)
                (#xB8BD . #x73FE)
                (#xB8BE . #x7D43)
                (#xB8BF . #x8237)
                (#xB8C0 . #x8A00)
                (#xB8C1 . #x8AFA)
                (#xB8C2 . #x9650)
                (#xB8C3 . #x4E4E)
                (#xB8C4 . #x500B)
                (#xB8C5 . #x53E4)
                (#xB8C6 . #x547C)
                (#xB8C7 . #x56FA)
                (#xB8C8 . #x59D1)
                (#xB8C9 . #x5B64)
                (#xB8CA . #x5DF1)
                (#xB8CB . #x5EAB)
                (#xB8CC . #x5F27)
                (#xB8CD . #x6238)
                (#xB8CE . #x6545)
                (#xB8CF . #x67AF)
                (#xB8D0 . #x6E56)
                (#xB8D1 . #x72D0)
                (#xB8D2 . #x7CCA)
                (#xB8D3 . #x88B4)
                (#xB8D4 . #x80A1)
                (#xB8D5 . #x80E1)
                (#xB8D6 . #x83F0)
                (#xB8D7 . #x864E)
                (#xB8D8 . #x8A87)
                (#xB8D9 . #x8DE8)
                (#xB8DA . #x9237)
                (#xB8DB . #x96C7)
                (#xB8DC . #x9867)
                (#xB8DD . #x9F13)
                (#xB8DE . #x4E94)
                (#xB8DF . #x4E92)
                (#xB8E0 . #x4F0D)
                (#xB8E1 . #x5348)
                (#xB8E2 . #x5449)
                (#xB8E3 . #x543E)
                (#xB8E4 . #x5A2F)
                (#xB8E5 . #x5F8C)
                (#xB8E6 . #x5FA1)
                (#xB8E7 . #x609F)
                (#xB8E8 . #x68A7)
                (#xB8E9 . #x6A8E)
                (#xB8EA . #x745A)
                (#xB8EB . #x7881)
                (#xB8EC . #x8A9E)
                (#xB8ED . #x8AA4)
                (#xB8EE . #x8B77)
                (#xB8EF . #x9190)
                (#xB8F0 . #x4E5E)
                (#xB8F1 . #x9BC9)
                (#xB8F2 . #x4EA4)
                (#xB8F3 . #x4F7C)
                (#xB8F4 . #x4FAF)
                (#xB8F5 . #x5019)
                (#xB8F6 . #x5016)
                (#xB8F7 . #x5149)
                (#xB8F8 . #x516C)
                (#xB8F9 . #x529F)
                (#xB8FA . #x52B9)
                (#xB8FB . #x52FE)
                (#xB8FC . #x539A)
                (#xB8FD . #x53E3)
                (#xB8FE . #x5411)
                (#xB9A1 . #x540E)
                (#xB9A2 . #x5589)
                (#xB9A3 . #x5751)
                (#xB9A4 . #x57A2)
                (#xB9A5 . #x597D)
                (#xB9A6 . #x5B54)
                (#xB9A7 . #x5B5D)
                (#xB9A8 . #x5B8F)
                (#xB9A9 . #x5DE5)
                (#xB9AA . #x5DE7)
                (#xB9AB . #x5DF7)
                (#xB9AC . #x5E78)
                (#xB9AD . #x5E83)
                (#xB9AE . #x5E9A)
                (#xB9AF . #x5EB7)
                (#xB9B0 . #x5F18)
                (#xB9B1 . #x6052)
                (#xB9B2 . #x614C)
                (#xB9B3 . #x6297)
                (#xB9B4 . #x62D8)
                (#xB9B5 . #x63A7)
                (#xB9B6 . #x653B)
                (#xB9B7 . #x6602)
                (#xB9B8 . #x6643)
                (#xB9B9 . #x66F4)
                (#xB9BA . #x676D)
                (#xB9BB . #x6821)
                (#xB9BC . #x6897)
                (#xB9BD . #x69CB)
                (#xB9BE . #x6C5F)
                (#xB9BF . #x6D2A)
                (#xB9C0 . #x6D69)
                (#xB9C1 . #x6E2F)
                (#xB9C2 . #x6E9D)
                (#xB9C3 . #x7532)
                (#xB9C4 . #x7687)
                (#xB9C5 . #x786C)
                (#xB9C6 . #x7A3F)
                (#xB9C7 . #x7CE0)
                (#xB9C8 . #x7D05)
                (#xB9C9 . #x7D18)
                (#xB9CA . #x7D5E)
                (#xB9CB . #x7DB1)
                (#xB9CC . #x8015)
                (#xB9CD . #x8003)
                (#xB9CE . #x80AF)
                (#xB9CF . #x80B1)
                (#xB9D0 . #x8154)
                (#xB9D1 . #x818F)
                (#xB9D2 . #x822A)
                (#xB9D3 . #x8352)
                (#xB9D4 . #x884C)
                (#xB9D5 . #x8861)
                (#xB9D6 . #x8B1B)
                (#xB9D7 . #x8CA2)
                (#xB9D8 . #x8CFC)
                (#xB9D9 . #x90CA)
                (#xB9DA . #x9175)
                (#xB9DB . #x9271)
                (#xB9DC . #x783F)
                (#xB9DD . #x92FC)
                (#xB9DE . #x95A4)
                (#xB9DF . #x964D)
                (#xB9E0 . #x9805)
                (#xB9E1 . #x9999)
                (#xB9E2 . #x9AD8)
                (#xB9E3 . #x9D3B)
                (#xB9E4 . #x525B)
                (#xB9E5 . #x52AB)
                (#xB9E6 . #x53F7)
                (#xB9E7 . #x5408)
                (#xB9E8 . #x58D5)
                (#xB9E9 . #x62F7)
                (#xB9EA . #x6FE0)
                (#xB9EB . #x8C6A)
                (#xB9EC . #x8F5F)
                (#xB9ED . #x9EB9)
                (#xB9EE . #x514B)
                (#xB9EF . #x523B)
                (#xB9F0 . #x544A)
                (#xB9F1 . #x56FD)
                (#xB9F2 . #x7A40)
                (#xB9F3 . #x9177)
                (#xB9F4 . #x9D60)
                (#xB9F5 . #x9ED2)
                (#xB9F6 . #x7344)
                (#xB9F7 . #x6F09)
                (#xB9F8 . #x8170)
                (#xB9F9 . #x7511)
                (#xB9FA . #x5FFD)
                (#xB9FB . #x60DA)
                (#xB9FC . #x9AA8)
                (#xB9FD . #x72DB)
                (#xB9FE . #x8FBC)
                (#xBAA1 . #x6B64)
                (#xBAA2 . #x9803)
                (#xBAA3 . #x4ECA)
                (#xBAA4 . #x56F0)
                (#xBAA5 . #x5764)
                (#xBAA6 . #x58BE)
                (#xBAA7 . #x5A5A)
                (#xBAA8 . #x6068)
                (#xBAA9 . #x61C7)
                (#xBAAA . #x660F)
                (#xBAAB . #x6606)
                (#xBAAC . #x6839)
                (#xBAAD . #x68B1)
                (#xBAAE . #x6DF7)
                (#xBAAF . #x75D5)
                (#xBAB0 . #x7D3A)
                (#xBAB1 . #x826E)
                (#xBAB2 . #x9B42)
                (#xBAB3 . #x4E9B)
                (#xBAB4 . #x4F50)
                (#xBAB5 . #x53C9)
                (#xBAB6 . #x5506)
                (#xBAB7 . #x5D6F)
                (#xBAB8 . #x5DE6)
                (#xBAB9 . #x5DEE)
                (#xBABA . #x67FB)
                (#xBABB . #x6C99)
                (#xBABC . #x7473)
                (#xBABD . #x7802)
                (#xBABE . #x8A50)
                (#xBABF . #x9396)
                (#xBAC0 . #x88DF)
                (#xBAC1 . #x5750)
                (#xBAC2 . #x5EA7)
                (#xBAC3 . #x632B)
                (#xBAC4 . #x50B5)
                (#xBAC5 . #x50AC)
                (#xBAC6 . #x518D)
                (#xBAC7 . #x6700)
                (#xBAC8 . #x54C9)
                (#xBAC9 . #x585E)
                (#xBACA . #x59BB)
                (#xBACB . #x5BB0)
                (#xBACC . #x5F69)
                (#xBACD . #x624D)
                (#xBACE . #x63A1)
                (#xBACF . #x683D)
                (#xBAD0 . #x6B73)
                (#xBAD1 . #x6E08)
                (#xBAD2 . #x707D)
                (#xBAD3 . #x91C7)
                (#xBAD4 . #x7280)
                (#xBAD5 . #x7815)
                (#xBAD6 . #x7826)
                (#xBAD7 . #x796D)
                (#xBAD8 . #x658E)
                (#xBAD9 . #x7D30)
                (#xBADA . #x83DC)
                (#xBADB . #x88C1)
                (#xBADC . #x8F09)
                (#xBADD . #x969B)
                (#xBADE . #x5264)
                (#xBADF . #x5728)
                (#xBAE0 . #x6750)
                (#xBAE1 . #x7F6A)
                (#xBAE2 . #x8CA1)
                (#xBAE3 . #x51B4)
                (#xBAE4 . #x5742)
                (#xBAE5 . #x962A)
                (#xBAE6 . #x583A)
                (#xBAE7 . #x698A)
                (#xBAE8 . #x80B4)
                (#xBAE9 . #x54B2)
                (#xBAEA . #x5D0E)
                (#xBAEB . #x57FC)
                (#xBAEC . #x7895)
                (#xBAED . #x9DFA)
                (#xBAEE . #x4F5C)
                (#xBAEF . #x524A)
                (#xBAF0 . #x548B)
                (#xBAF1 . #x643E)
                (#xBAF2 . #x6628)
                (#xBAF3 . #x6714)
                (#xBAF4 . #x67F5)
                (#xBAF5 . #x7A84)
                (#xBAF6 . #x7B56)
                (#xBAF7 . #x7D22)
                (#xBAF8 . #x932F)
                (#xBAF9 . #x685C)
                (#xBAFA . #x9BAD)
                (#xBAFB . #x7B39)
                (#xBAFC . #x5319)
                (#xBAFD . #x518A)
                (#xBAFE . #x5237)
                (#xBBA1 . #x5BDF)
                (#xBBA2 . #x62F6)
                (#xBBA3 . #x64AE)
                (#xBBA4 . #x64E6)
                (#xBBA5 . #x672D)
                (#xBBA6 . #x6BBA)
                (#xBBA7 . #x85A9)
                (#xBBA8 . #x96D1)
                (#xBBA9 . #x7690)
                (#xBBAA . #x9BD6)
                (#xBBAB . #x634C)
                (#xBBAC . #x9306)
                (#xBBAD . #x9BAB)
                (#xBBAE . #x76BF)
                (#xBBAF . #x6652)
                (#xBBB0 . #x4E09)
                (#xBBB1 . #x5098)
                (#xBBB2 . #x53C2)
                (#xBBB3 . #x5C71)
                (#xBBB4 . #x60E8)
                (#xBBB5 . #x6492)
                (#xBBB6 . #x6563)
                (#xBBB7 . #x685F)
                (#xBBB8 . #x71E6)
                (#xBBB9 . #x73CA)
                (#xBBBA . #x7523)
                (#xBBBB . #x7B97)
                (#xBBBC . #x7E82)
                (#xBBBD . #x8695)
                (#xBBBE . #x8B83)
                (#xBBBF . #x8CDB)
                (#xBBC0 . #x9178)
                (#xBBC1 . #x9910)
                (#xBBC2 . #x65AC)
                (#xBBC3 . #x66AB)
                (#xBBC4 . #x6B8B)
                (#xBBC5 . #x4ED5)
                (#xBBC6 . #x4ED4)
                (#xBBC7 . #x4F3A)
                (#xBBC8 . #x4F7F)
                (#xBBC9 . #x523A)
                (#xBBCA . #x53F8)
                (#xBBCB . #x53F2)
                (#xBBCC . #x55E3)
                (#xBBCD . #x56DB)
                (#xBBCE . #x58EB)
                (#xBBCF . #x59CB)
                (#xBBD0 . #x59C9)
                (#xBBD1 . #x59FF)
                (#xBBD2 . #x5B50)
                (#xBBD3 . #x5C4D)
                (#xBBD4 . #x5E02)
                (#xBBD5 . #x5E2B)
                (#xBBD6 . #x5FD7)
                (#xBBD7 . #x601D)
                (#xBBD8 . #x6307)
                (#xBBD9 . #x652F)
                (#xBBDA . #x5B5C)
                (#xBBDB . #x65AF)
                (#xBBDC . #x65BD)
                (#xBBDD . #x65E8)
                (#xBBDE . #x679D)
                (#xBBDF . #x6B62)
                (#xBBE0 . #x6B7B)
                (#xBBE1 . #x6C0F)
                (#xBBE2 . #x7345)
                (#xBBE3 . #x7949)
                (#xBBE4 . #x79C1)
                (#xBBE5 . #x7CF8)
                (#xBBE6 . #x7D19)
                (#xBBE7 . #x7D2B)
                (#xBBE8 . #x80A2)
                (#xBBE9 . #x8102)
                (#xBBEA . #x81F3)
                (#xBBEB . #x8996)
                (#xBBEC . #x8A5E)
                (#xBBED . #x8A69)
                (#xBBEE . #x8A66)
                (#xBBEF . #x8A8C)
                (#xBBF0 . #x8AEE)
                (#xBBF1 . #x8CC7)
                (#xBBF2 . #x8CDC)
                (#xBBF3 . #x96CC)
                (#xBBF4 . #x98FC)
                (#xBBF5 . #x6B6F)
                (#xBBF6 . #x4E8B)
                (#xBBF7 . #x4F3C)
                (#xBBF8 . #x4F8D)
                (#xBBF9 . #x5150)
                (#xBBFA . #x5B57)
                (#xBBFB . #x5BFA)
                (#xBBFC . #x6148)
                (#xBBFD . #x6301)
                (#xBBFE . #x6642)
                (#xBCA1 . #x6B21)
                (#xBCA2 . #x6ECB)
                (#xBCA3 . #x6CBB)
                (#xBCA4 . #x723E)
                (#xBCA5 . #x74BD)
                (#xBCA6 . #x75D4)
                (#xBCA7 . #x78C1)
                (#xBCA8 . #x793A)
                (#xBCA9 . #x800C)
                (#xBCAA . #x8033)
                (#xBCAB . #x81EA)
                (#xBCAC . #x8494)
                (#xBCAD . #x8F9E)
                (#xBCAE . #x6C50)
                (#xBCAF . #x9E7F)
                (#xBCB0 . #x5F0F)
                (#xBCB1 . #x8B58)
                (#xBCB2 . #x9D2B)
                (#xBCB3 . #x7AFA)
                (#xBCB4 . #x8EF8)
                (#xBCB5 . #x5B8D)
                (#xBCB6 . #x96EB)
                (#xBCB7 . #x4E03)
                (#xBCB8 . #x53F1)
                (#xBCB9 . #x57F7)
                (#xBCBA . #x5931)
                (#xBCBB . #x5AC9)
                (#xBCBC . #x5BA4)
                (#xBCBD . #x6089)
                (#xBCBE . #x6E7F)
                (#xBCBF . #x6F06)
                (#xBCC0 . #x75BE)
                (#xBCC1 . #x8CEA)
                (#xBCC2 . #x5B9F)
                (#xBCC3 . #x8500)
                (#xBCC4 . #x7BE0)
                (#xBCC5 . #x5072)
                (#xBCC6 . #x67F4)
                (#xBCC7 . #x829D)
                (#xBCC8 . #x5C61)
                (#xBCC9 . #x854A)
                (#xBCCA . #x7E1E)
                (#xBCCB . #x820E)
                (#xBCCC . #x5199)
                (#xBCCD . #x5C04)
                (#xBCCE . #x6368)
                (#xBCCF . #x8D66)
                (#xBCD0 . #x659C)
                (#xBCD1 . #x716E)
                (#xBCD2 . #x793E)
                (#xBCD3 . #x7D17)
                (#xBCD4 . #x8005)
                (#xBCD5 . #x8B1D)
                (#xBCD6 . #x8ECA)
                (#xBCD7 . #x906E)
                (#xBCD8 . #x86C7)
                (#xBCD9 . #x90AA)
                (#xBCDA . #x501F)
                (#xBCDB . #x52FA)
                (#xBCDC . #x5C3A)
                (#xBCDD . #x6753)
                (#xBCDE . #x707C)
                (#xBCDF . #x7235)
                (#xBCE0 . #x914C)
                (#xBCE1 . #x91C8)
                (#xBCE2 . #x932B)
                (#xBCE3 . #x82E5)
                (#xBCE4 . #x5BC2)
                (#xBCE5 . #x5F31)
                (#xBCE6 . #x60F9)
                (#xBCE7 . #x4E3B)
                (#xBCE8 . #x53D6)
                (#xBCE9 . #x5B88)
                (#xBCEA . #x624B)
                (#xBCEB . #x6731)
                (#xBCEC . #x6B8A)
                (#xBCED . #x72E9)
                (#xBCEE . #x73E0)
                (#xBCEF . #x7A2E)
                (#xBCF0 . #x816B)
                (#xBCF1 . #x8DA3)
                (#xBCF2 . #x9152)
                (#xBCF3 . #x9996)
                (#xBCF4 . #x5112)
                (#xBCF5 . #x53D7)
                (#xBCF6 . #x546A)
                (#xBCF7 . #x5BFF)
                (#xBCF8 . #x6388)
                (#xBCF9 . #x6A39)
                (#xBCFA . #x7DAC)
                (#xBCFB . #x9700)
                (#xBCFC . #x56DA)
                (#xBCFD . #x53CE)
                (#xBCFE . #x5468)
                (#xBDA1 . #x5B97)
                (#xBDA2 . #x5C31)
                (#xBDA3 . #x5DDE)
                (#xBDA4 . #x4FEE)
                (#xBDA5 . #x6101)
                (#xBDA6 . #x62FE)
                (#xBDA7 . #x6D32)
                (#xBDA8 . #x79C0)
                (#xBDA9 . #x79CB)
                (#xBDAA . #x7D42)
                (#xBDAB . #x7E4D)
                (#xBDAC . #x7FD2)
                (#xBDAD . #x81ED)
                (#xBDAE . #x821F)
                (#xBDAF . #x8490)
                (#xBDB0 . #x8846)
                (#xBDB1 . #x8972)
                (#xBDB2 . #x8B90)
                (#xBDB3 . #x8E74)
                (#xBDB4 . #x8F2F)
                (#xBDB5 . #x9031)
                (#xBDB6 . #x914B)
                (#xBDB7 . #x916C)
                (#xBDB8 . #x96C6)
                (#xBDB9 . #x919C)
                (#xBDBA . #x4EC0)
                (#xBDBB . #x4F4F)
                (#xBDBC . #x5145)
                (#xBDBD . #x5341)
                (#xBDBE . #x5F93)
                (#xBDBF . #x620E)
                (#xBDC0 . #x67D4)
                (#xBDC1 . #x6C41)
                (#xBDC2 . #x6E0B)
                (#xBDC3 . #x7363)
                (#xBDC4 . #x7E26)
                (#xBDC5 . #x91CD)
                (#xBDC6 . #x9283)
                (#xBDC7 . #x53D4)
                (#xBDC8 . #x5919)
                (#xBDC9 . #x5BBF)
                (#xBDCA . #x6DD1)
                (#xBDCB . #x795D)
                (#xBDCC . #x7E2E)
                (#xBDCD . #x7C9B)
                (#xBDCE . #x587E)
                (#xBDCF . #x719F)
                (#xBDD0 . #x51FA)
                (#xBDD1 . #x8853)
                (#xBDD2 . #x8FF0)
                (#xBDD3 . #x4FCA)
                (#xBDD4 . #x5CFB)
                (#xBDD5 . #x6625)
                (#xBDD6 . #x77AC)
                (#xBDD7 . #x7AE3)
                (#xBDD8 . #x821C)
                (#xBDD9 . #x99FF)
                (#xBDDA . #x51C6)
                (#xBDDB . #x5FAA)
                (#xBDDC . #x65EC)
                (#xBDDD . #x696F)
                (#xBDDE . #x6B89)
                (#xBDDF . #x6DF3)
                (#xBDE0 . #x6E96)
                (#xBDE1 . #x6F64)
                (#xBDE2 . #x76FE)
                (#xBDE3 . #x7D14)
                (#xBDE4 . #x5DE1)
                (#xBDE5 . #x9075)
                (#xBDE6 . #x9187)
                (#xBDE7 . #x9806)
                (#xBDE8 . #x51E6)
                (#xBDE9 . #x521D)
                (#xBDEA . #x6240)
                (#xBDEB . #x6691)
                (#xBDEC . #x66D9)
                (#xBDED . #x6E1A)
                (#xBDEE . #x5EB6)
                (#xBDEF . #x7DD2)
                (#xBDF0 . #x7F72)
                (#xBDF1 . #x66F8)
                (#xBDF2 . #x85AF)
                (#xBDF3 . #x85F7)
                (#xBDF4 . #x8AF8)
                (#xBDF5 . #x52A9)
                (#xBDF6 . #x53D9)
                (#xBDF7 . #x5973)
                (#xBDF8 . #x5E8F)
                (#xBDF9 . #x5F90)
                (#xBDFA . #x6055)
                (#xBDFB . #x92E4)
                (#xBDFC . #x9664)
                (#xBDFD . #x50B7)
                (#xBDFE . #x511F)
                (#xBEA1 . #x52DD)
                (#xBEA2 . #x5320)
                (#xBEA3 . #x5347)
                (#xBEA4 . #x53EC)
                (#xBEA5 . #x54E8)
                (#xBEA6 . #x5546)
                (#xBEA7 . #x5531)
                (#xBEA8 . #x5617)
                (#xBEA9 . #x5968)
                (#xBEAA . #x59BE)
                (#xBEAB . #x5A3C)
                (#xBEAC . #x5BB5)
                (#xBEAD . #x5C06)
                (#xBEAE . #x5C0F)
                (#xBEAF . #x5C11)
                (#xBEB0 . #x5C1A)
                (#xBEB1 . #x5E84)
                (#xBEB2 . #x5E8A)
                (#xBEB3 . #x5EE0)
                (#xBEB4 . #x5F70)
                (#xBEB5 . #x627F)
                (#xBEB6 . #x6284)
                (#xBEB7 . #x62DB)
                (#xBEB8 . #x638C)
                (#xBEB9 . #x6377)
                (#xBEBA . #x6607)
                (#xBEBB . #x660C)
                (#xBEBC . #x662D)
                (#xBEBD . #x6676)
                (#xBEBE . #x677E)
                (#xBEBF . #x68A2)
                (#xBEC0 . #x6A1F)
                (#xBEC1 . #x6A35)
                (#xBEC2 . #x6CBC)
                (#xBEC3 . #x6D88)
                (#xBEC4 . #x6E09)
                (#xBEC5 . #x6E58)
                (#xBEC6 . #x713C)
                (#xBEC7 . #x7126)
                (#xBEC8 . #x7167)
                (#xBEC9 . #x75C7)
                (#xBECA . #x7701)
                (#xBECB . #x785D)
                (#xBECC . #x7901)
                (#xBECD . #x7965)
                (#xBECE . #x79F0)
                (#xBECF . #x7AE0)
                (#xBED0 . #x7B11)
                (#xBED1 . #x7CA7)
                (#xBED2 . #x7D39)
                (#xBED3 . #x8096)
                (#xBED4 . #x83D6)
                (#xBED5 . #x848B)
                (#xBED6 . #x8549)
                (#xBED7 . #x885D)
                (#xBED8 . #x88F3)
                (#xBED9 . #x8A1F)
                (#xBEDA . #x8A3C)
                (#xBEDB . #x8A54)
                (#xBEDC . #x8A73)
                (#xBEDD . #x8C61)
                (#xBEDE . #x8CDE)
                (#xBEDF . #x91A4)
                (#xBEE0 . #x9266)
                (#xBEE1 . #x937E)
                (#xBEE2 . #x9418)
                (#xBEE3 . #x969C)
                (#xBEE4 . #x9798)
                (#xBEE5 . #x4E0A)
                (#xBEE6 . #x4E08)
                (#xBEE7 . #x4E1E)
                (#xBEE8 . #x4E57)
                (#xBEE9 . #x5197)
                (#xBEEA . #x5270)
                (#xBEEB . #x57CE)
                (#xBEEC . #x5834)
                (#xBEED . #x58CC)
                (#xBEEE . #x5B22)
                (#xBEEF . #x5E38)
                (#xBEF0 . #x60C5)
                (#xBEF1 . #x64FE)
                (#xBEF2 . #x6761)
                (#xBEF3 . #x6756)
                (#xBEF4 . #x6D44)
                (#xBEF5 . #x72B6)
                (#xBEF6 . #x7573)
                (#xBEF7 . #x7A63)
                (#xBEF8 . #x84B8)
                (#xBEF9 . #x8B72)
                (#xBEFA . #x91B8)
                (#xBEFB . #x9320)
                (#xBEFC . #x5631)
                (#xBEFD . #x57F4)
                (#xBEFE . #x98FE)
                (#xBFA1 . #x62ED)
                (#xBFA2 . #x690D)
                (#xBFA3 . #x6B96)
                (#xBFA4 . #x71ED)
                (#xBFA5 . #x7E54)
                (#xBFA6 . #x8077)
                (#xBFA7 . #x8272)
                (#xBFA8 . #x89E6)
                (#xBFA9 . #x98DF)
                (#xBFAA . #x8755)
                (#xBFAB . #x8FB1)
                (#xBFAC . #x5C3B)
                (#xBFAD . #x4F38)
                (#xBFAE . #x4FE1)
                (#xBFAF . #x4FB5)
                (#xBFB0 . #x5507)
                (#xBFB1 . #x5A20)
                (#xBFB2 . #x5BDD)
                (#xBFB3 . #x5BE9)
                (#xBFB4 . #x5FC3)
                (#xBFB5 . #x614E)
                (#xBFB6 . #x632F)
                (#xBFB7 . #x65B0)
                (#xBFB8 . #x664B)
                (#xBFB9 . #x68EE)
                (#xBFBA . #x699B)
                (#xBFBB . #x6D78)
                (#xBFBC . #x6DF1)
                (#xBFBD . #x7533)
                (#xBFBE . #x75B9)
                (#xBFBF . #x771F)
                (#xBFC0 . #x795E)
                (#xBFC1 . #x79E6)
                (#xBFC2 . #x7D33)
                (#xBFC3 . #x81E3)
                (#xBFC4 . #x82AF)
                (#xBFC5 . #x85AA)
                (#xBFC6 . #x89AA)
                (#xBFC7 . #x8A3A)
                (#xBFC8 . #x8EAB)
                (#xBFC9 . #x8F9B)
                (#xBFCA . #x9032)
                (#xBFCB . #x91DD)
                (#xBFCC . #x9707)
                (#xBFCD . #x4EBA)
                (#xBFCE . #x4EC1)
                (#xBFCF . #x5203)
                (#xBFD0 . #x5875)
                (#xBFD1 . #x58EC)
                (#xBFD2 . #x5C0B)
                (#xBFD3 . #x751A)
                (#xBFD4 . #x5C3D)
                (#xBFD5 . #x814E)
                (#xBFD6 . #x8A0A)
                (#xBFD7 . #x8FC5)
                (#xBFD8 . #x9663)
                (#xBFD9 . #x976D)
                (#xBFDA . #x7B25)
                (#xBFDB . #x8ACF)
                (#xBFDC . #x9808)
                (#xBFDD . #x9162)
                (#xBFDE . #x56F3)
                (#xBFDF . #x53A8)
                (#xBFE0 . #x9017)
                (#xBFE1 . #x5439)
                (#xBFE2 . #x5782)
                (#xBFE3 . #x5E25)
                (#xBFE4 . #x63A8)
                (#xBFE5 . #x6C34)
                (#xBFE6 . #x708A)
                (#xBFE7 . #x7761)
                (#xBFE8 . #x7C8B)
                (#xBFE9 . #x7FE0)
                (#xBFEA . #x8870)
                (#xBFEB . #x9042)
                (#xBFEC . #x9154)
                (#xBFED . #x9310)
                (#xBFEE . #x9318)
                (#xBFEF . #x968F)
                (#xBFF0 . #x745E)
                (#xBFF1 . #x9AC4)
                (#xBFF2 . #x5D07)
                (#xBFF3 . #x5D69)
                (#xBFF4 . #x6570)
                (#xBFF5 . #x67A2)
                (#xBFF6 . #x8DA8)
                (#xBFF7 . #x96DB)
                (#xBFF8 . #x636E)
                (#xBFF9 . #x6749)
                (#xBFFA . #x6919)
                (#xBFFB . #x83C5)
                (#xBFFC . #x9817)
                (#xBFFD . #x96C0)
                (#xBFFE . #x88FE)
                (#xC0A1 . #x6F84)
                (#xC0A2 . #x647A)
                (#xC0A3 . #x5BF8)
                (#xC0A4 . #x4E16)
                (#xC0A5 . #x702C)
                (#xC0A6 . #x755D)
                (#xC0A7 . #x662F)
                (#xC0A8 . #x51C4)
                (#xC0A9 . #x5236)
                (#xC0AA . #x52E2)
                (#xC0AB . #x59D3)
                (#xC0AC . #x5F81)
                (#xC0AD . #x6027)
                (#xC0AE . #x6210)
                (#xC0AF . #x653F)
                (#xC0B0 . #x6574)
                (#xC0B1 . #x661F)
                (#xC0B2 . #x6674)
                (#xC0B3 . #x68F2)
                (#xC0B4 . #x6816)
                (#xC0B5 . #x6B63)
                (#xC0B6 . #x6E05)
                (#xC0B7 . #x7272)
                (#xC0B8 . #x751F)
                (#xC0B9 . #x76DB)
                (#xC0BA . #x7CBE)
                (#xC0BB . #x8056)
                (#xC0BC . #x58F0)
                (#xC0BD . #x88FD)
                (#xC0BE . #x897F)
                (#xC0BF . #x8AA0)
                (#xC0C0 . #x8A93)
                (#xC0C1 . #x8ACB)
                (#xC0C2 . #x901D)
                (#xC0C3 . #x9192)
                (#xC0C4 . #x9752)
                (#xC0C5 . #x9759)
                (#xC0C6 . #x6589)
                (#xC0C7 . #x7A0E)
                (#xC0C8 . #x8106)
                (#xC0C9 . #x96BB)
                (#xC0CA . #x5E2D)
                (#xC0CB . #x60DC)
                (#xC0CC . #x621A)
                (#xC0CD . #x65A5)
                (#xC0CE . #x6614)
                (#xC0CF . #x6790)
                (#xC0D0 . #x77F3)
                (#xC0D1 . #x7A4D)
                (#xC0D2 . #x7C4D)
                (#xC0D3 . #x7E3E)
                (#xC0D4 . #x810A)
                (#xC0D5 . #x8CAC)
                (#xC0D6 . #x8D64)
                (#xC0D7 . #x8DE1)
                (#xC0D8 . #x8E5F)
                (#xC0D9 . #x78A9)
                (#xC0DA . #x5207)
                (#xC0DB . #x62D9)
                (#xC0DC . #x63A5)
                (#xC0DD . #x6442)
                (#xC0DE . #x6298)
                (#xC0DF . #x8A2D)
                (#xC0E0 . #x7A83)
                (#xC0E1 . #x7BC0)
                (#xC0E2 . #x8AAC)
                (#xC0E3 . #x96EA)
                (#xC0E4 . #x7D76)
                (#xC0E5 . #x820C)
                (#xC0E6 . #x8749)
                (#xC0E7 . #x4ED9)
                (#xC0E8 . #x5148)
                (#xC0E9 . #x5343)
                (#xC0EA . #x5360)
                (#xC0EB . #x5BA3)
                (#xC0EC . #x5C02)
                (#xC0ED . #x5C16)
                (#xC0EE . #x5DDD)
                (#xC0EF . #x6226)
                (#xC0F0 . #x6247)
                (#xC0F1 . #x64B0)
                (#xC0F2 . #x6813)
                (#xC0F3 . #x6834)
                (#xC0F4 . #x6CC9)
                (#xC0F5 . #x6D45)
                (#xC0F6 . #x6D17)
                (#xC0F7 . #x67D3)
                (#xC0F8 . #x6F5C)
                (#xC0F9 . #x714E)
                (#xC0FA . #x717D)
                (#xC0FB . #x65CB)
                (#xC0FC . #x7A7F)
                (#xC0FD . #x7BAD)
                (#xC0FE . #x7DDA)
                (#xC1A1 . #x7E4A)
                (#xC1A2 . #x7FA8)
                (#xC1A3 . #x817A)
                (#xC1A4 . #x821B)
                (#xC1A5 . #x8239)
                (#xC1A6 . #x85A6)
                (#xC1A7 . #x8A6E)
                (#xC1A8 . #x8CCE)
                (#xC1A9 . #x8DF5)
                (#xC1AA . #x9078)
                (#xC1AB . #x9077)
                (#xC1AC . #x92AD)
                (#xC1AD . #x9291)
                (#xC1AE . #x9583)
                (#xC1AF . #x9BAE)
                (#xC1B0 . #x524D)
                (#xC1B1 . #x5584)
                (#xC1B2 . #x6F38)
                (#xC1B3 . #x7136)
                (#xC1B4 . #x5168)
                (#xC1B5 . #x7985)
                (#xC1B6 . #x7E55)
                (#xC1B7 . #x81B3)
                (#xC1B8 . #x7CCE)
                (#xC1B9 . #x564C)
                (#xC1BA . #x5851)
                (#xC1BB . #x5CA8)
                (#xC1BC . #x63AA)
                (#xC1BD . #x66FE)
                (#xC1BE . #x66FD)
                (#xC1BF . #x695A)
                (#xC1C0 . #x72D9)
                (#xC1C1 . #x758F)
                (#xC1C2 . #x758E)
                (#xC1C3 . #x790E)
                (#xC1C4 . #x7956)
                (#xC1C5 . #x79DF)
                (#xC1C6 . #x7C97)
                (#xC1C7 . #x7D20)
                (#xC1C8 . #x7D44)
                (#xC1C9 . #x8607)
                (#xC1CA . #x8A34)
                (#xC1CB . #x963B)
                (#xC1CC . #x9061)
                (#xC1CD . #x9F20)
                (#xC1CE . #x50E7)
                (#xC1CF . #x5275)
                (#xC1D0 . #x53CC)
                (#xC1D1 . #x53E2)
                (#xC1D2 . #x5009)
                (#xC1D3 . #x55AA)
                (#xC1D4 . #x58EE)
                (#xC1D5 . #x594F)
                (#xC1D6 . #x723D)
                (#xC1D7 . #x5B8B)
                (#xC1D8 . #x5C64)
                (#xC1D9 . #x531D)
                (#xC1DA . #x60E3)
                (#xC1DB . #x60F3)
                (#xC1DC . #x635C)
                (#xC1DD . #x6383)
                (#xC1DE . #x633F)
                (#xC1DF . #x63BB)
                (#xC1E0 . #x64CD)
                (#xC1E1 . #x65E9)
                (#xC1E2 . #x66F9)
                (#xC1E3 . #x5DE3)
                (#xC1E4 . #x69CD)
                (#xC1E5 . #x69FD)
                (#xC1E6 . #x6F15)
                (#xC1E7 . #x71E5)
                (#xC1E8 . #x4E89)
                (#xC1E9 . #x75E9)
                (#xC1EA . #x76F8)
                (#xC1EB . #x7A93)
                (#xC1EC . #x7CDF)
                (#xC1ED . #x7DCF)
                (#xC1EE . #x7D9C)
                (#xC1EF . #x8061)
                (#xC1F0 . #x8349)
                (#xC1F1 . #x8358)
                (#xC1F2 . #x846C)
                (#xC1F3 . #x84BC)
                (#xC1F4 . #x85FB)
                (#xC1F5 . #x88C5)
                (#xC1F6 . #x8D70)
                (#xC1F7 . #x9001)
                (#xC1F8 . #x906D)
                (#xC1F9 . #x9397)
                (#xC1FA . #x971C)
                (#xC1FB . #x9A12)
                (#xC1FC . #x50CF)
                (#xC1FD . #x5897)
                (#xC1FE . #x618E)
                (#xC2A1 . #x81D3)
                (#xC2A2 . #x8535)
                (#xC2A3 . #x8D08)
                (#xC2A4 . #x9020)
                (#xC2A5 . #x4FC3)
                (#xC2A6 . #x5074)
                (#xC2A7 . #x5247)
                (#xC2A8 . #x5373)
                (#xC2A9 . #x606F)
                (#xC2AA . #x6349)
                (#xC2AB . #x675F)
                (#xC2AC . #x6E2C)
                (#xC2AD . #x8DB3)
                (#xC2AE . #x901F)
                (#xC2AF . #x4FD7)
                (#xC2B0 . #x5C5E)
                (#xC2B1 . #x8CCA)
                (#xC2B2 . #x65CF)
                (#xC2B3 . #x7D9A)
                (#xC2B4 . #x5352)
                (#xC2B5 . #x8896)
                (#xC2B6 . #x5176)
                (#xC2B7 . #x63C3)
                (#xC2B8 . #x5B58)
                (#xC2B9 . #x5B6B)
                (#xC2BA . #x5C0A)
                (#xC2BB . #x640D)
                (#xC2BC . #x6751)
                (#xC2BD . #x905C)
                (#xC2BE . #x4ED6)
                (#xC2BF . #x591A)
                (#xC2C0 . #x592A)
                (#xC2C1 . #x6C70)
                (#xC2C2 . #x8A51)
                (#xC2C3 . #x553E)
                (#xC2C4 . #x5815)
                (#xC2C5 . #x59A5)
                (#xC2C6 . #x60F0)
                (#xC2C7 . #x6253)
                (#xC2C8 . #x67C1)
                (#xC2C9 . #x8235)
                (#xC2CA . #x6955)
                (#xC2CB . #x9640)
                (#xC2CC . #x99C4)
                (#xC2CD . #x9A28)
                (#xC2CE . #x4F53)
                (#xC2CF . #x5806)
                (#xC2D0 . #x5BFE)
                (#xC2D1 . #x8010)
                (#xC2D2 . #x5CB1)
                (#xC2D3 . #x5E2F)
                (#xC2D4 . #x5F85)
                (#xC2D5 . #x6020)
                (#xC2D6 . #x614B)
                (#xC2D7 . #x6234)
                (#xC2D8 . #x66FF)
                (#xC2D9 . #x6CF0)
                (#xC2DA . #x6EDE)
                (#xC2DB . #x80CE)
                (#xC2DC . #x817F)
                (#xC2DD . #x82D4)
                (#xC2DE . #x888B)
                (#xC2DF . #x8CB8)
                (#xC2E0 . #x9000)
                (#xC2E1 . #x902E)
                (#xC2E2 . #x968A)
                (#xC2E3 . #x9EDB)
                (#xC2E4 . #x9BDB)
                (#xC2E5 . #x4EE3)
                (#xC2E6 . #x53F0)
                (#xC2E7 . #x5927)
                (#xC2E8 . #x7B2C)
                (#xC2E9 . #x918D)
                (#xC2EA . #x984C)
                (#xC2EB . #x9DF9)
                (#xC2EC . #x6EDD)
                (#xC2ED . #x7027)
                (#xC2EE . #x5353)
                (#xC2EF . #x5544)
                (#xC2F0 . #x5B85)
                (#xC2F1 . #x6258)
                (#xC2F2 . #x629E)
                (#xC2F3 . #x62D3)
                (#xC2F4 . #x6CA2)
                (#xC2F5 . #x6FEF)
                (#xC2F6 . #x7422)
                (#xC2F7 . #x8A17)
                (#xC2F8 . #x9438)
                (#xC2F9 . #x6FC1)
                (#xC2FA . #x8AFE)
                (#xC2FB . #x8338)
                (#xC2FC . #x51E7)
                (#xC2FD . #x86F8)
                (#xC2FE . #x53EA)
                (#xC3A1 . #x53E9)
                (#xC3A2 . #x4F46)
                (#xC3A3 . #x9054)
                (#xC3A4 . #x8FB0)
                (#xC3A5 . #x596A)
                (#xC3A6 . #x8131)
                (#xC3A7 . #x5DFD)
                (#xC3A8 . #x7AEA)
                (#xC3A9 . #x8FBF)
                (#xC3AA . #x68DA)
                (#xC3AB . #x8C37)
                (#xC3AC . #x72F8)
                (#xC3AD . #x9C48)
                (#xC3AE . #x6A3D)
                (#xC3AF . #x8AB0)
                (#xC3B0 . #x4E39)
                (#xC3B1 . #x5358)
                (#xC3B2 . #x5606)
                (#xC3B3 . #x5766)
                (#xC3B4 . #x62C5)
                (#xC3B5 . #x63A2)
                (#xC3B6 . #x65E6)
                (#xC3B7 . #x6B4E)
                (#xC3B8 . #x6DE1)
                (#xC3B9 . #x6E5B)
                (#xC3BA . #x70AD)
                (#xC3BB . #x77ED)
                (#xC3BC . #x7AEF)
                (#xC3BD . #x7BAA)
                (#xC3BE . #x7DBB)
                (#xC3BF . #x803D)
                (#xC3C0 . #x80C6)
                (#xC3C1 . #x86CB)
                (#xC3C2 . #x8A95)
                (#xC3C3 . #x935B)
                (#xC3C4 . #x56E3)
                (#xC3C5 . #x58C7)
                (#xC3C6 . #x5F3E)
                (#xC3C7 . #x65AD)
                (#xC3C8 . #x6696)
                (#xC3C9 . #x6A80)
                (#xC3CA . #x6BB5)
                (#xC3CB . #x7537)
                (#xC3CC . #x8AC7)
                (#xC3CD . #x5024)
                (#xC3CE . #x77E5)
                (#xC3CF . #x5730)
                (#xC3D0 . #x5F1B)
                (#xC3D1 . #x6065)
                (#xC3D2 . #x667A)
                (#xC3D3 . #x6C60)
                (#xC3D4 . #x75F4)
                (#xC3D5 . #x7A1A)
                (#xC3D6 . #x7F6E)
                (#xC3D7 . #x81F4)
                (#xC3D8 . #x8718)
                (#xC3D9 . #x9045)
                (#xC3DA . #x99B3)
                (#xC3DB . #x7BC9)
                (#xC3DC . #x755C)
                (#xC3DD . #x7AF9)
                (#xC3DE . #x7B51)
                (#xC3DF . #x84C4)
                (#xC3E0 . #x9010)
                (#xC3E1 . #x79E9)
                (#xC3E2 . #x7A92)
                (#xC3E3 . #x8336)
                (#xC3E4 . #x5AE1)
                (#xC3E5 . #x7740)
                (#xC3E6 . #x4E2D)
                (#xC3E7 . #x4EF2)
                (#xC3E8 . #x5B99)
                (#xC3E9 . #x5FE0)
                (#xC3EA . #x62BD)
                (#xC3EB . #x663C)
                (#xC3EC . #x67F1)
                (#xC3ED . #x6CE8)
                (#xC3EE . #x866B)
                (#xC3EF . #x8877)
                (#xC3F0 . #x8A3B)
                (#xC3F1 . #x914E)
                (#xC3F2 . #x92F3)
                (#xC3F3 . #x99D0)
                (#xC3F4 . #x6A17)
                (#xC3F5 . #x7026)
                (#xC3F6 . #x732A)
                (#xC3F7 . #x82E7)
                (#xC3F8 . #x8457)
                (#xC3F9 . #x8CAF)
                (#xC3FA . #x4E01)
                (#xC3FB . #x5146)
                (#xC3FC . #x51CB)
                (#xC3FD . #x558B)
                (#xC3FE . #x5BF5)
                (#xC4A1 . #x5E16)
                (#xC4A2 . #x5E33)
                (#xC4A3 . #x5E81)
                (#xC4A4 . #x5F14)
                (#xC4A5 . #x5F35)
                (#xC4A6 . #x5F6B)
                (#xC4A7 . #x5FB4)
                (#xC4A8 . #x61F2)
                (#xC4A9 . #x6311)
                (#xC4AA . #x66A2)
                (#xC4AB . #x671D)
                (#xC4AC . #x6F6E)
                (#xC4AD . #x7252)
                (#xC4AE . #x753A)
                (#xC4AF . #x773A)
                (#xC4B0 . #x8074)
                (#xC4B1 . #x8139)
                (#xC4B2 . #x8178)
                (#xC4B3 . #x8776)
                (#xC4B4 . #x8ABF)
                (#xC4B5 . #x8ADC)
                (#xC4B6 . #x8D85)
                (#xC4B7 . #x8DF3)
                (#xC4B8 . #x929A)
                (#xC4B9 . #x9577)
                (#xC4BA . #x9802)
                (#xC4BB . #x9CE5)
                (#xC4BC . #x52C5)
                (#xC4BD . #x6357)
                (#xC4BE . #x76F4)
                (#xC4BF . #x6715)
                (#xC4C0 . #x6C88)
                (#xC4C1 . #x73CD)
                (#xC4C2 . #x8CC3)
                (#xC4C3 . #x93AE)
                (#xC4C4 . #x9673)
                (#xC4C5 . #x6D25)
                (#xC4C6 . #x589C)
                (#xC4C7 . #x690E)
                (#xC4C8 . #x69CC)
                (#xC4C9 . #x8FFD)
                (#xC4CA . #x939A)
                (#xC4CB . #x75DB)
                (#xC4CC . #x901A)
                (#xC4CD . #x585A)
                (#xC4CE . #x6802)
                (#xC4CF . #x63B4)
                (#xC4D0 . #x69FB)
                (#xC4D1 . #x4F43)
                (#xC4D2 . #x6F2C)
                (#xC4D3 . #x67D8)
                (#xC4D4 . #x8FBB)
                (#xC4D5 . #x8526)
                (#xC4D6 . #x7DB4)
                (#xC4D7 . #x9354)
                (#xC4D8 . #x693F)
                (#xC4D9 . #x6F70)
                (#xC4DA . #x576A)
                (#xC4DB . #x58F7)
                (#xC4DC . #x5B2C)
                (#xC4DD . #x7D2C)
                (#xC4DE . #x722A)
                (#xC4DF . #x540A)
                (#xC4E0 . #x91E3)
                (#xC4E1 . #x9DB4)
                (#xC4E2 . #x4EAD)
                (#xC4E3 . #x4F4E)
                (#xC4E4 . #x505C)
                (#xC4E5 . #x5075)
                (#xC4E6 . #x5243)
                (#xC4E7 . #x8C9E)
                (#xC4E8 . #x5448)
                (#xC4E9 . #x5824)
                (#xC4EA . #x5B9A)
                (#xC4EB . #x5E1D)
                (#xC4EC . #x5E95)
                (#xC4ED . #x5EAD)
                (#xC4EE . #x5EF7)
                (#xC4EF . #x5F1F)
                (#xC4F0 . #x608C)
                (#xC4F1 . #x62B5)
                (#xC4F2 . #x633A)
                (#xC4F3 . #x63D0)
                (#xC4F4 . #x68AF)
                (#xC4F5 . #x6C40)
                (#xC4F6 . #x7887)
                (#xC4F7 . #x798E)
                (#xC4F8 . #x7A0B)
                (#xC4F9 . #x7DE0)
                (#xC4FA . #x8247)
                (#xC4FB . #x8A02)
                (#xC4FC . #x8AE6)
                (#xC4FD . #x8E44)
                (#xC4FE . #x9013)
                (#xC5A1 . #x90B8)
                (#xC5A2 . #x912D)
                (#xC5A3 . #x91D8)
                (#xC5A4 . #x9F0E)
                (#xC5A5 . #x6CE5)
                (#xC5A6 . #x6458)
                (#xC5A7 . #x64E2)
                (#xC5A8 . #x6575)
                (#xC5A9 . #x6EF4)
                (#xC5AA . #x7684)
                (#xC5AB . #x7B1B)
                (#xC5AC . #x9069)
                (#xC5AD . #x93D1)
                (#xC5AE . #x6EBA)
                (#xC5AF . #x54F2)
                (#xC5B0 . #x5FB9)
                (#xC5B1 . #x64A4)
                (#xC5B2 . #x8F4D)
                (#xC5B3 . #x8FED)
                (#xC5B4 . #x9244)
                (#xC5B5 . #x5178)
                (#xC5B6 . #x586B)
                (#xC5B7 . #x5929)
                (#xC5B8 . #x5C55)
                (#xC5B9 . #x5E97)
                (#xC5BA . #x6DFB)
                (#xC5BB . #x7E8F)
                (#xC5BC . #x751C)
                (#xC5BD . #x8CBC)
                (#xC5BE . #x8EE2)
                (#xC5BF . #x985B)
                (#xC5C0 . #x70B9)
                (#xC5C1 . #x4F1D)
                (#xC5C2 . #x6BBF)
                (#xC5C3 . #x6FB1)
                (#xC5C4 . #x7530)
                (#xC5C5 . #x96FB)
                (#xC5C6 . #x514E)
                (#xC5C7 . #x5410)
                (#xC5C8 . #x5835)
                (#xC5C9 . #x5857)
                (#xC5CA . #x59AC)
                (#xC5CB . #x5C60)
                (#xC5CC . #x5F92)
                (#xC5CD . #x6597)
                (#xC5CE . #x675C)
                (#xC5CF . #x6E21)
                (#xC5D0 . #x767B)
                (#xC5D1 . #x83DF)
                (#xC5D2 . #x8CED)
                (#xC5D3 . #x9014)
                (#xC5D4 . #x90FD)
                (#xC5D5 . #x934D)
                (#xC5D6 . #x7825)
                (#xC5D7 . #x783A)
                (#xC5D8 . #x52AA)
                (#xC5D9 . #x5EA6)
                (#xC5DA . #x571F)
                (#xC5DB . #x5974)
                (#xC5DC . #x6012)
                (#xC5DD . #x5012)
                (#xC5DE . #x515A)
                (#xC5DF . #x51AC)
                (#xC5E0 . #x51CD)
                (#xC5E1 . #x5200)
                (#xC5E2 . #x5510)
                (#xC5E3 . #x5854)
                (#xC5E4 . #x5858)
                (#xC5E5 . #x5957)
                (#xC5E6 . #x5B95)
                (#xC5E7 . #x5CF6)
                (#xC5E8 . #x5D8B)
                (#xC5E9 . #x60BC)
                (#xC5EA . #x6295)
                (#xC5EB . #x642D)
                (#xC5EC . #x6771)
                (#xC5ED . #x6843)
                (#xC5EE . #x68BC)
                (#xC5EF . #x68DF)
                (#xC5F0 . #x76D7)
                (#xC5F1 . #x6DD8)
                (#xC5F2 . #x6E6F)
                (#xC5F3 . #x6D9B)
                (#xC5F4 . #x706F)
                (#xC5F5 . #x71C8)
                (#xC5F6 . #x5F53)
                (#xC5F7 . #x75D8)
                (#xC5F8 . #x7977)
                (#xC5F9 . #x7B49)
                (#xC5FA . #x7B54)
                (#xC5FB . #x7B52)
                (#xC5FC . #x7CD6)
                (#xC5FD . #x7D71)
                (#xC5FE . #x5230)
                (#xC6A1 . #x8463)
                (#xC6A2 . #x8569)
                (#xC6A3 . #x85E4)
                (#xC6A4 . #x8A0E)
                (#xC6A5 . #x8B04)
                (#xC6A6 . #x8C46)
                (#xC6A7 . #x8E0F)
                (#xC6A8 . #x9003)
                (#xC6A9 . #x900F)
                (#xC6AA . #x9419)
                (#xC6AB . #x9676)
                (#xC6AC . #x982D)
                (#xC6AD . #x9A30)
                (#xC6AE . #x95D8)
                (#xC6AF . #x50CD)
                (#xC6B0 . #x52D5)
                (#xC6B1 . #x540C)
                (#xC6B2 . #x5802)
                (#xC6B3 . #x5C0E)
                (#xC6B4 . #x61A7)
                (#xC6B5 . #x649E)
                (#xC6B6 . #x6D1E)
                (#xC6B7 . #x77B3)
                (#xC6B8 . #x7AE5)
                (#xC6B9 . #x80F4)
                (#xC6BA . #x8404)
                (#xC6BB . #x9053)
                (#xC6BC . #x9285)
                (#xC6BD . #x5CE0)
                (#xC6BE . #x9D07)
                (#xC6BF . #x533F)
                (#xC6C0 . #x5F97)
                (#xC6C1 . #x5FB3)
                (#xC6C2 . #x6D9C)
                (#xC6C3 . #x7279)
                (#xC6C4 . #x7763)
                (#xC6C5 . #x79BF)
                (#xC6C6 . #x7BE4)
                (#xC6C7 . #x6BD2)
                (#xC6C8 . #x72EC)
                (#xC6C9 . #x8AAD)
                (#xC6CA . #x6803)
                (#xC6CB . #x6A61)
                (#xC6CC . #x51F8)
                (#xC6CD . #x7A81)
                (#xC6CE . #x6934)
                (#xC6CF . #x5C4A)
                (#xC6D0 . #x9CF6)
                (#xC6D1 . #x82EB)
                (#xC6D2 . #x5BC5)
                (#xC6D3 . #x9149)
                (#xC6D4 . #x701E)
                (#xC6D5 . #x5678)
                (#xC6D6 . #x5C6F)
                (#xC6D7 . #x60C7)
                (#xC6D8 . #x6566)
                (#xC6D9 . #x6C8C)
                (#xC6DA . #x8C5A)
                (#xC6DB . #x9041)
                (#xC6DC . #x9813)
                (#xC6DD . #x5451)
                (#xC6DE . #x66C7)
                (#xC6DF . #x920D)
                (#xC6E0 . #x5948)
                (#xC6E1 . #x90A3)
                (#xC6E2 . #x5185)
                (#xC6E3 . #x4E4D)
                (#xC6E4 . #x51EA)
                (#xC6E5 . #x8599)
                (#xC6E6 . #x8B0E)
                (#xC6E7 . #x7058)
                (#xC6E8 . #x637A)
                (#xC6E9 . #x934B)
                (#xC6EA . #x6962)
                (#xC6EB . #x99B4)
                (#xC6EC . #x7E04)
                (#xC6ED . #x7577)
                (#xC6EE . #x5357)
                (#xC6EF . #x6960)
                (#xC6F0 . #x8EDF)
                (#xC6F1 . #x96E3)
                (#xC6F2 . #x6C5D)
                (#xC6F3 . #x4E8C)
                (#xC6F4 . #x5C3C)
                (#xC6F5 . #x5F10)
                (#xC6F6 . #x8FE9)
                (#xC6F7 . #x5302)
                (#xC6F8 . #x8CD1)
                (#xC6F9 . #x8089)
                (#xC6FA . #x8679)
                (#xC6FB . #x5EFF)
                (#xC6FC . #x65E5)
                (#xC6FD . #x4E73)
                (#xC6FE . #x5165)
                (#xC7A1 . #x5982)
                (#xC7A2 . #x5C3F)
                (#xC7A3 . #x97EE)
                (#xC7A4 . #x4EFB)
                (#xC7A5 . #x598A)
                (#xC7A6 . #x5FCD)
                (#xC7A7 . #x8A8D)
                (#xC7A8 . #x6FE1)
                (#xC7A9 . #x79B0)
                (#xC7AA . #x7962)
                (#xC7AB . #x5BE7)
                (#xC7AC . #x8471)
                (#xC7AD . #x732B)
                (#xC7AE . #x71B1)
                (#xC7AF . #x5E74)
                (#xC7B0 . #x5FF5)
                (#xC7B1 . #x637B)
                (#xC7B2 . #x649A)
                (#xC7B3 . #x71C3)
                (#xC7B4 . #x7C98)
                (#xC7B5 . #x4E43)
                (#xC7B6 . #x5EFC)
                (#xC7B7 . #x4E4B)
                (#xC7B8 . #x57DC)
                (#xC7B9 . #x56A2)
                (#xC7BA . #x60A9)
                (#xC7BB . #x6FC3)
                (#xC7BC . #x7D0D)
                (#xC7BD . #x80FD)
                (#xC7BE . #x8133)
                (#xC7BF . #x81BF)
                (#xC7C0 . #x8FB2)
                (#xC7C1 . #x8997)
                (#xC7C2 . #x86A4)
                (#xC7C3 . #x5DF4)
                (#xC7C4 . #x628A)
                (#xC7C5 . #x64AD)
                (#xC7C6 . #x8987)
                (#xC7C7 . #x6777)
                (#xC7C8 . #x6CE2)
                (#xC7C9 . #x6D3E)
                (#xC7CA . #x7436)
                (#xC7CB . #x7834)
                (#xC7CC . #x5A46)
                (#xC7CD . #x7F75)
                (#xC7CE . #x82AD)
                (#xC7CF . #x99AC)
                (#xC7D0 . #x4FF3)
                (#xC7D1 . #x5EC3)
                (#xC7D2 . #x62DD)
                (#xC7D3 . #x6392)
                (#xC7D4 . #x6557)
                (#xC7D5 . #x676F)
                (#xC7D6 . #x76C3)
                (#xC7D7 . #x724C)
                (#xC7D8 . #x80CC)
                (#xC7D9 . #x80BA)
                (#xC7DA . #x8F29)
                (#xC7DB . #x914D)
                (#xC7DC . #x500D)
                (#xC7DD . #x57F9)
                (#xC7DE . #x5A92)
                (#xC7DF . #x6885)
                (#xC7E0 . #x6973)
                (#xC7E1 . #x7164)
                (#xC7E2 . #x72FD)
                (#xC7E3 . #x8CB7)
                (#xC7E4 . #x58F2)
                (#xC7E5 . #x8CE0)
                (#xC7E6 . #x966A)
                (#xC7E7 . #x9019)
                (#xC7E8 . #x877F)
                (#xC7E9 . #x79E4)
                (#xC7EA . #x77E7)
                (#xC7EB . #x8429)
                (#xC7EC . #x4F2F)
                (#xC7ED . #x5265)
                (#xC7EE . #x535A)
                (#xC7EF . #x62CD)
                (#xC7F0 . #x67CF)
                (#xC7F1 . #x6CCA)
                (#xC7F2 . #x767D)
                (#xC7F3 . #x7B94)
                (#xC7F4 . #x7C95)
                (#xC7F5 . #x8236)
                (#xC7F6 . #x8584)
                (#xC7F7 . #x8FEB)
                (#xC7F8 . #x66DD)
                (#xC7F9 . #x6F20)
                (#xC7FA . #x7206)
                (#xC7FB . #x7E1B)
                (#xC7FC . #x83AB)
                (#xC7FD . #x99C1)
                (#xC7FE . #x9EA6)
                (#xC8A1 . #x51FD)
                (#xC8A2 . #x7BB1)
                (#xC8A3 . #x7872)
                (#xC8A4 . #x7BB8)
                (#xC8A5 . #x8087)
                (#xC8A6 . #x7B48)
                (#xC8A7 . #x6AE8)
                (#xC8A8 . #x5E61)
                (#xC8A9 . #x808C)
                (#xC8AA . #x7551)
                (#xC8AB . #x7560)
                (#xC8AC . #x516B)
                (#xC8AD . #x9262)
                (#xC8AE . #x6E8C)
                (#xC8AF . #x767A)
                (#xC8B0 . #x9197)
                (#xC8B1 . #x9AEA)
                (#xC8B2 . #x4F10)
                (#xC8B3 . #x7F70)
                (#xC8B4 . #x629C)
                (#xC8B5 . #x7B4F)
                (#xC8B6 . #x95A5)
                (#xC8B7 . #x9CE9)
                (#xC8B8 . #x567A)
                (#xC8B9 . #x5859)
                (#xC8BA . #x86E4)
                (#xC8BB . #x96BC)
                (#xC8BC . #x4F34)
                (#xC8BD . #x5224)
                (#xC8BE . #x534A)
                (#xC8BF . #x53CD)
                (#xC8C0 . #x53DB)
                (#xC8C1 . #x5E06)
                (#xC8C2 . #x642C)
                (#xC8C3 . #x6591)
                (#xC8C4 . #x677F)
                (#xC8C5 . #x6C3E)
                (#xC8C6 . #x6C4E)
                (#xC8C7 . #x7248)
                (#xC8C8 . #x72AF)
                (#xC8C9 . #x73ED)
                (#xC8CA . #x7554)
                (#xC8CB . #x7E41)
                (#xC8CC . #x822C)
                (#xC8CD . #x85E9)
                (#xC8CE . #x8CA9)
                (#xC8CF . #x7BC4)
                (#xC8D0 . #x91C6)
                (#xC8D1 . #x7169)
                (#xC8D2 . #x9812)
                (#xC8D3 . #x98EF)
                (#xC8D4 . #x633D)
                (#xC8D5 . #x6669)
                (#xC8D6 . #x756A)
                (#xC8D7 . #x76E4)
                (#xC8D8 . #x78D0)
                (#xC8D9 . #x8543)
                (#xC8DA . #x86EE)
                (#xC8DB . #x532A)
                (#xC8DC . #x5351)
                (#xC8DD . #x5426)
                (#xC8DE . #x5983)
                (#xC8DF . #x5E87)
                (#xC8E0 . #x5F7C)
                (#xC8E1 . #x60B2)
                (#xC8E2 . #x6249)
                (#xC8E3 . #x6279)
                (#xC8E4 . #x62AB)
                (#xC8E5 . #x6590)
                (#xC8E6 . #x6BD4)
                (#xC8E7 . #x6CCC)
                (#xC8E8 . #x75B2)
                (#xC8E9 . #x76AE)
                (#xC8EA . #x7891)
                (#xC8EB . #x79D8)
                (#xC8EC . #x7DCB)
                (#xC8ED . #x7F77)
                (#xC8EE . #x80A5)
                (#xC8EF . #x88AB)
                (#xC8F0 . #x8AB9)
                (#xC8F1 . #x8CBB)
                (#xC8F2 . #x907F)
                (#xC8F3 . #x975E)
                (#xC8F4 . #x98DB)
                (#xC8F5 . #x6A0B)
                (#xC8F6 . #x7C38)
                (#xC8F7 . #x5099)
                (#xC8F8 . #x5C3E)
                (#xC8F9 . #x5FAE)
                (#xC8FA . #x6787)
                (#xC8FB . #x6BD8)
                (#xC8FC . #x7435)
                (#xC8FD . #x7709)
                (#xC8FE . #x7F8E)
                (#xC9A1 . #x9F3B)
                (#xC9A2 . #x67CA)
                (#xC9A3 . #x7A17)
                (#xC9A4 . #x5339)
                (#xC9A5 . #x758B)
                (#xC9A6 . #x9AED)
                (#xC9A7 . #x5F66)
                (#xC9A8 . #x819D)
                (#xC9A9 . #x83F1)
                (#xC9AA . #x8098)
                (#xC9AB . #x5F3C)
                (#xC9AC . #x5FC5)
                (#xC9AD . #x7562)
                (#xC9AE . #x7B46)
                (#xC9AF . #x903C)
                (#xC9B0 . #x6867)
                (#xC9B1 . #x59EB)
                (#xC9B2 . #x5A9B)
                (#xC9B3 . #x7D10)
                (#xC9B4 . #x767E)
                (#xC9B5 . #x8B2C)
                (#xC9B6 . #x4FF5)
                (#xC9B7 . #x5F6A)
                (#xC9B8 . #x6A19)
                (#xC9B9 . #x6C37)
                (#xC9BA . #x6F02)
                (#xC9BB . #x74E2)
                (#xC9BC . #x7968)
                (#xC9BD . #x8868)
                (#xC9BE . #x8A55)
                (#xC9BF . #x8C79)
                (#xC9C0 . #x5EDF)
                (#xC9C1 . #x63CF)
                (#xC9C2 . #x75C5)
                (#xC9C3 . #x79D2)
                (#xC9C4 . #x82D7)
                (#xC9C5 . #x9328)
                (#xC9C6 . #x92F2)
                (#xC9C7 . #x849C)
                (#xC9C8 . #x86ED)
                (#xC9C9 . #x9C2D)
                (#xC9CA . #x54C1)
                (#xC9CB . #x5F6C)
                (#xC9CC . #x658C)
                (#xC9CD . #x6D5C)
                (#xC9CE . #x7015)
                (#xC9CF . #x8CA7)
                (#xC9D0 . #x8CD3)
                (#xC9D1 . #x983B)
                (#xC9D2 . #x654F)
                (#xC9D3 . #x74F6)
                (#xC9D4 . #x4E0D)
                (#xC9D5 . #x4ED8)
                (#xC9D6 . #x57E0)
                (#xC9D7 . #x592B)
                (#xC9D8 . #x5A66)
                (#xC9D9 . #x5BCC)
                (#xC9DA . #x51A8)
                (#xC9DB . #x5E03)
                (#xC9DC . #x5E9C)
                (#xC9DD . #x6016)
                (#xC9DE . #x6276)
                (#xC9DF . #x6577)
                (#xC9E0 . #x65A7)
                (#xC9E1 . #x666E)
                (#xC9E2 . #x6D6E)
                (#xC9E3 . #x7236)
                (#xC9E4 . #x7B26)
                (#xC9E5 . #x8150)
                (#xC9E6 . #x819A)
                (#xC9E7 . #x8299)
                (#xC9E8 . #x8B5C)
                (#xC9E9 . #x8CA0)
                (#xC9EA . #x8CE6)
                (#xC9EB . #x8D74)
                (#xC9EC . #x961C)
                (#xC9ED . #x9644)
                (#xC9EE . #x4FAE)
                (#xC9EF . #x64AB)
                (#xC9F0 . #x6B66)
                (#xC9F1 . #x821E)
                (#xC9F2 . #x8461)
                (#xC9F3 . #x856A)
                (#xC9F4 . #x90E8)
                (#xC9F5 . #x5C01)
                (#xC9F6 . #x6953)
                (#xC9F7 . #x98A8)
                (#xC9F8 . #x847A)
                (#xC9F9 . #x8557)
                (#xC9FA . #x4F0F)
                (#xC9FB . #x526F)
                (#xC9FC . #x5FA9)
                (#xC9FD . #x5E45)
                (#xC9FE . #x670D)
                (#xCAA1 . #x798F)
                (#xCAA2 . #x8179)
                (#xCAA3 . #x8907)
                (#xCAA4 . #x8986)
                (#xCAA5 . #x6DF5)
                (#xCAA6 . #x5F17)
                (#xCAA7 . #x6255)
                (#xCAA8 . #x6CB8)
                (#xCAA9 . #x4ECF)
                (#xCAAA . #x7269)
                (#xCAAB . #x9B92)
                (#xCAAC . #x5206)
                (#xCAAD . #x543B)
                (#xCAAE . #x5674)
                (#xCAAF . #x58B3)
                (#xCAB0 . #x61A4)
                (#xCAB1 . #x626E)
                (#xCAB2 . #x711A)
                (#xCAB3 . #x596E)
                (#xCAB4 . #x7C89)
                (#xCAB5 . #x7CDE)
                (#xCAB6 . #x7D1B)
                (#xCAB7 . #x96F0)
                (#xCAB8 . #x6587)
                (#xCAB9 . #x805E)
                (#xCABA . #x4E19)
                (#xCABB . #x4F75)
                (#xCABC . #x5175)
                (#xCABD . #x5840)
                (#xCABE . #x5E63)
                (#xCABF . #x5E73)
                (#xCAC0 . #x5F0A)
                (#xCAC1 . #x67C4)
                (#xCAC2 . #x4E26)
                (#xCAC3 . #x853D)
                (#xCAC4 . #x9589)
                (#xCAC5 . #x965B)
                (#xCAC6 . #x7C73)
                (#xCAC7 . #x9801)
                (#xCAC8 . #x50FB)
                (#xCAC9 . #x58C1)
                (#xCACA . #x7656)
                (#xCACB . #x78A7)
                (#xCACC . #x5225)
                (#xCACD . #x77A5)
                (#xCACE . #x8511)
                (#xCACF . #x7B86)
                (#xCAD0 . #x504F)
                (#xCAD1 . #x5909)
                (#xCAD2 . #x7247)
                (#xCAD3 . #x7BC7)
                (#xCAD4 . #x7DE8)
                (#xCAD5 . #x8FBA)
                (#xCAD6 . #x8FD4)
                (#xCAD7 . #x904D)
                (#xCAD8 . #x4FBF)
                (#xCAD9 . #x52C9)
                (#xCADA . #x5A29)
                (#xCADB . #x5F01)
                (#xCADC . #x97AD)
                (#xCADD . #x4FDD)
                (#xCADE . #x8217)
                (#xCADF . #x92EA)
                (#xCAE0 . #x5703)
                (#xCAE1 . #x6355)
                (#xCAE2 . #x6B69)
                (#xCAE3 . #x752B)
                (#xCAE4 . #x88DC)
                (#xCAE5 . #x8F14)
                (#xCAE6 . #x7A42)
                (#xCAE7 . #x52DF)
                (#xCAE8 . #x5893)
                (#xCAE9 . #x6155)
                (#xCAEA . #x620A)
                (#xCAEB . #x66AE)
                (#xCAEC . #x6BCD)
                (#xCAED . #x7C3F)
                (#xCAEE . #x83E9)
                (#xCAEF . #x5023)
                (#xCAF0 . #x4FF8)
                (#xCAF1 . #x5305)
                (#xCAF2 . #x5446)
                (#xCAF3 . #x5831)
                (#xCAF4 . #x5949)
                (#xCAF5 . #x5B9D)
                (#xCAF6 . #x5CF0)
                (#xCAF7 . #x5CEF)
                (#xCAF8 . #x5D29)
                (#xCAF9 . #x5E96)
                (#xCAFA . #x62B1)
                (#xCAFB . #x6367)
                (#xCAFC . #x653E)
                (#xCAFD . #x65B9)
                (#xCAFE . #x670B)
                (#xCBA1 . #x6CD5)
                (#xCBA2 . #x6CE1)
                (#xCBA3 . #x70F9)
                (#xCBA4 . #x7832)
                (#xCBA5 . #x7E2B)
                (#xCBA6 . #x80DE)
                (#xCBA7 . #x82B3)
                (#xCBA8 . #x840C)
                (#xCBA9 . #x84EC)
                (#xCBAA . #x8702)
                (#xCBAB . #x8912)
                (#xCBAC . #x8A2A)
                (#xCBAD . #x8C4A)
                (#xCBAE . #x90A6)
                (#xCBAF . #x92D2)
                (#xCBB0 . #x98FD)
                (#xCBB1 . #x9CF3)
                (#xCBB2 . #x9D6C)
                (#xCBB3 . #x4E4F)
                (#xCBB4 . #x4EA1)
                (#xCBB5 . #x508D)
                (#xCBB6 . #x5256)
                (#xCBB7 . #x574A)
                (#xCBB8 . #x59A8)
                (#xCBB9 . #x5E3D)
                (#xCBBA . #x5FD8)
                (#xCBBB . #x5FD9)
                (#xCBBC . #x623F)
                (#xCBBD . #x66B4)
                (#xCBBE . #x671B)
                (#xCBBF . #x67D0)
                (#xCBC0 . #x68D2)
                (#xCBC1 . #x5192)
                (#xCBC2 . #x7D21)
                (#xCBC3 . #x80AA)
                (#xCBC4 . #x81A8)
                (#xCBC5 . #x8B00)
                (#xCBC6 . #x8C8C)
                (#xCBC7 . #x8CBF)
                (#xCBC8 . #x927E)
                (#xCBC9 . #x9632)
                (#xCBCA . #x5420)
                (#xCBCB . #x982C)
                (#xCBCC . #x5317)
                (#xCBCD . #x50D5)
                (#xCBCE . #x535C)
                (#xCBCF . #x58A8)
                (#xCBD0 . #x64B2)
                (#xCBD1 . #x6734)
                (#xCBD2 . #x7267)
                (#xCBD3 . #x7766)
                (#xCBD4 . #x7A46)
                (#xCBD5 . #x91E6)
                (#xCBD6 . #x52C3)
                (#xCBD7 . #x6CA1)
                (#xCBD8 . #x6B86)
                (#xCBD9 . #x5800)
                (#xCBDA . #x5E4C)
                (#xCBDB . #x5954)
                (#xCBDC . #x672C)
                (#xCBDD . #x7FFB)
                (#xCBDE . #x51E1)
                (#xCBDF . #x76C6)
                (#xCBE0 . #x6469)
                (#xCBE1 . #x78E8)
                (#xCBE2 . #x9B54)
                (#xCBE3 . #x9EBB)
                (#xCBE4 . #x57CB)
                (#xCBE5 . #x59B9)
                (#xCBE6 . #x6627)
                (#xCBE7 . #x679A)
                (#xCBE8 . #x6BCE)
                (#xCBE9 . #x54E9)
                (#xCBEA . #x69D9)
                (#xCBEB . #x5E55)
                (#xCBEC . #x819C)
                (#xCBED . #x6795)
                (#xCBEE . #x9BAA)
                (#xCBEF . #x67FE)
                (#xCBF0 . #x9C52)
                (#xCBF1 . #x685D)
                (#xCBF2 . #x4EA6)
                (#xCBF3 . #x4FE3)
                (#xCBF4 . #x53C8)
                (#xCBF5 . #x62B9)
                (#xCBF6 . #x672B)
                (#xCBF7 . #x6CAB)
                (#xCBF8 . #x8FC4)
                (#xCBF9 . #x4FAD)
                (#xCBFA . #x7E6D)
                (#xCBFB . #x9EBF)
                (#xCBFC . #x4E07)
                (#xCBFD . #x6162)
                (#xCBFE . #x6E80)
                (#xCCA1 . #x6F2B)
                (#xCCA2 . #x8513)
                (#xCCA3 . #x5473)
                (#xCCA4 . #x672A)
                (#xCCA5 . #x9B45)
                (#xCCA6 . #x5DF3)
                (#xCCA7 . #x7B95)
                (#xCCA8 . #x5CAC)
                (#xCCA9 . #x5BC6)
                (#xCCAA . #x871C)
                (#xCCAB . #x6E4A)
                (#xCCAC . #x84D1)
                (#xCCAD . #x7A14)
                (#xCCAE . #x8108)
                (#xCCAF . #x5999)
                (#xCCB0 . #x7C8D)
                (#xCCB1 . #x6C11)
                (#xCCB2 . #x7720)
                (#xCCB3 . #x52D9)
                (#xCCB4 . #x5922)
                (#xCCB5 . #x7121)
                (#xCCB6 . #x725F)
                (#xCCB7 . #x77DB)
                (#xCCB8 . #x9727)
                (#xCCB9 . #x9D61)
                (#xCCBA . #x690B)
                (#xCCBB . #x5A7F)
                (#xCCBC . #x5A18)
                (#xCCBD . #x51A5)
                (#xCCBE . #x540D)
                (#xCCBF . #x547D)
                (#xCCC0 . #x660E)
                (#xCCC1 . #x76DF)
                (#xCCC2 . #x8FF7)
                (#xCCC3 . #x9298)
                (#xCCC4 . #x9CF4)
                (#xCCC5 . #x59EA)
                (#xCCC6 . #x725D)
                (#xCCC7 . #x6EC5)
                (#xCCC8 . #x514D)
                (#xCCC9 . #x68C9)
                (#xCCCA . #x7DBF)
                (#xCCCB . #x7DEC)
                (#xCCCC . #x9762)
                (#xCCCD . #x9EBA)
                (#xCCCE . #x6478)
                (#xCCCF . #x6A21)
                (#xCCD0 . #x8302)
                (#xCCD1 . #x5984)
                (#xCCD2 . #x5B5F)
                (#xCCD3 . #x6BDB)
                (#xCCD4 . #x731B)
                (#xCCD5 . #x76F2)
                (#xCCD6 . #x7DB2)
                (#xCCD7 . #x8017)
                (#xCCD8 . #x8499)
                (#xCCD9 . #x5132)
                (#xCCDA . #x6728)
                (#xCCDB . #x9ED9)
                (#xCCDC . #x76EE)
                (#xCCDD . #x6762)
                (#xCCDE . #x52FF)
                (#xCCDF . #x9905)
                (#xCCE0 . #x5C24)
                (#xCCE1 . #x623B)
                (#xCCE2 . #x7C7E)
                (#xCCE3 . #x8CB0)
                (#xCCE4 . #x554F)
                (#xCCE5 . #x60B6)
                (#xCCE6 . #x7D0B)
                (#xCCE7 . #x9580)
                (#xCCE8 . #x5301)
                (#xCCE9 . #x4E5F)
                (#xCCEA . #x51B6)
                (#xCCEB . #x591C)
                (#xCCEC . #x723A)
                (#xCCED . #x8036)
                (#xCCEE . #x91CE)
                (#xCCEF . #x5F25)
                (#xCCF0 . #x77E2)
                (#xCCF1 . #x5384)
                (#xCCF2 . #x5F79)
                (#xCCF3 . #x7D04)
                (#xCCF4 . #x85AC)
                (#xCCF5 . #x8A33)
                (#xCCF6 . #x8E8D)
                (#xCCF7 . #x9756)
                (#xCCF8 . #x67F3)
                (#xCCF9 . #x85AE)
                (#xCCFA . #x9453)
                (#xCCFB . #x6109)
                (#xCCFC . #x6108)
                (#xCCFD . #x6CB9)
                (#xCCFE . #x7652)
                (#xCDA1 . #x8AED)
                (#xCDA2 . #x8F38)
                (#xCDA3 . #x552F)
                (#xCDA4 . #x4F51)
                (#xCDA5 . #x512A)
                (#xCDA6 . #x52C7)
                (#xCDA7 . #x53CB)
                (#xCDA8 . #x5BA5)
                (#xCDA9 . #x5E7D)
                (#xCDAA . #x60A0)
                (#xCDAB . #x6182)
                (#xCDAC . #x63D6)
                (#xCDAD . #x6709)
                (#xCDAE . #x67DA)
                (#xCDAF . #x6E67)
                (#xCDB0 . #x6D8C)
                (#xCDB1 . #x7336)
                (#xCDB2 . #x7337)
                (#xCDB3 . #x7531)
                (#xCDB4 . #x7950)
                (#xCDB5 . #x88D5)
                (#xCDB6 . #x8A98)
                (#xCDB7 . #x904A)
                (#xCDB8 . #x9091)
                (#xCDB9 . #x90F5)
                (#xCDBA . #x96C4)
                (#xCDBB . #x878D)
                (#xCDBC . #x5915)
                (#xCDBD . #x4E88)
                (#xCDBE . #x4F59)
                (#xCDBF . #x4E0E)
                (#xCDC0 . #x8A89)
                (#xCDC1 . #x8F3F)
                (#xCDC2 . #x9810)
                (#xCDC3 . #x50AD)
                (#xCDC4 . #x5E7C)
                (#xCDC5 . #x5996)
                (#xCDC6 . #x5BB9)
                (#xCDC7 . #x5EB8)
                (#xCDC8 . #x63DA)
                (#xCDC9 . #x63FA)
                (#xCDCA . #x64C1)
                (#xCDCB . #x66DC)
                (#xCDCC . #x694A)
                (#xCDCD . #x69D8)
                (#xCDCE . #x6D0B)
                (#xCDCF . #x6EB6)
                (#xCDD0 . #x7194)
                (#xCDD1 . #x7528)
                (#xCDD2 . #x7AAF)
                (#xCDD3 . #x7F8A)
                (#xCDD4 . #x8000)
                (#xCDD5 . #x8449)
                (#xCDD6 . #x84C9)
                (#xCDD7 . #x8981)
                (#xCDD8 . #x8B21)
                (#xCDD9 . #x8E0A)
                (#xCDDA . #x9065)
                (#xCDDB . #x967D)
                (#xCDDC . #x990A)
                (#xCDDD . #x617E)
                (#xCDDE . #x6291)
                (#xCDDF . #x6B32)
                (#xCDE0 . #x6C83)
                (#xCDE1 . #x6D74)
                (#xCDE2 . #x7FCC)
                (#xCDE3 . #x7FFC)
                (#xCDE4 . #x6DC0)
                (#xCDE5 . #x7F85)
                (#xCDE6 . #x87BA)
                (#xCDE7 . #x88F8)
                (#xCDE8 . #x6765)
                (#xCDE9 . #x83B1)
                (#xCDEA . #x983C)
                (#xCDEB . #x96F7)
                (#xCDEC . #x6D1B)
                (#xCDED . #x7D61)
                (#xCDEE . #x843D)
                (#xCDEF . #x916A)
                (#xCDF0 . #x4E71)
                (#xCDF1 . #x5375)
                (#xCDF2 . #x5D50)
                (#xCDF3 . #x6B04)
                (#xCDF4 . #x6FEB)
                (#xCDF5 . #x85CD)
                (#xCDF6 . #x862D)
                (#xCDF7 . #x89A7)
                (#xCDF8 . #x5229)
                (#xCDF9 . #x540F)
                (#xCDFA . #x5C65)
                (#xCDFB . #x674E)
                (#xCDFC . #x68A8)
                (#xCDFD . #x7406)
                (#xCDFE . #x7483)
                (#xCEA1 . #x75E2)
                (#xCEA2 . #x88CF)
                (#xCEA3 . #x88E1)
                (#xCEA4 . #x91CC)
                (#xCEA5 . #x96E2)
                (#xCEA6 . #x9678)
                (#xCEA7 . #x5F8B)
                (#xCEA8 . #x7387)
                (#xCEA9 . #x7ACB)
                (#xCEAA . #x844E)
                (#xCEAB . #x63A0)
                (#xCEAC . #x7565)
                (#xCEAD . #x5289)
                (#xCEAE . #x6D41)
                (#xCEAF . #x6E9C)
                (#xCEB0 . #x7409)
                (#xCEB1 . #x7559)
                (#xCEB2 . #x786B)
                (#xCEB3 . #x7C92)
                (#xCEB4 . #x9686)
                (#xCEB5 . #x7ADC)
                (#xCEB6 . #x9F8D)
                (#xCEB7 . #x4FB6)
                (#xCEB8 . #x616E)
                (#xCEB9 . #x65C5)
                (#xCEBA . #x865C)
                (#xCEBB . #x4E86)
                (#xCEBC . #x4EAE)
                (#xCEBD . #x50DA)
                (#xCEBE . #x4E21)
                (#xCEBF . #x51CC)
                (#xCEC0 . #x5BEE)
                (#xCEC1 . #x6599)
                (#xCEC2 . #x6881)
                (#xCEC3 . #x6DBC)
                (#xCEC4 . #x731F)
                (#xCEC5 . #x7642)
                (#xCEC6 . #x77AD)
                (#xCEC7 . #x7A1C)
                (#xCEC8 . #x7CE7)
                (#xCEC9 . #x826F)
                (#xCECA . #x8AD2)
                (#xCECB . #x907C)
                (#xCECC . #x91CF)
                (#xCECD . #x9675)
                (#xCECE . #x9818)
                (#xCECF . #x529B)
                (#xCED0 . #x7DD1)
                (#xCED1 . #x502B)
                (#xCED2 . #x5398)
                (#xCED3 . #x6797)
                (#xCED4 . #x6DCB)
                (#xCED5 . #x71D0)
                (#xCED6 . #x7433)
                (#xCED7 . #x81E8)
                (#xCED8 . #x8F2A)
                (#xCED9 . #x96A3)
                (#xCEDA . #x9C57)
                (#xCEDB . #x9E9F)
                (#xCEDC . #x7460)
                (#xCEDD . #x5841)
                (#xCEDE . #x6D99)
                (#xCEDF . #x7D2F)
                (#xCEE0 . #x985E)
                (#xCEE1 . #x4EE4)
                (#xCEE2 . #x4F36)
                (#xCEE3 . #x4F8B)
                (#xCEE4 . #x51B7)
                (#xCEE5 . #x52B1)
                (#xCEE6 . #x5DBA)
                (#xCEE7 . #x601C)
                (#xCEE8 . #x73B2)
                (#xCEE9 . #x793C)
                (#xCEEA . #x82D3)
                (#xCEEB . #x9234)
                (#xCEEC . #x96B7)
                (#xCEED . #x96F6)
                (#xCEEE . #x970A)
                (#xCEEF . #x9E97)
                (#xCEF0 . #x9F62)
                (#xCEF1 . #x66A6)
                (#xCEF2 . #x6B74)
                (#xCEF3 . #x5217)
                (#xCEF4 . #x52A3)
                (#xCEF5 . #x70C8)
                (#xCEF6 . #x88C2)
                (#xCEF7 . #x5EC9)
                (#xCEF8 . #x604B)
                (#xCEF9 . #x6190)
                (#xCEFA . #x6F23)
                (#xCEFB . #x7149)
                (#xCEFC . #x7C3E)
                (#xCEFD . #x7DF4)
                (#xCEFE . #x806F)
                (#xCFA1 . #x84EE)
                (#xCFA2 . #x9023)
                (#xCFA3 . #x932C)
                (#xCFA4 . #x5442)
                (#xCFA5 . #x9B6F)
                (#xCFA6 . #x6AD3)
                (#xCFA7 . #x7089)
                (#xCFA8 . #x8CC2)
                (#xCFA9 . #x8DEF)
                (#xCFAA . #x9732)
                (#xCFAB . #x52B4)
                (#xCFAC . #x5A41)
                (#xCFAD . #x5ECA)
                (#xCFAE . #x5F04)
                (#xCFAF . #x6717)
                (#xCFB0 . #x697C)
                (#xCFB1 . #x6994)
                (#xCFB2 . #x6D6A)
                (#xCFB3 . #x6F0F)
                (#xCFB4 . #x7262)
                (#xCFB5 . #x72FC)
                (#xCFB6 . #x7BED)
                (#xCFB7 . #x8001)
                (#xCFB8 . #x807E)
                (#xCFB9 . #x874B)
                (#xCFBA . #x90CE)
                (#xCFBB . #x516D)
                (#xCFBC . #x9E93)
                (#xCFBD . #x7984)
                (#xCFBE . #x808B)
                (#xCFBF . #x9332)
                (#xCFC0 . #x8AD6)
                (#xCFC1 . #x502D)
                (#xCFC2 . #x548C)
                (#xCFC3 . #x8A71)
                (#xCFC4 . #x6B6A)
                (#xCFC5 . #x8CC4)
                (#xCFC6 . #x8107)
                (#xCFC7 . #x60D1)
                (#xCFC8 . #x67A0)
                (#xCFC9 . #x9DF2)
                (#xCFCA . #x4E99)
                (#xCFCB . #x4E98)
                (#xCFCC . #x9C10)
                (#xCFCD . #x8A6B)
                (#xCFCE . #x85C1)
                (#xCFCF . #x8568)
                (#xCFD0 . #x6900)
                (#xCFD1 . #x6E7E)
                (#xCFD2 . #x7897)
                (#xCFD3 . #x8155)
                (#xD0A1 . #x5F0C)
                (#xD0A2 . #x4E10)
                (#xD0A3 . #x4E15)
                (#xD0A4 . #x4E2A)
                (#xD0A5 . #x4E31)
                (#xD0A6 . #x4E36)
                (#xD0A7 . #x4E3C)
                (#xD0A8 . #x4E3F)
                (#xD0A9 . #x4E42)
                (#xD0AA . #x4E56)
                (#xD0AB . #x4E58)
                (#xD0AC . #x4E82)
                (#xD0AD . #x4E85)
                (#xD0AE . #x8C6B)
                (#xD0AF . #x4E8A)
                (#xD0B0 . #x8212)
                (#xD0B1 . #x5F0D)
                (#xD0B2 . #x4E8E)
                (#xD0B3 . #x4E9E)
                (#xD0B4 . #x4E9F)
                (#xD0B5 . #x4EA0)
                (#xD0B6 . #x4EA2)
                (#xD0B7 . #x4EB0)
                (#xD0B8 . #x4EB3)
                (#xD0B9 . #x4EB6)
                (#xD0BA . #x4ECE)
                (#xD0BB . #x4ECD)
                (#xD0BC . #x4EC4)
                (#xD0BD . #x4EC6)
                (#xD0BE . #x4EC2)
                (#xD0BF . #x4ED7)
                (#xD0C0 . #x4EDE)
                (#xD0C1 . #x4EED)
                (#xD0C2 . #x4EDF)
                (#xD0C3 . #x4EF7)
                (#xD0C4 . #x4F09)
                (#xD0C5 . #x4F5A)
                (#xD0C6 . #x4F30)
                (#xD0C7 . #x4F5B)
                (#xD0C8 . #x4F5D)
                (#xD0C9 . #x4F57)
                (#xD0CA . #x4F47)
                (#xD0CB . #x4F76)
                (#xD0CC . #x4F88)
                (#xD0CD . #x4F8F)
                (#xD0CE . #x4F98)
                (#xD0CF . #x4F7B)
                (#xD0D0 . #x4F69)
                (#xD0D1 . #x4F70)
                (#xD0D2 . #x4F91)
                (#xD0D3 . #x4F6F)
                (#xD0D4 . #x4F86)
                (#xD0D5 . #x4F96)
                (#xD0D6 . #x5118)
                (#xD0D7 . #x4FD4)
                (#xD0D8 . #x4FDF)
                (#xD0D9 . #x4FCE)
                (#xD0DA . #x4FD8)
                (#xD0DB . #x4FDB)
                (#xD0DC . #x4FD1)
                (#xD0DD . #x4FDA)
                (#xD0DE . #x4FD0)
                (#xD0DF . #x4FE4)
                (#xD0E0 . #x4FE5)
                (#xD0E1 . #x501A)
                (#xD0E2 . #x5028)
                (#xD0E3 . #x5014)
                (#xD0E4 . #x502A)
                (#xD0E5 . #x5025)
                (#xD0E6 . #x5005)
                (#xD0E7 . #x4F1C)
                (#xD0E8 . #x4FF6)
                (#xD0E9 . #x5021)
                (#xD0EA . #x5029)
                (#xD0EB . #x502C)
                (#xD0EC . #x4FFE)
                (#xD0ED . #x4FEF)
                (#xD0EE . #x5011)
                (#xD0EF . #x5006)
                (#xD0F0 . #x5043)
                (#xD0F1 . #x5047)
                (#xD0F2 . #x6703)
                (#xD0F3 . #x5055)
                (#xD0F4 . #x5050)
                (#xD0F5 . #x5048)
                (#xD0F6 . #x505A)
                (#xD0F7 . #x5056)
                (#xD0F8 . #x506C)
                (#xD0F9 . #x5078)
                (#xD0FA . #x5080)
                (#xD0FB . #x509A)
                (#xD0FC . #x5085)
                (#xD0FD . #x50B4)
                (#xD0FE . #x50B2)
                (#xD1A1 . #x50C9)
                (#xD1A2 . #x50CA)
                (#xD1A3 . #x50B3)
                (#xD1A4 . #x50C2)
                (#xD1A5 . #x50D6)
                (#xD1A6 . #x50DE)
                (#xD1A7 . #x50E5)
                (#xD1A8 . #x50ED)
                (#xD1A9 . #x50E3)
                (#xD1AA . #x50EE)
                (#xD1AB . #x50F9)
                (#xD1AC . #x50F5)
                (#xD1AD . #x5109)
                (#xD1AE . #x5101)
                (#xD1AF . #x5102)
                (#xD1B0 . #x5116)
                (#xD1B1 . #x5115)
                (#xD1B2 . #x5114)
                (#xD1B3 . #x511A)
                (#xD1B4 . #x5121)
                (#xD1B5 . #x513A)
                (#xD1B6 . #x5137)
                (#xD1B7 . #x513C)
                (#xD1B8 . #x513B)
                (#xD1B9 . #x513F)
                (#xD1BA . #x5140)
                (#xD1BB . #x5152)
                (#xD1BC . #x514C)
                (#xD1BD . #x5154)
                (#xD1BE . #x5162)
                (#xD1BF . #x7AF8)
                (#xD1C0 . #x5169)
                (#xD1C1 . #x516A)
                (#xD1C2 . #x516E)
                (#xD1C3 . #x5180)
                (#xD1C4 . #x5182)
                (#xD1C5 . #x56D8)
                (#xD1C6 . #x518C)
                (#xD1C7 . #x5189)
                (#xD1C8 . #x518F)
                (#xD1C9 . #x5191)
                (#xD1CA . #x5193)
                (#xD1CB . #x5195)
                (#xD1CC . #x5196)
                (#xD1CD . #x51A4)
                (#xD1CE . #x51A6)
                (#xD1CF . #x51A2)
                (#xD1D0 . #x51A9)
                (#xD1D1 . #x51AA)
                (#xD1D2 . #x51AB)
                (#xD1D3 . #x51B3)
                (#xD1D4 . #x51B1)
                (#xD1D5 . #x51B2)
                (#xD1D6 . #x51B0)
                (#xD1D7 . #x51B5)
                (#xD1D8 . #x51BD)
                (#xD1D9 . #x51C5)
                (#xD1DA . #x51C9)
                (#xD1DB . #x51DB)
                (#xD1DC . #x51E0)
                (#xD1DD . #x8655)
                (#xD1DE . #x51E9)
                (#xD1DF . #x51ED)
                (#xD1E0 . #x51F0)
                (#xD1E1 . #x51F5)
                (#xD1E2 . #x51FE)
                (#xD1E3 . #x5204)
                (#xD1E4 . #x520B)
                (#xD1E5 . #x5214)
                (#xD1E6 . #x520E)
                (#xD1E7 . #x5227)
                (#xD1E8 . #x522A)
                (#xD1E9 . #x522E)
                (#xD1EA . #x5233)
                (#xD1EB . #x5239)
                (#xD1EC . #x524F)
                (#xD1ED . #x5244)
                (#xD1EE . #x524B)
                (#xD1EF . #x524C)
                (#xD1F0 . #x525E)
                (#xD1F1 . #x5254)
                (#xD1F2 . #x526A)
                (#xD1F3 . #x5274)
                (#xD1F4 . #x5269)
                (#xD1F5 . #x5273)
                (#xD1F6 . #x527F)
                (#xD1F7 . #x527D)
                (#xD1F8 . #x528D)
                (#xD1F9 . #x5294)
                (#xD1FA . #x5292)
                (#xD1FB . #x5271)
                (#xD1FC . #x5288)
                (#xD1FD . #x5291)
                (#xD1FE . #x8FA8)
                (#xD2A1 . #x8FA7)
                (#xD2A2 . #x52AC)
                (#xD2A3 . #x52AD)
                (#xD2A4 . #x52BC)
                (#xD2A5 . #x52B5)
                (#xD2A6 . #x52C1)
                (#xD2A7 . #x52CD)
                (#xD2A8 . #x52D7)
                (#xD2A9 . #x52DE)
                (#xD2AA . #x52E3)
                (#xD2AB . #x52E6)
                (#xD2AC . #x98ED)
                (#xD2AD . #x52E0)
                (#xD2AE . #x52F3)
                (#xD2AF . #x52F5)
                (#xD2B0 . #x52F8)
                (#xD2B1 . #x52F9)
                (#xD2B2 . #x5306)
                (#xD2B3 . #x5308)
                (#xD2B4 . #x7538)
                (#xD2B5 . #x530D)
                (#xD2B6 . #x5310)
                (#xD2B7 . #x530F)
                (#xD2B8 . #x5315)
                (#xD2B9 . #x531A)
                (#xD2BA . #x5323)
                (#xD2BB . #x532F)
                (#xD2BC . #x5331)
                (#xD2BD . #x5333)
                (#xD2BE . #x5338)
                (#xD2BF . #x5340)
                (#xD2C0 . #x5346)
                (#xD2C1 . #x5345)
                (#xD2C2 . #x4E17)
                (#xD2C3 . #x5349)
                (#xD2C4 . #x534D)
                (#xD2C5 . #x51D6)
                (#xD2C6 . #x535E)
                (#xD2C7 . #x5369)
                (#xD2C8 . #x536E)
                (#xD2C9 . #x5918)
                (#xD2CA . #x537B)
                (#xD2CB . #x5377)
                (#xD2CC . #x5382)
                (#xD2CD . #x5396)
                (#xD2CE . #x53A0)
                (#xD2CF . #x53A6)
                (#xD2D0 . #x53A5)
                (#xD2D1 . #x53AE)
                (#xD2D2 . #x53B0)
                (#xD2D3 . #x53B6)
                (#xD2D4 . #x53C3)
                (#xD2D5 . #x7C12)
                (#xD2D6 . #x96D9)
                (#xD2D7 . #x53DF)
                (#xD2D8 . #x66FC)
                (#xD2D9 . #x71EE)
                (#xD2DA . #x53EE)
                (#xD2DB . #x53E8)
                (#xD2DC . #x53ED)
                (#xD2DD . #x53FA)
                (#xD2DE . #x5401)
                (#xD2DF . #x543D)
                (#xD2E0 . #x5440)
                (#xD2E1 . #x542C)
                (#xD2E2 . #x542D)
                (#xD2E3 . #x543C)
                (#xD2E4 . #x542E)
                (#xD2E5 . #x5436)
                (#xD2E6 . #x5429)
                (#xD2E7 . #x541D)
                (#xD2E8 . #x544E)
                (#xD2E9 . #x548F)
                (#xD2EA . #x5475)
                (#xD2EB . #x548E)
                (#xD2EC . #x545F)
                (#xD2ED . #x5471)
                (#xD2EE . #x5477)
                (#xD2EF . #x5470)
                (#xD2F0 . #x5492)
                (#xD2F1 . #x547B)
                (#xD2F2 . #x5480)
                (#xD2F3 . #x5476)
                (#xD2F4 . #x5484)
                (#xD2F5 . #x5490)
                (#xD2F6 . #x5486)
                (#xD2F7 . #x54C7)
                (#xD2F8 . #x54A2)
                (#xD2F9 . #x54B8)
                (#xD2FA . #x54A5)
                (#xD2FB . #x54AC)
                (#xD2FC . #x54C4)
                (#xD2FD . #x54C8)
                (#xD2FE . #x54A8)
                (#xD3A1 . #x54AB)
                (#xD3A2 . #x54C2)
                (#xD3A3 . #x54A4)
                (#xD3A4 . #x54BE)
                (#xD3A5 . #x54BC)
                (#xD3A6 . #x54D8)
                (#xD3A7 . #x54E5)
                (#xD3A8 . #x54E6)
                (#xD3A9 . #x550F)
                (#xD3AA . #x5514)
                (#xD3AB . #x54FD)
                (#xD3AC . #x54EE)
                (#xD3AD . #x54ED)
                (#xD3AE . #x54FA)
                (#xD3AF . #x54E2)
                (#xD3B0 . #x5539)
                (#xD3B1 . #x5540)
                (#xD3B2 . #x5563)
                (#xD3B3 . #x554C)
                (#xD3B4 . #x552E)
                (#xD3B5 . #x555C)
                (#xD3B6 . #x5545)
                (#xD3B7 . #x5556)
                (#xD3B8 . #x5557)
                (#xD3B9 . #x5538)
                (#xD3BA . #x5533)
                (#xD3BB . #x555D)
                (#xD3BC . #x5599)
                (#xD3BD . #x5580)
                (#xD3BE . #x54AF)
                (#xD3BF . #x558A)
                (#xD3C0 . #x559F)
                (#xD3C1 . #x557B)
                (#xD3C2 . #x557E)
                (#xD3C3 . #x5598)
                (#xD3C4 . #x559E)
                (#xD3C5 . #x55AE)
                (#xD3C6 . #x557C)
                (#xD3C7 . #x5583)
                (#xD3C8 . #x55A9)
                (#xD3C9 . #x5587)
                (#xD3CA . #x55A8)
                (#xD3CB . #x55DA)
                (#xD3CC . #x55C5)
                (#xD3CD . #x55DF)
                (#xD3CE . #x55C4)
                (#xD3CF . #x55DC)
                (#xD3D0 . #x55E4)
                (#xD3D1 . #x55D4)
                (#xD3D2 . #x5614)
                (#xD3D3 . #x55F7)
                (#xD3D4 . #x5616)
                (#xD3D5 . #x55FE)
                (#xD3D6 . #x55FD)
                (#xD3D7 . #x561B)
                (#xD3D8 . #x55F9)
                (#xD3D9 . #x564E)
                (#xD3DA . #x5650)
                (#xD3DB . #x71DF)
                (#xD3DC . #x5634)
                (#xD3DD . #x5636)
                (#xD3DE . #x5632)
                (#xD3DF . #x5638)
                (#xD3E0 . #x566B)
                (#xD3E1 . #x5664)
                (#xD3E2 . #x562F)
                (#xD3E3 . #x566C)
                (#xD3E4 . #x566A)
                (#xD3E5 . #x5686)
                (#xD3E6 . #x5680)
                (#xD3E7 . #x568A)
                (#xD3E8 . #x56A0)
                (#xD3E9 . #x5694)
                (#xD3EA . #x568F)
                (#xD3EB . #x56A5)
                (#xD3EC . #x56AE)
                (#xD3ED . #x56B6)
                (#xD3EE . #x56B4)
                (#xD3EF . #x56C2)
                (#xD3F0 . #x56BC)
                (#xD3F1 . #x56C1)
                (#xD3F2 . #x56C3)
                (#xD3F3 . #x56C0)
                (#xD3F4 . #x56C8)
                (#xD3F5 . #x56CE)
                (#xD3F6 . #x56D1)
                (#xD3F7 . #x56D3)
                (#xD3F8 . #x56D7)
                (#xD3F9 . #x56EE)
                (#xD3FA . #x56F9)
                (#xD3FB . #x5700)
                (#xD3FC . #x56FF)
                (#xD3FD . #x5704)
                (#xD3FE . #x5709)
                (#xD4A1 . #x5708)
                (#xD4A2 . #x570B)
                (#xD4A3 . #x570D)
                (#xD4A4 . #x5713)
                (#xD4A5 . #x5718)
                (#xD4A6 . #x5716)
                (#xD4A7 . #x55C7)
                (#xD4A8 . #x571C)
                (#xD4A9 . #x5726)
                (#xD4AA . #x5737)
                (#xD4AB . #x5738)
                (#xD4AC . #x574E)
                (#xD4AD . #x573B)
                (#xD4AE . #x5740)
                (#xD4AF . #x574F)
                (#xD4B0 . #x5769)
                (#xD4B1 . #x57C0)
                (#xD4B2 . #x5788)
                (#xD4B3 . #x5761)
                (#xD4B4 . #x577F)
                (#xD4B5 . #x5789)
                (#xD4B6 . #x5793)
                (#xD4B7 . #x57A0)
                (#xD4B8 . #x57B3)
                (#xD4B9 . #x57A4)
                (#xD4BA . #x57AA)
                (#xD4BB . #x57B0)
                (#xD4BC . #x57C3)
                (#xD4BD . #x57C6)
                (#xD4BE . #x57D4)
                (#xD4BF . #x57D2)
                (#xD4C0 . #x57D3)
                (#xD4C1 . #x580A)
                (#xD4C2 . #x57D6)
                (#xD4C3 . #x57E3)
                (#xD4C4 . #x580B)
                (#xD4C5 . #x5819)
                (#xD4C6 . #x581D)
                (#xD4C7 . #x5872)
                (#xD4C8 . #x5821)
                (#xD4C9 . #x5862)
                (#xD4CA . #x584B)
                (#xD4CB . #x5870)
                (#xD4CC . #x6BC0)
                (#xD4CD . #x5852)
                (#xD4CE . #x583D)
                (#xD4CF . #x5879)
                (#xD4D0 . #x5885)
                (#xD4D1 . #x58B9)
                (#xD4D2 . #x589F)
                (#xD4D3 . #x58AB)
                (#xD4D4 . #x58BA)
                (#xD4D5 . #x58DE)
                (#xD4D6 . #x58BB)
                (#xD4D7 . #x58B8)
                (#xD4D8 . #x58AE)
                (#xD4D9 . #x58C5)
                (#xD4DA . #x58D3)
                (#xD4DB . #x58D1)
                (#xD4DC . #x58D7)
                (#xD4DD . #x58D9)
                (#xD4DE . #x58D8)
                (#xD4DF . #x58E5)
                (#xD4E0 . #x58DC)
                (#xD4E1 . #x58E4)
                (#xD4E2 . #x58DF)
                (#xD4E3 . #x58EF)
                (#xD4E4 . #x58FA)
                (#xD4E5 . #x58F9)
                (#xD4E6 . #x58FB)
                (#xD4E7 . #x58FC)
                (#xD4E8 . #x58FD)
                (#xD4E9 . #x5902)
                (#xD4EA . #x590A)
                (#xD4EB . #x5910)
                (#xD4EC . #x591B)
                (#xD4ED . #x68A6)
                (#xD4EE . #x5925)
                (#xD4EF . #x592C)
                (#xD4F0 . #x592D)
                (#xD4F1 . #x5932)
                (#xD4F2 . #x5938)
                (#xD4F3 . #x593E)
                (#xD4F4 . #x7AD2)
                (#xD4F5 . #x5955)
                (#xD4F6 . #x5950)
                (#xD4F7 . #x594E)
                (#xD4F8 . #x595A)
                (#xD4F9 . #x5958)
                (#xD4FA . #x5962)
                (#xD4FB . #x5960)
                (#xD4FC . #x5967)
                (#xD4FD . #x596C)
                (#xD4FE . #x5969)
                (#xD5A1 . #x5978)
                (#xD5A2 . #x5981)
                (#xD5A3 . #x599D)
                (#xD5A4 . #x4F5E)
                (#xD5A5 . #x4FAB)
                (#xD5A6 . #x59A3)
                (#xD5A7 . #x59B2)
                (#xD5A8 . #x59C6)
                (#xD5A9 . #x59E8)
                (#xD5AA . #x59DC)
                (#xD5AB . #x598D)
                (#xD5AC . #x59D9)
                (#xD5AD . #x59DA)
                (#xD5AE . #x5A25)
                (#xD5AF . #x5A1F)
                (#xD5B0 . #x5A11)
                (#xD5B1 . #x5A1C)
                (#xD5B2 . #x5A09)
                (#xD5B3 . #x5A1A)
                (#xD5B4 . #x5A40)
                (#xD5B5 . #x5A6C)
                (#xD5B6 . #x5A49)
                (#xD5B7 . #x5A35)
                (#xD5B8 . #x5A36)
                (#xD5B9 . #x5A62)
                (#xD5BA . #x5A6A)
                (#xD5BB . #x5A9A)
                (#xD5BC . #x5ABC)
                (#xD5BD . #x5ABE)
                (#xD5BE . #x5ACB)
                (#xD5BF . #x5AC2)
                (#xD5C0 . #x5ABD)
                (#xD5C1 . #x5AE3)
                (#xD5C2 . #x5AD7)
                (#xD5C3 . #x5AE6)
                (#xD5C4 . #x5AE9)
                (#xD5C5 . #x5AD6)
                (#xD5C6 . #x5AFA)
                (#xD5C7 . #x5AFB)
                (#xD5C8 . #x5B0C)
                (#xD5C9 . #x5B0B)
                (#xD5CA . #x5B16)
                (#xD5CB . #x5B32)
                (#xD5CC . #x5AD0)
                (#xD5CD . #x5B2A)
                (#xD5CE . #x5B36)
                (#xD5CF . #x5B3E)
                (#xD5D0 . #x5B43)
                (#xD5D1 . #x5B45)
                (#xD5D2 . #x5B40)
                (#xD5D3 . #x5B51)
                (#xD5D4 . #x5B55)
                (#xD5D5 . #x5B5A)
                (#xD5D6 . #x5B5B)
                (#xD5D7 . #x5B65)
                (#xD5D8 . #x5B69)
                (#xD5D9 . #x5B70)
                (#xD5DA . #x5B73)
                (#xD5DB . #x5B75)
                (#xD5DC . #x5B78)
                (#xD5DD . #x6588)
                (#xD5DE . #x5B7A)
                (#xD5DF . #x5B80)
                (#xD5E0 . #x5B83)
                (#xD5E1 . #x5BA6)
                (#xD5E2 . #x5BB8)
                (#xD5E3 . #x5BC3)
                (#xD5E4 . #x5BC7)
                (#xD5E5 . #x5BC9)
                (#xD5E6 . #x5BD4)
                (#xD5E7 . #x5BD0)
                (#xD5E8 . #x5BE4)
                (#xD5E9 . #x5BE6)
                (#xD5EA . #x5BE2)
                (#xD5EB . #x5BDE)
                (#xD5EC . #x5BE5)
                (#xD5ED . #x5BEB)
                (#xD5EE . #x5BF0)
                (#xD5EF . #x5BF6)
                (#xD5F0 . #x5BF3)
                (#xD5F1 . #x5C05)
                (#xD5F2 . #x5C07)
                (#xD5F3 . #x5C08)
                (#xD5F4 . #x5C0D)
                (#xD5F5 . #x5C13)
                (#xD5F6 . #x5C20)
                (#xD5F7 . #x5C22)
                (#xD5F8 . #x5C28)
                (#xD5F9 . #x5C38)
                (#xD5FA . #x5C39)
                (#xD5FB . #x5C41)
                (#xD5FC . #x5C46)
                (#xD5FD . #x5C4E)
                (#xD5FE . #x5C53)
                (#xD6A1 . #x5C50)
                (#xD6A2 . #x5C4F)
                (#xD6A3 . #x5B71)
                (#xD6A4 . #x5C6C)
                (#xD6A5 . #x5C6E)
                (#xD6A6 . #x4E62)
                (#xD6A7 . #x5C76)
                (#xD6A8 . #x5C79)
                (#xD6A9 . #x5C8C)
                (#xD6AA . #x5C91)
                (#xD6AB . #x5C94)
                (#xD6AC . #x599B)
                (#xD6AD . #x5CAB)
                (#xD6AE . #x5CBB)
                (#xD6AF . #x5CB6)
                (#xD6B0 . #x5CBC)
                (#xD6B1 . #x5CB7)
                (#xD6B2 . #x5CC5)
                (#xD6B3 . #x5CBE)
                (#xD6B4 . #x5CC7)
                (#xD6B5 . #x5CD9)
                (#xD6B6 . #x5CE9)
                (#xD6B7 . #x5CFD)
                (#xD6B8 . #x5CFA)
                (#xD6B9 . #x5CED)
                (#xD6BA . #x5D8C)
                (#xD6BB . #x5CEA)
                (#xD6BC . #x5D0B)
                (#xD6BD . #x5D15)
                (#xD6BE . #x5D17)
                (#xD6BF . #x5D5C)
                (#xD6C0 . #x5D1F)
                (#xD6C1 . #x5D1B)
                (#xD6C2 . #x5D11)
                (#xD6C3 . #x5D14)
                (#xD6C4 . #x5D22)
                (#xD6C5 . #x5D1A)
                (#xD6C6 . #x5D19)
                (#xD6C7 . #x5D18)
                (#xD6C8 . #x5D4C)
                (#xD6C9 . #x5D52)
                (#xD6CA . #x5D4E)
                (#xD6CB . #x5D4B)
                (#xD6CC . #x5D6C)
                (#xD6CD . #x5D73)
                (#xD6CE . #x5D76)
                (#xD6CF . #x5D87)
                (#xD6D0 . #x5D84)
                (#xD6D1 . #x5D82)
                (#xD6D2 . #x5DA2)
                (#xD6D3 . #x5D9D)
                (#xD6D4 . #x5DAC)
                (#xD6D5 . #x5DAE)
                (#xD6D6 . #x5DBD)
                (#xD6D7 . #x5D90)
                (#xD6D8 . #x5DB7)
                (#xD6D9 . #x5DBC)
                (#xD6DA . #x5DC9)
                (#xD6DB . #x5DCD)
                (#xD6DC . #x5DD3)
                (#xD6DD . #x5DD2)
                (#xD6DE . #x5DD6)
                (#xD6DF . #x5DDB)
                (#xD6E0 . #x5DEB)
                (#xD6E1 . #x5DF2)
                (#xD6E2 . #x5DF5)
                (#xD6E3 . #x5E0B)
                (#xD6E4 . #x5E1A)
                (#xD6E5 . #x5E19)
                (#xD6E6 . #x5E11)
                (#xD6E7 . #x5E1B)
                (#xD6E8 . #x5E36)
                (#xD6E9 . #x5E37)
                (#xD6EA . #x5E44)
                (#xD6EB . #x5E43)
                (#xD6EC . #x5E40)
                (#xD6ED . #x5E4E)
                (#xD6EE . #x5E57)
                (#xD6EF . #x5E54)
                (#xD6F0 . #x5E5F)
                (#xD6F1 . #x5E62)
                (#xD6F2 . #x5E64)
                (#xD6F3 . #x5E47)
                (#xD6F4 . #x5E75)
                (#xD6F5 . #x5E76)
                (#xD6F6 . #x5E7A)
                (#xD6F7 . #x9EBC)
                (#xD6F8 . #x5E7F)
                (#xD6F9 . #x5EA0)
                (#xD6FA . #x5EC1)
                (#xD6FB . #x5EC2)
                (#xD6FC . #x5EC8)
                (#xD6FD . #x5ED0)
                (#xD6FE . #x5ECF)
                (#xD7A1 . #x5ED6)
                (#xD7A2 . #x5EE3)
                (#xD7A3 . #x5EDD)
                (#xD7A4 . #x5EDA)
                (#xD7A5 . #x5EDB)
                (#xD7A6 . #x5EE2)
                (#xD7A7 . #x5EE1)
                (#xD7A8 . #x5EE8)
                (#xD7A9 . #x5EE9)
                (#xD7AA . #x5EEC)
                (#xD7AB . #x5EF1)
                (#xD7AC . #x5EF3)
                (#xD7AD . #x5EF0)
                (#xD7AE . #x5EF4)
                (#xD7AF . #x5EF8)
                (#xD7B0 . #x5EFE)
                (#xD7B1 . #x5F03)
                (#xD7B2 . #x5F09)
                (#xD7B3 . #x5F5D)
                (#xD7B4 . #x5F5C)
                (#xD7B5 . #x5F0B)
                (#xD7B6 . #x5F11)
                (#xD7B7 . #x5F16)
                (#xD7B8 . #x5F29)
                (#xD7B9 . #x5F2D)
                (#xD7BA . #x5F38)
                (#xD7BB . #x5F41)
                (#xD7BC . #x5F48)
                (#xD7BD . #x5F4C)
                (#xD7BE . #x5F4E)
                (#xD7BF . #x5F2F)
                (#xD7C0 . #x5F51)
                (#xD7C1 . #x5F56)
                (#xD7C2 . #x5F57)
                (#xD7C3 . #x5F59)
                (#xD7C4 . #x5F61)
                (#xD7C5 . #x5F6D)
                (#xD7C6 . #x5F73)
                (#xD7C7 . #x5F77)
                (#xD7C8 . #x5F83)
                (#xD7C9 . #x5F82)
                (#xD7CA . #x5F7F)
                (#xD7CB . #x5F8A)
                (#xD7CC . #x5F88)
                (#xD7CD . #x5F91)
                (#xD7CE . #x5F87)
                (#xD7CF . #x5F9E)
                (#xD7D0 . #x5F99)
                (#xD7D1 . #x5F98)
                (#xD7D2 . #x5FA0)
                (#xD7D3 . #x5FA8)
                (#xD7D4 . #x5FAD)
                (#xD7D5 . #x5FBC)
                (#xD7D6 . #x5FD6)
                (#xD7D7 . #x5FFB)
                (#xD7D8 . #x5FE4)
                (#xD7D9 . #x5FF8)
                (#xD7DA . #x5FF1)
                (#xD7DB . #x5FDD)
                (#xD7DC . #x60B3)
                (#xD7DD . #x5FFF)
                (#xD7DE . #x6021)
                (#xD7DF . #x6060)
                (#xD7E0 . #x6019)
                (#xD7E1 . #x6010)
                (#xD7E2 . #x6029)
                (#xD7E3 . #x600E)
                (#xD7E4 . #x6031)
                (#xD7E5 . #x601B)
                (#xD7E6 . #x6015)
                (#xD7E7 . #x602B)
                (#xD7E8 . #x6026)
                (#xD7E9 . #x600F)
                (#xD7EA . #x603A)
                (#xD7EB . #x605A)
                (#xD7EC . #x6041)
                (#xD7ED . #x606A)
                (#xD7EE . #x6077)
                (#xD7EF . #x605F)
                (#xD7F0 . #x604A)
                (#xD7F1 . #x6046)
                (#xD7F2 . #x604D)
                (#xD7F3 . #x6063)
                (#xD7F4 . #x6043)
                (#xD7F5 . #x6064)
                (#xD7F6 . #x6042)
                (#xD7F7 . #x606C)
                (#xD7F8 . #x606B)
                (#xD7F9 . #x6059)
                (#xD7FA . #x6081)
                (#xD7FB . #x608D)
                (#xD7FC . #x60E7)
                (#xD7FD . #x6083)
                (#xD7FE . #x609A)
                (#xD8A1 . #x6084)
                (#xD8A2 . #x609B)
                (#xD8A3 . #x6096)
                (#xD8A4 . #x6097)
                (#xD8A5 . #x6092)
                (#xD8A6 . #x60A7)
                (#xD8A7 . #x608B)
                (#xD8A8 . #x60E1)
                (#xD8A9 . #x60B8)
                (#xD8AA . #x60E0)
                (#xD8AB . #x60D3)
                (#xD8AC . #x60B4)
                (#xD8AD . #x5FF0)
                (#xD8AE . #x60BD)
                (#xD8AF . #x60C6)
                (#xD8B0 . #x60B5)
                (#xD8B1 . #x60D8)
                (#xD8B2 . #x614D)
                (#xD8B3 . #x6115)
                (#xD8B4 . #x6106)
                (#xD8B5 . #x60F6)
                (#xD8B6 . #x60F7)
                (#xD8B7 . #x6100)
                (#xD8B8 . #x60F4)
                (#xD8B9 . #x60FA)
                (#xD8BA . #x6103)
                (#xD8BB . #x6121)
                (#xD8BC . #x60FB)
                (#xD8BD . #x60F1)
                (#xD8BE . #x610D)
                (#xD8BF . #x610E)
                (#xD8C0 . #x6147)
                (#xD8C1 . #x613E)
                (#xD8C2 . #x6128)
                (#xD8C3 . #x6127)
                (#xD8C4 . #x614A)
                (#xD8C5 . #x613F)
                (#xD8C6 . #x613C)
                (#xD8C7 . #x612C)
                (#xD8C8 . #x6134)
                (#xD8C9 . #x613D)
                (#xD8CA . #x6142)
                (#xD8CB . #x6144)
                (#xD8CC . #x6173)
                (#xD8CD . #x6177)
                (#xD8CE . #x6158)
                (#xD8CF . #x6159)
                (#xD8D0 . #x615A)
                (#xD8D1 . #x616B)
                (#xD8D2 . #x6174)
                (#xD8D3 . #x616F)
                (#xD8D4 . #x6165)
                (#xD8D5 . #x6171)
                (#xD8D6 . #x615F)
                (#xD8D7 . #x615D)
                (#xD8D8 . #x6153)
                (#xD8D9 . #x6175)
                (#xD8DA . #x6199)
                (#xD8DB . #x6196)
                (#xD8DC . #x6187)
                (#xD8DD . #x61AC)
                (#xD8DE . #x6194)
                (#xD8DF . #x619A)
                (#xD8E0 . #x618A)
                (#xD8E1 . #x6191)
                (#xD8E2 . #x61AB)
                (#xD8E3 . #x61AE)
                (#xD8E4 . #x61CC)
                (#xD8E5 . #x61CA)
                (#xD8E6 . #x61C9)
                (#xD8E7 . #x61F7)
                (#xD8E8 . #x61C8)
                (#xD8E9 . #x61C3)
                (#xD8EA . #x61C6)
                (#xD8EB . #x61BA)
                (#xD8EC . #x61CB)
                (#xD8ED . #x7F79)
                (#xD8EE . #x61CD)
                (#xD8EF . #x61E6)
                (#xD8F0 . #x61E3)
                (#xD8F1 . #x61F6)
                (#xD8F2 . #x61FA)
                (#xD8F3 . #x61F4)
                (#xD8F4 . #x61FF)
                (#xD8F5 . #x61FD)
                (#xD8F6 . #x61FC)
                (#xD8F7 . #x61FE)
                (#xD8F8 . #x6200)
                (#xD8F9 . #x6208)
                (#xD8FA . #x6209)
                (#xD8FB . #x620D)
                (#xD8FC . #x620C)
                (#xD8FD . #x6214)
                (#xD8FE . #x621B)
                (#xD9A1 . #x621E)
                (#xD9A2 . #x6221)
                (#xD9A3 . #x622A)
                (#xD9A4 . #x622E)
                (#xD9A5 . #x6230)
                (#xD9A6 . #x6232)
                (#xD9A7 . #x6233)
                (#xD9A8 . #x6241)
                (#xD9A9 . #x624E)
                (#xD9AA . #x625E)
                (#xD9AB . #x6263)
                (#xD9AC . #x625B)
                (#xD9AD . #x6260)
                (#xD9AE . #x6268)
                (#xD9AF . #x627C)
                (#xD9B0 . #x6282)
                (#xD9B1 . #x6289)
                (#xD9B2 . #x627E)
                (#xD9B3 . #x6292)
                (#xD9B4 . #x6293)
                (#xD9B5 . #x6296)
                (#xD9B6 . #x62D4)
                (#xD9B7 . #x6283)
                (#xD9B8 . #x6294)
                (#xD9B9 . #x62D7)
                (#xD9BA . #x62D1)
                (#xD9BB . #x62BB)
                (#xD9BC . #x62CF)
                (#xD9BD . #x62FF)
                (#xD9BE . #x62C6)
                (#xD9BF . #x64D4)
                (#xD9C0 . #x62C8)
                (#xD9C1 . #x62DC)
                (#xD9C2 . #x62CC)
                (#xD9C3 . #x62CA)
                (#xD9C4 . #x62C2)
                (#xD9C5 . #x62C7)
                (#xD9C6 . #x629B)
                (#xD9C7 . #x62C9)
                (#xD9C8 . #x630C)
                (#xD9C9 . #x62EE)
                (#xD9CA . #x62F1)
                (#xD9CB . #x6327)
                (#xD9CC . #x6302)
                (#xD9CD . #x6308)
                (#xD9CE . #x62EF)
                (#xD9CF . #x62F5)
                (#xD9D0 . #x6350)
                (#xD9D1 . #x633E)
                (#xD9D2 . #x634D)
                (#xD9D3 . #x641C)
                (#xD9D4 . #x634F)
                (#xD9D5 . #x6396)
                (#xD9D6 . #x638E)
                (#xD9D7 . #x6380)
                (#xD9D8 . #x63AB)
                (#xD9D9 . #x6376)
                (#xD9DA . #x63A3)
                (#xD9DB . #x638F)
                (#xD9DC . #x6389)
                (#xD9DD . #x639F)
                (#xD9DE . #x63B5)
                (#xD9DF . #x636B)
                (#xD9E0 . #x6369)
                (#xD9E1 . #x63BE)
                (#xD9E2 . #x63E9)
                (#xD9E3 . #x63C0)
                (#xD9E4 . #x63C6)
                (#xD9E5 . #x63E3)
                (#xD9E6 . #x63C9)
                (#xD9E7 . #x63D2)
                (#xD9E8 . #x63F6)
                (#xD9E9 . #x63C4)
                (#xD9EA . #x6416)
                (#xD9EB . #x6434)
                (#xD9EC . #x6406)
                (#xD9ED . #x6413)
                (#xD9EE . #x6426)
                (#xD9EF . #x6436)
                (#xD9F0 . #x651D)
                (#xD9F1 . #x6417)
                (#xD9F2 . #x6428)
                (#xD9F3 . #x640F)
                (#xD9F4 . #x6467)
                (#xD9F5 . #x646F)
                (#xD9F6 . #x6476)
                (#xD9F7 . #x644E)
                (#xD9F8 . #x652A)
                (#xD9F9 . #x6495)
                (#xD9FA . #x6493)
                (#xD9FB . #x64A5)
                (#xD9FC . #x64A9)
                (#xD9FD . #x6488)
                (#xD9FE . #x64BC)
                (#xDAA1 . #x64DA)
                (#xDAA2 . #x64D2)
                (#xDAA3 . #x64C5)
                (#xDAA4 . #x64C7)
                (#xDAA5 . #x64BB)
                (#xDAA6 . #x64D8)
                (#xDAA7 . #x64C2)
                (#xDAA8 . #x64F1)
                (#xDAA9 . #x64E7)
                (#xDAAA . #x8209)
                (#xDAAB . #x64E0)
                (#xDAAC . #x64E1)
                (#xDAAD . #x62AC)
                (#xDAAE . #x64E3)
                (#xDAAF . #x64EF)
                (#xDAB0 . #x652C)
                (#xDAB1 . #x64F6)
                (#xDAB2 . #x64F4)
                (#xDAB3 . #x64F2)
                (#xDAB4 . #x64FA)
                (#xDAB5 . #x6500)
                (#xDAB6 . #x64FD)
                (#xDAB7 . #x6518)
                (#xDAB8 . #x651C)
                (#xDAB9 . #x6505)
                (#xDABA . #x6524)
                (#xDABB . #x6523)
                (#xDABC . #x652B)
                (#xDABD . #x6534)
                (#xDABE . #x6535)
                (#xDABF . #x6537)
                (#xDAC0 . #x6536)
                (#xDAC1 . #x6538)
                (#xDAC2 . #x754B)
                (#xDAC3 . #x6548)
                (#xDAC4 . #x6556)
                (#xDAC5 . #x6555)
                (#xDAC6 . #x654D)
                (#xDAC7 . #x6558)
                (#xDAC8 . #x655E)
                (#xDAC9 . #x655D)
                (#xDACA . #x6572)
                (#xDACB . #x6578)
                (#xDACC . #x6582)
                (#xDACD . #x6583)
                (#xDACE . #x8B8A)
                (#xDACF . #x659B)
                (#xDAD0 . #x659F)
                (#xDAD1 . #x65AB)
                (#xDAD2 . #x65B7)
                (#xDAD3 . #x65C3)
                (#xDAD4 . #x65C6)
                (#xDAD5 . #x65C1)
                (#xDAD6 . #x65C4)
                (#xDAD7 . #x65CC)
                (#xDAD8 . #x65D2)
                (#xDAD9 . #x65DB)
                (#xDADA . #x65D9)
                (#xDADB . #x65E0)
                (#xDADC . #x65E1)
                (#xDADD . #x65F1)
                (#xDADE . #x6772)
                (#xDADF . #x660A)
                (#xDAE0 . #x6603)
                (#xDAE1 . #x65FB)
                (#xDAE2 . #x6773)
                (#xDAE3 . #x6635)
                (#xDAE4 . #x6636)
                (#xDAE5 . #x6634)
                (#xDAE6 . #x661C)
                (#xDAE7 . #x664F)
                (#xDAE8 . #x6644)
                (#xDAE9 . #x6649)
                (#xDAEA . #x6641)
                (#xDAEB . #x665E)
                (#xDAEC . #x665D)
                (#xDAED . #x6664)
                (#xDAEE . #x6667)
                (#xDAEF . #x6668)
                (#xDAF0 . #x665F)
                (#xDAF1 . #x6662)
                (#xDAF2 . #x6670)
                (#xDAF3 . #x6683)
                (#xDAF4 . #x6688)
                (#xDAF5 . #x668E)
                (#xDAF6 . #x6689)
                (#xDAF7 . #x6684)
                (#xDAF8 . #x6698)
                (#xDAF9 . #x669D)
                (#xDAFA . #x66C1)
                (#xDAFB . #x66B9)
                (#xDAFC . #x66C9)
                (#xDAFD . #x66BE)
                (#xDAFE . #x66BC)
                (#xDBA1 . #x66C4)
                (#xDBA2 . #x66B8)
                (#xDBA3 . #x66D6)
                (#xDBA4 . #x66DA)
                (#xDBA5 . #x66E0)
                (#xDBA6 . #x663F)
                (#xDBA7 . #x66E6)
                (#xDBA8 . #x66E9)
                (#xDBA9 . #x66F0)
                (#xDBAA . #x66F5)
                (#xDBAB . #x66F7)
                (#xDBAC . #x670F)
                (#xDBAD . #x6716)
                (#xDBAE . #x671E)
                (#xDBAF . #x6726)
                (#xDBB0 . #x6727)
                (#xDBB1 . #x9738)
                (#xDBB2 . #x672E)
                (#xDBB3 . #x673F)
                (#xDBB4 . #x6736)
                (#xDBB5 . #x6741)
                (#xDBB6 . #x6738)
                (#xDBB7 . #x6737)
                (#xDBB8 . #x6746)
                (#xDBB9 . #x675E)
                (#xDBBA . #x6760)
                (#xDBBB . #x6759)
                (#xDBBC . #x6763)
                (#xDBBD . #x6764)
                (#xDBBE . #x6789)
                (#xDBBF . #x6770)
                (#xDBC0 . #x67A9)
                (#xDBC1 . #x677C)
                (#xDBC2 . #x676A)
                (#xDBC3 . #x678C)
                (#xDBC4 . #x678B)
                (#xDBC5 . #x67A6)
                (#xDBC6 . #x67A1)
                (#xDBC7 . #x6785)
                (#xDBC8 . #x67B7)
                (#xDBC9 . #x67EF)
                (#xDBCA . #x67B4)
                (#xDBCB . #x67EC)
                (#xDBCC . #x67B3)
                (#xDBCD . #x67E9)
                (#xDBCE . #x67B8)
                (#xDBCF . #x67E4)
                (#xDBD0 . #x67DE)
                (#xDBD1 . #x67DD)
                (#xDBD2 . #x67E2)
                (#xDBD3 . #x67EE)
                (#xDBD4 . #x67B9)
                (#xDBD5 . #x67CE)
                (#xDBD6 . #x67C6)
                (#xDBD7 . #x67E7)
                (#xDBD8 . #x6A9C)
                (#xDBD9 . #x681E)
                (#xDBDA . #x6846)
                (#xDBDB . #x6829)
                (#xDBDC . #x6840)
                (#xDBDD . #x684D)
                (#xDBDE . #x6832)
                (#xDBDF . #x684E)
                (#xDBE0 . #x68B3)
                (#xDBE1 . #x682B)
                (#xDBE2 . #x6859)
                (#xDBE3 . #x6863)
                (#xDBE4 . #x6877)
                (#xDBE5 . #x687F)
                (#xDBE6 . #x689F)
                (#xDBE7 . #x688F)
                (#xDBE8 . #x68AD)
                (#xDBE9 . #x6894)
                (#xDBEA . #x689D)
                (#xDBEB . #x689B)
                (#xDBEC . #x6883)
                (#xDBED . #x6AAE)
                (#xDBEE . #x68B9)
                (#xDBEF . #x6874)
                (#xDBF0 . #x68B5)
                (#xDBF1 . #x68A0)
                (#xDBF2 . #x68BA)
                (#xDBF3 . #x690F)
                (#xDBF4 . #x688D)
                (#xDBF5 . #x687E)
                (#xDBF6 . #x6901)
                (#xDBF7 . #x68CA)
                (#xDBF8 . #x6908)
                (#xDBF9 . #x68D8)
                (#xDBFA . #x6922)
                (#xDBFB . #x6926)
                (#xDBFC . #x68E1)
                (#xDBFD . #x690C)
                (#xDBFE . #x68CD)
                (#xDCA1 . #x68D4)
                (#xDCA2 . #x68E7)
                (#xDCA3 . #x68D5)
                (#xDCA4 . #x6936)
                (#xDCA5 . #x6912)
                (#xDCA6 . #x6904)
                (#xDCA7 . #x68D7)
                (#xDCA8 . #x68E3)
                (#xDCA9 . #x6925)
                (#xDCAA . #x68F9)
                (#xDCAB . #x68E0)
                (#xDCAC . #x68EF)
                (#xDCAD . #x6928)
                (#xDCAE . #x692A)
                (#xDCAF . #x691A)
                (#xDCB0 . #x6923)
                (#xDCB1 . #x6921)
                (#xDCB2 . #x68C6)
                (#xDCB3 . #x6979)
                (#xDCB4 . #x6977)
                (#xDCB5 . #x695C)
                (#xDCB6 . #x6978)
                (#xDCB7 . #x696B)
                (#xDCB8 . #x6954)
                (#xDCB9 . #x697E)
                (#xDCBA . #x696E)
                (#xDCBB . #x6939)
                (#xDCBC . #x6974)
                (#xDCBD . #x693D)
                (#xDCBE . #x6959)
                (#xDCBF . #x6930)
                (#xDCC0 . #x6961)
                (#xDCC1 . #x695E)
                (#xDCC2 . #x695D)
                (#xDCC3 . #x6981)
                (#xDCC4 . #x696A)
                (#xDCC5 . #x69B2)
                (#xDCC6 . #x69AE)
                (#xDCC7 . #x69D0)
                (#xDCC8 . #x69BF)
                (#xDCC9 . #x69C1)
                (#xDCCA . #x69D3)
                (#xDCCB . #x69BE)
                (#xDCCC . #x69CE)
                (#xDCCD . #x5BE8)
                (#xDCCE . #x69CA)
                (#xDCCF . #x69DD)
                (#xDCD0 . #x69BB)
                (#xDCD1 . #x69C3)
                (#xDCD2 . #x69A7)
                (#xDCD3 . #x6A2E)
                (#xDCD4 . #x6991)
                (#xDCD5 . #x69A0)
                (#xDCD6 . #x699C)
                (#xDCD7 . #x6995)
                (#xDCD8 . #x69B4)
                (#xDCD9 . #x69DE)
                (#xDCDA . #x69E8)
                (#xDCDB . #x6A02)
                (#xDCDC . #x6A1B)
                (#xDCDD . #x69FF)
                (#xDCDE . #x6B0A)
                (#xDCDF . #x69F9)
                (#xDCE0 . #x69F2)
                (#xDCE1 . #x69E7)
                (#xDCE2 . #x6A05)
                (#xDCE3 . #x69B1)
                (#xDCE4 . #x6A1E)
                (#xDCE5 . #x69ED)
                (#xDCE6 . #x6A14)
                (#xDCE7 . #x69EB)
                (#xDCE8 . #x6A0A)
                (#xDCE9 . #x6A12)
                (#xDCEA . #x6AC1)
                (#xDCEB . #x6A23)
                (#xDCEC . #x6A13)
                (#xDCED . #x6A44)
                (#xDCEE . #x6A0C)
                (#xDCEF . #x6A72)
                (#xDCF0 . #x6A36)
                (#xDCF1 . #x6A78)
                (#xDCF2 . #x6A47)
                (#xDCF3 . #x6A62)
                (#xDCF4 . #x6A59)
                (#xDCF5 . #x6A66)
                (#xDCF6 . #x6A48)
                (#xDCF7 . #x6A38)
                (#xDCF8 . #x6A22)
                (#xDCF9 . #x6A90)
                (#xDCFA . #x6A8D)
                (#xDCFB . #x6AA0)
                (#xDCFC . #x6A84)
                (#xDCFD . #x6AA2)
                (#xDCFE . #x6AA3)
                (#xDDA1 . #x6A97)
                (#xDDA2 . #x8617)
                (#xDDA3 . #x6ABB)
                (#xDDA4 . #x6AC3)
                (#xDDA5 . #x6AC2)
                (#xDDA6 . #x6AB8)
                (#xDDA7 . #x6AB3)
                (#xDDA8 . #x6AAC)
                (#xDDA9 . #x6ADE)
                (#xDDAA . #x6AD1)
                (#xDDAB . #x6ADF)
                (#xDDAC . #x6AAA)
                (#xDDAD . #x6ADA)
                (#xDDAE . #x6AEA)
                (#xDDAF . #x6AFB)
                (#xDDB0 . #x6B05)
                (#xDDB1 . #x8616)
                (#xDDB2 . #x6AFA)
                (#xDDB3 . #x6B12)
                (#xDDB4 . #x6B16)
                (#xDDB5 . #x9B31)
                (#xDDB6 . #x6B1F)
                (#xDDB7 . #x6B38)
                (#xDDB8 . #x6B37)
                (#xDDB9 . #x76DC)
                (#xDDBA . #x6B39)
                (#xDDBB . #x98EE)
                (#xDDBC . #x6B47)
                (#xDDBD . #x6B43)
                (#xDDBE . #x6B49)
                (#xDDBF . #x6B50)
                (#xDDC0 . #x6B59)
                (#xDDC1 . #x6B54)
                (#xDDC2 . #x6B5B)
                (#xDDC3 . #x6B5F)
                (#xDDC4 . #x6B61)
                (#xDDC5 . #x6B78)
                (#xDDC6 . #x6B79)
                (#xDDC7 . #x6B7F)
                (#xDDC8 . #x6B80)
                (#xDDC9 . #x6B84)
                (#xDDCA . #x6B83)
                (#xDDCB . #x6B8D)
                (#xDDCC . #x6B98)
                (#xDDCD . #x6B95)
                (#xDDCE . #x6B9E)
                (#xDDCF . #x6BA4)
                (#xDDD0 . #x6BAA)
                (#xDDD1 . #x6BAB)
                (#xDDD2 . #x6BAF)
                (#xDDD3 . #x6BB2)
                (#xDDD4 . #x6BB1)
                (#xDDD5 . #x6BB3)
                (#xDDD6 . #x6BB7)
                (#xDDD7 . #x6BBC)
                (#xDDD8 . #x6BC6)
                (#xDDD9 . #x6BCB)
                (#xDDDA . #x6BD3)
                (#xDDDB . #x6BDF)
                (#xDDDC . #x6BEC)
                (#xDDDD . #x6BEB)
                (#xDDDE . #x6BF3)
                (#xDDDF . #x6BEF)
                (#xDDE0 . #x9EBE)
                (#xDDE1 . #x6C08)
                (#xDDE2 . #x6C13)
                (#xDDE3 . #x6C14)
                (#xDDE4 . #x6C1B)
                (#xDDE5 . #x6C24)
                (#xDDE6 . #x6C23)
                (#xDDE7 . #x6C5E)
                (#xDDE8 . #x6C55)
                (#xDDE9 . #x6C62)
                (#xDDEA . #x6C6A)
                (#xDDEB . #x6C82)
                (#xDDEC . #x6C8D)
                (#xDDED . #x6C9A)
                (#xDDEE . #x6C81)
                (#xDDEF . #x6C9B)
                (#xDDF0 . #x6C7E)
                (#xDDF1 . #x6C68)
                (#xDDF2 . #x6C73)
                (#xDDF3 . #x6C92)
                (#xDDF4 . #x6C90)
                (#xDDF5 . #x6CC4)
                (#xDDF6 . #x6CF1)
                (#xDDF7 . #x6CD3)
                (#xDDF8 . #x6CBD)
                (#xDDF9 . #x6CD7)
                (#xDDFA . #x6CC5)
                (#xDDFB . #x6CDD)
                (#xDDFC . #x6CAE)
                (#xDDFD . #x6CB1)
                (#xDDFE . #x6CBE)
                (#xDEA1 . #x6CBA)
                (#xDEA2 . #x6CDB)
                (#xDEA3 . #x6CEF)
                (#xDEA4 . #x6CD9)
                (#xDEA5 . #x6CEA)
                (#xDEA6 . #x6D1F)
                (#xDEA7 . #x884D)
                (#xDEA8 . #x6D36)
                (#xDEA9 . #x6D2B)
                (#xDEAA . #x6D3D)
                (#xDEAB . #x6D38)
                (#xDEAC . #x6D19)
                (#xDEAD . #x6D35)
                (#xDEAE . #x6D33)
                (#xDEAF . #x6D12)
                (#xDEB0 . #x6D0C)
                (#xDEB1 . #x6D63)
                (#xDEB2 . #x6D93)
                (#xDEB3 . #x6D64)
                (#xDEB4 . #x6D5A)
                (#xDEB5 . #x6D79)
                (#xDEB6 . #x6D59)
                (#xDEB7 . #x6D8E)
                (#xDEB8 . #x6D95)
                (#xDEB9 . #x6FE4)
                (#xDEBA . #x6D85)
                (#xDEBB . #x6DF9)
                (#xDEBC . #x6E15)
                (#xDEBD . #x6E0A)
                (#xDEBE . #x6DB5)
                (#xDEBF . #x6DC7)
                (#xDEC0 . #x6DE6)
                (#xDEC1 . #x6DB8)
                (#xDEC2 . #x6DC6)
                (#xDEC3 . #x6DEC)
                (#xDEC4 . #x6DDE)
                (#xDEC5 . #x6DCC)
                (#xDEC6 . #x6DE8)
                (#xDEC7 . #x6DD2)
                (#xDEC8 . #x6DC5)
                (#xDEC9 . #x6DFA)
                (#xDECA . #x6DD9)
                (#xDECB . #x6DE4)
                (#xDECC . #x6DD5)
                (#xDECD . #x6DEA)
                (#xDECE . #x6DEE)
                (#xDECF . #x6E2D)
                (#xDED0 . #x6E6E)
                (#xDED1 . #x6E2E)
                (#xDED2 . #x6E19)
                (#xDED3 . #x6E72)
                (#xDED4 . #x6E5F)
                (#xDED5 . #x6E3E)
                (#xDED6 . #x6E23)
                (#xDED7 . #x6E6B)
                (#xDED8 . #x6E2B)
                (#xDED9 . #x6E76)
                (#xDEDA . #x6E4D)
                (#xDEDB . #x6E1F)
                (#xDEDC . #x6E43)
                (#xDEDD . #x6E3A)
                (#xDEDE . #x6E4E)
                (#xDEDF . #x6E24)
                (#xDEE0 . #x6EFF)
                (#xDEE1 . #x6E1D)
                (#xDEE2 . #x6E38)
                (#xDEE3 . #x6E82)
                (#xDEE4 . #x6EAA)
                (#xDEE5 . #x6E98)
                (#xDEE6 . #x6EC9)
                (#xDEE7 . #x6EB7)
                (#xDEE8 . #x6ED3)
                (#xDEE9 . #x6EBD)
                (#xDEEA . #x6EAF)
                (#xDEEB . #x6EC4)
                (#xDEEC . #x6EB2)
                (#xDEED . #x6ED4)
                (#xDEEE . #x6ED5)
                (#xDEEF . #x6E8F)
                (#xDEF0 . #x6EA5)
                (#xDEF1 . #x6EC2)
                (#xDEF2 . #x6E9F)
                (#xDEF3 . #x6F41)
                (#xDEF4 . #x6F11)
                (#xDEF5 . #x704C)
                (#xDEF6 . #x6EEC)
                (#xDEF7 . #x6EF8)
                (#xDEF8 . #x6EFE)
                (#xDEF9 . #x6F3F)
                (#xDEFA . #x6EF2)
                (#xDEFB . #x6F31)
                (#xDEFC . #x6EEF)
                (#xDEFD . #x6F32)
                (#xDEFE . #x6ECC)
                (#xDFA1 . #x6F3E)
                (#xDFA2 . #x6F13)
                (#xDFA3 . #x6EF7)
                (#xDFA4 . #x6F86)
                (#xDFA5 . #x6F7A)
                (#xDFA6 . #x6F78)
                (#xDFA7 . #x6F81)
                (#xDFA8 . #x6F80)
                (#xDFA9 . #x6F6F)
                (#xDFAA . #x6F5B)
                (#xDFAB . #x6FF3)
                (#xDFAC . #x6F6D)
                (#xDFAD . #x6F82)
                (#xDFAE . #x6F7C)
                (#xDFAF . #x6F58)
                (#xDFB0 . #x6F8E)
                (#xDFB1 . #x6F91)
                (#xDFB2 . #x6FC2)
                (#xDFB3 . #x6F66)
                (#xDFB4 . #x6FB3)
                (#xDFB5 . #x6FA3)
                (#xDFB6 . #x6FA1)
                (#xDFB7 . #x6FA4)
                (#xDFB8 . #x6FB9)
                (#xDFB9 . #x6FC6)
                (#xDFBA . #x6FAA)
                (#xDFBB . #x6FDF)
                (#xDFBC . #x6FD5)
                (#xDFBD . #x6FEC)
                (#xDFBE . #x6FD4)
                (#xDFBF . #x6FD8)
                (#xDFC0 . #x6FF1)
                (#xDFC1 . #x6FEE)
                (#xDFC2 . #x6FDB)
                (#xDFC3 . #x7009)
                (#xDFC4 . #x700B)
                (#xDFC5 . #x6FFA)
                (#xDFC6 . #x7011)
                (#xDFC7 . #x7001)
                (#xDFC8 . #x700F)
                (#xDFC9 . #x6FFE)
                (#xDFCA . #x701B)
                (#xDFCB . #x701A)
                (#xDFCC . #x6F74)
                (#xDFCD . #x701D)
                (#xDFCE . #x7018)
                (#xDFCF . #x701F)
                (#xDFD0 . #x7030)
                (#xDFD1 . #x703E)
                (#xDFD2 . #x7032)
                (#xDFD3 . #x7051)
                (#xDFD4 . #x7063)
                (#xDFD5 . #x7099)
                (#xDFD6 . #x7092)
                (#xDFD7 . #x70AF)
                (#xDFD8 . #x70F1)
                (#xDFD9 . #x70AC)
                (#xDFDA . #x70B8)
                (#xDFDB . #x70B3)
                (#xDFDC . #x70AE)
                (#xDFDD . #x70DF)
                (#xDFDE . #x70CB)
                (#xDFDF . #x70DD)
                (#xDFE0 . #x70D9)
                (#xDFE1 . #x7109)
                (#xDFE2 . #x70FD)
                (#xDFE3 . #x711C)
                (#xDFE4 . #x7119)
                (#xDFE5 . #x7165)
                (#xDFE6 . #x7155)
                (#xDFE7 . #x7188)
                (#xDFE8 . #x7166)
                (#xDFE9 . #x7162)
                (#xDFEA . #x714C)
                (#xDFEB . #x7156)
                (#xDFEC . #x716C)
                (#xDFED . #x718F)
                (#xDFEE . #x71FB)
                (#xDFEF . #x7184)
                (#xDFF0 . #x7195)
                (#xDFF1 . #x71A8)
                (#xDFF2 . #x71AC)
                (#xDFF3 . #x71D7)
                (#xDFF4 . #x71B9)
                (#xDFF5 . #x71BE)
                (#xDFF6 . #x71D2)
                (#xDFF7 . #x71C9)
                (#xDFF8 . #x71D4)
                (#xDFF9 . #x71CE)
                (#xDFFA . #x71E0)
                (#xDFFB . #x71EC)
                (#xDFFC . #x71E7)
                (#xDFFD . #x71F5)
                (#xDFFE . #x71FC)
                (#xE0A1 . #x71F9)
                (#xE0A2 . #x71FF)
                (#xE0A3 . #x720D)
                (#xE0A4 . #x7210)
                (#xE0A5 . #x721B)
                (#xE0A6 . #x7228)
                (#xE0A7 . #x722D)
                (#xE0A8 . #x722C)
                (#xE0A9 . #x7230)
                (#xE0AA . #x7232)
                (#xE0AB . #x723B)
                (#xE0AC . #x723C)
                (#xE0AD . #x723F)
                (#xE0AE . #x7240)
                (#xE0AF . #x7246)
                (#xE0B0 . #x724B)
                (#xE0B1 . #x7258)
                (#xE0B2 . #x7274)
                (#xE0B3 . #x727E)
                (#xE0B4 . #x7282)
                (#xE0B5 . #x7281)
                (#xE0B6 . #x7287)
                (#xE0B7 . #x7292)
                (#xE0B8 . #x7296)
                (#xE0B9 . #x72A2)
                (#xE0BA . #x72A7)
                (#xE0BB . #x72B9)
                (#xE0BC . #x72B2)
                (#xE0BD . #x72C3)
                (#xE0BE . #x72C6)
                (#xE0BF . #x72C4)
                (#xE0C0 . #x72CE)
                (#xE0C1 . #x72D2)
                (#xE0C2 . #x72E2)
                (#xE0C3 . #x72E0)
                (#xE0C4 . #x72E1)
                (#xE0C5 . #x72F9)
                (#xE0C6 . #x72F7)
                (#xE0C7 . #x500F)
                (#xE0C8 . #x7317)
                (#xE0C9 . #x730A)
                (#xE0CA . #x731C)
                (#xE0CB . #x7316)
                (#xE0CC . #x731D)
                (#xE0CD . #x7334)
                (#xE0CE . #x732F)
                (#xE0CF . #x7329)
                (#xE0D0 . #x7325)
                (#xE0D1 . #x733E)
                (#xE0D2 . #x734E)
                (#xE0D3 . #x734F)
                (#xE0D4 . #x9ED8)
                (#xE0D5 . #x7357)
                (#xE0D6 . #x736A)
                (#xE0D7 . #x7368)
                (#xE0D8 . #x7370)
                (#xE0D9 . #x7378)
                (#xE0DA . #x7375)
                (#xE0DB . #x737B)
                (#xE0DC . #x737A)
                (#xE0DD . #x73C8)
                (#xE0DE . #x73B3)
                (#xE0DF . #x73CE)
                (#xE0E0 . #x73BB)
                (#xE0E1 . #x73C0)
                (#xE0E2 . #x73E5)
                (#xE0E3 . #x73EE)
                (#xE0E4 . #x73DE)
                (#xE0E5 . #x74A2)
                (#xE0E6 . #x7405)
                (#xE0E7 . #x746F)
                (#xE0E8 . #x7425)
                (#xE0E9 . #x73F8)
                (#xE0EA . #x7432)
                (#xE0EB . #x743A)
                (#xE0EC . #x7455)
                (#xE0ED . #x743F)
                (#xE0EE . #x745F)
                (#xE0EF . #x7459)
                (#xE0F0 . #x7441)
                (#xE0F1 . #x745C)
                (#xE0F2 . #x7469)
                (#xE0F3 . #x7470)
                (#xE0F4 . #x7463)
                (#xE0F5 . #x746A)
                (#xE0F6 . #x7476)
                (#xE0F7 . #x747E)
                (#xE0F8 . #x748B)
                (#xE0F9 . #x749E)
                (#xE0FA . #x74A7)
                (#xE0FB . #x74CA)
                (#xE0FC . #x74CF)
                (#xE0FD . #x74D4)
                (#xE0FE . #x73F1)
                (#xE1A1 . #x74E0)
                (#xE1A2 . #x74E3)
                (#xE1A3 . #x74E7)
                (#xE1A4 . #x74E9)
                (#xE1A5 . #x74EE)
                (#xE1A6 . #x74F2)
                (#xE1A7 . #x74F0)
                (#xE1A8 . #x74F1)
                (#xE1A9 . #x74F8)
                (#xE1AA . #x74F7)
                (#xE1AB . #x7504)
                (#xE1AC . #x7503)
                (#xE1AD . #x7505)
                (#xE1AE . #x750C)
                (#xE1AF . #x750E)
                (#xE1B0 . #x750D)
                (#xE1B1 . #x7515)
                (#xE1B2 . #x7513)
                (#xE1B3 . #x751E)
                (#xE1B4 . #x7526)
                (#xE1B5 . #x752C)
                (#xE1B6 . #x753C)
                (#xE1B7 . #x7544)
                (#xE1B8 . #x754D)
                (#xE1B9 . #x754A)
                (#xE1BA . #x7549)
                (#xE1BB . #x755B)
                (#xE1BC . #x7546)
                (#xE1BD . #x755A)
                (#xE1BE . #x7569)
                (#xE1BF . #x7564)
                (#xE1C0 . #x7567)
                (#xE1C1 . #x756B)
                (#xE1C2 . #x756D)
                (#xE1C3 . #x7578)
                (#xE1C4 . #x7576)
                (#xE1C5 . #x7586)
                (#xE1C6 . #x7587)
                (#xE1C7 . #x7574)
                (#xE1C8 . #x758A)
                (#xE1C9 . #x7589)
                (#xE1CA . #x7582)
                (#xE1CB . #x7594)
                (#xE1CC . #x759A)
                (#xE1CD . #x759D)
                (#xE1CE . #x75A5)
                (#xE1CF . #x75A3)
                (#xE1D0 . #x75C2)
                (#xE1D1 . #x75B3)
                (#xE1D2 . #x75C3)
                (#xE1D3 . #x75B5)
                (#xE1D4 . #x75BD)
                (#xE1D5 . #x75B8)
                (#xE1D6 . #x75BC)
                (#xE1D7 . #x75B1)
                (#xE1D8 . #x75CD)
                (#xE1D9 . #x75CA)
                (#xE1DA . #x75D2)
                (#xE1DB . #x75D9)
                (#xE1DC . #x75E3)
                (#xE1DD . #x75DE)
                (#xE1DE . #x75FE)
                (#xE1DF . #x75FF)
                (#xE1E0 . #x75FC)
                (#xE1E1 . #x7601)
                (#xE1E2 . #x75F0)
                (#xE1E3 . #x75FA)
                (#xE1E4 . #x75F2)
                (#xE1E5 . #x75F3)
                (#xE1E6 . #x760B)
                (#xE1E7 . #x760D)
                (#xE1E8 . #x7609)
                (#xE1E9 . #x761F)
                (#xE1EA . #x7627)
                (#xE1EB . #x7620)
                (#xE1EC . #x7621)
                (#xE1ED . #x7622)
                (#xE1EE . #x7624)
                (#xE1EF . #x7634)
                (#xE1F0 . #x7630)
                (#xE1F1 . #x763B)
                (#xE1F2 . #x7647)
                (#xE1F3 . #x7648)
                (#xE1F4 . #x7646)
                (#xE1F5 . #x765C)
                (#xE1F6 . #x7658)
                (#xE1F7 . #x7661)
                (#xE1F8 . #x7662)
                (#xE1F9 . #x7668)
                (#xE1FA . #x7669)
                (#xE1FB . #x766A)
                (#xE1FC . #x7667)
                (#xE1FD . #x766C)
                (#xE1FE . #x7670)
                (#xE2A1 . #x7672)
                (#xE2A2 . #x7676)
                (#xE2A3 . #x7678)
                (#xE2A4 . #x767C)
                (#xE2A5 . #x7680)
                (#xE2A6 . #x7683)
                (#xE2A7 . #x7688)
                (#xE2A8 . #x768B)
                (#xE2A9 . #x768E)
                (#xE2AA . #x7696)
                (#xE2AB . #x7693)
                (#xE2AC . #x7699)
                (#xE2AD . #x769A)
                (#xE2AE . #x76B0)
                (#xE2AF . #x76B4)
                (#xE2B0 . #x76B8)
                (#xE2B1 . #x76B9)
                (#xE2B2 . #x76BA)
                (#xE2B3 . #x76C2)
                (#xE2B4 . #x76CD)
                (#xE2B5 . #x76D6)
                (#xE2B6 . #x76D2)
                (#xE2B7 . #x76DE)
                (#xE2B8 . #x76E1)
                (#xE2B9 . #x76E5)
                (#xE2BA . #x76E7)
                (#xE2BB . #x76EA)
                (#xE2BC . #x862F)
                (#xE2BD . #x76FB)
                (#xE2BE . #x7708)
                (#xE2BF . #x7707)
                (#xE2C0 . #x7704)
                (#xE2C1 . #x7729)
                (#xE2C2 . #x7724)
                (#xE2C3 . #x771E)
                (#xE2C4 . #x7725)
                (#xE2C5 . #x7726)
                (#xE2C6 . #x771B)
                (#xE2C7 . #x7737)
                (#xE2C8 . #x7738)
                (#xE2C9 . #x7747)
                (#xE2CA . #x775A)
                (#xE2CB . #x7768)
                (#xE2CC . #x776B)
                (#xE2CD . #x775B)
                (#xE2CE . #x7765)
                (#xE2CF . #x777F)
                (#xE2D0 . #x777E)
                (#xE2D1 . #x7779)
                (#xE2D2 . #x778E)
                (#xE2D3 . #x778B)
                (#xE2D4 . #x7791)
                (#xE2D5 . #x77A0)
                (#xE2D6 . #x779E)
                (#xE2D7 . #x77B0)
                (#xE2D8 . #x77B6)
                (#xE2D9 . #x77B9)
                (#xE2DA . #x77BF)
                (#xE2DB . #x77BC)
                (#xE2DC . #x77BD)
                (#xE2DD . #x77BB)
                (#xE2DE . #x77C7)
                (#xE2DF . #x77CD)
                (#xE2E0 . #x77D7)
                (#xE2E1 . #x77DA)
                (#xE2E2 . #x77DC)
                (#xE2E3 . #x77E3)
                (#xE2E4 . #x77EE)
                (#xE2E5 . #x77FC)
                (#xE2E6 . #x780C)
                (#xE2E7 . #x7812)
                (#xE2E8 . #x7926)
                (#xE2E9 . #x7820)
                (#xE2EA . #x792A)
                (#xE2EB . #x7845)
                (#xE2EC . #x788E)
                (#xE2ED . #x7874)
                (#xE2EE . #x7886)
                (#xE2EF . #x787C)
                (#xE2F0 . #x789A)
                (#xE2F1 . #x788C)
                (#xE2F2 . #x78A3)
                (#xE2F3 . #x78B5)
                (#xE2F4 . #x78AA)
                (#xE2F5 . #x78AF)
                (#xE2F6 . #x78D1)
                (#xE2F7 . #x78C6)
                (#xE2F8 . #x78CB)
                (#xE2F9 . #x78D4)
                (#xE2FA . #x78BE)
                (#xE2FB . #x78BC)
                (#xE2FC . #x78C5)
                (#xE2FD . #x78CA)
                (#xE2FE . #x78EC)
                (#xE3A1 . #x78E7)
                (#xE3A2 . #x78DA)
                (#xE3A3 . #x78FD)
                (#xE3A4 . #x78F4)
                (#xE3A5 . #x7907)
                (#xE3A6 . #x7912)
                (#xE3A7 . #x7911)
                (#xE3A8 . #x7919)
                (#xE3A9 . #x792C)
                (#xE3AA . #x792B)
                (#xE3AB . #x7940)
                (#xE3AC . #x7960)
                (#xE3AD . #x7957)
                (#xE3AE . #x795F)
                (#xE3AF . #x795A)
                (#xE3B0 . #x7955)
                (#xE3B1 . #x7953)
                (#xE3B2 . #x797A)
                (#xE3B3 . #x797F)
                (#xE3B4 . #x798A)
                (#xE3B5 . #x799D)
                (#xE3B6 . #x79A7)
                (#xE3B7 . #x9F4B)
                (#xE3B8 . #x79AA)
                (#xE3B9 . #x79AE)
                (#xE3BA . #x79B3)
                (#xE3BB . #x79B9)
                (#xE3BC . #x79BA)
                (#xE3BD . #x79C9)
                (#xE3BE . #x79D5)
                (#xE3BF . #x79E7)
                (#xE3C0 . #x79EC)
                (#xE3C1 . #x79E1)
                (#xE3C2 . #x79E3)
                (#xE3C3 . #x7A08)
                (#xE3C4 . #x7A0D)
                (#xE3C5 . #x7A18)
                (#xE3C6 . #x7A19)
                (#xE3C7 . #x7A20)
                (#xE3C8 . #x7A1F)
                (#xE3C9 . #x7980)
                (#xE3CA . #x7A31)
                (#xE3CB . #x7A3B)
                (#xE3CC . #x7A3E)
                (#xE3CD . #x7A37)
                (#xE3CE . #x7A43)
                (#xE3CF . #x7A57)
                (#xE3D0 . #x7A49)
                (#xE3D1 . #x7A61)
                (#xE3D2 . #x7A62)
                (#xE3D3 . #x7A69)
                (#xE3D4 . #x9F9D)
                (#xE3D5 . #x7A70)
                (#xE3D6 . #x7A79)
                (#xE3D7 . #x7A7D)
                (#xE3D8 . #x7A88)
                (#xE3D9 . #x7A97)
                (#xE3DA . #x7A95)
                (#xE3DB . #x7A98)
                (#xE3DC . #x7A96)
                (#xE3DD . #x7AA9)
                (#xE3DE . #x7AC8)
                (#xE3DF . #x7AB0)
                (#xE3E0 . #x7AB6)
                (#xE3E1 . #x7AC5)
                (#xE3E2 . #x7AC4)
                (#xE3E3 . #x7ABF)
                (#xE3E4 . #x9083)
                (#xE3E5 . #x7AC7)
                (#xE3E6 . #x7ACA)
                (#xE3E7 . #x7ACD)
                (#xE3E8 . #x7ACF)
                (#xE3E9 . #x7AD5)
                (#xE3EA . #x7AD3)
                (#xE3EB . #x7AD9)
                (#xE3EC . #x7ADA)
                (#xE3ED . #x7ADD)
                (#xE3EE . #x7AE1)
                (#xE3EF . #x7AE2)
                (#xE3F0 . #x7AE6)
                (#xE3F1 . #x7AED)
                (#xE3F2 . #x7AF0)
                (#xE3F3 . #x7B02)
                (#xE3F4 . #x7B0F)
                (#xE3F5 . #x7B0A)
                (#xE3F6 . #x7B06)
                (#xE3F7 . #x7B33)
                (#xE3F8 . #x7B18)
                (#xE3F9 . #x7B19)
                (#xE3FA . #x7B1E)
                (#xE3FB . #x7B35)
                (#xE3FC . #x7B28)
                (#xE3FD . #x7B36)
                (#xE3FE . #x7B50)
                (#xE4A1 . #x7B7A)
                (#xE4A2 . #x7B04)
                (#xE4A3 . #x7B4D)
                (#xE4A4 . #x7B0B)
                (#xE4A5 . #x7B4C)
                (#xE4A6 . #x7B45)
                (#xE4A7 . #x7B75)
                (#xE4A8 . #x7B65)
                (#xE4A9 . #x7B74)
                (#xE4AA . #x7B67)
                (#xE4AB . #x7B70)
                (#xE4AC . #x7B71)
                (#xE4AD . #x7B6C)
                (#xE4AE . #x7B6E)
                (#xE4AF . #x7B9D)
                (#xE4B0 . #x7B98)
                (#xE4B1 . #x7B9F)
                (#xE4B2 . #x7B8D)
                (#xE4B3 . #x7B9C)
                (#xE4B4 . #x7B9A)
                (#xE4B5 . #x7B8B)
                (#xE4B6 . #x7B92)
                (#xE4B7 . #x7B8F)
                (#xE4B8 . #x7B5D)
                (#xE4B9 . #x7B99)
                (#xE4BA . #x7BCB)
                (#xE4BB . #x7BC1)
                (#xE4BC . #x7BCC)
                (#xE4BD . #x7BCF)
                (#xE4BE . #x7BB4)
                (#xE4BF . #x7BC6)
                (#xE4C0 . #x7BDD)
                (#xE4C1 . #x7BE9)
                (#xE4C2 . #x7C11)
                (#xE4C3 . #x7C14)
                (#xE4C4 . #x7BE6)
                (#xE4C5 . #x7BE5)
                (#xE4C6 . #x7C60)
                (#xE4C7 . #x7C00)
                (#xE4C8 . #x7C07)
                (#xE4C9 . #x7C13)
                (#xE4CA . #x7BF3)
                (#xE4CB . #x7BF7)
                (#xE4CC . #x7C17)
                (#xE4CD . #x7C0D)
                (#xE4CE . #x7BF6)
                (#xE4CF . #x7C23)
                (#xE4D0 . #x7C27)
                (#xE4D1 . #x7C2A)
                (#xE4D2 . #x7C1F)
                (#xE4D3 . #x7C37)
                (#xE4D4 . #x7C2B)
                (#xE4D5 . #x7C3D)
                (#xE4D6 . #x7C4C)
                (#xE4D7 . #x7C43)
                (#xE4D8 . #x7C54)
                (#xE4D9 . #x7C4F)
                (#xE4DA . #x7C40)
                (#xE4DB . #x7C50)
                (#xE4DC . #x7C58)
                (#xE4DD . #x7C5F)
                (#xE4DE . #x7C64)
                (#xE4DF . #x7C56)
                (#xE4E0 . #x7C65)
                (#xE4E1 . #x7C6C)
                (#xE4E2 . #x7C75)
                (#xE4E3 . #x7C83)
                (#xE4E4 . #x7C90)
                (#xE4E5 . #x7CA4)
                (#xE4E6 . #x7CAD)
                (#xE4E7 . #x7CA2)
                (#xE4E8 . #x7CAB)
                (#xE4E9 . #x7CA1)
                (#xE4EA . #x7CA8)
                (#xE4EB . #x7CB3)
                (#xE4EC . #x7CB2)
                (#xE4ED . #x7CB1)
                (#xE4EE . #x7CAE)
                (#xE4EF . #x7CB9)
                (#xE4F0 . #x7CBD)
                (#xE4F1 . #x7CC0)
                (#xE4F2 . #x7CC5)
                (#xE4F3 . #x7CC2)
                (#xE4F4 . #x7CD8)
                (#xE4F5 . #x7CD2)
                (#xE4F6 . #x7CDC)
                (#xE4F7 . #x7CE2)
                (#xE4F8 . #x9B3B)
                (#xE4F9 . #x7CEF)
                (#xE4FA . #x7CF2)
                (#xE4FB . #x7CF4)
                (#xE4FC . #x7CF6)
                (#xE4FD . #x7CFA)
                (#xE4FE . #x7D06)
                (#xE5A1 . #x7D02)
                (#xE5A2 . #x7D1C)
                (#xE5A3 . #x7D15)
                (#xE5A4 . #x7D0A)
                (#xE5A5 . #x7D45)
                (#xE5A6 . #x7D4B)
                (#xE5A7 . #x7D2E)
                (#xE5A8 . #x7D32)
                (#xE5A9 . #x7D3F)
                (#xE5AA . #x7D35)
                (#xE5AB . #x7D46)
                (#xE5AC . #x7D73)
                (#xE5AD . #x7D56)
                (#xE5AE . #x7D4E)
                (#xE5AF . #x7D72)
                (#xE5B0 . #x7D68)
                (#xE5B1 . #x7D6E)
                (#xE5B2 . #x7D4F)
                (#xE5B3 . #x7D63)
                (#xE5B4 . #x7D93)
                (#xE5B5 . #x7D89)
                (#xE5B6 . #x7D5B)
                (#xE5B7 . #x7D8F)
                (#xE5B8 . #x7D7D)
                (#xE5B9 . #x7D9B)
                (#xE5BA . #x7DBA)
                (#xE5BB . #x7DAE)
                (#xE5BC . #x7DA3)
                (#xE5BD . #x7DB5)
                (#xE5BE . #x7DC7)
                (#xE5BF . #x7DBD)
                (#xE5C0 . #x7DAB)
                (#xE5C1 . #x7E3D)
                (#xE5C2 . #x7DA2)
                (#xE5C3 . #x7DAF)
                (#xE5C4 . #x7DDC)
                (#xE5C5 . #x7DB8)
                (#xE5C6 . #x7D9F)
                (#xE5C7 . #x7DB0)
                (#xE5C8 . #x7DD8)
                (#xE5C9 . #x7DDD)
                (#xE5CA . #x7DE4)
                (#xE5CB . #x7DDE)
                (#xE5CC . #x7DFB)
                (#xE5CD . #x7DF2)
                (#xE5CE . #x7DE1)
                (#xE5CF . #x7E05)
                (#xE5D0 . #x7E0A)
                (#xE5D1 . #x7E23)
                (#xE5D2 . #x7E21)
                (#xE5D3 . #x7E12)
                (#xE5D4 . #x7E31)
                (#xE5D5 . #x7E1F)
                (#xE5D6 . #x7E09)
                (#xE5D7 . #x7E0B)
                (#xE5D8 . #x7E22)
                (#xE5D9 . #x7E46)
                (#xE5DA . #x7E66)
                (#xE5DB . #x7E3B)
                (#xE5DC . #x7E35)
                (#xE5DD . #x7E39)
                (#xE5DE . #x7E43)
                (#xE5DF . #x7E37)
                (#xE5E0 . #x7E32)
                (#xE5E1 . #x7E3A)
                (#xE5E2 . #x7E67)
                (#xE5E3 . #x7E5D)
                (#xE5E4 . #x7E56)
                (#xE5E5 . #x7E5E)
                (#xE5E6 . #x7E59)
                (#xE5E7 . #x7E5A)
                (#xE5E8 . #x7E79)
                (#xE5E9 . #x7E6A)
                (#xE5EA . #x7E69)
                (#xE5EB . #x7E7C)
                (#xE5EC . #x7E7B)
                (#xE5ED . #x7E83)
                (#xE5EE . #x7DD5)
                (#xE5EF . #x7E7D)
                (#xE5F0 . #x8FAE)
                (#xE5F1 . #x7E7F)
                (#xE5F2 . #x7E88)
                (#xE5F3 . #x7E89)
                (#xE5F4 . #x7E8C)
                (#xE5F5 . #x7E92)
                (#xE5F6 . #x7E90)
                (#xE5F7 . #x7E93)
                (#xE5F8 . #x7E94)
                (#xE5F9 . #x7E96)
                (#xE5FA . #x7E8E)
                (#xE5FB . #x7E9B)
                (#xE5FC . #x7E9C)
                (#xE5FD . #x7F38)
                (#xE5FE . #x7F3A)
                (#xE6A1 . #x7F45)
                (#xE6A2 . #x7F4C)
                (#xE6A3 . #x7F4D)
                (#xE6A4 . #x7F4E)
                (#xE6A5 . #x7F50)
                (#xE6A6 . #x7F51)
                (#xE6A7 . #x7F55)
                (#xE6A8 . #x7F54)
                (#xE6A9 . #x7F58)
                (#xE6AA . #x7F5F)
                (#xE6AB . #x7F60)
                (#xE6AC . #x7F68)
                (#xE6AD . #x7F69)
                (#xE6AE . #x7F67)
                (#xE6AF . #x7F78)
                (#xE6B0 . #x7F82)
                (#xE6B1 . #x7F86)
                (#xE6B2 . #x7F83)
                (#xE6B3 . #x7F88)
                (#xE6B4 . #x7F87)
                (#xE6B5 . #x7F8C)
                (#xE6B6 . #x7F94)
                (#xE6B7 . #x7F9E)
                (#xE6B8 . #x7F9D)
                (#xE6B9 . #x7F9A)
                (#xE6BA . #x7FA3)
                (#xE6BB . #x7FAF)
                (#xE6BC . #x7FB2)
                (#xE6BD . #x7FB9)
                (#xE6BE . #x7FAE)
                (#xE6BF . #x7FB6)
                (#xE6C0 . #x7FB8)
                (#xE6C1 . #x8B71)
                (#xE6C2 . #x7FC5)
                (#xE6C3 . #x7FC6)
                (#xE6C4 . #x7FCA)
                (#xE6C5 . #x7FD5)
                (#xE6C6 . #x7FD4)
                (#xE6C7 . #x7FE1)
                (#xE6C8 . #x7FE6)
                (#xE6C9 . #x7FE9)
                (#xE6CA . #x7FF3)
                (#xE6CB . #x7FF9)
                (#xE6CC . #x98DC)
                (#xE6CD . #x8006)
                (#xE6CE . #x8004)
                (#xE6CF . #x800B)
                (#xE6D0 . #x8012)
                (#xE6D1 . #x8018)
                (#xE6D2 . #x8019)
                (#xE6D3 . #x801C)
                (#xE6D4 . #x8021)
                (#xE6D5 . #x8028)
                (#xE6D6 . #x803F)
                (#xE6D7 . #x803B)
                (#xE6D8 . #x804A)
                (#xE6D9 . #x8046)
                (#xE6DA . #x8052)
                (#xE6DB . #x8058)
                (#xE6DC . #x805A)
                (#xE6DD . #x805F)
                (#xE6DE . #x8062)
                (#xE6DF . #x8068)
                (#xE6E0 . #x8073)
                (#xE6E1 . #x8072)
                (#xE6E2 . #x8070)
                (#xE6E3 . #x8076)
                (#xE6E4 . #x8079)
                (#xE6E5 . #x807D)
                (#xE6E6 . #x807F)
                (#xE6E7 . #x8084)
                (#xE6E8 . #x8086)
                (#xE6E9 . #x8085)
                (#xE6EA . #x809B)
                (#xE6EB . #x8093)
                (#xE6EC . #x809A)
                (#xE6ED . #x80AD)
                (#xE6EE . #x5190)
                (#xE6EF . #x80AC)
                (#xE6F0 . #x80DB)
                (#xE6F1 . #x80E5)
                (#xE6F2 . #x80D9)
                (#xE6F3 . #x80DD)
                (#xE6F4 . #x80C4)
                (#xE6F5 . #x80DA)
                (#xE6F6 . #x80D6)
                (#xE6F7 . #x8109)
                (#xE6F8 . #x80EF)
                (#xE6F9 . #x80F1)
                (#xE6FA . #x811B)
                (#xE6FB . #x8129)
                (#xE6FC . #x8123)
                (#xE6FD . #x812F)
                (#xE6FE . #x814B)
                (#xE7A1 . #x968B)
                (#xE7A2 . #x8146)
                (#xE7A3 . #x813E)
                (#xE7A4 . #x8153)
                (#xE7A5 . #x8151)
                (#xE7A6 . #x80FC)
                (#xE7A7 . #x8171)
                (#xE7A8 . #x816E)
                (#xE7A9 . #x8165)
                (#xE7AA . #x8166)
                (#xE7AB . #x8174)
                (#xE7AC . #x8183)
                (#xE7AD . #x8188)
                (#xE7AE . #x818A)
                (#xE7AF . #x8180)
                (#xE7B0 . #x8182)
                (#xE7B1 . #x81A0)
                (#xE7B2 . #x8195)
                (#xE7B3 . #x81A4)
                (#xE7B4 . #x81A3)
                (#xE7B5 . #x815F)
                (#xE7B6 . #x8193)
                (#xE7B7 . #x81A9)
                (#xE7B8 . #x81B0)
                (#xE7B9 . #x81B5)
                (#xE7BA . #x81BE)
                (#xE7BB . #x81B8)
                (#xE7BC . #x81BD)
                (#xE7BD . #x81C0)
                (#xE7BE . #x81C2)
                (#xE7BF . #x81BA)
                (#xE7C0 . #x81C9)
                (#xE7C1 . #x81CD)
                (#xE7C2 . #x81D1)
                (#xE7C3 . #x81D9)
                (#xE7C4 . #x81D8)
                (#xE7C5 . #x81C8)
                (#xE7C6 . #x81DA)
                (#xE7C7 . #x81DF)
                (#xE7C8 . #x81E0)
                (#xE7C9 . #x81E7)
                (#xE7CA . #x81FA)
                (#xE7CB . #x81FB)
                (#xE7CC . #x81FE)
                (#xE7CD . #x8201)
                (#xE7CE . #x8202)
                (#xE7CF . #x8205)
                (#xE7D0 . #x8207)
                (#xE7D1 . #x820A)
                (#xE7D2 . #x820D)
                (#xE7D3 . #x8210)
                (#xE7D4 . #x8216)
                (#xE7D5 . #x8229)
                (#xE7D6 . #x822B)
                (#xE7D7 . #x8238)
                (#xE7D8 . #x8233)
                (#xE7D9 . #x8240)
                (#xE7DA . #x8259)
                (#xE7DB . #x8258)
                (#xE7DC . #x825D)
                (#xE7DD . #x825A)
                (#xE7DE . #x825F)
                (#xE7DF . #x8264)
                (#xE7E0 . #x8262)
                (#xE7E1 . #x8268)
                (#xE7E2 . #x826A)
                (#xE7E3 . #x826B)
                (#xE7E4 . #x822E)
                (#xE7E5 . #x8271)
                (#xE7E6 . #x8277)
                (#xE7E7 . #x8278)
                (#xE7E8 . #x827E)
                (#xE7E9 . #x828D)
                (#xE7EA . #x8292)
                (#xE7EB . #x82AB)
                (#xE7EC . #x829F)
                (#xE7ED . #x82BB)
                (#xE7EE . #x82AC)
                (#xE7EF . #x82E1)
                (#xE7F0 . #x82E3)
                (#xE7F1 . #x82DF)
                (#xE7F2 . #x82D2)
                (#xE7F3 . #x82F4)
                (#xE7F4 . #x82F3)
                (#xE7F5 . #x82FA)
                (#xE7F6 . #x8393)
                (#xE7F7 . #x8303)
                (#xE7F8 . #x82FB)
                (#xE7F9 . #x82F9)
                (#xE7FA . #x82DE)
                (#xE7FB . #x8306)
                (#xE7FC . #x82DC)
                (#xE7FD . #x8309)
                (#xE7FE . #x82D9)
                (#xE8A1 . #x8335)
                (#xE8A2 . #x8334)
                (#xE8A3 . #x8316)
                (#xE8A4 . #x8332)
                (#xE8A5 . #x8331)
                (#xE8A6 . #x8340)
                (#xE8A7 . #x8339)
                (#xE8A8 . #x8350)
                (#xE8A9 . #x8345)
                (#xE8AA . #x832F)
                (#xE8AB . #x832B)
                (#xE8AC . #x8317)
                (#xE8AD . #x8318)
                (#xE8AE . #x8385)
                (#xE8AF . #x839A)
                (#xE8B0 . #x83AA)
                (#xE8B1 . #x839F)
                (#xE8B2 . #x83A2)
                (#xE8B3 . #x8396)
                (#xE8B4 . #x8323)
                (#xE8B5 . #x838E)
                (#xE8B6 . #x8387)
                (#xE8B7 . #x838A)
                (#xE8B8 . #x837C)
                (#xE8B9 . #x83B5)
                (#xE8BA . #x8373)
                (#xE8BB . #x8375)
                (#xE8BC . #x83A0)
                (#xE8BD . #x8389)
                (#xE8BE . #x83A8)
                (#xE8BF . #x83F4)
                (#xE8C0 . #x8413)
                (#xE8C1 . #x83EB)
                (#xE8C2 . #x83CE)
                (#xE8C3 . #x83FD)
                (#xE8C4 . #x8403)
                (#xE8C5 . #x83D8)
                (#xE8C6 . #x840B)
                (#xE8C7 . #x83C1)
                (#xE8C8 . #x83F7)
                (#xE8C9 . #x8407)
                (#xE8CA . #x83E0)
                (#xE8CB . #x83F2)
                (#xE8CC . #x840D)
                (#xE8CD . #x8422)
                (#xE8CE . #x8420)
                (#xE8CF . #x83BD)
                (#xE8D0 . #x8438)
                (#xE8D1 . #x8506)
                (#xE8D2 . #x83FB)
                (#xE8D3 . #x846D)
                (#xE8D4 . #x842A)
                (#xE8D5 . #x843C)
                (#xE8D6 . #x855A)
                (#xE8D7 . #x8484)
                (#xE8D8 . #x8477)
                (#xE8D9 . #x846B)
                (#xE8DA . #x84AD)
                (#xE8DB . #x846E)
                (#xE8DC . #x8482)
                (#xE8DD . #x8469)
                (#xE8DE . #x8446)
                (#xE8DF . #x842C)
                (#xE8E0 . #x846F)
                (#xE8E1 . #x8479)
                (#xE8E2 . #x8435)
                (#xE8E3 . #x84CA)
                (#xE8E4 . #x8462)
                (#xE8E5 . #x84B9)
                (#xE8E6 . #x84BF)
                (#xE8E7 . #x849F)
                (#xE8E8 . #x84D9)
                (#xE8E9 . #x84CD)
                (#xE8EA . #x84BB)
                (#xE8EB . #x84DA)
                (#xE8EC . #x84D0)
                (#xE8ED . #x84C1)
                (#xE8EE . #x84C6)
                (#xE8EF . #x84D6)
                (#xE8F0 . #x84A1)
                (#xE8F1 . #x8521)
                (#xE8F2 . #x84FF)
                (#xE8F3 . #x84F4)
                (#xE8F4 . #x8517)
                (#xE8F5 . #x8518)
                (#xE8F6 . #x852C)
                (#xE8F7 . #x851F)
                (#xE8F8 . #x8515)
                (#xE8F9 . #x8514)
                (#xE8FA . #x84FC)
                (#xE8FB . #x8540)
                (#xE8FC . #x8563)
                (#xE8FD . #x8558)
                (#xE8FE . #x8548)
                (#xE9A1 . #x8541)
                (#xE9A2 . #x8602)
                (#xE9A3 . #x854B)
                (#xE9A4 . #x8555)
                (#xE9A5 . #x8580)
                (#xE9A6 . #x85A4)
                (#xE9A7 . #x8588)
                (#xE9A8 . #x8591)
                (#xE9A9 . #x858A)
                (#xE9AA . #x85A8)
                (#xE9AB . #x856D)
                (#xE9AC . #x8594)
                (#xE9AD . #x859B)
                (#xE9AE . #x85EA)
                (#xE9AF . #x8587)
                (#xE9B0 . #x859C)
                (#xE9B1 . #x8577)
                (#xE9B2 . #x857E)
                (#xE9B3 . #x8590)
                (#xE9B4 . #x85C9)
                (#xE9B5 . #x85BA)
                (#xE9B6 . #x85CF)
                (#xE9B7 . #x85B9)
                (#xE9B8 . #x85D0)
                (#xE9B9 . #x85D5)
                (#xE9BA . #x85DD)
                (#xE9BB . #x85E5)
                (#xE9BC . #x85DC)
                (#xE9BD . #x85F9)
                (#xE9BE . #x860A)
                (#xE9BF . #x8613)
                (#xE9C0 . #x860B)
                (#xE9C1 . #x85FE)
                (#xE9C2 . #x85FA)
                (#xE9C3 . #x8606)
                (#xE9C4 . #x8622)
                (#xE9C5 . #x861A)
                (#xE9C6 . #x8630)
                (#xE9C7 . #x863F)
                (#xE9C8 . #x864D)
                (#xE9C9 . #x4E55)
                (#xE9CA . #x8654)
                (#xE9CB . #x865F)
                (#xE9CC . #x8667)
                (#xE9CD . #x8671)
                (#xE9CE . #x8693)
                (#xE9CF . #x86A3)
                (#xE9D0 . #x86A9)
                (#xE9D1 . #x86AA)
                (#xE9D2 . #x868B)
                (#xE9D3 . #x868C)
                (#xE9D4 . #x86B6)
                (#xE9D5 . #x86AF)
                (#xE9D6 . #x86C4)
                (#xE9D7 . #x86C6)
                (#xE9D8 . #x86B0)
                (#xE9D9 . #x86C9)
                (#xE9DA . #x8823)
                (#xE9DB . #x86AB)
                (#xE9DC . #x86D4)
                (#xE9DD . #x86DE)
                (#xE9DE . #x86E9)
                (#xE9DF . #x86EC)
                (#xE9E0 . #x86DF)
                (#xE9E1 . #x86DB)
                (#xE9E2 . #x86EF)
                (#xE9E3 . #x8712)
                (#xE9E4 . #x8706)
                (#xE9E5 . #x8708)
                (#xE9E6 . #x8700)
                (#xE9E7 . #x8703)
                (#xE9E8 . #x86FB)
                (#xE9E9 . #x8711)
                (#xE9EA . #x8709)
                (#xE9EB . #x870D)
                (#xE9EC . #x86F9)
                (#xE9ED . #x870A)
                (#xE9EE . #x8734)
                (#xE9EF . #x873F)
                (#xE9F0 . #x8737)
                (#xE9F1 . #x873B)
                (#xE9F2 . #x8725)
                (#xE9F3 . #x8729)
                (#xE9F4 . #x871A)
                (#xE9F5 . #x8760)
                (#xE9F6 . #x875F)
                (#xE9F7 . #x8778)
                (#xE9F8 . #x874C)
                (#xE9F9 . #x874E)
                (#xE9FA . #x8774)
                (#xE9FB . #x8757)
                (#xE9FC . #x8768)
                (#xE9FD . #x876E)
                (#xE9FE . #x8759)
                (#xEAA1 . #x8753)
                (#xEAA2 . #x8763)
                (#xEAA3 . #x876A)
                (#xEAA4 . #x8805)
                (#xEAA5 . #x87A2)
                (#xEAA6 . #x879F)
                (#xEAA7 . #x8782)
                (#xEAA8 . #x87AF)
                (#xEAA9 . #x87CB)
                (#xEAAA . #x87BD)
                (#xEAAB . #x87C0)
                (#xEAAC . #x87D0)
                (#xEAAD . #x96D6)
                (#xEAAE . #x87AB)
                (#xEAAF . #x87C4)
                (#xEAB0 . #x87B3)
                (#xEAB1 . #x87C7)
                (#xEAB2 . #x87C6)
                (#xEAB3 . #x87BB)
                (#xEAB4 . #x87EF)
                (#xEAB5 . #x87F2)
                (#xEAB6 . #x87E0)
                (#xEAB7 . #x880F)
                (#xEAB8 . #x880D)
                (#xEAB9 . #x87FE)
                (#xEABA . #x87F6)
                (#xEABB . #x87F7)
                (#xEABC . #x880E)
                (#xEABD . #x87D2)
                (#xEABE . #x8811)
                (#xEABF . #x8816)
                (#xEAC0 . #x8815)
                (#xEAC1 . #x8822)
                (#xEAC2 . #x8821)
                (#xEAC3 . #x8831)
                (#xEAC4 . #x8836)
                (#xEAC5 . #x8839)
                (#xEAC6 . #x8827)
                (#xEAC7 . #x883B)
                (#xEAC8 . #x8844)
                (#xEAC9 . #x8842)
                (#xEACA . #x8852)
                (#xEACB . #x8859)
                (#xEACC . #x885E)
                (#xEACD . #x8862)
                (#xEACE . #x886B)
                (#xEACF . #x8881)
                (#xEAD0 . #x887E)
                (#xEAD1 . #x889E)
                (#xEAD2 . #x8875)
                (#xEAD3 . #x887D)
                (#xEAD4 . #x88B5)
                (#xEAD5 . #x8872)
                (#xEAD6 . #x8882)
                (#xEAD7 . #x8897)
                (#xEAD8 . #x8892)
                (#xEAD9 . #x88AE)
                (#xEADA . #x8899)
                (#xEADB . #x88A2)
                (#xEADC . #x888D)
                (#xEADD . #x88A4)
                (#xEADE . #x88B0)
                (#xEADF . #x88BF)
                (#xEAE0 . #x88B1)
                (#xEAE1 . #x88C3)
                (#xEAE2 . #x88C4)
                (#xEAE3 . #x88D4)
                (#xEAE4 . #x88D8)
                (#xEAE5 . #x88D9)
                (#xEAE6 . #x88DD)
                (#xEAE7 . #x88F9)
                (#xEAE8 . #x8902)
                (#xEAE9 . #x88FC)
                (#xEAEA . #x88F4)
                (#xEAEB . #x88E8)
                (#xEAEC . #x88F2)
                (#xEAED . #x8904)
                (#xEAEE . #x890C)
                (#xEAEF . #x890A)
                (#xEAF0 . #x8913)
                (#xEAF1 . #x8943)
                (#xEAF2 . #x891E)
                (#xEAF3 . #x8925)
                (#xEAF4 . #x892A)
                (#xEAF5 . #x892B)
                (#xEAF6 . #x8941)
                (#xEAF7 . #x8944)
                (#xEAF8 . #x893B)
                (#xEAF9 . #x8936)
                (#xEAFA . #x8938)
                (#xEAFB . #x894C)
                (#xEAFC . #x891D)
                (#xEAFD . #x8960)
                (#xEAFE . #x895E)
                (#xEBA1 . #x8966)
                (#xEBA2 . #x8964)
                (#xEBA3 . #x896D)
                (#xEBA4 . #x896A)
                (#xEBA5 . #x896F)
                (#xEBA6 . #x8974)
                (#xEBA7 . #x8977)
                (#xEBA8 . #x897E)
                (#xEBA9 . #x8983)
                (#xEBAA . #x8988)
                (#xEBAB . #x898A)
                (#xEBAC . #x8993)
                (#xEBAD . #x8998)
                (#xEBAE . #x89A1)
                (#xEBAF . #x89A9)
                (#xEBB0 . #x89A6)
                (#xEBB1 . #x89AC)
                (#xEBB2 . #x89AF)
                (#xEBB3 . #x89B2)
                (#xEBB4 . #x89BA)
                (#xEBB5 . #x89BD)
                (#xEBB6 . #x89BF)
                (#xEBB7 . #x89C0)
                (#xEBB8 . #x89DA)
                (#xEBB9 . #x89DC)
                (#xEBBA . #x89DD)
                (#xEBBB . #x89E7)
                (#xEBBC . #x89F4)
                (#xEBBD . #x89F8)
                (#xEBBE . #x8A03)
                (#xEBBF . #x8A16)
                (#xEBC0 . #x8A10)
                (#xEBC1 . #x8A0C)
                (#xEBC2 . #x8A1B)
                (#xEBC3 . #x8A1D)
                (#xEBC4 . #x8A25)
                (#xEBC5 . #x8A36)
                (#xEBC6 . #x8A41)
                (#xEBC7 . #x8A5B)
                (#xEBC8 . #x8A52)
                (#xEBC9 . #x8A46)
                (#xEBCA . #x8A48)
                (#xEBCB . #x8A7C)
                (#xEBCC . #x8A6D)
                (#xEBCD . #x8A6C)
                (#xEBCE . #x8A62)
                (#xEBCF . #x8A85)
                (#xEBD0 . #x8A82)
                (#xEBD1 . #x8A84)
                (#xEBD2 . #x8AA8)
                (#xEBD3 . #x8AA1)
                (#xEBD4 . #x8A91)
                (#xEBD5 . #x8AA5)
                (#xEBD6 . #x8AA6)
                (#xEBD7 . #x8A9A)
                (#xEBD8 . #x8AA3)
                (#xEBD9 . #x8AC4)
                (#xEBDA . #x8ACD)
                (#xEBDB . #x8AC2)
                (#xEBDC . #x8ADA)
                (#xEBDD . #x8AEB)
                (#xEBDE . #x8AF3)
                (#xEBDF . #x8AE7)
                (#xEBE0 . #x8AE4)
                (#xEBE1 . #x8AF1)
                (#xEBE2 . #x8B14)
                (#xEBE3 . #x8AE0)
                (#xEBE4 . #x8AE2)
                (#xEBE5 . #x8AF7)
                (#xEBE6 . #x8ADE)
                (#xEBE7 . #x8ADB)
                (#xEBE8 . #x8B0C)
                (#xEBE9 . #x8B07)
                (#xEBEA . #x8B1A)
                (#xEBEB . #x8AE1)
                (#xEBEC . #x8B16)
                (#xEBED . #x8B10)
                (#xEBEE . #x8B17)
                (#xEBEF . #x8B20)
                (#xEBF0 . #x8B33)
                (#xEBF1 . #x97AB)
                (#xEBF2 . #x8B26)
                (#xEBF3 . #x8B2B)
                (#xEBF4 . #x8B3E)
                (#xEBF5 . #x8B28)
                (#xEBF6 . #x8B41)
                (#xEBF7 . #x8B4C)
                (#xEBF8 . #x8B4F)
                (#xEBF9 . #x8B4E)
                (#xEBFA . #x8B49)
                (#xEBFB . #x8B56)
                (#xEBFC . #x8B5B)
                (#xEBFD . #x8B5A)
                (#xEBFE . #x8B6B)
                (#xECA1 . #x8B5F)
                (#xECA2 . #x8B6C)
                (#xECA3 . #x8B6F)
                (#xECA4 . #x8B74)
                (#xECA5 . #x8B7D)
                (#xECA6 . #x8B80)
                (#xECA7 . #x8B8C)
                (#xECA8 . #x8B8E)
                (#xECA9 . #x8B92)
                (#xECAA . #x8B93)
                (#xECAB . #x8B96)
                (#xECAC . #x8B99)
                (#xECAD . #x8B9A)
                (#xECAE . #x8C3A)
                (#xECAF . #x8C41)
                (#xECB0 . #x8C3F)
                (#xECB1 . #x8C48)
                (#xECB2 . #x8C4C)
                (#xECB3 . #x8C4E)
                (#xECB4 . #x8C50)
                (#xECB5 . #x8C55)
                (#xECB6 . #x8C62)
                (#xECB7 . #x8C6C)
                (#xECB8 . #x8C78)
                (#xECB9 . #x8C7A)
                (#xECBA . #x8C82)
                (#xECBB . #x8C89)
                (#xECBC . #x8C85)
                (#xECBD . #x8C8A)
                (#xECBE . #x8C8D)
                (#xECBF . #x8C8E)
                (#xECC0 . #x8C94)
                (#xECC1 . #x8C7C)
                (#xECC2 . #x8C98)
                (#xECC3 . #x621D)
                (#xECC4 . #x8CAD)
                (#xECC5 . #x8CAA)
                (#xECC6 . #x8CBD)
                (#xECC7 . #x8CB2)
                (#xECC8 . #x8CB3)
                (#xECC9 . #x8CAE)
                (#xECCA . #x8CB6)
                (#xECCB . #x8CC8)
                (#xECCC . #x8CC1)
                (#xECCD . #x8CE4)
                (#xECCE . #x8CE3)
                (#xECCF . #x8CDA)
                (#xECD0 . #x8CFD)
                (#xECD1 . #x8CFA)
                (#xECD2 . #x8CFB)
                (#xECD3 . #x8D04)
                (#xECD4 . #x8D05)
                (#xECD5 . #x8D0A)
                (#xECD6 . #x8D07)
                (#xECD7 . #x8D0F)
                (#xECD8 . #x8D0D)
                (#xECD9 . #x8D10)
                (#xECDA . #x9F4E)
                (#xECDB . #x8D13)
                (#xECDC . #x8CCD)
                (#xECDD . #x8D14)
                (#xECDE . #x8D16)
                (#xECDF . #x8D67)
                (#xECE0 . #x8D6D)
                (#xECE1 . #x8D71)
                (#xECE2 . #x8D73)
                (#xECE3 . #x8D81)
                (#xECE4 . #x8D99)
                (#xECE5 . #x8DC2)
                (#xECE6 . #x8DBE)
                (#xECE7 . #x8DBA)
                (#xECE8 . #x8DCF)
                (#xECE9 . #x8DDA)
                (#xECEA . #x8DD6)
                (#xECEB . #x8DCC)
                (#xECEC . #x8DDB)
                (#xECED . #x8DCB)
                (#xECEE . #x8DEA)
                (#xECEF . #x8DEB)
                (#xECF0 . #x8DDF)
                (#xECF1 . #x8DE3)
                (#xECF2 . #x8DFC)
                (#xECF3 . #x8E08)
                (#xECF4 . #x8E09)
                (#xECF5 . #x8DFF)
                (#xECF6 . #x8E1D)
                (#xECF7 . #x8E1E)
                (#xECF8 . #x8E10)
                (#xECF9 . #x8E1F)
                (#xECFA . #x8E42)
                (#xECFB . #x8E35)
                (#xECFC . #x8E30)
                (#xECFD . #x8E34)
                (#xECFE . #x8E4A)
                (#xEDA1 . #x8E47)
                (#xEDA2 . #x8E49)
                (#xEDA3 . #x8E4C)
                (#xEDA4 . #x8E50)
                (#xEDA5 . #x8E48)
                (#xEDA6 . #x8E59)
                (#xEDA7 . #x8E64)
                (#xEDA8 . #x8E60)
                (#xEDA9 . #x8E2A)
                (#xEDAA . #x8E63)
                (#xEDAB . #x8E55)
                (#xEDAC . #x8E76)
                (#xEDAD . #x8E72)
                (#xEDAE . #x8E7C)
                (#xEDAF . #x8E81)
                (#xEDB0 . #x8E87)
                (#xEDB1 . #x8E85)
                (#xEDB2 . #x8E84)
                (#xEDB3 . #x8E8B)
                (#xEDB4 . #x8E8A)
                (#xEDB5 . #x8E93)
                (#xEDB6 . #x8E91)
                (#xEDB7 . #x8E94)
                (#xEDB8 . #x8E99)
                (#xEDB9 . #x8EAA)
                (#xEDBA . #x8EA1)
                (#xEDBB . #x8EAC)
                (#xEDBC . #x8EB0)
                (#xEDBD . #x8EC6)
                (#xEDBE . #x8EB1)
                (#xEDBF . #x8EBE)
                (#xEDC0 . #x8EC5)
                (#xEDC1 . #x8EC8)
                (#xEDC2 . #x8ECB)
                (#xEDC3 . #x8EDB)
                (#xEDC4 . #x8EE3)
                (#xEDC5 . #x8EFC)
                (#xEDC6 . #x8EFB)
                (#xEDC7 . #x8EEB)
                (#xEDC8 . #x8EFE)
                (#xEDC9 . #x8F0A)
                (#xEDCA . #x8F05)
                (#xEDCB . #x8F15)
                (#xEDCC . #x8F12)
                (#xEDCD . #x8F19)
                (#xEDCE . #x8F13)
                (#xEDCF . #x8F1C)
                (#xEDD0 . #x8F1F)
                (#xEDD1 . #x8F1B)
                (#xEDD2 . #x8F0C)
                (#xEDD3 . #x8F26)
                (#xEDD4 . #x8F33)
                (#xEDD5 . #x8F3B)
                (#xEDD6 . #x8F39)
                (#xEDD7 . #x8F45)
                (#xEDD8 . #x8F42)
                (#xEDD9 . #x8F3E)
                (#xEDDA . #x8F4C)
                (#xEDDB . #x8F49)
                (#xEDDC . #x8F46)
                (#xEDDD . #x8F4E)
                (#xEDDE . #x8F57)
                (#xEDDF . #x8F5C)
                (#xEDE0 . #x8F62)
                (#xEDE1 . #x8F63)
                (#xEDE2 . #x8F64)
                (#xEDE3 . #x8F9C)
                (#xEDE4 . #x8F9F)
                (#xEDE5 . #x8FA3)
                (#xEDE6 . #x8FAD)
                (#xEDE7 . #x8FAF)
                (#xEDE8 . #x8FB7)
                (#xEDE9 . #x8FDA)
                (#xEDEA . #x8FE5)
                (#xEDEB . #x8FE2)
                (#xEDEC . #x8FEA)
                (#xEDED . #x8FEF)
                (#xEDEE . #x9087)
                (#xEDEF . #x8FF4)
                (#xEDF0 . #x9005)
                (#xEDF1 . #x8FF9)
                (#xEDF2 . #x8FFA)
                (#xEDF3 . #x9011)
                (#xEDF4 . #x9015)
                (#xEDF5 . #x9021)
                (#xEDF6 . #x900D)
                (#xEDF7 . #x901E)
                (#xEDF8 . #x9016)
                (#xEDF9 . #x900B)
                (#xEDFA . #x9027)
                (#xEDFB . #x9036)
                (#xEDFC . #x9035)
                (#xEDFD . #x9039)
                (#xEDFE . #x8FF8)
                (#xEEA1 . #x904F)
                (#xEEA2 . #x9050)
                (#xEEA3 . #x9051)
                (#xEEA4 . #x9052)
                (#xEEA5 . #x900E)
                (#xEEA6 . #x9049)
                (#xEEA7 . #x903E)
                (#xEEA8 . #x9056)
                (#xEEA9 . #x9058)
                (#xEEAA . #x905E)
                (#xEEAB . #x9068)
                (#xEEAC . #x906F)
                (#xEEAD . #x9076)
                (#xEEAE . #x96A8)
                (#xEEAF . #x9072)
                (#xEEB0 . #x9082)
                (#xEEB1 . #x907D)
                (#xEEB2 . #x9081)
                (#xEEB3 . #x9080)
                (#xEEB4 . #x908A)
                (#xEEB5 . #x9089)
                (#xEEB6 . #x908F)
                (#xEEB7 . #x90A8)
                (#xEEB8 . #x90AF)
                (#xEEB9 . #x90B1)
                (#xEEBA . #x90B5)
                (#xEEBB . #x90E2)
                (#xEEBC . #x90E4)
                (#xEEBD . #x6248)
                (#xEEBE . #x90DB)
                (#xEEBF . #x9102)
                (#xEEC0 . #x9112)
                (#xEEC1 . #x9119)
                (#xEEC2 . #x9132)
                (#xEEC3 . #x9130)
                (#xEEC4 . #x914A)
                (#xEEC5 . #x9156)
                (#xEEC6 . #x9158)
                (#xEEC7 . #x9163)
                (#xEEC8 . #x9165)
                (#xEEC9 . #x9169)
                (#xEECA . #x9173)
                (#xEECB . #x9172)
                (#xEECC . #x918B)
                (#xEECD . #x9189)
                (#xEECE . #x9182)
                (#xEECF . #x91A2)
                (#xEED0 . #x91AB)
                (#xEED1 . #x91AF)
                (#xEED2 . #x91AA)
                (#xEED3 . #x91B5)
                (#xEED4 . #x91B4)
                (#xEED5 . #x91BA)
                (#xEED6 . #x91C0)
                (#xEED7 . #x91C1)
                (#xEED8 . #x91C9)
                (#xEED9 . #x91CB)
                (#xEEDA . #x91D0)
                (#xEEDB . #x91D6)
                (#xEEDC . #x91DF)
                (#xEEDD . #x91E1)
                (#xEEDE . #x91DB)
                (#xEEDF . #x91FC)
                (#xEEE0 . #x91F5)
                (#xEEE1 . #x91F6)
                (#xEEE2 . #x921E)
                (#xEEE3 . #x91FF)
                (#xEEE4 . #x9214)
                (#xEEE5 . #x922C)
                (#xEEE6 . #x9215)
                (#xEEE7 . #x9211)
                (#xEEE8 . #x925E)
                (#xEEE9 . #x9257)
                (#xEEEA . #x9245)
                (#xEEEB . #x9249)
                (#xEEEC . #x9264)
                (#xEEED . #x9248)
                (#xEEEE . #x9295)
                (#xEEEF . #x923F)
                (#xEEF0 . #x924B)
                (#xEEF1 . #x9250)
                (#xEEF2 . #x929C)
                (#xEEF3 . #x9296)
                (#xEEF4 . #x9293)
                (#xEEF5 . #x929B)
                (#xEEF6 . #x925A)
                (#xEEF7 . #x92CF)
                (#xEEF8 . #x92B9)
                (#xEEF9 . #x92B7)
                (#xEEFA . #x92E9)
                (#xEEFB . #x930F)
                (#xEEFC . #x92FA)
                (#xEEFD . #x9344)
                (#xEEFE . #x932E)
                (#xEFA1 . #x9319)
                (#xEFA2 . #x9322)
                (#xEFA3 . #x931A)
                (#xEFA4 . #x9323)
                (#xEFA5 . #x933A)
                (#xEFA6 . #x9335)
                (#xEFA7 . #x933B)
                (#xEFA8 . #x935C)
                (#xEFA9 . #x9360)
                (#xEFAA . #x937C)
                (#xEFAB . #x936E)
                (#xEFAC . #x9356)
                (#xEFAD . #x93B0)
                (#xEFAE . #x93AC)
                (#xEFAF . #x93AD)
                (#xEFB0 . #x9394)
                (#xEFB1 . #x93B9)
                (#xEFB2 . #x93D6)
                (#xEFB3 . #x93D7)
                (#xEFB4 . #x93E8)
                (#xEFB5 . #x93E5)
                (#xEFB6 . #x93D8)
                (#xEFB7 . #x93C3)
                (#xEFB8 . #x93DD)
                (#xEFB9 . #x93D0)
                (#xEFBA . #x93C8)
                (#xEFBB . #x93E4)
                (#xEFBC . #x941A)
                (#xEFBD . #x9414)
                (#xEFBE . #x9413)
                (#xEFBF . #x9403)
                (#xEFC0 . #x9407)
                (#xEFC1 . #x9410)
                (#xEFC2 . #x9436)
                (#xEFC3 . #x942B)
                (#xEFC4 . #x9435)
                (#xEFC5 . #x9421)
                (#xEFC6 . #x943A)
                (#xEFC7 . #x9441)
                (#xEFC8 . #x9452)
                (#xEFC9 . #x9444)
                (#xEFCA . #x945B)
                (#xEFCB . #x9460)
                (#xEFCC . #x9462)
                (#xEFCD . #x945E)
                (#xEFCE . #x946A)
                (#xEFCF . #x9229)
                (#xEFD0 . #x9470)
                (#xEFD1 . #x9475)
                (#xEFD2 . #x9477)
                (#xEFD3 . #x947D)
                (#xEFD4 . #x945A)
                (#xEFD5 . #x947C)
                (#xEFD6 . #x947E)
                (#xEFD7 . #x9481)
                (#xEFD8 . #x947F)
                (#xEFD9 . #x9582)
                (#xEFDA . #x9587)
                (#xEFDB . #x958A)
                (#xEFDC . #x9594)
                (#xEFDD . #x9596)
                (#xEFDE . #x9598)
                (#xEFDF . #x9599)
                (#xEFE0 . #x95A0)
                (#xEFE1 . #x95A8)
                (#xEFE2 . #x95A7)
                (#xEFE3 . #x95AD)
                (#xEFE4 . #x95BC)
                (#xEFE5 . #x95BB)
                (#xEFE6 . #x95B9)
                (#xEFE7 . #x95BE)
                (#xEFE8 . #x95CA)
                (#xEFE9 . #x6FF6)
                (#xEFEA . #x95C3)
                (#xEFEB . #x95CD)
                (#xEFEC . #x95CC)
                (#xEFED . #x95D5)
                (#xEFEE . #x95D4)
                (#xEFEF . #x95D6)
                (#xEFF0 . #x95DC)
                (#xEFF1 . #x95E1)
                (#xEFF2 . #x95E5)
                (#xEFF3 . #x95E2)
                (#xEFF4 . #x9621)
                (#xEFF5 . #x9628)
                (#xEFF6 . #x962E)
                (#xEFF7 . #x962F)
                (#xEFF8 . #x9642)
                (#xEFF9 . #x964C)
                (#xEFFA . #x964F)
                (#xEFFB . #x964B)
                (#xEFFC . #x9677)
                (#xEFFD . #x965C)
                (#xEFFE . #x965E)
                (#xF0A1 . #x965D)
                (#xF0A2 . #x965F)
                (#xF0A3 . #x9666)
                (#xF0A4 . #x9672)
                (#xF0A5 . #x966C)
                (#xF0A6 . #x968D)
                (#xF0A7 . #x9698)
                (#xF0A8 . #x9695)
                (#xF0A9 . #x9697)
                (#xF0AA . #x96AA)
                (#xF0AB . #x96A7)
                (#xF0AC . #x96B1)
                (#xF0AD . #x96B2)
                (#xF0AE . #x96B0)
                (#xF0AF . #x96B4)
                (#xF0B0 . #x96B6)
                (#xF0B1 . #x96B8)
                (#xF0B2 . #x96B9)
                (#xF0B3 . #x96CE)
                (#xF0B4 . #x96CB)
                (#xF0B5 . #x96C9)
                (#xF0B6 . #x96CD)
                (#xF0B7 . #x894D)
                (#xF0B8 . #x96DC)
                (#xF0B9 . #x970D)
                (#xF0BA . #x96D5)
                (#xF0BB . #x96F9)
                (#xF0BC . #x9704)
                (#xF0BD . #x9706)
                (#xF0BE . #x9708)
                (#xF0BF . #x9713)
                (#xF0C0 . #x970E)
                (#xF0C1 . #x9711)
                (#xF0C2 . #x970F)
                (#xF0C3 . #x9716)
                (#xF0C4 . #x9719)
                (#xF0C5 . #x9724)
                (#xF0C6 . #x972A)
                (#xF0C7 . #x9730)
                (#xF0C8 . #x9739)
                (#xF0C9 . #x973D)
                (#xF0CA . #x973E)
                (#xF0CB . #x9744)
                (#xF0CC . #x9746)
                (#xF0CD . #x9748)
                (#xF0CE . #x9742)
                (#xF0CF . #x9749)
                (#xF0D0 . #x975C)
                (#xF0D1 . #x9760)
                (#xF0D2 . #x9764)
                (#xF0D3 . #x9766)
                (#xF0D4 . #x9768)
                (#xF0D5 . #x52D2)
                (#xF0D6 . #x976B)
                (#xF0D7 . #x9771)
                (#xF0D8 . #x9779)
                (#xF0D9 . #x9785)
                (#xF0DA . #x977C)
                (#xF0DB . #x9781)
                (#xF0DC . #x977A)
                (#xF0DD . #x9786)
                (#xF0DE . #x978B)
                (#xF0DF . #x978F)
                (#xF0E0 . #x9790)
                (#xF0E1 . #x979C)
                (#xF0E2 . #x97A8)
                (#xF0E3 . #x97A6)
                (#xF0E4 . #x97A3)
                (#xF0E5 . #x97B3)
                (#xF0E6 . #x97B4)
                (#xF0E7 . #x97C3)
                (#xF0E8 . #x97C6)
                (#xF0E9 . #x97C8)
                (#xF0EA . #x97CB)
                (#xF0EB . #x97DC)
                (#xF0EC . #x97ED)
                (#xF0ED . #x9F4F)
                (#xF0EE . #x97F2)
                (#xF0EF . #x7ADF)
                (#xF0F0 . #x97F6)
                (#xF0F1 . #x97F5)
                (#xF0F2 . #x980F)
                (#xF0F3 . #x980C)
                (#xF0F4 . #x9838)
                (#xF0F5 . #x9824)
                (#xF0F6 . #x9821)
                (#xF0F7 . #x9837)
                (#xF0F8 . #x983D)
                (#xF0F9 . #x9846)
                (#xF0FA . #x984F)
                (#xF0FB . #x984B)
                (#xF0FC . #x986B)
                (#xF0FD . #x986F)
                (#xF0FE . #x9870)
                (#xF1A1 . #x9871)
                (#xF1A2 . #x9874)
                (#xF1A3 . #x9873)
                (#xF1A4 . #x98AA)
                (#xF1A5 . #x98AF)
                (#xF1A6 . #x98B1)
                (#xF1A7 . #x98B6)
                (#xF1A8 . #x98C4)
                (#xF1A9 . #x98C3)
                (#xF1AA . #x98C6)
                (#xF1AB . #x98E9)
                (#xF1AC . #x98EB)
                (#xF1AD . #x9903)
                (#xF1AE . #x9909)
                (#xF1AF . #x9912)
                (#xF1B0 . #x9914)
                (#xF1B1 . #x9918)
                (#xF1B2 . #x9921)
                (#xF1B3 . #x991D)
                (#xF1B4 . #x991E)
                (#xF1B5 . #x9924)
                (#xF1B6 . #x9920)
                (#xF1B7 . #x992C)
                (#xF1B8 . #x992E)
                (#xF1B9 . #x993D)
                (#xF1BA . #x993E)
                (#xF1BB . #x9942)
                (#xF1BC . #x9949)
                (#xF1BD . #x9945)
                (#xF1BE . #x9950)
                (#xF1BF . #x994B)
                (#xF1C0 . #x9951)
                (#xF1C1 . #x9952)
                (#xF1C2 . #x994C)
                (#xF1C3 . #x9955)
                (#xF1C4 . #x9997)
                (#xF1C5 . #x9998)
                (#xF1C6 . #x99A5)
                (#xF1C7 . #x99AD)
                (#xF1C8 . #x99AE)
                (#xF1C9 . #x99BC)
                (#xF1CA . #x99DF)
                (#xF1CB . #x99DB)
                (#xF1CC . #x99DD)
                (#xF1CD . #x99D8)
                (#xF1CE . #x99D1)
                (#xF1CF . #x99ED)
                (#xF1D0 . #x99EE)
                (#xF1D1 . #x99F1)
                (#xF1D2 . #x99F2)
                (#xF1D3 . #x99FB)
                (#xF1D4 . #x99F8)
                (#xF1D5 . #x9A01)
                (#xF1D6 . #x9A0F)
                (#xF1D7 . #x9A05)
                (#xF1D8 . #x99E2)
                (#xF1D9 . #x9A19)
                (#xF1DA . #x9A2B)
                (#xF1DB . #x9A37)
                (#xF1DC . #x9A45)
                (#xF1DD . #x9A42)
                (#xF1DE . #x9A40)
                (#xF1DF . #x9A43)
                (#xF1E0 . #x9A3E)
                (#xF1E1 . #x9A55)
                (#xF1E2 . #x9A4D)
                (#xF1E3 . #x9A5B)
                (#xF1E4 . #x9A57)
                (#xF1E5 . #x9A5F)
                (#xF1E6 . #x9A62)
                (#xF1E7 . #x9A65)
                (#xF1E8 . #x9A64)
                (#xF1E9 . #x9A69)
                (#xF1EA . #x9A6B)
                (#xF1EB . #x9A6A)
                (#xF1EC . #x9AAD)
                (#xF1ED . #x9AB0)
                (#xF1EE . #x9ABC)
                (#xF1EF . #x9AC0)
                (#xF1F0 . #x9ACF)
                (#xF1F1 . #x9AD1)
                (#xF1F2 . #x9AD3)
                (#xF1F3 . #x9AD4)
                (#xF1F4 . #x9ADE)
                (#xF1F5 . #x9ADF)
                (#xF1F6 . #x9AE2)
                (#xF1F7 . #x9AE3)
                (#xF1F8 . #x9AE6)
                (#xF1F9 . #x9AEF)
                (#xF1FA . #x9AEB)
                (#xF1FB . #x9AEE)
                (#xF1FC . #x9AF4)
                (#xF1FD . #x9AF1)
                (#xF1FE . #x9AF7)
                (#xF2A1 . #x9AFB)
                (#xF2A2 . #x9B06)
                (#xF2A3 . #x9B18)
                (#xF2A4 . #x9B1A)
                (#xF2A5 . #x9B1F)
                (#xF2A6 . #x9B22)
                (#xF2A7 . #x9B23)
                (#xF2A8 . #x9B25)
                (#xF2A9 . #x9B27)
                (#xF2AA . #x9B28)
                (#xF2AB . #x9B29)
                (#xF2AC . #x9B2A)
                (#xF2AD . #x9B2E)
                (#xF2AE . #x9B2F)
                (#xF2AF . #x9B32)
                (#xF2B0 . #x9B44)
                (#xF2B1 . #x9B43)
                (#xF2B2 . #x9B4F)
                (#xF2B3 . #x9B4D)
                (#xF2B4 . #x9B4E)
                (#xF2B5 . #x9B51)
                (#xF2B6 . #x9B58)
                (#xF2B7 . #x9B74)
                (#xF2B8 . #x9B93)
                (#xF2B9 . #x9B83)
                (#xF2BA . #x9B91)
                (#xF2BB . #x9B96)
                (#xF2BC . #x9B97)
                (#xF2BD . #x9B9F)
                (#xF2BE . #x9BA0)
                (#xF2BF . #x9BA8)
                (#xF2C0 . #x9BB4)
                (#xF2C1 . #x9BC0)
                (#xF2C2 . #x9BCA)
                (#xF2C3 . #x9BB9)
                (#xF2C4 . #x9BC6)
                (#xF2C5 . #x9BCF)
                (#xF2C6 . #x9BD1)
                (#xF2C7 . #x9BD2)
                (#xF2C8 . #x9BE3)
                (#xF2C9 . #x9BE2)
                (#xF2CA . #x9BE4)
                (#xF2CB . #x9BD4)
                (#xF2CC . #x9BE1)
                (#xF2CD . #x9C3A)
                (#xF2CE . #x9BF2)
                (#xF2CF . #x9BF1)
                (#xF2D0 . #x9BF0)
                (#xF2D1 . #x9C15)
                (#xF2D2 . #x9C14)
                (#xF2D3 . #x9C09)
                (#xF2D4 . #x9C13)
                (#xF2D5 . #x9C0C)
                (#xF2D6 . #x9C06)
                (#xF2D7 . #x9C08)
                (#xF2D8 . #x9C12)
                (#xF2D9 . #x9C0A)
                (#xF2DA . #x9C04)
                (#xF2DB . #x9C2E)
                (#xF2DC . #x9C1B)
                (#xF2DD . #x9C25)
                (#xF2DE . #x9C24)
                (#xF2DF . #x9C21)
                (#xF2E0 . #x9C30)
                (#xF2E1 . #x9C47)
                (#xF2E2 . #x9C32)
                (#xF2E3 . #x9C46)
                (#xF2E4 . #x9C3E)
                (#xF2E5 . #x9C5A)
                (#xF2E6 . #x9C60)
                (#xF2E7 . #x9C67)
                (#xF2E8 . #x9C76)
                (#xF2E9 . #x9C78)
                (#xF2EA . #x9CE7)
                (#xF2EB . #x9CEC)
                (#xF2EC . #x9CF0)
                (#xF2ED . #x9D09)
                (#xF2EE . #x9D08)
                (#xF2EF . #x9CEB)
                (#xF2F0 . #x9D03)
                (#xF2F1 . #x9D06)
                (#xF2F2 . #x9D2A)
                (#xF2F3 . #x9D26)
                (#xF2F4 . #x9DAF)
                (#xF2F5 . #x9D23)
                (#xF2F6 . #x9D1F)
                (#xF2F7 . #x9D44)
                (#xF2F8 . #x9D15)
                (#xF2F9 . #x9D12)
                (#xF2FA . #x9D41)
                (#xF2FB . #x9D3F)
                (#xF2FC . #x9D3E)
                (#xF2FD . #x9D46)
                (#xF2FE . #x9D48)
                (#xF3A1 . #x9D5D)
                (#xF3A2 . #x9D5E)
                (#xF3A3 . #x9D64)
                (#xF3A4 . #x9D51)
                (#xF3A5 . #x9D50)
                (#xF3A6 . #x9D59)
                (#xF3A7 . #x9D72)
                (#xF3A8 . #x9D89)
                (#xF3A9 . #x9D87)
                (#xF3AA . #x9DAB)
                (#xF3AB . #x9D6F)
                (#xF3AC . #x9D7A)
                (#xF3AD . #x9D9A)
                (#xF3AE . #x9DA4)
                (#xF3AF . #x9DA9)
                (#xF3B0 . #x9DB2)
                (#xF3B1 . #x9DC4)
                (#xF3B2 . #x9DC1)
                (#xF3B3 . #x9DBB)
                (#xF3B4 . #x9DB8)
                (#xF3B5 . #x9DBA)
                (#xF3B6 . #x9DC6)
                (#xF3B7 . #x9DCF)
                (#xF3B8 . #x9DC2)
                (#xF3B9 . #x9DD9)
                (#xF3BA . #x9DD3)
                (#xF3BB . #x9DF8)
                (#xF3BC . #x9DE6)
                (#xF3BD . #x9DED)
                (#xF3BE . #x9DEF)
                (#xF3BF . #x9DFD)
                (#xF3C0 . #x9E1A)
                (#xF3C1 . #x9E1B)
                (#xF3C2 . #x9E1E)
                (#xF3C3 . #x9E75)
                (#xF3C4 . #x9E79)
                (#xF3C5 . #x9E7D)
                (#xF3C6 . #x9E81)
                (#xF3C7 . #x9E88)
                (#xF3C8 . #x9E8B)
                (#xF3C9 . #x9E8C)
                (#xF3CA . #x9E92)
                (#xF3CB . #x9E95)
                (#xF3CC . #x9E91)
                (#xF3CD . #x9E9D)
                (#xF3CE . #x9EA5)
                (#xF3CF . #x9EA9)
                (#xF3D0 . #x9EB8)
                (#xF3D1 . #x9EAA)
                (#xF3D2 . #x9EAD)
                (#xF3D3 . #x9761)
                (#xF3D4 . #x9ECC)
                (#xF3D5 . #x9ECE)
                (#xF3D6 . #x9ECF)
                (#xF3D7 . #x9ED0)
                (#xF3D8 . #x9ED4)
                (#xF3D9 . #x9EDC)
                (#xF3DA . #x9EDE)
                (#xF3DB . #x9EDD)
                (#xF3DC . #x9EE0)
                (#xF3DD . #x9EE5)
                (#xF3DE . #x9EE8)
                (#xF3DF . #x9EEF)
                (#xF3E0 . #x9EF4)
                (#xF3E1 . #x9EF6)
                (#xF3E2 . #x9EF7)
                (#xF3E3 . #x9EF9)
                (#xF3E4 . #x9EFB)
                (#xF3E5 . #x9EFC)
                (#xF3E6 . #x9EFD)
                (#xF3E7 . #x9F07)
                (#xF3E8 . #x9F08)
                (#xF3E9 . #x76B7)
                (#xF3EA . #x9F15)
                (#xF3EB . #x9F21)
                (#xF3EC . #x9F2C)
                (#xF3ED . #x9F3E)
                (#xF3EE . #x9F4A)
                (#xF3EF . #x9F52)
                (#xF3F0 . #x9F54)
                (#xF3F1 . #x9F63)
                (#xF3F2 . #x9F5F)
                (#xF3F3 . #x9F60)
                (#xF3F4 . #x9F61)
                (#xF3F5 . #x9F66)
                (#xF3F6 . #x9F67)
                (#xF3F7 . #x9F6C)
                (#xF3F8 . #x9F6A)
                (#xF3F9 . #x9F77)
                (#xF3FA . #x9F72)
                (#xF3FB . #x9F76)
                (#xF3FC . #x9F95)
                (#xF3FD . #x9F9C)
                (#xF3FE . #x9FA0)
                (#xF4A1 . #x582F)
                (#xF4A2 . #x69C7)
                (#xF4A3 . #x9059)
                (#xF4A4 . #x7464)
                (#xF4A5 . #x51DC)
                (#xF4A6 . #x7199)
                ))
       (all-cp932 cp932-only)
       (all-eucjp eucjp-only))
        
  

  (flet ((euc-cp932 (x)
           (let ((high (ash x -16))
                 (mid (logand (ash x -8) 255))
                 (low (logand x 255)))
             (cond ((not (zerop high))
                    nil)
                   ((= mid #x8e)
                    (logand x 255))
                   ((zerop mid)
                    x)
                   ((decf mid #xa1)
                    (decf low #x80)
                    (incf low (if (zerop (logand mid 1)) #x1f #x7e))
                    (incf low (if (<= #x7f low #x9d) 1 0))
                    (setq mid (ash mid -1))
                    (incf mid (if (<= mid #x1e) #x81 #xc1))
                    (+ (ash mid 8) low))))))
    (dolist (i eucjp)
      (push i all-eucjp)
      (let* ((cp932 (euc-cp932 (car i))))
        (when cp932
          (push (cons cp932 (cdr i)) all-cp932)))))

;; ascii
  (loop for i from #x00 to #x7f
        do
        (push (cons i i) all-eucjp)
        (push (cons i i) all-cp932))

;; half-width katakana
  (loop for i from #xa1 to #xdf
        do
        (push (cons i (+ #xff61 #x-a1 i)) all-cp932)
        (push (cons (+ #x8e00 i) (+ #xff61 #x-a1 i)) all-eucjp))
  (setq *cp932-to-ucs-map* (init-pv-map all-cp932)
        *ucs-to-cp932-map* (init-pv-map all-cp932 :reverse-mapping t)
        *eucjp-to-ucs-map* (init-pv-map all-eucjp)
        *ucs-to-eucjp-map* (init-pv-map all-eucjp :reverse-mapping t)))

(defun eucjp-to-ucs (code)
  (pv-map-lookup code *eucjp-to-ucs-map*))

(defun ucs-to-eucjp (code)
  (pv-map-lookup code *ucs-to-eucjp-map*))

(defun cp932-to-ucs (code)
  (pv-map-lookup code *cp932-to-ucs-map*))

(defun ucs-to-cp932 (code)
  (pv-map-lookup code *ucs-to-cp932-map*))


(defmacro define-jp-encoding (name docstring aliases max-units-per-char
                              from-ucs
                              to-ucs
                              length-by-code
                              length-by-1st-unit)
  `(define-character-encoding ,name
       ,docstring
     :aliases ,aliases
     :native-endianness nil
     :max-units-per-char ,max-units-per-char
     :stream-encode-function
     (lambda (char write-function stream)
       (let ((code (,from-ucs (char-code char))))
         (cond ((null code)
                (funcall write-function stream #.(char-code #\?))
                1)
               ((< code #x100)
                (funcall write-function stream code)
                1)
               ((< code #x10000)
                (funcall write-function stream (logand #xff (ash code -8)))
                (funcall write-function stream (logand code #xff))
                2)
               (t
                (funcall write-function stream (logand #xff (ash code -16)))
                (funcall write-function stream (logand #xff (ash code -8)))
                (funcall write-function stream (logand code #xff))
                3))))
     :stream-decode-function
     (lambda (1st-unit next-unit-function stream)
       (declare (type (unsigned-byte 8) 1st-unit))
       (let ((code
              (case ,length-by-1st-unit
                (3 (let ((2nd-unit (funcall next-unit-function stream)))
                     (if (eq 2nd-unit :eof)
                         :eof
                         (let ((3rd-unit (funcall next-unit-function stream)))
                           (if (eq 3rd-unit :eof)
                               :eof
                               (logior #x8f0000
                                       (ash 2nd-unit 8)
                                       3rd-unit))))))
                (2 (let ((2nd-unit (funcall next-unit-function stream)))
                     (if (eq 2nd-unit :eof)
                         :eof
                         (logior (ash 1st-unit 8)
                                 2nd-unit))))
                (1 1st-unit))))
         (if (eq code :eof)
             :eof
             (let ((ucs (,to-ucs code)))
               (if ucs
                   (code-char ucs)
                   #\?)))))
     :vector-encode-function
     (lambda (string vector idx start end)
       (declare (type (simple-array (unsigned-byte 8) (*)) vector)
                (fixnum idx))
       (do* ((i start (1+ i)))
            ((>= i end) idx)
         (let* ((char (schar string i))
                (code (,from-ucs (char-code char))))
           (cond ((null code)
                  (setf (aref vector idx) #.(char-code #\?))
                  (incf idx))
                 ((< code #x100)
                  (setf (aref vector idx) code)
                  (incf idx))
                 ((< code #x10000)
                  (setf (aref vector idx) (logand #xff (ash code -8)))
                  (setf (aref vector (the fixnum (1+ idx))) (logand code #xff))
                  (incf idx 2))
                 (t
                  (setf (aref vector idx) (logand #xff (ash code -16)))
                  (setf (aref vector (the fixnum (1+ idx)))
                        (logand #xff (ash code -8)))
                  (setf (aref vector (the fixnum (+ idx 2))) (logand code #xff))
                  (incf idx 3))))))
     :vector-decode-function
     (lambda (vector idx noctets string)
       (declare (type (simple-array (unsigned-byte 8) (*)) vector)
                (type index idx))
       (do* ((i 0 (1+ i))
             (end (+ idx noctets))
             (index idx (1+ index)))
            ((= index end) index)
         (let* ((1st-unit (aref vector index)))
           (declare (type (unsigned-byte 8) 1st-unit))
           (let* ((code (,to-ucs
                         (case ,length-by-1st-unit
                           (3 (logior
                               #x8f0000
                               (ash (aref vector (incf index)) 8)
                               (aref vector (incf index))))
                           (2 (logior
                               (ash 1st-unit 8)
                               (aref vector (incf index))))
                           (1 1st-unit))))
                  (char (and code (code-char code))))
             (setf (schar string i) (or char #\?))))))
     :memory-encode-function
     (lambda (string pointer idx start end)
       (declare (fixnum idx))
       (do* ((i start (1+ i)))
            ((>= i end) idx)
         (let* ((code (,from-ucs (char-code (schar string i)))))
           (cond ((null code)
                  (setf (%get-unsigned-byte pointer idx) #.(char-code #\?))
                  (incf idx))
                 ((< code #x100)
                  (setf (%get-unsigned-byte pointer idx) code)
                  (incf idx))
                 ((< code #x10000)
                  (setf (%get-unsigned-byte pointer idx)
                        (logand #xff (ash code -8)))
                  (setf (%get-unsigned-byte pointer (the fixnum (1+ idx)))
                        (logand code #xff))
                  (incf idx 2))
                 (t
                  (setf (%get-unsigned-byte pointer idx)
                        (logand #xff (ash code -16)))
                  (setf (%get-unsigned-byte pointer (the fixnum (1+ idx)))
                        (logand #xff (ash code -8)))
                  (setf (%get-unsigned-byte pointer (the fixnum (+ 2 idx)))
                        (logand code #xff))
                  (incf idx 3))))))
     :memory-decode-function
     (lambda (pointer noctets idx string)
       (declare (fixnum noctets idx))
       (do* ((i 0 (1+ i))
             (end (+ idx noctets))
             (index idx (1+ index)))
            ((>= index end) (if (= index end) index 0))
         (let* ((1st-unit (%get-unsigned-byte pointer index)))
           (declare (type (unsigned-byte 8) 1st-unit))
           (let* ((code
                   (,to-ucs
                    (case ,length-by-1st-unit
                      (3 (logior
                          #x8f0000
                          (ash (%get-unsigned-byte
                                pointer (incf index)) 8)
                          (%get-unsigned-byte pointer (incf index))))
                      (2 (logior
                          (ash 1st-unit 8)
                          (%get-unsigned-byte pointer (incf index))))
                      (1 1st-unit))))
                  (char (if code (code-char code) #\?)))
             (setf (schar string i) char)))))
     :octets-in-string-function
     (lambda (string start end)
       (if (>= end start)
           (do* ((noctets 0)
                 (i start (1+ i)))
                ((= i end) noctets)
             (declare (fixnum noctets))
             (let* ((code (,from-ucs (char-code (schar string i)))))
               (if code
                   (incf noctets ,length-by-code)
                   (incf noctets))))
           0))
     :length-of-vector-encoding-function
     (lambda (vector start end)
       (declare (type (simple-array (unsigned-byte 8) (*)) vector))
       (do* ((i start)
             (nchars 0))
            ((>= i end)
             (values nchars i))
         (declare (fixnum i))
         (let* ((1st-unit (aref vector i))
                (nexti (+ i ,length-by-1st-unit)))
           (declare (type (unsigned-byte 8) 1st-unit))
           (if (> nexti end)
               (return (values nchars i))
               (setq nchars (1+ nchars) i nexti)))))
     :length-of-memory-encoding-function
     (lambda (pointer noctets start)
       (do* ((i start)
             (end (+ start noctets))
             (nchars 0 (1+ nchars)))
            ((= i end) (values nchars (- i start)))
         (let* ((1st-unit (%get-unsigned-byte pointer i))
                (nexti (+ i ,length-by-1st-unit)))
           (declare (type (unsigned-byte 8) 1st-unit))
           (if (> nexti end)
               (return (values nchars (- i start)))
               (setq i nexti)))))
     :decode-literal-code-unit-limit #x80
     :encode-literal-char-code-limit #x80
     :character-size-in-octets-function
     (lambda (c)
       (let ((code (,from-ucs (char-code c))))
         (if code
             ,length-by-code
             1)))))


(define-jp-encoding :euc-jp
    "An 8-bit, variable-length character encoding in which
character code points in the range #x00-#x7f can be encoded in a
single octet; characters with larger code values can be encoded
in 2 to 3 bytes."
  '(:eucjp)
  3
  ucs-to-eucjp
  eucjp-to-ucs
  (cond ((< code #x100) 1)
        ((< code #x10000) 2)
        (t 3))
  (cond ((= 1st-unit #x8f)
         3)
        ((or (= 1st-unit #x8e)
             (< #xa0 1st-unit #xff))
         2)
        (t 1)))

(define-jp-encoding :windows-31j
    "An 8-bit, variable-length character encoding in which
character code points in the range #x00-#x7f can be encoded in a
single octet; characters with larger code values can be encoded
in 2 bytes."
  '(:cp932 :csWindows31J)
  2
  ucs-to-cp932
  cp932-to-ucs
  (cond ((< code #x100) 1)
        (t 2))
  (cond ((or (<= #x81 1st-unit #x9f)
             (<= #xe0 1st-unit #xfc))
         2)
        (t 1)))
