/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PopupMenuFactory;
import ca.sqlpower.architect.swingui.action.ExportPlaypenToPDFAction;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.action.CreateEnergonCubeAction;
import ca.sqlpower.architect.swingui.olap.action.EditCubeAction;
import ca.sqlpower.architect.swingui.olap.action.EditDimensionAction;
import ca.sqlpower.architect.swingui.olap.action.EditHierarchyAction;
import ca.sqlpower.architect.swingui.olap.action.EditLevelAction;
import ca.sqlpower.architect.swingui.olap.action.EditMeasureAction;
import ca.sqlpower.architect.swingui.olap.action.EditSchemaAction;
import ca.sqlpower.architect.swingui.olap.action.EditVirtualCubeAction;
import javax.swing.JPopupMenu;

public class OLAPContextMenuFactory
implements PopupMenuFactory {
    private final ArchitectSwingSession session;
    private final OLAPEditSession oSession;

    public OLAPContextMenuFactory(ArchitectSwingSession session, OLAPEditSession oSession) {
        this.session = session;
        this.oSession = oSession;
    }

    @Override
    public JPopupMenu createPopupMenu(Object sourceComponent) {
        OLAPObject obj = (OLAPObject)((Object)sourceComponent);
        JPopupMenu m = new JPopupMenu();
        if (obj == null) {
            m.add(this.oSession.getCreateCubeAction());
            m.add(this.oSession.getCreateDimensionAction());
            m.add(this.oSession.getCreateVirtualCubeAction());
            m.addSeparator();
            m.add(this.oSession.getExportSchemaAction());
            m.add(new ExportPlaypenToPDFAction(this.session, this.oSession.getOlapPlayPen()));
        } else if (obj instanceof MondrianModel.Schema) {
            m.add(this.oSession.getCreateCubeAction());
            m.add(this.oSession.getCreateDimensionAction());
            m.add(this.oSession.getCreateVirtualCubeAction());
            m.add(new CreateEnergonCubeAction(this.session, this.oSession.getOlapPlayPen()));
            m.addSeparator();
            m.add(new EditSchemaAction(this.session, (MondrianModel.Schema)obj, this.oSession.getOlapPlayPen()));
            m.addSeparator();
            m.add(this.oSession.getExportSchemaAction());
        } else if (obj instanceof MondrianModel.Dimension) {
            m.add(this.oSession.getCreateHierarchyAction());
            m.addSeparator();
            m.add(new EditDimensionAction(this.session, (MondrianModel.Dimension)obj, this.oSession.getOlapPlayPen()));
        } else if (obj instanceof MondrianModel.Cube) {
            m.add(this.oSession.getCreateDimensionAction());
            m.add(this.oSession.getCreateMeasureAction());
            m.add(this.oSession.getCreateCalculatedMemberAction());
            m.addSeparator();
            m.add(new EditCubeAction(this.session, (MondrianModel.Cube)obj, this.oSession.getOlapPlayPen()));
        } else if (obj instanceof MondrianModel.VirtualCube) {
            m.add(this.oSession.getCreateCubeAction());
            m.add(this.oSession.getCreateDimensionAction());
            m.add(this.oSession.getCreateMeasureAction());
            m.addSeparator();
            m.add(new EditVirtualCubeAction(this.session, (MondrianModel.VirtualCube)obj, this.oSession.getOlapPlayPen()));
        } else if (obj instanceof MondrianModel.Measure) {
            m.add(new EditMeasureAction(this.session, (MondrianModel.Measure)obj, this.oSession.getOlapPlayPen()));
        } else if (obj instanceof MondrianModel.Hierarchy) {
            m.add(new EditHierarchyAction(this.session, (MondrianModel.Hierarchy)obj, this.oSession.getOlapPlayPen()));
            m.add(this.oSession.getCreateLevelAction());
        } else if (obj instanceof MondrianModel.Level) {
            m.add(new EditLevelAction(this.session, (MondrianModel.Level)obj, this.oSession.getOlapPlayPen()));
        }
        if (obj != null && !(obj instanceof MondrianModel.Schema)) {
            m.addSeparator();
            m.add(this.oSession.getOLAPDeleteSelectedAction());
        }
        return m;
    }
}

