# Automatically generated by boost-vcpkg-helpers/generate-ports.ps1

include(vcpkg_common_functions)

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO boostorg/python
    REF boost-1.72.0
    SHA512 9e2214f45b6b7e269caeba3decf2b79df9d1addc711aa65b75273e5fef9ff7423d400e4f11a904f932759b32a5c7e699441961494e061c8dd9c966da1f5b8fef
    HEAD_REF master
)

# Find Python3 executable
vcpkg_find_acquire_program(PYTHON3)
set(VCPKG_PYTHON_EXECUTABLE "${PYTHON3}")
# Find Python3 libraries. Can't use find_package here, but we already know where everything is
file(GLOB VCPKG_PYTHON_INCLUDE "${CURRENT_INSTALLED_DIR}/include/python3.*")
set(VCPKG_PYTHON_LIBS_RELEASE "${CURRENT_INSTALLED_DIR}/lib")
set(VCPKG_PYTHON_LIBS_DEBUG "${CURRENT_INSTALLED_DIR}/debug/lib")
string(REGEX REPLACE ".*python([0-9\.]+).*" "\\1" VCPKG_PYTHON_VERSION "${VCPKG_PYTHON_INCLUDE}")
include(${CURRENT_INSTALLED_DIR}/share/boost-build/boost-modular-build.cmake)
boost_modular_build(SOURCE_PATH ${SOURCE_PATH})
include(${CURRENT_INSTALLED_DIR}/share/boost-vcpkg-helpers/boost-modular-headers.cmake)
boost_modular_headers(SOURCE_PATH ${SOURCE_PATH})
