
cmake_minimum_required(VERSION 3.2.0)

function(split_library_configurations LIBRARIES OPTIMIZED_OUT_VAR DEBUG_OUT_VAR GENERAL_OUT_VAR)
  set(OPTIMIZED_LIBRARIES)
  set(DEBUG_LIBRARIES)
  set(GENERAL_LIBRARIES)

  set(CURRENT_TYPE)
  foreach(LIBRARY ${LIBRARIES})
    if("${LIBRARY}" STREQUAL "optimized" OR "${LIBRARY}" STREQUAL "debug" OR "${LIBRARY}" STREQUAL "general")
      set(CURRENT_TYPE "${LIBRARY}")
    else()
      if("${CURRENT_TYPE}" STREQUAL "optimized")
        list(APPEND OPTIMIZED_LIBRARIES "${LIBRARY}")
      elseif("${CURRENT_TYPE}" STREQUAL "debug")
        list(APPEND DEBUG_LIBRARIES "${LIBRARY}")
      else()
        list(APPEND GENERAL_LIBRARIES "${LIBRARY}")
      endif()
      set(CURRENT_TYPE)
    endif()
  endforeach()

  set(${OPTIMIZED_OUT_VAR} "${OPTIMIZED_LIBRARIES}" PARENT_SCOPE)
  set(${DEBUG_OUT_VAR} "${DEBUG_LIBRARIES}" PARENT_SCOPE)
  set(${GENERAL_OUT_VAR} "${GENERAL_LIBRARIES}" PARENT_SCOPE)
endfunction()