cdef extern from "Evas.h":
    ####################################################################
    # #define  (this works only for integer define)
    #
    enum:
        EVAS_LAYER_MIN
        EVAS_LAYER_MAX

        EVAS_COLOR_SPACE_ARGB
        EVAS_COLOR_SPACE_AHSV

        EVAS_TEXT_INVALID
        EVAS_TEXT_SPECIAL

        EVAS_SMART_CLASS_VERSION

    ####################################################################
    # Enums
    #
    ctypedef enum Evas_Button_Flags:
        EVAS_BUTTON_NONE
        EVAS_BUTTON_DOUBLE_CLICK
        EVAS_BUTTON_TRIPLE_CLICK

    ctypedef enum Evas_BiDi_Direction:
        EVAS_BIDI_DIRECTION_NATURAL
        EVAS_BIDI_DIRECTION_NEUTRAL
        EVAS_BIDI_DIRECTION_LTR
        EVAS_BIDI_DIRECTION_RTL
        EVAS_BIDI_DIRECTION_INHERIT

    ctypedef enum Evas_Callback_Type:
        EVAS_CALLBACK_MOUSE_IN
        EVAS_CALLBACK_MOUSE_OUT
        EVAS_CALLBACK_MOUSE_DOWN
        EVAS_CALLBACK_MOUSE_UP
        EVAS_CALLBACK_MOUSE_MOVE
        EVAS_CALLBACK_MOUSE_WHEEL
        EVAS_CALLBACK_MULTI_DOWN
        EVAS_CALLBACK_MULTI_UP
        EVAS_CALLBACK_MULTI_MOVE
        EVAS_CALLBACK_FREE
        EVAS_CALLBACK_KEY_DOWN
        EVAS_CALLBACK_KEY_UP
        EVAS_CALLBACK_FOCUS_IN
        EVAS_CALLBACK_FOCUS_OUT
        EVAS_CALLBACK_SHOW
        EVAS_CALLBACK_HIDE
        EVAS_CALLBACK_MOVE
        EVAS_CALLBACK_RESIZE
        EVAS_CALLBACK_RESTACK
        EVAS_CALLBACK_DEL
        EVAS_CALLBACK_HOLD
        EVAS_CALLBACK_CHANGED_SIZE_HINTS
        EVAS_CALLBACK_IMAGE_PRELOADED
        EVAS_CALLBACK_CANVAS_FOCUS_IN
        EVAS_CALLBACK_CANVAS_FOCUS_OUT
        EVAS_CALLBACK_RENDER_FLUSH_PRE
        EVAS_CALLBACK_RENDER_FLUSH_POST
        EVAS_CALLBACK_CANVAS_OBJECT_FOCUS_IN
        EVAS_CALLBACK_CANVAS_OBJECT_FOCUS_OUT
        EVAS_CALLBACK_IMAGE_UNLOADED
        EVAS_CALLBACK_RENDER_PRE
        EVAS_CALLBACK_RENDER_POST
        EVAS_CALLBACK_IMAGE_RESIZE
        EVAS_CALLBACK_DEVICE_CHANGED
        EVAS_CALLBACK_AXIS_UPDATE
        EVAS_CALLBACK_CANVAS_VIEWPORT_RESIZE
        EVAS_CALLBACK_LAST

    ctypedef enum Evas_Event_Flags:
        EVAS_EVENT_FLAG_NONE
        EVAS_EVENT_FLAG_ON_HOLD
        EVAS_EVENT_FLAG_ON_SCROLL

    ctypedef enum Evas_Touch_Point_State:
        EVAS_TOUCH_POINT_DOWN
        EVAS_TOUCH_POINT_UP
        EVAS_TOUCH_POINT_MOVE
        EVAS_TOUCH_POINT_STILL
        EVAS_TOUCH_POINT_CANCEL

    ctypedef enum Evas_Font_Hinting_Flags:
        EVAS_FONT_HINTING_NONE
        EVAS_FONT_HINTING_AUTO
        EVAS_FONT_HINTING_BYTECODE

    ctypedef enum Evas_Colorspace:
        EVAS_COLORSPACE_ARGB8888
        EVAS_COLORSPACE_YCBCR422P601_PL
        EVAS_COLORSPACE_YCBCR422P709_PL
        EVAS_COLORSPACE_RGB565_A5P
        EVAS_COLORSPACE_GRY8
        EVAS_COLORSPACE_YCBCR422601_PL
        EVAS_COLORSPACE_YCBCR420NV12601_PL
        EVAS_COLORSPACE_YCBCR420TM12601_PL

    ctypedef enum Evas_Object_Table_Homogeneous_Mode:
        EVAS_OBJECT_TABLE_HOMOGENEOUS_NONE
        EVAS_OBJECT_TABLE_HOMOGENEOUS_TABLE
        EVAS_OBJECT_TABLE_HOMOGENEOUS_ITEM

    ctypedef enum Evas_Aspect_Control:
        EVAS_ASPECT_CONTROL_NONE
        EVAS_ASPECT_CONTROL_NEITHER
        EVAS_ASPECT_CONTROL_HORIZONTAL
        EVAS_ASPECT_CONTROL_VERTICAL
        EVAS_ASPECT_CONTROL_BOTH

    ctypedef enum Evas_Display_Mode:
        EVAS_DISPLAY_MODE_NONE
        EVAS_DISPLAY_MODE_COMPRESS
        EVAS_DISPLAY_MODE_EXPAND
        EVAS_DISPLAY_MODE_DONT_CHANGE

    ctypedef enum Evas_Load_Error:
        EVAS_LOAD_ERROR_NONE
        EVAS_LOAD_ERROR_GENERIC
        EVAS_LOAD_ERROR_DOES_NOT_EXIST
        EVAS_LOAD_ERROR_PERMISSION_DENIED
        EVAS_LOAD_ERROR_RESOURCE_ALLOCATION_FAILED
        EVAS_LOAD_ERROR_CORRUPT_FILE
        EVAS_LOAD_ERROR_UNKNOWN_FORMAT

    ctypedef enum Evas_Alloc_Error:
        EVAS_ALLOC_ERROR_NONE
        EVAS_ALLOC_ERROR_FATAL
        EVAS_ALLOC_ERROR_RECOVERED

    ctypedef enum Evas_Fill_Spread:
        EVAS_TEXTURE_REFLECT
        EVAS_TEXTURE_REPEAT
        EVAS_TEXTURE_RESTRICT
        EVAS_TEXTURE_RESTRICT_REFLECT
        EVAS_TEXTURE_RESTRICT_REPEAT
        EVAS_TEXTURE_PAD

    ctypedef enum Evas_Pixel_Import_Pixel_Format:
        EVAS_PIXEL_FORMAT_NONE
        EVAS_PIXEL_FORMAT_ARGB32
        EVAS_PIXEL_FORMAT_YUV420P_601

    ctypedef enum Evas_Native_Surface_Type:
        EVAS_NATIVE_SURFACE_NONE
        EVAS_NATIVE_SURFACE_X11
        EVAS_NATIVE_SURFACE_OPENGL
        EVAS_NATIVE_SURFACE_WL

    ctypedef enum Evas_Render_Op:
        EVAS_RENDER_BLEND
        EVAS_RENDER_BLEND_REL
        EVAS_RENDER_COPY
        EVAS_RENDER_COPY_REL
        EVAS_RENDER_ADD
        EVAS_RENDER_ADD_REL
        EVAS_RENDER_SUB
        EVAS_RENDER_SUB_REL
        EVAS_RENDER_TINT
        EVAS_RENDER_TINT_REL
        EVAS_RENDER_MASK
        EVAS_RENDER_MUL

    ctypedef enum Evas_Border_Fill_Mode:
        EVAS_BORDER_FILL_NONE
        EVAS_BORDER_FILL_DEFAULT
        EVAS_BORDER_FILL_SOLID

    ctypedef enum Evas_Image_Scale_Hint:
        EVAS_IMAGE_SCALE_HINT_NONE
        EVAS_IMAGE_SCALE_HINT_DYNAMIC
        EVAS_IMAGE_SCALE_HINT_STATIC

    ctypedef enum Evas_Image_Animated_Loop_Hint:
        EVAS_IMAGE_ANIMATED_HINT_NONE
        EVAS_IMAGE_ANIMATED_HINT_LOOP
        EVAS_IMAGE_ANIMATED_HINT_PINGPONG

    ctypedef enum Evas_Image_Orient:
        EVAS_IMAGE_ORIENT_NONE
        EVAS_IMAGE_ORIENT_0
        EVAS_IMAGE_ORIENT_90
        EVAS_IMAGE_ORIENT_180
        EVAS_IMAGE_ORIENT_270
        EVAS_IMAGE_FLIP_HORIZONTAL
        EVAS_IMAGE_FLIP_VERTICAL
        EVAS_IMAGE_FLIP_TRANSPOSE
        EVAS_IMAGE_FLIP_TRANSVERSE

    ctypedef enum Evas_Engine_Render_Mode:
        EVAS_RENDER_MODE_BLOCKING
        EVAS_RENDER_MODE_NONBLOCKING

    ctypedef enum Evas_Image_Content_Hint:
        EVAS_IMAGE_CONTENT_HINT_NONE
        EVAS_IMAGE_CONTENT_HINT_DYNAMIC
        EVAS_IMAGE_CONTENT_HINT_STATIC

    ctypedef enum Evas_Device_Class:
        EVAS_DEVICE_CLASS_NONE
        EVAS_DEVICE_CLASS_SEAT
        EVAS_DEVICE_CLASS_KEYBOARD
        EVAS_DEVICE_CLASS_MOUSE
        EVAS_DEVICE_CLASS_TOUCH
        EVAS_DEVICE_CLASS_PEN
        EVAS_DEVICE_CLASS_POINTER
        EVAS_DEVICE_CLASS_GAMEPAD

    ctypedef enum Evas_Object_Pointer_Mode:
        EVAS_OBJECT_POINTER_MODE_AUTOGRAB
        EVAS_OBJECT_POINTER_MODE_NOGRAB
        EVAS_OBJECT_POINTER_MODE_NOGRAB_NO_REPEAT_UPDOWN

    ctypedef enum Evas_Text_Style_Type:
        EVAS_TEXT_STYLE_PLAIN
        EVAS_TEXT_STYLE_SHADOW
        EVAS_TEXT_STYLE_OUTLINE
        EVAS_TEXT_STYLE_SOFT_OUTLINE
        EVAS_TEXT_STYLE_GLOW
        EVAS_TEXT_STYLE_OUTLINE_SHADOW
        EVAS_TEXT_STYLE_FAR_SHADOW
        EVAS_TEXT_STYLE_OUTLINE_SOFT_SHADOW
        EVAS_TEXT_STYLE_SOFT_SHADOW
        EVAS_TEXT_STYLE_FAR_SOFT_SHADOW
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_BOTTOM_RIGHT
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_BOTTOM
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_BOTTOM_LEFT
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_LEFT
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_TOP_LEFT
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_TOP
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_TOP_RIGHT
        EVAS_TEXT_STYLE_SHADOW_DIRECTION_RIGHT

    ctypedef enum Evas_Textblock_Text_Type:
        EVAS_TEXTBLOCK_TEXT_RAW
        EVAS_TEXTBLOCK_TEXT_PLAIN
        EVAS_TEXTBLOCK_TEXT_MARKUP

    ctypedef enum Evas_Textblock_Cursor_Type:
        EVAS_TEXTBLOCK_CURSOR_UNDER
        EVAS_TEXTBLOCK_CURSOR_BEFORE

    ctypedef enum Evas_Textgrid_Palette:
        EVAS_TEXTGRID_PALETTE_NONE
        EVAS_TEXTGRID_PALETTE_STANDARD
        EVAS_TEXTGRID_PALETTE_EXTENDED
        EVAS_TEXTGRID_PALETTE_LAST

    ctypedef enum Evas_Textgrid_Font_Style:
        EVAS_TEXTGRID_FONT_STYLE_NORMAL
        EVAS_TEXTGRID_FONT_STYLE_BOLD
        EVAS_TEXTGRID_FONT_STYLE_ITALIC
