/*
 *  Copyright (C) 2002-2021  The DOSBox Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include "dosbox.h"
#include "mem.h"
#include "inout.h"
#include "int10.h"


const Bit8u vparams[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// mode 7 MDA text
	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19, 0x02, 0x0d, 0x0b, 0x0c, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

const Bit8u vparams_pcjr[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2c, 0x06, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0c, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5, 6, 8
	0x38, 0x28, 0x2b, 0x06, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x26, 0x07, 0,0,0,0,
	// other graphics modes
	0x71, 0x50, 0x56, 0x0c, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x26, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

const Bit8u vparams_tandy[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2c, 0x08, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x58, 0x10, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2c, 0x08, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// graphics mode 7
	0x71, 0x50, 0x58, 0x10, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x06, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};

const Bit8u vparams_tandy_td[] = {
	// 40x25 mode 0 and 1 crtc registers
	0x38, 0x28, 0x2d, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// 80x25 mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x1f, 0x06, 0x19, 0x1c, 0x02, 0x07, 0x06, 0x07, 0,0,0,0,
	// graphics modes 4, 5 and 6
	0x38, 0x28, 0x2d, 0x0a, 0x7f, 0x06, 0x64, 0x70, 0x02, 0x01, 0x06, 0x07, 0,0,0,0,
	// mode 7 MDA text
	0x61, 0x50, 0x52, 0x0f, 0x19, 0x06, 0x19, 0x19, 0x02, 0x0d, 0x0b, 0x0c, 0,0,0,0,
	// ?? mode 2 and 3 crtc registers
	0x71, 0x50, 0x5a, 0x0a, 0x3f, 0x06, 0x32, 0x38, 0x02, 0x03, 0x06, 0x07, 0,0,0,0,
	// buffer length words 2048, 4096, 16384, 16384
	0x00, 0x08, 0x00, 0x10, 0x00, 0x40, 0x00, 0x40,
	// columns
	40, 40, 80, 80, 40, 40, 80, 80,
	// CGA mode register
	0x2c, 0x28, 0x2d, 0x29, 0x2a, 0x2e, 0x1e, 0x29
};


static Bit8u video_parameter_table_vga[0x40*0x1d]={
// video parameter table for mode 0 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 1 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 2 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 3 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 4
  0x28, 0x18, 0x08, 0x00, 0x40, // bios data
  0x09, 0x00, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xa2, 0xff, // crtc registers 16-24
  0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0f, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 5
  0x28, 0x18, 0x08, 0x00, 0x40, // bios data
  0x09, 0x00, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xa2, 0xff, // crtc registers 16-24
  0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x0f, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 6
  0x50, 0x18, 0x08, 0x00, 0x40, // bios data
  0x09, 0x0f, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0xc1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96, 0xb9, 0xc2, 0xff, // crtc registers 16-24
  0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,       // attr registers 0-7
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x01, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 7
  0x50, 0x18, 0x10, 0x00, 0x10, // bios data
  0x00, 0x0f, 0x00, 0x07, // sequencer registers
  0x66, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x0f, 0x96, 0xb9, 0xa3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x0c, 0x00, 0x0f, 0x08, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 8
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 9
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode a
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode b
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode c
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode d
  0x28, 0x18, 0x08, 0x00, 0x20, // bios data
  0x09, 0x0f, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x2d, 0x27, 0x28, 0x90, 0x2b, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x14, 0x00, 0x96, 0xb9, 0xe3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode e
  0x50, 0x18, 0x08, 0x00, 0x40, // bios data
  0x01, 0x0f, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x00, 0x96, 0xb9, 0xe3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode f (64k graphics memory)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 10 (64k graphics memory)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode f (>64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, // bios data
  0x01, 0x0f, 0x00, 0x02, // sequencer registers
  0xa2, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xba, 0xe3, 0xff, // crtc registers 16-24
  0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,       // attr registers 0-7
  0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,       // attr registers 8-15
  0x0b, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 10 (>64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, // bios data
  0x01, 0x0f, 0x00, 0x02, // sequencer registers
  0xa3, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xba, 0xe3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 0 (350 lines)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 1 (350 lines)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 2 (350 lines)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 3 (350 lines)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode e
  0x28, 0x18, 0x10, 0x00, 0x08, // bios data
  0x08, 0x0f, 0x00, 0x07, // sequencer registers
  0x67, // misc output registers
  0x2d, 0x27, 0x28, 0x90, 0x2b, 0xa0, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x14, 0x1f, 0x96, 0xb9, 0xa3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x0c, 0x00, 0x0f, 0x08, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode f
  0x50, 0x18, 0x10, 0x00, 0x10, // bios data
  0x00, 0x0f, 0x00, 0x07, // sequencer registers
  0x67, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96, 0xb9, 0xa3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x0c, 0x00, 0x0f, 0x08, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 10
  0x50, 0x18, 0x10, 0x00, 0x10, // bios data
  0x00, 0x0f, 0x00, 0x07, // sequencer registers
  0x66, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x4f, 0x0d, 0x0e, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x0f, 0x96, 0xb9, 0xa3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x0c, 0x00, 0x0f, 0x08, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0a, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 11
  0x50, 0x1d, 0x10, 0x00, 0xa0, // bios data
  0x01, 0x0f, 0x00, 0x02, // sequencer registers
  0xe3, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xc3, 0xff, // crtc registers 16-24
  0x00, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,       // attr registers 0-7
  0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 12
  0x50, 0x1d, 0x10, 0x00, 0xa0, // bios data
  0x01, 0x0f, 0x00, 0x02, // sequencer registers
  0xe3, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0x0b, 0x3e,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xea, 0x8c, 0xdf, 0x28, 0x00, 0xe7, 0x04, 0xe3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07,       // attr registers 0-7
  0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 13
  0x28, 0x18, 0x08, 0x00, 0x20, // bios data
  0x01, 0x0f, 0x00, 0x0e, // sequencer registers
  0x63, // misc output registers
  0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f,       // crtc registers 0-7
  0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x9c, 0x8e, 0x8f, 0x28, 0x40, 0x96, 0xb9, 0xa3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,       // attr registers 8-15
  0x41, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x05, 0x0f, 0xff  // graphics registers 0-8
};

static Bit8u video_parameter_table_ega[0x40*0x17]={
// video parameter table for mode 0 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 1 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 2 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 3 (cga emulation)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 4
  0x28, 0x18, 0x08, 0x00, 0x40, // bios data
  0x09, 0x03, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x37, 0x27, 0x28, 0x9a, 0x2b, 0x8a, 0x04, 0x11,       // crtc registers 0-7
  0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xd4, 0x86, 0xc7, 0x14, 0x00, 0xd0, 0xfc, 0xb2, 0xff, // crtc registers 16-24
  0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 5
  0x28, 0x18, 0x08, 0x00, 0x40, // bios data
  0x09, 0x03, 0x00, 0x02, // sequencer registers
  0x63, // misc output registers
  0x37, 0x27, 0x28, 0x9a, 0x2b, 0x8a, 0x04, 0x11,       // crtc registers 0-7
  0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xd4, 0x86, 0xc7, 0x14, 0x00, 0xd0, 0xfc, 0xb2, 0xff, // crtc registers 16-24
  0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0f, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 6
  0x50, 0x18, 0x08, 0x00, 0x40, // bios data
  0x01, 0x0f, 0x00, 0x06, // sequencer registers
  0x63, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x54, 0x94, 0x04, 0x11,       // crtc registers 0-7
  0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xd4, 0x86, 0xc7, 0x28, 0x00, 0xd0, 0xfc, 0xd2, 0xff, // crtc registers 16-24
  0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,       // attr registers 0-7
  0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x01, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 7
  0x50, 0x18, 0x0e, 0x00, 0x10, // bios data
  0x00, 0x0f, 0x00, 0x03, // sequencer registers
  0xa2, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x55, 0x95, 0xb6, 0x1f,       // crtc registers 0-7
  0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xb1, 0xb3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x08, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 8
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 9
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode a
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode b
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode c
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode d
  0x28, 0x18, 0x08, 0x00, 0x20, // bios data
  0x09, 0x0f, 0x00, 0x06, // sequencer registers
  0x63, // misc output registers
  0x37, 0x27, 0x28, 0x9a, 0x2b, 0x8a, 0x04, 0x11,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xd4, 0x86, 0xc7, 0x14, 0x00, 0xd0, 0xfc, 0xd3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode e
  0x50, 0x18, 0x08, 0x00, 0x40, // bios data
  0x01, 0x0f, 0x00, 0x06, // sequencer registers
  0x63, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x54, 0x94, 0x04, 0x11,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0xd4, 0x86, 0xc7, 0x28, 0x00, 0xd0, 0xfc, 0xd3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode f (64k graphics memory)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode 10 (64k graphics memory)
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// video parameter table for mode f (>64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, // bios data
  0x01, 0x0f, 0x00, 0x06, // sequencer registers
  0xa2, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x54, 0x94, 0xb6, 0x1f,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x14, 0x0f, 0x63, 0xb1, 0x9b, 0xff, // crtc registers 16-24
  0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,       // attr registers 0-7
  0x00, 0x08, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,       // attr registers 8-15
  0x0b, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 10 (>64k graphics memory)
  0x50, 0x18, 0x0e, 0x00, 0x80, // bios data
  0x01, 0x0f, 0x00, 0x06, // sequencer registers
  0xa3, // misc output registers
  0x5b, 0x4f, 0x50, 0x9e, 0x54, 0x1c, 0x4e, 0x1f,       // crtc registers 0-7
  0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x14, 0x0f, 0x63, 0x49, 0x9b, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x01, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 0 (350 lines)
  0x28, 0x18, 0x0e, 0x00, 0x08, // bios data
  0x09, 0x0f, 0x00, 0x03, // sequencer registers
  0xa3, // misc output registers
  0x37, 0x27, 0x28, 0x9a, 0x2b, 0xaa, 0x04, 0x1f,       // crtc registers 0-7
  0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x14, 0x0f, 0x63, 0xff, 0xb3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x08, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 1 (350 lines)
  0x28, 0x18, 0x0e, 0x00, 0x08, // bios data
  0x09, 0x0f, 0x00, 0x03, // sequencer registers
  0xa3, // misc output registers
  0x37, 0x27, 0x28, 0x9a, 0x2b, 0xaa, 0x04, 0x1f,       // crtc registers 0-7
  0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x14, 0x0f, 0x63, 0xff, 0xb3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x08, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 2 (350 lines)
  0x50, 0x18, 0x0e, 0x00, 0x10, // bios data
  0x01, 0x0f, 0x00, 0x03, // sequencer registers
  0xa3, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x55, 0x95, 0xb6, 0x1f,       // crtc registers 0-7
  0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xb1, 0xb3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x08, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff, // graphics registers 0-8
// video parameter table for mode 3 (350 lines)
  0x50, 0x18, 0x0e, 0x00, 0x10, // bios data
  0x01, 0x0f, 0x00, 0x03, // sequencer registers
  0xa3, // misc output registers
  0x73, 0x4f, 0x50, 0x96, 0x55, 0x95, 0xb6, 0x1f,       // crtc registers 0-7
  0x00, 0x4d, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00,       // crtc registers 8-15
  0x83, 0x85, 0x5d, 0x28, 0x0f, 0x63, 0xb1, 0xb3, 0xff, // crtc registers 16-24
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,       // attr registers 0-7
  0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,       // attr registers 8-15
  0x08, 0x00, 0x0f, 0x00, // attr registers 16-19
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x0f, 0xff // graphics registers 0-8
};


Bit16u INT10_SetupVideoParameterTable(PhysPt basepos) {
	if (IS_VGA_ARCH) {
		for (Bitu i=0;i<0x40*0x1d;i++) {
			phys_writeb(basepos+i,video_parameter_table_vga[i]);
		}
		return 0x40*0x1d;
	} else {
		for (Bitu i=0;i<0x40*0x17;i++) {
			phys_writeb(basepos+i,video_parameter_table_ega[i]);
		}
		return 0x40*0x17;
	}
}

void INT10_SetupBasicVideoParameterTable(void) {
	/* video parameter table at F000:F0A4 */
	RealSetVec(0x1d,RealMake(0xF000, 0xF0A4));
	switch (machine) {
	case MCH_TANDY:
		for (Bit16u i = 0; i < sizeof(vparams_tandy); i++) {
			phys_writeb(0xFF0A4+i,vparams_tandy[i]);
		}
		break;
	case MCH_PCJR:
		for (Bit16u i = 0; i < sizeof(vparams_pcjr); i++) {
			phys_writeb(0xFF0A4+i,vparams_pcjr[i]);
		}
		break;
	default:
		for (Bit16u i = 0; i < sizeof(vparams); i++) {
			phys_writeb(0xFF0A4+i,vparams[i]);
		}
		break;
	}
}

#if 0
void INT10_GenerateVideoParameterTable(void) {
	if (!IS_VGA_ARCH) E_Exit("Be sure that all graphics registers are readable!");
	Bitu i;
	for (i=0; i<4; i++) {
		LOG_MSG("// video parameter table for mode %x (cga emulation)",i);
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
	}
	for (i=4; i<0x0f; i++) {
		Bitu ct;
		LOG_MSG("// video parameter table for mode %x",i);
		if ((i>=8) && (i<0x0d)) {
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		} else {
			INT10_SetVideoMode(i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			Bit16u crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	for (i=0x0f; i<0x11; i++) {
		LOG_MSG("// video parameter table for mode %x (64k graphics memory)",i);
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
	}
	for (i=0x0f; i<0x11; i++) {
		Bitu ct;
		INT10_SetVideoMode(i);
		LOG_MSG("// video parameter table for mode %x (>64k graphics memory)",i);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
		Bitu seq_regs[4];
		for (ct=0; ct<4; ct++) {
			IO_WriteB(0x3c4,ct+1);
			seq_regs[ct]=IO_ReadB(0x3c5);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
		LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
		Bitu crtc_regs[0x19];
		Bit16u crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
		for (ct=0; ct<0x19; ct++) {
			IO_WriteB(crt_addr,ct);
			crtc_regs[ct]=IO_ReadB(crt_addr+1);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
			crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
			crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
			crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
			crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
			crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
			crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
		Bitu attr_regs[0x14];
		for (ct=0; ct<0x14; ct++) {
			IO_ReadB(crt_addr+6);
			IO_WriteB(0x3c0,ct);
			attr_regs[ct]=IO_ReadB(0x3c1);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
			attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
			attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
			attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
			attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
			attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
		Bitu gfx_regs[9];
		for (ct=0; ct<0x09; ct++) {
			IO_WriteB(0x3ce,ct);
			gfx_regs[ct]=IO_ReadB(0x3cf);
		}
		LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
			gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
			gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
	}
	for (i=0; i<4; i++) {
		if (IS_VGA_ARCH) {
			LOG_MSG("// video parameter table for mode %x (350 lines)",i);
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
			LOG_MSG("  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,");
		} else {
			Bitu ct;
			INT10_SetVideoMode(i);
			LOG_MSG("// video parameter table for mode %x (350 lines)",i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			Bit16u crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	if (IS_VGA_ARCH) {
		for (i=0x0e; i<0x14; i++) {
			Bitu ct=i;
			if (i==0x0e) ct=1;
			if (i==0x0f) ct=3;
			if (i==0x010) ct=7;
			INT10_SetVideoMode(ct);
			LOG_MSG("// video parameter table for mode %x",i);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // bios data",real_readb(0x40,0x4a),real_readb(0x40,0x84),real_readb(0x40,0x85),real_readb(0x40,0x4c),real_readb(0x40,0x4d));
			Bitu seq_regs[4];
			for (ct=0; ct<4; ct++) {
				IO_WriteB(0x3c4,ct+1);
				seq_regs[ct]=IO_ReadB(0x3c5);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // sequencer registers",seq_regs[0],seq_regs[1],seq_regs[2],seq_regs[3]);
			LOG_MSG("  0x%02x, // misc output registers",IO_ReadB(0x3cc));
			Bitu crtc_regs[0x19];
			Bit16u crt_addr=real_readw(BIOSMEM_SEG,BIOSMEM_CRTC_ADDRESS);
			for (ct=0; ct<0x19; ct++) {
				IO_WriteB(crt_addr,ct);
				crtc_regs[ct]=IO_ReadB(crt_addr+1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 0-7",
				crtc_regs[0x00],crtc_regs[0x01],crtc_regs[0x02],crtc_regs[0x03],
				crtc_regs[0x04],crtc_regs[0x05],crtc_regs[0x06],crtc_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // crtc registers 8-15",
				crtc_regs[0x08],crtc_regs[0x09],crtc_regs[0x0a],crtc_regs[0x0b],
				crtc_regs[0x0c],crtc_regs[0x0d],crtc_regs[0x0e],crtc_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // crtc registers 16-24",
				crtc_regs[0x10],crtc_regs[0x11],crtc_regs[0x12],crtc_regs[0x13],
				crtc_regs[0x14],crtc_regs[0x15],crtc_regs[0x16],crtc_regs[0x17],crtc_regs[0x18]);
			Bitu attr_regs[0x14];
			for (ct=0; ct<0x14; ct++) {
				IO_ReadB(crt_addr+6);
				IO_WriteB(0x3c0,ct);
				attr_regs[ct]=IO_ReadB(0x3c1);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 0-7",
				attr_regs[0x00],attr_regs[0x01],attr_regs[0x02],attr_regs[0x03],
				attr_regs[0x04],attr_regs[0x05],attr_regs[0x06],attr_regs[0x07]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x,       // attr registers 8-15",
				attr_regs[0x08],attr_regs[0x09],attr_regs[0x0a],attr_regs[0x0b],
				attr_regs[0x0c],attr_regs[0x0d],attr_regs[0x0e],attr_regs[0x0f]);
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, // attr registers 16-19",
				attr_regs[0x10],attr_regs[0x11],attr_regs[0x12],attr_regs[0x13]);
			Bitu gfx_regs[9];
			for (ct=0; ct<0x09; ct++) {
				IO_WriteB(0x3ce,ct);
				gfx_regs[ct]=IO_ReadB(0x3cf);
			}
			LOG_MSG("  0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, 0x%02x, // graphics registers 0-8",
				gfx_regs[0x00],gfx_regs[0x01],gfx_regs[0x02],gfx_regs[0x03],
				gfx_regs[0x04],gfx_regs[0x05],gfx_regs[0x06],gfx_regs[0x07],gfx_regs[0x08]);
		}
	}
	INT10_SetVideoMode(3);
	E_Exit("done!");
}
#endif 
