/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JSplitPane;
import org.fest.swing.annotation.RunsInCurrentThread;

final class HorizontalJSplitPaneDividerLocation {
    @RunsInCurrentThread
    static int locationToMoveDividerToHorizontally(JSplitPane splitPane, int desiredLocation) {
        int minimum = HorizontalJSplitPaneDividerLocation.calculateMinimum(splitPane);
        int maximum = HorizontalJSplitPaneDividerLocation.calculateMaximum(splitPane);
        if (maximum < minimum) {
            maximum = 0;
            minimum = 0;
        }
        return Math.min(maximum, Math.max(minimum, desiredLocation));
    }

    private static int calculateMinimum(JSplitPane splitPane) {
        Component left = splitPane.getLeftComponent();
        if (left == null || !left.isVisible()) {
            return 0;
        }
        int minimum = left.getMinimumSize().width;
        Insets insets = splitPane.getInsets();
        if (insets != null) {
            minimum += insets.left;
        }
        return minimum;
    }

    private static int calculateMaximum(JSplitPane splitPane) {
        Component rightComponent = splitPane.getRightComponent();
        if (splitPane.getLeftComponent() == null || rightComponent == null) {
            return -1;
        }
        Insets insets = splitPane.getInsets();
        int dividerSize = splitPane.getDividerSize();
        int right = insets != null ? insets.right : 0;
        int splitPaneWidth = splitPane.getSize().width;
        if (!rightComponent.isVisible()) {
            return Math.max(0, splitPaneWidth - (dividerSize + right));
        }
        return Math.max(0, splitPaneWidth - (dividerSize + right) - rightComponent.getMinimumSize().width);
    }

    private HorizontalJSplitPaneDividerLocation() {
    }
}

