/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.fields.IntegerField;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class JavaIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private static final String LABEL_INDENT_LABEL = ApplicationBundle.message((String)"editbox.indent.label.indent", (Object[])new Object[0]);
    private IntegerField myLabelIndent;
    private JLabel myLabelIndentLabel;
    private JCheckBox myLabelIndentAbsolute;
    private JCheckBox myCbDontIndentTopLevelMembers;
    private JCheckBox myCbUseRelativeIndent;

    protected void addComponents() {
        super.addComponents();
        this.myLabelIndent = new IntegerField(LABEL_INDENT_LABEL, 0, 32);
        this.myLabelIndent.setColumns(4);
        this.myLabelIndentLabel = new JLabel(LABEL_INDENT_LABEL);
        this.add(this.myLabelIndentLabel, (JComponent)this.myLabelIndent);
        this.myLabelIndentAbsolute = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.absolute.label.indent", (Object[])new Object[0]));
        this.add(this.myLabelIndentAbsolute, true);
        this.myCbDontIndentTopLevelMembers = new JCheckBox(ApplicationBundle.message((String)"checkbox.do.not.indent.top.level.class.members", (Object[])new Object[0]));
        this.add(this.myCbDontIndentTopLevelMembers);
        this.myCbUseRelativeIndent = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.relative.indents", (Object[])new Object[0]));
        this.add(this.myCbUseRelativeIndent);
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        CommonCodeStyleSettings javaSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        isModified |= JavaIndentOptionsEditor.isFieldModified((JTextField)this.myLabelIndent, (int)options.LABEL_INDENT_SIZE);
        isModified |= JavaIndentOptionsEditor.isFieldModified((JCheckBox)this.myLabelIndentAbsolute, (boolean)options.LABEL_INDENT_ABSOLUTE);
        isModified |= JavaIndentOptionsEditor.isFieldModified((JCheckBox)this.myCbDontIndentTopLevelMembers, (boolean)javaSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS);
        return isModified |= JavaIndentOptionsEditor.isFieldModified((JCheckBox)this.myCbUseRelativeIndent, (boolean)options.USE_RELATIVE_INDENTS);
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        options.LABEL_INDENT_SIZE = this.myLabelIndent.getValue();
        options.LABEL_INDENT_ABSOLUTE = this.myLabelIndentAbsolute.isSelected();
        CommonCodeStyleSettings javaSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        javaSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = this.myCbDontIndentTopLevelMembers.isSelected();
        options.USE_RELATIVE_INDENTS = this.myCbUseRelativeIndent.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        super.reset(settings, options);
        this.myLabelIndent.setValue(Integer.valueOf(options.LABEL_INDENT_SIZE));
        this.myLabelIndentAbsolute.setSelected(options.LABEL_INDENT_ABSOLUTE);
        CommonCodeStyleSettings javaSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        this.myCbDontIndentTopLevelMembers.setSelected(javaSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS);
        this.myCbUseRelativeIndent.setSelected(options.USE_RELATIVE_INDENTS);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLabelIndent.setEnabled(enabled);
        this.myLabelIndentLabel.setEnabled(enabled);
        this.myLabelIndentAbsolute.setEnabled(enabled);
    }
}

