/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludeTable
extends ListTableWithButtons<Item> {
    private static final Pattern ourPackagePattern = Pattern.compile("([\\w*]+\\.)*[\\w*]+");
    private static final BiFunction<Object, JComponent, ValidationInfo> validationInfoProducer = (value2, component) -> value2 == null || StringUtil.isEmpty((String)value2.toString()) || ourPackagePattern.matcher(value2.toString()).matches() ? null : new ValidationInfo("Illegal name: " + value2.toString(), component);
    private static final Disposable validatorsDisposable = Disposer.newDisposable();
    private static final ColumnInfo<Item, String> NAME_COLUMN = new ColumnInfo<Item, String>("Class/package/member qualified name mask"){

        @Nullable
        public String valueOf(Item pair) {
            return pair.exclude;
        }

        public TableCellEditor getEditor(Item pair) {
            ExtendableTextField cellEditor = new ExtendableTextField();
            cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)Boolean.TRUE);
            new ComponentValidator(validatorsDisposable).withValidator(() -> {
                String text2 = cellEditor.getText();
                boolean hasError = !StringUtil.isEmpty((String)text2) && !ourPackagePattern.matcher(text2).matches();
                ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ExtendableTextComponent.Extension)ValidationUtils.ERROR_EXTENSION, (boolean)hasError);
                return (ValidationInfo)validationInfoProducer.apply(text2, cellEditor);
            }).andRegisterOnDocumentListener((JTextComponent)cellEditor).installOn((JComponent)cellEditor);
            return new DefaultCellEditor((JTextField)cellEditor);
        }

        public TableCellRenderer getRenderer(Item pair) {
            JTextField cellEditor = new JTextField();
            cellEditor.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
            return new ValidatingTableCellRendererWrapper((TableCellRenderer)new DefaultTableCellRenderer()).withCellValidator((value2, row, column) -> (ValidationInfo)validationInfoProducer.apply(value2, null)).bindToEditorSize(cellEditor::getPreferredSize);
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item item, String value2) {
            item.exclude = value2;
        }
    };
    private static final ColumnInfo<Item, ExclusionScope> SCOPE_COLUMN = new ColumnInfo<Item, ExclusionScope>("Scope"){

        @Nullable
        public ExclusionScope valueOf(Item pair) {
            return pair.scope;
        }

        public TableCellRenderer getRenderer(Item pair) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public TableCellEditor getEditor(Item pair) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public boolean isCellEditable(Item pair) {
            return true;
        }

        public void setValue(Item pair, ExclusionScope value2) {
            pair.scope = value2;
        }

        public String getMaxStringValue() {
            return "Project";
        }

        public int getAdditionalWidth() {
            return JBUI.scale((int)12) + AllIcons.General.ArrowDown.getIconWidth();
        }
    };
    private final Project myProject;

    ExcludeTable(@NotNull Project project) {
        this.myProject = project;
        TableView table = this.getTableView();
        table.getEmptyText().setText(ApplicationBundle.message((String)"exclude.from.imports.no.exclusions", (Object[])new Object[0]));
        table.setStriped(false);
        new CellTooltipManager((Disposable)this.myProject).withCellComponentProvider(CellComponentProvider.forTable((JTable)table)).installOn((JComponent)table);
        Disposer.register((Disposable)project, (Disposable)validatorsDisposable);
    }

    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{NAME_COLUMN, SCOPE_COLUMN});
    }

    protected Item createElement() {
        return new Item("", ExclusionScope.IDE);
    }

    protected boolean isEmpty(Item element) {
        return element.exclude.isEmpty();
    }

    protected Item cloneElement(Item variable) {
        return new Item(variable.exclude, variable.scope);
    }

    protected boolean canDeleteElement(Item selection) {
        return true;
    }

    void addExcludePackage(String packageName) {
        int index;
        if (packageName == null) {
            return;
        }
        for (index = 0; index < this.getTableView().getListTableModel().getRowCount() && ((Item)this.getTableView().getListTableModel().getItem((int)index)).exclude.compareTo(packageName) <= 0; ++index) {
        }
        this.getTableView().getListTableModel().insertRow(index, (Object)new Item(packageName, ExclusionScope.IDE));
        this.getTableView().clearSelection();
        this.getTableView().addRowSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible((JTable)this.getTableView(), (int)index, (int)0);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTableView(), false);
    }

    void reset() {
        ArrayList rows = ContainerUtil.newArrayList();
        for (String s : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            rows.add(new Item(s, ExclusionScope.IDE));
        }
        for (String s : JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames) {
            rows.add(new Item(s, ExclusionScope.Project));
        }
        Collections.sort(rows, Comparator.comparing(o -> o.exclude));
        this.setValues(rows);
    }

    void apply() {
        CodeInsightSettings.getInstance().EXCLUDED_PACKAGES = ArrayUtil.toStringArray(this.getExcludedPackages(ExclusionScope.IDE));
        JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames = this.getExcludedPackages(ExclusionScope.Project);
    }

    private List<String> getExcludedPackages(ExclusionScope scope) {
        ArrayList result = ContainerUtil.newArrayList();
        for (Item pair : this.getTableView().getListTableModel().getItems()) {
            if (scope != pair.scope) continue;
            result.add(pair.exclude);
        }
        Collections.sort(result);
        return result;
    }

    boolean isModified() {
        return !this.getExcludedPackages(ExclusionScope.IDE).equals(Arrays.asList(CodeInsightSettings.getInstance().EXCLUDED_PACKAGES)) || !this.getExcludedPackages(ExclusionScope.Project).equals(JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames);
    }

    static class Item {
        String exclude;
        ExclusionScope scope;

        Item(@NotNull String exclude, ExclusionScope scope) {
            this.exclude = exclude;
            this.scope = scope;
        }
    }

    private static enum ExclusionScope {
        Project,
        IDE;

    }
}

