/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.text.CharSequenceReader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    private static final Key<Boolean> EXTERNAL_ANNO_MARKER = Key.create((String)"EXTERNAL_ANNO_MARKER");
    private static final List<PsiFile> NULL_LIST = Collections.emptyList();
    protected final PsiManager myPsiManager;
    private final ConcurrentMap<VirtualFile, List<PsiFile>> myExternalAnnotationsCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Map<AnnotationData, AnnotationData> myAnnotationDataCache = ContainerUtil.createWeakKeyWeakValueMap();
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> myAnnotationFileToDataAndModStampCache = ContainerUtil.createConcurrentSoftMap();
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<Object, AnnotationData> cache = new ConcurrentMostlySingularMultiMap();
    private final CharTableImpl charTable = new CharTableImpl();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = JavaParser.INSTANCE.getDeclarationParser()::parseAnnotation;

    public BaseExternalAnnotationsManager(@NotNull PsiManager psiManager) {
        this.myPsiManager = psiManager;
        LowMemoryWatcher.register(this::dropCache, (Disposable)psiManager.getProject());
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner) {
        return BaseExternalAnnotationsManager.getExternalName(listOwner, false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        return PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)showParamName, (int)Integer.MAX_VALUE);
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    public boolean hasAnnotationRootsForFile(@NotNull VirtualFile file) {
        return this.hasAnyAnnotationsRoots();
    }

    public boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        return annotation.getUserData(EXTERNAL_ANNO_MARKER) != null;
    }

    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<PsiAnnotation> result = this.findExternalAnnotations(listOwner, annotationFQN);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public List<PsiAnnotation> findExternalAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return this.filterAnnotations(result, annotationFQN);
    }

    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass, @NotNull String annotationFQN) {
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return this.filterAnnotations(result, annotationFQN);
    }

    @NotNull
    private List<PsiAnnotation> filterAnnotations(@NotNull List<AnnotationData> result, @NotNull String annotationFQN) {
        return (List)((StreamEx)StreamEx.of(result).filter(data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN))).map(data -> data.getAnnotation(this)).toCollection(SmartList::new);
    }

    @Nullable
    public List<PsiAnnotation> findDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        if (aClass.getConstructors().length > 0) {
            return null;
        }
        List<AnnotationData> result = this.collectDefaultConstructorExternalAnnotations(aClass);
        return (List)StreamEx.of(result).map(data -> data.getAnnotation(this)).toCollection(SmartList::new);
    }

    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        List<AnnotationData> map2 = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map2, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map2, @NotNull String annotationFQN) {
        return (AnnotationData)ContainerUtil.find(map2, data -> ((AnnotationData)data).annotationClassFqName.equals(annotationFQN));
    }

    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return result.isEmpty() ? null : (PsiAnnotation[])ContainerUtil.map2Array(result, (Object[])PsiAnnotation.EMPTY_ARRAY, data -> data.getAnnotation(this));
    }

    @NotNull
    private List<AnnotationData> collectDefaultConstructorExternalAnnotations(@NotNull PsiClass aClass) {
        List<PsiFile> annotationsFiles = this.findExternalAnnotationsFiles((PsiModifierListOwner)aClass);
        if (annotationsFiles == null) {
            return NO_DATA;
        }
        String defCtrExternalName = BaseExternalAnnotationsManager.getExternalName((PsiModifierListOwner)aClass) + " " + aClass.getName() + "()";
        return this.collectExternalAnnotations(defCtrExternalName, () -> this.doCollect(defCtrExternalName, annotationsFiles, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        return this.collectExternalAnnotations(listOwner, () -> this.doCollect(listOwner, false));
    }

    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull Object cacheKey, @NotNull Supplier<List<AnnotationData>> dataSupplier) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        if (!this.hasAnyAnnotationsRoots()) {
            return Collections.emptyList();
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(cacheKey)) != NO_DATA && cached.isEmpty()) continue;
            return cached;
        } while (!this.cache.replace(cacheKey, (Collection)cached, computed = dataSupplier.get()));
        cached = computed;
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        Map<AnnotationData, AnnotationData> map2 = this.myAnnotationDataCache;
        synchronized (map2) {
            AnnotationData interned = this.myAnnotationDataCache.get(data);
            if (interned == null) {
                this.myAnnotationDataCache.put(data, data);
                interned = data;
            }
            return interned;
        }
    }

    @NotNull
    public MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        Pair cached = (Pair)this.myAnnotationFileToDataAndModStampCache.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            return (MostlySingularMultiMap)cached.getFirst();
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(file);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource((Reader)new CharSequenceReader(BaseExternalAnnotationsManager.escapeAttributes(file.getViewProvider().getContents()))), (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error(file.getViewProvider().getVirtualFile().getPath(), (Throwable)e);
        }
        MostlySingularMultiMap<String, AnnotationData> result = handler.getResult();
        this.myAnnotationFileToDataAndModStampCache.put(file, (Pair<MostlySingularMultiMap<String, AnnotationData>, Long>)Pair.create(result, (Object)fileModificationStamp));
        return result;
    }

    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text2) {
        LOG.error(text2 + "; for signature: '" + externalName + "' in the " + file.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        CharTableImpl charTableImpl = this.charTable;
        synchronized (charTableImpl) {
            return this.charTable.doIntern((CharSequence)annotationFQN).toString();
        }
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            return NO_DATA;
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner);
        if (externalName == null) {
            return NO_DATA;
        }
        return this.doCollect(externalName, files, onlyWritable);
    }

    @NotNull
    private List<AnnotationData> doCollect(@NotNull String externalName, @NotNull List<PsiFile> annotationsFiles, boolean onlyWritable) {
        SmartList result = new SmartList();
        for (PsiFile file : annotationsFiles) {
            if (!file.isValid() || onlyWritable && !file.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file);
            ContainerUtil.addAll((Collection)result, (Iterable)fileData.get((Object)externalName));
        }
        if (result.isEmpty()) {
            return NO_DATA;
        }
        result.trimToSize();
        return result;
    }

    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        PsiFile containingFile = PsiUtil.preferCompiledElement((PsiModifierListOwner)listOwner).getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotationsCache.get(virtualFile);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (Object file : files) {
                if (file.isValid()) continue;
                allValid = false;
                break;
            }
            if (allValid) {
                return files;
            }
        }
        THashSet possibleAnnotationXmls = new THashSet();
        String relativePath = ((PsiJavaFile)containingFile).getPackageName().replace('.', '/') + '/' + "annotations.xml";
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(relativePath);
            if (ext == null || !ext.isValid() || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationXmls.add(psiFile);
        }
        if (possibleAnnotationXmls.isEmpty()) {
            this.myExternalAnnotationsCache.put(virtualFile, NULL_LIST);
            return null;
        }
        SmartList result = new SmartList((Collection)possibleAnnotationXmls);
        result.sort((f1, f2) -> {
            boolean w2;
            boolean w1 = f1.isWritable();
            return w1 == (w2 = f2.isWritable()) ? 0 : (w1 ? -1 : 1);
        });
        this.myExternalAnnotationsCache.put(virtualFile, (List<PsiFile>)result);
        return result;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotationsCache.clear();
        this.myAnnotationFileToDataAndModStampCache.clear();
        this.cache.clear();
    }

    @NotNull
    private static CharSequence escapeAttributes(@NotNull CharSequence invalidXml) {
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value2) throws ExternalAnnotationsManager.CanceledConfigurationException {
        throw new UnsupportedOperationException();
    }

    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        throw new UnsupportedOperationException();
    }

    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value2) {
        throw new UnsupportedOperationException();
    }

    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        throw new UnsupportedOperationException();
    }

    protected void registerExternalAnnotations(@NotNull PsiFile fromFile, @NotNull PsiFile annotationsFile) {
        VirtualFile virtualFile = fromFile.getVirtualFile();
        if (virtualFile != null) {
            this.myExternalAnnotationsCache.compute(virtualFile, (k, v) -> {
                if (v == null || v == NULL_LIST) {
                    return new SmartList((Object)annotationsFile);
                }
                v.add(annotationsFile);
                return v;
            });
        }
    }

    private static PsiAnnotation markAsExternalAnnotation(@NotNull PsiAnnotation annotation) {
        annotation.putUserData(EXTERNAL_ANNO_MARKER, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text2) throws IncorrectOperationException {
        CharTableImpl charTableImpl = this.charTable;
        synchronized (charTableImpl) {
            DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myPsiManager, (TreeElement)new JavaDummyElement(text2, ANNOTATION, LanguageLevel.HIGHEST), null, (CharTable)this.charTable);
            PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
            if (!(element instanceof PsiAnnotation)) {
                throw new IncorrectOperationException("Incorrect annotation \"" + text2 + "\".");
            }
            return BaseExternalAnnotationsManager.markAsExternalAnnotation((PsiAnnotation)element);
        }
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> myData = new MostlySingularMultiMap();
        private final PsiFile myFile;
        private String myExternalName;
        private String myAnnotationFqn;
        private StringBuilder myArguments;

        private DataParsingSaxHandler(PsiFile file) {
            this.myFile = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.myExternalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.myAnnotationFqn = attributes.getValue("name");
                this.myArguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.myArguments.length() != 0) {
                    this.myArguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.myArguments.append(name);
                    this.myArguments.append("=");
                }
                this.myArguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("item".equals(qName)) {
                this.myExternalName = null;
            } else if ("annotation".equals(qName) && this.myExternalName != null && this.myAnnotationFqn != null) {
                String argumentsString = this.myArguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.myArguments.toString());
                for (AnnotationData existingData : this.myData.get((Object)this.myExternalName)) {
                    if (!existingData.annotationClassFqName.equals(this.myAnnotationFqn)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.myFile, this.myExternalName, "Duplicate annotation '" + this.myAnnotationFqn + "'");
                }
                AnnotationData data = new AnnotationData(this.myAnnotationFqn, argumentsString);
                this.myData.add((Object)this.myExternalName, (Object)BaseExternalAnnotationsManager.this.internAnnotationData(data));
                this.myAnnotationFqn = null;
                this.myArguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.myData.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.myData.compact();
            return this.myData;
        }
    }

    public static class AnnotationData {
        private final String annotationClassFqName;
        private final String annotationParameters;
        private volatile PsiAnnotation myAnnotation;

        private AnnotationData(@NotNull String fqn, @NotNull String parameters2) {
            this.annotationClassFqName = fqn;
            this.annotationParameters = parameters2;
        }

        @NotNull
        public PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            PsiAnnotation a = this.myAnnotation;
            if (a == null) {
                String text2 = "@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")");
                this.myAnnotation = a = context.createAnnotationFromText(text2);
            }
            return a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result = this.annotationClassFqName.hashCode();
            result = 31 * result + this.annotationParameters.hashCode();
            return result;
        }

        public String toString() {
            return this.annotationClassFqName + "(" + this.annotationParameters + ")";
        }
    }
}

