/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(PsiElement ... elements) {
        List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(elements);
        if (exceptions.isEmpty()) {
            return exceptions;
        }
        exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        return exceptions;
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(@NotNull List<? extends PsiClassType> exceptions) {
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiClassType psiClassType : exceptions) {
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            array.add(psiClassType);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        final ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            Visitor() {
            }

            public void visitElement(PsiElement psiElement) {
                PsiElement parent;
                if (psiElement != element && (parent = psiElement.getParent()) instanceof PsiAnonymousClass && !(psiElement instanceof PsiExpressionList)) {
                    return;
                }
                super.visitElement(psiElement);
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                this.visitElement((PsiElement)aClass);
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                PsiExpression expr = statement.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result, StreamEx.of((Collection)ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            public void visitTryStatement(PsiTryStatement statement) {
                ExceptionUtil.addExceptions(result, ExceptionUtil.getTryExceptions(statement));
            }
        }
        element.accept((PsiElementVisitor)new Visitor());
        return result;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        ArrayList array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiCodeBlock[] resource : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, (PsiElement)resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        for (PsiResourceListElement psiResourceListElement : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiResourceListElement.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom((PsiType)exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)psiCodeBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions((PsiElement)finallyBlock);
                if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        return array;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes = method.getThrowsList().getReferencedTypes();
        if (referenceTypes.length == 0) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClassType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)type2), scope)) instanceof PsiClassType)) continue;
            result.add(type2);
        }
        return result;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<? extends PsiClassType> exceptions) {
        for (PsiClassType psiClassType : exceptions) {
            ExceptionUtil.addException(array, psiClassType);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom((PsiType)exception)) {
                return;
            }
            if (!exception.isAssignableFrom((PsiType)exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @NotNull PsiCallExpression skippedCall) {
        return ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, c -> c == skippedCall));
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        return ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        return ContainerUtil.notNullize(ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls ? c -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        }));
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, @NotNull Predicate<? super PsiCallExpression> callFilter) {
        AbstractCollection unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2 = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression2 != null ? ExceptionUtil.collectUnhandledExceptions((PsiElement)qualifierExpression2, topElement, null, callFilter) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer.getBody(), (PsiElement)initializer, (Set<PsiClassType>)thrownByInitializer, callFilter);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.getHandlePlace((PsiElement)constructor.getBody(), thrown, topElement) != HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, callFilter);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod) {
            PsiElement referenceNameElement2 = methodReferenceExpression.getReferenceNameElement();
            return ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, referenceNameElement2, topElement, () -> ((JavaResolveResult)resolveResult).getSubstitutor());
        }
        return Collections.emptyList();
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        final ArrayList array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitClass(PsiClass aClass) {
            }
        };
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)visitor);
        }
        return array;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                return ExceptionUtil.getUnhandledExceptions(method, element, null, () -> PsiSubstitutor.EMPTY);
            }
            return Collections.emptyList();
        }
        if (element instanceof PsiCallExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
        }
        if (element instanceof PsiThrowStatement) {
            return ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
        }
        if (element instanceof PsiMethodReferenceExpression) {
            return ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
        }
        if (element instanceof PsiResourceListElement) {
            return ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement element) {
        return ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        return ExceptionUtil.getUnhandledExceptions(methodCall, topElement, c -> false);
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCallExpression> skipCondition) {
        PsiClassType[] thrownExceptions;
        PsiMethod method;
        if (MethodCandidateInfo.isOverloadCheck()) {
            return Collections.emptyList();
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)methodCall.getArgumentList());
        MethodCandidateInfo result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)methodCall);
        PsiElement element = result.getElement();
        PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : null;
        if (method == null) {
            return Collections.emptyList();
        }
        if (skipCondition.test((PsiCallExpression)methodCall)) {
            return Collections.emptyList();
        }
        if (properties != null) {
            PsiUtilCore.ensureValid((PsiElement)method);
        }
        if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
            return Collections.emptyList();
        }
        if (!ExceptionUtil.isArrayClone(method, (PsiElement)methodCall) && methodCall instanceof PsiMethodCallExpression) {
            PsiFile containingFile = methodCall.getContainingFile();
            MethodResolverProcessor processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
            try {
                PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                List candidates = ContainerUtil.mapNotNull(processor.getResults(), info -> {
                    PsiElement element1 = info.getElement();
                    if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)((PsiMethod)element1)) && !((PsiMethod)element1).hasModifierProperty("private") && !MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)element1), (PsiMethod)method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
                        return Pair.create((Object)((PsiMethod)element1), (Object)((MethodCandidateInfo)info).getSubstitutor(false));
                    }
                    return null;
                });
                if (!candidates.isEmpty()) {
                    GlobalSearchScope scope = methodCall.getResolveScope();
                    List<PsiClassType> ex = ExceptionUtil.collectSubstituted(result.getSubstitutor(), thrownExceptions, scope);
                    for (Pair pair : candidates) {
                        PsiClassType[] exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            return Collections.emptyList();
                        }
                        ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                    }
                    return ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
                }
            }
            catch (MethodProcessorSetupFailedException ignore) {
                return Collections.emptyList();
            }
        }
        return ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, () -> ((JavaResolveResult)result).getSubstitutor());
    }

    public static void retainExceptions(List<PsiClassType> ex, List<? extends PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator = ex.iterator();
        while (iterator.hasNext()) {
            PsiClassType classType = iterator.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom((PsiType)classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom((PsiType)psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex = ExceptionUtil.getExceptionsFromClose(resource);
        return ex != null ? ex : Collections.emptyList();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        PsiType type2 = resource.getType();
        return ExceptionUtil.getUnhandledCloserExceptions((PsiElement)resource, topElement, type2);
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        return ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods = PsiUtil.getResourceCloserMethodsForType((PsiClassType)((PsiClassType)type2));
        if (methods != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods) {
                PsiSubstitutor substitutor;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)closerClass, (PsiClass)resourceClass, (PsiSubstitutor)resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        SmartList unhandled = new SmartList();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiType upperBound;
                PsiClassType classType = null;
                if (subType instanceof PsiClassType) {
                    classType = (PsiClassType)subType;
                } else if (subType instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)subType).getUpperBound()) instanceof PsiClassType) {
                    classType = (PsiClassType)upperBound;
                }
                if (classType == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace((PsiElement)throwStatement, classType, topElement) != HandlePlace.UNHANDLED) continue;
                unhandled.add(classType);
            }
        }
        return unhandled;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter((PsiElement)target)) {
            return ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            return Collections.singletonList(type2);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull Supplier<PsiSubstitutor> substitutor) {
        if (ExceptionUtil.isArrayClone(method, element)) {
            return Collections.emptyList();
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        if (referencedTypes.length == 0) {
            return Collections.emptyList();
        }
        return ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor.get(), referencedTypes);
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute((PsiType)referencedType), (boolean)false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.getHandlePlace(element, classType, topElement) != HandlePlace.UNHANDLED) continue;
                result.add((PsiClassType)type2);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (!method.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression2 = methodCallExpression.getQualifierExpression();
            return qualifierExpression2 != null && qualifierExpression2.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression3 = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression3 != null && qualifierExpression3.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Error");
    }

    public static boolean isUncheckedException(@NotNull PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        return ExceptionUtil.isGeneralExceptionType((PsiType)type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText = type2.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(@NotNull PsiClassType exceptionType, @NotNull PsiElement throwPlace) {
        return ExceptionUtil.getHandlePlace(throwPlace, exceptionType, (PsiElement)throwPlace.getContainingFile()) != HandlePlace.UNHANDLED;
    }

    @NotNull
    public static HandlePlace getHandlePlace(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, @Nullable PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return HandlePlace.UNHANDLED;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return HandlePlace.fromBoolean(ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType));
        }
        if (parent instanceof PsiClass) {
            if (!(parent instanceof PsiAnonymousClass)) {
                return HandlePlace.UNHANDLED;
            }
            return ExceptionUtil.getHandlePlace(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression || parent instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent).getFunctionalInterfaceType();
            return HandlePlace.fromBoolean(ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType));
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return HandlePlace.UNHANDLED;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
            }
        } else if (parent instanceof PsiTryStatement) {
            HandlePlace place;
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                return place;
            }
            if (tryStatement.getResourceList() == element && (place = ExceptionUtil.getCaughtPlace(tryStatement, exceptionType)) != HandlePlace.UNHANDLED) {
                return place;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return HandlePlace.UNKNOWN;
            }
        } else {
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return HandlePlace.fromBoolean(exceptionHandler != null && exceptionHandler.isHandledException(exceptionType));
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return HandlePlace.UNKNOWN;
            }
            if (parent instanceof PsiFile) {
                return HandlePlace.fromBoolean(false);
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                    return HandlePlace.fromBoolean(ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType));
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : CustomExceptionHandler.KEY.getExtensionList()) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return HandlePlace.UNKNOWN;
                }
            }
        }
        return ExceptionUtil.getHandlePlace(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)interfaceType)))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    @NotNull
    private static HandlePlace getCaughtPlace(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return HandlePlace.UNKNOWN;
        }
        for (PsiParameter parameter2 : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter2.getType();
            if (!paramType.isAssignableFrom((PsiType)exceptionType)) continue;
            return new HandlePlace.TryCatch(tryStatement, parameter2);
        }
        return HandlePlace.UNHANDLED;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, PsiSubstitutor.EMPTY);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(@NotNull List<? extends PsiClassType> exceptions) {
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable((PsiType)((PsiType)exceptions.get(i)), (PsiType)((PsiType)exceptions.get(i + 1)))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }

    public static interface HandlePlace {
        public static final HandlePlace UNHANDLED = new HandlePlace(){};
        public static final HandlePlace UNKNOWN = new HandlePlace(){};

        public static HandlePlace fromBoolean(boolean isHandled) {
            return isHandled ? UNKNOWN : UNHANDLED;
        }

        public static class TryCatch
        implements HandlePlace {
            private final PsiTryStatement myTryStatement;
            private final PsiParameter myParameter;

            public TryCatch(PsiTryStatement statement, PsiParameter parameter2) {
                this.myTryStatement = statement;
                this.myParameter = parameter2;
            }

            public PsiTryStatement getTryStatement() {
                return this.myTryStatement;
            }

            public PsiParameter getParameter() {
                return this.myParameter;
            }
        }
    }
}

