/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeInfoImpl
implements ExpectedTypeInfo {
    public static final NullableComputable<String> NULL = () -> null;
    @NotNull
    private final PsiType type;
    @NotNull
    private final PsiType defaultType;
    private final int kind;
    @NotNull
    private final TailType myTailType;
    private final PsiMethod myCalledMethod;
    @NotNull
    private final NullableComputable<String> expectedNameComputable;
    @NotNull
    private final NullableLazyValue<String> expectedNameLazyValue;

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public TailType getTailType() {
        return this.myTailType;
    }

    public ExpectedTypeInfoImpl(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, @NotNull PsiType defaultType, @NotNull TailType myTailType, PsiMethod calledMethod, @NotNull NullableComputable<String> expectedName) {
        this.type = type2;
        this.kind = kind2;
        this.myTailType = myTailType;
        this.defaultType = defaultType;
        this.myCalledMethod = calledMethod;
        this.expectedNameComputable = expectedName;
        this.expectedNameLazyValue = new VolatileNullableLazyValue<String>(){

            @Nullable
            protected String compute() {
                return (String)ExpectedTypeInfoImpl.this.expectedNameComputable.compute();
            }
        };
        PsiUtil.ensureValidType((PsiType)type2);
        PsiUtil.ensureValidType((PsiType)defaultType);
    }

    @Nullable
    public String getExpectedName() {
        return (String)this.expectedNameLazyValue.getValue();
    }

    @Override
    public PsiMethod getCalledMethod() {
        return this.myCalledMethod;
    }

    @Override
    @NotNull
    public PsiType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PsiType getDefaultType() {
        return this.defaultType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpectedTypeInfoImpl)) {
            return false;
        }
        ExpectedTypeInfoImpl that = (ExpectedTypeInfoImpl)o;
        if (this.kind != that.kind) {
            return false;
        }
        if (!this.defaultType.equals(that.defaultType)) {
            return false;
        }
        if (!this.myTailType.equals(that.myTailType)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.defaultType.hashCode();
        result = 31 * result + this.kind;
        result = 31 * result + this.myTailType.hashCode();
        return result;
    }

    @Override
    public boolean equals(ExpectedTypeInfo obj) {
        return this.equals((Object)obj);
    }

    @Override
    public String toString() {
        return "ExpectedTypeInfo[type='" + this.type + "' kind='" + this.kind + "']";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ExpectedTypeInfo[] intersect(@NotNull ExpectedTypeInfo info) {
        ExpectedTypeInfoImpl info1 = (ExpectedTypeInfoImpl)info;
        if (this.kind == 0) {
            if (info1.kind != 0) return info1.intersect(this);
            if (!info1.type.equals(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (this.kind == 1) {
            if (info1.kind == 0) {
                if (!this.type.isAssignableFrom(info1.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
                return new ExpectedTypeInfoImpl[]{info1};
            }
            if (info1.kind != 1) return info1.intersect(this);
            PsiType otherType = info1.type;
            if (this.type.isAssignableFrom(otherType)) {
                return new ExpectedTypeInfoImpl[]{info1};
            }
            if (!otherType.isAssignableFrom(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (this.kind != 2) return ExpectedTypeInfo.EMPTY_ARRAY;
        if (info1.kind == 0) {
            if (!info1.type.isAssignableFrom(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{info1};
        }
        if (info1.kind == 1) {
            if (!info1.type.isAssignableFrom(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (info1.kind != 2) return info1.intersect(this);
        PsiType otherType = info1.type;
        if (this.type.isAssignableFrom(otherType)) {
            return new ExpectedTypeInfoImpl[]{this};
        }
        if (!otherType.isAssignableFrom(this.type)) return ExpectedTypeInfo.EMPTY_ARRAY;
        return new ExpectedTypeInfoImpl[]{info1};
    }
}

