/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.MakeExternalAnnotationExplicit;
import com.intellij.codeInsight.MakeInferredAnnotationExplicit;
import com.intellij.codeInsight.ToggleSourceInferredAnnotations;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.AnnotateIntentionAction;
import com.intellij.codeInsight.intention.impl.DeannotateIntentionAction;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.NonCodeAnnotationGenerator;
import com.intellij.codeInspection.dataFlow.EditContractIntention;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Function<PsiElement, String> ourTooltipProvider = nameIdentifier -> {
        PsiModifierListOwner owner = (PsiModifierListOwner)nameIdentifier.getParent();
        return XmlStringUtil.wrapInHtml((CharSequence)(NonCodeAnnotationGenerator.getNonCodeHeader(NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(owner).values()) + " available. Full signature:<p>\n" + JavaDocInfoGenerator.generateSignature((PsiElement)owner)));
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(element);
        if (owner == null) {
            return null;
        }
        boolean includeSourceInferred = CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS;
        boolean hasAnnotationsToShow = ContainerUtil.exists((Iterable)NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(owner).values(), a -> includeSourceInferred || !a.isInferredFromSource());
        if (!hasAnnotationsToShow) {
            return null;
        }
        return new LineMarkerInfo(element, element.getTextRange(), AllIcons.Gutter.ExtAnnotation, 11, ourTooltipProvider, (GutterIconNavigationHandler)MyIconGutterHandler.INSTANCE, GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    static PsiModifierListOwner getAnnotationOwner(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement owner = element.getParent();
        if (!(owner instanceof PsiModifierListOwner) || !(owner instanceof PsiNameIdentifierOwner)) {
            return null;
        }
        if (owner instanceof PsiParameter || owner instanceof PsiLocalVariable) {
            return null;
        }
        PsiElement nameIdentifier = ((PsiNameIdentifierOwner)owner).getNameIdentifier();
        if (nameIdentifier == null || !nameIdentifier.getTextRange().equals((Object)element.getTextRange())) {
            return null;
        }
        return (PsiModifierListOwner)owner;
    }

    @NotNull
    public String getName() {
        return "External annotations";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.ExtAnnotation;
    }

    private static class MyIconGutterHandler
    implements GutterIconNavigationHandler<PsiElement> {
        static final MyIconGutterHandler INSTANCE = new MyIconGutterHandler();

        private MyIconGutterHandler() {
        }

        public void navigate(MouseEvent e, PsiElement nameIdentifier) {
            Project project;
            Editor editor;
            PsiElement listOwner = nameIdentifier.getParent();
            PsiFile containingFile = listOwner.getContainingFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)listOwner);
            if (virtualFile != null && containingFile != null && (editor = FileEditorManager.getInstance((Project)(project = listOwner.getProject())).getSelectedTextEditor()) != null) {
                JBPopup popup;
                editor.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (file != null && virtualFile.equals(file.getVirtualFile()) && (popup = MyIconGutterHandler.createActionGroupPopup(containingFile, project, editor)) != null) {
                    popup.show(new RelativePoint(e));
                }
            }
        }

        @Nullable
        private static JBPopup createActionGroupPopup(PsiFile file, Project project, Editor editor) {
            List actions = ((StreamEx)((StreamEx)StreamEx.of((Object[])new List[]{MyIconGutterHandler.getMethodActions(file, project, editor), MyIconGutterHandler.getParameterAnnotationActions(file, project, editor)}).remove(List::isEmpty)).intersperse(Collections.singletonList(Separator.create()))).toFlatList(l -> l);
            if (!actions.isEmpty()) {
                DefaultActionGroup group = new DefaultActionGroup(actions);
                DataContext context = SimpleDataContext.getProjectContext(null);
                return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            }
            return null;
        }

        @NotNull
        private static List<AnAction> getMethodActions(PsiFile file, Project project, Editor editor) {
            Comparator<IntentionAction> comparator = Comparator.comparing(action -> action instanceof PriorityAction ? ((PriorityAction)action).getPriority() : PriorityAction.Priority.NORMAL).thenComparing(IntentionAction::getText);
            return Stream.of(IntentionManager.getInstance().getAvailableIntentionActions()).map(action -> action instanceof IntentionActionDelegate ? ((IntentionActionDelegate)action).getDelegate() : action).filter(action -> MyIconGutterHandler.shouldShowInGutterPopup(action) && action.isAvailable(project, editor, file)).sorted(comparator).map(action -> new ApplyIntentionAction(action, action.getText(), editor, file)).collect(Collectors.toList());
        }

        @NotNull
        private static List<AnAction> getParameterAnnotationActions(final @NotNull PsiFile file, final Project project, Editor editor) {
            PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
            if (leaf == null) {
                return Collections.emptyList();
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)leaf.getParent(), PsiMethod.class);
            if (method == null) {
                return Collections.emptyList();
            }
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
            int n = psiParameterArray.length;
            for (int i = 0; i < n; ++i) {
                final MakeInferredAnnotationExplicit intention = new MakeInferredAnnotationExplicit();
                final PsiParameter parameter2 = psiParameterArray[i];
                if (!intention.isAvailable(project, file, (PsiModifierListOwner)parameter2)) continue;
                actions.add(new AnAction(intention.getText() + " on parameter '" + parameter2.getName() + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                        intention.makeAnnotationsExplicit(project, file, (PsiModifierListOwner)parameter2);
                    }
                });
            }
            return actions;
        }

        private static boolean shouldShowInGutterPopup(IntentionAction action) {
            return action instanceof AnnotateIntentionAction || action instanceof DeannotateIntentionAction || action instanceof EditContractIntention || action instanceof ToggleSourceInferredAnnotations || action instanceof MakeInferredAnnotationExplicit || action instanceof MakeExternalAnnotationExplicit;
        }
    }
}

