/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.InferredAnnotationProvider;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferredAnnotationsManagerImpl
extends InferredAnnotationsManager {
    private static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    private final Project myProject;

    public InferredAnnotationsManagerImpl(Project project) {
        this.myProject = project;
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        for (InferredAnnotationProvider provider : InferredAnnotationProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            PsiAnnotation annotation = provider.findInferredAnnotation(listOwner, annotationFQN);
            if (annotation == null) continue;
            InferredAnnotationsManagerImpl.markInferred(annotation);
            return annotation;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        ArrayList result = ContainerUtil.newArrayList();
        for (InferredAnnotationProvider provider : InferredAnnotationProvider.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            List annotations2 = provider.findInferredAnnotations(listOwner);
            for (PsiAnnotation annotation : annotations2) {
                InferredAnnotationsManagerImpl.markInferred(annotation);
                result.add(annotation);
            }
        }
        return result.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    public boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        return annotation.getUserData(INFERRED_ANNOTATION) != null;
    }

    private static void markInferred(@NotNull PsiAnnotation annotation) {
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
    }
}

