/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaProjectCodeInsightSettings", storages={@Storage(value="codeInsightSettings.xml")})
public class JavaProjectCodeInsightSettings
implements PersistentStateComponent<JavaProjectCodeInsightSettings> {
    private static final ConcurrentMap<String, Pattern> ourPatterns = ConcurrentFactoryMap.createWeakMap(PatternUtil::fromMask);
    @XCollection(propertyElementName="excluded-names", elementName="name", valueAttributeName="")
    public List<String> excludedNames = ContainerUtil.newArrayList();

    public static JavaProjectCodeInsightSettings getSettings(@NotNull Project project) {
        return (JavaProjectCodeInsightSettings)ServiceManager.getService((Project)project, JavaProjectCodeInsightSettings.class);
    }

    public boolean isExcluded(@NotNull String name) {
        for (String excluded : this.excludedNames) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name, excluded)) continue;
            return true;
        }
        for (String excluded : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name, excluded)) continue;
            return true;
        }
        return false;
    }

    private static boolean nameMatches(@NotNull String name, String excluded) {
        int length = JavaProjectCodeInsightSettings.getMatchingLength(name, excluded);
        return length > 0 && (name.length() == length || name.charAt(length) == '.');
    }

    private static int getMatchingLength(@NotNull String name, String excluded) {
        Matcher matcher;
        if (name.startsWith(excluded)) {
            return excluded.length();
        }
        if (excluded.indexOf(42) >= 0 && (matcher = ((Pattern)ourPatterns.get(excluded)).matcher(name)).lookingAt()) {
            return matcher.end();
        }
        return -1;
    }

    @Nullable
    public JavaProjectCodeInsightSettings getState() {
        return this;
    }

    public void loadState(@NotNull JavaProjectCodeInsightSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static void setExcludedNames(Project project, Disposable parentDisposable, String ... excludes) {
        final JavaProjectCodeInsightSettings instance = JavaProjectCodeInsightSettings.getSettings(project);
        assert (instance.excludedNames.isEmpty());
        instance.excludedNames = Arrays.asList(excludes);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                instance.excludedNames = ContainerUtil.newArrayList();
            }
        });
    }
}

