/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeExternalAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return "Make External Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Object[] annotations2;
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner != null && owner.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeExternalAnnotationExplicit.isWritable(owner) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && (annotations2 = this.getAnnotations(project, owner)).length > 0) {
            String annos = StringUtil.join((Object[])annotations2, annotation -> {
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                String name = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
                return "@" + name + annotation.getParameterList().getText();
            }, (String)" ");
            this.setText("Insert '" + annos + "'");
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        assert (owner != null);
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file, owner, externalAnnotationsManager))) {
            return;
        }
        for (PsiAnnotation anno : this.getAnnotations(project, owner)) {
            String qname = anno.getQualifiedName();
            assert (qname != null);
            externalAnnotationsManager.deannotate(owner, qname);
            WriteCommandAction.runWriteCommandAction((Project)project, () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)anno, null))));
        }
    }

    public static List<PsiFile> getFilesToWrite(PsiFile file, PsiModifierListOwner owner, ExternalAnnotationsManager externalAnnotationsManager) {
        List files = externalAnnotationsManager.findExternalAnnotationsFiles(owner);
        if (files != null) {
            ArrayList<PsiFile> elements = new ArrayList<PsiFile>(files);
            elements.add(file);
            return elements;
        }
        return Collections.singletonList(file);
    }

    @NotNull
    private PsiAnnotation[] getAnnotations(@NotNull Project project, PsiModifierListOwner owner) {
        PsiAnnotation[] annotations2 = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotations(owner);
        if (annotations2 == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return (PsiAnnotation[])Arrays.stream(annotations2).filter(anno -> {
            String qualifiedName = anno.getQualifiedName();
            return qualifiedName != null && facade.findClass(qualifiedName, owner.getResolveScope()) != null && !owner.hasAnnotation(qualifiedName);
        }).toArray(PsiAnnotation[]::new);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isWritable(PsiModifierListOwner owner) {
        if (owner instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner);
        return vFile != null && vFile.isInLocalFileSystem();
    }
}

