/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return "Make Inferred Annotations Explicit";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        if (leaf == null) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        return this.isAvailable(project, file, owner);
    }

    public boolean isAvailable(@NotNull Project project, PsiFile file, PsiModifierListOwner owner) {
        String annotations2;
        if (owner != null && owner.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && !(annotations2 = ((StreamEx)StreamEx.of((Object[])InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)).remove(DefaultInferredAnnotationProvider::isExperimentalInferredAnnotation)).map(MakeInferredAnnotationExplicit::getAnnotationPresentation).joining((CharSequence)" ")).isEmpty()) {
            this.setText("Insert '" + annotations2 + "'");
            return true;
        }
        return false;
    }

    @NotNull
    private static String getAnnotationPresentation(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
        String name = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
        return "@" + name + annotation.getParameterList().getText();
    }

    private static boolean isWritable(PsiModifierListOwner owner) {
        if (owner instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        assert (leaf != null);
        PsiModifierListOwner owner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        assert (owner != null);
        this.makeAnnotationsExplicit(project, file, owner);
    }

    public void makeAnnotationsExplicit(@NotNull Project project, PsiFile file, PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        assert (modifierList != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner)) {
            if (DefaultInferredAnnotationProvider.isExperimentalInferredAnnotation(inferred)) continue;
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project, Collections.singleton(module), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)toInsert, null))));
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        Project project = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            return facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
        }
        return annotation;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

