/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NullableNotNullManager")
public class NullableNotNullManagerImpl
extends NullableNotNullManager
implements PersistentStateComponent<Element>,
ModificationTracker {
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";
    private static final String INSTRUMENTED_NOT_NULLS_TAG = "instrumentedNotNulls";
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList(Arrays.asList(DEFAULT_NULLABLES));
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList(Arrays.asList(DEFAULT_NOT_NULLS));
    private List<String> myInstrumentedNotNulls = ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"});
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();

    public NullableNotNullManagerImpl(Project project) {
        super(project);
    }

    public void setNotNulls(String ... annotations2) {
        this.myNotNulls.clear();
        Collections.addAll(this.myNotNulls, annotations2);
        this.normalizeDefaults();
    }

    public void setNullables(String ... annotations2) {
        this.myNullables.clear();
        Collections.addAll(this.myNullables, annotations2);
        this.normalizeDefaults();
    }

    @NotNull
    public String getDefaultNullable() {
        return this.myDefaultNullable;
    }

    public void setDefaultNullable(@NotNull String defaultNullable) {
        LOG.assertTrue(this.getNullables().contains(defaultNullable));
        this.myDefaultNullable = defaultNullable;
        this.myTracker.incModificationCount();
    }

    @NotNull
    public String getDefaultNotNull() {
        return this.myDefaultNotNull;
    }

    public void setDefaultNotNull(@NotNull String defaultNotNull) {
        LOG.assertTrue(this.getNotNulls().contains(defaultNotNull));
        this.myDefaultNotNull = defaultNotNull;
        this.myTracker.incModificationCount();
    }

    @NotNull
    public List<String> getNullables() {
        return Collections.unmodifiableList(this.myNullables);
    }

    @NotNull
    public List<String> getNotNulls() {
        return Collections.unmodifiableList(this.myNotNulls);
    }

    @NotNull
    public List<String> getInstrumentedNotNulls() {
        return Collections.unmodifiableList(this.myInstrumentedNotNulls);
    }

    public void setInstrumentedNotNulls(@NotNull List<String> names) {
        this.myInstrumentedNotNulls = ContainerUtil.sorted(names);
        this.myTracker.incModificationCount();
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        return HardcodedContracts.hasHardcodedContracts(element);
    }

    public Element getState() {
        Element component = new Element("component");
        if (!this.hasDefaultValues()) {
            try {
                DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)component);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myInstrumentedNotNulls.size() != 1 || !"org.jetbrains.annotations.NotNull".equals(this.myInstrumentedNotNulls.get(0))) {
            Element instrumentedNotNulls = new Element(INSTRUMENTED_NOT_NULLS_TAG);
            for (String value2 : this.myInstrumentedNotNulls) {
                instrumentedNotNulls.addContent(new Element("option").setAttribute("value", value2));
            }
            component.addContent(instrumentedNotNulls);
        }
        return component;
    }

    private boolean hasDefaultValues() {
        return "org.jetbrains.annotations.NotNull".equals(this.myDefaultNotNull) && "org.jetbrains.annotations.Nullable".equals(this.myDefaultNullable) && new HashSet(this.myNullables).equals(ContainerUtil.newHashSet((Object[])DEFAULT_NULLABLES)) && new HashSet(this.myNotNulls).equals(ContainerUtil.newHashSet((Object[])DEFAULT_NOT_NULLS));
    }

    public void loadState(@NotNull Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)state);
            this.normalizeDefaults();
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        Element instrumented = state.getChild(INSTRUMENTED_NOT_NULLS_TAG);
        this.myInstrumentedNotNulls = instrumented == null ? ContainerUtil.newArrayList((Object[])new String[]{"org.jetbrains.annotations.NotNull"}) : ContainerUtil.mapNotNull((Collection)instrumented.getChildren("option"), o -> o.getAttributeValue("value"));
    }

    private void normalizeDefaults() {
        this.myNotNulls.removeAll((Collection)ContainerUtil.newHashSet((Object[])DEFAULT_NULLABLES));
        this.myNullables.removeAll((Collection)ContainerUtil.newHashSet((Object[])DEFAULT_NOT_NULLS));
        this.myNullables.addAll((Collection)ContainerUtil.filter((Object[])DEFAULT_NULLABLES, s -> !this.myNullables.contains(s)));
        this.myNotNulls.addAll((Collection)ContainerUtil.filter((Object[])DEFAULT_NOT_NULLS, s -> !this.myNotNulls.contains(s)));
        this.myTracker.incModificationCount();
    }

    @NotNull
    private List<PsiClass> getAllNullabilityNickNames() {
        if (!this.getNotNulls().contains("javax.annotation.Nonnull")) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            PsiClass[] nickDeclarations;
            ArrayList<PsiClass> result = new ArrayList<PsiClass>();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            for (PsiClass tqNick : nickDeclarations = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(TYPE_QUALIFIER_NICKNAME, scope)) {
                result.addAll(ContainerUtil.findAll((Collection)MetaAnnotationUtil.getChildren((PsiClass)tqNick, (GlobalSearchScope)scope), NullableNotNullManagerImpl::isNullabilityNickName));
            }
            if (nickDeclarations.length == 0) {
                result.addAll(this.getUnresolvedNicknameUsages());
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    private List<PsiClass> getUnresolvedNicknameUsages() {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        Collection<PsiAnnotation> annotations2 = JavaAnnotationIndex.getInstance().get(StringUtil.getShortName((String)TYPE_QUALIFIER_NICKNAME), this.myProject, GlobalSearchScope.allScope((Project)this.myProject));
        for (PsiAnnotation annotation : annotations2) {
            PsiClass ownerClass;
            PsiElement context = annotation.getContext();
            if (!(context instanceof PsiModifierList) || !(context.getContext() instanceof PsiClass) || !(ownerClass = (PsiClass)context.getContext()).isAnnotationType() || !NullableNotNullManagerImpl.isNullabilityNickName(ownerClass)) continue;
            result.add(ownerClass);
        }
        return result;
    }

    protected NullabilityAnnotationInfo isJsr305Default(@NotNull PsiAnnotation annotation, @NotNull PsiAnnotation.TargetType[] placeTargetTypes) {
        PsiModifierList modList;
        PsiClass declaration2 = NullableNotNullManagerImpl.resolveAnnotationType(annotation);
        PsiModifierList psiModifierList = modList = declaration2 == null ? null : declaration2.getModifierList();
        if (modList == null) {
            return null;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)declaration2, (boolean)true, (String[])new String[]{"javax.annotation.meta.TypeQualifierDefault"});
        if (tqDefault == null) {
            return null;
        }
        Set required = AnnotationTargetUtil.extractRequiredAnnotationTargets((PsiAnnotationMemberValue)tqDefault.findAttributeValue(null));
        if (required == null || !required.isEmpty() && !ContainerUtil.intersects((Collection)required, Arrays.asList(placeTargetTypes))) {
            return null;
        }
        for (PsiAnnotation qualifier : modList.getAnnotations()) {
            Nullability nullability = this.getJsr305QualifierNullability(qualifier);
            if (nullability == null) continue;
            return new NullabilityAnnotationInfo(annotation, nullability, true);
        }
        return null;
    }

    @Nullable
    private static PsiClass resolveAnnotationType(@NotNull PsiAnnotation annotation) {
        PsiElement declaration2;
        PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
        PsiElement psiElement = declaration2 = element == null ? null : element.resolve();
        if (!(declaration2 instanceof PsiClass) || !((PsiClass)declaration2).isAnnotationType()) {
            return null;
        }
        return (PsiClass)declaration2;
    }

    @Nullable
    private Nullability getJsr305QualifierNullability(@NotNull PsiAnnotation qualifier) {
        String qName = qualifier.getQualifiedName();
        if (qName == null || !qName.startsWith("javax.annotation.")) {
            return null;
        }
        if (qName.equals("javax.annotation.Nullable") && this.getNullables().contains(qName)) {
            return Nullability.NULLABLE;
        }
        if (qName.equals("javax.annotation.Nonnull")) {
            return NullableNotNullManagerImpl.extractNullityFromWhenValue(qualifier);
        }
        return null;
    }

    private static boolean isNullabilityNickName(@NotNull PsiClass candidate) {
        String qname = candidate.getQualifiedName();
        if (qname == null || qname.startsWith("javax.annotation.")) {
            return false;
        }
        return NullableNotNullManagerImpl.getNickNamedNullability(candidate) != Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            return Nullability.UNKNOWN;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.annotation.Nonnull"});
        return nonNull != null ? NullableNotNullManagerImpl.extractNullityFromWhenValue(nonNull) : Nullability.UNKNOWN;
    }

    @NotNull
    private static Nullability extractNullityFromWhenValue(@NotNull PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when = nonNull.findAttributeValue("when");
        if (when instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                return Nullability.NOT_NULL;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                return Nullability.NULLABLE;
            }
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    private List<String> filterNickNames(@NotNull Nullability nullability) {
        return ContainerUtil.mapNotNull(this.getAllNullabilityNickNames(), c -> NullableNotNullManagerImpl.getNickNamedNullability(c) == nullability ? c.getQualifiedName() : null);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNullables(), this.filterNickNames(Nullability.NULLABLE)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat(this.getNotNulls(), this.filterNickNames(Nullability.NOT_NULL)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }
}

