/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityAnnotationModifier
extends TypeAnnotationModifier {
    @Nullable
    public TypeAnnotationProvider boundAppeared(@NotNull PsiType inferenceVariableType, @NotNull PsiType boundType) {
        PsiAnnotation[] annotations2;
        for (PsiAnnotation annotation : annotations2 = inferenceVariableType.getAnnotations()) {
            if (!NullityAnnotationModifier.isMatchingNullityAnnotation(boundType, annotation)) continue;
            return NullityAnnotationModifier.removeAnnotation(annotations2, annotation);
        }
        return null;
    }

    private static boolean isMatchingNullityAnnotation(@NotNull PsiType boundType, PsiAnnotation annotation) {
        String qName = annotation.getQualifiedName();
        return qName != null && (NullableNotNullManager.isNullableAnnotation((PsiAnnotation)annotation) || NullableNotNullManager.isNotNullAnnotation((PsiAnnotation)annotation)) && boundType.hasAnnotation(qName);
    }

    @Nullable
    public TypeAnnotationProvider modifyLowerBoundAnnotations(@NotNull PsiType lowerBound, @NotNull PsiType upperBound) {
        PsiAnnotation[] lowerAnnotations = lowerBound.getAnnotations();
        PsiAnnotation nullable = NullityAnnotationModifier.findNullable(lowerAnnotations);
        if (nullable != null && NullityAnnotationModifier.findNullable(upperBound.getAnnotations()) == null) {
            return NullityAnnotationModifier.removeAnnotation(lowerAnnotations, nullable);
        }
        return null;
    }

    private static PsiAnnotation findNullable(PsiAnnotation[] annotations2) {
        return (PsiAnnotation)ContainerUtil.find((Object[])annotations2, NullableNotNullManager::isNullableAnnotation);
    }

    @NotNull
    private static TypeAnnotationProvider removeAnnotation(PsiAnnotation[] annotations2, PsiAnnotation annotation) {
        ArrayList list = ContainerUtil.newArrayList((Object[])annotations2);
        list.remove(annotation);
        return TypeAnnotationProvider.Static.create((PsiAnnotation[])list.toArray(PsiAnnotation.EMPTY_ARRAY));
    }
}

