/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ToggleSourceInferredAnnotations
extends BaseIntentionAction
implements LowPriorityAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return "Show/Hide Gutter Icon for Annotations Inferred from Source Code";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiModifierListOwner owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf);
        if (owner != null) {
            boolean hasSrcInferredAnnotation = ContainerUtil.exists(AnnotationDocGenerator.getAnnotationsToShow(owner), AnnotationDocGenerator::isInferredFromSource);
            if (!hasSrcInferredAnnotation && owner instanceof PsiMethod) {
                hasSrcInferredAnnotation = StreamEx.of((Object[])((PsiMethod)owner).getParameterList().getParameters()).flatCollection(AnnotationDocGenerator::getAnnotationsToShow).anyMatch(AnnotationDocGenerator::isInferredFromSource);
            }
            if (hasSrcInferredAnnotation) {
                this.setText((CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS ? "Hide" : "Show") + " gutter icon for annotations inferred from source code");
                return true;
            }
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        final boolean showAnnotations = !CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS;
        ToggleSourceInferredAnnotations.showAnnotations(project, file, showAnnotations);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file.getVirtualFile()}){

            public void undo() {
                ToggleSourceInferredAnnotations.showAnnotations(project, file, !showAnnotations);
            }

            public void redo() {
                ToggleSourceInferredAnnotations.showAnnotations(project, file, showAnnotations);
            }
        });
    }

    private static void showAnnotations(@NotNull Project project, PsiFile file, boolean showAnnotations) {
        CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS = showAnnotations;
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

