/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CheckInitialized
implements ElementFilter {
    private final Set<PsiField> myNonInitializedFields;
    private final boolean myInsideConstructorCall;

    CheckInitialized(@NotNull PsiElement position) {
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myInsideConstructorCall = CheckInitialized.isInsideConstructorCall(position);
    }

    static boolean isInsideConstructorCall(@NotNull PsiElement position) {
        return JavaPsiConstructorUtil.isConstructorCall((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class)) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)position);
    }

    private static boolean isInitializedImplicitly(PsiField field) {
        field = (PsiField)CompletionUtil.getOriginalOrSelf((PsiElement)field);
        for (ImplicitUsageProvider provider : (ImplicitUsageProvider[])ImplicitUsageProvider.EP_NAME.getExtensions()) {
            if (!provider.isImplicitWrite((PsiElement)field)) continue;
            return true;
        }
        return false;
    }

    static Set<PsiField> getNonInitializedFields(PsiElement element) {
        final PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiReferenceExpression.class});
        if (ref == null) {
            return Collections.emptySet();
        }
        final PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        if (statement == null || method == null || !method.isConstructor()) {
            return Collections.emptySet();
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)parent)) {
            return Collections.emptySet();
        }
        while (parent != statement) {
            PsiStatement psiStatement;
            PsiElement next = parent.getParent();
            if (next instanceof PsiAssignmentExpression && parent == ((PsiAssignmentExpression)next).getLExpression()) {
                return Collections.emptySet();
            }
            if (parent instanceof PsiJavaCodeReferenceElement && (psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class)) != null && psiStatement.getTextRange().getStartOffset() == parent.getTextRange().getStartOffset()) {
                return Collections.emptySet();
            }
            parent = next;
        }
        boolean allowNonFinalFields = !CheckInitialized.isInsideConstructorCall(element);
        final HashSet<PsiField> fields = new HashSet<PsiField>();
        PsiClass containingClass = method.getContainingClass();
        assert (containingClass != null);
        InheritanceUtil.processSupers((PsiClass)containingClass, (boolean)true, eachClass -> {
            for (PsiField field : eachClass.getFields()) {
                if (CheckInitialized.seemsInitialized(allowNonFinalFields, containingClass, field)) continue;
                fields.add(field);
            }
            return true;
        });
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiElement target;
                PsiExpression lExpression = expression2.getLExpression();
                if (lExpression instanceof PsiReferenceExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)lExpression) && (target = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField) {
                    if (expression2.getTextRange().getStartOffset() < statement.getTextRange().getStartOffset()) {
                        fields.remove(target);
                    } else if (ref == PsiUtil.deparenthesizeExpression((PsiExpression)expression2.getRExpression())) {
                        fields.add((PsiField)target);
                    }
                }
                super.visitAssignmentExpression(expression2);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodExpression;
                if (expression2.getTextRange().getStartOffset() < statement.getTextRange().getStartOffset() && (methodExpression = expression2.getMethodExpression()).textMatches((CharSequence)"this")) {
                    fields.clear();
                }
                super.visitMethodCallExpression(expression2);
            }
        });
        return fields;
    }

    private static boolean seemsInitialized(boolean allowNonFinalFields, PsiClass placeClass, PsiField field) {
        if (field.hasModifierProperty("static")) {
            return true;
        }
        if (field.getContainingClass() == placeClass && (CheckInitialized.isInitializedBeforeConstructor(field, placeClass) || CheckInitialized.isInitializedImplicitly(field))) {
            return true;
        }
        return allowNonFinalFields && !field.hasModifierProperty("final");
    }

    private static boolean isInitializedBeforeConstructor(PsiField field, PsiClass containingClass) {
        if (field.getInitializer() != null) {
            return true;
        }
        return ContainerUtil.exists((Object[])containingClass.getInitializers(), i -> !i.hasModifierProperty("static") && VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)i, false));
    }

    public boolean isAcceptable(Object element, @Nullable PsiElement context) {
        if (element instanceof CandidateInfo) {
            element = ((CandidateInfo)element).getElement();
        }
        if (element instanceof PsiField) {
            return !this.myNonInitializedFields.contains(element);
        }
        if (element instanceof PsiMethod && this.myInsideConstructorCall) {
            return ((PsiMethod)element).hasModifierProperty("static");
        }
        return true;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }
}

