/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaClassNameInsertHandler
implements InsertHandler<JavaPsiClassReferenceElement> {
    static final InsertHandler<JavaPsiClassReferenceElement> JAVA_CLASS_INSERT_HANDLER = new JavaClassNameInsertHandler();

    JavaClassNameInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull JavaPsiClassReferenceElement item) {
        boolean fillTypeArgs;
        int offset = context.getTailOffset() - 1;
        PsiFile file = context.getFile();
        if (PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiImportStatementBase.class, (boolean)false) != null) {
            PsiJavaCodeReferenceElement ref = JavaClassNameInsertHandler.findJavaReference(file, offset);
            String qname = item.getQualifiedName();
            if (!(qname == null || ref != null && qname.equals(ref.getCanonicalText()))) {
                AllClassesGetter.INSERT_FQN.handleInsert(context, (LookupElement)item);
            }
            return;
        }
        PsiElement position = file.findElementAt(offset);
        PsiJavaCodeReferenceElement ref = position != null && position.getParent() instanceof PsiJavaCodeReferenceElement ? (PsiJavaCodeReferenceElement)position.getParent() : null;
        PsiClass psiClass = item.getObject();
        Project project = context.getProject();
        Editor editor = context.getEditor();
        char c = context.getCompletionChar();
        if (c == '#') {
            context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(project, editor));
        } else if (c == '.' && PsiTreeUtil.getParentOfType((PsiElement)position, PsiParameterList.class) == null) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
        String qname = psiClass.getQualifiedName();
        if (qname != null && PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class, (boolean)false) != null && (ref == null || !ref.isQualified()) && JavaClassNameInsertHandler.shouldInsertFqnInJavadoc(item, file)) {
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)qname);
            return;
        }
        if (ref != null && PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocTag.class) != null && ref.isReferenceTo((PsiElement)psiClass)) {
            return;
        }
        OffsetKey refEnd = context.trackOffset(context.getTailOffset(), true);
        boolean bl = fillTypeArgs = context.getCompletionChar() == '<';
        if (fillTypeArgs) {
            context.setAddCompletionChar(false);
        }
        if (ref == null || !ref.isQualified()) {
            PsiTypeLookupItem.addImportForItem(context, psiClass);
        }
        if (!context.getOffsetMap().containsOffset(refEnd)) {
            return;
        }
        context.setTailOffset(context.getOffset(refEnd));
        refEnd = context.trackOffset(context.getTailOffset(), false);
        context.commitDocument();
        if (item.getUserData(JavaChainLookupElement.CHAIN_QUALIFIER) == null && JavaClassNameInsertHandler.shouldInsertParentheses(file.findElementAt(context.getTailOffset() - 1))) {
            if (context.getCompletionChar() == '\t') {
                JavaClassNameInsertHandler.overwriteTopmostReference(context);
                context.commitDocument();
            }
            if (ConstructorInsertHandler.insertParentheses(context, (LookupElement)item, psiClass, false)) {
                fillTypeArgs |= psiClass.hasTypeParameters() && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5);
            }
        } else if (JavaClassNameInsertHandler.insertingAnnotation(context, (LookupElement)item)) {
            if (JavaClassNameInsertHandler.shouldHaveAnnotationParameters(psiClass)) {
                JavaCompletionUtil.insertParentheses(context, (LookupElement)item, false, true);
            }
            if (context.getCompletionChar() == '\n' || context.getCompletionChar() == '\r') {
                CharSequence text2 = context.getDocument().getCharsSequence();
                int tail = context.getTailOffset();
                if (text2.length() > tail && Character.isLetter(text2.charAt(tail))) {
                    context.getDocument().insertString(tail, (CharSequence)" ");
                }
            }
        }
        if (fillTypeArgs && context.getCompletionChar() != '(') {
            JavaCompletionUtil.promptTypeArgs(context, context.getOffset(refEnd));
        } else if (context.getCompletionChar() == '\r' && psiClass.getTypeParameters().length == 1 && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5)) {
            JavaClassNameInsertHandler.wrapFollowingTypeInGenerics(context, context.getOffset(refEnd));
        }
    }

    private static void wrapFollowingTypeInGenerics(InsertionContext context, int refEnd) {
        PsiTypeElement typeElem = (PsiTypeElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)refEnd, PsiTypeElement.class, (boolean)false);
        if (typeElem != null) {
            int typeEnd = typeElem.getTextRange().getEndOffset();
            context.getDocument().insertString(typeEnd, (CharSequence)">");
            context.getEditor().getCaretModel().moveToOffset(typeEnd + 1);
            context.getDocument().insertString(refEnd, (CharSequence)"<");
            context.setAddCompletionChar(false);
        }
    }

    @Nullable
    static PsiJavaCodeReferenceElement findJavaReference(@NotNull PsiFile file, int offset) {
        return (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
    }

    static void overwriteTopmostReference(InsertionContext context) {
        context.commitDocument();
        PsiJavaCodeReferenceElement ref = JavaClassNameInsertHandler.findJavaReference(context.getFile(), context.getTailOffset() - 1);
        if (ref != null) {
            while (ref.getParent() instanceof PsiJavaCodeReferenceElement) {
                ref = (PsiJavaCodeReferenceElement)ref.getParent();
            }
            context.getDocument().deleteString(context.getTailOffset(), ref.getTextRange().getEndOffset());
        }
    }

    private static boolean shouldInsertFqnInJavadoc(@NotNull JavaPsiClassReferenceElement item, @NotNull PsiFile file) {
        JavaCodeStyleSettings javaSettings = JavaCodeStyleSettings.getInstance(file);
        switch (javaSettings.CLASS_NAMES_IN_JAVADOC) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 1: {
                if (!(file instanceof PsiJavaFile)) break;
                PsiJavaFile javaFile = (PsiJavaFile)file;
                return item.getQualifiedName() != null && !ImportHelper.isAlreadyImported(javaFile, item.getQualifiedName());
            }
        }
        return false;
    }

    private static boolean shouldInsertParentheses(PsiElement position) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiJavaCodeReferenceElement.class);
        if (ref == null) {
            return false;
        }
        PsiReferenceParameterList parameterList = ref.getParameterList();
        if (parameterList != null && parameterList.getTextLength() > 0) {
            return false;
        }
        PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)ref);
        if (prevElement != null && prevElement.getParent() instanceof PsiNewExpression) {
            return !JavaClassNameInsertHandler.isArrayTypeExpected((PsiExpression)prevElement.getParent());
        }
        return false;
    }

    static boolean isArrayTypeExpected(PsiExpression expr) {
        return ContainerUtil.exists((Object[])ExpectedTypesProvider.getExpectedTypes(expr, true), info -> info.getType() instanceof PsiArrayType);
    }

    private static boolean insertingAnnotation(InsertionContext context, LookupElement item) {
        Object obj = item.getObject();
        if (!(obj instanceof PsiClass) || !((PsiClass)obj).isAnnotationType()) {
            return false;
        }
        PsiElement leaf = context.getFile().findElementAt(context.getStartOffset());
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiAnnotation.class);
        return anno != null && PsiTreeUtil.isAncestor((PsiElement)anno.getNameReferenceElement(), (PsiElement)leaf, (boolean)false);
    }

    static boolean shouldHaveAnnotationParameters(PsiClass annoClass) {
        for (PsiMethod m : annoClass.getMethods()) {
            if (!PsiUtil.isAnnotationMethod((PsiElement)m) || ((PsiAnnotationMethod)m).getDefaultValue() != null) continue;
            return true;
        }
        return false;
    }
}

