/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private final Set<String> myKeywords = new HashSet<String>();
    private final MultiMap<CompletionResultSet, LookupElement> myBatchItems = MultiMap.create();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result) {
        this.myResult = result;
    }

    void registerBatchItems(CompletionResultSet result, Collection<? extends LookupElement> elements) {
        this.myBatchItems.putValues((Object)result, elements);
    }

    void flushBatchItems() {
        for (Map.Entry entry : this.myBatchItems.entrySet()) {
            ((CompletionResultSet)entry.getKey()).addAllElements((Iterable)entry.getValue());
        }
        this.myBatchItems.clear();
    }

    public void addClassItem(LookupElement lookupElement) {
        if (!this.myResult.getPrefixMatcher().prefixMatches(lookupElement)) {
            return;
        }
        this.registerClassFrom(lookupElement);
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    void registerClassFrom(LookupElement lookupElement) {
        PsiClass psiClass = JavaCompletionSession.extractClass(lookupElement);
        if (psiClass != null) {
            this.registerClass(psiClass);
        }
    }

    @NotNull
    PrefixMatcher getMatcher() {
        return this.myResult.getPrefixMatcher();
    }

    @Nullable
    private static PsiClass extractClass(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            return (PsiClass)object;
        }
        if (object instanceof PsiMethod && ((PsiMethod)object).isConstructor()) {
            return ((PsiMethod)object).getContainingClass();
        }
        return null;
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        String name = psiClass.getQualifiedName();
        return name == null ? psiClass.getName() : name;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        PsiClass psiClass = JavaCompletionSession.extractClass(element);
        return psiClass != null && this.alreadyProcessed(psiClass);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        String name = JavaCompletionSession.getClassName(object);
        return name == null || this.myAddedClasses.contains(name);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        return this.myKeywords.contains(keyword);
    }

    void registerKeyword(@NotNull String keyword) {
        this.myKeywords.add(keyword);
    }
}

