/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CollectionsUtilityMethodsProvider;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.BetterPrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNoVariantsDelegator
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        boolean empty;
        ResultTracker tracker = new ResultTracker(result){

            @Override
            public void consume(CompletionResult plainResult) {
                super.consume(plainResult);
                LookupElement element = plainResult.getLookupElement();
                if (element instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
                    ((TypeArgumentCompletionProvider.TypeArgsLookupElement)element).registerSingleClass(this.session);
                }
            }
        };
        result.runRemainingContributors(parameters2, (Consumer)tracker);
        boolean bl = empty = tracker.containsOnlyPackages || JavaNoVariantsDelegator.suggestAllAnnotations(parameters2);
        if (JavaCompletionContributor.isClassNamePossible(parameters2) && !JavaCompletionContributor.mayStartClassName(result)) {
            result.restartCompletionOnAnyPrefixChange();
        }
        if (empty) {
            JavaNoVariantsDelegator.delegate(parameters2, JavaCompletionSorting.addJavaSorting(parameters2, result), tracker.session);
        } else if (Registry.is((String)"ide.completion.show.better.matching.classes") && parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName(result) && JavaCompletionContributor.isClassNamePossible(parameters2)) {
            JavaNoVariantsDelegator.suggestNonImportedClasses(parameters2, JavaCompletionSorting.addJavaSorting(parameters2, result.withPrefixMatcher((PrefixMatcher)tracker.betterMatcher)), tracker.session);
        }
    }

    private static boolean suggestAllAnnotations(CompletionParameters parameters2) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)parameters2.getPosition());
    }

    private static void delegate(CompletionParameters parameters2, CompletionResultSet result, JavaCompletionSession session) {
        if (parameters2.getCompletionType() == CompletionType.BASIC) {
            PsiElement position = parameters2.getPosition();
            JavaNoVariantsDelegator.suggestCollectionUtilities(parameters2, result, position);
            if (parameters2.getInvocationCount() <= 1 && (JavaCompletionContributor.mayStartClassName(result) || JavaNoVariantsDelegator.suggestAllAnnotations(parameters2)) && JavaCompletionContributor.isClassNamePossible(parameters2)) {
                JavaNoVariantsDelegator.suggestNonImportedClasses(parameters2, result, session);
                return;
            }
            JavaNoVariantsDelegator.suggestChainedCalls(parameters2, result, position);
        }
        if (parameters2.getCompletionType() == CompletionType.SMART && parameters2.getInvocationCount() == 2) {
            result.runRemainingContributors(parameters2.withInvocationCount(3), true);
        }
    }

    private static void suggestCollectionUtilities(CompletionParameters parameters2, CompletionResultSet result, PsiElement position) {
        if (StringUtil.isNotEmpty((String)result.getPrefixMatcher().getPrefix())) {
            for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                new CollectionsUtilityMethodsProvider(position, info.getType(), info.getDefaultType(), (Consumer<? super LookupElement>)result).addCompletions(true);
            }
        }
    }

    private static void suggestChainedCalls(CompletionParameters parameters2, CompletionResultSet result, PsiElement position) {
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement) || parent.getParent() instanceof PsiImportStatementBase) {
            return;
        }
        PsiElement qualifier = ((PsiJavaCodeReferenceElement)parent).getQualifier();
        if (!(qualifier instanceof PsiJavaCodeReferenceElement) || ((PsiJavaCodeReferenceElement)qualifier).isQualified()) {
            return;
        }
        PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
        if (target != null && !(target instanceof PsiPackage)) {
            return;
        }
        PsiFile file = position.getContainingFile();
        if (file instanceof PsiJavaCodeReferenceCodeFragment) {
            return;
        }
        String fullPrefix = parent.getText().substring(0, parameters2.getOffset() - parent.getTextRange().getStartOffset());
        CompletionResultSet qualifiedCollector = result.withPrefixMatcher(fullPrefix);
        ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
        for (LookupElement base : JavaNoVariantsDelegator.suggestQualifierItems(parameters2, (PsiJavaCodeReferenceElement)qualifier, filter)) {
            String separator;
            PsiReferenceExpression ref;
            PsiType type2 = JavaCompletionUtil.getLookupElementType(base);
            if (type2 == null || PsiType.VOID.equals((Object)type2) || (ref = ReferenceExpressionCompletionContributor.createMockReference(position, type2, base, separator = parent instanceof PsiMethodReferenceExpression ? "::" : ".")) == null) continue;
            for (LookupElement item : JavaSmartCompletionContributor.completeReference(position, (PsiJavaCodeReferenceElement)ref, filter, true, true, parameters2, result.getPrefixMatcher())) {
                qualifiedCollector.addElement(JavaCompletionUtil.highlightIfNeeded(null, (LookupElement)new JavaChainLookupElement(base, item, separator), item.getObject(), position));
            }
        }
    }

    private static Set<LookupElement> suggestQualifierItems(CompletionParameters parameters2, PsiJavaCodeReferenceElement qualifier, ElementFilter filter) {
        String referenceName = qualifier.getReferenceName();
        if (referenceName == null) {
            return Collections.emptySet();
        }
        CamelHumpMatcher qMatcher = new CamelHumpMatcher(referenceName);
        Set<LookupElement> plainVariants = JavaSmartCompletionContributor.completeReference((PsiElement)qualifier, qualifier, filter, true, true, parameters2, (PrefixMatcher)qMatcher);
        for (PsiClass aClass : PsiShortNamesCache.getInstance((Project)qualifier.getProject()).getClassesByName(referenceName, qualifier.getResolveScope())) {
            plainVariants.add((LookupElement)JavaClassNameCompletionContributor.createClassLookupItem(aClass, true));
        }
        if (!plainVariants.isEmpty()) {
            return plainVariants;
        }
        LinkedHashSet<LookupElement> allClasses = new LinkedHashSet<LookupElement>();
        PsiElement qualifierName = qualifier.getReferenceNameElement();
        if (qualifierName != null) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2.withPosition(qualifierName, qualifierName.getTextRange().getEndOffset()), true, (PrefixMatcher)qMatcher, (Consumer<? super LookupElement>)new CollectConsumer(allClasses));
        }
        return allClasses;
    }

    private static void suggestNonImportedClasses(CompletionParameters parameters2, CompletionResultSet result, @Nullable JavaCompletionSession session) {
        JavaClassNameCompletionContributor.addAllClasses(parameters2, true, result.getPrefixMatcher(), (Consumer<? super LookupElement>)((Consumer)element -> {
            if (session != null && session.alreadyProcessed((LookupElement)element)) {
                return;
            }
            JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)element.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
            if (classElement != null) {
                classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
            }
            result.addElement(element);
        }));
    }

    public static class ResultTracker
    implements Consumer<CompletionResult> {
        private final CompletionResultSet myResult;
        public final JavaCompletionSession session;
        public boolean containsOnlyPackages = true;
        public BetterPrefixMatcher betterMatcher;

        public ResultTracker(CompletionResultSet result) {
            this.myResult = result;
            this.betterMatcher = new BetterPrefixMatcher.AutoRestarting(result);
            this.session = new JavaCompletionSession(result);
        }

        public void consume(CompletionResult plainResult) {
            this.myResult.passResult(plainResult);
            LookupElement element = plainResult.getLookupElement();
            if (this.containsOnlyPackages && !(CompletionUtil.getTargetElement((LookupElement)element) instanceof PsiPackage)) {
                this.containsOnlyPackages = false;
            }
            this.session.registerClassFrom(element);
            this.betterMatcher = this.betterMatcher.improve(plainResult);
        }
    }
}

