/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberLookupHelper {
    private final PsiMember myMember;
    private final boolean myMergedOverloads;
    @Nullable
    private final PsiClass myContainingClass;
    private boolean myShouldImport;

    public MemberLookupHelper(List<? extends PsiMethod> overloads, PsiClass containingClass, boolean shouldImport) {
        this((PsiMember)overloads.get(0), containingClass, shouldImport, true);
    }

    public MemberLookupHelper(PsiMember member, @Nullable PsiClass containingClass, boolean shouldImport, boolean mergedOverloads) {
        this.myMember = member;
        this.myContainingClass = containingClass;
        this.myShouldImport = shouldImport;
        this.myMergedOverloads = mergedOverloads;
    }

    public PsiMember getMember() {
        return this.myMember;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public void setShouldBeImported(boolean shouldImportStatic) {
        this.myShouldImport = shouldImportStatic;
    }

    public boolean willBeImported() {
        return this.myShouldImport;
    }

    public void renderElement(LookupElementPresentation presentation, boolean showClass, boolean showPackage, PsiSubstitutor substitutor) {
        String location;
        String className = this.myContainingClass == null ? "???" : this.myContainingClass.getName();
        String memberName = this.myMember.getName();
        if (showClass && StringUtil.isNotEmpty((String)className)) {
            presentation.setItemText(className + "." + memberName);
        } else {
            presentation.setItemText(memberName);
        }
        String qname = this.myContainingClass == null ? "" : this.myContainingClass.getQualifiedName();
        String pkg = qname == null ? "" : StringUtil.getPackageName((String)qname);
        String string = location = showPackage && StringUtil.isNotEmpty((String)pkg) ? " (" + pkg + ")" : "";
        String params = this.myMergedOverloads ? "(...)" : (this.myMember instanceof PsiMethod ? MemberLookupHelper.getMethodParameterString((PsiMethod)this.myMember, substitutor) : "");
        presentation.clearTail();
        presentation.appendTailText(params, false);
        if (this.myShouldImport && StringUtil.isNotEmpty((String)className)) {
            presentation.appendTailText(" in " + className + location, true);
        } else {
            presentation.appendTailText(location, true);
        }
        PsiType declaredType = this.myMember instanceof PsiMethod ? ((PsiMethod)this.myMember).getReturnType() : ((PsiField)this.myMember).getType();
        PsiType type2 = this.patchGetClass(substitutor.substitute(declaredType));
        if (type2 != null) {
            presentation.setTypeText(substitutor.substitute(type2).getPresentableText());
        }
    }

    @Nullable
    private PsiType patchGetClass(@Nullable PsiType type2) {
        if (this.myMember instanceof PsiMethod && PsiTypesUtil.isGetClass((PsiMethod)((PsiMethod)this.myMember)) && type2 instanceof PsiClassType) {
            PsiType bound;
            PsiType arg = (PsiType)ContainerUtil.getFirstItem(Arrays.asList(((PsiClassType)type2).getParameters()));
            PsiType psiType = bound = arg instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)((PsiWildcardType)arg).getExtendsBound()) : null;
            if (bound != null) {
                return PsiTypesUtil.createJavaLangClassType((PsiElement)this.myMember, (PsiType)bound, (boolean)false);
            }
        }
        return type2;
    }

    @NotNull
    static String getMethodParameterString(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (int)256, (int)3);
    }
}

