/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReturnTypeProvider
extends CompletionProvider<CompletionParameters> {
    protected static final ElementPattern<PsiElement> IN_METHOD_RETURN_TYPE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiMethod.class})).andNot(JavaKeywordCompletion.AFTER_DOT);

    MethodReturnTypeProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        MethodReturnTypeProvider.addProbableReturnTypes(parameters2, (Consumer<? super LookupElement>)result);
    }

    static void addProbableReturnTypes(@NotNull CompletionParameters parameters2, final Consumer<? super LookupElement> consumer) {
        final PsiElement position = parameters2.getPosition();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class);
        assert (method != null);
        PsiTypeVisitor<PsiType> eachProcessor = new PsiTypeVisitor<PsiType>(){
            private final Set<PsiType> myProcessed = ContainerUtil.newHashSet();

            @Nullable
            public PsiType visitType(PsiType type2) {
                if (!(type2 instanceof PsiPrimitiveType) && PsiTypesUtil.isDenotableType((PsiType)type2, (PsiElement)position) && this.myProcessed.add(type2)) {
                    int priority = type2.equalsToText("java.lang.Object") ? 1 : 1000 - this.myProcessed.size();
                    consumer.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)PsiTypeLookupItem.createLookupItem(type2, position), (double)priority));
                }
                return type2;
            }
        };
        for (PsiType type2 : MethodReturnTypeProvider.getReturnTypeCandidates(method)) {
            eachProcessor.visitType(type2);
            ExpectedTypesProvider.processAllSuperTypes(type2, (PsiTypeVisitor<? extends PsiType>)eachProcessor, position.getProject(), new HashSet(), new HashSet());
        }
    }

    private static PsiType[] getReturnTypeCandidates(@NotNull PsiMethod method) {
        PsiType[] psiTypeArray;
        PsiPrimitiveType lub = null;
        boolean hasVoid = false;
        for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiMethod)method)) {
            PsiExpression value2 = statement.getReturnValue();
            if (value2 == null) {
                hasVoid = true;
                continue;
            }
            PsiType type2 = value2.getType();
            if (lub == null) {
                lub = type2;
                continue;
            }
            if (type2 == null) continue;
            lub = GenericsUtil.getLeastUpperBound((PsiType)lub, (PsiType)type2, (PsiManager)method.getManager());
        }
        if (hasVoid && lub == null) {
            lub = PsiType.VOID;
        }
        if (lub instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)lub).getConjuncts();
        }
        if (lub == null) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
        } else {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = lub;
        }
        return psiTypeArray;
    }
}

