/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaDocCompletionContributor;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.KnownElementWeigher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferByKindWeigher
extends LookupElementWeigher {
    public static final Key<Boolean> INTRODUCED_VARIABLE = Key.create((String)"INTRODUCED_VARIABLE");
    private static final ElementPattern<PsiElement> IN_CATCH_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiCatchSection.class), PsiJavaPatterns.psiElement(PsiVariable.class).withParent(PsiCatchSection.class)}))));
    private static final ElementPattern<PsiElement> IN_MULTI_CATCH_TYPE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiCatchSection.class)), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiParameter.class)).withSuperParent(3, PsiCatchSection.class))});
    private static final ElementPattern<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaElementType.THROWS_LIST));
    static final ElementPattern<PsiElement> IN_RESOURCE = PsiJavaPatterns.psiElement().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiTypeElement.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiResourceVariable.class), PsiJavaPatterns.psiElement(PsiResourceList.class)})), PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiResourceExpression.class)}));
    private static final Function<PsiClass, MyResult> PREFER_THROWABLE = psiClass -> PreferByKindWeigher.preferClassIf(InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable"));
    private final CompletionType myCompletionType;
    private final PsiElement myPosition;
    private final Set<PsiField> myNonInitializedFields;
    private final Function<PsiClass, MyResult> myClassSuitability;
    private final ExpectedTypeInfo[] myExpectedTypes;

    public PreferByKindWeigher(CompletionType completionType, PsiElement position, ExpectedTypeInfo[] expectedTypes) {
        super("kind");
        this.myCompletionType = completionType;
        this.myPosition = position;
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myClassSuitability = PreferByKindWeigher.createSuitabilityCondition(position);
        this.myExpectedTypes = expectedTypes;
    }

    @NotNull
    private static Function<PsiClass, MyResult> createSuitabilityCondition(PsiElement position) {
        if (PreferByKindWeigher.isExceptionPosition(position)) {
            PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class});
            ArrayList thrownExceptions = ContainerUtil.newArrayList();
            if (container != null) {
                PsiElement block;
                Object object = block = container instanceof PsiTryStatement ? ((PsiTryStatement)container).getTryBlock() : container;
                if (block != null) {
                    for (PsiClassType type2 : ExceptionUtil.getThrownExceptions(block)) {
                        ContainerUtil.addIfNotNull((Collection)thrownExceptions, (Object)type2.resolve());
                    }
                }
            }
            return psiClass -> {
                if (ContainerUtil.exists((Iterable)thrownExceptions, t -> InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)t, (boolean)true))) {
                    return MyResult.verySuitableClass;
                }
                return PREFER_THROWABLE.apply((PsiClass)psiClass);
            };
        }
        if (JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position)) {
            return PREFER_THROWABLE;
        }
        if (IN_RESOURCE.accepts((Object)position)) {
            return psiClass -> PreferByKindWeigher.preferClassIf(InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.AutoCloseable"));
        }
        PsiElement parent = position.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement) {
            PsiElement refParent = parent.getParent();
            if (refParent instanceof PsiAnnotation) {
                PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)((PsiAnnotation)refParent).getOwner());
                return psiClass -> PreferByKindWeigher.preferClassIf(psiClass.isAnnotationType() && AnnotationTargetUtil.findAnnotationTarget((PsiClass)psiClass, (PsiAnnotation.TargetType[])targets) != null);
            }
            if (refParent instanceof PsiTypeElement) {
                List<PsiClass> bounds = PreferByKindWeigher.getTypeBounds((PsiTypeElement)refParent);
                return psiClass -> PreferByKindWeigher.preferClassIf(ContainerUtil.exists((Iterable)bounds, bound -> InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)bound, (boolean)true)));
            }
        }
        return aClass -> MyResult.classNameOrGlobalStatic;
    }

    private static List<PsiClass> getTypeBounds(PsiTypeElement typeElement) {
        PsiElement typeParent = typeElement.getParent();
        if (typeParent instanceof PsiReferenceParameterList) {
            PsiTypeParameter[] typeParameters;
            PsiElement target;
            int index = Arrays.asList(((PsiReferenceParameterList)typeParent).getTypeParameterElements()).indexOf(typeElement);
            PsiElement listParent = typeParent.getParent();
            if (index >= 0 && listParent instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)listParent).resolve()) instanceof PsiClass && index < (typeParameters = ((PsiClass)target).getTypeParameters()).length) {
                return ContainerUtil.mapNotNull((Object[])typeParameters[index].getExtendsListTypes(), PsiUtil::resolveClassInType);
            }
        }
        return Collections.emptyList();
    }

    static boolean isExceptionPosition(PsiElement position) {
        return IN_CATCH_TYPE.accepts((Object)position) || IN_MULTI_CATCH_TYPE.accepts((Object)position) || INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)position) || JavaDocCompletionContributor.THROWS_TAG_EXCEPTION.accepts((Object)position);
    }

    @NotNull
    private static MyResult preferClassIf(boolean condition2) {
        return condition2 ? MyResult.suitableClass : MyResult.classNameOrGlobalStatic;
    }

    @NotNull
    public MyResult weigh(@NotNull LookupElement item) {
        PsiClass containingClass;
        Object object = item.getObject();
        if (object instanceof PsiKeyword) {
            ThreeState result = this.isProbableKeyword(((PsiKeyword)object).getText());
            if (result == ThreeState.YES) {
                return MyResult.probableKeyword;
            }
            if (result == ThreeState.NO) {
                return MyResult.improbableKeyword;
            }
        }
        if (item.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null) {
            return MyResult.castVariable;
        }
        if ((object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression || object instanceof PsiField && !((PsiField)object).hasModifierProperty("static")) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiDocComment.class) == null) {
            return this.isExpectedTypeItem(item) ? MyResult.expectedTypeVariable : MyResult.variable;
        }
        if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
            return MyResult.superMethodParameters;
        }
        if (item.getUserData(FunctionalExpressionCompletionProvider.LAMBDA_ITEM) != null) {
            return MyResult.lambda;
        }
        if (item.getUserData(FunctionalExpressionCompletionProvider.METHOD_REF_ITEM) != null) {
            return MyResult.methodRef;
        }
        if (object instanceof PsiMethod && (containingClass = ((PsiMethod)object).getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
            return MyResult.collectionFactory;
        }
        if (object instanceof PsiClass && "java.lang.String".equals(((PsiClass)object).getQualifiedName()) && JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)this.myPosition)) {
            return MyResult.unlikelyClass;
        }
        Boolean expectedTypeMember = (Boolean)item.getUserData(MembersGetter.EXPECTED_TYPE_MEMBER);
        if (expectedTypeMember != null) {
            return expectedTypeMember.booleanValue() ? (object instanceof PsiField ? MyResult.expectedTypeConstant : MyResult.expectedTypeMethod) : MyResult.classNameOrGlobalStatic;
        }
        if (item instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
            return MyResult.expectedTypeArgument;
        }
        JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
        if (chain != null) {
            Object qualifier = chain.getQualifier().getObject();
            if (qualifier instanceof PsiLocalVariable || qualifier instanceof PsiParameter) {
                return MyResult.variable;
            }
            if (qualifier instanceof PsiField) {
                return MyResult.qualifiedWithField;
            }
            if (PreferByKindWeigher.isGetter(qualifier)) {
                return MyResult.qualifiedWithGetter;
            }
            if (chain.getQualifier().getUserData(INTRODUCED_VARIABLE) == Boolean.TRUE) {
                return MyResult.introducedVariable;
            }
            if (this.myCompletionType == CompletionType.SMART && qualifier instanceof PsiMethod && PreferByKindWeigher.isGetter(object)) {
                return MyResult.getterQualifiedByMethod;
            }
        }
        if (this.myCompletionType == CompletionType.SMART) {
            if (PreferByKindWeigher.isGetter(object)) {
                return chain == null && this.isAccessibleFieldGetter(object) ? MyResult.accessibleFieldGetter : MyResult.getter;
            }
            return MyResult.normal;
        }
        if (this.myCompletionType == CompletionType.BASIC) {
            StaticallyImportable callElement = (StaticallyImportable)item.as(StaticallyImportable.CLASS_CONDITION_KEY);
            if (callElement != null && callElement.canBeImported() && !callElement.willBeImported()) {
                return MyResult.classNameOrGlobalStatic;
            }
            if (object instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)object))) {
                return MyResult.annoMethod;
            }
            if (object instanceof PsiClass) {
                return this.myClassSuitability.apply((PsiClass)object);
            }
            if (object instanceof PsiField && this.myNonInitializedFields.contains(object)) {
                return MyResult.nonInitialized;
            }
        }
        return MyResult.normal;
    }

    private boolean isExpectedTypeItem(@NotNull LookupElement item) {
        TypedLookupItem typed = (TypedLookupItem)item.as(TypedLookupItem.CLASS_CONDITION_KEY);
        PsiType itemType = typed == null ? null : typed.getType();
        return itemType != null && Arrays.stream(this.myExpectedTypes).map(ExpectedTypeInfo::getType).anyMatch(type2 -> !PreferByKindWeigher.isTooGeneric(type2) && type2.isAssignableFrom(itemType));
    }

    private static boolean isTooGeneric(PsiType type2) {
        PsiType erasure = TypeConversionUtil.erasure((PsiType)type2);
        return erasure == null || erasure.equalsToText("java.lang.Object");
    }

    @NotNull
    private ThreeState isProbableKeyword(String keyword) {
        PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class);
        if ("return".equals(keyword) && this.isLastStatement(parentStatement) && !PreferByKindWeigher.isOnTopLevelInVoidMethod(parentStatement)) {
            return ThreeState.YES;
        }
        if (("break".equals(keyword) || "continue".equals(keyword)) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiLoopStatement.class) != null && this.isLastStatement(parentStatement)) {
            return ThreeState.YES;
        }
        if ("else".equals(keyword) || "finally".equals(keyword) || "catch".equals(keyword)) {
            return ThreeState.YES;
        }
        if ("true".equals(keyword) || "false".equals(keyword)) {
            if (this.myCompletionType == CompletionType.SMART) {
                boolean inReturn = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiReturnStatement.class})).accepts((Object)this.myPosition);
                return inReturn ? ThreeState.YES : ThreeState.UNSURE;
            }
            if (Arrays.stream(this.myExpectedTypes).anyMatch(info -> PsiType.BOOLEAN.isAssignableFrom(info.getDefaultType())) && !(this.myPosition.getParent() instanceof PsiIfStatement)) {
                return ThreeState.YES;
            }
        }
        if ("interface".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)this.myPosition)) {
            return ThreeState.NO;
        }
        if ("null".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE})))).accepts((Object)this.myPosition)) {
            return ThreeState.YES;
        }
        if (JavaKeywordCompletion.PRIMITIVE_TYPES.contains(keyword) || "void".equals(keyword)) {
            boolean inCallArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionList.class})).accepts((Object)this.myPosition);
            return inCallArg || PreferByKindWeigher.isInMethodTypeArg(this.myPosition) ? ThreeState.NO : ThreeState.UNSURE;
        }
        if ("final".equals(keyword) && this.isBeforeVariableOnSameLine(parentStatement)) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }

    private boolean isBeforeVariableOnSameLine(@Nullable PsiStatement parentStatement) {
        return parentStatement != null && parentStatement.getTextRange().getStartOffset() == this.myPosition.getTextRange().getStartOffset() && JBIterable.generate((Object)parentStatement, PsiElement::getNextSibling).takeWhile(e -> !e.textContains('\n')).skip(1).filter(PsiStatement.class).isNotEmpty();
    }

    private boolean isAccessibleFieldGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiField field = PropertyUtil.getFieldOfGetter((PsiMethod)object);
        return field != null && PsiResolveHelper.SERVICE.getInstance((Project)this.myPosition.getProject()).isAccessible((PsiMember)field, this.myPosition, null);
    }

    static boolean isInMethodTypeArg(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position);
    }

    private static boolean isOnTopLevelInVoidMethod(@NotNull PsiStatement statement) {
        if (!(statement.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        PsiElement parent = statement.getParent().getParent();
        if (parent instanceof PsiMethod) {
            return ((PsiMethod)parent).isConstructor() || PsiType.VOID.equals((Object)((PsiMethod)parent).getReturnType());
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            return method != null && PsiType.VOID.equals((Object)method.getReturnType());
        }
        return false;
    }

    private static boolean isGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)object;
        if (!PropertyUtilBase.hasGetterName((PsiMethod)method)) {
            return false;
        }
        if (method.hasTypeParameters()) {
            return false;
        }
        return !KnownElementWeigher.isGetClass(method);
    }

    private boolean isLastStatement(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (!(statement.getParent() instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)statement.getParent();
        PsiStatement[] siblings2 = codeBlock.getStatements();
        PsiStatement lastOne = siblings2[siblings2.length - 1];
        if (statement == lastOne) {
            return true;
        }
        int posEnd = this.myPosition.getTextRange().getEndOffset();
        int blockContentEnd = lastOne.getTextRange().getEndOffset();
        CharSequence fileText = this.myPosition.getContainingFile().getViewProvider().getContents();
        String afterPos = fileText.subSequence(posEnd, blockContentEnd).toString();
        int nonSpace = CharArrayUtil.shiftForward((CharSequence)afterPos, (int)0, (String)" \t");
        if (nonSpace < afterPos.length() && afterPos.charAt(nonSpace) == '\n') {
            return false;
        }
        try {
            PsiStatement asStatement = JavaPsiFacade.getElementFactory((Project)this.myPosition.getProject()).createStatementFromText(afterPos.trim(), null);
            return asStatement instanceof PsiExpressionStatement;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    static enum MyResult {
        annoMethod,
        probableKeyword,
        castVariable,
        expectedTypeVariable,
        lambda,
        methodRef,
        variable,
        getter,
        qualifiedWithField,
        qualifiedWithGetter,
        superMethodParameters,
        expectedTypeConstant,
        expectedTypeArgument,
        getterQualifiedByMethod,
        accessibleFieldGetter,
        normal,
        collectionFactory,
        expectedTypeMethod,
        verySuitableClass,
        suitableClass,
        nonInitialized,
        classNameOrGlobalStatic,
        introducedVariable,
        unlikelyClass,
        improbableKeyword;

    }
}

