/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.element.ExcludeSillyAssignment;
import com.intellij.psi.impl.search.MethodDeepestSuperSearcher;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecursionWeigher
extends LookupElementWeigher {
    private final ElementFilter myFilter;
    private final PsiElement myPosition;
    private final PsiReferenceExpression myReference;
    @Nullable
    private final PsiMethodCallExpression myExpression;
    private final PsiMethod myPositionMethod;
    private final ExpectedTypeInfo[] myExpectedInfos;
    private final PsiExpression myCallQualifier;
    private final PsiExpression myPositionQualifier;
    private final boolean myDelegate;
    private final CompletionType myCompletionType;

    RecursionWeigher(PsiElement position, CompletionType completionType, @NotNull PsiReferenceExpression reference, @Nullable PsiMethodCallExpression expression2, ExpectedTypeInfo[] expectedInfos) {
        super("recursion");
        this.myCompletionType = completionType;
        this.myFilter = RecursionWeigher.recursionFilter(position);
        this.myPosition = position;
        this.myReference = reference;
        this.myExpression = expression2;
        this.myPositionMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class, (boolean)false);
        this.myExpectedInfos = expectedInfos;
        this.myCallQualifier = RecursionWeigher.normalizeQualifier((PsiElement)this.myReference.getQualifierExpression());
        this.myPositionQualifier = RecursionWeigher.normalizeQualifier(position.getParent() instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier() : null);
        this.myDelegate = this.isDelegatingCall();
    }

    @Nullable
    private static PsiExpression normalizeQualifier(@Nullable PsiElement qualifier) {
        return qualifier instanceof PsiThisExpression || !(qualifier instanceof PsiExpression) ? null : (PsiExpression)qualifier;
    }

    private boolean isDelegatingCall() {
        if (this.myCallQualifier != null && this.myPositionQualifier != null && this.myCallQualifier != this.myPositionQualifier && JavaPsiEquivalenceUtil.areExpressionsEquivalent(this.myCallQualifier, this.myPositionQualifier)) {
            return false;
        }
        return this.myCallQualifier != null || this.myPositionQualifier != null;
    }

    @Nullable
    static ElementFilter recursionFilter(PsiElement element) {
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"return"})).inside(PsiReturnStatement.class)).accepts((Object)element)) {
            return new ExcludeDeclaredFilter(ElementClassFilter.METHOD);
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAssignmentExpression.class), PsiJavaPatterns.psiElement(PsiVariable.class)}))).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)element)) {
            return new AndFilter((ElementFilter)new ExcludeSillyAssignment(), (ElementFilter)new ExcludeDeclaredFilter((ElementFilter)new ClassFilter(PsiVariable.class)));
        }
        return null;
    }

    @NotNull
    public Result weigh(@NotNull LookupElement element) {
        PsiType itemType;
        Object object = element.getObject();
        if (!(object instanceof PsiMethod || object instanceof PsiVariable || object instanceof PsiExpression)) {
            return Result.normal;
        }
        if (this.myFilter != null && !this.myFilter.isAcceptable(object, this.myPosition)) {
            return Result.recursive;
        }
        if (this.isPassingObjectToItself(object) && this.myCompletionType == CompletionType.SMART) {
            return Result.passingObjectToItself;
        }
        if (this.myExpectedInfos != null && (itemType = JavaCompletionUtil.getLookupElementType(element)) != null) {
            boolean hasRecursiveInvocations = false;
            boolean hasOtherInvocations = false;
            for (ExpectedTypeInfo expectedInfo : this.myExpectedInfos) {
                PsiMethod calledMethod = expectedInfo.getCalledMethod();
                if (!expectedInfo.getType().isAssignableFrom(itemType)) continue;
                if (calledMethod != null && calledMethod.equals(this.myPositionMethod) || this.isGetterSetterAssignment(object, calledMethod)) {
                    hasRecursiveInvocations = true;
                    continue;
                }
                if (calledMethod == null) continue;
                hasOtherInvocations = true;
            }
            if (hasRecursiveInvocations && !hasOtherInvocations) {
                return this.myDelegate ? Result.delegation : Result.recursive;
            }
        }
        if (this.myExpression != null) {
            return Result.normal;
        }
        if (object instanceof PsiMethod && this.myPositionMethod != null) {
            PsiMethod method = (PsiMethod)object;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myReference, (PsiElement)this.myPosition, (boolean)false) && Comparing.equal((String)method.getName(), (String)this.myPositionMethod.getName())) {
                if (!this.myDelegate && RecursionWeigher.findDeepestSuper(method).equals(RecursionWeigher.findDeepestSuper(this.myPositionMethod))) {
                    return Result.recursive;
                }
                return Result.delegation;
            }
        }
        return Result.normal;
    }

    @Nullable
    private String getSetterPropertyName(@Nullable PsiMethod calledMethod) {
        PsiElement target;
        if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)calledMethod)) {
            assert (calledMethod != null);
            return PropertyUtilBase.getPropertyName((PsiMethod)calledMethod);
        }
        PsiReferenceExpression reference = ExcludeSillyAssignment.getAssignedReference(this.myPosition);
        if (reference != null && (target = reference.resolve()) instanceof PsiField) {
            return PropertyUtilBase.suggestPropertyName((PsiField)((PsiField)target));
        }
        return null;
    }

    private boolean isGetterSetterAssignment(Object lookupObject, @Nullable PsiMethod calledMethod) {
        String prop = this.getSetterPropertyName(calledMethod);
        if (prop == null) {
            return false;
        }
        if (lookupObject instanceof PsiField && prop.equals(PropertyUtilBase.suggestPropertyName((PsiField)((PsiField)lookupObject)))) {
            return true;
        }
        return lookupObject instanceof PsiMethod && PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)lookupObject)) && prop.equals(PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)lookupObject)));
    }

    private boolean isPassingObjectToItself(Object object) {
        if (object instanceof PsiThisExpression) {
            return this.myCallQualifier != null && !this.myDelegate || this.myCallQualifier instanceof PsiSuperExpression;
        }
        return this.myCallQualifier instanceof PsiReferenceExpression && object.equals(((PsiReferenceExpression)this.myCallQualifier).advancedResolve(true).getElement());
    }

    @NotNull
    public static PsiMethod findDeepestSuper(@NotNull PsiMethod method) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        MethodDeepestSuperSearcher.processDeepestSuperMethods(method, (Processor<? super PsiMethod>)processor);
        PsiMethod first = (PsiMethod)processor.getFoundValue();
        return first == null ? method : first;
    }

    private static enum Result {
        delegation,
        normal,
        passingObjectToItself,
        recursive;

    }
}

