/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartCompletionDecorator
extends TailTypeDecorator<LookupElement> {
    @NotNull
    private final Collection<? extends ExpectedTypeInfo> myExpectedTypeInfos;
    private PsiElement myPosition;

    public SmartCompletionDecorator(LookupElement item, @NotNull Collection<? extends ExpectedTypeInfo> expectedTypeInfos) {
        super(item);
        this.myExpectedTypeInfos = expectedTypeInfos;
    }

    protected TailType computeTailType(InsertionContext context) {
        if (context.getCompletionChar() == '\r') {
            return TailType.NONE;
        }
        if (LookupItem.getDefaultTailType((char)context.getCompletionChar()) != null) {
            return null;
        }
        LookupElement delegate = this.getDelegate();
        LookupItem item = (LookupItem)this.as(LookupItem.CLASS_CONDITION_KEY);
        Object object = delegate.getObject();
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && (object instanceof PsiMethod || object instanceof PsiClass)) {
            return TailType.NONE;
        }
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)this.myPosition, PsiExpression.class, (boolean)true);
        if (enclosing != null) {
            TailType itemType;
            PsiType type2 = JavaCompletionUtil.getLookupElementType(delegate);
            TailType tailType = itemType = item != null ? item.getTailType() : TailType.NONE;
            if (type2 != null && type2.isValid()) {
                HashSet<TailType> voidTyped = new HashSet<TailType>();
                HashSet<TailType> sameTyped = new HashSet<TailType>();
                HashSet<TailType> assignableTyped = new HashSet<TailType>();
                for (ExpectedTypeInfo expectedTypeInfo : this.myExpectedTypeInfos) {
                    PsiType infoType = expectedTypeInfo.getType();
                    PsiType originalInfoType = JavaCompletionUtil.originalize(infoType);
                    if (PsiType.VOID.equals((Object)infoType)) {
                        voidTyped.add(expectedTypeInfo.getTailType());
                        continue;
                    }
                    if (infoType.equals(type2) || originalInfoType.equals(type2)) {
                        sameTyped.add(expectedTypeInfo.getTailType());
                        continue;
                    }
                    if ((expectedTypeInfo.getKind() != 1 || !infoType.isAssignableFrom(type2) && !originalInfoType.isAssignableFrom(type2)) && (expectedTypeInfo.getKind() != 2 || !type2.isAssignableFrom(infoType) && !type2.isAssignableFrom(originalInfoType))) continue;
                    assignableTyped.add(expectedTypeInfo.getTailType());
                }
                if (!sameTyped.isEmpty()) {
                    return sameTyped.size() == 1 ? (TailType)sameTyped.iterator().next() : itemType;
                }
                if (!assignableTyped.isEmpty()) {
                    return assignableTyped.size() == 1 ? (TailType)assignableTyped.iterator().next() : itemType;
                }
                if (!voidTyped.isEmpty()) {
                    return voidTyped.size() == 1 ? (TailType)voidTyped.iterator().next() : itemType;
                }
            } else if (this.myExpectedTypeInfos.size() == 1) {
                return this.myExpectedTypeInfos.iterator().next().getTailType();
            }
            return itemType;
        }
        return null;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (this.getObject() instanceof PsiVariable && context.getCompletionChar() == '\t') {
            context.commitDocument();
            SmartCompletionDecorator.replaceMethodCallIfNeeded(context);
        }
        context.commitDocument();
        this.myPosition = SmartCompletionDecorator.getPosition(context, (LookupElement)this);
        TailType tailType = this.computeTailType(context);
        super.handleInsert(context);
        if (tailType == TailType.COMMA) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    private static void replaceMethodCallIfNeeded(InsertionContext context) {
        PsiFile file = context.getFile();
        PsiElement element = file.findElementAt(context.getTailOffset());
        if (element instanceof PsiWhiteSpace && (!element.textContains('\n') || CodeStyle.getLanguageSettings((PsiFile)file, (Language)JavaLanguage.INSTANCE).METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE)) {
            element = file.findElementAt(element.getTextRange().getEndOffset());
        }
        if (element != null && PsiUtilCore.getElementType((PsiElement)element) == JavaTokenType.LPARENTH && element.getParent() instanceof PsiExpressionList) {
            context.getDocument().deleteString(context.getTailOffset(), element.getParent().getTextRange().getEndOffset());
        }
    }

    public static boolean hasUnboundTypeParams(PsiMethod method, PsiType expectedType) {
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length == 0) {
            return false;
        }
        THashSet set = new THashSet(Arrays.asList(typeParameters));
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            if (!PsiPolyExpressionUtil.mentionsTypeParameters((PsiType)parameter2.getType(), (Set)set).booleanValue()) continue;
            return false;
        }
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, expectedType);
        for (PsiTypeParameter parameter3 : typeParameters) {
            if (TypeConversionUtil.typeParameterErasure((PsiTypeParameter)parameter3).equals(substitutor.substitute(parameter3))) continue;
            return true;
        }
        return false;
    }

    public static PsiSubstitutor calculateMethodReturnTypeSubstitutor(@NotNull PsiMethod method, @NotNull PsiType expected) {
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return PsiSubstitutor.EMPTY;
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
        return helper.inferTypeArguments(method.getTypeParameters(), new PsiType[]{expected}, new PsiType[]{returnType}, LanguageLevel.HIGHEST);
    }

    @Nullable
    public static PsiElement getPosition(InsertionContext context, LookupElement element) {
        PsiElement position = context.getFile().findElementAt(context.getStartOffset() + element.getLookupString().length() - 1);
        if (position instanceof PsiJavaToken && ">".equals(position.getText())) {
            return position.getParent().getParent();
        }
        return position;
    }
}

