/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.proc;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VariablesProcessor
implements PsiScopeProcessor,
ElementClassHint {
    private final String myPrefix;
    private boolean myStaticScopeFlag;
    private final boolean myStaticSensitiveFlag;
    private final List<? super PsiVariable> myResultList;

    public VariablesProcessor(String _prefix, boolean staticSensitiveFlag) {
        this(_prefix, staticSensitiveFlag, new ArrayList());
    }

    public VariablesProcessor(String _prefix, boolean staticSensitiveFlag, List<? super PsiVariable> lst) {
        this.myPrefix = _prefix;
        this.myStaticSensitiveFlag = staticSensitiveFlag;
        this.myResultList = lst;
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
        return kind2 == ElementClassHint.DeclarationKind.VARIABLE || kind2 == ElementClassHint.DeclarationKind.FIELD || kind2 == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
        PsiVariable pvar;
        String pvar_name;
        if (pe instanceof PsiVariable && (pvar_name = (pvar = (PsiVariable)pe).getName()).startsWith(this.myPrefix) && (!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static"))) {
            this.myResultList.add((PsiVariable)pvar);
        }
        return true;
    }

    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public PsiVariable[] getResultsAsArray() {
        PsiVariable[] ret = new PsiVariable[this.myResultList.size()];
        this.myResultList.toArray(ret);
        return ret;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return null;
    }
}

