/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GutterTooltipHelper {
    private static final JBColor SEPARATOR_COLOR = JBColor.namedColor((String)"GutterTooltip.lineSeparatorColor", (Color)HintUtil.INFORMATION_BORDER_COLOR);
    private static final JBColor CONTEXT_HELP_FOREGROUND = JBColor.namedColor((String)"GutterTooltip.infoForeground", (Color)new JBColor(0x787878, 0x878787));

    private GutterTooltipHelper() {
    }

    @NotNull
    public static <E extends PsiElement> String getTooltipText(@NotNull Collection<E> elements, @NotNull String prefix, boolean skipFirstMember, @Nullable String actionId) {
        String firstDivider = GutterTooltipHelper.getElementDivider(true, true, elements.size());
        String nextDivider = GutterTooltipHelper.getElementDivider(false, true, elements.size());
        AtomicReference<String> reference = new AtomicReference<String>(firstDivider);
        return GutterTooltipHelper.getTooltipText(prefix, elements, e -> reference.getAndSet(nextDivider), e -> skipFirstMember, actionId);
    }

    static String getElementDivider(boolean firstElement, boolean marginLeft, int elementsCount) {
        if (elementsCount <= 1) {
            return " ";
        }
        StringBuilder sb = new StringBuilder("</p><p style='margin-top:2pt");
        if (marginLeft) {
            sb.append(";margin-left:20pt");
        }
        if (!firstElement) {
            sb.append(";border-top:thin solid #").append(ColorUtil.toHex((Color)SEPARATOR_COLOR));
        }
        return sb.append(";'>").toString();
    }

    @NotNull
    public static <E extends PsiElement> String getTooltipText(@NotNull Collection<E> elements, @NotNull Function<E, String> elementToPrefix, @NotNull Predicate<E> skipFirstMemberOfElement, @Nullable String actionId) {
        return GutterTooltipHelper.getTooltipText(null, elements, elementToPrefix, skipFirstMemberOfElement, actionId);
    }

    @NotNull
    private static <E extends PsiElement> String getTooltipText(@Nullable String prefix, @NotNull Collection<E> elements, @NotNull Function<E, String> elementToPrefix, @NotNull Predicate<E> skipFirstMemberOfElement, @Nullable String actionId) {
        StringBuilder sb = new StringBuilder("<html><body><p>");
        if (prefix != null) {
            sb.append(prefix);
        }
        for (PsiElement element : elements) {
            String elementPrefix = elementToPrefix.apply(element);
            if (elementPrefix != null) {
                sb.append(elementPrefix);
            }
            GutterTooltipHelper.appendElement(sb, element, skipFirstMemberOfElement.test(element));
        }
        GutterTooltipHelper.appendContextHelp(sb, actionId);
        sb.append("</p></body></html>");
        return sb.toString();
    }

    private static void appendElement(@NotNull StringBuilder sb, @NotNull PsiElement element, boolean skip) {
        boolean useSingleLink = Registry.is((String)"gutter.tooltip.single.link");
        String packageName = null;
        boolean addedSingleLink = useSingleLink && GutterTooltipHelper.appendLink(sb, element);
        PsiElement original = element;
        if (skip && (element instanceof PsiMethod || element instanceof PsiField)) {
            element = GutterTooltipHelper.getContainingElement(element);
        }
        while (element != null) {
            String name = GutterTooltipHelper.getPresentableName(element);
            if (name != null) {
                boolean addedLink = !useSingleLink && GutterTooltipHelper.appendLink(sb, original != null ? original : element);
                original = null;
                sb.append(name);
                if (addedLink) {
                    sb.append("</code></a>");
                }
            }
            if (element instanceof PsiFile) break;
            PsiElement parent = GutterTooltipHelper.getContainingElement(element);
            if ((parent == null || parent instanceof PsiFile) && element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                String qualifiedName = ((PsiClass)element).getQualifiedName();
                if (qualifiedName == null) break;
                packageName = StringUtil.getPackageName((String)qualifiedName);
                break;
            }
            if (name != null && parent != null) {
                sb.append(" in ");
            }
            element = parent;
        }
        if (addedSingleLink) {
            sb.append("</code></a>");
        }
        GutterTooltipHelper.appendPackageName(sb, packageName);
    }

    private static void appendPackageName(@NotNull StringBuilder sb, @Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        sb.append(" <font color='#").append(ColorUtil.toHex((Color)CONTEXT_HELP_FOREGROUND));
        sb.append("'><code>(").append(name).append(")</code></font>");
    }

    private static void appendContextHelp(@NotNull StringBuilder sb, @Nullable String actionId) {
        if (actionId == null) {
            return;
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            return;
        }
        String text2 = KeymapUtil.getPreferredShortcutText((Shortcut[])action.getShortcutSet().getShortcuts());
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        sb.append("</p><p style='margin-top:8px;'><font size='2' color='#");
        sb.append(ColorUtil.toHex((Color)CONTEXT_HELP_FOREGROUND));
        sb.append("'>Press ").append(text2).append(" to navigate</font>");
    }

    private static boolean appendLink(@NotNull StringBuilder sb, @NotNull PsiElement element) {
        try {
            String name = GutterTooltipHelper.getQualifiedName(element);
            if (!StringUtil.isEmpty((String)name)) {
                sb.append("<a href=\"#element/").append(name).append("\"><code>");
                return true;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file == null) {
                return false;
            }
            int offset = element.getTextOffset();
            sb.append("<a href=\"#navigation/");
            sb.append(FileUtil.toSystemIndependentName((String)file.getPath()));
            sb.append(":").append(offset).append("\"><code>");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Nullable
    private static String getQualifiedName(@NotNull PsiElement element) {
        PsiClass psiClass;
        PsiClass psiClass2 = psiClass = element instanceof PsiClass ? (PsiClass)element : (PsiClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        return QualifiedNameProviderUtil.getQualifiedName((PsiElement)element);
    }

    @Nullable
    private static PsiElement getContainingElement(@NotNull PsiElement element) {
        PsiMember member = (PsiMember)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, PsiMember.class);
        if (member == null && element instanceof PsiMember) {
            member = ((PsiMember)element).getContainingClass();
        }
        return member != null ? member : element.getContainingFile();
    }

    @Nullable
    private static String getPresentableName(@NotNull PsiElement element) {
        if (element instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer initializer = (PsiEnumConstantInitializer)element;
            return initializer.getEnumConstant().getName();
        }
        if (element instanceof PsiAnonymousClass) {
            return "Anonymous";
        }
        if (element instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element;
            return named.getName();
        }
        return null;
    }
}

