/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveSuppressWarningAction
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction");
    @NotNull
    private final String myID;

    public RemoveSuppressWarningAction(@NotNull String id) {
        int idx = id.indexOf(";");
        this.myID = idx > -1 ? id.substring(0, idx) : id;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        try {
            if (element != null) {
                if (element instanceof PsiComment) {
                    this.removeFromComment((PsiComment)element);
                } else {
                    PsiModifierListOwner commentOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
                    if (commentOwner != null) {
                        PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                        if (psiElement instanceof PsiAnnotation) {
                            this.removeFromAnnotation((PsiAnnotation)psiElement, commentOwner);
                        } else if (psiElement instanceof PsiDocComment) {
                            this.removeFromJavaDoc((PsiDocComment)psiElement);
                        } else {
                            final HashSet comments = new HashSet();
                            commentOwner.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                                public void visitComment(PsiComment comment) {
                                    super.visitComment(comment);
                                    if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                        comments.add(comment);
                                    }
                                }
                            });
                            for (PsiComment comment : comments) {
                                try {
                                    this.removeFromComment(comment);
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getName() {
        return QuickFixBundle.message("remove.suppression.action.name", this.myID);
    }

    private void removeFromComment(PsiComment comment) throws IncorrectOperationException {
        String newText;
        String commentText = comment.getText();
        int secondCommentIdx = commentText.indexOf("//", 2);
        String suffix = "";
        if (secondCommentIdx > 0) {
            suffix = commentText.substring(secondCommentIdx);
        }
        if ((newText = this.removeFromElementText(new PsiElement[]{comment})) != null) {
            if (newText.isEmpty()) {
                if (suffix.isEmpty()) {
                    comment.delete();
                } else {
                    comment.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText(suffix, (PsiElement)comment));
                }
            } else {
                PsiComment newComment = JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText("// noinspection " + newText + suffix, (PsiElement)comment);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private void removeFromJavaDoc(PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag = docComment.findTagByName("noinspection");
        if (tag == null) {
            return;
        }
        String text2 = tag.getText();
        int i = text2.indexOf(this.myID);
        if (i < 0) {
            return;
        }
        String noInspectionText = StringUtil.trimEnd((String)text2.substring(0, i), (String)" ");
        String nextText = StringUtil.trimStart((String)text2.substring(i + this.myID.length()), (String)" ");
        String nextTagText = noInspectionText.endsWith(",") ? noInspectionText.substring(0, noInspectionText.length() - 1) + nextText : (nextText.startsWith(",") ? noInspectionText + nextText.substring(1) : null);
        if (nextTagText != null) {
            tag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)tag.getProject()).createDocTagFromText(nextTagText));
        } else {
            PsiElement[] descriptionElements = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createDocCommentFromText("/**" + nextText + "*/", (PsiElement)tag).getDescriptionElements();
            if (descriptionElements.length > 0) {
                docComment.addRangeAfter(descriptionElements[0], descriptionElements[descriptionElements.length - 1], (PsiElement)tag);
            }
            tag.delete();
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        List ids;
        int i;
        String text2 = "";
        for (PsiElement element : elements) {
            text2 = text2 + StringUtil.trimStart((String)element.getText(), (String)"//").trim();
        }
        int secondCommentIdx = (text2 = StringUtil.trimStart((String)text2, (String)"@").trim()).indexOf("//");
        if (secondCommentIdx > 0) {
            text2 = text2.substring(0, secondCommentIdx);
        }
        if ((i = ArrayUtil.find((Object[])(ids = StringUtil.split((String)(text2 = StringUtil.trimStart((String)text2, (String)"noinspection").trim()), (String)",")).toArray(), (Object)this.myID)) == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join((Collection)ids, (String)",");
    }

    private void removeFromAnnotation(PsiAnnotation annotation, PsiModifierListOwner owner) throws IncorrectOperationException {
        PsiNameValuePair[] attributes;
        for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers()) {
                    if (!this.removeFromValue(annotation, initializer, initializers.length == 1, owner)) continue;
                    return;
                }
            }
            assert (value2 != null);
            if (!this.removeFromValue(annotation, value2, attributes.length == 1, owner)) continue;
            return;
        }
    }

    private boolean removeFromValue(PsiAnnotation annotation, PsiAnnotationMemberValue value2, boolean removeParent, PsiModifierListOwner owner) throws IncorrectOperationException {
        String text2 = StringUtil.unquoteString((String)value2.getText());
        if (this.myID.equals(text2)) {
            if (removeParent) {
                if (annotation.isPhysical()) {
                    new CommentTracker().deleteAndRestoreComments((PsiElement)annotation);
                } else {
                    String qualifiedName = annotation.getQualifiedName();
                    assert (qualifiedName != null);
                    ExternalAnnotationsManager.getInstance((Project)annotation.getProject()).deannotate(owner, qualifiedName);
                }
            } else if (annotation.isPhysical()) {
                value2.delete();
            } else {
                PsiAnnotation annotationCopy = (PsiAnnotation)annotation.copy();
                PsiTreeUtil.processElements((PsiElement)annotationCopy, e -> {
                    if (e instanceof PsiAnnotationMemberValue && e.getText().equals(value2.getText())) {
                        e.delete();
                        return false;
                    }
                    return true;
                });
                PsiNameValuePair[] nameValuePairs = annotationCopy.getParameterList().getAttributes();
                String qualifiedName = annotation.getQualifiedName();
                assert (qualifiedName != null);
                ExternalAnnotationsManager.getInstance((Project)annotation.getProject()).editExternalAnnotation(owner, qualifiedName, nameValuePairs);
            }
            return true;
        }
        return false;
    }
}

