/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressByJavaCommentFix
extends SuppressByCommentFix {
    public SuppressByJavaCommentFix(@NotNull HighlightDisplayKey key2) {
        super(key2, PsiStatement.class);
    }

    public SuppressByJavaCommentFix(@NotNull String toolId) {
        super(toolId, PsiStatement.class);
    }

    @Nullable
    public PsiElement getContainer(PsiElement context) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class, (boolean)false);
        return statement != null && JavaLanguage.INSTANCE.equals(statement.getLanguage()) ? statement : null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        PsiElement declaredElement = this.getElementToAnnotate(element, container);
        if (declaredElement == null) {
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> this.suppressWithComment(project, element, container), (PsiFile[])new PsiFile[]{container.getContainingFile()});
        } else {
            JavaSuppressionUtil.addSuppressAnnotation(project, container, (PsiModifierListOwner)((PsiVariable)declaredElement), this.myID);
        }
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        if (this.getElementToAnnotate(container, container) != null) {
            return false;
        }
        return super.replaceSuppressionComments(container);
    }

    @Nullable
    protected PsiElement getElementToAnnotate(PsiElement element, PsiElement container) {
        return JavaSuppressionUtil.getElementToAnnotate(element, container);
    }

    protected void suppressWithComment(Project project, PsiElement element, PsiElement container) {
        super.createSuppression(project, element, container);
    }
}

